/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics;

import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.DoubleVector;
import JSci.physics.AbstractClassicalParticle;

public class Spring {
    private final double coefficient;
    private AbstractDoubleVector x;

    public Spring(double d) {
        this.coefficient = d;
    }

    public void setPosition(AbstractDoubleVector abstractDoubleVector) {
        this.x = abstractDoubleVector;
    }

    public AbstractDoubleVector getPosition() {
        return this.x;
    }

    public double energy(AbstractClassicalParticle abstractClassicalParticle) {
        double d = 0.0;
        AbstractDoubleVector abstractDoubleVector = abstractClassicalParticle.getPosition();
        for (int i = 0; i < this.x.dimension(); ++i) {
            double d2 = abstractDoubleVector.getComponent(i) - this.x.getComponent(i);
            d += d2 * d2;
        }
        return this.coefficient * d / 2.0;
    }

    public Force createForce(AbstractClassicalParticle abstractClassicalParticle) {
        return new Force(abstractClassicalParticle);
    }

    private class Force
    extends JSci.physics.Force {
        private final AbstractClassicalParticle p;

        public Force(AbstractClassicalParticle abstractClassicalParticle) {
            this.p = abstractClassicalParticle;
        }

        public AbstractDoubleVector getVector(double d) {
            AbstractDoubleVector abstractDoubleVector = this.p.getPosition();
            double[] dArray = new double[Spring.this.x.dimension()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = -Spring.this.coefficient * (abstractDoubleVector.getComponent(i) - Spring.this.x.getComponent(i));
            }
            return new DoubleVector(dArray);
        }
    }
}

