/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.vectors;

import JSci.GlobalSettings;
import JSci.maths.Mapping;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.DoubleSparseMatrix;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.DoubleVector;
import JSci.maths.vectors.MathVector;
import JSci.maths.vectors.VectorDimensionException;

public final class DoubleSparseVector
extends AbstractDoubleVector {
    private double[] vector;
    private int[] pos;

    public DoubleSparseVector(int n) {
        super(n);
        this.vector = new double[0];
        this.pos = new int[0];
    }

    public DoubleSparseVector(double[] dArray) {
        super(dArray.length);
        int n;
        int n2 = 0;
        for (n = 0; n < this.N; ++n) {
            if (dArray[n] == 0.0) continue;
            ++n2;
        }
        this.vector = new double[n2];
        this.pos = new int[n2];
        n2 = 0;
        for (n = 0; n < this.N; ++n) {
            if (dArray[n] == 0.0) continue;
            this.vector[n2] = dArray[n];
            this.pos[n2] = n;
            ++n2;
        }
    }

    public boolean equals(Object object, double d) {
        if (object != null && object instanceof DoubleSparseVector && this.N == ((DoubleSparseVector)object).N) {
            DoubleSparseVector doubleSparseVector = (DoubleSparseVector)object;
            if (this.pos.length != doubleSparseVector.pos.length) {
                return false;
            }
            double d2 = 0.0;
            for (int i = 0; i < this.pos.length; ++i) {
                if (this.pos[i] != doubleSparseVector.pos[i]) {
                    return false;
                }
                double d3 = this.vector[i] - doubleSparseVector.vector[i];
                d2 += d3 * d3;
            }
            return d2 <= d * d;
        }
        return false;
    }

    public double getComponent(int n) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
        }
        for (int i = 0; i < this.pos.length; ++i) {
            if (this.pos[i] != n) continue;
            return this.vector[i];
        }
        return 0.0;
    }

    public void setComponent(int n, double d) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
        }
        if (Math.abs(d) <= GlobalSettings.ZERO_TOL) {
            return;
        }
        for (int i = 0; i < this.pos.length; ++i) {
            if (n != this.pos[i]) continue;
            this.vector[i] = d;
            return;
        }
        int[] nArray = new int[this.pos.length + 1];
        double[] dArray = new double[this.vector.length + 1];
        System.arraycopy(this.pos, 0, nArray, 0, this.pos.length);
        System.arraycopy(this.vector, 0, dArray, 0, this.pos.length);
        nArray[this.pos.length] = n;
        dArray[this.vector.length] = d;
        this.pos = nArray;
        this.vector = dArray;
    }

    public double norm() {
        return Math.sqrt(this.sumSquares());
    }

    public double sumSquares() {
        double d = 0.0;
        for (int i = 0; i < this.pos.length; ++i) {
            d += this.vector[i] * this.vector[i];
        }
        return d;
    }

    public double mass() {
        double d = 0.0;
        for (int i = 0; i < this.pos.length; ++i) {
            d += this.vector[i];
        }
        return d;
    }

    public AbelianGroup.Member negate() {
        DoubleSparseVector doubleSparseVector = new DoubleSparseVector(this.N);
        doubleSparseVector.vector = new double[this.vector.length];
        doubleSparseVector.pos = new int[this.pos.length];
        System.arraycopy(this.pos, 0, doubleSparseVector.pos, 0, this.pos.length);
        for (int i = 0; i < this.pos.length; ++i) {
            doubleSparseVector.vector[i] = -this.vector[i];
        }
        return doubleSparseVector;
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleVector) {
            return this.add((AbstractDoubleVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector add(AbstractDoubleVector abstractDoubleVector) {
        int n;
        if (abstractDoubleVector instanceof DoubleSparseVector) {
            return this.add((DoubleSparseVector)abstractDoubleVector);
        }
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.add((DoubleVector)abstractDoubleVector);
        }
        if (this.N != abstractDoubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        dArray[0] = abstractDoubleVector.getComponent(0);
        for (n = 1; n < this.N; ++n) {
            dArray[n] = abstractDoubleVector.getComponent(n);
        }
        for (n = 0; n < this.pos.length; ++n) {
            int n2 = this.pos[n];
            dArray[n2] = dArray[n2] + this.vector[n];
        }
        return new DoubleVector(dArray);
    }

    public DoubleVector add(DoubleVector doubleVector) {
        if (this.N != doubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        System.arraycopy(doubleVector.vector, 0, dArray, 0, this.N);
        for (int i = 0; i < this.pos.length; ++i) {
            int n = this.pos[i];
            dArray[n] = dArray[n] + this.vector[i];
        }
        return new DoubleVector(dArray);
    }

    public DoubleSparseVector add(DoubleSparseVector doubleSparseVector) {
        int n;
        if (this.N != doubleSparseVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        for (n = 0; n < this.pos.length; ++n) {
            dArray[this.pos[n]] = this.vector[n] + doubleSparseVector.getComponent(this.pos[n]);
        }
        for (int i = 0; i < doubleSparseVector.pos.length; ++i) {
            n = doubleSparseVector.pos[i];
            dArray[n] = this.getComponent(n) + doubleSparseVector.vector[i];
        }
        return new DoubleSparseVector(dArray);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleVector) {
            return this.subtract((AbstractDoubleVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector subtract(AbstractDoubleVector abstractDoubleVector) {
        int n;
        if (abstractDoubleVector instanceof DoubleSparseVector) {
            return this.subtract((DoubleSparseVector)abstractDoubleVector);
        }
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.subtract((DoubleVector)abstractDoubleVector);
        }
        if (this.N != abstractDoubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        dArray[0] = -abstractDoubleVector.getComponent(0);
        for (n = 1; n < this.N; ++n) {
            dArray[n] = -abstractDoubleVector.getComponent(n);
        }
        for (n = 0; n < this.pos.length; ++n) {
            int n2 = this.pos[n];
            dArray[n2] = dArray[n2] + this.vector[n];
        }
        return new DoubleVector(dArray);
    }

    public DoubleVector subtract(DoubleVector doubleVector) {
        int n;
        if (this.N != doubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        dArray[0] = -doubleVector.vector[0];
        for (n = 1; n < this.N; ++n) {
            dArray[n] = -doubleVector.vector[n];
        }
        for (n = 0; n < this.pos.length; ++n) {
            int n2 = this.pos[n];
            dArray[n2] = dArray[n2] + this.vector[n];
        }
        return new DoubleVector(dArray);
    }

    public DoubleSparseVector subtract(DoubleSparseVector doubleSparseVector) {
        int n;
        if (this.N != doubleSparseVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        for (n = 0; n < this.pos.length; ++n) {
            dArray[this.pos[n]] = this.vector[n] - doubleSparseVector.getComponent(this.pos[n]);
        }
        for (int i = 0; i < doubleSparseVector.pos.length; ++i) {
            n = doubleSparseVector.pos[i];
            dArray[n] = this.getComponent(n) - doubleSparseVector.vector[i];
        }
        return new DoubleSparseVector(dArray);
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector scalarMultiply(double d) {
        DoubleSparseVector doubleSparseVector = new DoubleSparseVector(this.N);
        doubleSparseVector.vector = new double[this.vector.length];
        doubleSparseVector.pos = new int[this.pos.length];
        System.arraycopy(this.pos, 0, doubleSparseVector.pos, 0, this.pos.length);
        for (int i = 0; i < this.pos.length; ++i) {
            doubleSparseVector.vector[i] = d * this.vector[i];
        }
        return doubleSparseVector;
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector scalarDivide(double d) {
        DoubleSparseVector doubleSparseVector = new DoubleSparseVector(this.N);
        doubleSparseVector.vector = new double[this.vector.length];
        doubleSparseVector.pos = new int[this.pos.length];
        System.arraycopy(this.pos, 0, doubleSparseVector.pos, 0, this.pos.length);
        for (int i = 0; i < this.pos.length; ++i) {
            doubleSparseVector.vector[i] = this.vector[i] / d;
        }
        return doubleSparseVector;
    }

    public double scalarProduct(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector instanceof DoubleSparseVector) {
            return this.scalarProduct((DoubleSparseVector)abstractDoubleVector);
        }
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.scalarProduct((DoubleVector)abstractDoubleVector);
        }
        if (this.N != abstractDoubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double d = 0.0;
        for (int i = 0; i < this.pos.length; ++i) {
            d += this.vector[i] * abstractDoubleVector.getComponent(this.pos[i]);
        }
        return d;
    }

    public double scalarProduct(DoubleVector doubleVector) {
        if (this.N != doubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double d = 0.0;
        for (int i = 0; i < this.pos.length; ++i) {
            d += this.vector[i] * doubleVector.vector[this.pos[i]];
        }
        return d;
    }

    public double scalarProduct(DoubleSparseVector doubleSparseVector) {
        if (this.N != doubleSparseVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double d = 0.0;
        if (this.pos.length <= doubleSparseVector.pos.length) {
            for (int i = 0; i < this.pos.length; ++i) {
                d += this.vector[i] * doubleSparseVector.getComponent(this.pos[i]);
            }
        } else {
            for (int i = 0; i < doubleSparseVector.pos.length; ++i) {
                d += this.getComponent(doubleSparseVector.pos[i]) * doubleSparseVector.vector[i];
            }
        }
        return d;
    }

    public DoubleSparseMatrix tensorProduct(DoubleSparseVector doubleSparseVector) {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.N, doubleSparseVector.N);
        for (int i = 0; i < this.pos.length; ++i) {
            for (int j = 0; j < doubleSparseVector.pos.length; ++j) {
                doubleSparseMatrix.setElement(this.pos[i], doubleSparseVector.pos[j], this.vector[i] * doubleSparseVector.vector[j]);
            }
        }
        return doubleSparseMatrix;
    }

    public AbstractDoubleVector mapComponents(Mapping mapping) {
        double d = mapping.map(0.0);
        if (Math.abs(d) <= GlobalSettings.ZERO_TOL) {
            return this.sparseMap(mapping);
        }
        return this.generalMap(mapping, d);
    }

    private AbstractDoubleVector sparseMap(Mapping mapping) {
        DoubleSparseVector doubleSparseVector = new DoubleSparseVector(this.N);
        doubleSparseVector.vector = new double[this.vector.length];
        doubleSparseVector.pos = new int[this.pos.length];
        System.arraycopy(this.pos, 0, doubleSparseVector.pos, 0, this.pos.length);
        for (int i = 0; i < this.pos.length; ++i) {
            doubleSparseVector.vector[i] = mapping.map(this.vector[i]);
        }
        return doubleSparseVector;
    }

    private AbstractDoubleVector generalMap(Mapping mapping, double d) {
        int n;
        double[] dArray = new double[this.N];
        for (n = 0; n < this.N; ++n) {
            dArray[n] = d;
        }
        for (n = 0; n < this.pos.length; ++n) {
            dArray[n] = mapping.map(this.vector[this.pos[n]]);
        }
        return new DoubleVector(dArray);
    }
}

