/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.vectors;

import JSci.maths.Mapping;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.AbstractIntegerVector;
import JSci.maths.vectors.Complex3Vector;
import JSci.maths.vectors.Integer3Vector;
import JSci.maths.vectors.VectorDimensionException;

public final class Double3Vector
extends AbstractDoubleVector {
    protected double x;
    protected double y;
    protected double z;

    public Double3Vector() {
        super(3);
    }

    public Double3Vector(double d, double d2, double d3) {
        this();
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Double3Vector(double[] dArray) {
        this();
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public boolean equals(Object object, double d) {
        if (object != null && object instanceof Double3Vector) {
            Double3Vector double3Vector = (Double3Vector)object;
            double d2 = this.x - double3Vector.x;
            double d3 = this.y - double3Vector.y;
            double d4 = this.z - double3Vector.z;
            return d2 * d2 + d3 * d3 + d4 * d4 <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(15);
        stringBuffer.append(this.x).append(',').append(this.y).append(',').append(this.z);
        return stringBuffer.toString();
    }

    public AbstractIntegerVector toIntegerVector() {
        return new Integer3Vector(Math.round((float)this.x), Math.round((float)this.y), Math.round((float)this.z));
    }

    public AbstractComplexVector toComplexVector() {
        return new Complex3Vector(this.x, 0.0, this.y, 0.0, this.z, 0.0);
    }

    public double getComponent(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new VectorDimensionException("Invalid component.");
    }

    public void setComponent(int n, double d) {
        switch (n) {
            case 0: {
                this.x = d;
                break;
            }
            case 1: {
                this.y = d;
                break;
            }
            case 2: {
                this.z = d;
                break;
            }
            default: {
                throw new VectorDimensionException("Invalid component.");
            }
        }
    }

    public double norm(int n) {
        double d = Math.pow(Math.abs(this.x), n) + Math.pow(Math.abs(this.y), n) + Math.pow(Math.abs(this.z), n);
        return Math.pow(d, 1.0 / (double)n);
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double infNorm() {
        double d = 0.0;
        double d2 = Math.abs(this.x);
        if (d2 > d) {
            d = d2;
        }
        if ((d2 = Math.abs(this.y)) > d) {
            d = d2;
        }
        if ((d2 = Math.abs(this.z)) > d) {
            d = d2;
        }
        return d;
    }

    public AbelianGroup.Member negate() {
        return new Double3Vector(-this.x, -this.y, -this.z);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleVector) {
            return this.add((AbstractDoubleVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector add(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector.N == 3) {
            return new Double3Vector(this.x + abstractDoubleVector.getComponent(0), this.y + abstractDoubleVector.getComponent(1), this.z + abstractDoubleVector.getComponent(2));
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleVector) {
            return this.subtract((AbstractDoubleVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector subtract(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector.N == 3) {
            return new Double3Vector(this.x - abstractDoubleVector.getComponent(0), this.y - abstractDoubleVector.getComponent(1), this.z - abstractDoubleVector.getComponent(2));
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        if (member instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector scalarMultiply(double d) {
        return new Double3Vector(d * this.x, d * this.y, d * this.z);
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector scalarDivide(double d) {
        return new Double3Vector(this.x / d, this.y / d, this.z / d);
    }

    public double scalarProduct(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector.N == 3) {
            return this.x * abstractDoubleVector.getComponent(0) + this.y * abstractDoubleVector.getComponent(1) + this.z * abstractDoubleVector.getComponent(2);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Double3Vector multiply(Double3Vector double3Vector) {
        return new Double3Vector(this.y * double3Vector.z - double3Vector.y * this.z, this.z * double3Vector.x - double3Vector.z * this.x, this.x * double3Vector.y - double3Vector.x * this.y);
    }

    public AbstractDoubleVector mapComponents(Mapping mapping) {
        return new Double3Vector(mapping.map(this.x), mapping.map(this.y), mapping.map(this.z));
    }
}

