/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.vectors;

import JSci.GlobalSettings;
import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.algebras.HilbertSpace;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.MathVector;

public abstract class AbstractComplexVector
extends MathVector
implements HilbertSpace.Member {
    protected AbstractComplexVector(int n) {
        super(n);
    }

    public final boolean equals(Object object) {
        return this.equals(object, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(Object object, double d) {
        if (object != null && object instanceof AbstractComplexVector) {
            AbstractComplexVector abstractComplexVector = (AbstractComplexVector)object;
            return this.dimension() == abstractComplexVector.dimension() && this.subtract(abstractComplexVector).norm() <= d;
        }
        return false;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(12 * this.N);
        for (n = 0; n < this.N - 1; ++n) {
            stringBuffer.append(this.getComponent(n).toString());
            stringBuffer.append(',');
        }
        stringBuffer.append(this.getComponent(n).toString());
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public abstract AbstractDoubleVector real();

    public abstract AbstractDoubleVector imag();

    public abstract Complex getComponent(int var1);

    public abstract double getRealComponent(int var1);

    public abstract double getImagComponent(int var1);

    public abstract void setComponent(int var1, Complex var2);

    public abstract void setComponent(int var1, double var2, double var4);

    public Object getSet() {
        throw new RuntimeException("Not implemented: file bug");
    }

    public double norm() {
        double d = this.getRealComponent(0) * this.getRealComponent(0) + this.getImagComponent(0) * this.getImagComponent(0);
        for (int i = 1; i < this.N; ++i) {
            d += this.getRealComponent(i) * this.getRealComponent(i) + this.getImagComponent(i) * this.getImagComponent(i);
        }
        return Math.sqrt(d);
    }

    public double infNorm() {
        double d = this.getComponent(0).mod();
        for (int i = 1; i < this.N; ++i) {
            double d2 = this.getComponent(i).mod();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public abstract AbstractComplexVector conjugate();

    public abstract AbstractComplexVector add(AbstractComplexVector var1);

    public abstract AbstractComplexVector subtract(AbstractComplexVector var1);

    public abstract AbstractComplexVector scalarMultiply(Complex var1);

    public abstract AbstractComplexVector scalarMultiply(double var1);

    public abstract AbstractComplexVector scalarDivide(Complex var1);

    public abstract AbstractComplexVector scalarDivide(double var1);

    public AbstractComplexVector normalize() {
        return this.scalarDivide(this.norm());
    }

    public abstract Complex scalarProduct(AbstractComplexVector var1);

    public abstract AbstractComplexVector mapComponents(ComplexMapping var1);

    public abstract /* synthetic */ Complex scalarProduct(HilbertSpace.Member var1);

    public abstract /* synthetic */ VectorSpace.Member scalarDivide(Field.Member var1);
}

