/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.polynomials;

import JSci.GlobalSettings;
import JSci.maths.MathDouble;
import JSci.maths.analysis.RealFunction;
import JSci.maths.fields.Field;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.polynomials.Polynomial;
import JSci.maths.polynomials.PolynomialMath;
import JSci.maths.polynomials.RealPolynomialRing;

public class RealPolynomial
extends RealFunction
implements Polynomial {
    private double[] _coeff;

    public RealPolynomial(double[] dArray) {
        if (dArray == null) {
            throw new NullPointerException("Coefficients cannot be null");
        }
        this._coeff = RealPolynomial.normalise(dArray);
    }

    private static double[] normalise(double[] dArray) {
        int n;
        for (n = dArray.length - 1; n >= 0 && Math.abs(dArray[n]) <= GlobalSettings.ZERO_TOL; --n) {
        }
        if (n < 0) {
            return new double[]{0.0};
        }
        if (n < dArray.length - 1) {
            double[] dArray2 = new double[n + 1];
            System.arraycopy(dArray, 0, dArray2, 0, dArray2.length);
            return dArray2;
        }
        return dArray;
    }

    public RealPolynomial(Field.Member[] memberArray) {
        if (memberArray == null) {
            throw new NullPointerException("Coefficients cannot be null");
        }
        this._coeff = RealPolynomial.normalise(RealPolynomial.toDoubleArray(memberArray));
    }

    private static double[] toDoubleArray(Field.Member[] memberArray) {
        double[] dArray = new double[memberArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            if (!(memberArray[i] instanceof MathDouble)) {
                throw new IllegalArgumentException("Different fields. Argument was " + memberArray[i].getClass());
            }
            dArray[i] = ((MathDouble)memberArray[i]).value();
        }
        return dArray;
    }

    public Field.Member getCoefficient(int n) {
        return new MathDouble(this.getCoefficientAsDouble(n));
    }

    public double getCoefficientAsDouble(int n) {
        if (n >= this._coeff.length) {
            return 0.0;
        }
        return this._coeff[n];
    }

    public Field.Member[] getCoefficients() {
        return RealPolynomialRing.toMathDouble(this.getCoefficientsAsDoubles());
    }

    public double[] getCoefficientsAsDoubles() {
        return this._coeff;
    }

    public double map(double d) {
        return PolynomialMath.evalPolynomial(this, d);
    }

    public int degree() {
        return this._coeff.length - 1;
    }

    public Object getSet() {
        return RealPolynomialRing.getInstance();
    }

    public boolean isZero() {
        for (int i = 0; i < this._coeff.length; ++i) {
            if (!(Math.abs(this._coeff[i]) > GlobalSettings.ZERO_TOL)) continue;
            return false;
        }
        return true;
    }

    public boolean isOne() {
        if (Math.abs(this._coeff[0] - 1.0) > GlobalSettings.ZERO_TOL) {
            return false;
        }
        for (int i = 1; i < this._coeff.length; ++i) {
            if (!(Math.abs(this._coeff[i]) > GlobalSettings.ZERO_TOL)) continue;
            return false;
        }
        return true;
    }

    public RealFunction add(RealFunction realFunction) {
        if (realFunction instanceof RealPolynomial) {
            RealPolynomial realPolynomial = (RealPolynomial)realFunction;
            int n = PolynomialMath.maxDegree(this, realPolynomial);
            double[] dArray = new double[n + 1];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.getCoefficientAsDouble(i) + realPolynomial.getCoefficientAsDouble(i);
            }
            return new RealPolynomial(dArray);
        }
        return super.add(realFunction);
    }

    public RealFunction differentiate() {
        if (this.degree() == 0) {
            return (RealPolynomial)RealPolynomialRing.getInstance().zero();
        }
        double[] dArray = new double[this.degree()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.getCoefficientAsDouble(i + 1) * (double)(i + 1);
        }
        return new RealPolynomial(dArray);
    }

    public Polynomial scalarDivide(Field.Member member) {
        if (member instanceof Number) {
            double d = ((Number)((Object)member)).doubleValue();
            return this.scalarDivide(d);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealPolynomial scalarDivide(double d) {
        double[] dArray = new double[this._coeff.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this._coeff[i] / d;
        }
        return new RealPolynomial(dArray);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RealPolynomial) {
            RealPolynomial realPolynomial = (RealPolynomial)object;
            return ((RealPolynomial)this.subtract(realPolynomial)).isZero();
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this._coeff.length; ++i) {
            n += (int)(this._coeff[i] * 10.0);
        }
        return n;
    }

    public RealPolynomial integrate() {
        double[] dArray = new double[this._coeff.length + 1];
        for (int i = 1; i < dArray.length; ++i) {
            dArray[i] = this.getCoefficientAsDouble(i - 1) / (double)i;
        }
        return new RealPolynomial(dArray);
    }

    public Polynomial scalarMultiply(Field.Member member) {
        if (member instanceof Number) {
            double d = ((Number)((Object)member)).doubleValue();
            return this.scalarMultiply(d);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealPolynomial scalarMultiply(double d) {
        double[] dArray = new double[this._coeff.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this._coeff[i] * d;
        }
        return new RealPolynomial(dArray);
    }

    public RealFunction multiply(RealFunction realFunction) {
        if (realFunction instanceof RealPolynomial) {
            RealPolynomial realPolynomial = (RealPolynomial)realFunction;
            int n = PolynomialMath.maxDegree(this, realPolynomial);
            int n2 = PolynomialMath.minDegree(this, realPolynomial);
            int n3 = n + n2;
            double[] dArray = new double[n3 + 1];
            for (int i = 0; i < this._coeff.length; ++i) {
                for (int j = 0; j < realPolynomial._coeff.length; ++j) {
                    int n4 = i + j;
                    dArray[n4] = dArray[n4] + this._coeff[i] * realPolynomial._coeff[j];
                }
            }
            return new RealPolynomial(dArray);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbelianGroup.Member negate() {
        double[] dArray = new double[this._coeff.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = -this._coeff[i];
        }
        return new RealPolynomial(dArray);
    }

    public RealFunction subtract(RealFunction realFunction) {
        if (realFunction instanceof RealPolynomial) {
            RealPolynomial realPolynomial = (RealPolynomial)realFunction;
            int n = PolynomialMath.maxDegree(this, realPolynomial);
            double[] dArray = new double[n + 1];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.getCoefficientAsDouble(i) - realPolynomial.getCoefficientAsDouble(i);
            }
            return new RealPolynomial(dArray);
        }
        return super.subtract(realFunction);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("P(x) = ");
        if (this._coeff[this.degree()] < 0.0) {
            stringBuffer.append("-");
        } else {
            stringBuffer.append(" ");
        }
        for (int i = this.degree(); i > 0; --i) {
            stringBuffer.append(Math.abs(this._coeff[i])).append("x^").append(i).append(this._coeff[i - 1] >= 0.0 ? " + " : " - ");
        }
        stringBuffer.append(Math.abs(this._coeff[0]));
        return stringBuffer.toString();
    }
}

