/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.GlobalSettings;
import JSci.maths.ArrayMath;
import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.DimensionException;
import JSci.maths.LinearMath;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractComplexSquareMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.ComplexSquareMatrix;
import JSci.maths.matrices.DoubleTridiagonalMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;
import JSci.maths.matrices.TridiagonalMatrix;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.ComplexVector;

public class ComplexTridiagonalMatrix
extends AbstractComplexSquareMatrix
implements TridiagonalMatrix {
    protected final double[] ldiagRe;
    protected final double[] ldiagIm;
    protected final double[] diagRe;
    protected final double[] diagIm;
    protected final double[] udiagRe;
    protected final double[] udiagIm;

    public ComplexTridiagonalMatrix(int n) {
        super(n);
        this.ldiagRe = new double[n];
        this.ldiagIm = new double[n];
        this.diagRe = new double[n];
        this.diagIm = new double[n];
        this.udiagRe = new double[n];
        this.udiagIm = new double[n];
    }

    public ComplexTridiagonalMatrix(Complex[][] complexArray) {
        this(complexArray.length);
        int n;
        if (!ArrayMath.isSquare(complexArray)) {
            throw new MatrixDimensionException("Array is not square.");
        }
        this.diagRe[0] = complexArray[0][0].real();
        this.diagIm[0] = complexArray[0][0].imag();
        this.udiagRe[0] = complexArray[0][1].real();
        this.udiagIm[0] = complexArray[0][1].imag();
        for (n = 1; n < complexArray.length - 1; ++n) {
            this.ldiagRe[n] = complexArray[n][n - 1].real();
            this.ldiagIm[n] = complexArray[n][n - 1].imag();
            this.diagRe[n] = complexArray[n][n].real();
            this.diagIm[n] = complexArray[n][n].imag();
            this.udiagRe[n] = complexArray[n][n + 1].real();
            this.udiagIm[n] = complexArray[n][n + 1].imag();
        }
        this.ldiagRe[n] = complexArray[n][n - 1].real();
        this.ldiagIm[n] = complexArray[n][n - 1].imag();
        this.diagRe[n] = complexArray[n][n].real();
        this.diagIm[n] = complexArray[n][n].imag();
    }

    public boolean equals(AbstractComplexMatrix abstractComplexMatrix, double d) {
        if (abstractComplexMatrix instanceof TridiagonalMatrix) {
            double d2;
            double d3;
            int n;
            if (this.numRows != abstractComplexMatrix.rows() || this.numCols != abstractComplexMatrix.columns()) {
                return false;
            }
            double d4 = 0.0;
            double d5 = this.diagRe[0] - abstractComplexMatrix.getRealElement(0, 0);
            double d6 = this.diagIm[0] - abstractComplexMatrix.getImagElement(0, 0);
            double d7 = this.udiagRe[0] - abstractComplexMatrix.getRealElement(0, 1);
            double d8 = this.udiagIm[0] - abstractComplexMatrix.getImagElement(0, 1);
            d4 += d5 * d5 + d6 * d6 + d7 * d7 + d8 * d8;
            for (n = 1; n < this.numRows - 1; ++n) {
                d3 = this.ldiagRe[n] - abstractComplexMatrix.getRealElement(n, n - 1);
                d2 = this.ldiagIm[n] - abstractComplexMatrix.getImagElement(n, n - 1);
                d5 = this.diagRe[n] - abstractComplexMatrix.getRealElement(n, n);
                d6 = this.diagIm[n] - abstractComplexMatrix.getImagElement(n, n);
                d7 = this.udiagRe[n] - abstractComplexMatrix.getRealElement(n, n + 1);
                d8 = this.udiagIm[n] - abstractComplexMatrix.getImagElement(n, n + 1);
                d4 += d3 * d3 + d2 * d2 + d5 * d5 + d6 * d6 + d7 * d7 + d8 * d8;
            }
            d3 = this.ldiagRe[n] - abstractComplexMatrix.getRealElement(n, n - 1);
            return (d4 += d3 * d3 + (d2 = this.ldiagIm[n] - abstractComplexMatrix.getImagElement(n, n - 1)) * d2 + (d5 = this.diagRe[n] - abstractComplexMatrix.getRealElement(n, n)) * d5 + (d6 = this.diagIm[n] - abstractComplexMatrix.getImagElement(n, n)) * d6) <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.rows() * this.columns());
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                stringBuffer.append(this.getElement(i, j).toString());
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public AbstractDoubleMatrix real() {
        int n;
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.numRows);
        doubleTridiagonalMatrix.diag[0] = this.diagRe[0];
        doubleTridiagonalMatrix.udiag[0] = this.udiagRe[0];
        for (n = 1; n < this.numRows - 1; ++n) {
            doubleTridiagonalMatrix.ldiag[n] = this.ldiagRe[n];
            doubleTridiagonalMatrix.diag[n] = this.diagRe[n];
            doubleTridiagonalMatrix.udiag[n] = this.udiagRe[n];
        }
        doubleTridiagonalMatrix.ldiag[n] = this.ldiagRe[n];
        doubleTridiagonalMatrix.diag[n] = this.diagRe[n];
        return doubleTridiagonalMatrix;
    }

    public AbstractDoubleMatrix imag() {
        int n;
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.numRows);
        doubleTridiagonalMatrix.diag[0] = this.diagIm[0];
        doubleTridiagonalMatrix.udiag[0] = this.udiagIm[0];
        for (n = 1; n < this.numRows - 1; ++n) {
            doubleTridiagonalMatrix.ldiag[n] = this.ldiagIm[n];
            doubleTridiagonalMatrix.diag[n] = this.diagIm[n];
            doubleTridiagonalMatrix.udiag[n] = this.udiagIm[n];
        }
        doubleTridiagonalMatrix.ldiag[n] = this.ldiagIm[n];
        doubleTridiagonalMatrix.diag[n] = this.diagIm[n];
        return doubleTridiagonalMatrix;
    }

    public Complex getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n2 == n - 1) {
                return new Complex(this.ldiagRe[n], this.ldiagIm[n]);
            }
            if (n2 == n) {
                return new Complex(this.diagRe[n], this.diagIm[n]);
            }
            if (n2 == n + 1) {
                return new Complex(this.udiagRe[n], this.udiagIm[n]);
            }
            return Complex.ZERO;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public double getRealElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n2 == n - 1) {
                return this.ldiagRe[n];
            }
            if (n2 == n) {
                return this.diagRe[n];
            }
            if (n2 == n + 1) {
                return this.udiagRe[n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public double getImagElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n2 == n - 1) {
                return this.ldiagIm[n];
            }
            if (n2 == n) {
                return this.diagIm[n];
            }
            if (n2 == n + 1) {
                return this.udiagIm[n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(int n, int n2, Complex complex) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        if (n2 == n - 1) {
            this.ldiagRe[n] = complex.real();
            this.ldiagIm[n] = complex.imag();
            return;
        } else if (n2 == n) {
            this.diagRe[n] = complex.real();
            this.diagIm[n] = complex.imag();
            return;
        } else {
            if (n2 != n + 1) throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
            this.udiagRe[n] = complex.real();
            this.udiagIm[n] = complex.imag();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(int n, int n2, double d, double d2) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        if (n2 == n - 1) {
            this.ldiagRe[n] = d;
            this.ldiagIm[n] = d2;
            return;
        } else if (n2 == n) {
            this.diagRe[n] = d;
            this.diagIm[n] = d2;
            return;
        } else {
            if (n2 != n + 1) throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
            this.udiagRe[n] = d;
            this.udiagIm[n] = d2;
        }
    }

    public Complex trace() {
        double d = this.diagRe[0];
        double d2 = this.diagIm[0];
        for (int i = 1; i < this.numRows; ++i) {
            d += this.diagRe[i];
            d2 += this.diagIm[i];
        }
        return new Complex(d, d2);
    }

    public double infNorm() {
        double d;
        int n;
        double d2 = Math.sqrt(this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0]) + Math.sqrt(this.udiagRe[0] * this.udiagRe[0] + this.udiagIm[0] * this.udiagIm[0]);
        for (n = 1; n < this.numRows - 1; ++n) {
            d = Math.sqrt(this.ldiagRe[n] * this.ldiagRe[n] + this.ldiagIm[n] * this.ldiagIm[n]) + Math.sqrt(this.diagRe[n] * this.diagRe[n] + this.diagIm[n] * this.diagIm[n]) + Math.sqrt(this.udiagRe[n] * this.udiagRe[n] + this.udiagIm[n] * this.udiagIm[n]);
            if (!(d > d2)) continue;
            d2 = d;
        }
        d = Math.sqrt(this.ldiagRe[n] * this.ldiagRe[n] + this.ldiagIm[n] * this.ldiagIm[n]) + Math.sqrt(this.diagRe[n] * this.diagRe[n] + this.diagIm[n] * this.diagIm[n]);
        if (d > d2) {
            d2 = d;
        }
        return d2;
    }

    public double frobeniusNorm() {
        int n;
        double d = this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0] + this.udiagRe[0] * this.udiagRe[0] + this.udiagIm[0] * this.udiagIm[0];
        for (n = 1; n < this.numRows - 1; ++n) {
            d += this.ldiagRe[n] * this.ldiagRe[n] + this.ldiagIm[n] * this.ldiagIm[n] + this.diagRe[n] * this.diagRe[n] + this.diagIm[n] * this.diagIm[n] + this.udiagRe[n] * this.udiagRe[n] + this.udiagIm[n] * this.udiagIm[n];
        }
        return Math.sqrt(d += this.ldiagRe[n] * this.ldiagRe[n] + this.ldiagIm[n] * this.ldiagIm[n] + this.diagRe[n] * this.diagRe[n] + this.diagIm[n] * this.diagIm[n]);
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return Math.sqrt(ArrayMath.max(LinearMath.eigenvalueSolveHermitian((ComplexTridiagonalMatrix)this.hermitianAdjoint().multiply(this))));
    }

    public AbstractComplexSquareMatrix add(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.add((ComplexTridiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof TridiagonalMatrix) {
            return this.addTridiagonal(abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.add((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numRows == abstractComplexSquareMatrix.rows() && this.numCols == abstractComplexSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                Complex complex = this.getElement(i, 0).add(abstractComplexSquareMatrix.getElement(i, 0));
                dArray[i][0] = complex.real();
                dArray2[i][0] = complex.imag();
                for (int j = 1; j < this.numCols; ++j) {
                    complex = this.getElement(i, j).add(abstractComplexSquareMatrix.getElement(i, j));
                    dArray[i][j] = complex.real();
                    dArray2[i][j] = complex.imag();
                }
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numRows == complexSquareMatrix.numRows && this.numCols == complexSquareMatrix.numCols) {
            int n;
            double[][] dArray = new double[this.numRows][this.numRows];
            double[][] dArray2 = new double[this.numRows][this.numRows];
            for (n = 0; n < this.numRows; ++n) {
                System.arraycopy(complexSquareMatrix.matrixRe[n], 0, dArray[n], 0, this.numRows);
                System.arraycopy(complexSquareMatrix.matrixIm[n], 0, dArray2[n], 0, this.numRows);
            }
            double[] dArray3 = dArray[0];
            dArray3[0] = dArray3[0] + this.diagRe[0];
            double[] dArray4 = dArray2[0];
            dArray4[0] = dArray4[0] + this.diagIm[0];
            double[] dArray5 = dArray[0];
            dArray5[1] = dArray5[1] + this.udiagRe[0];
            double[] dArray6 = dArray2[0];
            dArray6[1] = dArray6[1] + this.udiagIm[0];
            n = this.numCols - 1;
            for (int i = 1; i < n; ++i) {
                double[] dArray7 = dArray[i];
                int n2 = i - 1;
                dArray7[n2] = dArray7[n2] + this.ldiagRe[i];
                double[] dArray8 = dArray2[i];
                int n3 = i - 1;
                dArray8[n3] = dArray8[n3] + this.ldiagIm[i];
                double[] dArray9 = dArray[i];
                int n4 = i;
                dArray9[n4] = dArray9[n4] + this.diagRe[i];
                double[] dArray10 = dArray2[i];
                int n5 = i;
                dArray10[n5] = dArray10[n5] + this.diagIm[i];
                double[] dArray11 = dArray[i];
                int n6 = i + 1;
                dArray11[n6] = dArray11[n6] + this.udiagRe[i];
                double[] dArray12 = dArray2[i];
                int n7 = i + 1;
                dArray12[n7] = dArray12[n7] + this.udiagIm[i];
            }
            double[] dArray13 = dArray[n];
            int n8 = n - 1;
            dArray13[n8] = dArray13[n8] + this.ldiagRe[n];
            double[] dArray14 = dArray2[n];
            int n9 = n - 1;
            dArray14[n9] = dArray14[n9] + this.ldiagIm[n];
            double[] dArray15 = dArray[n];
            int n10 = n;
            dArray15[n10] = dArray15[n10] + this.diagRe[n];
            double[] dArray16 = dArray2[n];
            int n11 = n;
            dArray16[n11] = dArray16[n11] + this.diagIm[n];
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix add(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.numRows;
        if (n == complexTridiagonalMatrix.numRows) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.diagRe[0] = this.diagRe[0] + complexTridiagonalMatrix.diagRe[0];
            complexTridiagonalMatrix2.diagIm[0] = this.diagIm[0] + complexTridiagonalMatrix.diagIm[0];
            complexTridiagonalMatrix2.udiagRe[0] = this.udiagRe[0] + complexTridiagonalMatrix.udiagRe[0];
            complexTridiagonalMatrix2.udiagIm[0] = this.udiagIm[0] + complexTridiagonalMatrix.udiagIm[0];
            --n;
            for (int i = 1; i < n; ++i) {
                complexTridiagonalMatrix2.ldiagRe[i] = this.ldiagRe[i] + complexTridiagonalMatrix.ldiagRe[i];
                complexTridiagonalMatrix2.ldiagIm[i] = this.ldiagIm[i] + complexTridiagonalMatrix.ldiagIm[i];
                complexTridiagonalMatrix2.diagRe[i] = this.diagRe[i] + complexTridiagonalMatrix.diagRe[i];
                complexTridiagonalMatrix2.diagIm[i] = this.diagIm[i] + complexTridiagonalMatrix.diagIm[i];
                complexTridiagonalMatrix2.udiagRe[i] = this.udiagRe[i] + complexTridiagonalMatrix.udiagRe[i];
                complexTridiagonalMatrix2.udiagIm[i] = this.udiagIm[i] + complexTridiagonalMatrix.udiagIm[i];
            }
            complexTridiagonalMatrix2.ldiagRe[n] = this.ldiagRe[n] + complexTridiagonalMatrix.ldiagRe[n];
            complexTridiagonalMatrix2.ldiagIm[n] = this.ldiagIm[n] + complexTridiagonalMatrix.ldiagIm[n];
            complexTridiagonalMatrix2.diagRe[n] = this.diagRe[n] + complexTridiagonalMatrix.diagRe[n];
            complexTridiagonalMatrix2.diagIm[n] = this.diagIm[n] + complexTridiagonalMatrix.diagIm[n];
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix addTridiagonal(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        int n = this.numRows;
        if (n == abstractComplexSquareMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
            Complex complex = abstractComplexSquareMatrix.getElement(0, 0);
            complexTridiagonalMatrix.diagRe[0] = this.diagRe[0] + complex.real();
            complexTridiagonalMatrix.diagIm[0] = this.diagIm[0] + complex.imag();
            complex = abstractComplexSquareMatrix.getElement(0, 1);
            complexTridiagonalMatrix.udiagRe[0] = this.udiagRe[0] + complex.real();
            complexTridiagonalMatrix.udiagIm[0] = this.udiagIm[0] + complex.imag();
            --n;
            for (int i = 1; i < n; ++i) {
                complex = abstractComplexSquareMatrix.getElement(i, i - 1);
                complexTridiagonalMatrix.ldiagRe[i] = this.ldiagRe[i] + complex.real();
                complexTridiagonalMatrix.ldiagIm[i] = this.ldiagIm[i] + complex.imag();
                complex = abstractComplexSquareMatrix.getElement(i, i);
                complexTridiagonalMatrix.diagRe[i] = this.diagRe[i] + complex.real();
                complexTridiagonalMatrix.diagIm[i] = this.diagIm[i] + complex.imag();
                complex = abstractComplexSquareMatrix.getElement(i, i + 1);
                complexTridiagonalMatrix.udiagRe[i] = this.udiagRe[i] + complex.real();
                complexTridiagonalMatrix.udiagIm[i] = this.udiagIm[i] + complex.imag();
            }
            complex = abstractComplexSquareMatrix.getElement(n, n - 1);
            complexTridiagonalMatrix.ldiagRe[n] = this.ldiagRe[n] + complex.real();
            complexTridiagonalMatrix.ldiagIm[n] = this.ldiagIm[n] + complex.imag();
            complex = abstractComplexSquareMatrix.getElement(n, n);
            complexTridiagonalMatrix.diagRe[n] = this.diagRe[n] + complex.real();
            complexTridiagonalMatrix.diagIm[n] = this.diagIm[n] + complex.imag();
            return complexTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexSquareMatrix subtract(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.subtract((ComplexTridiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof TridiagonalMatrix) {
            return this.subtractTridiagonal(abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.subtract((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numRows == abstractComplexSquareMatrix.rows() && this.numCols == abstractComplexSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                Complex complex = this.getElement(i, 0).subtract(abstractComplexSquareMatrix.getElement(i, 0));
                dArray[i][0] = complex.real();
                dArray2[i][0] = complex.imag();
                for (int j = 1; j < this.numCols; ++j) {
                    complex = this.getElement(i, j).subtract(abstractComplexSquareMatrix.getElement(i, j));
                    dArray[i][j] = complex.real();
                    dArray2[i][j] = complex.imag();
                }
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numRows == complexSquareMatrix.numRows && this.numCols == complexSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                Complex complex = this.getElement(i, 0);
                dArray[i][0] = complex.real() - complexSquareMatrix.matrixRe[i][0];
                dArray2[i][0] = complex.imag() - complexSquareMatrix.matrixIm[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    complex = this.getElement(i, j);
                    dArray[i][j] = complex.real() - complexSquareMatrix.matrixRe[i][j];
                    dArray2[i][j] = complex.imag() - complexSquareMatrix.matrixIm[i][j];
                }
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix subtract(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.numRows;
        if (n == complexTridiagonalMatrix.numRows) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.diagRe[0] = this.diagRe[0] - complexTridiagonalMatrix.diagRe[0];
            complexTridiagonalMatrix2.diagIm[0] = this.diagIm[0] - complexTridiagonalMatrix.diagIm[0];
            complexTridiagonalMatrix2.udiagRe[0] = this.udiagRe[0] - complexTridiagonalMatrix.udiagRe[0];
            complexTridiagonalMatrix2.udiagIm[0] = this.udiagIm[0] - complexTridiagonalMatrix.udiagIm[0];
            --n;
            for (int i = 1; i < n; ++i) {
                complexTridiagonalMatrix2.ldiagRe[i] = this.ldiagRe[i] - complexTridiagonalMatrix.ldiagRe[i];
                complexTridiagonalMatrix2.ldiagIm[i] = this.ldiagIm[i] - complexTridiagonalMatrix.ldiagIm[i];
                complexTridiagonalMatrix2.diagRe[i] = this.diagRe[i] - complexTridiagonalMatrix.diagRe[i];
                complexTridiagonalMatrix2.diagIm[i] = this.diagIm[i] - complexTridiagonalMatrix.diagIm[i];
                complexTridiagonalMatrix2.udiagRe[i] = this.udiagRe[i] - complexTridiagonalMatrix.udiagRe[i];
                complexTridiagonalMatrix2.udiagIm[i] = this.udiagIm[i] - complexTridiagonalMatrix.udiagIm[i];
            }
            complexTridiagonalMatrix2.ldiagRe[n] = this.ldiagRe[n] - complexTridiagonalMatrix.ldiagRe[n];
            complexTridiagonalMatrix2.ldiagIm[n] = this.ldiagIm[n] - complexTridiagonalMatrix.ldiagIm[n];
            complexTridiagonalMatrix2.diagRe[n] = this.diagRe[n] - complexTridiagonalMatrix.diagRe[n];
            complexTridiagonalMatrix2.diagIm[n] = this.diagIm[n] - complexTridiagonalMatrix.diagIm[n];
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix subtractTridiagonal(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        int n = this.numRows;
        if (n == abstractComplexSquareMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
            Complex complex = abstractComplexSquareMatrix.getElement(0, 0);
            complexTridiagonalMatrix.diagRe[0] = this.diagRe[0] - complex.real();
            complexTridiagonalMatrix.diagIm[0] = this.diagIm[0] - complex.imag();
            complex = abstractComplexSquareMatrix.getElement(0, 1);
            complexTridiagonalMatrix.udiagRe[0] = this.udiagRe[0] - complex.real();
            complexTridiagonalMatrix.udiagIm[0] = this.udiagIm[0] - complex.imag();
            --n;
            for (int i = 1; i < n; ++i) {
                complex = abstractComplexSquareMatrix.getElement(i, i - 1);
                complexTridiagonalMatrix.ldiagRe[i] = this.ldiagRe[i] - complex.real();
                complexTridiagonalMatrix.ldiagIm[i] = this.ldiagIm[i] - complex.imag();
                complex = abstractComplexSquareMatrix.getElement(i, i);
                complexTridiagonalMatrix.diagRe[i] = this.diagRe[i] - complex.real();
                complexTridiagonalMatrix.diagIm[i] = this.diagIm[i] - complex.imag();
                complex = abstractComplexSquareMatrix.getElement(i, i + 1);
                complexTridiagonalMatrix.udiagRe[i] = this.udiagRe[i] - complex.real();
                complexTridiagonalMatrix.udiagIm[i] = this.udiagIm[i] - complex.imag();
            }
            complex = abstractComplexSquareMatrix.getElement(n, n - 1);
            complexTridiagonalMatrix.ldiagRe[n] = this.ldiagRe[n] - complex.real();
            complexTridiagonalMatrix.ldiagIm[n] = this.ldiagIm[n] - complex.imag();
            complex = abstractComplexSquareMatrix.getElement(n, n);
            complexTridiagonalMatrix.diagRe[n] = this.diagRe[n] - complex.real();
            complexTridiagonalMatrix.diagIm[n] = this.diagIm[n] - complex.imag();
            return complexTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexMatrix scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        int n = this.numRows;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.diagRe[0] = d * this.diagRe[0] - d2 * this.diagIm[0];
        complexTridiagonalMatrix.diagIm[0] = d2 * this.diagRe[0] + d * this.diagIm[0];
        complexTridiagonalMatrix.udiagRe[0] = d * this.udiagRe[0] - d2 * this.udiagIm[0];
        complexTridiagonalMatrix.udiagIm[0] = d2 * this.udiagRe[0] + d * this.udiagIm[0];
        --n;
        for (int i = 1; i < n; ++i) {
            complexTridiagonalMatrix.ldiagRe[i] = d * this.ldiagRe[i] - d2 * this.ldiagIm[i];
            complexTridiagonalMatrix.ldiagIm[i] = d2 * this.ldiagRe[i] + d * this.ldiagIm[i];
            complexTridiagonalMatrix.diagRe[i] = d * this.diagRe[i] - d2 * this.diagIm[i];
            complexTridiagonalMatrix.diagIm[i] = d2 * this.diagRe[i] + d * this.diagIm[i];
            complexTridiagonalMatrix.udiagRe[i] = d * this.udiagRe[i] - d2 * this.udiagIm[i];
            complexTridiagonalMatrix.udiagIm[i] = d2 * this.udiagRe[i] + d * this.udiagIm[i];
        }
        complexTridiagonalMatrix.ldiagRe[n] = d * this.ldiagRe[n] - d2 * this.ldiagIm[n];
        complexTridiagonalMatrix.ldiagIm[n] = d2 * this.ldiagRe[n] + d * this.ldiagIm[n];
        complexTridiagonalMatrix.diagRe[n] = d * this.diagRe[n] - d2 * this.diagIm[n];
        complexTridiagonalMatrix.diagIm[n] = d2 * this.diagRe[n] + d * this.diagIm[n];
        return complexTridiagonalMatrix;
    }

    public AbstractComplexMatrix scalarMultiply(double d) {
        int n = this.numRows;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.diagRe[0] = d * this.diagRe[0];
        complexTridiagonalMatrix.diagIm[0] = d * this.diagIm[0];
        complexTridiagonalMatrix.udiagRe[0] = d * this.udiagRe[0];
        complexTridiagonalMatrix.udiagIm[0] = d * this.udiagIm[0];
        --n;
        for (int i = 1; i < n; ++i) {
            complexTridiagonalMatrix.ldiagRe[i] = d * this.ldiagRe[i];
            complexTridiagonalMatrix.ldiagIm[i] = d * this.ldiagIm[i];
            complexTridiagonalMatrix.diagRe[i] = d * this.diagRe[i];
            complexTridiagonalMatrix.diagIm[i] = d * this.diagIm[i];
            complexTridiagonalMatrix.udiagRe[i] = d * this.udiagRe[i];
            complexTridiagonalMatrix.udiagIm[i] = d * this.udiagIm[i];
        }
        complexTridiagonalMatrix.ldiagRe[n] = d * this.ldiagRe[n];
        complexTridiagonalMatrix.ldiagIm[n] = d * this.ldiagIm[n];
        complexTridiagonalMatrix.diagRe[n] = d * this.diagRe[n];
        complexTridiagonalMatrix.diagIm[n] = d * this.diagIm[n];
        return complexTridiagonalMatrix;
    }

    public AbstractComplexVector multiply(AbstractComplexVector abstractComplexVector) {
        int n = this.numRows;
        if (n == abstractComplexVector.dimension()) {
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            Complex complex = abstractComplexVector.getComponent(0);
            dArray[0] = this.diagRe[0] * complex.real() - this.diagIm[0] * complex.imag();
            dArray2[0] = this.diagIm[0] * complex.real() + this.diagRe[0] * complex.imag();
            complex = abstractComplexVector.getComponent(1);
            dArray[0] = dArray[0] + (this.udiagRe[0] * complex.real() - this.udiagIm[0] * complex.imag());
            dArray2[0] = dArray2[0] + (this.udiagIm[0] * complex.real() + this.udiagRe[0] * complex.imag());
            --n;
            for (int i = 1; i < n; ++i) {
                complex = abstractComplexVector.getComponent(i - 1);
                dArray[i] = this.ldiagRe[i] * complex.real() - this.ldiagIm[i] * complex.imag();
                dArray2[i] = this.ldiagIm[i] * complex.real() + this.ldiagRe[i] * complex.imag();
                complex = abstractComplexVector.getComponent(i);
                int n2 = i;
                dArray[n2] = dArray[n2] + (this.diagRe[i] * complex.real() - this.diagIm[i] * complex.imag());
                int n3 = i;
                dArray2[n3] = dArray2[n3] + (this.diagIm[i] * complex.real() + this.diagRe[i] * complex.imag());
                complex = abstractComplexVector.getComponent(i + 1);
                int n4 = i;
                dArray[n4] = dArray[n4] + (this.udiagRe[i] * complex.real() - this.udiagIm[i] * complex.imag());
                int n5 = i;
                dArray2[n5] = dArray2[n5] + (this.udiagIm[i] * complex.real() + this.udiagRe[i] * complex.imag());
            }
            complex = abstractComplexVector.getComponent(n - 1);
            dArray[n] = this.ldiagRe[n] * complex.real() - this.ldiagIm[n] * complex.imag();
            dArray2[n] = this.ldiagIm[n] * complex.real() + this.ldiagRe[n] * complex.imag();
            complex = abstractComplexVector.getComponent(n);
            int n6 = n;
            dArray[n6] = dArray[n6] + (this.diagRe[n] * complex.real() - this.diagIm[n] * complex.imag());
            int n7 = n;
            dArray2[n7] = dArray2[n7] + (this.diagIm[n] * complex.real() + this.diagRe[n] * complex.imag());
            return new ComplexVector(dArray, dArray2);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractComplexSquareMatrix multiply(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.multiply((ComplexTridiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof TridiagonalMatrix) {
            return this.multiplyTridiagonal(abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.multiply((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numCols == abstractComplexSquareMatrix.rows()) {
            int n = abstractComplexSquareMatrix.columns();
            double[][] dArray = new double[this.numRows][n];
            double[][] dArray2 = new double[this.numRows][n];
            int n2 = this.numRows - 1;
            for (int i = 0; i < this.numRows; ++i) {
                dArray[0][i] = this.diagRe[0] * abstractComplexSquareMatrix.getRealElement(0, i) - this.diagIm[0] * abstractComplexSquareMatrix.getImagElement(0, i) + (this.udiagRe[0] * abstractComplexSquareMatrix.getRealElement(1, i) - this.udiagIm[0] * abstractComplexSquareMatrix.getImagElement(1, i));
                dArray2[0][i] = this.diagIm[0] * abstractComplexSquareMatrix.getRealElement(0, i) + this.diagRe[0] * abstractComplexSquareMatrix.getImagElement(0, i) + (this.udiagIm[0] * abstractComplexSquareMatrix.getRealElement(1, i) + this.udiagRe[0] * abstractComplexSquareMatrix.getImagElement(1, i));
                for (int j = 1; j < n2; ++j) {
                    dArray[j][i] = this.ldiagRe[j] * abstractComplexSquareMatrix.getRealElement(j - 1, i) - this.ldiagIm[j] * abstractComplexSquareMatrix.getImagElement(j - 1, i) + (this.diagRe[j] * abstractComplexSquareMatrix.getRealElement(j, i) - this.diagIm[j] * abstractComplexSquareMatrix.getImagElement(j, i)) + (this.udiagRe[j] * abstractComplexSquareMatrix.getRealElement(j + 1, i) - this.udiagIm[j] * abstractComplexSquareMatrix.getImagElement(j + 1, i));
                    dArray2[j][i] = this.ldiagIm[j] * abstractComplexSquareMatrix.getRealElement(j - 1, i) + this.ldiagRe[j] * abstractComplexSquareMatrix.getImagElement(j - 1, i) + (this.diagIm[j] * abstractComplexSquareMatrix.getRealElement(j, i) + this.diagRe[j] * abstractComplexSquareMatrix.getImagElement(j, i)) + (this.udiagIm[j] * abstractComplexSquareMatrix.getRealElement(j + 1, i) + this.udiagRe[j] * abstractComplexSquareMatrix.getImagElement(j + 1, i));
                }
                dArray[n2][i] = this.ldiagRe[n2] * abstractComplexSquareMatrix.getRealElement(n2 - 1, i) - this.ldiagIm[n2] * abstractComplexSquareMatrix.getImagElement(n2 - 1, i) + (this.diagRe[n2] * abstractComplexSquareMatrix.getRealElement(n2, i) - this.diagIm[n2] * abstractComplexSquareMatrix.getImagElement(n2, i));
                dArray2[n2][i] = this.ldiagIm[n2] * abstractComplexSquareMatrix.getRealElement(n2 - 1, i) + this.ldiagRe[n2] * abstractComplexSquareMatrix.getImagElement(n2 - 1, i) + (this.diagIm[n2] * abstractComplexSquareMatrix.getRealElement(n2, i) + this.diagRe[n2] * abstractComplexSquareMatrix.getImagElement(n2, i));
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numCols == complexSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][complexSquareMatrix.numCols];
            double[][] dArray2 = new double[this.numRows][complexSquareMatrix.numCols];
            int n = this.numRows - 1;
            for (int i = 0; i < this.numRows; ++i) {
                dArray[0][i] = this.diagRe[0] * complexSquareMatrix.matrixRe[0][i] - this.diagIm[0] * complexSquareMatrix.matrixIm[0][i] + (this.udiagRe[0] * complexSquareMatrix.matrixRe[1][i] - this.udiagIm[0] * complexSquareMatrix.matrixIm[1][i]);
                dArray2[0][i] = this.diagIm[0] * complexSquareMatrix.matrixRe[0][i] + this.diagRe[0] * complexSquareMatrix.matrixIm[0][i] + (this.udiagIm[0] * complexSquareMatrix.matrixRe[1][i] + this.udiagRe[0] * complexSquareMatrix.matrixIm[1][i]);
                for (int j = 1; j < n; ++j) {
                    dArray[j][i] = this.ldiagRe[j] * complexSquareMatrix.matrixRe[j - 1][i] - this.ldiagIm[j] * complexSquareMatrix.matrixIm[j - 1][i] + (this.diagRe[j] * complexSquareMatrix.matrixRe[j][i] - this.diagIm[j] * complexSquareMatrix.matrixIm[j][i]) + (this.udiagRe[j] * complexSquareMatrix.matrixRe[j + 1][i] - this.udiagIm[j] * complexSquareMatrix.matrixIm[j + 1][i]);
                    dArray2[j][i] = this.ldiagIm[j] * complexSquareMatrix.matrixRe[j - 1][i] + this.ldiagRe[j] * complexSquareMatrix.matrixIm[j - 1][i] + (this.diagIm[j] * complexSquareMatrix.matrixRe[j][i] + this.diagRe[j] * complexSquareMatrix.matrixIm[j][i]) + (this.udiagIm[j] * complexSquareMatrix.matrixRe[j + 1][i] + this.udiagRe[j] * complexSquareMatrix.matrixIm[j + 1][i]);
                }
                dArray[n][i] = this.ldiagRe[n] * complexSquareMatrix.matrixRe[n - 1][i] - this.ldiagIm[n] * complexSquareMatrix.matrixIm[n - 1][i] + (this.diagRe[n] * complexSquareMatrix.matrixRe[n][i] - this.diagIm[n] * complexSquareMatrix.matrixIm[n][i]);
                dArray2[n][i] = this.ldiagIm[n] * complexSquareMatrix.matrixRe[n - 1][i] + this.ldiagRe[n] * complexSquareMatrix.matrixIm[n - 1][i] + (this.diagIm[n] * complexSquareMatrix.matrixRe[n][i] + this.diagRe[n] * complexSquareMatrix.matrixIm[n][i]);
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexSquareMatrix multiply(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.numRows;
        if (this.numCols == complexTridiagonalMatrix.numRows) {
            double[][] dArray = new double[n][n];
            double[][] dArray2 = new double[n][n];
            dArray[0][0] = this.diagRe[0] * complexTridiagonalMatrix.diagRe[0] - this.diagIm[0] * complexTridiagonalMatrix.diagIm[0] + (this.udiagRe[0] * complexTridiagonalMatrix.ldiagRe[1] - this.udiagIm[0] * complexTridiagonalMatrix.ldiagIm[1]);
            dArray2[0][0] = this.diagIm[0] * complexTridiagonalMatrix.diagRe[0] + this.diagRe[0] * complexTridiagonalMatrix.diagIm[0] + (this.udiagIm[0] * complexTridiagonalMatrix.ldiagRe[1] + this.udiagRe[0] * complexTridiagonalMatrix.ldiagIm[1]);
            dArray[0][1] = this.diagRe[0] * complexTridiagonalMatrix.udiagRe[0] - this.diagIm[0] * complexTridiagonalMatrix.udiagIm[0] + (this.udiagRe[0] * complexTridiagonalMatrix.diagRe[1] - this.udiagIm[0] * complexTridiagonalMatrix.diagIm[1]);
            dArray2[0][1] = this.diagIm[0] * complexTridiagonalMatrix.udiagRe[0] + this.diagRe[0] * complexTridiagonalMatrix.udiagIm[0] + (this.udiagIm[0] * complexTridiagonalMatrix.diagRe[1] + this.udiagRe[0] * complexTridiagonalMatrix.diagIm[1]);
            dArray[0][2] = this.udiagRe[0] * complexTridiagonalMatrix.udiagRe[1] - this.udiagIm[0] * complexTridiagonalMatrix.udiagIm[1];
            dArray2[0][2] = this.udiagIm[0] * complexTridiagonalMatrix.udiagRe[1] + this.udiagRe[0] * complexTridiagonalMatrix.udiagIm[1];
            if (n > 3) {
                dArray[1][0] = this.ldiagRe[1] * complexTridiagonalMatrix.diagRe[0] - this.ldiagIm[1] * complexTridiagonalMatrix.diagIm[0] + (this.diagRe[1] * complexTridiagonalMatrix.ldiagRe[1] - this.diagIm[1] * complexTridiagonalMatrix.ldiagIm[1]);
                dArray2[1][0] = this.ldiagIm[1] * complexTridiagonalMatrix.diagRe[0] + this.ldiagRe[1] * complexTridiagonalMatrix.diagIm[0] + (this.diagIm[1] * complexTridiagonalMatrix.ldiagRe[1] + this.diagRe[1] * complexTridiagonalMatrix.ldiagIm[1]);
                dArray[1][1] = this.ldiagRe[1] * complexTridiagonalMatrix.udiagRe[0] - this.ldiagIm[1] * complexTridiagonalMatrix.udiagIm[0] + (this.diagRe[1] * complexTridiagonalMatrix.diagRe[1] - this.diagIm[1] * complexTridiagonalMatrix.diagIm[1]) + (this.udiagRe[1] * complexTridiagonalMatrix.ldiagRe[2] - this.udiagIm[1] * complexTridiagonalMatrix.ldiagIm[2]);
                dArray2[1][1] = this.ldiagIm[1] * complexTridiagonalMatrix.udiagRe[0] + this.ldiagRe[1] * complexTridiagonalMatrix.udiagIm[0] + (this.diagIm[1] * complexTridiagonalMatrix.diagRe[1] + this.diagRe[1] * complexTridiagonalMatrix.diagIm[1]) + (this.udiagIm[1] * complexTridiagonalMatrix.ldiagRe[2] + this.udiagRe[1] * complexTridiagonalMatrix.ldiagIm[2]);
                dArray[1][2] = this.diagRe[1] * complexTridiagonalMatrix.udiagRe[1] - this.diagIm[1] * complexTridiagonalMatrix.udiagIm[1] + (this.udiagRe[1] * complexTridiagonalMatrix.diagRe[2] - this.udiagIm[1] * complexTridiagonalMatrix.diagIm[2]);
                dArray2[1][2] = this.diagIm[1] * complexTridiagonalMatrix.udiagRe[1] + this.diagRe[1] * complexTridiagonalMatrix.udiagIm[1] + (this.udiagIm[1] * complexTridiagonalMatrix.diagRe[2] + this.udiagRe[1] * complexTridiagonalMatrix.diagIm[2]);
                dArray[1][3] = this.udiagRe[1] * complexTridiagonalMatrix.udiagRe[2] - this.udiagIm[1] * complexTridiagonalMatrix.udiagIm[2];
                dArray2[1][3] = this.udiagIm[1] * complexTridiagonalMatrix.udiagRe[2] + this.udiagRe[1] * complexTridiagonalMatrix.udiagIm[2];
            }
            if (n == 3) {
                dArray[1][0] = this.ldiagRe[1] * complexTridiagonalMatrix.diagRe[0] - this.ldiagIm[1] * complexTridiagonalMatrix.diagIm[0] + (this.diagRe[1] * complexTridiagonalMatrix.ldiagRe[1] - this.diagIm[1] * complexTridiagonalMatrix.ldiagIm[1]);
                dArray2[1][0] = this.ldiagIm[1] * complexTridiagonalMatrix.diagRe[0] + this.ldiagRe[1] * complexTridiagonalMatrix.diagIm[0] + (this.diagIm[1] * complexTridiagonalMatrix.ldiagRe[1] + this.diagRe[1] * complexTridiagonalMatrix.ldiagIm[1]);
                dArray[1][1] = this.ldiagRe[1] * complexTridiagonalMatrix.udiagRe[0] - this.ldiagIm[1] * complexTridiagonalMatrix.udiagIm[0] + (this.diagRe[1] * complexTridiagonalMatrix.diagRe[1] - this.diagIm[1] * complexTridiagonalMatrix.diagIm[1]) + (this.udiagRe[1] * complexTridiagonalMatrix.ldiagRe[2] - this.udiagIm[1] * complexTridiagonalMatrix.ldiagIm[2]);
                dArray2[1][1] = this.ldiagIm[1] * complexTridiagonalMatrix.udiagRe[0] + this.ldiagRe[1] * complexTridiagonalMatrix.udiagIm[0] + (this.diagIm[1] * complexTridiagonalMatrix.diagRe[1] + this.diagRe[1] * complexTridiagonalMatrix.diagIm[1]) + (this.udiagIm[1] * complexTridiagonalMatrix.ldiagRe[2] + this.udiagRe[1] * complexTridiagonalMatrix.ldiagIm[2]);
                dArray[1][2] = this.diagRe[1] * complexTridiagonalMatrix.udiagRe[1] - this.diagIm[1] * complexTridiagonalMatrix.udiagIm[1] + (this.udiagRe[1] * complexTridiagonalMatrix.diagRe[2] - this.udiagIm[1] * complexTridiagonalMatrix.diagIm[2]);
                dArray2[1][2] = this.diagIm[1] * complexTridiagonalMatrix.udiagRe[1] + this.diagRe[1] * complexTridiagonalMatrix.udiagIm[1] + (this.udiagIm[1] * complexTridiagonalMatrix.diagRe[2] + this.udiagRe[1] * complexTridiagonalMatrix.diagIm[2]);
            } else if (n > 4) {
                for (int i = 2; i < n - 2; ++i) {
                    dArray[i][i - 2] = this.ldiagRe[i] * complexTridiagonalMatrix.ldiagRe[i - 1] - this.ldiagIm[i] * complexTridiagonalMatrix.ldiagIm[i - 1];
                    dArray2[i][i - 2] = this.ldiagIm[i] * complexTridiagonalMatrix.ldiagRe[i - 1] + this.ldiagRe[i] * complexTridiagonalMatrix.ldiagIm[i - 1];
                    dArray[i][i - 1] = this.ldiagRe[i] * complexTridiagonalMatrix.diagRe[i - 1] - this.ldiagIm[i] * complexTridiagonalMatrix.diagIm[i - 1] + (this.diagRe[i] * complexTridiagonalMatrix.ldiagRe[i] - this.diagIm[i] * complexTridiagonalMatrix.ldiagIm[i]);
                    dArray2[i][i - 1] = this.ldiagIm[i] * complexTridiagonalMatrix.diagRe[i - 1] + this.ldiagRe[i] * complexTridiagonalMatrix.diagIm[i - 1] + (this.diagIm[i] * complexTridiagonalMatrix.ldiagRe[i] + this.diagRe[i] * complexTridiagonalMatrix.ldiagIm[i]);
                    dArray[i][i] = this.ldiagRe[i] * complexTridiagonalMatrix.udiagRe[i - 1] - this.ldiagIm[i] * complexTridiagonalMatrix.udiagIm[i - 1] + (this.diagRe[i] * complexTridiagonalMatrix.diagRe[i] - this.diagIm[i] * complexTridiagonalMatrix.diagIm[i]) + (this.udiagRe[i] * complexTridiagonalMatrix.ldiagRe[i + 1] - this.udiagIm[i] * complexTridiagonalMatrix.ldiagIm[i + 1]);
                    dArray2[i][i] = this.ldiagIm[i] * complexTridiagonalMatrix.udiagRe[i - 1] + this.ldiagRe[i] * complexTridiagonalMatrix.udiagIm[i - 1] + (this.diagIm[i] * complexTridiagonalMatrix.diagRe[i] + this.diagRe[i] * complexTridiagonalMatrix.diagIm[i]) + (this.udiagIm[i] * complexTridiagonalMatrix.ldiagRe[i + 1] + this.udiagRe[i] * complexTridiagonalMatrix.ldiagIm[i + 1]);
                    dArray[i][i + 1] = this.diagRe[i] * complexTridiagonalMatrix.udiagRe[i] - this.diagIm[i] * complexTridiagonalMatrix.udiagIm[i] + (this.udiagRe[i] * complexTridiagonalMatrix.diagRe[i + 1] - this.udiagIm[i] * complexTridiagonalMatrix.diagIm[i + 1]);
                    dArray2[i][i + 1] = this.diagIm[i] * complexTridiagonalMatrix.udiagRe[i] + this.diagRe[i] * complexTridiagonalMatrix.udiagIm[i] + (this.udiagIm[i] * complexTridiagonalMatrix.diagRe[i + 1] + this.udiagRe[i] * complexTridiagonalMatrix.diagIm[i + 1]);
                    dArray[i][i + 2] = this.udiagRe[i] * complexTridiagonalMatrix.udiagRe[i + 1] - this.udiagIm[i] * complexTridiagonalMatrix.udiagIm[i + 1];
                    dArray2[i][i + 2] = this.udiagIm[i] * complexTridiagonalMatrix.udiagRe[i + 1] + this.udiagRe[i] * complexTridiagonalMatrix.udiagIm[i + 1];
                }
            }
            if (n > 3) {
                dArray[n - 2][n - 4] = this.ldiagRe[n - 2] * complexTridiagonalMatrix.ldiagRe[n - 3] - this.ldiagIm[n - 2] * complexTridiagonalMatrix.ldiagIm[n - 3];
                dArray2[n - 2][n - 4] = this.ldiagIm[n - 2] * complexTridiagonalMatrix.ldiagRe[n - 3] + this.ldiagRe[n - 2] * complexTridiagonalMatrix.ldiagIm[n - 3];
                dArray[n - 2][n - 3] = this.ldiagRe[n - 2] * complexTridiagonalMatrix.diagRe[n - 3] - this.ldiagIm[n - 2] * complexTridiagonalMatrix.diagIm[n - 3] + (this.diagRe[n - 2] * complexTridiagonalMatrix.ldiagRe[n - 2] - this.diagIm[n - 2] * complexTridiagonalMatrix.ldiagIm[n - 2]);
                dArray2[n - 2][n - 3] = this.ldiagIm[n - 2] * complexTridiagonalMatrix.diagRe[n - 3] + this.ldiagRe[n - 2] * complexTridiagonalMatrix.diagIm[n - 3] + (this.diagIm[n - 2] * complexTridiagonalMatrix.ldiagRe[n - 2] + this.diagRe[n - 2] * complexTridiagonalMatrix.ldiagIm[n - 2]);
                dArray[n - 2][n - 2] = this.ldiagRe[n - 2] * complexTridiagonalMatrix.udiagRe[n - 3] - this.ldiagIm[n - 2] * complexTridiagonalMatrix.udiagIm[n - 3] + (this.diagRe[n - 2] * complexTridiagonalMatrix.diagRe[n - 2] - this.diagIm[n - 2] * complexTridiagonalMatrix.diagIm[n - 2]) + (this.udiagRe[n - 2] * complexTridiagonalMatrix.ldiagRe[n - 1] - this.udiagIm[n - 2] * complexTridiagonalMatrix.ldiagIm[n - 1]);
                dArray2[n - 2][n - 2] = this.ldiagIm[n - 2] * complexTridiagonalMatrix.udiagRe[n - 3] + this.ldiagRe[n - 2] * complexTridiagonalMatrix.udiagIm[n - 3] + (this.diagIm[n - 2] * complexTridiagonalMatrix.diagRe[n - 2] + this.diagRe[n - 2] * complexTridiagonalMatrix.diagIm[n - 2]) + (this.udiagIm[n - 2] * complexTridiagonalMatrix.ldiagRe[n - 1] + this.udiagRe[n - 2] * complexTridiagonalMatrix.ldiagIm[n - 1]);
                dArray[n - 2][n - 1] = this.diagRe[n - 2] * complexTridiagonalMatrix.udiagRe[n - 2] - this.diagIm[n - 2] * complexTridiagonalMatrix.udiagIm[n - 2] + (this.udiagRe[n - 2] * complexTridiagonalMatrix.diagRe[n - 1] - this.udiagIm[n - 2] * complexTridiagonalMatrix.diagIm[n - 1]);
                dArray2[n - 2][n - 1] = this.diagIm[n - 2] * complexTridiagonalMatrix.udiagRe[n - 2] + this.diagRe[n - 2] * complexTridiagonalMatrix.udiagIm[n - 2] + (this.udiagIm[n - 2] * complexTridiagonalMatrix.diagRe[n - 1] + this.udiagRe[n - 2] * complexTridiagonalMatrix.diagIm[n - 1]);
            }
            dArray[n][--n - 2] = this.ldiagRe[n] * complexTridiagonalMatrix.ldiagRe[n - 1] - this.ldiagIm[n] * complexTridiagonalMatrix.ldiagIm[n - 1];
            dArray2[n][n - 2] = this.ldiagIm[n] * complexTridiagonalMatrix.ldiagRe[n - 1] + this.ldiagRe[n] * complexTridiagonalMatrix.ldiagIm[n - 1];
            dArray[n][n - 1] = this.ldiagRe[n] * complexTridiagonalMatrix.diagRe[n - 1] - this.ldiagIm[n] * complexTridiagonalMatrix.diagIm[n - 1] + (this.diagRe[n] * complexTridiagonalMatrix.ldiagRe[n] - this.diagIm[n] * complexTridiagonalMatrix.ldiagIm[n]);
            dArray2[n][n - 1] = this.ldiagIm[n] * complexTridiagonalMatrix.diagRe[n - 1] + this.ldiagRe[n] * complexTridiagonalMatrix.diagIm[n - 1] + (this.diagIm[n] * complexTridiagonalMatrix.ldiagRe[n] + this.diagRe[n] * complexTridiagonalMatrix.ldiagIm[n]);
            dArray[n][n] = this.ldiagRe[n] * complexTridiagonalMatrix.udiagRe[n - 1] - this.ldiagIm[n] * complexTridiagonalMatrix.udiagIm[n - 1] + (this.diagRe[n] * complexTridiagonalMatrix.diagRe[n] - this.diagIm[n] * complexTridiagonalMatrix.diagIm[n]);
            dArray2[n][n] = this.ldiagIm[n] * complexTridiagonalMatrix.udiagRe[n - 1] + this.ldiagRe[n] * complexTridiagonalMatrix.udiagIm[n - 1] + (this.diagIm[n] * complexTridiagonalMatrix.diagRe[n] + this.diagRe[n] * complexTridiagonalMatrix.diagIm[n]);
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private ComplexSquareMatrix multiplyTridiagonal(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        int n = this.numRows;
        if (this.numCols == abstractComplexSquareMatrix.rows()) {
            Complex complex;
            double[][] dArray = new double[n][n];
            double[][] dArray2 = new double[n][n];
            Complex complex2 = abstractComplexSquareMatrix.getElement(0, 0);
            Complex complex3 = abstractComplexSquareMatrix.getElement(1, 0);
            dArray[0][0] = this.diagRe[0] * complex2.real() - this.diagIm[0] * complex2.imag() + (this.udiagRe[0] * complex3.real() - this.udiagIm[0] * complex3.imag());
            dArray2[0][0] = this.diagIm[0] * complex2.real() + this.diagRe[0] * complex2.imag() + (this.udiagIm[0] * complex3.real() + this.udiagRe[0] * complex3.imag());
            complex2 = abstractComplexSquareMatrix.getElement(0, 1);
            complex3 = abstractComplexSquareMatrix.getElement(1, 1);
            dArray[0][1] = this.diagRe[0] * complex2.real() - this.diagIm[0] * complex2.imag() + (this.udiagRe[0] * complex3.real() - this.udiagIm[0] * complex3.imag());
            dArray2[0][1] = this.diagIm[0] * complex2.real() + this.diagRe[0] * complex2.imag() + (this.udiagIm[0] * complex3.real() + this.udiagRe[0] * complex3.imag());
            complex2 = abstractComplexSquareMatrix.getElement(1, 2);
            dArray[0][2] = this.udiagRe[0] * complex2.real() - this.udiagIm[0] * complex2.imag();
            dArray2[0][2] = this.udiagIm[0] * complex2.real() + this.udiagRe[0] * complex2.imag();
            if (n > 3) {
                complex2 = abstractComplexSquareMatrix.getElement(0, 0);
                complex3 = abstractComplexSquareMatrix.getElement(1, 0);
                dArray[1][0] = this.ldiagRe[1] * complex2.real() - this.ldiagIm[1] * complex2.imag() + (this.diagRe[1] * complex3.real() - this.diagIm[1] * complex3.imag());
                dArray2[1][0] = this.ldiagIm[1] * complex2.real() + this.ldiagRe[1] * complex2.imag() + (this.diagIm[1] * complex3.real() + this.diagRe[1] * complex3.imag());
                complex2 = abstractComplexSquareMatrix.getElement(0, 1);
                complex3 = abstractComplexSquareMatrix.getElement(1, 1);
                complex = abstractComplexSquareMatrix.getElement(2, 1);
                dArray[1][1] = this.ldiagRe[1] * complex2.real() - this.ldiagIm[1] * complex2.imag() + (this.diagRe[1] * complex3.real() - this.diagIm[1] * complex3.imag()) + (this.udiagRe[1] * complex.real() - this.udiagIm[1] * complex.imag());
                dArray2[1][1] = this.ldiagIm[1] * complex2.real() + this.ldiagRe[1] * complex2.imag() + (this.diagIm[1] * complex3.real() + this.diagRe[1] * complex3.imag()) + (this.udiagIm[1] * complex.real() + this.udiagRe[1] * complex.imag());
                complex2 = abstractComplexSquareMatrix.getElement(1, 2);
                complex3 = abstractComplexSquareMatrix.getElement(2, 2);
                dArray[1][2] = this.diagRe[1] * complex2.real() - this.diagIm[1] * complex2.imag() + (this.udiagRe[1] * complex3.real() - this.udiagIm[1] * complex3.imag());
                dArray2[1][2] = this.diagIm[1] * complex2.real() + this.diagRe[1] * complex2.imag() + (this.udiagIm[1] * complex3.real() + this.udiagRe[1] * complex3.imag());
                complex2 = abstractComplexSquareMatrix.getElement(2, 3);
                dArray[1][3] = this.udiagRe[1] * complex2.real() - this.udiagIm[1] * complex2.imag();
                dArray2[1][3] = this.udiagIm[1] * complex2.real() + this.udiagRe[1] * complex2.imag();
            }
            if (n == 3) {
                complex2 = abstractComplexSquareMatrix.getElement(0, 0);
                complex3 = abstractComplexSquareMatrix.getElement(1, 0);
                dArray[1][0] = this.ldiagRe[1] * complex2.real() - this.ldiagIm[1] * complex2.imag() + (this.diagRe[1] * complex3.real() - this.diagIm[1] * complex3.imag());
                dArray2[1][0] = this.ldiagIm[1] * complex2.real() + this.ldiagRe[1] * complex2.imag() + (this.diagIm[1] * complex3.real() + this.diagRe[1] * complex3.imag());
                complex2 = abstractComplexSquareMatrix.getElement(0, 1);
                complex3 = abstractComplexSquareMatrix.getElement(1, 1);
                complex = abstractComplexSquareMatrix.getElement(2, 1);
                dArray[1][1] = this.ldiagRe[1] * complex2.real() - this.ldiagIm[1] * complex2.imag() + (this.diagRe[1] * complex3.real() - this.diagIm[1] * complex3.imag()) + (this.udiagRe[1] * complex.real() - this.udiagIm[1] * complex.imag());
                dArray2[1][1] = this.ldiagIm[1] * complex2.real() + this.ldiagRe[1] * complex2.imag() + (this.diagIm[1] * complex3.real() + this.diagRe[1] * complex3.imag()) + (this.udiagIm[1] * complex.real() + this.udiagRe[1] * complex.imag());
                complex2 = abstractComplexSquareMatrix.getElement(1, 2);
                complex3 = abstractComplexSquareMatrix.getElement(2, 2);
                dArray[1][2] = this.diagRe[1] * complex2.real() - this.diagIm[1] * complex2.imag() + (this.udiagRe[1] * complex3.real() - this.udiagIm[1] * complex3.imag());
                dArray2[1][2] = this.diagIm[1] * complex2.real() + this.diagRe[1] * complex2.imag() + (this.udiagIm[1] * complex3.real() + this.udiagRe[1] * complex3.imag());
            } else if (n > 4) {
                for (int i = 2; i < n - 2; ++i) {
                    complex2 = abstractComplexSquareMatrix.getElement(i - 1, i - 2);
                    dArray[i][i - 2] = this.ldiagRe[i] * complex2.real() - this.ldiagIm[i] * complex2.imag();
                    dArray2[i][i - 2] = this.ldiagIm[i] * complex2.real() + this.ldiagRe[i] * complex2.imag();
                    complex2 = abstractComplexSquareMatrix.getElement(i - 1, i - 1);
                    complex3 = abstractComplexSquareMatrix.getElement(i, i - 1);
                    dArray[i][i - 1] = this.ldiagRe[i] * complex2.real() - this.ldiagIm[i] * complex2.imag() + (this.diagRe[i] * complex3.real() - this.diagIm[i] * complex3.imag());
                    dArray2[i][i - 1] = this.ldiagIm[i] * complex2.real() + this.ldiagRe[i] * complex2.imag() + (this.diagIm[i] * complex3.real() + this.diagRe[i] * complex3.imag());
                    complex2 = abstractComplexSquareMatrix.getElement(i - 1, i);
                    complex3 = abstractComplexSquareMatrix.getElement(i, i);
                    complex = abstractComplexSquareMatrix.getElement(i + 1, i);
                    dArray[i][i] = this.ldiagRe[i] * complex2.real() - this.ldiagIm[i] * complex2.imag() + (this.diagRe[i] * complex3.real() - this.diagIm[i] * complex3.imag()) + (this.udiagRe[i] * complex.real() - this.udiagIm[i] * complex.imag());
                    dArray2[i][i] = this.ldiagIm[i] * complex2.real() + this.ldiagRe[i] * complex2.imag() + (this.diagIm[i] * complex3.real() + this.diagRe[i] * complex3.imag()) + (this.udiagIm[i] * complex.real() + this.udiagRe[i] * complex.imag());
                    complex2 = abstractComplexSquareMatrix.getElement(i, i + 1);
                    complex3 = abstractComplexSquareMatrix.getElement(i + 1, i + 1);
                    dArray[i][i + 1] = this.diagRe[i] * complex2.real() - this.diagIm[i] * complex2.imag() + (this.udiagRe[i] * complex3.real() - this.udiagIm[i] * complex3.imag());
                    dArray2[i][i + 1] = this.diagIm[i] * complex2.real() + this.diagRe[i] * complex2.imag() + (this.udiagIm[i] * complex3.real() + this.udiagRe[i] * complex3.imag());
                    complex2 = abstractComplexSquareMatrix.getElement(i + 1, i + 2);
                    dArray[i][i + 2] = this.udiagRe[i] * complex2.real() - this.udiagIm[i] * complex2.imag();
                    dArray2[i][i + 2] = this.udiagIm[i] * complex2.real() + this.udiagRe[i] * complex2.imag();
                }
            }
            if (n > 3) {
                complex2 = abstractComplexSquareMatrix.getElement(n - 3, n - 4);
                dArray[n - 2][n - 4] = this.ldiagRe[n - 2] * complex2.real() - this.ldiagIm[n - 2] * complex2.imag();
                dArray2[n - 2][n - 4] = this.ldiagIm[n - 2] * complex2.real() + this.ldiagRe[n - 2] * complex2.imag();
                complex2 = abstractComplexSquareMatrix.getElement(n - 3, n - 3);
                complex3 = abstractComplexSquareMatrix.getElement(n - 2, n - 3);
                dArray[n - 2][n - 3] = this.ldiagRe[n - 2] * complex2.real() - this.ldiagIm[n - 2] * complex2.imag() + (this.diagRe[n - 2] * complex3.real() - this.diagIm[n - 2] * complex3.imag());
                dArray2[n - 2][n - 3] = this.ldiagIm[n - 2] * complex2.real() + this.ldiagRe[n - 2] * complex2.imag() + (this.diagIm[n - 2] * complex3.real() + this.diagRe[n - 2] * complex3.imag());
                complex2 = abstractComplexSquareMatrix.getElement(n - 3, n - 2);
                complex3 = abstractComplexSquareMatrix.getElement(n - 2, n - 2);
                complex = abstractComplexSquareMatrix.getElement(n - 1, n - 2);
                dArray[n - 2][n - 2] = this.ldiagRe[n - 2] * complex2.real() - this.ldiagIm[n - 2] * complex2.imag() + (this.diagRe[n - 2] * complex3.real() - this.diagIm[n - 2] * complex3.imag()) + (this.udiagRe[n - 2] * complex.real() - this.udiagIm[n - 2] * complex.imag());
                dArray2[n - 2][n - 2] = this.ldiagIm[n - 2] * complex2.real() + this.ldiagRe[n - 2] * complex2.imag() + (this.diagIm[n - 2] * complex3.real() + this.diagRe[n - 2] * complex3.imag()) + (this.udiagIm[n - 2] * complex.real() + this.udiagRe[n - 2] * complex.imag());
                complex2 = abstractComplexSquareMatrix.getElement(n - 2, n - 1);
                complex3 = abstractComplexSquareMatrix.getElement(n - 1, n - 1);
                dArray[n - 2][n - 1] = this.diagRe[n - 2] * complex2.real() - this.diagIm[n - 2] * complex2.imag() + (this.udiagRe[n - 2] * complex3.real() - this.udiagIm[n - 2] * complex3.imag());
                dArray2[n - 2][n - 1] = this.diagIm[n - 2] * complex2.real() + this.diagRe[n - 2] * complex2.imag() + (this.udiagIm[n - 2] * complex3.real() + this.udiagRe[n - 2] * complex3.imag());
            }
            complex2 = abstractComplexSquareMatrix.getElement(--n - 1, n - 2);
            dArray[n][n - 2] = this.ldiagRe[n] * complex2.real() - this.ldiagIm[n] * complex2.imag();
            dArray2[n][n - 2] = this.ldiagIm[n] * complex2.real() + this.ldiagRe[n] * complex2.imag();
            complex2 = abstractComplexSquareMatrix.getElement(n - 1, n - 1);
            complex3 = abstractComplexSquareMatrix.getElement(n, n - 1);
            dArray[n][n - 1] = this.ldiagRe[n] * complex2.real() - this.ldiagIm[n] * complex2.imag() + (this.diagRe[n] * complex3.real() - this.diagIm[n] * complex3.imag());
            dArray2[n][n - 1] = this.ldiagIm[n] * complex2.real() + this.ldiagRe[n] * complex2.imag() + (this.diagIm[n] * complex3.real() + this.diagRe[n] * complex3.imag());
            complex2 = abstractComplexSquareMatrix.getElement(n - 1, n);
            complex3 = abstractComplexSquareMatrix.getElement(n, n);
            dArray[n][n] = this.ldiagRe[n] * complex2.real() - this.ldiagIm[n] * complex2.imag() + (this.diagRe[n] * complex3.real() - this.diagIm[n] * complex3.imag());
            dArray2[n][n] = this.ldiagIm[n] * complex2.real() + this.ldiagRe[n] * complex2.imag() + (this.diagIm[n] * complex3.real() + this.diagRe[n] * complex3.imag());
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractComplexMatrix hermitianAdjoint() {
        int n = this.numRows;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        System.arraycopy(this.ldiagRe, 1, complexTridiagonalMatrix.udiagRe, 0, this.ldiagRe.length - 1);
        System.arraycopy(this.diagRe, 0, complexTridiagonalMatrix.diagRe, 0, this.diagRe.length);
        System.arraycopy(this.udiagRe, 0, complexTridiagonalMatrix.ldiagRe, 1, this.udiagRe.length - 1);
        complexTridiagonalMatrix.diagIm[0] = -this.diagIm[0];
        complexTridiagonalMatrix.ldiagIm[1] = -this.udiagIm[0];
        --n;
        for (int i = 1; i < n; ++i) {
            complexTridiagonalMatrix.udiagIm[i - 1] = -this.ldiagIm[i];
            complexTridiagonalMatrix.diagIm[i] = -this.diagIm[i];
            complexTridiagonalMatrix.ldiagIm[i + 1] = -this.udiagIm[i];
        }
        complexTridiagonalMatrix.udiagIm[n - 1] = -this.ldiagIm[n];
        complexTridiagonalMatrix.diagIm[n] = -this.diagIm[n];
        return complexTridiagonalMatrix;
    }

    public AbstractComplexMatrix conjugate() {
        int n = this.numRows;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        System.arraycopy(this.ldiagRe, 1, complexTridiagonalMatrix.ldiagRe, 0, this.ldiagRe.length - 1);
        System.arraycopy(this.diagRe, 0, complexTridiagonalMatrix.diagRe, 0, this.diagRe.length);
        System.arraycopy(this.udiagRe, 0, complexTridiagonalMatrix.udiagRe, 1, this.udiagRe.length - 1);
        complexTridiagonalMatrix.diagIm[0] = -this.diagIm[0];
        complexTridiagonalMatrix.udiagIm[0] = -this.udiagIm[0];
        --n;
        for (int i = 1; i < n; ++i) {
            complexTridiagonalMatrix.ldiagIm[i] = -this.ldiagIm[i];
            complexTridiagonalMatrix.diagIm[i] = -this.diagIm[i];
            complexTridiagonalMatrix.udiagIm[i] = -this.udiagIm[i];
        }
        complexTridiagonalMatrix.ldiagIm[n] = -this.ldiagIm[n];
        complexTridiagonalMatrix.diagIm[n] = -this.diagIm[n];
        return complexTridiagonalMatrix;
    }

    public Matrix transpose() {
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(this.numRows);
        System.arraycopy(this.ldiagRe, 1, complexTridiagonalMatrix.udiagRe, 0, this.ldiagRe.length - 1);
        System.arraycopy(this.ldiagIm, 1, complexTridiagonalMatrix.udiagIm, 0, this.ldiagIm.length - 1);
        System.arraycopy(this.diagRe, 0, complexTridiagonalMatrix.diagRe, 0, this.diagRe.length);
        System.arraycopy(this.diagIm, 0, complexTridiagonalMatrix.diagIm, 0, this.diagIm.length);
        System.arraycopy(this.udiagRe, 0, complexTridiagonalMatrix.ldiagRe, 1, this.udiagRe.length - 1);
        System.arraycopy(this.udiagIm, 0, complexTridiagonalMatrix.ldiagIm, 1, this.udiagIm.length - 1);
        return complexTridiagonalMatrix;
    }

    public AbstractComplexMatrix mapElements(ComplexMapping complexMapping) {
        Complex complex = complexMapping.map(Complex.ZERO);
        if (complex.mod() <= GlobalSettings.ZERO_TOL) {
            return this.tridiagonalMap(complexMapping);
        }
        return this.generalMap(complexMapping, complex);
    }

    private AbstractComplexMatrix tridiagonalMap(ComplexMapping complexMapping) {
        int n = this.numRows;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.setElement(0, 0, complexMapping.map(this.diagRe[0], this.diagIm[0]));
        complexTridiagonalMatrix.setElement(0, 1, complexMapping.map(this.udiagRe[0], this.udiagIm[0]));
        --n;
        for (int i = 1; i < n; ++i) {
            complexTridiagonalMatrix.setElement(i, i - 1, complexMapping.map(this.ldiagRe[i], this.ldiagIm[i]));
            complexTridiagonalMatrix.setElement(i, i, complexMapping.map(this.diagRe[i], this.diagIm[i]));
            complexTridiagonalMatrix.setElement(i, i + 1, complexMapping.map(this.udiagRe[i], this.udiagIm[i]));
        }
        complexTridiagonalMatrix.setElement(n, n - 1, complexMapping.map(this.ldiagRe[n], this.ldiagIm[n]));
        complexTridiagonalMatrix.setElement(n, n, complexMapping.map(this.diagRe[n], this.diagIm[n]));
        return complexTridiagonalMatrix;
    }

    private AbstractComplexMatrix generalMap(ComplexMapping complexMapping, Complex complex) {
        int n;
        double[][] dArray = new double[this.numRows][this.numRows];
        double[][] dArray2 = new double[this.numRows][this.numRows];
        for (n = 0; n < this.numRows; ++n) {
            for (int i = 0; i < this.numRows; ++i) {
                dArray[n][i] = complex.real();
                dArray2[n][i] = complex.imag();
            }
        }
        n = this.numRows;
        Complex complex2 = complexMapping.map(this.diagRe[0], this.diagIm[0]);
        dArray[0][0] = complex2.real();
        dArray2[0][0] = complex2.imag();
        complex2 = complexMapping.map(this.udiagRe[0], this.udiagIm[0]);
        dArray[0][1] = complex2.real();
        dArray2[0][1] = complex2.imag();
        --n;
        for (int i = 1; i < n; ++i) {
            complex2 = complexMapping.map(this.ldiagRe[i], this.ldiagIm[i]);
            dArray[i][i - 1] = complex2.real();
            dArray2[i][i - 1] = complex2.imag();
            complex2 = complexMapping.map(this.diagRe[i], this.diagIm[i]);
            dArray[i][i] = complex2.real();
            dArray2[i][i] = complex2.imag();
            complex2 = complexMapping.map(this.udiagRe[i], this.udiagIm[i]);
            dArray[i][i + 1] = complex2.real();
            dArray2[i][i + 1] = complex2.imag();
        }
        complex2 = complexMapping.map(this.ldiagRe[n], this.ldiagIm[n]);
        dArray[n][n - 1] = complex2.real();
        dArray2[n][n - 1] = complex2.imag();
        complex2 = complexMapping.map(this.diagRe[n], this.diagIm[n]);
        dArray[n][n] = complex2.real();
        dArray2[n][n] = complex2.imag();
        return new ComplexSquareMatrix(dArray, dArray2);
    }
}

