/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.GlobalSettings;
import JSci.maths.DimensionException;
import JSci.maths.ExtraMath;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.ComplexMatrix;
import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.IntegerMatrix;
import JSci.maths.matrices.IntegerMatrixAlgebra;
import JSci.maths.matrices.IntegerSquareMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;
import JSci.maths.vectors.AbstractIntegerVector;
import JSci.maths.vectors.IntegerVector;

public abstract class AbstractIntegerMatrix
extends Matrix {
    protected AbstractIntegerMatrix(int n, int n2) {
        super(n, n2);
    }

    public final boolean equals(Object object) {
        if (object instanceof AbstractIntegerMatrix) {
            return this.equals((AbstractIntegerMatrix)object);
        }
        return false;
    }

    public final boolean equals(AbstractIntegerMatrix abstractIntegerMatrix) {
        return this.equals(abstractIntegerMatrix, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(AbstractIntegerMatrix abstractIntegerMatrix, double d) {
        if (abstractIntegerMatrix != null && this.numRows == abstractIntegerMatrix.rows() && this.numCols == abstractIntegerMatrix.columns()) {
            int n = 0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    int n2 = this.getElement(i, j) - abstractIntegerMatrix.getElement(i, j);
                    n += n2 * n2;
                }
            }
            return (double)n <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                stringBuffer.append(this.getElement(i, j));
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public AbstractDoubleMatrix toDoubleMatrix() {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                dArray[i][j] = this.getElement(i, j);
            }
        }
        return new DoubleMatrix(dArray);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        ComplexMatrix complexMatrix = new ComplexMatrix(this.numRows, this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                complexMatrix.setElement(i, j, this.getElement(i, j), 0.0);
            }
        }
        return complexMatrix;
    }

    public abstract int getElement(int var1, int var2);

    public abstract void setElement(int var1, int var2, int var3);

    public final Object getSet() {
        return IntegerMatrixAlgebra.get(this.numRows, this.numCols);
    }

    public int infNorm() {
        int n = 0;
        for (int i = 0; i < this.numRows; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.numCols; ++j) {
                n2 += Math.abs(this.getElement(i, j));
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                d = ExtraMath.hypot(d, this.getElement(i, j));
            }
        }
        return d;
    }

    public AbelianGroup.Member negate() {
        int[][] nArray = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            nArray[i][0] = -this.getElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                nArray[i][j] = -this.getElement(i, j);
            }
        }
        return new IntegerMatrix(nArray);
    }

    public final AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof AbstractIntegerMatrix) {
            return this.add((AbstractIntegerMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerMatrix add(AbstractIntegerMatrix abstractIntegerMatrix) {
        if (this.numRows == abstractIntegerMatrix.rows() && this.numCols == abstractIntegerMatrix.columns()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                nArray[i][0] = this.getElement(i, 0) + abstractIntegerMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    nArray[i][j] = this.getElement(i, j) + abstractIntegerMatrix.getElement(i, j);
                }
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public final AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof AbstractIntegerMatrix) {
            return this.subtract((AbstractIntegerMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerMatrix subtract(AbstractIntegerMatrix abstractIntegerMatrix) {
        if (this.numRows == abstractIntegerMatrix.rows() && this.numCols == abstractIntegerMatrix.columns()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                nArray[i][0] = this.getElement(i, 0) - abstractIntegerMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    nArray[i][j] = this.getElement(i, j) - abstractIntegerMatrix.getElement(i, j);
                }
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public final Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof Number) {
            return this.scalarMultiply(((Number)((Object)member)).intValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerMatrix scalarMultiply(int n) {
        int[][] nArray = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            nArray[i][0] = n * this.getElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                nArray[i][j] = n * this.getElement(i, j);
            }
        }
        return new IntegerMatrix(nArray);
    }

    public final VectorSpace.Member scalarDivide(Field.Member member) {
        throw new UnsupportedOperationException("Not an algebra");
    }

    public int scalarProduct(AbstractIntegerMatrix abstractIntegerMatrix) {
        if (this.numRows == abstractIntegerMatrix.rows() && this.numCols == abstractIntegerMatrix.columns()) {
            int n = 0;
            for (int i = 0; i < this.numRows; ++i) {
                n += this.getElement(i, 0) * abstractIntegerMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    n += this.getElement(i, j) * abstractIntegerMatrix.getElement(i, j);
                }
            }
            return n;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractIntegerVector multiply(AbstractIntegerVector abstractIntegerVector) {
        if (this.numCols == abstractIntegerVector.dimension()) {
            int[] nArray = new int[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                nArray[i] = this.getElement(i, 0) * abstractIntegerVector.getComponent(0);
                for (int j = 1; j < this.numCols; ++j) {
                    int n = i;
                    nArray[n] = nArray[n] + this.getElement(i, j) * abstractIntegerVector.getComponent(j);
                }
            }
            return new IntegerVector(nArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public final Ring.Member multiply(Ring.Member member) {
        if (member instanceof AbstractIntegerMatrix) {
            return this.multiply((AbstractIntegerMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerMatrix multiply(AbstractIntegerMatrix abstractIntegerMatrix) {
        if (this.numCols == abstractIntegerMatrix.rows()) {
            int n = abstractIntegerMatrix.columns();
            int[][] nArray = new int[this.numRows][n];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < n; ++j) {
                    nArray[i][j] = this.getElement(i, 0) * abstractIntegerMatrix.getElement(0, j);
                    for (int k = 1; k < this.numCols; ++k) {
                        int[] nArray2 = nArray[i];
                        int n2 = j;
                        nArray2[n2] = nArray2[n2] + this.getElement(i, k) * abstractIntegerMatrix.getElement(k, j);
                    }
                }
            }
            if (this.numRows == n) {
                return new IntegerSquareMatrix(nArray);
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractIntegerMatrix directSum(AbstractIntegerMatrix abstractIntegerMatrix) {
        int n;
        int n2;
        int[][] nArray = new int[this.numRows + abstractIntegerMatrix.numRows][this.numCols + abstractIntegerMatrix.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                nArray[n2][n] = this.getElement(n2, n);
            }
        }
        for (n2 = 0; n2 < abstractIntegerMatrix.numRows; ++n2) {
            for (n = 0; n < abstractIntegerMatrix.numCols; ++n) {
                nArray[n2 + this.numRows][n + this.numCols] = abstractIntegerMatrix.getElement(n2, n);
            }
        }
        return new IntegerMatrix(nArray);
    }

    public AbstractIntegerMatrix tensor(AbstractIntegerMatrix abstractIntegerMatrix) {
        int[][] nArray = new int[this.numRows * abstractIntegerMatrix.numRows][this.numCols * abstractIntegerMatrix.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int n = 0;
                while (n < abstractIntegerMatrix.numRows) {
                    for (int k = 0; k < abstractIntegerMatrix.numCols; ++k) {
                        nArray[i * abstractIntegerMatrix.numRows + n][j * abstractIntegerMatrix.numCols + k] = this.getElement(i, j) * abstractIntegerMatrix.getElement(n, k);
                    }
                    ++j;
                }
            }
        }
        return new IntegerMatrix(nArray);
    }

    public Matrix transpose() {
        int[][] nArray = new int[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            nArray[0][i] = this.getElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                nArray[j][i] = this.getElement(i, j);
            }
        }
        return new IntegerMatrix(nArray);
    }
}

