/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.chaos;

import JSci.maths.Complex;
import JSci.maths.ComplexMapping;

public final class MandelbrotMap
implements ComplexMapping {
    public static final double CONVERGENT_BOUND = 2.0;
    private Complex a;

    public MandelbrotMap(double d) {
        this.a = new Complex(d, 0.0);
    }

    public MandelbrotMap(Complex complex) {
        this.a = complex;
    }

    public Complex getConstant() {
        return this.a;
    }

    public void setConstant(Complex complex) {
        this.a = complex;
    }

    public double map(double d) {
        return d * d + this.a.real();
    }

    public Complex map(Complex complex) {
        return this.map(complex.real(), complex.imag());
    }

    public Complex map(double d, double d2) {
        return new Complex(d * d - d2 * d2 + this.a.real(), 2.0 * d * d2 + this.a.imag());
    }

    public double iterate(int n, double d) {
        for (int i = 0; i < n; ++i) {
            d = this.map(d);
        }
        return d;
    }

    public Complex iterate(int n, Complex complex) {
        for (int i = 0; i < n; ++i) {
            complex = this.map(complex);
        }
        return complex;
    }
}

