(defproject e85th/gaia "0.1.0-SNAPSHOT"
  :description "Limited wrapper for geotools lib."
  :url "http://github.com/e85th/gaia"
  :license {:name "Apache License 2.0"
            :url "http://www.apache.org/licenses/LICENSE-2.0"}

  :dependencies [[org.clojure/clojure "1.8.0"]
                 [com.stuartsierra/component "0.3.1"]
                 [com.taoensso/timbre "4.6.0"]
                 [prismatic/schema "1.1.2"]
                 [org.geotools/gt-shapefile "15.1"]
                 [org.geotools/gt-cql "15.1"]]

  :source-paths ["src/clj"]

  :plugins [[com.jakemccrary/lein-test-refresh "0.10.0"]
            [codox "0.8.13"]
            [lein-exec "0.3.6"]
            [lein-version-script "0.1.0"]
            [test2junit "1.1.2"]
            [lein-kibit "0.1.2"] ; static code analyzer for clojure
            [lein-ancient "0.6.7" :exclusions [org.clojure/clojure]]]

  :profiles {:dev  [:project/dev  :profiles/dev]
             :test [:project/test :profiles/test]
             :uberjar {:aot :all}
             :profiles/dev  {}
             :profiles/test {}
             :project/dev   {:dependencies [[reloaded.repl "0.2.2"]
                                            [org.clojure/tools.namespace "0.2.11"]
                                            [org.clojure/tools.nrepl "0.2.12"]]
                             :source-paths   ["dev/src"]
                             :resource-paths ["dev/resources"]
                             :repl-options {:init-ns user}
                             :project/test  {}}}

  :repositories [["osgeo-geotools" {:url "http://download.osgeo.org/webdav/geotools" :sign-releases false}]]
  :codox {:sources ["src/clj"]
          :defaults {:doc "FIXME: write docs"}
          :src-dir-uri "http://github.com/e85th/gaia/blob/master/"
          :src-linenum-anchor-prefix "L"}

  :deploy-repositories [["releases" :clojars]
                        ["snapshots" :clojars]])
