(ns e85th.clj-postgis
  (:require [clojure.java.jdbc :as jdbc]
            [e85th.commons.geo :as geo]))

(defmulti parse-geometry class)

(defmethod parse-geometry org.postgis.Point
  [^org.postgis.Point v]
  (geo/map->Point {:x (.getX v) :y (.getY v)}))

(defmethod parse-geometry :default
  [v]
  ;;(geo/map->Point {:lat (.getX v) :lng (.getY v)})
  (throw (ex-info "Unhandled parse-geometry" {:input v :class (class v)})))

(extend-protocol jdbc/IResultSetReadColumn
  org.postgis.PGgeometry
  (result-set-read-column [^org.postgis.PGgeometry v _ _]
    (parse-geometry (.getGeometry v))))

;; ;; to avoid manually changing from DateTime to timestamp
(extend-type e85th.commons.geo.Point
  jdbc/ISQLParameter
  (set-parameter [v ^java.sql.PreparedStatement stmt idx]
    (.setObject stmt idx (org.postgis.PGgeometry. (org.postgis.Point. (:x v) (:y v))))))
