(ns e85th.backend.core.models
  (:require [clojure.spec.alpha :as s]
            [e85th.commons.email :as email]
            [e85th.commons.tel :as tel]
            [e85th.commons.util :as u]
            [clojure.string :as str])
  (:import [org.joda.time DateTime]))

(def mobile-channel-type-id "mobile phone channel" 1)

(def email-channel-type-id "email channel" 2)

(def email-channel-type-id?
  "Answers if the input integer is an email channel type"
  (partial = email-channel-type-id))

(def email-channel?
  "Answers if the associative data input is an email channel"
  (comp email-channel-type-id? :channel-type-id))

(def channel-type->normalizer
  {email-channel-type-id email/normalize
   mobile-channel-type-id tel/normalize})

(defn normalize-identifier
  [{:keys [channel-type-id identifier] :as ch}]
  (if (str/blank? identifier)
    ch
    (let [f (get channel-type->normalizer channel-type-id identity)]
      (update ch :identifier f))))
