# dvlopt.rxtx



Thin clojure wrapper around [jRxTx](https://github.com/openmuc/jrxtx) for doing
IO on serial ports, it acts as a drop-in replacement for legacy
[RXTX](http://rxtx.qbang.org/wiki/index.php/Main_Page).

Supports a (very) wide variety of platforms.

## Installation

There is a bit of a setup but nothing to worry about, it is fairly easy.

For more information about the process or if something goes wrong, go to
[jRxTx](https://github.com/openmuc/jrxtx).

On a debian based distribution :

```
sudo apt install librxtx-java
```

When starting your application/repl, check if the "java.library.path" property
contains a path to the installed native libs. On debian, that should be
'/usr/lib/jni' :

```clj
(System/getProperty "java.library.path")
```

If this property is not properly set, you must do it yourself.

In your project file :
```clj
:jvm-opts ["-Djava.library.path=/PATH/TO/LIBS"]
```

When executing your uberjar :
```sh
java -Djava.library.path=/PATH/TO/LIBS -jar your_program.jar
```

## Usage

Read the [API](https://dvlopt.github.io/doc/clojure/dvlopt/rxtx/dvlopt.rxtx.html).

```clj
(require '[clotty.core :as serial])


;; get a set of available ports on your machine
(serial/available-ports)


;; open a serial port
(def port (serial/open "/dev/ttyUSB0"
                       {:baud-rate 9600
                        :parity    :none}))


;; re-configure the port on the fly
(serial/configure port
                  {:baud-rate 115200})


;; get a nice description of the port
(serial/describe port)

    
;; write something
(serial/write-bytes port
                    (.getBytes "Hello world!\n\r"))


;; read a single byte with a 2000 ms timeout
(serial/read-byte port
                  2000)


;; check how many more bytes there are to read
(serial/available-bytes port)


;; serial ports are sequable into a byte stream
;; read 8 bytes as chars
(take 8
      (map char
           port))

(first port)
(second port)


;; when you need a timeout on your sequence
(into []
      (comp (take 8)
            (map char))
      (serial/seq-timeout port
                          2000))


;; do not forget to close the port
(serial/close port)
```


## License

Copyright © 2017 Adam Helinski

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
