(ns onto.std
  (:use onto.core))



(defn >0 [?] (> ? 0))

(defn >=0 [?] (>= ? 0))





(-|  ::.Any
  |- any?)

(-|  ::.Nil
  |- nil?)




(-|  ::.Ls
  |- list?)

(-|  ::<>Ls
  |- (|& ::.Any
         (|not ::.Ls)))

(-|  ::.Vec
  |- vector?)

(-|  ::.Map
  |- map?)

(-|  ::.Set
  |- set?)

(-|  ::.Coll
  |- coll?)

(-|  ::.Empty
  |- empty?)

(-|  ::<>Empty
  |- (|& ::.Coll
         (|not ::.Empty)))



(-|  ::.0
  |- #(= % 0)
  |> (constantly 0))


(-|  ::<>0
  |- (|& ::.Num
         (|not ::.0)))



(-| ::.Num
  |- number?)

(-| ::<>Num
  |- (|& ::.Any
         (|not ::.Num)))



(-|  ::.Num.+
  |- (|& ::.Num
         >=0))

(-|  ::.Num.*+
  |- (|& ::.Num.+
         ::<>0))


(-|  ::.Num.-
  |- (|& ::.Num
         (|not ::.Num.*+)))

(-|  ::.Num.*-
  |- (|& ::.Num
         (|not ::.Num.+)))


(-| ::.Ls.Num.+
  |- (|c ::.Num.+))


(-|  ::.Int
  |- int?)

(-|  ::.Int.+
  |- (|& ::.Int
         ::.Num.+))

(-|  ::.Int.*+
  |- (|& ::.Int.+
         ::<>0))

(-|  ::.Int.-
  |- (|& ::.Int
         (|not ::.Int.*+)))

(-|  ::.Int.*-
  |- (|& ::.Int.-
         ::<>0))




(-| ::.Ls.Num
  |- (|c ::.Num))




(-|  ::.Str
  |- string?)

(-|  ::.Str.Empty
  |- #(= % "")
  |> (constantly ""))

(-| ::+Str
  |- (|& ::.Str
         (|not ::.Str.Empty)))
