(ns {{namespace}}.server.pathom-parser
  (:require
    [com.wsscode.pathom.connect :as pc]
    [dv.crux-node :refer [crux-node]]
    [dv.pathom :refer [build-parser]]
    [{{namespace}}.server.task-resolvers :as task]
    [{{namespace}}.auth.session :as session]
    [{{namespace}}.auth.user :as user]
    [{{namespace}}.server.config :refer [config]]))

(def all-resolvers
  [session/resolvers
   user/resolvers
   task/resolvers])

(def parser
  (build-parser
    {:resolvers          all-resolvers
     :trace?             (-> config ::config :trace?)
     :index-explorer?    (-> config ::config :index-explorer?)
     :log-responses?     (-> config ::config :log-responses?)
     :enable-pathom-viz? (-> config ::config :connect-viz?)
     :env-additions      (fn [env] {:crux-node    crux-node
                                    :config       config
                                    :current-user (user/get-current-user env)})}))
