(ns {{namespace}}.pathom-resolvers
  (:require
    [clojure.core.async :refer [go <! <!! >! >!! chan]]
    [clojure.pprint :refer [pprint]]
    [clojure.spec.alpha :as s]
    [com.fulcrologic.guardrails.core :refer [>defn >def | => ?]]
    [com.wsscode.pathom.connect :as pc]
    [{{namespace}}.auth.user :as user]
    [{{namespace}}.data-model.task :as dm]
    [{{namespace}}.db-layer :as dl]
    [dv.clj-utils.crux-util :as cu]
    [taoensso.timbre :as log]))

(defmacro validity-check
  [& args]
  `(when-let
     [msg# (cond ~@args)]
     (fu/server-error msg#)))

(defn conj-vec [entity fkw val]
  (update entity fkw #(conj (or % []) val)))

(defn conj-set [entity fkw val]
  (update entity fkw #(conj (or (set %) #{}) val)))

(pc/defmutation create-task-mutation
  [{:keys [current-user crux-node]}
   {:task/keys [id description] :as props}]
  {::pc/sym 'dv.play-app.client.ui.task-item/create-task}
  (let [user-tasks (:user/tasks current-user)]
    (log/info "props: ") (pprint props)
    (or
      (validity-check
        (not current-user) "You must be logged in to create a task."
        (not (s/valid? ::dm/task props)) "Task is invalid"
        (dl/get-task-by-description user-tasks description)
        "A task with that description already exists.")

      (let [task (dm/make-db-task props)
            new-user (dl/read-merge-user (conj-vec current-user :user/tasks id))]
        (log/info "Submitting tx for creating task")
        (pprint [task new-user])
        (cu/put-all crux-node [task new-user])))))

(pc/defresolver get-task [{:keys [crux-node]} {:task/keys [id]}]
  {::pc/input #{:task/id}
   ::pc/output [:task/description]}
  (log/info "in task-resolver id: " id)
  (dl/get-task id))

(defn user-all-tasks [user]
  (cu/join-ref :task/id (:user/tasks user)))

(def resolvers [create-task-mutation get-task user-all-tasks])
