goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_52473 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_52473(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_52475 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_52475(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__51667 = coll;
var G__51668 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__51667,G__51668) : shadow.dom.lazy_native_coll_seq.call(null,G__51667,G__51668));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__51692 = arguments.length;
switch (G__51692) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__51698 = arguments.length;
switch (G__51698) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__51703 = arguments.length;
switch (G__51703) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__51711 = arguments.length;
switch (G__51711) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__51725 = arguments.length;
switch (G__51725) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__51740 = arguments.length;
switch (G__51740) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e51750){if((e51750 instanceof Object)){
var e = e51750;
return console.log("didnt support attachEvent",el,e);
} else {
throw e51750;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__51759 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__51760 = null;
var count__51761 = (0);
var i__51762 = (0);
while(true){
if((i__51762 < count__51761)){
var el = chunk__51760.cljs$core$IIndexed$_nth$arity$2(null,i__51762);
var handler_52499__$1 = ((function (seq__51759,chunk__51760,count__51761,i__51762,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__51759,chunk__51760,count__51761,i__51762,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_52499__$1);


var G__52500 = seq__51759;
var G__52501 = chunk__51760;
var G__52502 = count__51761;
var G__52503 = (i__51762 + (1));
seq__51759 = G__52500;
chunk__51760 = G__52501;
count__51761 = G__52502;
i__51762 = G__52503;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__51759);
if(temp__5735__auto__){
var seq__51759__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51759__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__51759__$1);
var G__52505 = cljs.core.chunk_rest(seq__51759__$1);
var G__52506 = c__4556__auto__;
var G__52507 = cljs.core.count(c__4556__auto__);
var G__52508 = (0);
seq__51759 = G__52505;
chunk__51760 = G__52506;
count__51761 = G__52507;
i__51762 = G__52508;
continue;
} else {
var el = cljs.core.first(seq__51759__$1);
var handler_52509__$1 = ((function (seq__51759,chunk__51760,count__51761,i__51762,el,seq__51759__$1,temp__5735__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__51759,chunk__51760,count__51761,i__51762,el,seq__51759__$1,temp__5735__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_52509__$1);


var G__52510 = cljs.core.next(seq__51759__$1);
var G__52511 = null;
var G__52512 = (0);
var G__52513 = (0);
seq__51759 = G__52510;
chunk__51760 = G__52511;
count__51761 = G__52512;
i__51762 = G__52513;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__51775 = arguments.length;
switch (G__51775) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__51780 = cljs.core.seq(events);
var chunk__51781 = null;
var count__51782 = (0);
var i__51783 = (0);
while(true){
if((i__51783 < count__51782)){
var vec__51796 = chunk__51781.cljs$core$IIndexed$_nth$arity$2(null,i__51783);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51796,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51796,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__52519 = seq__51780;
var G__52520 = chunk__51781;
var G__52521 = count__51782;
var G__52522 = (i__51783 + (1));
seq__51780 = G__52519;
chunk__51781 = G__52520;
count__51782 = G__52521;
i__51783 = G__52522;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__51780);
if(temp__5735__auto__){
var seq__51780__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51780__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__51780__$1);
var G__52524 = cljs.core.chunk_rest(seq__51780__$1);
var G__52525 = c__4556__auto__;
var G__52526 = cljs.core.count(c__4556__auto__);
var G__52527 = (0);
seq__51780 = G__52524;
chunk__51781 = G__52525;
count__51782 = G__52526;
i__51783 = G__52527;
continue;
} else {
var vec__51803 = cljs.core.first(seq__51780__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51803,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51803,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__52530 = cljs.core.next(seq__51780__$1);
var G__52531 = null;
var G__52532 = (0);
var G__52533 = (0);
seq__51780 = G__52530;
chunk__51781 = G__52531;
count__51782 = G__52532;
i__51783 = G__52533;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__51807 = cljs.core.seq(styles);
var chunk__51808 = null;
var count__51809 = (0);
var i__51810 = (0);
while(true){
if((i__51810 < count__51809)){
var vec__51834 = chunk__51808.cljs$core$IIndexed$_nth$arity$2(null,i__51810);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51834,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51834,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__52537 = seq__51807;
var G__52538 = chunk__51808;
var G__52539 = count__51809;
var G__52540 = (i__51810 + (1));
seq__51807 = G__52537;
chunk__51808 = G__52538;
count__51809 = G__52539;
i__51810 = G__52540;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__51807);
if(temp__5735__auto__){
var seq__51807__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51807__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__51807__$1);
var G__52543 = cljs.core.chunk_rest(seq__51807__$1);
var G__52544 = c__4556__auto__;
var G__52545 = cljs.core.count(c__4556__auto__);
var G__52546 = (0);
seq__51807 = G__52543;
chunk__51808 = G__52544;
count__51809 = G__52545;
i__51810 = G__52546;
continue;
} else {
var vec__51839 = cljs.core.first(seq__51807__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51839,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51839,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__52549 = cljs.core.next(seq__51807__$1);
var G__52550 = null;
var G__52551 = (0);
var G__52552 = (0);
seq__51807 = G__52549;
chunk__51808 = G__52550;
count__51809 = G__52551;
i__51810 = G__52552;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__51849_52554 = key;
var G__51849_52555__$1 = (((G__51849_52554 instanceof cljs.core.Keyword))?G__51849_52554.fqn:null);
switch (G__51849_52555__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_52560 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_52560,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_52560,"aria-");
}
})())){
el.setAttribute(ks_52560,value);
} else {
(el[ks_52560] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__51877){
var map__51878 = p__51877;
var map__51878__$1 = (((((!((map__51878 == null))))?(((((map__51878.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51878.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51878):map__51878);
var props = map__51878__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51878__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__51887 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51887,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51887,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51887,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__51890 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__51890,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__51890;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__51897 = arguments.length;
switch (G__51897) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__51909){
var vec__51910 = p__51909;
var seq__51911 = cljs.core.seq(vec__51910);
var first__51912 = cljs.core.first(seq__51911);
var seq__51911__$1 = cljs.core.next(seq__51911);
var nn = first__51912;
var first__51912__$1 = cljs.core.first(seq__51911__$1);
var seq__51911__$2 = cljs.core.next(seq__51911__$1);
var np = first__51912__$1;
var nc = seq__51911__$2;
var node = vec__51910;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__51922 = nn;
var G__51923 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__51922,G__51923) : create_fn.call(null,G__51922,G__51923));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__51925 = nn;
var G__51926 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__51925,G__51926) : create_fn.call(null,G__51925,G__51926));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__51929 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51929,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51929,(1),null);
var seq__51938_52584 = cljs.core.seq(node_children);
var chunk__51939_52585 = null;
var count__51940_52586 = (0);
var i__51941_52587 = (0);
while(true){
if((i__51941_52587 < count__51940_52586)){
var child_struct_52589 = chunk__51939_52585.cljs$core$IIndexed$_nth$arity$2(null,i__51941_52587);
var children_52590 = shadow.dom.dom_node(child_struct_52589);
if(cljs.core.seq_QMARK_(children_52590)){
var seq__51973_52591 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_52590));
var chunk__51975_52592 = null;
var count__51976_52593 = (0);
var i__51977_52594 = (0);
while(true){
if((i__51977_52594 < count__51976_52593)){
var child_52596 = chunk__51975_52592.cljs$core$IIndexed$_nth$arity$2(null,i__51977_52594);
if(cljs.core.truth_(child_52596)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52596);


var G__52598 = seq__51973_52591;
var G__52599 = chunk__51975_52592;
var G__52600 = count__51976_52593;
var G__52601 = (i__51977_52594 + (1));
seq__51973_52591 = G__52598;
chunk__51975_52592 = G__52599;
count__51976_52593 = G__52600;
i__51977_52594 = G__52601;
continue;
} else {
var G__52604 = seq__51973_52591;
var G__52605 = chunk__51975_52592;
var G__52606 = count__51976_52593;
var G__52607 = (i__51977_52594 + (1));
seq__51973_52591 = G__52604;
chunk__51975_52592 = G__52605;
count__51976_52593 = G__52606;
i__51977_52594 = G__52607;
continue;
}
} else {
var temp__5735__auto___52609 = cljs.core.seq(seq__51973_52591);
if(temp__5735__auto___52609){
var seq__51973_52611__$1 = temp__5735__auto___52609;
if(cljs.core.chunked_seq_QMARK_(seq__51973_52611__$1)){
var c__4556__auto___52612 = cljs.core.chunk_first(seq__51973_52611__$1);
var G__52613 = cljs.core.chunk_rest(seq__51973_52611__$1);
var G__52614 = c__4556__auto___52612;
var G__52615 = cljs.core.count(c__4556__auto___52612);
var G__52616 = (0);
seq__51973_52591 = G__52613;
chunk__51975_52592 = G__52614;
count__51976_52593 = G__52615;
i__51977_52594 = G__52616;
continue;
} else {
var child_52617 = cljs.core.first(seq__51973_52611__$1);
if(cljs.core.truth_(child_52617)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52617);


var G__52618 = cljs.core.next(seq__51973_52611__$1);
var G__52619 = null;
var G__52620 = (0);
var G__52621 = (0);
seq__51973_52591 = G__52618;
chunk__51975_52592 = G__52619;
count__51976_52593 = G__52620;
i__51977_52594 = G__52621;
continue;
} else {
var G__52623 = cljs.core.next(seq__51973_52611__$1);
var G__52624 = null;
var G__52625 = (0);
var G__52626 = (0);
seq__51973_52591 = G__52623;
chunk__51975_52592 = G__52624;
count__51976_52593 = G__52625;
i__51977_52594 = G__52626;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_52590);
}


var G__52629 = seq__51938_52584;
var G__52630 = chunk__51939_52585;
var G__52631 = count__51940_52586;
var G__52632 = (i__51941_52587 + (1));
seq__51938_52584 = G__52629;
chunk__51939_52585 = G__52630;
count__51940_52586 = G__52631;
i__51941_52587 = G__52632;
continue;
} else {
var temp__5735__auto___52634 = cljs.core.seq(seq__51938_52584);
if(temp__5735__auto___52634){
var seq__51938_52636__$1 = temp__5735__auto___52634;
if(cljs.core.chunked_seq_QMARK_(seq__51938_52636__$1)){
var c__4556__auto___52638 = cljs.core.chunk_first(seq__51938_52636__$1);
var G__52639 = cljs.core.chunk_rest(seq__51938_52636__$1);
var G__52640 = c__4556__auto___52638;
var G__52641 = cljs.core.count(c__4556__auto___52638);
var G__52642 = (0);
seq__51938_52584 = G__52639;
chunk__51939_52585 = G__52640;
count__51940_52586 = G__52641;
i__51941_52587 = G__52642;
continue;
} else {
var child_struct_52643 = cljs.core.first(seq__51938_52636__$1);
var children_52644 = shadow.dom.dom_node(child_struct_52643);
if(cljs.core.seq_QMARK_(children_52644)){
var seq__51987_52645 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_52644));
var chunk__51989_52646 = null;
var count__51990_52647 = (0);
var i__51991_52648 = (0);
while(true){
if((i__51991_52648 < count__51990_52647)){
var child_52650 = chunk__51989_52646.cljs$core$IIndexed$_nth$arity$2(null,i__51991_52648);
if(cljs.core.truth_(child_52650)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52650);


var G__52653 = seq__51987_52645;
var G__52654 = chunk__51989_52646;
var G__52655 = count__51990_52647;
var G__52656 = (i__51991_52648 + (1));
seq__51987_52645 = G__52653;
chunk__51989_52646 = G__52654;
count__51990_52647 = G__52655;
i__51991_52648 = G__52656;
continue;
} else {
var G__52659 = seq__51987_52645;
var G__52660 = chunk__51989_52646;
var G__52661 = count__51990_52647;
var G__52662 = (i__51991_52648 + (1));
seq__51987_52645 = G__52659;
chunk__51989_52646 = G__52660;
count__51990_52647 = G__52661;
i__51991_52648 = G__52662;
continue;
}
} else {
var temp__5735__auto___52663__$1 = cljs.core.seq(seq__51987_52645);
if(temp__5735__auto___52663__$1){
var seq__51987_52664__$1 = temp__5735__auto___52663__$1;
if(cljs.core.chunked_seq_QMARK_(seq__51987_52664__$1)){
var c__4556__auto___52665 = cljs.core.chunk_first(seq__51987_52664__$1);
var G__52666 = cljs.core.chunk_rest(seq__51987_52664__$1);
var G__52667 = c__4556__auto___52665;
var G__52668 = cljs.core.count(c__4556__auto___52665);
var G__52669 = (0);
seq__51987_52645 = G__52666;
chunk__51989_52646 = G__52667;
count__51990_52647 = G__52668;
i__51991_52648 = G__52669;
continue;
} else {
var child_52670 = cljs.core.first(seq__51987_52664__$1);
if(cljs.core.truth_(child_52670)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52670);


var G__52673 = cljs.core.next(seq__51987_52664__$1);
var G__52674 = null;
var G__52675 = (0);
var G__52676 = (0);
seq__51987_52645 = G__52673;
chunk__51989_52646 = G__52674;
count__51990_52647 = G__52675;
i__51991_52648 = G__52676;
continue;
} else {
var G__52678 = cljs.core.next(seq__51987_52664__$1);
var G__52679 = null;
var G__52680 = (0);
var G__52681 = (0);
seq__51987_52645 = G__52678;
chunk__51989_52646 = G__52679;
count__51990_52647 = G__52680;
i__51991_52648 = G__52681;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_52644);
}


var G__52684 = cljs.core.next(seq__51938_52636__$1);
var G__52685 = null;
var G__52686 = (0);
var G__52687 = (0);
seq__51938_52584 = G__52684;
chunk__51939_52585 = G__52685;
count__51940_52586 = G__52686;
i__51941_52587 = G__52687;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__52078 = cljs.core.seq(node);
var chunk__52079 = null;
var count__52080 = (0);
var i__52081 = (0);
while(true){
if((i__52081 < count__52080)){
var n = chunk__52079.cljs$core$IIndexed$_nth$arity$2(null,i__52081);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__52705 = seq__52078;
var G__52706 = chunk__52079;
var G__52707 = count__52080;
var G__52708 = (i__52081 + (1));
seq__52078 = G__52705;
chunk__52079 = G__52706;
count__52080 = G__52707;
i__52081 = G__52708;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__52078);
if(temp__5735__auto__){
var seq__52078__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__52078__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__52078__$1);
var G__52713 = cljs.core.chunk_rest(seq__52078__$1);
var G__52714 = c__4556__auto__;
var G__52715 = cljs.core.count(c__4556__auto__);
var G__52716 = (0);
seq__52078 = G__52713;
chunk__52079 = G__52714;
count__52080 = G__52715;
i__52081 = G__52716;
continue;
} else {
var n = cljs.core.first(seq__52078__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__52719 = cljs.core.next(seq__52078__$1);
var G__52720 = null;
var G__52721 = (0);
var G__52722 = (0);
seq__52078 = G__52719;
chunk__52079 = G__52720;
count__52080 = G__52721;
i__52081 = G__52722;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__52095 = arguments.length;
switch (G__52095) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__52097 = arguments.length;
switch (G__52097) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__52102 = arguments.length;
switch (G__52102) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___52757 = arguments.length;
var i__4737__auto___52758 = (0);
while(true){
if((i__4737__auto___52758 < len__4736__auto___52757)){
args__4742__auto__.push((arguments[i__4737__auto___52758]));

var G__52759 = (i__4737__auto___52758 + (1));
i__4737__auto___52758 = G__52759;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__52114_52771 = cljs.core.seq(nodes);
var chunk__52115_52772 = null;
var count__52116_52773 = (0);
var i__52117_52774 = (0);
while(true){
if((i__52117_52774 < count__52116_52773)){
var node_52776 = chunk__52115_52772.cljs$core$IIndexed$_nth$arity$2(null,i__52117_52774);
fragment.appendChild(shadow.dom._to_dom(node_52776));


var G__52778 = seq__52114_52771;
var G__52779 = chunk__52115_52772;
var G__52780 = count__52116_52773;
var G__52781 = (i__52117_52774 + (1));
seq__52114_52771 = G__52778;
chunk__52115_52772 = G__52779;
count__52116_52773 = G__52780;
i__52117_52774 = G__52781;
continue;
} else {
var temp__5735__auto___52784 = cljs.core.seq(seq__52114_52771);
if(temp__5735__auto___52784){
var seq__52114_52785__$1 = temp__5735__auto___52784;
if(cljs.core.chunked_seq_QMARK_(seq__52114_52785__$1)){
var c__4556__auto___52786 = cljs.core.chunk_first(seq__52114_52785__$1);
var G__52788 = cljs.core.chunk_rest(seq__52114_52785__$1);
var G__52789 = c__4556__auto___52786;
var G__52790 = cljs.core.count(c__4556__auto___52786);
var G__52791 = (0);
seq__52114_52771 = G__52788;
chunk__52115_52772 = G__52789;
count__52116_52773 = G__52790;
i__52117_52774 = G__52791;
continue;
} else {
var node_52793 = cljs.core.first(seq__52114_52785__$1);
fragment.appendChild(shadow.dom._to_dom(node_52793));


var G__52794 = cljs.core.next(seq__52114_52785__$1);
var G__52795 = null;
var G__52796 = (0);
var G__52797 = (0);
seq__52114_52771 = G__52794;
chunk__52115_52772 = G__52795;
count__52116_52773 = G__52796;
i__52117_52774 = G__52797;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq52109){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq52109));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__52130_52803 = cljs.core.seq(scripts);
var chunk__52131_52804 = null;
var count__52132_52805 = (0);
var i__52133_52806 = (0);
while(true){
if((i__52133_52806 < count__52132_52805)){
var vec__52142_52809 = chunk__52131_52804.cljs$core$IIndexed$_nth$arity$2(null,i__52133_52806);
var script_tag_52810 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52142_52809,(0),null);
var script_body_52811 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52142_52809,(1),null);
eval(script_body_52811);


var G__52814 = seq__52130_52803;
var G__52815 = chunk__52131_52804;
var G__52816 = count__52132_52805;
var G__52817 = (i__52133_52806 + (1));
seq__52130_52803 = G__52814;
chunk__52131_52804 = G__52815;
count__52132_52805 = G__52816;
i__52133_52806 = G__52817;
continue;
} else {
var temp__5735__auto___52820 = cljs.core.seq(seq__52130_52803);
if(temp__5735__auto___52820){
var seq__52130_52821__$1 = temp__5735__auto___52820;
if(cljs.core.chunked_seq_QMARK_(seq__52130_52821__$1)){
var c__4556__auto___52822 = cljs.core.chunk_first(seq__52130_52821__$1);
var G__52823 = cljs.core.chunk_rest(seq__52130_52821__$1);
var G__52824 = c__4556__auto___52822;
var G__52825 = cljs.core.count(c__4556__auto___52822);
var G__52826 = (0);
seq__52130_52803 = G__52823;
chunk__52131_52804 = G__52824;
count__52132_52805 = G__52825;
i__52133_52806 = G__52826;
continue;
} else {
var vec__52146_52827 = cljs.core.first(seq__52130_52821__$1);
var script_tag_52828 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52146_52827,(0),null);
var script_body_52829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52146_52827,(1),null);
eval(script_body_52829);


var G__52830 = cljs.core.next(seq__52130_52821__$1);
var G__52831 = null;
var G__52832 = (0);
var G__52833 = (0);
seq__52130_52803 = G__52830;
chunk__52131_52804 = G__52831;
count__52132_52805 = G__52832;
i__52133_52806 = G__52833;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__52150){
var vec__52151 = p__52150;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52151,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52151,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__52157 = arguments.length;
switch (G__52157) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__52160 = cljs.core.seq(style_keys);
var chunk__52161 = null;
var count__52162 = (0);
var i__52163 = (0);
while(true){
if((i__52163 < count__52162)){
var it = chunk__52161.cljs$core$IIndexed$_nth$arity$2(null,i__52163);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__52864 = seq__52160;
var G__52865 = chunk__52161;
var G__52866 = count__52162;
var G__52867 = (i__52163 + (1));
seq__52160 = G__52864;
chunk__52161 = G__52865;
count__52162 = G__52866;
i__52163 = G__52867;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__52160);
if(temp__5735__auto__){
var seq__52160__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__52160__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__52160__$1);
var G__52869 = cljs.core.chunk_rest(seq__52160__$1);
var G__52870 = c__4556__auto__;
var G__52871 = cljs.core.count(c__4556__auto__);
var G__52872 = (0);
seq__52160 = G__52869;
chunk__52161 = G__52870;
count__52162 = G__52871;
i__52163 = G__52872;
continue;
} else {
var it = cljs.core.first(seq__52160__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__52873 = cljs.core.next(seq__52160__$1);
var G__52874 = null;
var G__52875 = (0);
var G__52876 = (0);
seq__52160 = G__52873;
chunk__52161 = G__52874;
count__52162 = G__52875;
i__52163 = G__52876;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k52166,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__52171 = k52166;
var G__52171__$1 = (((G__52171 instanceof cljs.core.Keyword))?G__52171.fqn:null);
switch (G__52171__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k52166,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__52173){
var vec__52174 = p__52173;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52174,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52174,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__52165){
var self__ = this;
var G__52165__$1 = this;
return (new cljs.core.RecordIter((0),G__52165__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this52167,other52168){
var self__ = this;
var this52167__$1 = this;
return (((!((other52168 == null)))) && ((this52167__$1.constructor === other52168.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this52167__$1.x,other52168.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this52167__$1.y,other52168.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this52167__$1.__extmap,other52168.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__52165){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__52188 = cljs.core.keyword_identical_QMARK_;
var expr__52189 = k__4388__auto__;
if(cljs.core.truth_((pred__52188.cljs$core$IFn$_invoke$arity$2 ? pred__52188.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__52189) : pred__52188.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__52189)))){
return (new shadow.dom.Coordinate(G__52165,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__52188.cljs$core$IFn$_invoke$arity$2 ? pred__52188.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__52189) : pred__52188.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__52189)))){
return (new shadow.dom.Coordinate(self__.x,G__52165,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__52165),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__52165){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__52165,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__52170){
var extmap__4419__auto__ = (function (){var G__52195 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__52170,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__52170)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__52195);
} else {
return G__52195;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__52170),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__52170),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k52198,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__52207 = k52198;
var G__52207__$1 = (((G__52207 instanceof cljs.core.Keyword))?G__52207.fqn:null);
switch (G__52207__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k52198,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__52208){
var vec__52209 = p__52208;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52209,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52209,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__52197){
var self__ = this;
var G__52197__$1 = this;
return (new cljs.core.RecordIter((0),G__52197__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this52199,other52200){
var self__ = this;
var this52199__$1 = this;
return (((!((other52200 == null)))) && ((this52199__$1.constructor === other52200.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this52199__$1.w,other52200.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this52199__$1.h,other52200.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this52199__$1.__extmap,other52200.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__52197){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__52219 = cljs.core.keyword_identical_QMARK_;
var expr__52220 = k__4388__auto__;
if(cljs.core.truth_((pred__52219.cljs$core$IFn$_invoke$arity$2 ? pred__52219.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__52220) : pred__52219.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__52220)))){
return (new shadow.dom.Size(G__52197,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__52219.cljs$core$IFn$_invoke$arity$2 ? pred__52219.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__52220) : pred__52219.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__52220)))){
return (new shadow.dom.Size(self__.w,G__52197,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__52197),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__52197){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__52197,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__52203){
var extmap__4419__auto__ = (function (){var G__52223 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__52203,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__52203)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__52223);
} else {
return G__52223;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__52203),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__52203),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__52977 = (i + (1));
var G__52978 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__52977;
ret = G__52978;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__52239){
var vec__52240 = p__52239;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52240,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52240,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__52244 = arguments.length;
switch (G__52244) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5733__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5733__auto__)){
var child = temp__5733__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__52990 = ps;
var G__52991 = (i + (1));
el__$1 = G__52990;
i = G__52991;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__52280 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52280,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52280,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52280,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__52297_52995 = cljs.core.seq(props);
var chunk__52299_52996 = null;
var count__52300_52997 = (0);
var i__52301_52998 = (0);
while(true){
if((i__52301_52998 < count__52300_52997)){
var vec__52312_52999 = chunk__52299_52996.cljs$core$IIndexed$_nth$arity$2(null,i__52301_52998);
var k_53000 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52312_52999,(0),null);
var v_53001 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52312_52999,(1),null);
el.setAttributeNS((function (){var temp__5735__auto__ = cljs.core.namespace(k_53000);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_53000),v_53001);


var G__53003 = seq__52297_52995;
var G__53004 = chunk__52299_52996;
var G__53005 = count__52300_52997;
var G__53006 = (i__52301_52998 + (1));
seq__52297_52995 = G__53003;
chunk__52299_52996 = G__53004;
count__52300_52997 = G__53005;
i__52301_52998 = G__53006;
continue;
} else {
var temp__5735__auto___53007 = cljs.core.seq(seq__52297_52995);
if(temp__5735__auto___53007){
var seq__52297_53008__$1 = temp__5735__auto___53007;
if(cljs.core.chunked_seq_QMARK_(seq__52297_53008__$1)){
var c__4556__auto___53010 = cljs.core.chunk_first(seq__52297_53008__$1);
var G__53014 = cljs.core.chunk_rest(seq__52297_53008__$1);
var G__53015 = c__4556__auto___53010;
var G__53016 = cljs.core.count(c__4556__auto___53010);
var G__53017 = (0);
seq__52297_52995 = G__53014;
chunk__52299_52996 = G__53015;
count__52300_52997 = G__53016;
i__52301_52998 = G__53017;
continue;
} else {
var vec__52319_53018 = cljs.core.first(seq__52297_53008__$1);
var k_53019 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52319_53018,(0),null);
var v_53020 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52319_53018,(1),null);
el.setAttributeNS((function (){var temp__5735__auto____$1 = cljs.core.namespace(k_53019);
if(cljs.core.truth_(temp__5735__auto____$1)){
var ns = temp__5735__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_53019),v_53020);


var G__53021 = cljs.core.next(seq__52297_53008__$1);
var G__53022 = null;
var G__53023 = (0);
var G__53024 = (0);
seq__52297_52995 = G__53021;
chunk__52299_52996 = G__53022;
count__52300_52997 = G__53023;
i__52301_52998 = G__53024;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__52327 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52327,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52327,(1),null);
var seq__52331_53025 = cljs.core.seq(node_children);
var chunk__52333_53026 = null;
var count__52334_53027 = (0);
var i__52335_53028 = (0);
while(true){
if((i__52335_53028 < count__52334_53027)){
var child_struct_53029 = chunk__52333_53026.cljs$core$IIndexed$_nth$arity$2(null,i__52335_53028);
if((!((child_struct_53029 == null)))){
if(typeof child_struct_53029 === 'string'){
var text_53030 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_53030),child_struct_53029].join(''));
} else {
var children_53031 = shadow.dom.svg_node(child_struct_53029);
if(cljs.core.seq_QMARK_(children_53031)){
var seq__52364_53033 = cljs.core.seq(children_53031);
var chunk__52366_53034 = null;
var count__52367_53035 = (0);
var i__52368_53036 = (0);
while(true){
if((i__52368_53036 < count__52367_53035)){
var child_53037 = chunk__52366_53034.cljs$core$IIndexed$_nth$arity$2(null,i__52368_53036);
if(cljs.core.truth_(child_53037)){
node.appendChild(child_53037);


var G__53038 = seq__52364_53033;
var G__53039 = chunk__52366_53034;
var G__53040 = count__52367_53035;
var G__53041 = (i__52368_53036 + (1));
seq__52364_53033 = G__53038;
chunk__52366_53034 = G__53039;
count__52367_53035 = G__53040;
i__52368_53036 = G__53041;
continue;
} else {
var G__53044 = seq__52364_53033;
var G__53045 = chunk__52366_53034;
var G__53046 = count__52367_53035;
var G__53047 = (i__52368_53036 + (1));
seq__52364_53033 = G__53044;
chunk__52366_53034 = G__53045;
count__52367_53035 = G__53046;
i__52368_53036 = G__53047;
continue;
}
} else {
var temp__5735__auto___53049 = cljs.core.seq(seq__52364_53033);
if(temp__5735__auto___53049){
var seq__52364_53050__$1 = temp__5735__auto___53049;
if(cljs.core.chunked_seq_QMARK_(seq__52364_53050__$1)){
var c__4556__auto___53051 = cljs.core.chunk_first(seq__52364_53050__$1);
var G__53052 = cljs.core.chunk_rest(seq__52364_53050__$1);
var G__53053 = c__4556__auto___53051;
var G__53054 = cljs.core.count(c__4556__auto___53051);
var G__53055 = (0);
seq__52364_53033 = G__53052;
chunk__52366_53034 = G__53053;
count__52367_53035 = G__53054;
i__52368_53036 = G__53055;
continue;
} else {
var child_53056 = cljs.core.first(seq__52364_53050__$1);
if(cljs.core.truth_(child_53056)){
node.appendChild(child_53056);


var G__53057 = cljs.core.next(seq__52364_53050__$1);
var G__53058 = null;
var G__53059 = (0);
var G__53060 = (0);
seq__52364_53033 = G__53057;
chunk__52366_53034 = G__53058;
count__52367_53035 = G__53059;
i__52368_53036 = G__53060;
continue;
} else {
var G__53061 = cljs.core.next(seq__52364_53050__$1);
var G__53062 = null;
var G__53063 = (0);
var G__53064 = (0);
seq__52364_53033 = G__53061;
chunk__52366_53034 = G__53062;
count__52367_53035 = G__53063;
i__52368_53036 = G__53064;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_53031);
}
}


var G__53069 = seq__52331_53025;
var G__53070 = chunk__52333_53026;
var G__53071 = count__52334_53027;
var G__53072 = (i__52335_53028 + (1));
seq__52331_53025 = G__53069;
chunk__52333_53026 = G__53070;
count__52334_53027 = G__53071;
i__52335_53028 = G__53072;
continue;
} else {
var G__53074 = seq__52331_53025;
var G__53075 = chunk__52333_53026;
var G__53076 = count__52334_53027;
var G__53077 = (i__52335_53028 + (1));
seq__52331_53025 = G__53074;
chunk__52333_53026 = G__53075;
count__52334_53027 = G__53076;
i__52335_53028 = G__53077;
continue;
}
} else {
var temp__5735__auto___53078 = cljs.core.seq(seq__52331_53025);
if(temp__5735__auto___53078){
var seq__52331_53079__$1 = temp__5735__auto___53078;
if(cljs.core.chunked_seq_QMARK_(seq__52331_53079__$1)){
var c__4556__auto___53080 = cljs.core.chunk_first(seq__52331_53079__$1);
var G__53081 = cljs.core.chunk_rest(seq__52331_53079__$1);
var G__53082 = c__4556__auto___53080;
var G__53083 = cljs.core.count(c__4556__auto___53080);
var G__53084 = (0);
seq__52331_53025 = G__53081;
chunk__52333_53026 = G__53082;
count__52334_53027 = G__53083;
i__52335_53028 = G__53084;
continue;
} else {
var child_struct_53085 = cljs.core.first(seq__52331_53079__$1);
if((!((child_struct_53085 == null)))){
if(typeof child_struct_53085 === 'string'){
var text_53086 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_53086),child_struct_53085].join(''));
} else {
var children_53087 = shadow.dom.svg_node(child_struct_53085);
if(cljs.core.seq_QMARK_(children_53087)){
var seq__52380_53089 = cljs.core.seq(children_53087);
var chunk__52382_53090 = null;
var count__52383_53091 = (0);
var i__52384_53092 = (0);
while(true){
if((i__52384_53092 < count__52383_53091)){
var child_53093 = chunk__52382_53090.cljs$core$IIndexed$_nth$arity$2(null,i__52384_53092);
if(cljs.core.truth_(child_53093)){
node.appendChild(child_53093);


var G__53094 = seq__52380_53089;
var G__53095 = chunk__52382_53090;
var G__53096 = count__52383_53091;
var G__53097 = (i__52384_53092 + (1));
seq__52380_53089 = G__53094;
chunk__52382_53090 = G__53095;
count__52383_53091 = G__53096;
i__52384_53092 = G__53097;
continue;
} else {
var G__53098 = seq__52380_53089;
var G__53099 = chunk__52382_53090;
var G__53100 = count__52383_53091;
var G__53101 = (i__52384_53092 + (1));
seq__52380_53089 = G__53098;
chunk__52382_53090 = G__53099;
count__52383_53091 = G__53100;
i__52384_53092 = G__53101;
continue;
}
} else {
var temp__5735__auto___53103__$1 = cljs.core.seq(seq__52380_53089);
if(temp__5735__auto___53103__$1){
var seq__52380_53104__$1 = temp__5735__auto___53103__$1;
if(cljs.core.chunked_seq_QMARK_(seq__52380_53104__$1)){
var c__4556__auto___53105 = cljs.core.chunk_first(seq__52380_53104__$1);
var G__53106 = cljs.core.chunk_rest(seq__52380_53104__$1);
var G__53107 = c__4556__auto___53105;
var G__53108 = cljs.core.count(c__4556__auto___53105);
var G__53109 = (0);
seq__52380_53089 = G__53106;
chunk__52382_53090 = G__53107;
count__52383_53091 = G__53108;
i__52384_53092 = G__53109;
continue;
} else {
var child_53110 = cljs.core.first(seq__52380_53104__$1);
if(cljs.core.truth_(child_53110)){
node.appendChild(child_53110);


var G__53111 = cljs.core.next(seq__52380_53104__$1);
var G__53112 = null;
var G__53113 = (0);
var G__53114 = (0);
seq__52380_53089 = G__53111;
chunk__52382_53090 = G__53112;
count__52383_53091 = G__53113;
i__52384_53092 = G__53114;
continue;
} else {
var G__53115 = cljs.core.next(seq__52380_53104__$1);
var G__53116 = null;
var G__53117 = (0);
var G__53118 = (0);
seq__52380_53089 = G__53115;
chunk__52382_53090 = G__53116;
count__52383_53091 = G__53117;
i__52384_53092 = G__53118;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_53087);
}
}


var G__53119 = cljs.core.next(seq__52331_53079__$1);
var G__53120 = null;
var G__53121 = (0);
var G__53122 = (0);
seq__52331_53025 = G__53119;
chunk__52333_53026 = G__53120;
count__52334_53027 = G__53121;
i__52335_53028 = G__53122;
continue;
} else {
var G__53123 = cljs.core.next(seq__52331_53079__$1);
var G__53124 = null;
var G__53125 = (0);
var G__53126 = (0);
seq__52331_53025 = G__53123;
chunk__52333_53026 = G__53124;
count__52334_53027 = G__53125;
i__52335_53028 = G__53126;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___53127 = arguments.length;
var i__4737__auto___53128 = (0);
while(true){
if((i__4737__auto___53128 < len__4736__auto___53127)){
args__4742__auto__.push((arguments[i__4737__auto___53128]));

var G__53129 = (i__4737__auto___53128 + (1));
i__4737__auto___53128 = G__53129;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq52416){
var G__52417 = cljs.core.first(seq52416);
var seq52416__$1 = cljs.core.next(seq52416);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__52417,seq52416__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__52420 = arguments.length;
switch (G__52420) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__45764__auto___53139 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_52432){
var state_val_52433 = (state_52432[(1)]);
if((state_val_52433 === (1))){
var state_52432__$1 = state_52432;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52432__$1,(2),once_or_cleanup);
} else {
if((state_val_52433 === (2))){
var inst_52429 = (state_52432[(2)]);
var inst_52430 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_52432__$1 = (function (){var statearr_52436 = state_52432;
(statearr_52436[(7)] = inst_52429);

return statearr_52436;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_52432__$1,inst_52430);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__45666__auto__ = null;
var shadow$dom$state_machine__45666__auto____0 = (function (){
var statearr_52439 = [null,null,null,null,null,null,null,null];
(statearr_52439[(0)] = shadow$dom$state_machine__45666__auto__);

(statearr_52439[(1)] = (1));

return statearr_52439;
});
var shadow$dom$state_machine__45666__auto____1 = (function (state_52432){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_52432);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e52441){var ex__45669__auto__ = e52441;
var statearr_52442_53145 = state_52432;
(statearr_52442_53145[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_52432[(4)]))){
var statearr_52443_53146 = state_52432;
(statearr_52443_53146[(1)] = cljs.core.first((state_52432[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53147 = state_52432;
state_52432 = G__53147;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
shadow$dom$state_machine__45666__auto__ = function(state_52432){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__45666__auto____0.call(this);
case 1:
return shadow$dom$state_machine__45666__auto____1.call(this,state_52432);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__45666__auto____0;
shadow$dom$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__45666__auto____1;
return shadow$dom$state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_52445 = f__45765__auto__();
(statearr_52445[(6)] = c__45764__auto___53139);

return statearr_52445;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
