goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
var module$node_modules$react$index=shadow.js.require("module$node_modules$react$index", {});
/**
 * The React.js create element function.
 */
sablono.core.create_element = module$node_modules$react$index.createElement;
/**
 * The React.js Fragment.
 */
sablono.core.fragment = module$node_modules$react$index.Fragment;
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__51993__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__51617 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var seq__51618 = cljs.core.seq(vec__51617);
var first__51619 = cljs.core.first(seq__51618);
var seq__51618__$1 = cljs.core.next(seq__51618);
var tag = first__51619;
var body = seq__51618__$1;
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.first(body),cljs.core.first(args)], 0))], null),cljs.core.rest(body));
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.first(args)], null),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__51993 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__51994__i = 0, G__51994__a = new Array(arguments.length -  0);
while (G__51994__i < G__51994__a.length) {G__51994__a[G__51994__i] = arguments[G__51994__i + 0]; ++G__51994__i;}
  args = new cljs.core.IndexedSeq(G__51994__a,0,null);
} 
return G__51993__delegate.call(this,args);};
G__51993.cljs$lang$maxFixedArity = 0;
G__51993.cljs$lang$applyTo = (function (arglist__51995){
var args = cljs.core.seq(arglist__51995);
return G__51993__delegate(args);
});
G__51993.cljs$core$IFn$_invoke$arity$variadic = G__51993__delegate;
return G__51993;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__4529__auto__ = (function sablono$core$update_arglists_$_iter__51622(s__51623){
return (new cljs.core.LazySeq(null,(function (){
var s__51623__$1 = s__51623;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__51623__$1);
if(temp__5735__auto__){
var s__51623__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__51623__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__51623__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__51625 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__51624 = (0);
while(true){
if((i__51624 < size__4528__auto__)){
var args = cljs.core._nth(c__4527__auto__,i__51624);
cljs.core.chunk_append(b__51625,cljs.core.vec(cljs.core.cons(new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__52001 = (i__51624 + (1));
i__51624 = G__52001;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__51625),sablono$core$update_arglists_$_iter__51622(cljs.core.chunk_rest(s__51623__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__51625),null);
}
} else {
var args = cljs.core.first(s__51623__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__51622(cljs.core.rest(s__51623__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__4742__auto__ = [];
var len__4736__auto___52002 = arguments.length;
var i__4737__auto___52003 = (0);
while(true){
if((i__4737__auto___52003 < len__4736__auto___52002)){
args__4742__auto__.push((arguments[i__4737__auto___52003]));

var G__52004 = (i__4737__auto___52003 + (1));
i__4737__auto___52003 = G__52004;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__4529__auto__ = (function sablono$core$iter__51633(s__51634){
return (new cljs.core.LazySeq(null,(function (){
var s__51634__$1 = s__51634;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__51634__$1);
if(temp__5735__auto__){
var s__51634__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__51634__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__51634__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__51636 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__51635 = (0);
while(true){
if((i__51635 < size__4528__auto__)){
var style = cljs.core._nth(c__4527__auto__,i__51635);
cljs.core.chunk_append(b__51636,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([style], 0)),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__52008 = (i__51635 + (1));
i__51635 = G__52008;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__51636),sablono$core$iter__51633(cljs.core.chunk_rest(s__51634__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__51636),null);
}
} else {
var style = cljs.core.first(s__51634__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([style], 0)),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__51633(cljs.core.rest(s__51634__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(styles);
}));

(sablono.core.include_css.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(sablono.core.include_css.cljs$lang$applyTo = (function (seq51630){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq51630));
}));

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to51646 = (function sablono$core$link_to51646(var_args){
var args__4742__auto__ = [];
var len__4736__auto___52009 = arguments.length;
var i__4737__auto___52010 = (0);
while(true){
if((i__4737__auto___52010 < len__4736__auto___52009)){
args__4742__auto__.push((arguments[i__4737__auto___52010]));

var G__52011 = (i__4737__auto___52010 + (1));
i__4737__auto___52010 = G__52011;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to51646.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(sablono.core.link_to51646.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([url], 0))], null),content], null);
}));

(sablono.core.link_to51646.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sablono.core.link_to51646.cljs$lang$applyTo = (function (seq51647){
var G__51648 = cljs.core.first(seq51647);
var seq51647__$1 = cljs.core.next(seq51647);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__51648,seq51647__$1);
}));


sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to51646);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to51653 = (function sablono$core$mail_to51653(var_args){
var args__4742__auto__ = [];
var len__4736__auto___52012 = arguments.length;
var i__4737__auto___52013 = (0);
while(true){
if((i__4737__auto___52013 < len__4736__auto___52012)){
args__4742__auto__.push((arguments[i__4737__auto___52013]));

var G__52014 = (i__4737__auto___52013 + (1));
i__4737__auto___52013 = G__52014;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to51653.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(sablono.core.mail_to51653.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__51656){
var vec__51657 = p__51656;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51657,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),["mailto:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__4126__auto__ = content;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return e_mail;
}
})()], null);
}));

(sablono.core.mail_to51653.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sablono.core.mail_to51653.cljs$lang$applyTo = (function (seq51654){
var G__51655 = cljs.core.first(seq51654);
var seq51654__$1 = cljs.core.next(seq51654);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__51655,seq51654__$1);
}));


sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to51653);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list51660 = (function sablono$core$unordered_list51660(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__4529__auto__ = (function sablono$core$unordered_list51660_$_iter__51662(s__51663){
return (new cljs.core.LazySeq(null,(function (){
var s__51663__$1 = s__51663;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__51663__$1);
if(temp__5735__auto__){
var s__51663__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__51663__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__51663__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__51665 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__51664 = (0);
while(true){
if((i__51664 < size__4528__auto__)){
var x = cljs.core._nth(c__4527__auto__,i__51664);
cljs.core.chunk_append(b__51665,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__52024 = (i__51664 + (1));
i__51664 = G__52024;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__51665),sablono$core$unordered_list51660_$_iter__51662(cljs.core.chunk_rest(s__51663__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__51665),null);
}
} else {
var x = cljs.core.first(s__51663__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list51660_$_iter__51662(cljs.core.rest(s__51663__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list51660);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list51669 = (function sablono$core$ordered_list51669(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__4529__auto__ = (function sablono$core$ordered_list51669_$_iter__51670(s__51671){
return (new cljs.core.LazySeq(null,(function (){
var s__51671__$1 = s__51671;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__51671__$1);
if(temp__5735__auto__){
var s__51671__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__51671__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__51671__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__51673 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__51672 = (0);
while(true){
if((i__51672 < size__4528__auto__)){
var x = cljs.core._nth(c__4527__auto__,i__51672);
cljs.core.chunk_append(b__51673,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__52031 = (i__51672 + (1));
i__51672 = G__52031;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__51673),sablono$core$ordered_list51669_$_iter__51670(cljs.core.chunk_rest(s__51671__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__51673),null);
}
} else {
var x = cljs.core.first(s__51671__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list51669_$_iter__51670(cljs.core.rest(s__51671__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list51669);
/**
 * Create an image element.
 */
sablono.core.image51679 = (function sablono$core$image51679(var_args){
var G__51681 = arguments.length;
switch (G__51681) {
case 1:
return sablono.core.image51679.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image51679.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.image51679.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([src], 0))], null)], null);
}));

(sablono.core.image51679.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([src], 0)),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
}));

(sablono.core.image51679.cljs$lang$maxFixedArity = 2);


sablono.core.image = sablono.core.wrap_attrs(sablono.core.image51679);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__51682_SHARP_,p2__51683_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__51682_SHARP_),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__51683_SHARP_),"]"].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__51685_SHARP_,p2__51686_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__51685_SHARP_),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__51686_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(var_args){
var G__51688 = arguments.length;
switch (G__51688) {
case 2:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (type,name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
}));

(sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4126__auto__ = value;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return undefined;
}
})()], null)], null);
}));

(sablono.core.input_field_STAR_.cljs$lang$maxFixedArity = 3);

/**
 * Creates a color input field.
 */
sablono.core.color_field51694 = (function sablono$core$color_field51694(var_args){
var G__51696 = arguments.length;
switch (G__51696) {
case 1:
return sablono.core.color_field51694.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field51694.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.color_field51694.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null)),name__51605__auto__);
}));

(sablono.core.color_field51694.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.color_field51694.cljs$lang$maxFixedArity = 2);


sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field51694);

/**
 * Creates a date input field.
 */
sablono.core.date_field51699 = (function sablono$core$date_field51699(var_args){
var G__51701 = arguments.length;
switch (G__51701) {
case 1:
return sablono.core.date_field51699.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field51699.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.date_field51699.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null)),name__51605__auto__);
}));

(sablono.core.date_field51699.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.date_field51699.cljs$lang$maxFixedArity = 2);


sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field51699);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field51706 = (function sablono$core$datetime_field51706(var_args){
var G__51709 = arguments.length;
switch (G__51709) {
case 1:
return sablono.core.datetime_field51706.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field51706.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.datetime_field51706.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null)),name__51605__auto__);
}));

(sablono.core.datetime_field51706.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.datetime_field51706.cljs$lang$maxFixedArity = 2);


sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field51706);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field51712 = (function sablono$core$datetime_local_field51712(var_args){
var G__51714 = arguments.length;
switch (G__51714) {
case 1:
return sablono.core.datetime_local_field51712.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field51712.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.datetime_local_field51712.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null)),name__51605__auto__);
}));

(sablono.core.datetime_local_field51712.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.datetime_local_field51712.cljs$lang$maxFixedArity = 2);


sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field51712);

/**
 * Creates a email input field.
 */
sablono.core.email_field51718 = (function sablono$core$email_field51718(var_args){
var G__51723 = arguments.length;
switch (G__51723) {
case 1:
return sablono.core.email_field51718.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field51718.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.email_field51718.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null)),name__51605__auto__);
}));

(sablono.core.email_field51718.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.email_field51718.cljs$lang$maxFixedArity = 2);


sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field51718);

/**
 * Creates a file input field.
 */
sablono.core.file_field51729 = (function sablono$core$file_field51729(var_args){
var G__51731 = arguments.length;
switch (G__51731) {
case 1:
return sablono.core.file_field51729.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field51729.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.file_field51729.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null)),name__51605__auto__);
}));

(sablono.core.file_field51729.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.file_field51729.cljs$lang$maxFixedArity = 2);


sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field51729);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field51733 = (function sablono$core$hidden_field51733(var_args){
var G__51738 = arguments.length;
switch (G__51738) {
case 1:
return sablono.core.hidden_field51733.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field51733.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.hidden_field51733.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null)),name__51605__auto__);
}));

(sablono.core.hidden_field51733.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.hidden_field51733.cljs$lang$maxFixedArity = 2);


sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field51733);

/**
 * Creates a month input field.
 */
sablono.core.month_field51741 = (function sablono$core$month_field51741(var_args){
var G__51744 = arguments.length;
switch (G__51744) {
case 1:
return sablono.core.month_field51741.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field51741.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.month_field51741.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null)),name__51605__auto__);
}));

(sablono.core.month_field51741.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.month_field51741.cljs$lang$maxFixedArity = 2);


sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field51741);

/**
 * Creates a number input field.
 */
sablono.core.number_field51749 = (function sablono$core$number_field51749(var_args){
var G__51752 = arguments.length;
switch (G__51752) {
case 1:
return sablono.core.number_field51749.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field51749.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.number_field51749.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null)),name__51605__auto__);
}));

(sablono.core.number_field51749.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.number_field51749.cljs$lang$maxFixedArity = 2);


sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field51749);

/**
 * Creates a password input field.
 */
sablono.core.password_field51756 = (function sablono$core$password_field51756(var_args){
var G__51758 = arguments.length;
switch (G__51758) {
case 1:
return sablono.core.password_field51756.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field51756.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.password_field51756.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null)),name__51605__auto__);
}));

(sablono.core.password_field51756.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.password_field51756.cljs$lang$maxFixedArity = 2);


sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field51756);

/**
 * Creates a range input field.
 */
sablono.core.range_field51763 = (function sablono$core$range_field51763(var_args){
var G__51765 = arguments.length;
switch (G__51765) {
case 1:
return sablono.core.range_field51763.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field51763.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.range_field51763.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null)),name__51605__auto__);
}));

(sablono.core.range_field51763.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.range_field51763.cljs$lang$maxFixedArity = 2);


sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field51763);

/**
 * Creates a search input field.
 */
sablono.core.search_field51767 = (function sablono$core$search_field51767(var_args){
var G__51770 = arguments.length;
switch (G__51770) {
case 1:
return sablono.core.search_field51767.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field51767.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.search_field51767.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null)),name__51605__auto__);
}));

(sablono.core.search_field51767.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.search_field51767.cljs$lang$maxFixedArity = 2);


sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field51767);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field51771 = (function sablono$core$tel_field51771(var_args){
var G__51773 = arguments.length;
switch (G__51773) {
case 1:
return sablono.core.tel_field51771.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field51771.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.tel_field51771.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null)),name__51605__auto__);
}));

(sablono.core.tel_field51771.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.tel_field51771.cljs$lang$maxFixedArity = 2);


sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field51771);

/**
 * Creates a text input field.
 */
sablono.core.text_field51776 = (function sablono$core$text_field51776(var_args){
var G__51778 = arguments.length;
switch (G__51778) {
case 1:
return sablono.core.text_field51776.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field51776.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.text_field51776.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null)),name__51605__auto__);
}));

(sablono.core.text_field51776.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.text_field51776.cljs$lang$maxFixedArity = 2);


sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field51776);

/**
 * Creates a time input field.
 */
sablono.core.time_field51784 = (function sablono$core$time_field51784(var_args){
var G__51789 = arguments.length;
switch (G__51789) {
case 1:
return sablono.core.time_field51784.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field51784.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.time_field51784.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null)),name__51605__auto__);
}));

(sablono.core.time_field51784.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.time_field51784.cljs$lang$maxFixedArity = 2);


sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field51784);

/**
 * Creates a url input field.
 */
sablono.core.url_field51800 = (function sablono$core$url_field51800(var_args){
var G__51802 = arguments.length;
switch (G__51802) {
case 1:
return sablono.core.url_field51800.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field51800.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.url_field51800.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null)),name__51605__auto__);
}));

(sablono.core.url_field51800.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.url_field51800.cljs$lang$maxFixedArity = 2);


sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field51800);

/**
 * Creates a week input field.
 */
sablono.core.week_field51811 = (function sablono$core$week_field51811(var_args){
var G__51817 = arguments.length;
switch (G__51817) {
case 1:
return sablono.core.week_field51811.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field51811.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.week_field51811.cljs$core$IFn$_invoke$arity$1 = (function (name__51605__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null)),name__51605__auto__);
}));

(sablono.core.week_field51811.cljs$core$IFn$_invoke$arity$2 = (function (name__51605__auto__,value__51606__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null)),name__51605__auto__,value__51606__auto__);
}));

(sablono.core.week_field51811.cljs$lang$maxFixedArity = 2);


sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field51811);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box51838 = (function sablono$core$check_box51838(var_args){
var G__51844 = arguments.length;
switch (G__51844) {
case 1:
return sablono.core.check_box51838.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box51838.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box51838.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.check_box51838.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
}));

(sablono.core.check_box51838.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.check_box51838.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.check_box51838.cljs$lang$maxFixedArity = 3);


sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box51838);
/**
 * Creates a radio button.
 */
sablono.core.radio_button51852 = (function sablono$core$radio_button51852(var_args){
var G__51857 = arguments.length;
switch (G__51857) {
case 1:
return sablono.core.radio_button51852.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button51852.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button51852.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.radio_button51852.cljs$core$IFn$_invoke$arity$1 = (function (group){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0)))], null)], null);
}));

(sablono.core.radio_button51852.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0))),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.radio_button51852.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id([sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0)),"-",sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([value], 0))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.radio_button51852.cljs$lang$maxFixedArity = 3);


sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button51852);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0)));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options51871 = (function sablono$core$select_options51871(coll){
var iter__4529__auto__ = (function sablono$core$select_options51871_$_iter__51873(s__51874){
return (new cljs.core.LazySeq(null,(function (){
var s__51874__$1 = s__51874;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__51874__$1);
if(temp__5735__auto__){
var s__51874__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__51874__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__51874__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__51876 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__51875 = (0);
while(true){
if((i__51875 < size__4528__auto__)){
var x = cljs.core._nth(c__4527__auto__,i__51875);
cljs.core.chunk_append(b__51876,((cljs.core.sequential_QMARK_(x))?(function (){var vec__51882 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51882,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51882,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51882,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),(sablono.core.select_options51871.cljs$core$IFn$_invoke$arity$1 ? sablono.core.select_options51871.cljs$core$IFn$_invoke$arity$1(val) : sablono.core.select_options51871.call(null,val))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__52158 = (i__51875 + (1));
i__51875 = G__52158;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__51876),sablono$core$select_options51871_$_iter__51873(cljs.core.chunk_rest(s__51874__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__51876),null);
}
} else {
var x = cljs.core.first(s__51874__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__51891 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51891,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51891,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51891,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),(sablono.core.select_options51871.cljs$core$IFn$_invoke$arity$1 ? sablono.core.select_options51871.cljs$core$IFn$_invoke$arity$1(val) : sablono.core.select_options51871.call(null,val))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options51871_$_iter__51873(cljs.core.rest(s__51874__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
});

sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options51871);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down51901 = (function sablono$core$drop_down51901(var_args){
var G__51906 = arguments.length;
switch (G__51906) {
case 2:
return sablono.core.drop_down51901.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down51901.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.drop_down51901.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down51901.cljs$core$IFn$_invoke$arity$3(name,options,null);
}));

(sablono.core.drop_down51901.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null),sablono.core.select_options(options,selected)], null);
}));

(sablono.core.drop_down51901.cljs$lang$maxFixedArity = 3);


sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down51901);
/**
 * Creates a text area element.
 */
sablono.core.text_area51913 = (function sablono$core$text_area51913(var_args){
var G__51928 = arguments.length;
switch (G__51928) {
case 1:
return sablono.core.text_area51913.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area51913.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.text_area51913.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
}));

(sablono.core.text_area51913.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4126__auto__ = value;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return undefined;
}
})()], null)], null);
}));

(sablono.core.text_area51913.cljs$lang$maxFixedArity = 2);


sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area51913);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label51949 = (function sablono$core$label51949(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label51949);
/**
 * Creates a submit button.
 */
sablono.core.submit_button51952 = (function sablono$core$submit_button51952(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button51952);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button51953 = (function sablono$core$reset_button51953(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button51953);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to51961 = (function sablono$core$form_to51961(var_args){
var args__4742__auto__ = [];
var len__4736__auto___52177 = arguments.length;
var i__4737__auto___52178 = (0);
while(true){
if((i__4737__auto___52178 < len__4736__auto___52177)){
args__4742__auto__.push((arguments[i__4737__auto___52178]));

var G__52179 = (i__4737__auto___52178 + (1));
i__4737__auto___52178 = G__52179;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to51961.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(sablono.core.form_to51961.cljs$core$IFn$_invoke$arity$variadic = (function (p__51969,body){
var vec__51970 = p__51969;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51970,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51970,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
}));

(sablono.core.form_to51961.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sablono.core.form_to51961.cljs$lang$applyTo = (function (seq51962){
var G__51963 = cljs.core.first(seq51962);
var seq51962__$1 = cljs.core.next(seq51962);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__51963,seq51962__$1);
}));


sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to51961);

//# sourceMappingURL=sablono.core.js.map
