goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__45884 = arguments.length;
switch (G__45884) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45894 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45894 = (function (f,blockable,meta45895){
this.f = f;
this.blockable = blockable;
this.meta45895 = meta45895;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45894.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45896,meta45895__$1){
var self__ = this;
var _45896__$1 = this;
return (new cljs.core.async.t_cljs$core$async45894(self__.f,self__.blockable,meta45895__$1));
}));

(cljs.core.async.t_cljs$core$async45894.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45896){
var self__ = this;
var _45896__$1 = this;
return self__.meta45895;
}));

(cljs.core.async.t_cljs$core$async45894.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45894.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45894.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async45894.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async45894.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta45895","meta45895",-1030326824,null)], null);
}));

(cljs.core.async.t_cljs$core$async45894.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45894.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45894");

(cljs.core.async.t_cljs$core$async45894.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45894");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45894.
 */
cljs.core.async.__GT_t_cljs$core$async45894 = (function cljs$core$async$__GT_t_cljs$core$async45894(f__$1,blockable__$1,meta45895){
return (new cljs.core.async.t_cljs$core$async45894(f__$1,blockable__$1,meta45895));
});

}

return (new cljs.core.async.t_cljs$core$async45894(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__45966 = arguments.length;
switch (G__45966) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__45996 = arguments.length;
switch (G__45996) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__46033 = arguments.length;
switch (G__46033) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_49871 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_49871) : fn1.call(null,val_49871));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_49871) : fn1.call(null,val_49871));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__46065 = arguments.length;
switch (G__46065) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___49882 = n;
var x_49883 = (0);
while(true){
if((x_49883 < n__4613__auto___49882)){
(a[x_49883] = x_49883);

var G__49884 = (x_49883 + (1));
x_49883 = G__49884;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46113 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46113 = (function (flag,meta46114){
this.flag = flag;
this.meta46114 = meta46114;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46113.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46115,meta46114__$1){
var self__ = this;
var _46115__$1 = this;
return (new cljs.core.async.t_cljs$core$async46113(self__.flag,meta46114__$1));
}));

(cljs.core.async.t_cljs$core$async46113.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46115){
var self__ = this;
var _46115__$1 = this;
return self__.meta46114;
}));

(cljs.core.async.t_cljs$core$async46113.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46113.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async46113.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async46113.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async46113.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta46114","meta46114",-1070841654,null)], null);
}));

(cljs.core.async.t_cljs$core$async46113.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46113.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46113");

(cljs.core.async.t_cljs$core$async46113.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async46113");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46113.
 */
cljs.core.async.__GT_t_cljs$core$async46113 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async46113(flag__$1,meta46114){
return (new cljs.core.async.t_cljs$core$async46113(flag__$1,meta46114));
});

}

return (new cljs.core.async.t_cljs$core$async46113(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46153 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46153 = (function (flag,cb,meta46154){
this.flag = flag;
this.cb = cb;
this.meta46154 = meta46154;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46153.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46155,meta46154__$1){
var self__ = this;
var _46155__$1 = this;
return (new cljs.core.async.t_cljs$core$async46153(self__.flag,self__.cb,meta46154__$1));
}));

(cljs.core.async.t_cljs$core$async46153.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46155){
var self__ = this;
var _46155__$1 = this;
return self__.meta46154;
}));

(cljs.core.async.t_cljs$core$async46153.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46153.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async46153.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async46153.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async46153.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta46154","meta46154",-1823075509,null)], null);
}));

(cljs.core.async.t_cljs$core$async46153.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46153.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46153");

(cljs.core.async.t_cljs$core$async46153.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async46153");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46153.
 */
cljs.core.async.__GT_t_cljs$core$async46153 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async46153(flag__$1,cb__$1,meta46154){
return (new cljs.core.async.t_cljs$core$async46153(flag__$1,cb__$1,meta46154));
});

}

return (new cljs.core.async.t_cljs$core$async46153(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__46187_SHARP_){
var G__46199 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__46187_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__46199) : fret.call(null,G__46199));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__46188_SHARP_){
var G__46203 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__46188_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__46203) : fret.call(null,G__46203));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__49911 = (i + (1));
i = G__49911;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___49918 = arguments.length;
var i__4737__auto___49919 = (0);
while(true){
if((i__4737__auto___49919 < len__4736__auto___49918)){
args__4742__auto__.push((arguments[i__4737__auto___49919]));

var G__49922 = (i__4737__auto___49919 + (1));
i__4737__auto___49919 = G__49922;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__46257){
var map__46260 = p__46257;
var map__46260__$1 = (((((!((map__46260 == null))))?(((((map__46260.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46260.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46260):map__46260);
var opts = map__46260__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq46216){
var G__46217 = cljs.core.first(seq46216);
var seq46216__$1 = cljs.core.next(seq46216);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46217,seq46216__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__46324 = arguments.length;
switch (G__46324) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__45764__auto___49930 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_46431){
var state_val_46433 = (state_46431[(1)]);
if((state_val_46433 === (7))){
var inst_46426 = (state_46431[(2)]);
var state_46431__$1 = state_46431;
var statearr_46446_49931 = state_46431__$1;
(statearr_46446_49931[(2)] = inst_46426);

(statearr_46446_49931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (1))){
var state_46431__$1 = state_46431;
var statearr_46449_49933 = state_46431__$1;
(statearr_46449_49933[(2)] = null);

(statearr_46449_49933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (4))){
var inst_46389 = (state_46431[(7)]);
var inst_46389__$1 = (state_46431[(2)]);
var inst_46404 = (inst_46389__$1 == null);
var state_46431__$1 = (function (){var statearr_46455 = state_46431;
(statearr_46455[(7)] = inst_46389__$1);

return statearr_46455;
})();
if(cljs.core.truth_(inst_46404)){
var statearr_46458_49937 = state_46431__$1;
(statearr_46458_49937[(1)] = (5));

} else {
var statearr_46459_49938 = state_46431__$1;
(statearr_46459_49938[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (13))){
var state_46431__$1 = state_46431;
var statearr_46465_49939 = state_46431__$1;
(statearr_46465_49939[(2)] = null);

(statearr_46465_49939[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (6))){
var inst_46389 = (state_46431[(7)]);
var state_46431__$1 = state_46431;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46431__$1,(11),to,inst_46389);
} else {
if((state_val_46433 === (3))){
var inst_46428 = (state_46431[(2)]);
var state_46431__$1 = state_46431;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46431__$1,inst_46428);
} else {
if((state_val_46433 === (12))){
var state_46431__$1 = state_46431;
var statearr_46487_49941 = state_46431__$1;
(statearr_46487_49941[(2)] = null);

(statearr_46487_49941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (2))){
var state_46431__$1 = state_46431;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46431__$1,(4),from);
} else {
if((state_val_46433 === (11))){
var inst_46418 = (state_46431[(2)]);
var state_46431__$1 = state_46431;
if(cljs.core.truth_(inst_46418)){
var statearr_46497_49943 = state_46431__$1;
(statearr_46497_49943[(1)] = (12));

} else {
var statearr_46498_49944 = state_46431__$1;
(statearr_46498_49944[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (9))){
var state_46431__$1 = state_46431;
var statearr_46501_49947 = state_46431__$1;
(statearr_46501_49947[(2)] = null);

(statearr_46501_49947[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (5))){
var state_46431__$1 = state_46431;
if(cljs.core.truth_(close_QMARK_)){
var statearr_46506_49951 = state_46431__$1;
(statearr_46506_49951[(1)] = (8));

} else {
var statearr_46509_49952 = state_46431__$1;
(statearr_46509_49952[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (14))){
var inst_46424 = (state_46431[(2)]);
var state_46431__$1 = state_46431;
var statearr_46511_49954 = state_46431__$1;
(statearr_46511_49954[(2)] = inst_46424);

(statearr_46511_49954[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (10))){
var inst_46415 = (state_46431[(2)]);
var state_46431__$1 = state_46431;
var statearr_46514_49957 = state_46431__$1;
(statearr_46514_49957[(2)] = inst_46415);

(statearr_46514_49957[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (8))){
var inst_46409 = cljs.core.async.close_BANG_(to);
var state_46431__$1 = state_46431;
var statearr_46520_49958 = state_46431__$1;
(statearr_46520_49958[(2)] = inst_46409);

(statearr_46520_49958[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45666__auto__ = null;
var cljs$core$async$state_machine__45666__auto____0 = (function (){
var statearr_46534 = [null,null,null,null,null,null,null,null];
(statearr_46534[(0)] = cljs$core$async$state_machine__45666__auto__);

(statearr_46534[(1)] = (1));

return statearr_46534;
});
var cljs$core$async$state_machine__45666__auto____1 = (function (state_46431){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_46431);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e46540){var ex__45669__auto__ = e46540;
var statearr_46542_49968 = state_46431;
(statearr_46542_49968[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_46431[(4)]))){
var statearr_46546_49969 = state_46431;
(statearr_46546_49969[(1)] = cljs.core.first((state_46431[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49970 = state_46431;
state_46431 = G__49970;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$state_machine__45666__auto__ = function(state_46431){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45666__auto____1.call(this,state_46431);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45666__auto____0;
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45666__auto____1;
return cljs$core$async$state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_46554 = f__45765__auto__();
(statearr_46554[(6)] = c__45764__auto___49930);

return statearr_46554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__46576){
var vec__46577 = p__46576;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46577,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46577,(1),null);
var job = vec__46577;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__45764__auto___49978 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_46585){
var state_val_46586 = (state_46585[(1)]);
if((state_val_46586 === (1))){
var state_46585__$1 = state_46585;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46585__$1,(2),res,v);
} else {
if((state_val_46586 === (2))){
var inst_46582 = (state_46585[(2)]);
var inst_46583 = cljs.core.async.close_BANG_(res);
var state_46585__$1 = (function (){var statearr_46587 = state_46585;
(statearr_46587[(7)] = inst_46582);

return statearr_46587;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46585__$1,inst_46583);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____0 = (function (){
var statearr_46588 = [null,null,null,null,null,null,null,null];
(statearr_46588[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__);

(statearr_46588[(1)] = (1));

return statearr_46588;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____1 = (function (state_46585){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_46585);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e46589){var ex__45669__auto__ = e46589;
var statearr_46592_49984 = state_46585;
(statearr_46592_49984[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_46585[(4)]))){
var statearr_46595_49985 = state_46585;
(statearr_46595_49985[(1)] = cljs.core.first((state_46585[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49986 = state_46585;
state_46585 = G__49986;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__ = function(state_46585){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____1.call(this,state_46585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_46600 = f__45765__auto__();
(statearr_46600[(6)] = c__45764__auto___49978);

return statearr_46600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__46602){
var vec__46603 = p__46602;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46603,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46603,(1),null);
var job = vec__46603;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___49991 = n;
var __49992 = (0);
while(true){
if((__49992 < n__4613__auto___49991)){
var G__46613_49993 = type;
var G__46613_49994__$1 = (((G__46613_49993 instanceof cljs.core.Keyword))?G__46613_49993.fqn:null);
switch (G__46613_49994__$1) {
case "compute":
var c__45764__auto___49996 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__49992,c__45764__auto___49996,G__46613_49993,G__46613_49994__$1,n__4613__auto___49991,jobs,results,process,async){
return (function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = ((function (__49992,c__45764__auto___49996,G__46613_49993,G__46613_49994__$1,n__4613__auto___49991,jobs,results,process,async){
return (function (state_46631){
var state_val_46632 = (state_46631[(1)]);
if((state_val_46632 === (1))){
var state_46631__$1 = state_46631;
var statearr_46639_50001 = state_46631__$1;
(statearr_46639_50001[(2)] = null);

(statearr_46639_50001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46632 === (2))){
var state_46631__$1 = state_46631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46631__$1,(4),jobs);
} else {
if((state_val_46632 === (3))){
var inst_46629 = (state_46631[(2)]);
var state_46631__$1 = state_46631;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46631__$1,inst_46629);
} else {
if((state_val_46632 === (4))){
var inst_46620 = (state_46631[(2)]);
var inst_46621 = process(inst_46620);
var state_46631__$1 = state_46631;
if(cljs.core.truth_(inst_46621)){
var statearr_46646_50005 = state_46631__$1;
(statearr_46646_50005[(1)] = (5));

} else {
var statearr_46648_50006 = state_46631__$1;
(statearr_46648_50006[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46632 === (5))){
var state_46631__$1 = state_46631;
var statearr_46651_50007 = state_46631__$1;
(statearr_46651_50007[(2)] = null);

(statearr_46651_50007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46632 === (6))){
var state_46631__$1 = state_46631;
var statearr_46655_50010 = state_46631__$1;
(statearr_46655_50010[(2)] = null);

(statearr_46655_50010[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46632 === (7))){
var inst_46627 = (state_46631[(2)]);
var state_46631__$1 = state_46631;
var statearr_46659_50012 = state_46631__$1;
(statearr_46659_50012[(2)] = inst_46627);

(statearr_46659_50012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__49992,c__45764__auto___49996,G__46613_49993,G__46613_49994__$1,n__4613__auto___49991,jobs,results,process,async))
;
return ((function (__49992,switch__45665__auto__,c__45764__auto___49996,G__46613_49993,G__46613_49994__$1,n__4613__auto___49991,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____0 = (function (){
var statearr_46666 = [null,null,null,null,null,null,null];
(statearr_46666[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__);

(statearr_46666[(1)] = (1));

return statearr_46666;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____1 = (function (state_46631){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_46631);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e46669){var ex__45669__auto__ = e46669;
var statearr_46670_50015 = state_46631;
(statearr_46670_50015[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_46631[(4)]))){
var statearr_46671_50018 = state_46631;
(statearr_46671_50018[(1)] = cljs.core.first((state_46631[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50019 = state_46631;
state_46631 = G__50019;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__ = function(state_46631){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____1.call(this,state_46631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__;
})()
;})(__49992,switch__45665__auto__,c__45764__auto___49996,G__46613_49993,G__46613_49994__$1,n__4613__auto___49991,jobs,results,process,async))
})();
var state__45766__auto__ = (function (){var statearr_46678 = f__45765__auto__();
(statearr_46678[(6)] = c__45764__auto___49996);

return statearr_46678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
});})(__49992,c__45764__auto___49996,G__46613_49993,G__46613_49994__$1,n__4613__auto___49991,jobs,results,process,async))
);


break;
case "async":
var c__45764__auto___50023 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__49992,c__45764__auto___50023,G__46613_49993,G__46613_49994__$1,n__4613__auto___49991,jobs,results,process,async){
return (function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = ((function (__49992,c__45764__auto___50023,G__46613_49993,G__46613_49994__$1,n__4613__auto___49991,jobs,results,process,async){
return (function (state_46703){
var state_val_46705 = (state_46703[(1)]);
if((state_val_46705 === (1))){
var state_46703__$1 = state_46703;
var statearr_46707_50024 = state_46703__$1;
(statearr_46707_50024[(2)] = null);

(statearr_46707_50024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46705 === (2))){
var state_46703__$1 = state_46703;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46703__$1,(4),jobs);
} else {
if((state_val_46705 === (3))){
var inst_46699 = (state_46703[(2)]);
var state_46703__$1 = state_46703;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46703__$1,inst_46699);
} else {
if((state_val_46705 === (4))){
var inst_46690 = (state_46703[(2)]);
var inst_46691 = async(inst_46690);
var state_46703__$1 = state_46703;
if(cljs.core.truth_(inst_46691)){
var statearr_46710_50032 = state_46703__$1;
(statearr_46710_50032[(1)] = (5));

} else {
var statearr_46713_50033 = state_46703__$1;
(statearr_46713_50033[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46705 === (5))){
var state_46703__$1 = state_46703;
var statearr_46716_50034 = state_46703__$1;
(statearr_46716_50034[(2)] = null);

(statearr_46716_50034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46705 === (6))){
var state_46703__$1 = state_46703;
var statearr_46717_50035 = state_46703__$1;
(statearr_46717_50035[(2)] = null);

(statearr_46717_50035[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46705 === (7))){
var inst_46697 = (state_46703[(2)]);
var state_46703__$1 = state_46703;
var statearr_46726_50038 = state_46703__$1;
(statearr_46726_50038[(2)] = inst_46697);

(statearr_46726_50038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__49992,c__45764__auto___50023,G__46613_49993,G__46613_49994__$1,n__4613__auto___49991,jobs,results,process,async))
;
return ((function (__49992,switch__45665__auto__,c__45764__auto___50023,G__46613_49993,G__46613_49994__$1,n__4613__auto___49991,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____0 = (function (){
var statearr_46731 = [null,null,null,null,null,null,null];
(statearr_46731[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__);

(statearr_46731[(1)] = (1));

return statearr_46731;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____1 = (function (state_46703){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_46703);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e46734){var ex__45669__auto__ = e46734;
var statearr_46735_50044 = state_46703;
(statearr_46735_50044[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_46703[(4)]))){
var statearr_46737_50045 = state_46703;
(statearr_46737_50045[(1)] = cljs.core.first((state_46703[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50046 = state_46703;
state_46703 = G__50046;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__ = function(state_46703){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____1.call(this,state_46703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__;
})()
;})(__49992,switch__45665__auto__,c__45764__auto___50023,G__46613_49993,G__46613_49994__$1,n__4613__auto___49991,jobs,results,process,async))
})();
var state__45766__auto__ = (function (){var statearr_46739 = f__45765__auto__();
(statearr_46739[(6)] = c__45764__auto___50023);

return statearr_46739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
});})(__49992,c__45764__auto___50023,G__46613_49993,G__46613_49994__$1,n__4613__auto___49991,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__46613_49994__$1)].join('')));

}

var G__50050 = (__49992 + (1));
__49992 = G__50050;
continue;
} else {
}
break;
}

var c__45764__auto___50051 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_46767){
var state_val_46768 = (state_46767[(1)]);
if((state_val_46768 === (7))){
var inst_46760 = (state_46767[(2)]);
var state_46767__$1 = state_46767;
var statearr_46778_50054 = state_46767__$1;
(statearr_46778_50054[(2)] = inst_46760);

(statearr_46778_50054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46768 === (1))){
var state_46767__$1 = state_46767;
var statearr_46779_50056 = state_46767__$1;
(statearr_46779_50056[(2)] = null);

(statearr_46779_50056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46768 === (4))){
var inst_46742 = (state_46767[(7)]);
var inst_46742__$1 = (state_46767[(2)]);
var inst_46743 = (inst_46742__$1 == null);
var state_46767__$1 = (function (){var statearr_46780 = state_46767;
(statearr_46780[(7)] = inst_46742__$1);

return statearr_46780;
})();
if(cljs.core.truth_(inst_46743)){
var statearr_46782_50058 = state_46767__$1;
(statearr_46782_50058[(1)] = (5));

} else {
var statearr_46786_50059 = state_46767__$1;
(statearr_46786_50059[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46768 === (6))){
var inst_46742 = (state_46767[(7)]);
var inst_46748 = (state_46767[(8)]);
var inst_46748__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_46750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46751 = [inst_46742,inst_46748__$1];
var inst_46752 = (new cljs.core.PersistentVector(null,2,(5),inst_46750,inst_46751,null));
var state_46767__$1 = (function (){var statearr_46811 = state_46767;
(statearr_46811[(8)] = inst_46748__$1);

return statearr_46811;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46767__$1,(8),jobs,inst_46752);
} else {
if((state_val_46768 === (3))){
var inst_46762 = (state_46767[(2)]);
var state_46767__$1 = state_46767;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46767__$1,inst_46762);
} else {
if((state_val_46768 === (2))){
var state_46767__$1 = state_46767;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46767__$1,(4),from);
} else {
if((state_val_46768 === (9))){
var inst_46756 = (state_46767[(2)]);
var state_46767__$1 = (function (){var statearr_46814 = state_46767;
(statearr_46814[(9)] = inst_46756);

return statearr_46814;
})();
var statearr_46815_50067 = state_46767__$1;
(statearr_46815_50067[(2)] = null);

(statearr_46815_50067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46768 === (5))){
var inst_46746 = cljs.core.async.close_BANG_(jobs);
var state_46767__$1 = state_46767;
var statearr_46816_50070 = state_46767__$1;
(statearr_46816_50070[(2)] = inst_46746);

(statearr_46816_50070[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46768 === (8))){
var inst_46748 = (state_46767[(8)]);
var inst_46754 = (state_46767[(2)]);
var state_46767__$1 = (function (){var statearr_46818 = state_46767;
(statearr_46818[(10)] = inst_46754);

return statearr_46818;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46767__$1,(9),results,inst_46748);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____0 = (function (){
var statearr_46820 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46820[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__);

(statearr_46820[(1)] = (1));

return statearr_46820;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____1 = (function (state_46767){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_46767);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e46821){var ex__45669__auto__ = e46821;
var statearr_46822_50073 = state_46767;
(statearr_46822_50073[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_46767[(4)]))){
var statearr_46823_50074 = state_46767;
(statearr_46823_50074[(1)] = cljs.core.first((state_46767[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50076 = state_46767;
state_46767 = G__50076;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__ = function(state_46767){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____1.call(this,state_46767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_46824 = f__45765__auto__();
(statearr_46824[(6)] = c__45764__auto___50051);

return statearr_46824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));


var c__45764__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_46864){
var state_val_46865 = (state_46864[(1)]);
if((state_val_46865 === (7))){
var inst_46860 = (state_46864[(2)]);
var state_46864__$1 = state_46864;
var statearr_46868_50079 = state_46864__$1;
(statearr_46868_50079[(2)] = inst_46860);

(statearr_46868_50079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46865 === (20))){
var state_46864__$1 = state_46864;
var statearr_46869_50081 = state_46864__$1;
(statearr_46869_50081[(2)] = null);

(statearr_46869_50081[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46865 === (1))){
var state_46864__$1 = state_46864;
var statearr_46870_50082 = state_46864__$1;
(statearr_46870_50082[(2)] = null);

(statearr_46870_50082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46865 === (4))){
var inst_46828 = (state_46864[(7)]);
var inst_46828__$1 = (state_46864[(2)]);
var inst_46830 = (inst_46828__$1 == null);
var state_46864__$1 = (function (){var statearr_46872 = state_46864;
(statearr_46872[(7)] = inst_46828__$1);

return statearr_46872;
})();
if(cljs.core.truth_(inst_46830)){
var statearr_46873_50086 = state_46864__$1;
(statearr_46873_50086[(1)] = (5));

} else {
var statearr_46874_50087 = state_46864__$1;
(statearr_46874_50087[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46865 === (15))){
var inst_46842 = (state_46864[(8)]);
var state_46864__$1 = state_46864;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46864__$1,(18),to,inst_46842);
} else {
if((state_val_46865 === (21))){
var inst_46855 = (state_46864[(2)]);
var state_46864__$1 = state_46864;
var statearr_46876_50088 = state_46864__$1;
(statearr_46876_50088[(2)] = inst_46855);

(statearr_46876_50088[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46865 === (13))){
var inst_46857 = (state_46864[(2)]);
var state_46864__$1 = (function (){var statearr_46879 = state_46864;
(statearr_46879[(9)] = inst_46857);

return statearr_46879;
})();
var statearr_46880_50093 = state_46864__$1;
(statearr_46880_50093[(2)] = null);

(statearr_46880_50093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46865 === (6))){
var inst_46828 = (state_46864[(7)]);
var state_46864__$1 = state_46864;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46864__$1,(11),inst_46828);
} else {
if((state_val_46865 === (17))){
var inst_46850 = (state_46864[(2)]);
var state_46864__$1 = state_46864;
if(cljs.core.truth_(inst_46850)){
var statearr_46883_50097 = state_46864__$1;
(statearr_46883_50097[(1)] = (19));

} else {
var statearr_46884_50098 = state_46864__$1;
(statearr_46884_50098[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46865 === (3))){
var inst_46862 = (state_46864[(2)]);
var state_46864__$1 = state_46864;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46864__$1,inst_46862);
} else {
if((state_val_46865 === (12))){
var inst_46839 = (state_46864[(10)]);
var state_46864__$1 = state_46864;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46864__$1,(14),inst_46839);
} else {
if((state_val_46865 === (2))){
var state_46864__$1 = state_46864;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46864__$1,(4),results);
} else {
if((state_val_46865 === (19))){
var state_46864__$1 = state_46864;
var statearr_46887_50103 = state_46864__$1;
(statearr_46887_50103[(2)] = null);

(statearr_46887_50103[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46865 === (11))){
var inst_46839 = (state_46864[(2)]);
var state_46864__$1 = (function (){var statearr_46889 = state_46864;
(statearr_46889[(10)] = inst_46839);

return statearr_46889;
})();
var statearr_46892_50107 = state_46864__$1;
(statearr_46892_50107[(2)] = null);

(statearr_46892_50107[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46865 === (9))){
var state_46864__$1 = state_46864;
var statearr_46897_50109 = state_46864__$1;
(statearr_46897_50109[(2)] = null);

(statearr_46897_50109[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46865 === (5))){
var state_46864__$1 = state_46864;
if(cljs.core.truth_(close_QMARK_)){
var statearr_46898_50112 = state_46864__$1;
(statearr_46898_50112[(1)] = (8));

} else {
var statearr_46899_50114 = state_46864__$1;
(statearr_46899_50114[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46865 === (14))){
var inst_46842 = (state_46864[(8)]);
var inst_46842__$1 = (state_46864[(2)]);
var inst_46843 = (inst_46842__$1 == null);
var inst_46844 = cljs.core.not(inst_46843);
var state_46864__$1 = (function (){var statearr_46901 = state_46864;
(statearr_46901[(8)] = inst_46842__$1);

return statearr_46901;
})();
if(inst_46844){
var statearr_46903_50118 = state_46864__$1;
(statearr_46903_50118[(1)] = (15));

} else {
var statearr_46905_50120 = state_46864__$1;
(statearr_46905_50120[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46865 === (16))){
var state_46864__$1 = state_46864;
var statearr_46908_50122 = state_46864__$1;
(statearr_46908_50122[(2)] = false);

(statearr_46908_50122[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46865 === (10))){
var inst_46836 = (state_46864[(2)]);
var state_46864__$1 = state_46864;
var statearr_46910_50123 = state_46864__$1;
(statearr_46910_50123[(2)] = inst_46836);

(statearr_46910_50123[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46865 === (18))){
var inst_46847 = (state_46864[(2)]);
var state_46864__$1 = state_46864;
var statearr_46911_50124 = state_46864__$1;
(statearr_46911_50124[(2)] = inst_46847);

(statearr_46911_50124[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46865 === (8))){
var inst_46833 = cljs.core.async.close_BANG_(to);
var state_46864__$1 = state_46864;
var statearr_46912_50125 = state_46864__$1;
(statearr_46912_50125[(2)] = inst_46833);

(statearr_46912_50125[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____0 = (function (){
var statearr_46914 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46914[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__);

(statearr_46914[(1)] = (1));

return statearr_46914;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____1 = (function (state_46864){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_46864);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e46916){var ex__45669__auto__ = e46916;
var statearr_46921_50131 = state_46864;
(statearr_46921_50131[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_46864[(4)]))){
var statearr_46923_50133 = state_46864;
(statearr_46923_50133[(1)] = cljs.core.first((state_46864[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50134 = state_46864;
state_46864 = G__50134;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__ = function(state_46864){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____1.call(this,state_46864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45666__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_46926 = f__45765__auto__();
(statearr_46926[(6)] = c__45764__auto__);

return statearr_46926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));

return c__45764__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__46932 = arguments.length;
switch (G__46932) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__46953 = arguments.length;
switch (G__46953) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__46967 = arguments.length;
switch (G__46967) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__45764__auto___50142 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_47001){
var state_val_47002 = (state_47001[(1)]);
if((state_val_47002 === (7))){
var inst_46994 = (state_47001[(2)]);
var state_47001__$1 = state_47001;
var statearr_47013_50143 = state_47001__$1;
(statearr_47013_50143[(2)] = inst_46994);

(statearr_47013_50143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47002 === (1))){
var state_47001__$1 = state_47001;
var statearr_47033_50145 = state_47001__$1;
(statearr_47033_50145[(2)] = null);

(statearr_47033_50145[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47002 === (4))){
var inst_46970 = (state_47001[(7)]);
var inst_46970__$1 = (state_47001[(2)]);
var inst_46971 = (inst_46970__$1 == null);
var state_47001__$1 = (function (){var statearr_47034 = state_47001;
(statearr_47034[(7)] = inst_46970__$1);

return statearr_47034;
})();
if(cljs.core.truth_(inst_46971)){
var statearr_47035_50146 = state_47001__$1;
(statearr_47035_50146[(1)] = (5));

} else {
var statearr_47039_50147 = state_47001__$1;
(statearr_47039_50147[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47002 === (13))){
var state_47001__$1 = state_47001;
var statearr_47041_50148 = state_47001__$1;
(statearr_47041_50148[(2)] = null);

(statearr_47041_50148[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47002 === (6))){
var inst_46970 = (state_47001[(7)]);
var inst_46979 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_46970) : p.call(null,inst_46970));
var state_47001__$1 = state_47001;
if(cljs.core.truth_(inst_46979)){
var statearr_47042_50150 = state_47001__$1;
(statearr_47042_50150[(1)] = (9));

} else {
var statearr_47043_50151 = state_47001__$1;
(statearr_47043_50151[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47002 === (3))){
var inst_46996 = (state_47001[(2)]);
var state_47001__$1 = state_47001;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47001__$1,inst_46996);
} else {
if((state_val_47002 === (12))){
var state_47001__$1 = state_47001;
var statearr_47045_50152 = state_47001__$1;
(statearr_47045_50152[(2)] = null);

(statearr_47045_50152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47002 === (2))){
var state_47001__$1 = state_47001;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47001__$1,(4),ch);
} else {
if((state_val_47002 === (11))){
var inst_46970 = (state_47001[(7)]);
var inst_46985 = (state_47001[(2)]);
var state_47001__$1 = state_47001;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47001__$1,(8),inst_46985,inst_46970);
} else {
if((state_val_47002 === (9))){
var state_47001__$1 = state_47001;
var statearr_47047_50157 = state_47001__$1;
(statearr_47047_50157[(2)] = tc);

(statearr_47047_50157[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47002 === (5))){
var inst_46976 = cljs.core.async.close_BANG_(tc);
var inst_46977 = cljs.core.async.close_BANG_(fc);
var state_47001__$1 = (function (){var statearr_47048 = state_47001;
(statearr_47048[(8)] = inst_46976);

return statearr_47048;
})();
var statearr_47049_50161 = state_47001__$1;
(statearr_47049_50161[(2)] = inst_46977);

(statearr_47049_50161[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47002 === (14))){
var inst_46992 = (state_47001[(2)]);
var state_47001__$1 = state_47001;
var statearr_47050_50163 = state_47001__$1;
(statearr_47050_50163[(2)] = inst_46992);

(statearr_47050_50163[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47002 === (10))){
var state_47001__$1 = state_47001;
var statearr_47051_50164 = state_47001__$1;
(statearr_47051_50164[(2)] = fc);

(statearr_47051_50164[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47002 === (8))){
var inst_46987 = (state_47001[(2)]);
var state_47001__$1 = state_47001;
if(cljs.core.truth_(inst_46987)){
var statearr_47054_50165 = state_47001__$1;
(statearr_47054_50165[(1)] = (12));

} else {
var statearr_47055_50166 = state_47001__$1;
(statearr_47055_50166[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45666__auto__ = null;
var cljs$core$async$state_machine__45666__auto____0 = (function (){
var statearr_47056 = [null,null,null,null,null,null,null,null,null];
(statearr_47056[(0)] = cljs$core$async$state_machine__45666__auto__);

(statearr_47056[(1)] = (1));

return statearr_47056;
});
var cljs$core$async$state_machine__45666__auto____1 = (function (state_47001){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_47001);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e47061){var ex__45669__auto__ = e47061;
var statearr_47062_50172 = state_47001;
(statearr_47062_50172[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_47001[(4)]))){
var statearr_47067_50175 = state_47001;
(statearr_47067_50175[(1)] = cljs.core.first((state_47001[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50176 = state_47001;
state_47001 = G__50176;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$state_machine__45666__auto__ = function(state_47001){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45666__auto____1.call(this,state_47001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45666__auto____0;
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45666__auto____1;
return cljs$core$async$state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_47072 = f__45765__auto__();
(statearr_47072[(6)] = c__45764__auto___50142);

return statearr_47072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__45764__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_47101){
var state_val_47102 = (state_47101[(1)]);
if((state_val_47102 === (7))){
var inst_47097 = (state_47101[(2)]);
var state_47101__$1 = state_47101;
var statearr_47110_50183 = state_47101__$1;
(statearr_47110_50183[(2)] = inst_47097);

(statearr_47110_50183[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47102 === (1))){
var inst_47077 = init;
var inst_47078 = inst_47077;
var state_47101__$1 = (function (){var statearr_47111 = state_47101;
(statearr_47111[(7)] = inst_47078);

return statearr_47111;
})();
var statearr_47113_50184 = state_47101__$1;
(statearr_47113_50184[(2)] = null);

(statearr_47113_50184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47102 === (4))){
var inst_47081 = (state_47101[(8)]);
var inst_47081__$1 = (state_47101[(2)]);
var inst_47082 = (inst_47081__$1 == null);
var state_47101__$1 = (function (){var statearr_47118 = state_47101;
(statearr_47118[(8)] = inst_47081__$1);

return statearr_47118;
})();
if(cljs.core.truth_(inst_47082)){
var statearr_47119_50185 = state_47101__$1;
(statearr_47119_50185[(1)] = (5));

} else {
var statearr_47120_50186 = state_47101__$1;
(statearr_47120_50186[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47102 === (6))){
var inst_47081 = (state_47101[(8)]);
var inst_47078 = (state_47101[(7)]);
var inst_47087 = (state_47101[(9)]);
var inst_47087__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_47078,inst_47081) : f.call(null,inst_47078,inst_47081));
var inst_47088 = cljs.core.reduced_QMARK_(inst_47087__$1);
var state_47101__$1 = (function (){var statearr_47121 = state_47101;
(statearr_47121[(9)] = inst_47087__$1);

return statearr_47121;
})();
if(inst_47088){
var statearr_47124_50187 = state_47101__$1;
(statearr_47124_50187[(1)] = (8));

} else {
var statearr_47126_50188 = state_47101__$1;
(statearr_47126_50188[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47102 === (3))){
var inst_47099 = (state_47101[(2)]);
var state_47101__$1 = state_47101;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47101__$1,inst_47099);
} else {
if((state_val_47102 === (2))){
var state_47101__$1 = state_47101;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47101__$1,(4),ch);
} else {
if((state_val_47102 === (9))){
var inst_47087 = (state_47101[(9)]);
var inst_47078 = inst_47087;
var state_47101__$1 = (function (){var statearr_47131 = state_47101;
(statearr_47131[(7)] = inst_47078);

return statearr_47131;
})();
var statearr_47133_50189 = state_47101__$1;
(statearr_47133_50189[(2)] = null);

(statearr_47133_50189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47102 === (5))){
var inst_47078 = (state_47101[(7)]);
var state_47101__$1 = state_47101;
var statearr_47178_50190 = state_47101__$1;
(statearr_47178_50190[(2)] = inst_47078);

(statearr_47178_50190[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47102 === (10))){
var inst_47095 = (state_47101[(2)]);
var state_47101__$1 = state_47101;
var statearr_47193_50191 = state_47101__$1;
(statearr_47193_50191[(2)] = inst_47095);

(statearr_47193_50191[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47102 === (8))){
var inst_47087 = (state_47101[(9)]);
var inst_47091 = cljs.core.deref(inst_47087);
var state_47101__$1 = state_47101;
var statearr_47207_50193 = state_47101__$1;
(statearr_47207_50193[(2)] = inst_47091);

(statearr_47207_50193[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__45666__auto__ = null;
var cljs$core$async$reduce_$_state_machine__45666__auto____0 = (function (){
var statearr_47208 = [null,null,null,null,null,null,null,null,null,null];
(statearr_47208[(0)] = cljs$core$async$reduce_$_state_machine__45666__auto__);

(statearr_47208[(1)] = (1));

return statearr_47208;
});
var cljs$core$async$reduce_$_state_machine__45666__auto____1 = (function (state_47101){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_47101);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e47212){var ex__45669__auto__ = e47212;
var statearr_47213_50197 = state_47101;
(statearr_47213_50197[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_47101[(4)]))){
var statearr_47215_50199 = state_47101;
(statearr_47215_50199[(1)] = cljs.core.first((state_47101[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50202 = state_47101;
state_47101 = G__50202;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__45666__auto__ = function(state_47101){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__45666__auto____1.call(this,state_47101);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__45666__auto____0;
cljs$core$async$reduce_$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__45666__auto____1;
return cljs$core$async$reduce_$_state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_47219 = f__45765__auto__();
(statearr_47219[(6)] = c__45764__auto__);

return statearr_47219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));

return c__45764__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__45764__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_47226){
var state_val_47227 = (state_47226[(1)]);
if((state_val_47227 === (1))){
var inst_47221 = cljs.core.async.reduce(f__$1,init,ch);
var state_47226__$1 = state_47226;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47226__$1,(2),inst_47221);
} else {
if((state_val_47227 === (2))){
var inst_47223 = (state_47226[(2)]);
var inst_47224 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_47223) : f__$1.call(null,inst_47223));
var state_47226__$1 = state_47226;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47226__$1,inst_47224);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__45666__auto__ = null;
var cljs$core$async$transduce_$_state_machine__45666__auto____0 = (function (){
var statearr_47232 = [null,null,null,null,null,null,null];
(statearr_47232[(0)] = cljs$core$async$transduce_$_state_machine__45666__auto__);

(statearr_47232[(1)] = (1));

return statearr_47232;
});
var cljs$core$async$transduce_$_state_machine__45666__auto____1 = (function (state_47226){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_47226);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e47233){var ex__45669__auto__ = e47233;
var statearr_47234_50205 = state_47226;
(statearr_47234_50205[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_47226[(4)]))){
var statearr_47238_50207 = state_47226;
(statearr_47238_50207[(1)] = cljs.core.first((state_47226[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50210 = state_47226;
state_47226 = G__50210;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__45666__auto__ = function(state_47226){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__45666__auto____1.call(this,state_47226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__45666__auto____0;
cljs$core$async$transduce_$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__45666__auto____1;
return cljs$core$async$transduce_$_state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_47239 = f__45765__auto__();
(statearr_47239[(6)] = c__45764__auto__);

return statearr_47239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));

return c__45764__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__47247 = arguments.length;
switch (G__47247) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__45764__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_47272){
var state_val_47273 = (state_47272[(1)]);
if((state_val_47273 === (7))){
var inst_47254 = (state_47272[(2)]);
var state_47272__$1 = state_47272;
var statearr_47274_50214 = state_47272__$1;
(statearr_47274_50214[(2)] = inst_47254);

(statearr_47274_50214[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47273 === (1))){
var inst_47248 = cljs.core.seq(coll);
var inst_47249 = inst_47248;
var state_47272__$1 = (function (){var statearr_47275 = state_47272;
(statearr_47275[(7)] = inst_47249);

return statearr_47275;
})();
var statearr_47276_50215 = state_47272__$1;
(statearr_47276_50215[(2)] = null);

(statearr_47276_50215[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47273 === (4))){
var inst_47249 = (state_47272[(7)]);
var inst_47252 = cljs.core.first(inst_47249);
var state_47272__$1 = state_47272;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47272__$1,(7),ch,inst_47252);
} else {
if((state_val_47273 === (13))){
var inst_47266 = (state_47272[(2)]);
var state_47272__$1 = state_47272;
var statearr_47280_50218 = state_47272__$1;
(statearr_47280_50218[(2)] = inst_47266);

(statearr_47280_50218[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47273 === (6))){
var inst_47257 = (state_47272[(2)]);
var state_47272__$1 = state_47272;
if(cljs.core.truth_(inst_47257)){
var statearr_47281_50219 = state_47272__$1;
(statearr_47281_50219[(1)] = (8));

} else {
var statearr_47282_50220 = state_47272__$1;
(statearr_47282_50220[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47273 === (3))){
var inst_47270 = (state_47272[(2)]);
var state_47272__$1 = state_47272;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47272__$1,inst_47270);
} else {
if((state_val_47273 === (12))){
var state_47272__$1 = state_47272;
var statearr_47283_50221 = state_47272__$1;
(statearr_47283_50221[(2)] = null);

(statearr_47283_50221[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47273 === (2))){
var inst_47249 = (state_47272[(7)]);
var state_47272__$1 = state_47272;
if(cljs.core.truth_(inst_47249)){
var statearr_47284_50223 = state_47272__$1;
(statearr_47284_50223[(1)] = (4));

} else {
var statearr_47285_50224 = state_47272__$1;
(statearr_47285_50224[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47273 === (11))){
var inst_47263 = cljs.core.async.close_BANG_(ch);
var state_47272__$1 = state_47272;
var statearr_47290_50227 = state_47272__$1;
(statearr_47290_50227[(2)] = inst_47263);

(statearr_47290_50227[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47273 === (9))){
var state_47272__$1 = state_47272;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47291_50229 = state_47272__$1;
(statearr_47291_50229[(1)] = (11));

} else {
var statearr_47292_50231 = state_47272__$1;
(statearr_47292_50231[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47273 === (5))){
var inst_47249 = (state_47272[(7)]);
var state_47272__$1 = state_47272;
var statearr_47293_50234 = state_47272__$1;
(statearr_47293_50234[(2)] = inst_47249);

(statearr_47293_50234[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47273 === (10))){
var inst_47268 = (state_47272[(2)]);
var state_47272__$1 = state_47272;
var statearr_47294_50238 = state_47272__$1;
(statearr_47294_50238[(2)] = inst_47268);

(statearr_47294_50238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47273 === (8))){
var inst_47249 = (state_47272[(7)]);
var inst_47259 = cljs.core.next(inst_47249);
var inst_47249__$1 = inst_47259;
var state_47272__$1 = (function (){var statearr_47295 = state_47272;
(statearr_47295[(7)] = inst_47249__$1);

return statearr_47295;
})();
var statearr_47297_50240 = state_47272__$1;
(statearr_47297_50240[(2)] = null);

(statearr_47297_50240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45666__auto__ = null;
var cljs$core$async$state_machine__45666__auto____0 = (function (){
var statearr_47298 = [null,null,null,null,null,null,null,null];
(statearr_47298[(0)] = cljs$core$async$state_machine__45666__auto__);

(statearr_47298[(1)] = (1));

return statearr_47298;
});
var cljs$core$async$state_machine__45666__auto____1 = (function (state_47272){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_47272);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e47299){var ex__45669__auto__ = e47299;
var statearr_47300_50251 = state_47272;
(statearr_47300_50251[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_47272[(4)]))){
var statearr_47304_50252 = state_47272;
(statearr_47304_50252[(1)] = cljs.core.first((state_47272[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50253 = state_47272;
state_47272 = G__50253;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$state_machine__45666__auto__ = function(state_47272){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45666__auto____1.call(this,state_47272);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45666__auto____0;
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45666__auto____1;
return cljs$core$async$state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_47305 = f__45765__auto__();
(statearr_47305[(6)] = c__45764__auto__);

return statearr_47305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));

return c__45764__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__47313 = arguments.length;
switch (G__47313) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_50262 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_50262(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_50265 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_50265(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_50268 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_50268(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_50272 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_50272(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47330 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47330 = (function (ch,cs,meta47331){
this.ch = ch;
this.cs = cs;
this.meta47331 = meta47331;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47330.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47332,meta47331__$1){
var self__ = this;
var _47332__$1 = this;
return (new cljs.core.async.t_cljs$core$async47330(self__.ch,self__.cs,meta47331__$1));
}));

(cljs.core.async.t_cljs$core$async47330.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47332){
var self__ = this;
var _47332__$1 = this;
return self__.meta47331;
}));

(cljs.core.async.t_cljs$core$async47330.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47330.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async47330.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47330.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async47330.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async47330.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async47330.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta47331","meta47331",1399060365,null)], null);
}));

(cljs.core.async.t_cljs$core$async47330.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47330.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47330");

(cljs.core.async.t_cljs$core$async47330.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47330");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47330.
 */
cljs.core.async.__GT_t_cljs$core$async47330 = (function cljs$core$async$mult_$___GT_t_cljs$core$async47330(ch__$1,cs__$1,meta47331){
return (new cljs.core.async.t_cljs$core$async47330(ch__$1,cs__$1,meta47331));
});

}

return (new cljs.core.async.t_cljs$core$async47330(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__45764__auto___50287 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_47621){
var state_val_47623 = (state_47621[(1)]);
if((state_val_47623 === (7))){
var inst_47611 = (state_47621[(2)]);
var state_47621__$1 = state_47621;
var statearr_47628_50290 = state_47621__$1;
(statearr_47628_50290[(2)] = inst_47611);

(statearr_47628_50290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (20))){
var inst_47495 = (state_47621[(7)]);
var inst_47510 = cljs.core.first(inst_47495);
var inst_47511 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47510,(0),null);
var inst_47512 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47510,(1),null);
var state_47621__$1 = (function (){var statearr_47631 = state_47621;
(statearr_47631[(8)] = inst_47511);

return statearr_47631;
})();
if(cljs.core.truth_(inst_47512)){
var statearr_47632_50292 = state_47621__$1;
(statearr_47632_50292[(1)] = (22));

} else {
var statearr_47633_50293 = state_47621__$1;
(statearr_47633_50293[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (27))){
var inst_47547 = (state_47621[(9)]);
var inst_47545 = (state_47621[(10)]);
var inst_47556 = (state_47621[(11)]);
var inst_47382 = (state_47621[(12)]);
var inst_47556__$1 = cljs.core._nth(inst_47545,inst_47547);
var inst_47558 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_47556__$1,inst_47382,done);
var state_47621__$1 = (function (){var statearr_47636 = state_47621;
(statearr_47636[(11)] = inst_47556__$1);

return statearr_47636;
})();
if(cljs.core.truth_(inst_47558)){
var statearr_47637_50297 = state_47621__$1;
(statearr_47637_50297[(1)] = (30));

} else {
var statearr_47638_50298 = state_47621__$1;
(statearr_47638_50298[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (1))){
var state_47621__$1 = state_47621;
var statearr_47639_50299 = state_47621__$1;
(statearr_47639_50299[(2)] = null);

(statearr_47639_50299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (24))){
var inst_47495 = (state_47621[(7)]);
var inst_47520 = (state_47621[(2)]);
var inst_47521 = cljs.core.next(inst_47495);
var inst_47398 = inst_47521;
var inst_47399 = null;
var inst_47400 = (0);
var inst_47401 = (0);
var state_47621__$1 = (function (){var statearr_47641 = state_47621;
(statearr_47641[(13)] = inst_47401);

(statearr_47641[(14)] = inst_47400);

(statearr_47641[(15)] = inst_47520);

(statearr_47641[(16)] = inst_47398);

(statearr_47641[(17)] = inst_47399);

return statearr_47641;
})();
var statearr_47643_50308 = state_47621__$1;
(statearr_47643_50308[(2)] = null);

(statearr_47643_50308[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (39))){
var state_47621__$1 = state_47621;
var statearr_47647_50309 = state_47621__$1;
(statearr_47647_50309[(2)] = null);

(statearr_47647_50309[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (4))){
var inst_47382 = (state_47621[(12)]);
var inst_47382__$1 = (state_47621[(2)]);
var inst_47385 = (inst_47382__$1 == null);
var state_47621__$1 = (function (){var statearr_47650 = state_47621;
(statearr_47650[(12)] = inst_47382__$1);

return statearr_47650;
})();
if(cljs.core.truth_(inst_47385)){
var statearr_47652_50311 = state_47621__$1;
(statearr_47652_50311[(1)] = (5));

} else {
var statearr_47653_50312 = state_47621__$1;
(statearr_47653_50312[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (15))){
var inst_47401 = (state_47621[(13)]);
var inst_47400 = (state_47621[(14)]);
var inst_47398 = (state_47621[(16)]);
var inst_47399 = (state_47621[(17)]);
var inst_47490 = (state_47621[(2)]);
var inst_47491 = (inst_47401 + (1));
var tmp47644 = inst_47400;
var tmp47645 = inst_47398;
var tmp47646 = inst_47399;
var inst_47398__$1 = tmp47645;
var inst_47399__$1 = tmp47646;
var inst_47400__$1 = tmp47644;
var inst_47401__$1 = inst_47491;
var state_47621__$1 = (function (){var statearr_47654 = state_47621;
(statearr_47654[(18)] = inst_47490);

(statearr_47654[(13)] = inst_47401__$1);

(statearr_47654[(14)] = inst_47400__$1);

(statearr_47654[(16)] = inst_47398__$1);

(statearr_47654[(17)] = inst_47399__$1);

return statearr_47654;
})();
var statearr_47655_50316 = state_47621__$1;
(statearr_47655_50316[(2)] = null);

(statearr_47655_50316[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (21))){
var inst_47524 = (state_47621[(2)]);
var state_47621__$1 = state_47621;
var statearr_47659_50318 = state_47621__$1;
(statearr_47659_50318[(2)] = inst_47524);

(statearr_47659_50318[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (31))){
var inst_47556 = (state_47621[(11)]);
var inst_47561 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_47556);
var state_47621__$1 = state_47621;
var statearr_47664_50320 = state_47621__$1;
(statearr_47664_50320[(2)] = inst_47561);

(statearr_47664_50320[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (32))){
var inst_47547 = (state_47621[(9)]);
var inst_47545 = (state_47621[(10)]);
var inst_47544 = (state_47621[(19)]);
var inst_47546 = (state_47621[(20)]);
var inst_47563 = (state_47621[(2)]);
var inst_47564 = (inst_47547 + (1));
var tmp47656 = inst_47545;
var tmp47657 = inst_47544;
var tmp47658 = inst_47546;
var inst_47544__$1 = tmp47657;
var inst_47545__$1 = tmp47656;
var inst_47546__$1 = tmp47658;
var inst_47547__$1 = inst_47564;
var state_47621__$1 = (function (){var statearr_47732 = state_47621;
(statearr_47732[(9)] = inst_47547__$1);

(statearr_47732[(10)] = inst_47545__$1);

(statearr_47732[(19)] = inst_47544__$1);

(statearr_47732[(20)] = inst_47546__$1);

(statearr_47732[(21)] = inst_47563);

return statearr_47732;
})();
var statearr_47733_50322 = state_47621__$1;
(statearr_47733_50322[(2)] = null);

(statearr_47733_50322[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (40))){
var inst_47581 = (state_47621[(22)]);
var inst_47588 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_47581);
var state_47621__$1 = state_47621;
var statearr_47734_50325 = state_47621__$1;
(statearr_47734_50325[(2)] = inst_47588);

(statearr_47734_50325[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (33))){
var inst_47567 = (state_47621[(23)]);
var inst_47573 = cljs.core.chunked_seq_QMARK_(inst_47567);
var state_47621__$1 = state_47621;
if(inst_47573){
var statearr_47735_50326 = state_47621__$1;
(statearr_47735_50326[(1)] = (36));

} else {
var statearr_47736_50327 = state_47621__$1;
(statearr_47736_50327[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (13))){
var inst_47484 = (state_47621[(24)]);
var inst_47487 = cljs.core.async.close_BANG_(inst_47484);
var state_47621__$1 = state_47621;
var statearr_47737_50330 = state_47621__$1;
(statearr_47737_50330[(2)] = inst_47487);

(statearr_47737_50330[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (22))){
var inst_47511 = (state_47621[(8)]);
var inst_47517 = cljs.core.async.close_BANG_(inst_47511);
var state_47621__$1 = state_47621;
var statearr_47738_50331 = state_47621__$1;
(statearr_47738_50331[(2)] = inst_47517);

(statearr_47738_50331[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (36))){
var inst_47567 = (state_47621[(23)]);
var inst_47575 = cljs.core.chunk_first(inst_47567);
var inst_47577 = cljs.core.chunk_rest(inst_47567);
var inst_47578 = cljs.core.count(inst_47575);
var inst_47544 = inst_47577;
var inst_47545 = inst_47575;
var inst_47546 = inst_47578;
var inst_47547 = (0);
var state_47621__$1 = (function (){var statearr_47739 = state_47621;
(statearr_47739[(9)] = inst_47547);

(statearr_47739[(10)] = inst_47545);

(statearr_47739[(19)] = inst_47544);

(statearr_47739[(20)] = inst_47546);

return statearr_47739;
})();
var statearr_47740_50338 = state_47621__$1;
(statearr_47740_50338[(2)] = null);

(statearr_47740_50338[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (41))){
var inst_47567 = (state_47621[(23)]);
var inst_47590 = (state_47621[(2)]);
var inst_47591 = cljs.core.next(inst_47567);
var inst_47544 = inst_47591;
var inst_47545 = null;
var inst_47546 = (0);
var inst_47547 = (0);
var state_47621__$1 = (function (){var statearr_47741 = state_47621;
(statearr_47741[(9)] = inst_47547);

(statearr_47741[(10)] = inst_47545);

(statearr_47741[(19)] = inst_47544);

(statearr_47741[(20)] = inst_47546);

(statearr_47741[(25)] = inst_47590);

return statearr_47741;
})();
var statearr_47742_50340 = state_47621__$1;
(statearr_47742_50340[(2)] = null);

(statearr_47742_50340[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (43))){
var state_47621__$1 = state_47621;
var statearr_47743_50341 = state_47621__$1;
(statearr_47743_50341[(2)] = null);

(statearr_47743_50341[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (29))){
var inst_47599 = (state_47621[(2)]);
var state_47621__$1 = state_47621;
var statearr_47744_50343 = state_47621__$1;
(statearr_47744_50343[(2)] = inst_47599);

(statearr_47744_50343[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (44))){
var inst_47608 = (state_47621[(2)]);
var state_47621__$1 = (function (){var statearr_47749 = state_47621;
(statearr_47749[(26)] = inst_47608);

return statearr_47749;
})();
var statearr_47750_50345 = state_47621__$1;
(statearr_47750_50345[(2)] = null);

(statearr_47750_50345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (6))){
var inst_47535 = (state_47621[(27)]);
var inst_47534 = cljs.core.deref(cs);
var inst_47535__$1 = cljs.core.keys(inst_47534);
var inst_47536 = cljs.core.count(inst_47535__$1);
var inst_47537 = cljs.core.reset_BANG_(dctr,inst_47536);
var inst_47543 = cljs.core.seq(inst_47535__$1);
var inst_47544 = inst_47543;
var inst_47545 = null;
var inst_47546 = (0);
var inst_47547 = (0);
var state_47621__$1 = (function (){var statearr_47751 = state_47621;
(statearr_47751[(9)] = inst_47547);

(statearr_47751[(27)] = inst_47535__$1);

(statearr_47751[(10)] = inst_47545);

(statearr_47751[(19)] = inst_47544);

(statearr_47751[(20)] = inst_47546);

(statearr_47751[(28)] = inst_47537);

return statearr_47751;
})();
var statearr_47753_50349 = state_47621__$1;
(statearr_47753_50349[(2)] = null);

(statearr_47753_50349[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (28))){
var inst_47544 = (state_47621[(19)]);
var inst_47567 = (state_47621[(23)]);
var inst_47567__$1 = cljs.core.seq(inst_47544);
var state_47621__$1 = (function (){var statearr_47759 = state_47621;
(statearr_47759[(23)] = inst_47567__$1);

return statearr_47759;
})();
if(inst_47567__$1){
var statearr_47760_50350 = state_47621__$1;
(statearr_47760_50350[(1)] = (33));

} else {
var statearr_47761_50351 = state_47621__$1;
(statearr_47761_50351[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (25))){
var inst_47547 = (state_47621[(9)]);
var inst_47546 = (state_47621[(20)]);
var inst_47551 = (inst_47547 < inst_47546);
var inst_47552 = inst_47551;
var state_47621__$1 = state_47621;
if(cljs.core.truth_(inst_47552)){
var statearr_47763_50353 = state_47621__$1;
(statearr_47763_50353[(1)] = (27));

} else {
var statearr_47764_50354 = state_47621__$1;
(statearr_47764_50354[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (34))){
var state_47621__$1 = state_47621;
var statearr_47774_50355 = state_47621__$1;
(statearr_47774_50355[(2)] = null);

(statearr_47774_50355[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (17))){
var state_47621__$1 = state_47621;
var statearr_47775_50357 = state_47621__$1;
(statearr_47775_50357[(2)] = null);

(statearr_47775_50357[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (3))){
var inst_47613 = (state_47621[(2)]);
var state_47621__$1 = state_47621;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47621__$1,inst_47613);
} else {
if((state_val_47623 === (12))){
var inst_47530 = (state_47621[(2)]);
var state_47621__$1 = state_47621;
var statearr_47776_50359 = state_47621__$1;
(statearr_47776_50359[(2)] = inst_47530);

(statearr_47776_50359[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (2))){
var state_47621__$1 = state_47621;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47621__$1,(4),ch);
} else {
if((state_val_47623 === (23))){
var state_47621__$1 = state_47621;
var statearr_47778_50361 = state_47621__$1;
(statearr_47778_50361[(2)] = null);

(statearr_47778_50361[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (35))){
var inst_47597 = (state_47621[(2)]);
var state_47621__$1 = state_47621;
var statearr_47779_50364 = state_47621__$1;
(statearr_47779_50364[(2)] = inst_47597);

(statearr_47779_50364[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (19))){
var inst_47495 = (state_47621[(7)]);
var inst_47502 = cljs.core.chunk_first(inst_47495);
var inst_47503 = cljs.core.chunk_rest(inst_47495);
var inst_47504 = cljs.core.count(inst_47502);
var inst_47398 = inst_47503;
var inst_47399 = inst_47502;
var inst_47400 = inst_47504;
var inst_47401 = (0);
var state_47621__$1 = (function (){var statearr_47782 = state_47621;
(statearr_47782[(13)] = inst_47401);

(statearr_47782[(14)] = inst_47400);

(statearr_47782[(16)] = inst_47398);

(statearr_47782[(17)] = inst_47399);

return statearr_47782;
})();
var statearr_47783_50367 = state_47621__$1;
(statearr_47783_50367[(2)] = null);

(statearr_47783_50367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (11))){
var inst_47398 = (state_47621[(16)]);
var inst_47495 = (state_47621[(7)]);
var inst_47495__$1 = cljs.core.seq(inst_47398);
var state_47621__$1 = (function (){var statearr_47785 = state_47621;
(statearr_47785[(7)] = inst_47495__$1);

return statearr_47785;
})();
if(inst_47495__$1){
var statearr_47786_50368 = state_47621__$1;
(statearr_47786_50368[(1)] = (16));

} else {
var statearr_47787_50369 = state_47621__$1;
(statearr_47787_50369[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (9))){
var inst_47532 = (state_47621[(2)]);
var state_47621__$1 = state_47621;
var statearr_47788_50371 = state_47621__$1;
(statearr_47788_50371[(2)] = inst_47532);

(statearr_47788_50371[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (5))){
var inst_47394 = cljs.core.deref(cs);
var inst_47395 = cljs.core.seq(inst_47394);
var inst_47398 = inst_47395;
var inst_47399 = null;
var inst_47400 = (0);
var inst_47401 = (0);
var state_47621__$1 = (function (){var statearr_47789 = state_47621;
(statearr_47789[(13)] = inst_47401);

(statearr_47789[(14)] = inst_47400);

(statearr_47789[(16)] = inst_47398);

(statearr_47789[(17)] = inst_47399);

return statearr_47789;
})();
var statearr_47790_50374 = state_47621__$1;
(statearr_47790_50374[(2)] = null);

(statearr_47790_50374[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (14))){
var state_47621__$1 = state_47621;
var statearr_47791_50381 = state_47621__$1;
(statearr_47791_50381[(2)] = null);

(statearr_47791_50381[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (45))){
var inst_47605 = (state_47621[(2)]);
var state_47621__$1 = state_47621;
var statearr_47792_50382 = state_47621__$1;
(statearr_47792_50382[(2)] = inst_47605);

(statearr_47792_50382[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (26))){
var inst_47535 = (state_47621[(27)]);
var inst_47601 = (state_47621[(2)]);
var inst_47602 = cljs.core.seq(inst_47535);
var state_47621__$1 = (function (){var statearr_47793 = state_47621;
(statearr_47793[(29)] = inst_47601);

return statearr_47793;
})();
if(inst_47602){
var statearr_47794_50385 = state_47621__$1;
(statearr_47794_50385[(1)] = (42));

} else {
var statearr_47795_50386 = state_47621__$1;
(statearr_47795_50386[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (16))){
var inst_47495 = (state_47621[(7)]);
var inst_47500 = cljs.core.chunked_seq_QMARK_(inst_47495);
var state_47621__$1 = state_47621;
if(inst_47500){
var statearr_47796_50387 = state_47621__$1;
(statearr_47796_50387[(1)] = (19));

} else {
var statearr_47798_50388 = state_47621__$1;
(statearr_47798_50388[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (38))){
var inst_47594 = (state_47621[(2)]);
var state_47621__$1 = state_47621;
var statearr_47799_50389 = state_47621__$1;
(statearr_47799_50389[(2)] = inst_47594);

(statearr_47799_50389[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (30))){
var state_47621__$1 = state_47621;
var statearr_47800_50390 = state_47621__$1;
(statearr_47800_50390[(2)] = null);

(statearr_47800_50390[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (10))){
var inst_47401 = (state_47621[(13)]);
var inst_47399 = (state_47621[(17)]);
var inst_47410 = cljs.core._nth(inst_47399,inst_47401);
var inst_47484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47410,(0),null);
var inst_47485 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47410,(1),null);
var state_47621__$1 = (function (){var statearr_47801 = state_47621;
(statearr_47801[(24)] = inst_47484);

return statearr_47801;
})();
if(cljs.core.truth_(inst_47485)){
var statearr_47802_50394 = state_47621__$1;
(statearr_47802_50394[(1)] = (13));

} else {
var statearr_47803_50395 = state_47621__$1;
(statearr_47803_50395[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (18))){
var inst_47528 = (state_47621[(2)]);
var state_47621__$1 = state_47621;
var statearr_47804_50396 = state_47621__$1;
(statearr_47804_50396[(2)] = inst_47528);

(statearr_47804_50396[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (42))){
var state_47621__$1 = state_47621;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47621__$1,(45),dchan);
} else {
if((state_val_47623 === (37))){
var inst_47581 = (state_47621[(22)]);
var inst_47382 = (state_47621[(12)]);
var inst_47567 = (state_47621[(23)]);
var inst_47581__$1 = cljs.core.first(inst_47567);
var inst_47582 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_47581__$1,inst_47382,done);
var state_47621__$1 = (function (){var statearr_47805 = state_47621;
(statearr_47805[(22)] = inst_47581__$1);

return statearr_47805;
})();
if(cljs.core.truth_(inst_47582)){
var statearr_47806_50398 = state_47621__$1;
(statearr_47806_50398[(1)] = (39));

} else {
var statearr_47807_50399 = state_47621__$1;
(statearr_47807_50399[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47623 === (8))){
var inst_47401 = (state_47621[(13)]);
var inst_47400 = (state_47621[(14)]);
var inst_47404 = (inst_47401 < inst_47400);
var inst_47405 = inst_47404;
var state_47621__$1 = state_47621;
if(cljs.core.truth_(inst_47405)){
var statearr_47808_50402 = state_47621__$1;
(statearr_47808_50402[(1)] = (10));

} else {
var statearr_47809_50403 = state_47621__$1;
(statearr_47809_50403[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__45666__auto__ = null;
var cljs$core$async$mult_$_state_machine__45666__auto____0 = (function (){
var statearr_47810 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47810[(0)] = cljs$core$async$mult_$_state_machine__45666__auto__);

(statearr_47810[(1)] = (1));

return statearr_47810;
});
var cljs$core$async$mult_$_state_machine__45666__auto____1 = (function (state_47621){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_47621);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e47811){var ex__45669__auto__ = e47811;
var statearr_47812_50406 = state_47621;
(statearr_47812_50406[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_47621[(4)]))){
var statearr_47814_50410 = state_47621;
(statearr_47814_50410[(1)] = cljs.core.first((state_47621[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50411 = state_47621;
state_47621 = G__50411;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__45666__auto__ = function(state_47621){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__45666__auto____1.call(this,state_47621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__45666__auto____0;
cljs$core$async$mult_$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__45666__auto____1;
return cljs$core$async$mult_$_state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_47815 = f__45765__auto__();
(statearr_47815[(6)] = c__45764__auto___50287);

return statearr_47815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__47817 = arguments.length;
switch (G__47817) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_50421 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_50421(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_50429 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_50429(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_50433 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_50433(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_50442 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_50442(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_50445 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_50445(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___50446 = arguments.length;
var i__4737__auto___50447 = (0);
while(true){
if((i__4737__auto___50447 < len__4736__auto___50446)){
args__4742__auto__.push((arguments[i__4737__auto___50447]));

var G__50448 = (i__4737__auto___50447 + (1));
i__4737__auto___50447 = G__50448;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__47872){
var map__47875 = p__47872;
var map__47875__$1 = (((((!((map__47875 == null))))?(((((map__47875.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47875.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47875):map__47875);
var opts = map__47875__$1;
var statearr_47879_50452 = state;
(statearr_47879_50452[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_47880_50454 = state;
(statearr_47880_50454[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_47882_50456 = state;
(statearr_47882_50456[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq47861){
var G__47863 = cljs.core.first(seq47861);
var seq47861__$1 = cljs.core.next(seq47861);
var G__47864 = cljs.core.first(seq47861__$1);
var seq47861__$2 = cljs.core.next(seq47861__$1);
var G__47865 = cljs.core.first(seq47861__$2);
var seq47861__$3 = cljs.core.next(seq47861__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47863,G__47864,G__47865,seq47861__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47928 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47928 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta47929){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta47929 = meta47929;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47928.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47930,meta47929__$1){
var self__ = this;
var _47930__$1 = this;
return (new cljs.core.async.t_cljs$core$async47928(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta47929__$1));
}));

(cljs.core.async.t_cljs$core$async47928.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47930){
var self__ = this;
var _47930__$1 = this;
return self__.meta47929;
}));

(cljs.core.async.t_cljs$core$async47928.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47928.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async47928.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47928.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async47928.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async47928.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async47928.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async47928.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async47928.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta47929","meta47929",-1643069887,null)], null);
}));

(cljs.core.async.t_cljs$core$async47928.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47928.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47928");

(cljs.core.async.t_cljs$core$async47928.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47928");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47928.
 */
cljs.core.async.__GT_t_cljs$core$async47928 = (function cljs$core$async$mix_$___GT_t_cljs$core$async47928(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta47929){
return (new cljs.core.async.t_cljs$core$async47928(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta47929));
});

}

return (new cljs.core.async.t_cljs$core$async47928(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__45764__auto___50477 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_48073){
var state_val_48074 = (state_48073[(1)]);
if((state_val_48074 === (7))){
var inst_47961 = (state_48073[(2)]);
var state_48073__$1 = state_48073;
var statearr_48085_50479 = state_48073__$1;
(statearr_48085_50479[(2)] = inst_47961);

(statearr_48085_50479[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (20))){
var inst_47975 = (state_48073[(7)]);
var state_48073__$1 = state_48073;
var statearr_48089_50480 = state_48073__$1;
(statearr_48089_50480[(2)] = inst_47975);

(statearr_48089_50480[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (27))){
var state_48073__$1 = state_48073;
var statearr_48096_50482 = state_48073__$1;
(statearr_48096_50482[(2)] = null);

(statearr_48096_50482[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (1))){
var inst_47947 = (state_48073[(8)]);
var inst_47947__$1 = calc_state();
var inst_47949 = (inst_47947__$1 == null);
var inst_47950 = cljs.core.not(inst_47949);
var state_48073__$1 = (function (){var statearr_48101 = state_48073;
(statearr_48101[(8)] = inst_47947__$1);

return statearr_48101;
})();
if(inst_47950){
var statearr_48102_50484 = state_48073__$1;
(statearr_48102_50484[(1)] = (2));

} else {
var statearr_48103_50485 = state_48073__$1;
(statearr_48103_50485[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (24))){
var inst_48039 = (state_48073[(9)]);
var inst_48000 = (state_48073[(10)]);
var inst_48009 = (state_48073[(11)]);
var inst_48039__$1 = (inst_48000.cljs$core$IFn$_invoke$arity$1 ? inst_48000.cljs$core$IFn$_invoke$arity$1(inst_48009) : inst_48000.call(null,inst_48009));
var state_48073__$1 = (function (){var statearr_48104 = state_48073;
(statearr_48104[(9)] = inst_48039__$1);

return statearr_48104;
})();
if(cljs.core.truth_(inst_48039__$1)){
var statearr_48105_50487 = state_48073__$1;
(statearr_48105_50487[(1)] = (29));

} else {
var statearr_48106_50488 = state_48073__$1;
(statearr_48106_50488[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (4))){
var inst_47964 = (state_48073[(2)]);
var state_48073__$1 = state_48073;
if(cljs.core.truth_(inst_47964)){
var statearr_48107_50490 = state_48073__$1;
(statearr_48107_50490[(1)] = (8));

} else {
var statearr_48109_50491 = state_48073__$1;
(statearr_48109_50491[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (15))){
var inst_47994 = (state_48073[(2)]);
var state_48073__$1 = state_48073;
if(cljs.core.truth_(inst_47994)){
var statearr_48113_50493 = state_48073__$1;
(statearr_48113_50493[(1)] = (19));

} else {
var statearr_48114_50494 = state_48073__$1;
(statearr_48114_50494[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (21))){
var inst_47999 = (state_48073[(12)]);
var inst_47999__$1 = (state_48073[(2)]);
var inst_48000 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47999__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_48001 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47999__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_48002 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47999__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_48073__$1 = (function (){var statearr_48115 = state_48073;
(statearr_48115[(12)] = inst_47999__$1);

(statearr_48115[(13)] = inst_48001);

(statearr_48115[(10)] = inst_48000);

return statearr_48115;
})();
return cljs.core.async.ioc_alts_BANG_(state_48073__$1,(22),inst_48002);
} else {
if((state_val_48074 === (31))){
var inst_48047 = (state_48073[(2)]);
var state_48073__$1 = state_48073;
if(cljs.core.truth_(inst_48047)){
var statearr_48119_50496 = state_48073__$1;
(statearr_48119_50496[(1)] = (32));

} else {
var statearr_48121_50497 = state_48073__$1;
(statearr_48121_50497[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (32))){
var inst_48008 = (state_48073[(14)]);
var state_48073__$1 = state_48073;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48073__$1,(35),out,inst_48008);
} else {
if((state_val_48074 === (33))){
var inst_47999 = (state_48073[(12)]);
var inst_47975 = inst_47999;
var state_48073__$1 = (function (){var statearr_48131 = state_48073;
(statearr_48131[(7)] = inst_47975);

return statearr_48131;
})();
var statearr_48132_50499 = state_48073__$1;
(statearr_48132_50499[(2)] = null);

(statearr_48132_50499[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (13))){
var inst_47975 = (state_48073[(7)]);
var inst_47983 = inst_47975.cljs$lang$protocol_mask$partition0$;
var inst_47984 = (inst_47983 & (64));
var inst_47985 = inst_47975.cljs$core$ISeq$;
var inst_47986 = (cljs.core.PROTOCOL_SENTINEL === inst_47985);
var inst_47987 = ((inst_47984) || (inst_47986));
var state_48073__$1 = state_48073;
if(cljs.core.truth_(inst_47987)){
var statearr_48133_50501 = state_48073__$1;
(statearr_48133_50501[(1)] = (16));

} else {
var statearr_48134_50502 = state_48073__$1;
(statearr_48134_50502[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (22))){
var inst_48008 = (state_48073[(14)]);
var inst_48009 = (state_48073[(11)]);
var inst_48007 = (state_48073[(2)]);
var inst_48008__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48007,(0),null);
var inst_48009__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48007,(1),null);
var inst_48010 = (inst_48008__$1 == null);
var inst_48011 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48009__$1,change);
var inst_48012 = ((inst_48010) || (inst_48011));
var state_48073__$1 = (function (){var statearr_48141 = state_48073;
(statearr_48141[(14)] = inst_48008__$1);

(statearr_48141[(11)] = inst_48009__$1);

return statearr_48141;
})();
if(cljs.core.truth_(inst_48012)){
var statearr_48147_50504 = state_48073__$1;
(statearr_48147_50504[(1)] = (23));

} else {
var statearr_48149_50505 = state_48073__$1;
(statearr_48149_50505[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (36))){
var inst_47999 = (state_48073[(12)]);
var inst_47975 = inst_47999;
var state_48073__$1 = (function (){var statearr_48156 = state_48073;
(statearr_48156[(7)] = inst_47975);

return statearr_48156;
})();
var statearr_48158_50507 = state_48073__$1;
(statearr_48158_50507[(2)] = null);

(statearr_48158_50507[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (29))){
var inst_48039 = (state_48073[(9)]);
var state_48073__$1 = state_48073;
var statearr_48165_50509 = state_48073__$1;
(statearr_48165_50509[(2)] = inst_48039);

(statearr_48165_50509[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (6))){
var state_48073__$1 = state_48073;
var statearr_48167_50510 = state_48073__$1;
(statearr_48167_50510[(2)] = false);

(statearr_48167_50510[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (28))){
var inst_48019 = (state_48073[(2)]);
var inst_48020 = calc_state();
var inst_47975 = inst_48020;
var state_48073__$1 = (function (){var statearr_48169 = state_48073;
(statearr_48169[(15)] = inst_48019);

(statearr_48169[(7)] = inst_47975);

return statearr_48169;
})();
var statearr_48170_50512 = state_48073__$1;
(statearr_48170_50512[(2)] = null);

(statearr_48170_50512[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (25))){
var inst_48062 = (state_48073[(2)]);
var state_48073__$1 = state_48073;
var statearr_48175_50513 = state_48073__$1;
(statearr_48175_50513[(2)] = inst_48062);

(statearr_48175_50513[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (34))){
var inst_48060 = (state_48073[(2)]);
var state_48073__$1 = state_48073;
var statearr_48182_50515 = state_48073__$1;
(statearr_48182_50515[(2)] = inst_48060);

(statearr_48182_50515[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (17))){
var state_48073__$1 = state_48073;
var statearr_48189_50516 = state_48073__$1;
(statearr_48189_50516[(2)] = false);

(statearr_48189_50516[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (3))){
var state_48073__$1 = state_48073;
var statearr_48195_50517 = state_48073__$1;
(statearr_48195_50517[(2)] = false);

(statearr_48195_50517[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (12))){
var inst_48065 = (state_48073[(2)]);
var state_48073__$1 = state_48073;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48073__$1,inst_48065);
} else {
if((state_val_48074 === (2))){
var inst_47947 = (state_48073[(8)]);
var inst_47953 = inst_47947.cljs$lang$protocol_mask$partition0$;
var inst_47954 = (inst_47953 & (64));
var inst_47955 = inst_47947.cljs$core$ISeq$;
var inst_47956 = (cljs.core.PROTOCOL_SENTINEL === inst_47955);
var inst_47957 = ((inst_47954) || (inst_47956));
var state_48073__$1 = state_48073;
if(cljs.core.truth_(inst_47957)){
var statearr_48196_50519 = state_48073__$1;
(statearr_48196_50519[(1)] = (5));

} else {
var statearr_48201_50520 = state_48073__$1;
(statearr_48201_50520[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (23))){
var inst_48008 = (state_48073[(14)]);
var inst_48014 = (inst_48008 == null);
var state_48073__$1 = state_48073;
if(cljs.core.truth_(inst_48014)){
var statearr_48207_50522 = state_48073__$1;
(statearr_48207_50522[(1)] = (26));

} else {
var statearr_48210_50523 = state_48073__$1;
(statearr_48210_50523[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (35))){
var inst_48050 = (state_48073[(2)]);
var state_48073__$1 = state_48073;
if(cljs.core.truth_(inst_48050)){
var statearr_48225_50524 = state_48073__$1;
(statearr_48225_50524[(1)] = (36));

} else {
var statearr_48226_50526 = state_48073__$1;
(statearr_48226_50526[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (19))){
var inst_47975 = (state_48073[(7)]);
var inst_47996 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_47975);
var state_48073__$1 = state_48073;
var statearr_48233_50527 = state_48073__$1;
(statearr_48233_50527[(2)] = inst_47996);

(statearr_48233_50527[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (11))){
var inst_47975 = (state_48073[(7)]);
var inst_47980 = (inst_47975 == null);
var inst_47981 = cljs.core.not(inst_47980);
var state_48073__$1 = state_48073;
if(inst_47981){
var statearr_48237_50529 = state_48073__$1;
(statearr_48237_50529[(1)] = (13));

} else {
var statearr_48238_50530 = state_48073__$1;
(statearr_48238_50530[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (9))){
var inst_47947 = (state_48073[(8)]);
var state_48073__$1 = state_48073;
var statearr_48239_50531 = state_48073__$1;
(statearr_48239_50531[(2)] = inst_47947);

(statearr_48239_50531[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (5))){
var state_48073__$1 = state_48073;
var statearr_48240_50532 = state_48073__$1;
(statearr_48240_50532[(2)] = true);

(statearr_48240_50532[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (14))){
var state_48073__$1 = state_48073;
var statearr_48241_50533 = state_48073__$1;
(statearr_48241_50533[(2)] = false);

(statearr_48241_50533[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (26))){
var inst_48009 = (state_48073[(11)]);
var inst_48016 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_48009);
var state_48073__$1 = state_48073;
var statearr_48246_50534 = state_48073__$1;
(statearr_48246_50534[(2)] = inst_48016);

(statearr_48246_50534[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (16))){
var state_48073__$1 = state_48073;
var statearr_48247_50535 = state_48073__$1;
(statearr_48247_50535[(2)] = true);

(statearr_48247_50535[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (38))){
var inst_48056 = (state_48073[(2)]);
var state_48073__$1 = state_48073;
var statearr_48258_50536 = state_48073__$1;
(statearr_48258_50536[(2)] = inst_48056);

(statearr_48258_50536[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (30))){
var inst_48001 = (state_48073[(13)]);
var inst_48000 = (state_48073[(10)]);
var inst_48009 = (state_48073[(11)]);
var inst_48042 = cljs.core.empty_QMARK_(inst_48000);
var inst_48043 = (inst_48001.cljs$core$IFn$_invoke$arity$1 ? inst_48001.cljs$core$IFn$_invoke$arity$1(inst_48009) : inst_48001.call(null,inst_48009));
var inst_48044 = cljs.core.not(inst_48043);
var inst_48045 = ((inst_48042) && (inst_48044));
var state_48073__$1 = state_48073;
var statearr_48265_50537 = state_48073__$1;
(statearr_48265_50537[(2)] = inst_48045);

(statearr_48265_50537[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (10))){
var inst_47947 = (state_48073[(8)]);
var inst_47970 = (state_48073[(2)]);
var inst_47971 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47970,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_47973 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47970,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_47974 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47970,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_47975 = inst_47947;
var state_48073__$1 = (function (){var statearr_48266 = state_48073;
(statearr_48266[(16)] = inst_47973);

(statearr_48266[(17)] = inst_47971);

(statearr_48266[(18)] = inst_47974);

(statearr_48266[(7)] = inst_47975);

return statearr_48266;
})();
var statearr_48267_50539 = state_48073__$1;
(statearr_48267_50539[(2)] = null);

(statearr_48267_50539[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (18))){
var inst_47991 = (state_48073[(2)]);
var state_48073__$1 = state_48073;
var statearr_48268_50540 = state_48073__$1;
(statearr_48268_50540[(2)] = inst_47991);

(statearr_48268_50540[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (37))){
var state_48073__$1 = state_48073;
var statearr_48269_50541 = state_48073__$1;
(statearr_48269_50541[(2)] = null);

(statearr_48269_50541[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48074 === (8))){
var inst_47947 = (state_48073[(8)]);
var inst_47967 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_47947);
var state_48073__$1 = state_48073;
var statearr_48270_50543 = state_48073__$1;
(statearr_48270_50543[(2)] = inst_47967);

(statearr_48270_50543[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__45666__auto__ = null;
var cljs$core$async$mix_$_state_machine__45666__auto____0 = (function (){
var statearr_48276 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48276[(0)] = cljs$core$async$mix_$_state_machine__45666__auto__);

(statearr_48276[(1)] = (1));

return statearr_48276;
});
var cljs$core$async$mix_$_state_machine__45666__auto____1 = (function (state_48073){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_48073);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e48277){var ex__45669__auto__ = e48277;
var statearr_48280_50546 = state_48073;
(statearr_48280_50546[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_48073[(4)]))){
var statearr_48281_50547 = state_48073;
(statearr_48281_50547[(1)] = cljs.core.first((state_48073[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50548 = state_48073;
state_48073 = G__50548;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__45666__auto__ = function(state_48073){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__45666__auto____1.call(this,state_48073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__45666__auto____0;
cljs$core$async$mix_$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__45666__auto____1;
return cljs$core$async$mix_$_state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_48282 = f__45765__auto__();
(statearr_48282[(6)] = c__45764__auto___50477);

return statearr_48282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_50550 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_50550(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_50553 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_50553(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_50555 = (function() {
var G__50556 = null;
var G__50556__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__50556__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__50556 = function(p,v){
switch(arguments.length){
case 1:
return G__50556__1.call(this,p);
case 2:
return G__50556__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__50556.cljs$core$IFn$_invoke$arity$1 = G__50556__1;
G__50556.cljs$core$IFn$_invoke$arity$2 = G__50556__2;
return G__50556;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__48307 = arguments.length;
switch (G__48307) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_50555(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_50555(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__48316 = arguments.length;
switch (G__48316) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__48314_SHARP_){
if(cljs.core.truth_((p1__48314_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__48314_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__48314_SHARP_.call(null,topic)))){
return p1__48314_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__48314_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48335 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48335 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta48336){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta48336 = meta48336;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48335.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48337,meta48336__$1){
var self__ = this;
var _48337__$1 = this;
return (new cljs.core.async.t_cljs$core$async48335(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta48336__$1));
}));

(cljs.core.async.t_cljs$core$async48335.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48337){
var self__ = this;
var _48337__$1 = this;
return self__.meta48336;
}));

(cljs.core.async.t_cljs$core$async48335.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48335.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async48335.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48335.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async48335.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async48335.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async48335.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async48335.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta48336","meta48336",-1285132828,null)], null);
}));

(cljs.core.async.t_cljs$core$async48335.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48335.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48335");

(cljs.core.async.t_cljs$core$async48335.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48335");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48335.
 */
cljs.core.async.__GT_t_cljs$core$async48335 = (function cljs$core$async$__GT_t_cljs$core$async48335(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta48336){
return (new cljs.core.async.t_cljs$core$async48335(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta48336));
});

}

return (new cljs.core.async.t_cljs$core$async48335(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__45764__auto___50568 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_48498){
var state_val_48499 = (state_48498[(1)]);
if((state_val_48499 === (7))){
var inst_48477 = (state_48498[(2)]);
var state_48498__$1 = state_48498;
var statearr_48503_50570 = state_48498__$1;
(statearr_48503_50570[(2)] = inst_48477);

(statearr_48503_50570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (20))){
var state_48498__$1 = state_48498;
var statearr_48505_50572 = state_48498__$1;
(statearr_48505_50572[(2)] = null);

(statearr_48505_50572[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (1))){
var state_48498__$1 = state_48498;
var statearr_48509_50573 = state_48498__$1;
(statearr_48509_50573[(2)] = null);

(statearr_48509_50573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (24))){
var inst_48444 = (state_48498[(7)]);
var inst_48469 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_48444);
var state_48498__$1 = state_48498;
var statearr_48510_50574 = state_48498__$1;
(statearr_48510_50574[(2)] = inst_48469);

(statearr_48510_50574[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (4))){
var inst_48355 = (state_48498[(8)]);
var inst_48355__$1 = (state_48498[(2)]);
var inst_48356 = (inst_48355__$1 == null);
var state_48498__$1 = (function (){var statearr_48514 = state_48498;
(statearr_48514[(8)] = inst_48355__$1);

return statearr_48514;
})();
if(cljs.core.truth_(inst_48356)){
var statearr_48515_50576 = state_48498__$1;
(statearr_48515_50576[(1)] = (5));

} else {
var statearr_48516_50577 = state_48498__$1;
(statearr_48516_50577[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (15))){
var inst_48418 = (state_48498[(2)]);
var state_48498__$1 = state_48498;
var statearr_48517_50578 = state_48498__$1;
(statearr_48517_50578[(2)] = inst_48418);

(statearr_48517_50578[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (21))){
var inst_48474 = (state_48498[(2)]);
var state_48498__$1 = (function (){var statearr_48518 = state_48498;
(statearr_48518[(9)] = inst_48474);

return statearr_48518;
})();
var statearr_48519_50580 = state_48498__$1;
(statearr_48519_50580[(2)] = null);

(statearr_48519_50580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (13))){
var inst_48400 = (state_48498[(10)]);
var inst_48402 = cljs.core.chunked_seq_QMARK_(inst_48400);
var state_48498__$1 = state_48498;
if(inst_48402){
var statearr_48522_50581 = state_48498__$1;
(statearr_48522_50581[(1)] = (16));

} else {
var statearr_48523_50582 = state_48498__$1;
(statearr_48523_50582[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (22))){
var inst_48462 = (state_48498[(2)]);
var state_48498__$1 = state_48498;
if(cljs.core.truth_(inst_48462)){
var statearr_48524_50584 = state_48498__$1;
(statearr_48524_50584[(1)] = (23));

} else {
var statearr_48526_50585 = state_48498__$1;
(statearr_48526_50585[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (6))){
var inst_48444 = (state_48498[(7)]);
var inst_48355 = (state_48498[(8)]);
var inst_48450 = (state_48498[(11)]);
var inst_48444__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_48355) : topic_fn.call(null,inst_48355));
var inst_48448 = cljs.core.deref(mults);
var inst_48450__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48448,inst_48444__$1);
var state_48498__$1 = (function (){var statearr_48533 = state_48498;
(statearr_48533[(7)] = inst_48444__$1);

(statearr_48533[(11)] = inst_48450__$1);

return statearr_48533;
})();
if(cljs.core.truth_(inst_48450__$1)){
var statearr_48534_50587 = state_48498__$1;
(statearr_48534_50587[(1)] = (19));

} else {
var statearr_48535_50588 = state_48498__$1;
(statearr_48535_50588[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (25))){
var inst_48471 = (state_48498[(2)]);
var state_48498__$1 = state_48498;
var statearr_48539_50589 = state_48498__$1;
(statearr_48539_50589[(2)] = inst_48471);

(statearr_48539_50589[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (17))){
var inst_48400 = (state_48498[(10)]);
var inst_48409 = cljs.core.first(inst_48400);
var inst_48410 = cljs.core.async.muxch_STAR_(inst_48409);
var inst_48411 = cljs.core.async.close_BANG_(inst_48410);
var inst_48412 = cljs.core.next(inst_48400);
var inst_48365 = inst_48412;
var inst_48366 = null;
var inst_48367 = (0);
var inst_48368 = (0);
var state_48498__$1 = (function (){var statearr_48540 = state_48498;
(statearr_48540[(12)] = inst_48368);

(statearr_48540[(13)] = inst_48365);

(statearr_48540[(14)] = inst_48367);

(statearr_48540[(15)] = inst_48411);

(statearr_48540[(16)] = inst_48366);

return statearr_48540;
})();
var statearr_48542_50591 = state_48498__$1;
(statearr_48542_50591[(2)] = null);

(statearr_48542_50591[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (3))){
var inst_48479 = (state_48498[(2)]);
var state_48498__$1 = state_48498;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48498__$1,inst_48479);
} else {
if((state_val_48499 === (12))){
var inst_48420 = (state_48498[(2)]);
var state_48498__$1 = state_48498;
var statearr_48546_50593 = state_48498__$1;
(statearr_48546_50593[(2)] = inst_48420);

(statearr_48546_50593[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (2))){
var state_48498__$1 = state_48498;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48498__$1,(4),ch);
} else {
if((state_val_48499 === (23))){
var state_48498__$1 = state_48498;
var statearr_48547_50594 = state_48498__$1;
(statearr_48547_50594[(2)] = null);

(statearr_48547_50594[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (19))){
var inst_48355 = (state_48498[(8)]);
var inst_48450 = (state_48498[(11)]);
var inst_48460 = cljs.core.async.muxch_STAR_(inst_48450);
var state_48498__$1 = state_48498;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48498__$1,(22),inst_48460,inst_48355);
} else {
if((state_val_48499 === (11))){
var inst_48365 = (state_48498[(13)]);
var inst_48400 = (state_48498[(10)]);
var inst_48400__$1 = cljs.core.seq(inst_48365);
var state_48498__$1 = (function (){var statearr_48548 = state_48498;
(statearr_48548[(10)] = inst_48400__$1);

return statearr_48548;
})();
if(inst_48400__$1){
var statearr_48551_50596 = state_48498__$1;
(statearr_48551_50596[(1)] = (13));

} else {
var statearr_48553_50597 = state_48498__$1;
(statearr_48553_50597[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (9))){
var inst_48422 = (state_48498[(2)]);
var state_48498__$1 = state_48498;
var statearr_48554_50599 = state_48498__$1;
(statearr_48554_50599[(2)] = inst_48422);

(statearr_48554_50599[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (5))){
var inst_48362 = cljs.core.deref(mults);
var inst_48363 = cljs.core.vals(inst_48362);
var inst_48364 = cljs.core.seq(inst_48363);
var inst_48365 = inst_48364;
var inst_48366 = null;
var inst_48367 = (0);
var inst_48368 = (0);
var state_48498__$1 = (function (){var statearr_48558 = state_48498;
(statearr_48558[(12)] = inst_48368);

(statearr_48558[(13)] = inst_48365);

(statearr_48558[(14)] = inst_48367);

(statearr_48558[(16)] = inst_48366);

return statearr_48558;
})();
var statearr_48559_50600 = state_48498__$1;
(statearr_48559_50600[(2)] = null);

(statearr_48559_50600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (14))){
var state_48498__$1 = state_48498;
var statearr_48566_50602 = state_48498__$1;
(statearr_48566_50602[(2)] = null);

(statearr_48566_50602[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (16))){
var inst_48400 = (state_48498[(10)]);
var inst_48404 = cljs.core.chunk_first(inst_48400);
var inst_48405 = cljs.core.chunk_rest(inst_48400);
var inst_48406 = cljs.core.count(inst_48404);
var inst_48365 = inst_48405;
var inst_48366 = inst_48404;
var inst_48367 = inst_48406;
var inst_48368 = (0);
var state_48498__$1 = (function (){var statearr_48567 = state_48498;
(statearr_48567[(12)] = inst_48368);

(statearr_48567[(13)] = inst_48365);

(statearr_48567[(14)] = inst_48367);

(statearr_48567[(16)] = inst_48366);

return statearr_48567;
})();
var statearr_48568_50604 = state_48498__$1;
(statearr_48568_50604[(2)] = null);

(statearr_48568_50604[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (10))){
var inst_48368 = (state_48498[(12)]);
var inst_48365 = (state_48498[(13)]);
var inst_48367 = (state_48498[(14)]);
var inst_48366 = (state_48498[(16)]);
var inst_48377 = cljs.core._nth(inst_48366,inst_48368);
var inst_48382 = cljs.core.async.muxch_STAR_(inst_48377);
var inst_48383 = cljs.core.async.close_BANG_(inst_48382);
var inst_48384 = (inst_48368 + (1));
var tmp48562 = inst_48365;
var tmp48563 = inst_48367;
var tmp48564 = inst_48366;
var inst_48365__$1 = tmp48562;
var inst_48366__$1 = tmp48564;
var inst_48367__$1 = tmp48563;
var inst_48368__$1 = inst_48384;
var state_48498__$1 = (function (){var statearr_48571 = state_48498;
(statearr_48571[(12)] = inst_48368__$1);

(statearr_48571[(13)] = inst_48365__$1);

(statearr_48571[(14)] = inst_48367__$1);

(statearr_48571[(17)] = inst_48383);

(statearr_48571[(16)] = inst_48366__$1);

return statearr_48571;
})();
var statearr_48573_50607 = state_48498__$1;
(statearr_48573_50607[(2)] = null);

(statearr_48573_50607[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (18))){
var inst_48415 = (state_48498[(2)]);
var state_48498__$1 = state_48498;
var statearr_48576_50608 = state_48498__$1;
(statearr_48576_50608[(2)] = inst_48415);

(statearr_48576_50608[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48499 === (8))){
var inst_48368 = (state_48498[(12)]);
var inst_48367 = (state_48498[(14)]);
var inst_48370 = (inst_48368 < inst_48367);
var inst_48371 = inst_48370;
var state_48498__$1 = state_48498;
if(cljs.core.truth_(inst_48371)){
var statearr_48577_50610 = state_48498__$1;
(statearr_48577_50610[(1)] = (10));

} else {
var statearr_48578_50611 = state_48498__$1;
(statearr_48578_50611[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45666__auto__ = null;
var cljs$core$async$state_machine__45666__auto____0 = (function (){
var statearr_48580 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48580[(0)] = cljs$core$async$state_machine__45666__auto__);

(statearr_48580[(1)] = (1));

return statearr_48580;
});
var cljs$core$async$state_machine__45666__auto____1 = (function (state_48498){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_48498);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e48581){var ex__45669__auto__ = e48581;
var statearr_48582_50613 = state_48498;
(statearr_48582_50613[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_48498[(4)]))){
var statearr_48583_50614 = state_48498;
(statearr_48583_50614[(1)] = cljs.core.first((state_48498[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50616 = state_48498;
state_48498 = G__50616;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$state_machine__45666__auto__ = function(state_48498){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45666__auto____1.call(this,state_48498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45666__auto____0;
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45666__auto____1;
return cljs$core$async$state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_48586 = f__45765__auto__();
(statearr_48586[(6)] = c__45764__auto___50568);

return statearr_48586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__48593 = arguments.length;
switch (G__48593) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__48598 = arguments.length;
switch (G__48598) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__48600 = arguments.length;
switch (G__48600) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__45764__auto___50625 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_48650){
var state_val_48651 = (state_48650[(1)]);
if((state_val_48651 === (7))){
var state_48650__$1 = state_48650;
var statearr_48653_50626 = state_48650__$1;
(statearr_48653_50626[(2)] = null);

(statearr_48653_50626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48651 === (1))){
var state_48650__$1 = state_48650;
var statearr_48656_50628 = state_48650__$1;
(statearr_48656_50628[(2)] = null);

(statearr_48656_50628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48651 === (4))){
var inst_48607 = (state_48650[(7)]);
var inst_48608 = (state_48650[(8)]);
var inst_48610 = (inst_48608 < inst_48607);
var state_48650__$1 = state_48650;
if(cljs.core.truth_(inst_48610)){
var statearr_48657_50630 = state_48650__$1;
(statearr_48657_50630[(1)] = (6));

} else {
var statearr_48658_50631 = state_48650__$1;
(statearr_48658_50631[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48651 === (15))){
var inst_48633 = (state_48650[(9)]);
var inst_48638 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_48633);
var state_48650__$1 = state_48650;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48650__$1,(17),out,inst_48638);
} else {
if((state_val_48651 === (13))){
var inst_48633 = (state_48650[(9)]);
var inst_48633__$1 = (state_48650[(2)]);
var inst_48634 = cljs.core.some(cljs.core.nil_QMARK_,inst_48633__$1);
var state_48650__$1 = (function (){var statearr_48661 = state_48650;
(statearr_48661[(9)] = inst_48633__$1);

return statearr_48661;
})();
if(cljs.core.truth_(inst_48634)){
var statearr_48663_50633 = state_48650__$1;
(statearr_48663_50633[(1)] = (14));

} else {
var statearr_48665_50634 = state_48650__$1;
(statearr_48665_50634[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48651 === (6))){
var state_48650__$1 = state_48650;
var statearr_48667_50635 = state_48650__$1;
(statearr_48667_50635[(2)] = null);

(statearr_48667_50635[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48651 === (17))){
var inst_48640 = (state_48650[(2)]);
var state_48650__$1 = (function (){var statearr_48669 = state_48650;
(statearr_48669[(10)] = inst_48640);

return statearr_48669;
})();
var statearr_48670_50637 = state_48650__$1;
(statearr_48670_50637[(2)] = null);

(statearr_48670_50637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48651 === (3))){
var inst_48645 = (state_48650[(2)]);
var state_48650__$1 = state_48650;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48650__$1,inst_48645);
} else {
if((state_val_48651 === (12))){
var _ = (function (){var statearr_48674 = state_48650;
(statearr_48674[(4)] = cljs.core.rest((state_48650[(4)])));

return statearr_48674;
})();
var state_48650__$1 = state_48650;
var ex48668 = (state_48650__$1[(2)]);
var statearr_48675_50639 = state_48650__$1;
(statearr_48675_50639[(5)] = ex48668);


if((ex48668 instanceof Object)){
var statearr_48676_50641 = state_48650__$1;
(statearr_48676_50641[(1)] = (11));

(statearr_48676_50641[(5)] = null);

} else {
throw ex48668;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48651 === (2))){
var inst_48606 = cljs.core.reset_BANG_(dctr,cnt);
var inst_48607 = cnt;
var inst_48608 = (0);
var state_48650__$1 = (function (){var statearr_48682 = state_48650;
(statearr_48682[(7)] = inst_48607);

(statearr_48682[(8)] = inst_48608);

(statearr_48682[(11)] = inst_48606);

return statearr_48682;
})();
var statearr_48683_50643 = state_48650__$1;
(statearr_48683_50643[(2)] = null);

(statearr_48683_50643[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48651 === (11))){
var inst_48612 = (state_48650[(2)]);
var inst_48613 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_48650__$1 = (function (){var statearr_48685 = state_48650;
(statearr_48685[(12)] = inst_48612);

return statearr_48685;
})();
var statearr_48686_50645 = state_48650__$1;
(statearr_48686_50645[(2)] = inst_48613);

(statearr_48686_50645[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48651 === (9))){
var inst_48608 = (state_48650[(8)]);
var _ = (function (){var statearr_48687 = state_48650;
(statearr_48687[(4)] = cljs.core.cons((12),(state_48650[(4)])));

return statearr_48687;
})();
var inst_48619 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_48608) : chs__$1.call(null,inst_48608));
var inst_48620 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_48608) : done.call(null,inst_48608));
var inst_48621 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_48619,inst_48620);
var ___$1 = (function (){var statearr_48688 = state_48650;
(statearr_48688[(4)] = cljs.core.rest((state_48650[(4)])));

return statearr_48688;
})();
var state_48650__$1 = state_48650;
var statearr_48689_50647 = state_48650__$1;
(statearr_48689_50647[(2)] = inst_48621);

(statearr_48689_50647[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48651 === (5))){
var inst_48631 = (state_48650[(2)]);
var state_48650__$1 = (function (){var statearr_48690 = state_48650;
(statearr_48690[(13)] = inst_48631);

return statearr_48690;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48650__$1,(13),dchan);
} else {
if((state_val_48651 === (14))){
var inst_48636 = cljs.core.async.close_BANG_(out);
var state_48650__$1 = state_48650;
var statearr_48693_50649 = state_48650__$1;
(statearr_48693_50649[(2)] = inst_48636);

(statearr_48693_50649[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48651 === (16))){
var inst_48643 = (state_48650[(2)]);
var state_48650__$1 = state_48650;
var statearr_48697_50651 = state_48650__$1;
(statearr_48697_50651[(2)] = inst_48643);

(statearr_48697_50651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48651 === (10))){
var inst_48608 = (state_48650[(8)]);
var inst_48624 = (state_48650[(2)]);
var inst_48625 = (inst_48608 + (1));
var inst_48608__$1 = inst_48625;
var state_48650__$1 = (function (){var statearr_48699 = state_48650;
(statearr_48699[(14)] = inst_48624);

(statearr_48699[(8)] = inst_48608__$1);

return statearr_48699;
})();
var statearr_48700_50653 = state_48650__$1;
(statearr_48700_50653[(2)] = null);

(statearr_48700_50653[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48651 === (8))){
var inst_48629 = (state_48650[(2)]);
var state_48650__$1 = state_48650;
var statearr_48702_50655 = state_48650__$1;
(statearr_48702_50655[(2)] = inst_48629);

(statearr_48702_50655[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45666__auto__ = null;
var cljs$core$async$state_machine__45666__auto____0 = (function (){
var statearr_48703 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48703[(0)] = cljs$core$async$state_machine__45666__auto__);

(statearr_48703[(1)] = (1));

return statearr_48703;
});
var cljs$core$async$state_machine__45666__auto____1 = (function (state_48650){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_48650);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e48708){var ex__45669__auto__ = e48708;
var statearr_48709_50657 = state_48650;
(statearr_48709_50657[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_48650[(4)]))){
var statearr_48710_50659 = state_48650;
(statearr_48710_50659[(1)] = cljs.core.first((state_48650[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50660 = state_48650;
state_48650 = G__50660;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$state_machine__45666__auto__ = function(state_48650){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45666__auto____1.call(this,state_48650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45666__auto____0;
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45666__auto____1;
return cljs$core$async$state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_48715 = f__45765__auto__();
(statearr_48715[(6)] = c__45764__auto___50625);

return statearr_48715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__48727 = arguments.length;
switch (G__48727) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45764__auto___50664 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_48768){
var state_val_48770 = (state_48768[(1)]);
if((state_val_48770 === (7))){
var inst_48741 = (state_48768[(7)]);
var inst_48742 = (state_48768[(8)]);
var inst_48741__$1 = (state_48768[(2)]);
var inst_48742__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48741__$1,(0),null);
var inst_48743 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48741__$1,(1),null);
var inst_48744 = (inst_48742__$1 == null);
var state_48768__$1 = (function (){var statearr_48772 = state_48768;
(statearr_48772[(9)] = inst_48743);

(statearr_48772[(7)] = inst_48741__$1);

(statearr_48772[(8)] = inst_48742__$1);

return statearr_48772;
})();
if(cljs.core.truth_(inst_48744)){
var statearr_48775_50667 = state_48768__$1;
(statearr_48775_50667[(1)] = (8));

} else {
var statearr_48776_50668 = state_48768__$1;
(statearr_48776_50668[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48770 === (1))){
var inst_48731 = cljs.core.vec(chs);
var inst_48732 = inst_48731;
var state_48768__$1 = (function (){var statearr_48777 = state_48768;
(statearr_48777[(10)] = inst_48732);

return statearr_48777;
})();
var statearr_48778_50670 = state_48768__$1;
(statearr_48778_50670[(2)] = null);

(statearr_48778_50670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48770 === (4))){
var inst_48732 = (state_48768[(10)]);
var state_48768__$1 = state_48768;
return cljs.core.async.ioc_alts_BANG_(state_48768__$1,(7),inst_48732);
} else {
if((state_val_48770 === (6))){
var inst_48762 = (state_48768[(2)]);
var state_48768__$1 = state_48768;
var statearr_48779_50672 = state_48768__$1;
(statearr_48779_50672[(2)] = inst_48762);

(statearr_48779_50672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48770 === (3))){
var inst_48764 = (state_48768[(2)]);
var state_48768__$1 = state_48768;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48768__$1,inst_48764);
} else {
if((state_val_48770 === (2))){
var inst_48732 = (state_48768[(10)]);
var inst_48734 = cljs.core.count(inst_48732);
var inst_48735 = (inst_48734 > (0));
var state_48768__$1 = state_48768;
if(cljs.core.truth_(inst_48735)){
var statearr_48783_50674 = state_48768__$1;
(statearr_48783_50674[(1)] = (4));

} else {
var statearr_48785_50675 = state_48768__$1;
(statearr_48785_50675[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48770 === (11))){
var inst_48732 = (state_48768[(10)]);
var inst_48751 = (state_48768[(2)]);
var tmp48780 = inst_48732;
var inst_48732__$1 = tmp48780;
var state_48768__$1 = (function (){var statearr_48786 = state_48768;
(statearr_48786[(11)] = inst_48751);

(statearr_48786[(10)] = inst_48732__$1);

return statearr_48786;
})();
var statearr_48787_50677 = state_48768__$1;
(statearr_48787_50677[(2)] = null);

(statearr_48787_50677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48770 === (9))){
var inst_48742 = (state_48768[(8)]);
var state_48768__$1 = state_48768;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48768__$1,(11),out,inst_48742);
} else {
if((state_val_48770 === (5))){
var inst_48760 = cljs.core.async.close_BANG_(out);
var state_48768__$1 = state_48768;
var statearr_48791_50679 = state_48768__$1;
(statearr_48791_50679[(2)] = inst_48760);

(statearr_48791_50679[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48770 === (10))){
var inst_48755 = (state_48768[(2)]);
var state_48768__$1 = state_48768;
var statearr_48792_50680 = state_48768__$1;
(statearr_48792_50680[(2)] = inst_48755);

(statearr_48792_50680[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48770 === (8))){
var inst_48743 = (state_48768[(9)]);
var inst_48741 = (state_48768[(7)]);
var inst_48742 = (state_48768[(8)]);
var inst_48732 = (state_48768[(10)]);
var inst_48746 = (function (){var cs = inst_48732;
var vec__48737 = inst_48741;
var v = inst_48742;
var c = inst_48743;
return (function (p1__48724_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__48724_SHARP_);
});
})();
var inst_48747 = cljs.core.filterv(inst_48746,inst_48732);
var inst_48732__$1 = inst_48747;
var state_48768__$1 = (function (){var statearr_48793 = state_48768;
(statearr_48793[(10)] = inst_48732__$1);

return statearr_48793;
})();
var statearr_48794_50683 = state_48768__$1;
(statearr_48794_50683[(2)] = null);

(statearr_48794_50683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45666__auto__ = null;
var cljs$core$async$state_machine__45666__auto____0 = (function (){
var statearr_48795 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48795[(0)] = cljs$core$async$state_machine__45666__auto__);

(statearr_48795[(1)] = (1));

return statearr_48795;
});
var cljs$core$async$state_machine__45666__auto____1 = (function (state_48768){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_48768);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e48797){var ex__45669__auto__ = e48797;
var statearr_48798_50685 = state_48768;
(statearr_48798_50685[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_48768[(4)]))){
var statearr_48800_50687 = state_48768;
(statearr_48800_50687[(1)] = cljs.core.first((state_48768[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50688 = state_48768;
state_48768 = G__50688;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$state_machine__45666__auto__ = function(state_48768){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45666__auto____1.call(this,state_48768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45666__auto____0;
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45666__auto____1;
return cljs$core$async$state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_48801 = f__45765__auto__();
(statearr_48801[(6)] = c__45764__auto___50664);

return statearr_48801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__48805 = arguments.length;
switch (G__48805) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45764__auto___50692 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_48839){
var state_val_48840 = (state_48839[(1)]);
if((state_val_48840 === (7))){
var inst_48820 = (state_48839[(7)]);
var inst_48820__$1 = (state_48839[(2)]);
var inst_48821 = (inst_48820__$1 == null);
var inst_48822 = cljs.core.not(inst_48821);
var state_48839__$1 = (function (){var statearr_48849 = state_48839;
(statearr_48849[(7)] = inst_48820__$1);

return statearr_48849;
})();
if(inst_48822){
var statearr_48850_50695 = state_48839__$1;
(statearr_48850_50695[(1)] = (8));

} else {
var statearr_48852_50696 = state_48839__$1;
(statearr_48852_50696[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48840 === (1))){
var inst_48812 = (0);
var state_48839__$1 = (function (){var statearr_48854 = state_48839;
(statearr_48854[(8)] = inst_48812);

return statearr_48854;
})();
var statearr_48856_50697 = state_48839__$1;
(statearr_48856_50697[(2)] = null);

(statearr_48856_50697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48840 === (4))){
var state_48839__$1 = state_48839;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48839__$1,(7),ch);
} else {
if((state_val_48840 === (6))){
var inst_48834 = (state_48839[(2)]);
var state_48839__$1 = state_48839;
var statearr_48857_50699 = state_48839__$1;
(statearr_48857_50699[(2)] = inst_48834);

(statearr_48857_50699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48840 === (3))){
var inst_48836 = (state_48839[(2)]);
var inst_48837 = cljs.core.async.close_BANG_(out);
var state_48839__$1 = (function (){var statearr_48861 = state_48839;
(statearr_48861[(9)] = inst_48836);

return statearr_48861;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_48839__$1,inst_48837);
} else {
if((state_val_48840 === (2))){
var inst_48812 = (state_48839[(8)]);
var inst_48815 = (inst_48812 < n);
var state_48839__$1 = state_48839;
if(cljs.core.truth_(inst_48815)){
var statearr_48864_50701 = state_48839__$1;
(statearr_48864_50701[(1)] = (4));

} else {
var statearr_48867_50703 = state_48839__$1;
(statearr_48867_50703[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48840 === (11))){
var inst_48812 = (state_48839[(8)]);
var inst_48826 = (state_48839[(2)]);
var inst_48827 = (inst_48812 + (1));
var inst_48812__$1 = inst_48827;
var state_48839__$1 = (function (){var statearr_48868 = state_48839;
(statearr_48868[(8)] = inst_48812__$1);

(statearr_48868[(10)] = inst_48826);

return statearr_48868;
})();
var statearr_48869_50705 = state_48839__$1;
(statearr_48869_50705[(2)] = null);

(statearr_48869_50705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48840 === (9))){
var state_48839__$1 = state_48839;
var statearr_48871_50706 = state_48839__$1;
(statearr_48871_50706[(2)] = null);

(statearr_48871_50706[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48840 === (5))){
var state_48839__$1 = state_48839;
var statearr_48872_50707 = state_48839__$1;
(statearr_48872_50707[(2)] = null);

(statearr_48872_50707[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48840 === (10))){
var inst_48831 = (state_48839[(2)]);
var state_48839__$1 = state_48839;
var statearr_48873_50709 = state_48839__$1;
(statearr_48873_50709[(2)] = inst_48831);

(statearr_48873_50709[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48840 === (8))){
var inst_48820 = (state_48839[(7)]);
var state_48839__$1 = state_48839;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48839__$1,(11),out,inst_48820);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45666__auto__ = null;
var cljs$core$async$state_machine__45666__auto____0 = (function (){
var statearr_48876 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48876[(0)] = cljs$core$async$state_machine__45666__auto__);

(statearr_48876[(1)] = (1));

return statearr_48876;
});
var cljs$core$async$state_machine__45666__auto____1 = (function (state_48839){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_48839);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e48878){var ex__45669__auto__ = e48878;
var statearr_48879_50712 = state_48839;
(statearr_48879_50712[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_48839[(4)]))){
var statearr_48881_50713 = state_48839;
(statearr_48881_50713[(1)] = cljs.core.first((state_48839[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50714 = state_48839;
state_48839 = G__50714;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$state_machine__45666__auto__ = function(state_48839){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45666__auto____1.call(this,state_48839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45666__auto____0;
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45666__auto____1;
return cljs$core$async$state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_48883 = f__45765__auto__();
(statearr_48883[(6)] = c__45764__auto___50692);

return statearr_48883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48891 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48891 = (function (f,ch,meta48892){
this.f = f;
this.ch = ch;
this.meta48892 = meta48892;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48891.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48893,meta48892__$1){
var self__ = this;
var _48893__$1 = this;
return (new cljs.core.async.t_cljs$core$async48891(self__.f,self__.ch,meta48892__$1));
}));

(cljs.core.async.t_cljs$core$async48891.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48893){
var self__ = this;
var _48893__$1 = this;
return self__.meta48892;
}));

(cljs.core.async.t_cljs$core$async48891.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48891.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48891.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48891.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48891.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48913 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48913 = (function (f,ch,meta48892,_,fn1,meta48914){
this.f = f;
this.ch = ch;
this.meta48892 = meta48892;
this._ = _;
this.fn1 = fn1;
this.meta48914 = meta48914;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48913.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48915,meta48914__$1){
var self__ = this;
var _48915__$1 = this;
return (new cljs.core.async.t_cljs$core$async48913(self__.f,self__.ch,self__.meta48892,self__._,self__.fn1,meta48914__$1));
}));

(cljs.core.async.t_cljs$core$async48913.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48915){
var self__ = this;
var _48915__$1 = this;
return self__.meta48914;
}));

(cljs.core.async.t_cljs$core$async48913.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48913.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async48913.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async48913.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__48887_SHARP_){
var G__48931 = (((p1__48887_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__48887_SHARP_) : self__.f.call(null,p1__48887_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__48931) : f1.call(null,G__48931));
});
}));

(cljs.core.async.t_cljs$core$async48913.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48892","meta48892",-1631120347,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async48891","cljs.core.async/t_cljs$core$async48891",1586415073,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta48914","meta48914",615392731,null)], null);
}));

(cljs.core.async.t_cljs$core$async48913.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48913.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48913");

(cljs.core.async.t_cljs$core$async48913.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48913");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48913.
 */
cljs.core.async.__GT_t_cljs$core$async48913 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48913(f__$1,ch__$1,meta48892__$1,___$2,fn1__$1,meta48914){
return (new cljs.core.async.t_cljs$core$async48913(f__$1,ch__$1,meta48892__$1,___$2,fn1__$1,meta48914));
});

}

return (new cljs.core.async.t_cljs$core$async48913(self__.f,self__.ch,self__.meta48892,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__48939 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__48939) : self__.f.call(null,G__48939));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async48891.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48891.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async48891.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48892","meta48892",-1631120347,null)], null);
}));

(cljs.core.async.t_cljs$core$async48891.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48891.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48891");

(cljs.core.async.t_cljs$core$async48891.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48891");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48891.
 */
cljs.core.async.__GT_t_cljs$core$async48891 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48891(f__$1,ch__$1,meta48892){
return (new cljs.core.async.t_cljs$core$async48891(f__$1,ch__$1,meta48892));
});

}

return (new cljs.core.async.t_cljs$core$async48891(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48960 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48960 = (function (f,ch,meta48961){
this.f = f;
this.ch = ch;
this.meta48961 = meta48961;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48960.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48962,meta48961__$1){
var self__ = this;
var _48962__$1 = this;
return (new cljs.core.async.t_cljs$core$async48960(self__.f,self__.ch,meta48961__$1));
}));

(cljs.core.async.t_cljs$core$async48960.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48962){
var self__ = this;
var _48962__$1 = this;
return self__.meta48961;
}));

(cljs.core.async.t_cljs$core$async48960.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48960.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48960.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48960.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async48960.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48960.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async48960.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48961","meta48961",-1982148376,null)], null);
}));

(cljs.core.async.t_cljs$core$async48960.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48960.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48960");

(cljs.core.async.t_cljs$core$async48960.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48960");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48960.
 */
cljs.core.async.__GT_t_cljs$core$async48960 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async48960(f__$1,ch__$1,meta48961){
return (new cljs.core.async.t_cljs$core$async48960(f__$1,ch__$1,meta48961));
});

}

return (new cljs.core.async.t_cljs$core$async48960(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async49009 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49009 = (function (p,ch,meta49010){
this.p = p;
this.ch = ch;
this.meta49010 = meta49010;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async49009.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_49011,meta49010__$1){
var self__ = this;
var _49011__$1 = this;
return (new cljs.core.async.t_cljs$core$async49009(self__.p,self__.ch,meta49010__$1));
}));

(cljs.core.async.t_cljs$core$async49009.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_49011){
var self__ = this;
var _49011__$1 = this;
return self__.meta49010;
}));

(cljs.core.async.t_cljs$core$async49009.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49009.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async49009.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async49009.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49009.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async49009.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49009.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async49009.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta49010","meta49010",337995172,null)], null);
}));

(cljs.core.async.t_cljs$core$async49009.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async49009.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49009");

(cljs.core.async.t_cljs$core$async49009.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async49009");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async49009.
 */
cljs.core.async.__GT_t_cljs$core$async49009 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async49009(p__$1,ch__$1,meta49010){
return (new cljs.core.async.t_cljs$core$async49009(p__$1,ch__$1,meta49010));
});

}

return (new cljs.core.async.t_cljs$core$async49009(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__49037 = arguments.length;
switch (G__49037) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45764__auto___50737 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_49066){
var state_val_49067 = (state_49066[(1)]);
if((state_val_49067 === (7))){
var inst_49062 = (state_49066[(2)]);
var state_49066__$1 = state_49066;
var statearr_49076_50739 = state_49066__$1;
(statearr_49076_50739[(2)] = inst_49062);

(statearr_49076_50739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49067 === (1))){
var state_49066__$1 = state_49066;
var statearr_49077_50741 = state_49066__$1;
(statearr_49077_50741[(2)] = null);

(statearr_49077_50741[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49067 === (4))){
var inst_49046 = (state_49066[(7)]);
var inst_49046__$1 = (state_49066[(2)]);
var inst_49047 = (inst_49046__$1 == null);
var state_49066__$1 = (function (){var statearr_49078 = state_49066;
(statearr_49078[(7)] = inst_49046__$1);

return statearr_49078;
})();
if(cljs.core.truth_(inst_49047)){
var statearr_49079_50743 = state_49066__$1;
(statearr_49079_50743[(1)] = (5));

} else {
var statearr_49080_50744 = state_49066__$1;
(statearr_49080_50744[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49067 === (6))){
var inst_49046 = (state_49066[(7)]);
var inst_49053 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_49046) : p.call(null,inst_49046));
var state_49066__$1 = state_49066;
if(cljs.core.truth_(inst_49053)){
var statearr_49081_50746 = state_49066__$1;
(statearr_49081_50746[(1)] = (8));

} else {
var statearr_49082_50747 = state_49066__$1;
(statearr_49082_50747[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49067 === (3))){
var inst_49064 = (state_49066[(2)]);
var state_49066__$1 = state_49066;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49066__$1,inst_49064);
} else {
if((state_val_49067 === (2))){
var state_49066__$1 = state_49066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49066__$1,(4),ch);
} else {
if((state_val_49067 === (11))){
var inst_49056 = (state_49066[(2)]);
var state_49066__$1 = state_49066;
var statearr_49083_50749 = state_49066__$1;
(statearr_49083_50749[(2)] = inst_49056);

(statearr_49083_50749[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49067 === (9))){
var state_49066__$1 = state_49066;
var statearr_49084_50750 = state_49066__$1;
(statearr_49084_50750[(2)] = null);

(statearr_49084_50750[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49067 === (5))){
var inst_49051 = cljs.core.async.close_BANG_(out);
var state_49066__$1 = state_49066;
var statearr_49085_50751 = state_49066__$1;
(statearr_49085_50751[(2)] = inst_49051);

(statearr_49085_50751[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49067 === (10))){
var inst_49059 = (state_49066[(2)]);
var state_49066__$1 = (function (){var statearr_49086 = state_49066;
(statearr_49086[(8)] = inst_49059);

return statearr_49086;
})();
var statearr_49087_50752 = state_49066__$1;
(statearr_49087_50752[(2)] = null);

(statearr_49087_50752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49067 === (8))){
var inst_49046 = (state_49066[(7)]);
var state_49066__$1 = state_49066;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49066__$1,(11),out,inst_49046);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45666__auto__ = null;
var cljs$core$async$state_machine__45666__auto____0 = (function (){
var statearr_49088 = [null,null,null,null,null,null,null,null,null];
(statearr_49088[(0)] = cljs$core$async$state_machine__45666__auto__);

(statearr_49088[(1)] = (1));

return statearr_49088;
});
var cljs$core$async$state_machine__45666__auto____1 = (function (state_49066){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_49066);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e49089){var ex__45669__auto__ = e49089;
var statearr_49090_50760 = state_49066;
(statearr_49090_50760[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_49066[(4)]))){
var statearr_49091_50761 = state_49066;
(statearr_49091_50761[(1)] = cljs.core.first((state_49066[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50763 = state_49066;
state_49066 = G__50763;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$state_machine__45666__auto__ = function(state_49066){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45666__auto____1.call(this,state_49066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45666__auto____0;
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45666__auto____1;
return cljs$core$async$state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_49092 = f__45765__auto__();
(statearr_49092[(6)] = c__45764__auto___50737);

return statearr_49092;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__49109 = arguments.length;
switch (G__49109) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__45764__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_49206){
var state_val_49208 = (state_49206[(1)]);
if((state_val_49208 === (7))){
var inst_49198 = (state_49206[(2)]);
var state_49206__$1 = state_49206;
var statearr_49228_50769 = state_49206__$1;
(statearr_49228_50769[(2)] = inst_49198);

(statearr_49228_50769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (20))){
var inst_49160 = (state_49206[(7)]);
var inst_49177 = (state_49206[(2)]);
var inst_49179 = cljs.core.next(inst_49160);
var inst_49139 = inst_49179;
var inst_49140 = null;
var inst_49141 = (0);
var inst_49142 = (0);
var state_49206__$1 = (function (){var statearr_49234 = state_49206;
(statearr_49234[(8)] = inst_49141);

(statearr_49234[(9)] = inst_49139);

(statearr_49234[(10)] = inst_49142);

(statearr_49234[(11)] = inst_49140);

(statearr_49234[(12)] = inst_49177);

return statearr_49234;
})();
var statearr_49238_50771 = state_49206__$1;
(statearr_49238_50771[(2)] = null);

(statearr_49238_50771[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (1))){
var state_49206__$1 = state_49206;
var statearr_49240_50772 = state_49206__$1;
(statearr_49240_50772[(2)] = null);

(statearr_49240_50772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (4))){
var inst_49125 = (state_49206[(13)]);
var inst_49125__$1 = (state_49206[(2)]);
var inst_49126 = (inst_49125__$1 == null);
var state_49206__$1 = (function (){var statearr_49243 = state_49206;
(statearr_49243[(13)] = inst_49125__$1);

return statearr_49243;
})();
if(cljs.core.truth_(inst_49126)){
var statearr_49246_50773 = state_49206__$1;
(statearr_49246_50773[(1)] = (5));

} else {
var statearr_49247_50774 = state_49206__$1;
(statearr_49247_50774[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (15))){
var state_49206__$1 = state_49206;
var statearr_49256_50775 = state_49206__$1;
(statearr_49256_50775[(2)] = null);

(statearr_49256_50775[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (21))){
var state_49206__$1 = state_49206;
var statearr_49260_50776 = state_49206__$1;
(statearr_49260_50776[(2)] = null);

(statearr_49260_50776[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (13))){
var inst_49141 = (state_49206[(8)]);
var inst_49139 = (state_49206[(9)]);
var inst_49142 = (state_49206[(10)]);
var inst_49140 = (state_49206[(11)]);
var inst_49154 = (state_49206[(2)]);
var inst_49155 = (inst_49142 + (1));
var tmp49251 = inst_49141;
var tmp49252 = inst_49139;
var tmp49253 = inst_49140;
var inst_49139__$1 = tmp49252;
var inst_49140__$1 = tmp49253;
var inst_49141__$1 = tmp49251;
var inst_49142__$1 = inst_49155;
var state_49206__$1 = (function (){var statearr_49267 = state_49206;
(statearr_49267[(8)] = inst_49141__$1);

(statearr_49267[(14)] = inst_49154);

(statearr_49267[(9)] = inst_49139__$1);

(statearr_49267[(10)] = inst_49142__$1);

(statearr_49267[(11)] = inst_49140__$1);

return statearr_49267;
})();
var statearr_49268_50779 = state_49206__$1;
(statearr_49268_50779[(2)] = null);

(statearr_49268_50779[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (22))){
var state_49206__$1 = state_49206;
var statearr_49269_50781 = state_49206__$1;
(statearr_49269_50781[(2)] = null);

(statearr_49269_50781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (6))){
var inst_49125 = (state_49206[(13)]);
var inst_49135 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_49125) : f.call(null,inst_49125));
var inst_49136 = cljs.core.seq(inst_49135);
var inst_49139 = inst_49136;
var inst_49140 = null;
var inst_49141 = (0);
var inst_49142 = (0);
var state_49206__$1 = (function (){var statearr_49270 = state_49206;
(statearr_49270[(8)] = inst_49141);

(statearr_49270[(9)] = inst_49139);

(statearr_49270[(10)] = inst_49142);

(statearr_49270[(11)] = inst_49140);

return statearr_49270;
})();
var statearr_49271_50785 = state_49206__$1;
(statearr_49271_50785[(2)] = null);

(statearr_49271_50785[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (17))){
var inst_49160 = (state_49206[(7)]);
var inst_49167 = cljs.core.chunk_first(inst_49160);
var inst_49168 = cljs.core.chunk_rest(inst_49160);
var inst_49170 = cljs.core.count(inst_49167);
var inst_49139 = inst_49168;
var inst_49140 = inst_49167;
var inst_49141 = inst_49170;
var inst_49142 = (0);
var state_49206__$1 = (function (){var statearr_49274 = state_49206;
(statearr_49274[(8)] = inst_49141);

(statearr_49274[(9)] = inst_49139);

(statearr_49274[(10)] = inst_49142);

(statearr_49274[(11)] = inst_49140);

return statearr_49274;
})();
var statearr_49275_50786 = state_49206__$1;
(statearr_49275_50786[(2)] = null);

(statearr_49275_50786[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (3))){
var inst_49201 = (state_49206[(2)]);
var state_49206__$1 = state_49206;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49206__$1,inst_49201);
} else {
if((state_val_49208 === (12))){
var inst_49188 = (state_49206[(2)]);
var state_49206__$1 = state_49206;
var statearr_49276_50787 = state_49206__$1;
(statearr_49276_50787[(2)] = inst_49188);

(statearr_49276_50787[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (2))){
var state_49206__$1 = state_49206;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49206__$1,(4),in$);
} else {
if((state_val_49208 === (23))){
var inst_49196 = (state_49206[(2)]);
var state_49206__$1 = state_49206;
var statearr_49279_50790 = state_49206__$1;
(statearr_49279_50790[(2)] = inst_49196);

(statearr_49279_50790[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (19))){
var inst_49183 = (state_49206[(2)]);
var state_49206__$1 = state_49206;
var statearr_49294_50791 = state_49206__$1;
(statearr_49294_50791[(2)] = inst_49183);

(statearr_49294_50791[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (11))){
var inst_49160 = (state_49206[(7)]);
var inst_49139 = (state_49206[(9)]);
var inst_49160__$1 = cljs.core.seq(inst_49139);
var state_49206__$1 = (function (){var statearr_49303 = state_49206;
(statearr_49303[(7)] = inst_49160__$1);

return statearr_49303;
})();
if(inst_49160__$1){
var statearr_49305_50793 = state_49206__$1;
(statearr_49305_50793[(1)] = (14));

} else {
var statearr_49306_50794 = state_49206__$1;
(statearr_49306_50794[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (9))){
var inst_49190 = (state_49206[(2)]);
var inst_49191 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_49206__$1 = (function (){var statearr_49307 = state_49206;
(statearr_49307[(15)] = inst_49190);

return statearr_49307;
})();
if(cljs.core.truth_(inst_49191)){
var statearr_49308_50795 = state_49206__$1;
(statearr_49308_50795[(1)] = (21));

} else {
var statearr_49309_50797 = state_49206__$1;
(statearr_49309_50797[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (5))){
var inst_49128 = cljs.core.async.close_BANG_(out);
var state_49206__$1 = state_49206;
var statearr_49312_50798 = state_49206__$1;
(statearr_49312_50798[(2)] = inst_49128);

(statearr_49312_50798[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (14))){
var inst_49160 = (state_49206[(7)]);
var inst_49164 = cljs.core.chunked_seq_QMARK_(inst_49160);
var state_49206__$1 = state_49206;
if(inst_49164){
var statearr_49315_50800 = state_49206__$1;
(statearr_49315_50800[(1)] = (17));

} else {
var statearr_49316_50801 = state_49206__$1;
(statearr_49316_50801[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (16))){
var inst_49186 = (state_49206[(2)]);
var state_49206__$1 = state_49206;
var statearr_49317_50803 = state_49206__$1;
(statearr_49317_50803[(2)] = inst_49186);

(statearr_49317_50803[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49208 === (10))){
var inst_49142 = (state_49206[(10)]);
var inst_49140 = (state_49206[(11)]);
var inst_49149 = cljs.core._nth(inst_49140,inst_49142);
var state_49206__$1 = state_49206;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49206__$1,(13),out,inst_49149);
} else {
if((state_val_49208 === (18))){
var inst_49160 = (state_49206[(7)]);
var inst_49175 = cljs.core.first(inst_49160);
var state_49206__$1 = state_49206;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49206__$1,(20),out,inst_49175);
} else {
if((state_val_49208 === (8))){
var inst_49141 = (state_49206[(8)]);
var inst_49142 = (state_49206[(10)]);
var inst_49144 = (inst_49142 < inst_49141);
var inst_49145 = inst_49144;
var state_49206__$1 = state_49206;
if(cljs.core.truth_(inst_49145)){
var statearr_49326_50805 = state_49206__$1;
(statearr_49326_50805[(1)] = (10));

} else {
var statearr_49328_50806 = state_49206__$1;
(statearr_49328_50806[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__45666__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__45666__auto____0 = (function (){
var statearr_49335 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49335[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__45666__auto__);

(statearr_49335[(1)] = (1));

return statearr_49335;
});
var cljs$core$async$mapcat_STAR__$_state_machine__45666__auto____1 = (function (state_49206){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_49206);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e49343){var ex__45669__auto__ = e49343;
var statearr_49344_50810 = state_49206;
(statearr_49344_50810[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_49206[(4)]))){
var statearr_49350_50813 = state_49206;
(statearr_49350_50813[(1)] = cljs.core.first((state_49206[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50815 = state_49206;
state_49206 = G__50815;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__45666__auto__ = function(state_49206){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__45666__auto____1.call(this,state_49206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__45666__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__45666__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_49355 = f__45765__auto__();
(statearr_49355[(6)] = c__45764__auto__);

return statearr_49355;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));

return c__45764__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__49367 = arguments.length;
switch (G__49367) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__49389 = arguments.length;
switch (G__49389) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__49413 = arguments.length;
switch (G__49413) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45764__auto___50840 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_49457){
var state_val_49458 = (state_49457[(1)]);
if((state_val_49458 === (7))){
var inst_49450 = (state_49457[(2)]);
var state_49457__$1 = state_49457;
var statearr_49469_50843 = state_49457__$1;
(statearr_49469_50843[(2)] = inst_49450);

(statearr_49469_50843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49458 === (1))){
var inst_49425 = null;
var state_49457__$1 = (function (){var statearr_49471 = state_49457;
(statearr_49471[(7)] = inst_49425);

return statearr_49471;
})();
var statearr_49476_50849 = state_49457__$1;
(statearr_49476_50849[(2)] = null);

(statearr_49476_50849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49458 === (4))){
var inst_49431 = (state_49457[(8)]);
var inst_49431__$1 = (state_49457[(2)]);
var inst_49432 = (inst_49431__$1 == null);
var inst_49433 = cljs.core.not(inst_49432);
var state_49457__$1 = (function (){var statearr_49480 = state_49457;
(statearr_49480[(8)] = inst_49431__$1);

return statearr_49480;
})();
if(inst_49433){
var statearr_49485_50854 = state_49457__$1;
(statearr_49485_50854[(1)] = (5));

} else {
var statearr_49488_50855 = state_49457__$1;
(statearr_49488_50855[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49458 === (6))){
var state_49457__$1 = state_49457;
var statearr_49493_50856 = state_49457__$1;
(statearr_49493_50856[(2)] = null);

(statearr_49493_50856[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49458 === (3))){
var inst_49452 = (state_49457[(2)]);
var inst_49453 = cljs.core.async.close_BANG_(out);
var state_49457__$1 = (function (){var statearr_49498 = state_49457;
(statearr_49498[(9)] = inst_49452);

return statearr_49498;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_49457__$1,inst_49453);
} else {
if((state_val_49458 === (2))){
var state_49457__$1 = state_49457;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49457__$1,(4),ch);
} else {
if((state_val_49458 === (11))){
var inst_49431 = (state_49457[(8)]);
var inst_49442 = (state_49457[(2)]);
var inst_49425 = inst_49431;
var state_49457__$1 = (function (){var statearr_49502 = state_49457;
(statearr_49502[(7)] = inst_49425);

(statearr_49502[(10)] = inst_49442);

return statearr_49502;
})();
var statearr_49503_50870 = state_49457__$1;
(statearr_49503_50870[(2)] = null);

(statearr_49503_50870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49458 === (9))){
var inst_49431 = (state_49457[(8)]);
var state_49457__$1 = state_49457;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49457__$1,(11),out,inst_49431);
} else {
if((state_val_49458 === (5))){
var inst_49425 = (state_49457[(7)]);
var inst_49431 = (state_49457[(8)]);
var inst_49436 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_49431,inst_49425);
var state_49457__$1 = state_49457;
if(inst_49436){
var statearr_49505_50873 = state_49457__$1;
(statearr_49505_50873[(1)] = (8));

} else {
var statearr_49506_50874 = state_49457__$1;
(statearr_49506_50874[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49458 === (10))){
var inst_49447 = (state_49457[(2)]);
var state_49457__$1 = state_49457;
var statearr_49507_50877 = state_49457__$1;
(statearr_49507_50877[(2)] = inst_49447);

(statearr_49507_50877[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49458 === (8))){
var inst_49425 = (state_49457[(7)]);
var tmp49504 = inst_49425;
var inst_49425__$1 = tmp49504;
var state_49457__$1 = (function (){var statearr_49508 = state_49457;
(statearr_49508[(7)] = inst_49425__$1);

return statearr_49508;
})();
var statearr_49509_50879 = state_49457__$1;
(statearr_49509_50879[(2)] = null);

(statearr_49509_50879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45666__auto__ = null;
var cljs$core$async$state_machine__45666__auto____0 = (function (){
var statearr_49510 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_49510[(0)] = cljs$core$async$state_machine__45666__auto__);

(statearr_49510[(1)] = (1));

return statearr_49510;
});
var cljs$core$async$state_machine__45666__auto____1 = (function (state_49457){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_49457);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e49511){var ex__45669__auto__ = e49511;
var statearr_49512_50888 = state_49457;
(statearr_49512_50888[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_49457[(4)]))){
var statearr_49515_50889 = state_49457;
(statearr_49515_50889[(1)] = cljs.core.first((state_49457[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50890 = state_49457;
state_49457 = G__50890;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$state_machine__45666__auto__ = function(state_49457){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45666__auto____1.call(this,state_49457);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45666__auto____0;
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45666__auto____1;
return cljs$core$async$state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_49516 = f__45765__auto__();
(statearr_49516[(6)] = c__45764__auto___50840);

return statearr_49516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__49520 = arguments.length;
switch (G__49520) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45764__auto___50902 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_49572){
var state_val_49573 = (state_49572[(1)]);
if((state_val_49573 === (7))){
var inst_49564 = (state_49572[(2)]);
var state_49572__$1 = state_49572;
var statearr_49583_50904 = state_49572__$1;
(statearr_49583_50904[(2)] = inst_49564);

(statearr_49583_50904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49573 === (1))){
var inst_49526 = (new Array(n));
var inst_49528 = inst_49526;
var inst_49529 = (0);
var state_49572__$1 = (function (){var statearr_49587 = state_49572;
(statearr_49587[(7)] = inst_49529);

(statearr_49587[(8)] = inst_49528);

return statearr_49587;
})();
var statearr_49588_50907 = state_49572__$1;
(statearr_49588_50907[(2)] = null);

(statearr_49588_50907[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49573 === (4))){
var inst_49533 = (state_49572[(9)]);
var inst_49533__$1 = (state_49572[(2)]);
var inst_49535 = (inst_49533__$1 == null);
var inst_49536 = cljs.core.not(inst_49535);
var state_49572__$1 = (function (){var statearr_49589 = state_49572;
(statearr_49589[(9)] = inst_49533__$1);

return statearr_49589;
})();
if(inst_49536){
var statearr_49590_50910 = state_49572__$1;
(statearr_49590_50910[(1)] = (5));

} else {
var statearr_49591_50913 = state_49572__$1;
(statearr_49591_50913[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49573 === (15))){
var inst_49558 = (state_49572[(2)]);
var state_49572__$1 = state_49572;
var statearr_49592_50915 = state_49572__$1;
(statearr_49592_50915[(2)] = inst_49558);

(statearr_49592_50915[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49573 === (13))){
var state_49572__$1 = state_49572;
var statearr_49595_50916 = state_49572__$1;
(statearr_49595_50916[(2)] = null);

(statearr_49595_50916[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49573 === (6))){
var inst_49529 = (state_49572[(7)]);
var inst_49554 = (inst_49529 > (0));
var state_49572__$1 = state_49572;
if(cljs.core.truth_(inst_49554)){
var statearr_49596_50923 = state_49572__$1;
(statearr_49596_50923[(1)] = (12));

} else {
var statearr_49599_50924 = state_49572__$1;
(statearr_49599_50924[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49573 === (3))){
var inst_49566 = (state_49572[(2)]);
var state_49572__$1 = state_49572;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49572__$1,inst_49566);
} else {
if((state_val_49573 === (12))){
var inst_49528 = (state_49572[(8)]);
var inst_49556 = cljs.core.vec(inst_49528);
var state_49572__$1 = state_49572;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49572__$1,(15),out,inst_49556);
} else {
if((state_val_49573 === (2))){
var state_49572__$1 = state_49572;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49572__$1,(4),ch);
} else {
if((state_val_49573 === (11))){
var inst_49547 = (state_49572[(2)]);
var inst_49548 = (new Array(n));
var inst_49528 = inst_49548;
var inst_49529 = (0);
var state_49572__$1 = (function (){var statearr_49605 = state_49572;
(statearr_49605[(7)] = inst_49529);

(statearr_49605[(8)] = inst_49528);

(statearr_49605[(10)] = inst_49547);

return statearr_49605;
})();
var statearr_49606_50930 = state_49572__$1;
(statearr_49606_50930[(2)] = null);

(statearr_49606_50930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49573 === (9))){
var inst_49528 = (state_49572[(8)]);
var inst_49545 = cljs.core.vec(inst_49528);
var state_49572__$1 = state_49572;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49572__$1,(11),out,inst_49545);
} else {
if((state_val_49573 === (5))){
var inst_49540 = (state_49572[(11)]);
var inst_49529 = (state_49572[(7)]);
var inst_49528 = (state_49572[(8)]);
var inst_49533 = (state_49572[(9)]);
var inst_49539 = (inst_49528[inst_49529] = inst_49533);
var inst_49540__$1 = (inst_49529 + (1));
var inst_49541 = (inst_49540__$1 < n);
var state_49572__$1 = (function (){var statearr_49611 = state_49572;
(statearr_49611[(12)] = inst_49539);

(statearr_49611[(11)] = inst_49540__$1);

return statearr_49611;
})();
if(cljs.core.truth_(inst_49541)){
var statearr_49612_50938 = state_49572__$1;
(statearr_49612_50938[(1)] = (8));

} else {
var statearr_49613_50939 = state_49572__$1;
(statearr_49613_50939[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49573 === (14))){
var inst_49561 = (state_49572[(2)]);
var inst_49562 = cljs.core.async.close_BANG_(out);
var state_49572__$1 = (function (){var statearr_49616 = state_49572;
(statearr_49616[(13)] = inst_49561);

return statearr_49616;
})();
var statearr_49617_50942 = state_49572__$1;
(statearr_49617_50942[(2)] = inst_49562);

(statearr_49617_50942[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49573 === (10))){
var inst_49551 = (state_49572[(2)]);
var state_49572__$1 = state_49572;
var statearr_49621_50943 = state_49572__$1;
(statearr_49621_50943[(2)] = inst_49551);

(statearr_49621_50943[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49573 === (8))){
var inst_49540 = (state_49572[(11)]);
var inst_49528 = (state_49572[(8)]);
var tmp49614 = inst_49528;
var inst_49528__$1 = tmp49614;
var inst_49529 = inst_49540;
var state_49572__$1 = (function (){var statearr_49624 = state_49572;
(statearr_49624[(7)] = inst_49529);

(statearr_49624[(8)] = inst_49528__$1);

return statearr_49624;
})();
var statearr_49626_50946 = state_49572__$1;
(statearr_49626_50946[(2)] = null);

(statearr_49626_50946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45666__auto__ = null;
var cljs$core$async$state_machine__45666__auto____0 = (function (){
var statearr_49632 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49632[(0)] = cljs$core$async$state_machine__45666__auto__);

(statearr_49632[(1)] = (1));

return statearr_49632;
});
var cljs$core$async$state_machine__45666__auto____1 = (function (state_49572){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_49572);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e49634){var ex__45669__auto__ = e49634;
var statearr_49635_50953 = state_49572;
(statearr_49635_50953[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_49572[(4)]))){
var statearr_49636_50956 = state_49572;
(statearr_49636_50956[(1)] = cljs.core.first((state_49572[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50960 = state_49572;
state_49572 = G__50960;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$state_machine__45666__auto__ = function(state_49572){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45666__auto____1.call(this,state_49572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45666__auto____0;
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45666__auto____1;
return cljs$core$async$state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_49639 = f__45765__auto__();
(statearr_49639[(6)] = c__45764__auto___50902);

return statearr_49639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__49664 = arguments.length;
switch (G__49664) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45764__auto___50963 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45765__auto__ = (function (){var switch__45665__auto__ = (function (state_49728){
var state_val_49729 = (state_49728[(1)]);
if((state_val_49729 === (7))){
var inst_49719 = (state_49728[(2)]);
var state_49728__$1 = state_49728;
var statearr_49745_50969 = state_49728__$1;
(statearr_49745_50969[(2)] = inst_49719);

(statearr_49745_50969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49729 === (1))){
var inst_49669 = [];
var inst_49671 = inst_49669;
var inst_49672 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_49728__$1 = (function (){var statearr_49750 = state_49728;
(statearr_49750[(7)] = inst_49672);

(statearr_49750[(8)] = inst_49671);

return statearr_49750;
})();
var statearr_49754_50970 = state_49728__$1;
(statearr_49754_50970[(2)] = null);

(statearr_49754_50970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49729 === (4))){
var inst_49675 = (state_49728[(9)]);
var inst_49675__$1 = (state_49728[(2)]);
var inst_49677 = (inst_49675__$1 == null);
var inst_49678 = cljs.core.not(inst_49677);
var state_49728__$1 = (function (){var statearr_49759 = state_49728;
(statearr_49759[(9)] = inst_49675__$1);

return statearr_49759;
})();
if(inst_49678){
var statearr_49763_50975 = state_49728__$1;
(statearr_49763_50975[(1)] = (5));

} else {
var statearr_49765_50976 = state_49728__$1;
(statearr_49765_50976[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49729 === (15))){
var inst_49712 = (state_49728[(2)]);
var state_49728__$1 = state_49728;
var statearr_49771_50981 = state_49728__$1;
(statearr_49771_50981[(2)] = inst_49712);

(statearr_49771_50981[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49729 === (13))){
var state_49728__$1 = state_49728;
var statearr_49772_50982 = state_49728__$1;
(statearr_49772_50982[(2)] = null);

(statearr_49772_50982[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49729 === (6))){
var inst_49671 = (state_49728[(8)]);
var inst_49707 = inst_49671.length;
var inst_49708 = (inst_49707 > (0));
var state_49728__$1 = state_49728;
if(cljs.core.truth_(inst_49708)){
var statearr_49773_50987 = state_49728__$1;
(statearr_49773_50987[(1)] = (12));

} else {
var statearr_49774_50990 = state_49728__$1;
(statearr_49774_50990[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49729 === (3))){
var inst_49721 = (state_49728[(2)]);
var state_49728__$1 = state_49728;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49728__$1,inst_49721);
} else {
if((state_val_49729 === (12))){
var inst_49671 = (state_49728[(8)]);
var inst_49710 = cljs.core.vec(inst_49671);
var state_49728__$1 = state_49728;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49728__$1,(15),out,inst_49710);
} else {
if((state_val_49729 === (2))){
var state_49728__$1 = state_49728;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49728__$1,(4),ch);
} else {
if((state_val_49729 === (11))){
var inst_49681 = (state_49728[(10)]);
var inst_49675 = (state_49728[(9)]);
var inst_49696 = (state_49728[(2)]);
var inst_49699 = [];
var inst_49700 = inst_49699.push(inst_49675);
var inst_49671 = inst_49699;
var inst_49672 = inst_49681;
var state_49728__$1 = (function (){var statearr_49786 = state_49728;
(statearr_49786[(7)] = inst_49672);

(statearr_49786[(11)] = inst_49700);

(statearr_49786[(12)] = inst_49696);

(statearr_49786[(8)] = inst_49671);

return statearr_49786;
})();
var statearr_49788_50995 = state_49728__$1;
(statearr_49788_50995[(2)] = null);

(statearr_49788_50995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49729 === (9))){
var inst_49671 = (state_49728[(8)]);
var inst_49693 = cljs.core.vec(inst_49671);
var state_49728__$1 = state_49728;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49728__$1,(11),out,inst_49693);
} else {
if((state_val_49729 === (5))){
var inst_49672 = (state_49728[(7)]);
var inst_49681 = (state_49728[(10)]);
var inst_49675 = (state_49728[(9)]);
var inst_49681__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_49675) : f.call(null,inst_49675));
var inst_49685 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_49681__$1,inst_49672);
var inst_49686 = cljs.core.keyword_identical_QMARK_(inst_49672,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_49688 = ((inst_49685) || (inst_49686));
var state_49728__$1 = (function (){var statearr_49797 = state_49728;
(statearr_49797[(10)] = inst_49681__$1);

return statearr_49797;
})();
if(cljs.core.truth_(inst_49688)){
var statearr_49800_51001 = state_49728__$1;
(statearr_49800_51001[(1)] = (8));

} else {
var statearr_49801_51002 = state_49728__$1;
(statearr_49801_51002[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49729 === (14))){
var inst_49715 = (state_49728[(2)]);
var inst_49717 = cljs.core.async.close_BANG_(out);
var state_49728__$1 = (function (){var statearr_49808 = state_49728;
(statearr_49808[(13)] = inst_49715);

return statearr_49808;
})();
var statearr_49812_51005 = state_49728__$1;
(statearr_49812_51005[(2)] = inst_49717);

(statearr_49812_51005[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49729 === (10))){
var inst_49703 = (state_49728[(2)]);
var state_49728__$1 = state_49728;
var statearr_49816_51007 = state_49728__$1;
(statearr_49816_51007[(2)] = inst_49703);

(statearr_49816_51007[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49729 === (8))){
var inst_49681 = (state_49728[(10)]);
var inst_49675 = (state_49728[(9)]);
var inst_49671 = (state_49728[(8)]);
var inst_49690 = inst_49671.push(inst_49675);
var tmp49805 = inst_49671;
var inst_49671__$1 = tmp49805;
var inst_49672 = inst_49681;
var state_49728__$1 = (function (){var statearr_49823 = state_49728;
(statearr_49823[(7)] = inst_49672);

(statearr_49823[(14)] = inst_49690);

(statearr_49823[(8)] = inst_49671__$1);

return statearr_49823;
})();
var statearr_49826_51010 = state_49728__$1;
(statearr_49826_51010[(2)] = null);

(statearr_49826_51010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45666__auto__ = null;
var cljs$core$async$state_machine__45666__auto____0 = (function (){
var statearr_49836 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49836[(0)] = cljs$core$async$state_machine__45666__auto__);

(statearr_49836[(1)] = (1));

return statearr_49836;
});
var cljs$core$async$state_machine__45666__auto____1 = (function (state_49728){
while(true){
var ret_value__45667__auto__ = (function (){try{while(true){
var result__45668__auto__ = switch__45665__auto__(state_49728);
if(cljs.core.keyword_identical_QMARK_(result__45668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45668__auto__;
}
break;
}
}catch (e49842){var ex__45669__auto__ = e49842;
var statearr_49844_51020 = state_49728;
(statearr_49844_51020[(2)] = ex__45669__auto__);


if(cljs.core.seq((state_49728[(4)]))){
var statearr_49848_51021 = state_49728;
(statearr_49848_51021[(1)] = cljs.core.first((state_49728[(4)])));

} else {
throw ex__45669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51025 = state_49728;
state_49728 = G__51025;
continue;
} else {
return ret_value__45667__auto__;
}
break;
}
});
cljs$core$async$state_machine__45666__auto__ = function(state_49728){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45666__auto____1.call(this,state_49728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45666__auto____0;
cljs$core$async$state_machine__45666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45666__auto____1;
return cljs$core$async$state_machine__45666__auto__;
})()
})();
var state__45766__auto__ = (function (){var statearr_49852 = f__45765__auto__();
(statearr_49852[(6)] = c__45764__auto___50963);

return statearr_49852;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45766__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
