goog.provide('dv.cljs_emotion.helix_cards');
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.helix_cards","dv.cljs_emotion.helix_cards",1092827443),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"# Helix dom support for :css prop.\n\nThe namespace `dv.emotion-helix-dom` is a copy of the `helix.dom` namespace with added support for emotion's `:css` property.\n\n\nIf a component does not include the `:css` property and it does not include the dynamic property symbols `:&` and `&`,\nthen helix's `dom-props` macro is expanded on the props, so there is no performance cost on top of helix for components\nthat don't use styles. For any components using dynamic props the code is the same as that in helix with the addition\nof the `:css` property being wrapped to deal with cljs->js datatype conversion.",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),null,new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));

dv.cljs_emotion.helix_cards.a_component = (function (){var G__62855 = (function dv$cljs_emotion$helix_cards$a_component_render(props__54161__auto__,maybe_ref__54162__auto__){
var vec__62856 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [helix.core.extract_cljs_props(props__54161__auto__),maybe_ref__54162__auto__], null);

var G__62859 = "div";
var G__62860 = (function (){var obj62863 = ({"css":dv.cljs_emotion.convert_css((function (p__62864){
var map__62865 = p__62864;
var map__62865__$1 = cljs.core.__destructure_map(map__62865);
var bg = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62865__$1,new cljs.core.Keyword(null,"bg","bg",-206688421));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"color","color",1011675173),"yellow",new cljs.core.Keyword(null,"background-color","background-color",570434026),(function (){var or__4253__auto__ = bg;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "black";
}
})()], null);
}))});
return obj62863;
})();
var G__62861 = "Here is some text in a div";
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3(G__62859,G__62860,G__62861) : dv.emotion_helix_dom.jsx.call(null,G__62859,G__62860,G__62861));
});
if(goog.DEBUG === true){
var G__62866 = G__62855;
(G__62866.displayName = "dv.cljs-emotion.helix-cards/a-component");

return G__62866;
} else {
return G__62855;
}
})();




dv.cljs_emotion.helix_cards.a_table = (function (){var G__62868 = (function dv$cljs_emotion$helix_cards$a_table_render(props__54161__auto__,maybe_ref__54162__auto__){
var vec__62869 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [helix.core.extract_cljs_props(props__54161__auto__),maybe_ref__54162__auto__], null);

var dyn_props = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"TESTING",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"red"], null)], null);
var G__62872 = "table";
var G__62873 = (function (){var G__62875 = (function (){var obj62878 = ({"css":dv.cljs_emotion.convert_css(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"blue","tbody > tr:nth-of-type(odd)",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"purple"], null),new cljs.core.Keyword(null,"border","border",1444987323),"2px solid yellow"], null))});
return obj62878;
})();
var G__62876 = dv.emotion_helix_dom._dom_props.cljs$core$IFn$_invoke$arity$1(dyn_props);
return (dv.emotion_helix_dom.hx_merge_obj.cljs$core$IFn$_invoke$arity$2 ? dv.emotion_helix_dom.hx_merge_obj.cljs$core$IFn$_invoke$arity$2(G__62875,G__62876) : dv.emotion_helix_dom.hx_merge_obj.call(null,G__62875,G__62876));
})();
var G__62874 = (function (){var G__62879 = "tbody";
var G__62880 = null;
var G__62881 = (function (){var G__62890 = "tr";
var G__62891 = null;
var G__62892 = (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3("td",null,"hello") : dv.emotion_helix_dom.jsx.call(null,"td",null,"hello"));
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3(G__62890,G__62891,G__62892) : dv.emotion_helix_dom.jsx.call(null,G__62890,G__62891,G__62892));
})();
var G__62882 = (function (){var G__62893 = "tr";
var G__62894 = null;
var G__62895 = (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3("td",null,"hello1") : dv.emotion_helix_dom.jsx.call(null,"td",null,"hello1"));
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3(G__62893,G__62894,G__62895) : dv.emotion_helix_dom.jsx.call(null,G__62893,G__62894,G__62895));
})();
var G__62883 = (function (){var G__62896 = "tr";
var G__62897 = null;
var G__62898 = (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3("td",null,"hello2") : dv.emotion_helix_dom.jsx.call(null,"td",null,"hello2"));
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3(G__62896,G__62897,G__62898) : dv.emotion_helix_dom.jsx.call(null,G__62896,G__62897,G__62898));
})();
var G__62884 = (function (){var G__62899 = "tr";
var G__62900 = null;
var G__62901 = (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3("td",null,"hello2") : dv.emotion_helix_dom.jsx.call(null,"td",null,"hello2"));
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3(G__62899,G__62900,G__62901) : dv.emotion_helix_dom.jsx.call(null,G__62899,G__62900,G__62901));
})();
var G__62885 = (function (){var G__62902 = "tr";
var G__62903 = null;
var G__62904 = (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3("td",null,"hello2") : dv.emotion_helix_dom.jsx.call(null,"td",null,"hello2"));
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3(G__62902,G__62903,G__62904) : dv.emotion_helix_dom.jsx.call(null,G__62902,G__62903,G__62904));
})();
var G__62886 = (function (){var G__62905 = "tr";
var G__62906 = null;
var G__62907 = (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3("td",null,"hello2") : dv.emotion_helix_dom.jsx.call(null,"td",null,"hello2"));
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3(G__62905,G__62906,G__62907) : dv.emotion_helix_dom.jsx.call(null,G__62905,G__62906,G__62907));
})();
var G__62887 = (function (){var G__62908 = "tr";
var G__62909 = null;
var G__62910 = (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3("td",null,"hello2") : dv.emotion_helix_dom.jsx.call(null,"td",null,"hello2"));
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3(G__62908,G__62909,G__62910) : dv.emotion_helix_dom.jsx.call(null,G__62908,G__62909,G__62910));
})();
var G__62888 = (function (){var G__62911 = "tr";
var G__62912 = null;
var G__62913 = (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3("td",null,"hello2") : dv.emotion_helix_dom.jsx.call(null,"td",null,"hello2"));
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3(G__62911,G__62912,G__62913) : dv.emotion_helix_dom.jsx.call(null,G__62911,G__62912,G__62913));
})();
var G__62889 = (function (){var G__62914 = "tr";
var G__62915 = null;
var G__62916 = (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3("td",null,"hello2") : dv.emotion_helix_dom.jsx.call(null,"td",null,"hello2"));
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3(G__62914,G__62915,G__62916) : dv.emotion_helix_dom.jsx.call(null,G__62914,G__62915,G__62916));
})();
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$11 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$11(G__62879,G__62880,G__62881,G__62882,G__62883,G__62884,G__62885,G__62886,G__62887,G__62888,G__62889) : dv.emotion_helix_dom.jsx.call(null,G__62879,G__62880,G__62881,G__62882,G__62883,G__62884,G__62885,G__62886,G__62887,G__62888,G__62889));
})();
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3(G__62872,G__62873,G__62874) : dv.emotion_helix_dom.jsx.call(null,G__62872,G__62873,G__62874));
});
if(goog.DEBUG === true){
var G__62917 = G__62868;
(G__62917.displayName = "dv.cljs-emotion.helix-cards/a-table");

return G__62917;
} else {
return G__62868;
}
})();




dv.cljs_emotion.helix_cards.vector_of_styles = (function (){var G__62919 = (function dv$cljs_emotion$helix_cards$vector_of_styles_render(props__54161__auto__,maybe_ref__54162__auto__){
var vec__62920 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [helix.core.extract_cljs_props(props__54161__auto__),maybe_ref__54162__auto__], null);

var G__62923 = "div";
var G__62924 = (function (){var obj62927 = ({"css":dv.cljs_emotion.convert_css(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"black"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"#efefef"], null),({"borderRadius": "4px"}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"border","border",1444987323),"1px solid"], null)], null))});
return obj62927;
})();
var G__62925 = "This text should be black on #efefef";
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3(G__62923,G__62924,G__62925) : dv.emotion_helix_dom.jsx.call(null,G__62923,G__62924,G__62925));
});
if(goog.DEBUG === true){
var G__62928 = G__62919;
(G__62928.displayName = "dv.cljs-emotion.helix-cards/vector-of-styles");

return G__62928;
} else {
return G__62919;
}
})();



devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.helix_cards","dv.cljs_emotion.helix_cards",1092827443),new cljs.core.Keyword(null,"helix-css","helix-css",-1931587758)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"helix-css",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var G__62929 = "div";
var G__62930 = null;
var G__62931 = (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3("h1",null,"This is a helix table with the :css prop targeting the children rows") : dv.emotion_helix_dom.jsx.call(null,"h1",null,"This is a helix table with the :css prop targeting the children rows"));
var G__62932 = helix.core.get_react().createElement(dv.cljs_emotion.helix_cards.a_table,null);
var G__62933 = helix.core.get_react().createElement(dv.cljs_emotion.helix_cards.vector_of_styles,null);
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$5 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$5(G__62929,G__62930,G__62931,G__62932,G__62933) : dv.emotion_helix_dom.jsx.call(null,G__62929,G__62930,G__62931,G__62932,G__62933));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.helix_cards","dv.cljs_emotion.helix_cards",1092827443),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),devcards.core.markdown__GT_react.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["In the above example we're using nested selectors with both static props and dynamic\n(you can inspect this page to see the `TESTING` css class is applied).\n\nIn the second example we're using a\nvector of styles which are merged together by emotion.",["\n```clojure\n","(defnc a-table []\n  (let [dyn-props {:class \"TESTING\"\n                   :style {:background-color \"red\"}}]\n    (d/table {:css {:background-color             \"blue\"\n                    \"tbody > tr:nth-of-type(odd)\" {:background-color \"purple\"}\n                    :border                       \"2px solid yellow\"}\n              :&   dyn-props}\n      (d/tbody\n        (d/tr (d/td \"hello\"))\n        (d/tr (d/td \"hello1\"))\n        (d/tr (d/td \"hello2\"))\n        (d/tr (d/td \"hello2\"))\n        (d/tr (d/td \"hello2\"))\n        (d/tr (d/td \"hello2\"))\n        (d/tr (d/td \"hello2\"))\n        (d/tr (d/td \"hello2\"))\n        (d/tr (d/td \"hello2\"))))))","\n```\n"].join(''),["\n```clojure\n","(defnc vector-of-styles []\n  (d/div {:css [{:color \"black\"} {:background-color \"#efefef\"} #js {:borderRadius \"4px\"} {:border \"1px solid\"}]}\n    \"This text should be black on #efefef\"))","\n```\n"].join('')], 0)),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"hide-border","hide-border",1463657151),true], null))], 0))], null));
})], null));

dv.cljs_emotion.helix_cards.theme_component = (function (){var G__62935 = (function dv$cljs_emotion$helix_cards$theme_component_render(props__54161__auto__,maybe_ref__54162__auto__){
var vec__62936 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [helix.core.extract_cljs_props(props__54161__auto__),maybe_ref__54162__auto__], null);

var G__62939 = "div";
var G__62940 = null;
var G__62941 = dv.cljs_emotion.theme_provider.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"theme","theme",-1247880880),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bg","bg",-206688421),"cadetblue"], null)], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3("h2",null,"With theme, bg should be cadetblue") : dv.emotion_helix_dom.jsx.call(null,"h2",null,"With theme, bg should be cadetblue")),helix.core.get_react().createElement(dv.cljs_emotion.helix_cards.a_component,null)], 0));
var G__62942 = (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3("h2",null,"With no theme, bg should be black") : dv.emotion_helix_dom.jsx.call(null,"h2",null,"With no theme, bg should be black"));
var G__62943 = helix.core.get_react().createElement(dv.cljs_emotion.helix_cards.a_component,null);
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$5 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$5(G__62939,G__62940,G__62941,G__62942,G__62943) : dv.emotion_helix_dom.jsx.call(null,G__62939,G__62940,G__62941,G__62942,G__62943));
});
if(goog.DEBUG === true){
var G__62944 = G__62935;
(G__62944.displayName = "dv.cljs-emotion.helix-cards/theme-component");

return G__62944;
} else {
return G__62935;
}
})();



devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.helix_cards","dv.cljs_emotion.helix_cards",1092827443),new cljs.core.Keyword(null,"theme-support","theme-support",-1077835840)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"theme-support",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),helix.core.get_react().createElement(dv.cljs_emotion.helix_cards.theme_component,null),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.helix_cards","dv.cljs_emotion.helix_cards",1092827443),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),devcards.core.markdown__GT_react.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["This example demonstrates using a theme and function as the value for `:css` to read the theme data.",["\n```clojure\n","(defnc theme-component []\n  (d/div\n    (em/theme-provider {:theme {:bg \"cadetblue\"}}\n      (d/h2 \"With theme, bg should be cadetblue\")\n      ($ a-component))\n    (d/h2 \"With no theme, bg should be black\")\n    ($ a-component)))","\n```\n"].join(''),["\n```clojure\n","(defnc a-component []\n  (d/div {:css (fn [{:keys [bg]}]\n                 {:color            \"yellow\"\n                  :background-color (or bg \"black\")})}\n    \"Here is some text in a div\"))","\n```\n"].join('')], 0)),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"hide-border","hide-border",1463657151),true], null))], 0))], null));
})], null));
dv.cljs_emotion.helix_cards.some_css = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"self","self",-1547428899),dv.cljs_emotion.css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([({"backgroundColor": "#aefefe", "border": "2px solid #eee", "borderRadius": "0.5rem", "padding": "1rem"})], 0)),new cljs.core.Keyword(null,"title","title",636505583),dv.cljs_emotion.css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"1.25rem",new cljs.core.Keyword(null,"color","color",1011675173),"red"], null),({"border": "1px dashed", "> div > p": new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"blue"], null)})], 0)),new cljs.core.Keyword(null,"more","more",-2058821800),dv.cljs_emotion.css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"border","border",1444987323),"2px solid"], null)], 0))], null);
dv.cljs_emotion.helix_cards.merged_css = dv.cljs_emotion.css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"black"], null),new cljs.core.Keyword(null,"title","title",636505583).cljs$core$IFn$_invoke$arity$1(dv.cljs_emotion.helix_cards.some_css),new cljs.core.Keyword(null,"more","more",-2058821800).cljs$core$IFn$_invoke$arity$1(dv.cljs_emotion.helix_cards.some_css)], 0));
dv.cljs_emotion.helix_cards.object_styles = (function dv$cljs_emotion$helix_cards$object_styles(){
var G__62945 = "div";
var G__62946 = (function (){var obj62951 = ({"css":dv.cljs_emotion.convert_css(new cljs.core.Keyword(null,"self","self",-1547428899).cljs$core$IFn$_invoke$arity$1(dv.cljs_emotion.helix_cards.some_css))});
return obj62951;
})();
var G__62947 = (function (){var G__62952 = "h2";
var G__62953 = (function (){var obj62956 = ({"css":dv.cljs_emotion.convert_css(new cljs.core.Keyword(null,"title","title",636505583).cljs$core$IFn$_invoke$arity$1(dv.cljs_emotion.helix_cards.some_css))});
return obj62956;
})();
var G__62954 = "here we have a title";
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3(G__62952,G__62953,G__62954) : dv.emotion_helix_dom.jsx.call(null,G__62952,G__62953,G__62954));
})();
var G__62948 = (function (){var G__62957 = "h2";
var G__62958 = (function (){var obj62961 = ({"css":dv.cljs_emotion.convert_css(dv.cljs_emotion.helix_cards.merged_css)});
return obj62961;
})();
var G__62959 = "here we have a title";
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3(G__62957,G__62958,G__62959) : dv.emotion_helix_dom.jsx.call(null,G__62957,G__62958,G__62959));
})();
var G__62949 = (function (){var G__62962 = "p";
var G__62963 = (function (){var obj62966 = ({"css":dv.cljs_emotion.convert_css(dv.cljs_emotion.css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([dv.cljs_emotion.helix_cards.merged_css,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"white"], null)], 0)))});
return obj62966;
})();
var G__62964 = "And overwrite inline";
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$3(G__62962,G__62963,G__62964) : dv.emotion_helix_dom.jsx.call(null,G__62962,G__62963,G__62964));
})();
return (dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$5 ? dv.emotion_helix_dom.jsx.cljs$core$IFn$_invoke$arity$5(G__62945,G__62946,G__62947,G__62948,G__62949) : dv.emotion_helix_dom.jsx.call(null,G__62945,G__62946,G__62947,G__62948,G__62949));
});
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.helix_cards","dv.cljs_emotion.helix_cards",1092827443),new cljs.core.Keyword(null,"object-styles-card","object-styles-card",-350522431)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"object-styles-card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),dv.cljs_emotion.helix_cards.object_styles(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.helix_cards","dv.cljs_emotion.helix_cards",1092827443),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),devcards.core.markdown__GT_react.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["We can use object styles as described here [https://emotion.sh/docs/object-styles](https://emotion.sh/docs/object-styles)\n  and here [https://emotion.sh/docs/composition](https://emotion.sh/docs/composition)\n\n  We have the `css` function which lets us mix cljs datatypes with javascript ones.\n\n  This is very flexible and allows creating a library of reusable styles which can be combined per component as needed.",["\n```clojure\n","(def some-css\n  {:self  (em/css #js {:backgroundColor \"#aefefe\"\n                       :border          \"2px solid #eee\"\n                       :borderRadius    \"0.5rem\"\n                       :padding         \"1rem\"})\n   :title (em/css {:font-size \"1.25rem\"\n                   :color     \"red\"}\n            #js{:border     \"1px dashed\"\n                \"> div > p\" {:color \"blue\"}})\n   :more  (em/css {:border \"2px solid\"})})","\n```\n"].join(''),["\n```clojure\n","(def merged-css\n  (em/css\n    {:background-color \"black\"}\n    (:title some-css)\n    (:more some-css)))","\n```\n"].join(''),["\n```clojure\n","(defn object-styles []\n  (d/div {:css (:self some-css)}\n    (d/h2 {:css (:title some-css)} \"here we have a title\")\n    (d/h2 {:css merged-css} \"here we have a title\")\n    (d/p {:css (em/css merged-css {:color \"white\"})}\n      \"And overwrite inline\")))","\n```\n"].join('')], 0)),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"hide-border","hide-border",1463657151),true], null))], 0))], null));
})], null));

//# sourceMappingURL=dv.cljs_emotion.helix_cards.js.map
