goog.provide('dv.cljs_emotion.devcards');
var module$node_modules$polished$dist$polished_cjs=shadow.js.require("module$node_modules$polished$dist$polished_cjs", {});
cljs.core.enable_console_print_BANG_();
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"\n  Hi there. This page uses devcards to demonstrate usage of the dv.cljs-emotion library.\n  This library is a small wrapper around the emotion css-in-js JavaScript library that\n  makes it easy to use all of CSS within a react application.\n\n  The source of these cards can be found here:\n  https://github.com/dvingo/cljs-emotion/tree/master/src/dev/dv/cljs_emotion\n\n  The main API of this library is: `[defstyled keyframes global-style theme-provider]`\n\n  defstyled is a wrapper around `@emotion/styled`\n  Styled is multi-arity and supports passing functions that return maps of styles, a vector of styles that\n  will be merged top down (first to last) and a map, you can also pass JavaScript objects and arrays.\n\n  This library converts between cljs and js structures, but the multi-arity capability is built into emotion already.\n  ",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),null,new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"# Use it\n\nRequire the library:\n```clojure\n(require [dv.cljs-emotion :refer [defstyled keyframes global-style theme-provider]])\n```\n\nOr for reagent support:\n```clojure\n(require [dv.cljs-emotion-reagent :refer [defstyled keyframes global-style theme-provider]])\n```\n\nYou can pass any number of children to defstyled:\n\n```clojure\n(defstyled sample1 :div\n  {:background-color \"RebeccaPurple\"})\n```\n\n```clojure\n(defstyled sample1 :div\n {:background-color \"RebeccaPurple\"}\n #js{:color \"yellow\"}\n (fn [props] {:border-radius 4}))\n```\n\nThis library delegates to emotion's styled API, while adding a transform layer for cljs->js data structures.\n  ",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),null,new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
dv.cljs_emotion.devcards.global_data = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on?","on?",-74017086),false], null));
dv.cljs_emotion.devcards.btn_styles = new cljs.core.PersistentArrayMap(null, 1, ["button",cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"line-height","line-height",1870784992),new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),new cljs.core.Keyword(null,"background-color","background-color",570434026),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"background-image","background-image",-1142314704),":hover",":active",new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"text-shadow","text-shadow",116733623),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),new cljs.core.Keyword(null,"font-family","font-family",-667419874),new cljs.core.Keyword(null,"margin","margin",-995903681)],["1rem",["inset 0 1px 0 white, inset 0 -1px 0 #d9d9d9,"," inset    0 0 0 1px #f2f2f2, 0 2px 4px rgba(0, 0, 0, 0.2)"].join(''),"#8c8c8c","top","all 20ms ease-out",(700),"#f2f2f2","pointer","linear-gradient(to bottom, #f2f2f2, #f2f2f2)",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"background","background",-863952629),"#f2f2f2",new cljs.core.Keyword(null,"border-color","border-color",-2059162761),"#8c8c8c",new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"inset 0 1px 0 white, inset 0 -1px 0 #d9d9d9, inset 0 0 0 1px #f2f2f2"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"inset 0 2px 3px rgba(0, 0, 0, 0.2)"], null),"9px 16px 9px","0 1px 0 rgba(255, 255, 255, 0.5)","1px solid #bfbfbf",(3),"sans-serif","16px 0 0 16px"])], null);
dv.cljs_emotion.devcards.button_styles = new cljs.core.PersistentArrayMap(null, 1, ["button",new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"padding","padding",1660304693),"1rem 2rem",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"transition","transition",765692007),"all .5s",":hover",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755)," 0px 10px 10px rgba(0,0,0,0.2)",new cljs.core.Keyword(null,"transform","transform",1381301764),"translateY(-3px)","::after",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"transform","transform",1381301764),"scaleX(1.4) scaleY(1.6)",new cljs.core.Keyword(null,"opacity","opacity",397153780),(0)], null)], null),"::after",cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"text-transform","text-transform",1685000676),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"top","top",-1856271961),new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"z-index","z-index",1892827090),new cljs.core.Keyword(null,"text-decoration","text-decoration",1836813207),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),new cljs.core.Keyword(null,"height","height",1025178622),new cljs.core.Keyword(null,"left","left",-399115937)],["uppercase","all .5s",(0),"''","100 %",(-1),"none","inline-block","absolute",(100),"100 %",(0)])], null)], null);
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"For a quick demonstration we will change some global styles on this page.\n\n  In this example we add some styles to `<button>` elements on this page.\n\n  If global styles are rendered and then on subsequent render they are not, emotion will remove those global styles\n  from the page so you can dynamically include global styles.\n```clojure\n(html\n  [:div\n  [:h2 \"Click the button to style all the <button>s on this page\"]\n  [:button {:on-click #(swap! global-data update :on? not)} \"Do it.\"]\n (when on? (global-style btn-styles))])\n```\n  ",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (data,_){
var on_QMARK_ = new cljs.core.Keyword(null,"on?","on?",-74017086).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(data));
var G__57222 = "div";
var G__57223 = null;
var G__57224 = (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3("h2",null,"Click the button to style all the <button>s on this page") : sablono.core.create_element.call(null,"h2",null,"Click the button to style all the <button>s on this page"));
var G__57225 = (function (){var G__57227 = "button";
var G__57228 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(dv.cljs_emotion.devcards.global_data,cljs.core.update,new cljs.core.Keyword(null,"on?","on?",-74017086),cljs.core.not);
})});
var G__57229 = "Do it.";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__57227,G__57228,G__57229) : sablono.core.create_element.call(null,G__57227,G__57228,G__57229));
})();
var G__57226 = (cljs.core.truth_(on_QMARK_)?sablono.interpreter.interpret(dv.cljs_emotion.global_style(dv.cljs_emotion.devcards.btn_styles)):null);
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$5 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$5(G__57222,G__57223,G__57224,G__57225,G__57226) : sablono.core.create_element.call(null,G__57222,G__57223,G__57224,G__57225,G__57226));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),dv.cljs_emotion.devcards.global_data,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
var className57233_57467 = "dv.cljs-emotion.devcards/sample1";
var fullClassName57234_57468 = "dv.cljs-emotion.devcards/sample1";
var children57235_57469 = clojure.walk.postwalk((function (x__56880__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__56880__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__56880__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__56880__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__56880__auto__)){
return (function (arg__56881__auto__){
delete arg__56881__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__57236 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__56881__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__56880__auto__.cljs$core$IFn$_invoke$arity$1 ? x__56880__auto__.cljs$core$IFn$_invoke$arity$1(G__57236) : x__56880__auto__.call(null,G__57236));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__56880__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__56880__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__56880__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"rebeCCApurple"], null)], null));
var children57235_57470__$1 = cljs.core.clj__GT_js(children57235_57469);
var component_type57231_57471 = goog.object.get(dv.cljs_emotion.styled,"div");
var clss57232_57472 = component_type57231_57471.apply(component_type57231_57471,children57235_57470__$1);
goog.object.set(clss57232_57472,"displayName","dv.cljs-emotion.devcards/sample1");

dv.cljs_emotion.devcards.sample1 = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss57232_57472,className57233_57467),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName57234_57468),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss57232_57472], null));

var x57243_57473 = dv.cljs_emotion.devcards.sample1;
(x57243_57473.toString = (function (){
var this__56888__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.sample1)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"The main api is defstyled which will return react element factory - a function that accepts props and children.\n\n  ```clojure\n  (defstyled sample1 :div\n    {:background-color \"RebeccaPurple\"})\n\n  (sample1 \"Some text here\")\n  ```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(dv.cljs_emotion.devcards.sample1.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.sample1.cljs$core$IFn$_invoke$arity$1("Some text here") : dv.cljs_emotion.devcards.sample1.call(null,"Some text here")),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"You may find it useful to know that the `className` property is passed through to the rendered element.\n  Inspect the output in the browser devtools to confirm that it works.\n\n  Additionally you will note that the fully qualified symbol name is also added as a classname - this is soley used\n  during development time to see your components easily in the browser devtools. By default these classnames are removed\n  when `goog.DEBUG` is set to `false`. You can keep them during release builds by setting the closure constant:\n\n`dv.cljs-emotion/ADD_CLASSNAMES` to `true`\n\nor if using reagent:\n\n`dv.cljs-emotion-reagent/ADD_CLASSNAMES`\n\nI've set this var to true so these classname will show up in the release build of these devcards.\n\n```clojure\n  (defstyled sample1 :div\n    {:background-color \"RebeccaPurple\"})\n  (sample1 {:className \"TEST\"} \"Some text here\")\n```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var G__57244 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"TEST"], null);
var G__57245 = "Some text here";
return (dv.cljs_emotion.devcards.sample1.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.devcards.sample1.cljs$core$IFn$_invoke$arity$2(G__57244,G__57245) : dv.cljs_emotion.devcards.sample1.call(null,G__57244,G__57245));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
dv.cljs_emotion.devcards.mw_700 = "@media (min-width:700px)";
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"global-styles","global-styles",1792539654)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"global-styles",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Nested styles are supported - as these are part of the emotion API. Here we are applying different styles\n  for screen widths greater than 699 pixels using a breakpoint.\n\n  We also target a global class \"my-thing\" - using the :.classname notation is handled by this library and passes\n  \".my-thing\" to emotion.\n\n  Resize the width of the page to see the effect.\n\n```clojure\n(def mw-700 \"@media (min-width:700px)\")\n[:div\n [:.my-thing \"Some content\"]\n  (global-style\n    {:.my-thing {:background \"navy\" :color \"#cce\" mw-700 {:background \"black\"}}})])\n```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var G__57255 = "div";
var G__57256 = null;
var G__57257 = (function (){var G__57259 = "div";
var G__57260 = ({"className": "my-thing"});
var G__57261 = "Some content";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__57259,G__57260,G__57261) : sablono.core.create_element.call(null,G__57259,G__57260,G__57261));
})();
var G__57258 = sablono.interpreter.interpret(dv.cljs_emotion.global_style(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,".my-thing",".my-thing",780594527),cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"background","background",-863952629),"navy",new cljs.core.Keyword(null,"color","color",1011675173),"#cce",dv.cljs_emotion.devcards.mw_700,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"black"], null)])], null)));
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$4 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$4(G__57255,G__57256,G__57257,G__57258) : sablono.core.create_element.call(null,G__57255,G__57256,G__57257,G__57258));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
dv.cljs_emotion.devcards.animation = dv.cljs_emotion.keyframes(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"transparent"], null),new cljs.core.Keyword(null,"to","to",192099007),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"grey"], null)], null));
dv.cljs_emotion.devcards.animation_styles = (function dv$cljs_emotion$devcards$animation_styles(p__57262){
var map__57263 = p__57262;
var map__57263__$1 = (((((!((map__57263 == null))))?(((((map__57263.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57263.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__57263):map__57263);
var time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57263__$1,new cljs.core.Keyword(null,"time","time",1385887882));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"animation","animation",-1248293244),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dv.cljs_emotion.devcards.animation)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(time),"s ease-in-out infinite"].join('')], null);
});
var className57268_57474 = "dv.cljs-emotion.devcards/with-anim";
var fullClassName57269_57475 = "dv.cljs-emotion.devcards/with-anim";
var children57270_57476 = clojure.walk.postwalk((function (x__56880__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__56880__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__56880__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__56880__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__56880__auto__)){
return (function (arg__56881__auto__){
delete arg__56881__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__57271 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__56881__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__56880__auto__.cljs$core$IFn$_invoke$arity$1 ? x__56880__auto__.cljs$core$IFn$_invoke$arity$1(G__57271) : x__56880__auto__.call(null,G__57271));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__56880__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__56880__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__56880__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [dv.cljs_emotion.devcards.animation_styles], null));
var children57270_57477__$1 = cljs.core.clj__GT_js(children57270_57476);
var component_type57266_57478 = goog.object.get(dv.cljs_emotion.styled,"div");
var clss57267_57479 = component_type57266_57478.apply(component_type57266_57478,children57270_57477__$1);
goog.object.set(clss57267_57479,"displayName","dv.cljs-emotion.devcards/with-anim");

dv.cljs_emotion.devcards.with_anim = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss57267_57479,className57268_57474),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName57269_57475),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss57267_57479], null));

var x57272_57480 = dv.cljs_emotion.devcards.with_anim;
(x57272_57480.toString = (function (){
var this__56888__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.with_anim)))].join('');
}));

dv.cljs_emotion.devcards.animation_card = (function dv$cljs_emotion$devcards$animation_card(a,o){
var G__57273 = "div";
var G__57274 = null;
var G__57275 = (function (){var G__57285 = "p";
var G__57286 = null;
var G__57287 = "animation time: ";
var G__57288 = sablono.interpreter.interpret(new cljs.core.Keyword(null,"time","time",1385887882).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(a)));
var G__57289 = " seconds";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$5 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$5(G__57285,G__57286,G__57287,G__57288,G__57289) : sablono.core.create_element.call(null,G__57285,G__57286,G__57287,G__57288,G__57289));
})();
var G__57276 = (function (){var G__57290 = "button";
var G__57291 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.update,new cljs.core.Keyword(null,"time","time",1385887882),cljs.core.inc);
})});
var G__57292 = "inc";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__57290,G__57291,G__57292) : sablono.core.create_element.call(null,G__57290,G__57291,G__57292));
})();
var G__57277 = (function (){var G__57293 = "button";
var G__57294 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.update,new cljs.core.Keyword(null,"time","time",1385887882),cljs.core.dec);
})});
var G__57295 = "dec";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__57293,G__57294,G__57295) : sablono.core.create_element.call(null,G__57293,G__57294,G__57295));
})();
var G__57278 = sablono.interpreter.interpret((function (){var G__57296 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"time","time",1385887882).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(a))], null);
var G__57297 = "Some text here";
return (dv.cljs_emotion.devcards.with_anim.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.devcards.with_anim.cljs$core$IFn$_invoke$arity$2(G__57296,G__57297) : dv.cljs_emotion.devcards.with_anim.call(null,G__57296,G__57297));
})());
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$6 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$6(G__57273,G__57274,G__57275,G__57276,G__57277,G__57278) : sablono.core.create_element.call(null,G__57273,G__57274,G__57275,G__57276,G__57277,G__57278));
});
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),devcards.core.markdown__GT_react.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Keyframe animations are supported - this is built into emotion. ",["\n```clojure\n","(def animation\n  (keyframes {:from {:background-color \"transparent\"}\n              :to   {:background-color \"grey\"}}))","\n```\n"].join(''),["\n```clojure\n","(defn animation-styles [{:keys [time]}]\n  {:animation (str animation \" \" time \"s ease-in-out infinite\")})","\n```\n"].join(''),["\n```clojure\n","(defstyled with-anim :div\n  animation-styles)","\n```\n"].join(''),["\n```clojure\n","(defn animation-card [a o]\n  (html\n    [:div\n     [:p \"animation time: \" (:time @a) \" seconds\"]\n     [:button {:on-click #(swap! a update :time inc)} \"inc\"]\n     [:button {:on-click #(swap! a update :time dec)} \"dec\"]\n     (with-anim {:time (:time @a)} \"Some text here\")]))","\n```\n"].join('')], 0)),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"hide-border","hide-border",1463657151),true], null))], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"keyframes","keyframes",-1437976012)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"keyframes",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),dv.cljs_emotion.devcards.animation_card,new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"time","time",1385887882),(1)], null),new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
var className57307_57481 = "dv.cljs-emotion.devcards/with-anim2";
var fullClassName57308_57482 = "dv.cljs-emotion.devcards/with-anim2";
var children57309_57483 = clojure.walk.postwalk((function (x__56880__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__56880__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__56880__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__56880__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__56880__auto__)){
return (function (arg__56881__auto__){
delete arg__56881__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__57310 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__56881__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__56880__auto__.cljs$core$IFn$_invoke$arity$1 ? x__56880__auto__.cljs$core$IFn$_invoke$arity$1(G__57310) : x__56880__auto__.call(null,G__57310));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__56880__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__56880__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__56880__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (p__57311){
var map__57312 = p__57311;
var map__57312__$1 = (((((!((map__57312 == null))))?(((((map__57312.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57312.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__57312):map__57312);
var amt = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__57312__$1,new cljs.core.Keyword(null,"amt","amt",-1785711538),(20));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"animation","animation",-1248293244),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dv.cljs_emotion.keyframes(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),module$node_modules$polished$dist$polished_cjs.adjustHue(amt,"yellow")], null),new cljs.core.Keyword(null,"to","to",192099007),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"yellow"], null)], null)))," 2s ease-in-out infinite"].join('')], null);
})], null));
var children57309_57484__$1 = cljs.core.clj__GT_js(children57309_57483);
var component_type57305_57485 = goog.object.get(dv.cljs_emotion.styled,"div");
var clss57306_57486 = component_type57305_57485.apply(component_type57305_57485,children57309_57484__$1);
goog.object.set(clss57306_57486,"displayName","dv.cljs-emotion.devcards/with-anim2");

dv.cljs_emotion.devcards.with_anim2 = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss57306_57486,className57307_57481),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName57308_57482),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss57306_57486], null));

var x57314_57487 = dv.cljs_emotion.devcards.with_anim2;
(x57314_57487.toString = (function (){
var this__56888__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.with_anim2)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"keyframes2","keyframes2",-701299326)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"keyframes2",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Animation can be defined dynamically as well - in the render.\n\n  This example also shows how you can pass any props to the underlying component - in this case onClick.\n\n  ```clojure\n  (defstyled with-anim2 :div\n    (fn [{:keys [amt] :or {amt 20}}]\n      {:animation\n        (str (keyframes\n          {:from {:background (p/adjustHue amt \"yellow\")}\n           :to   {:background \"yellow\"}})\n            \" 2s ease-in-out infinite\")}))\n\n  (html\n  [:div\n    [:p \"hue: \" (p/adjustHue (:amt @a) \"yellow\")]\n    [:button {:on-click #(swap! a update :amt (partial + 10))} \"inc\"]\n    [:button {:on-click #(swap! a update :amt (partial - 10))} \"dec\"]\n    (with-anim2 {:amt     (:amt @a)\n                 :onClick #(js/console.log \"ON CLICK\")} \"Some text here\")])\n  ```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (a,o){
var G__57316 = "div";
var G__57317 = null;
var G__57318 = (function (){var G__57322 = "p";
var G__57323 = null;
var G__57324 = "hue: ";
var G__57325 = sablono.interpreter.interpret(module$node_modules$polished$dist$polished_cjs.adjustHue(new cljs.core.Keyword(null,"amt","amt",-1785711538).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(a)),"yellow"));
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$4 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$4(G__57322,G__57323,G__57324,G__57325) : sablono.core.create_element.call(null,G__57322,G__57323,G__57324,G__57325));
})();
var G__57319 = (function (){var G__57326 = "button";
var G__57327 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.update,new cljs.core.Keyword(null,"amt","amt",-1785711538),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,(10)));
})});
var G__57328 = "inc";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__57326,G__57327,G__57328) : sablono.core.create_element.call(null,G__57326,G__57327,G__57328));
})();
var G__57320 = (function (){var G__57329 = "button";
var G__57330 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.update,new cljs.core.Keyword(null,"amt","amt",-1785711538),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._,(10)));
})});
var G__57331 = "dec";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__57329,G__57330,G__57331) : sablono.core.create_element.call(null,G__57329,G__57330,G__57331));
})();
var G__57321 = sablono.interpreter.interpret((function (){var G__57332 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"amt","amt",-1785711538),new cljs.core.Keyword(null,"amt","amt",-1785711538).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(a)),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),(function (){
return console.log("ON CLICK");
})], null);
var G__57333 = "Some text here";
return (dv.cljs_emotion.devcards.with_anim2.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.devcards.with_anim2.cljs$core$IFn$_invoke$arity$2(G__57332,G__57333) : dv.cljs_emotion.devcards.with_anim2.call(null,G__57332,G__57333));
})());
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$6 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$6(G__57316,G__57317,G__57318,G__57319,G__57320,G__57321) : sablono.core.create_element.call(null,G__57316,G__57317,G__57318,G__57319,G__57320,G__57321));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"amt","amt",-1785711538),(20)], null),new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
var className57336_57488 = "dv.cljs-emotion.devcards/multi";
var fullClassName57337_57489 = "dv.cljs-emotion.devcards/multi";
var children57338_57490 = clojure.walk.postwalk((function (x__56880__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__56880__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__56880__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__56880__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__56880__auto__)){
return (function (arg__56881__auto__){
delete arg__56881__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__57339 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__56881__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__56880__auto__.cljs$core$IFn$_invoke$arity$1 ? x__56880__auto__.cljs$core$IFn$_invoke$arity$1(G__57339) : x__56880__auto__.call(null,G__57339));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__56880__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__56880__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__56880__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"blue"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"yellow"], null),({"borderRadius": (4)}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, ["border","1px solid grey"], null)], null),(function (_){
return new cljs.core.PersistentArrayMap(null, 1, [":hover",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"white"], null)], null);
})], null));
var children57338_57491__$1 = cljs.core.clj__GT_js(children57338_57490);
var component_type57334_57492 = goog.object.get(dv.cljs_emotion.styled,"div");
var clss57335_57493 = component_type57334_57492.apply(component_type57334_57492,children57338_57491__$1);
goog.object.set(clss57335_57493,"displayName","dv.cljs-emotion.devcards/multi");

dv.cljs_emotion.devcards.multi = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss57335_57493,className57336_57488),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName57337_57489),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss57335_57493], null));

var x57340_57494 = dv.cljs_emotion.devcards.multi;
(x57340_57494.toString = (function (){
var this__56888__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.multi)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Multiple children are handled just like emotion:\n```clojure\n(defstyled multi :div\n  {:background \"blue\"}\n  {:color \"yellow\"}\n  #js{\"borderRadius\" 4}\n  [{\"border\" \"1px solid grey\"}]\n  (fn [_] {\":hover\" {:background \"white\"}}))\n\n(multi \"HELLO\")\n```\n",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(dv.cljs_emotion.devcards.multi.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.multi.cljs$core$IFn$_invoke$arity$1("HELLO") : dv.cljs_emotion.devcards.multi.call(null,"HELLO")),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
var className57349_57495 = "dv.cljs-emotion.devcards/multi2";
var fullClassName57350_57496 = "dv.cljs-emotion.devcards/multi2";
var children57351_57497 = clojure.walk.postwalk((function (x__56880__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__56880__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__56880__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__56880__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__56880__auto__)){
return (function (arg__56881__auto__){
delete arg__56881__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__57352 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__56881__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__56880__auto__.cljs$core$IFn$_invoke$arity$1 ? x__56880__auto__.cljs$core$IFn$_invoke$arity$1(G__57352) : x__56880__auto__.call(null,G__57352));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__56880__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__56880__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__56880__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"blue"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"yellow"], null),({"borderRadius": (4)}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, ["border","1px solid grey"], null)], null),(function (_){
return new cljs.core.PersistentArrayMap(null, 1, [":hover",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"white"], null)], null);
})], null)], null));
var children57351_57498__$1 = cljs.core.clj__GT_js(children57351_57497);
var component_type57347_57499 = goog.object.get(dv.cljs_emotion.styled,"div");
var clss57348_57500 = component_type57347_57499.apply(component_type57347_57499,children57351_57498__$1);
goog.object.set(clss57348_57500,"displayName","dv.cljs-emotion.devcards/multi2");

dv.cljs_emotion.devcards.multi2 = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss57348_57500,className57349_57495),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName57350_57496),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss57348_57500], null));

var x57353_57501 = dv.cljs_emotion.devcards.multi2;
(x57353_57501.toString = (function (){
var this__56888__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.multi2)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Anywhere an array is passed emotion will merge those styles, so you can also\n  pass multiple styles as a vector/array:\n\n```clojure\n(defstyled multi2 :div\n  [{:background \"blue\"}\n  {:color \"yellow\"}\n  #js{\"borderRadius\" 4}\n  [{\"border\" \"1px solid grey\"}]\n  (fn [_] {\":hover\" {:background \"white\"}})])\n\n(multi2 \"HELLO\")\n```\n",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(dv.cljs_emotion.devcards.multi2.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.multi2.cljs$core$IFn$_invoke$arity$1("HELLO") : dv.cljs_emotion.devcards.multi2.call(null,"HELLO")),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
var className57356_57502 = "dv.cljs-emotion.devcards/a-fn";
var fullClassName57357_57503 = "dv.cljs-emotion.devcards/a-fn";
var children57358_57504 = clojure.walk.postwalk((function (x__56880__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__56880__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__56880__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__56880__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__56880__auto__)){
return (function (arg__56881__auto__){
delete arg__56881__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__57360 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__56881__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__56880__auto__.cljs$core$IFn$_invoke$arity$1 ? x__56880__auto__.cljs$core$IFn$_invoke$arity$1(G__57360) : x__56880__auto__.call(null,G__57360));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__56880__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__56880__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__56880__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (p__57361){
var map__57362 = p__57361;
var map__57362__$1 = (((((!((map__57362 == null))))?(((((map__57362.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57362.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__57362):map__57362);
var my_padding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57362__$1,new cljs.core.Keyword(null,"my-padding","my-padding",1389925511));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"padding","padding",1660304693),my_padding], null);
})], null));
var children57358_57505__$1 = cljs.core.clj__GT_js(children57358_57504);
var component_type57354_57506 = goog.object.get(dv.cljs_emotion.styled,"button");
var clss57355_57507 = component_type57354_57506.apply(component_type57354_57506,children57358_57505__$1);
goog.object.set(clss57355_57507,"displayName","dv.cljs-emotion.devcards/a-fn");

dv.cljs_emotion.devcards.a_fn = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss57355_57507,className57356_57502),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName57357_57503),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss57355_57507], null));

var x57364_57508 = dv.cljs_emotion.devcards.a_fn;
(x57364_57508.toString = (function (){
var this__56888__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.a_fn)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Any props you pass to the component at render time are converted to cljs data\n  structures via `js->clj` and then passed to any functions in defstyled. The output of your\n  function is then passed to `clj->js` and on to emotion.\n```clojure\n(defstyled a-fn :button\n  (fn [{:keys [my-padding]}]\n    {:padding my-padding}))\n\n  (a-fn\n    {:my-padding 20 :onClick #(js/console.log \"clicked\")\n     :another-key 5} \"This is a button\")\n```\n  ",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var G__57365 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"my-padding","my-padding",1389925511),(20),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),(function (){
return console.log("clicked");
}),new cljs.core.Keyword(null,"another-key","another-key",1757915937),(5)], null);
var G__57366 = "This is a button";
return (dv.cljs_emotion.devcards.a_fn.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.devcards.a_fn.cljs$core$IFn$_invoke$arity$2(G__57365,G__57366) : dv.cljs_emotion.devcards.a_fn.call(null,G__57365,G__57366));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
var className57369_57509 = "dv.cljs-emotion.devcards/flex";
var fullClassName57370_57510 = "dv.cljs-emotion.devcards/flex";
var children57371_57511 = clojure.walk.postwalk((function (x__56880__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__56880__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__56880__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__56880__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__56880__auto__)){
return (function (arg__56881__auto__){
delete arg__56881__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__57372 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__56881__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__56880__auto__.cljs$core$IFn$_invoke$arity$1 ? x__56880__auto__.cljs$core$IFn$_invoke$arity$1(G__57372) : x__56880__auto__.call(null,G__57372));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__56880__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__56880__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__56880__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex-wrap","flex-wrap",455413707),"wrap",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"space-evenly"], null)], null));
var children57371_57512__$1 = cljs.core.clj__GT_js(children57371_57511);
var component_type57367_57513 = goog.object.get(dv.cljs_emotion.styled,"div");
var clss57368_57514 = component_type57367_57513.apply(component_type57367_57513,children57371_57512__$1);
goog.object.set(clss57368_57514,"displayName","dv.cljs-emotion.devcards/flex");

dv.cljs_emotion.devcards.flex = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss57368_57514,className57369_57509),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName57370_57510),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss57368_57514], null));

var x57373_57515 = dv.cljs_emotion.devcards.flex;
(x57373_57515.toString = (function (){
var this__56888__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.flex)))].join('');
}));

var className57376_57516 = "dv.cljs-emotion.devcards/box";
var fullClassName57377_57517 = "dv.cljs-emotion.devcards/box";
var children57378_57518 = clojure.walk.postwalk((function (x__56880__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__56880__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__56880__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__56880__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__56880__auto__)){
return (function (arg__56881__auto__){
delete arg__56881__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__57379 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__56881__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__56880__auto__.cljs$core$IFn$_invoke$arity$1 ? x__56880__auto__.cljs$core$IFn$_invoke$arity$1(G__57379) : x__56880__auto__.call(null,G__57379));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__56880__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__56880__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__56880__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"width","width",-384071477),"20%",new cljs.core.Keyword(null,"padding","padding",1660304693),"1rem 0",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"margin","margin",-995903681),"1rem",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center",new cljs.core.Keyword(null,"background","background",-863952629),"palEvIoletrEd"], null)], null));
var children57378_57519__$1 = cljs.core.clj__GT_js(children57378_57518);
var component_type57374_57520 = goog.object.get(dv.cljs_emotion.styled,"div");
var clss57375_57521 = component_type57374_57520.apply(component_type57374_57520,children57378_57519__$1);
goog.object.set(clss57375_57521,"displayName","dv.cljs-emotion.devcards/box");

dv.cljs_emotion.devcards.box = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss57375_57521,className57376_57516),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName57377_57517),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss57375_57521], null));

var x57380_57522 = dv.cljs_emotion.devcards.box;
(x57380_57522.toString = (function (){
var this__56888__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.box)))].join('');
}));

var className57383_57523 = "dv.cljs-emotion.devcards/box2";
var fullClassName57384_57524 = "dv.cljs-emotion.devcards/box2";
var children57385_57525 = clojure.walk.postwalk((function (x__56880__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__56880__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__56880__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__56880__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__56880__auto__)){
return (function (arg__56881__auto__){
delete arg__56881__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__57386 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__56881__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__56880__auto__.cljs$core$IFn$_invoke$arity$1 ? x__56880__auto__.cljs$core$IFn$_invoke$arity$1(G__57386) : x__56880__auto__.call(null,G__57386));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__56880__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__56880__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__56880__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"user-select","user-select",-346451650),"none",new cljs.core.Keyword(null,"background","background",-863952629),module$node_modules$polished$dist$polished_cjs.lighten(0.2,"palevioletred"),new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",":hover",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),module$node_modules$polished$dist$polished_cjs.darken(0.2,"palevioletred")], null),":active",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"background","background",-863952629),module$node_modules$polished$dist$polished_cjs.darken(0.4,"palevioletred"),new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"4px 4px lightgrey"], null)], null)], null));
var children57385_57526__$1 = cljs.core.clj__GT_js(children57385_57525);
var component_type57381_57527 = ((typeof dv.cljs_emotion.devcards.box === 'string')?goog.object.get(dv.cljs_emotion.styled,dv.cljs_emotion.devcards.box):(((dv.cljs_emotion.devcards.box instanceof cljs.core.Keyword))?goog.object.get(dv.cljs_emotion.styled,"box"):(cljs.core.truth_(new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.box)))?dv.cljs_emotion.styled.call(dv.cljs_emotion.styled,new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.box))):dv.cljs_emotion.styled.call(dv.cljs_emotion.styled,dv.cljs_emotion.devcards.box)
)));
var clss57382_57528 = component_type57381_57527.apply(component_type57381_57527,children57385_57526__$1);
goog.object.set(clss57382_57528,"displayName","dv.cljs-emotion.devcards/box2");

dv.cljs_emotion.devcards.box2 = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss57382_57528,className57383_57523),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName57384_57524),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss57382_57528], null));

var x57387_57529 = dv.cljs_emotion.devcards.box2;
(x57387_57529.toString = (function (){
var this__56888__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.box2)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"flex-card","flex-card",-1954027863)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"flex-card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Here is a somewhat larger example, showing the extension feature of emotion to override styles.\n\n  This example using the polished library as well.\n\n```clojure\n(defstyled flex :div\n  {:display         \"flex\"\n   :flex-wrap       \"wrap\"\n   :justify-content \"space-evenly\"})\n\n(defstyled box :div\n  {:width           \"20%\"\n   :padding         \"1rem 0\"\n   :display         \"flex\"\n   :margin          \"1rem\"\n   :justify-content \"center\"\n   :background      \"palEvIoletrEd\"})\n\n\n(defstyled box2 box\n  {:border-radius \"4px\"\n   :user-select   \"none\"\n   :background    (p/lighten 0.2 \"palevioletred\")\n   :cursor        \"pointer\"\n   \":hover\"       {:background (darken 0.2 \"palevioletred\")}\n   \":active\"      {:background (darken 0.4 \"palevioletred\")\n                   :box-shadow \"4px 4px lightgrey\"}})\n\n(flex (box \"box\") (box \"box\") (box \"box\") (box2 \"box2\") (box2 \"box2\") (box \"box\") (box \"box\") (box2 \"box2\") (box \"box\")))\n```\n",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var G__57388 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__57389 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__57390 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__57391 = (dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1("box2") : dv.cljs_emotion.devcards.box2.call(null,"box2"));
var G__57392 = (dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1("box2") : dv.cljs_emotion.devcards.box2.call(null,"box2"));
var G__57393 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__57394 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__57395 = (dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1("box2") : dv.cljs_emotion.devcards.box2.call(null,"box2"));
var G__57396 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
return (dv.cljs_emotion.devcards.flex.cljs$core$IFn$_invoke$arity$9 ? dv.cljs_emotion.devcards.flex.cljs$core$IFn$_invoke$arity$9(G__57388,G__57389,G__57390,G__57391,G__57392,G__57393,G__57394,G__57395,G__57396) : dv.cljs_emotion.devcards.flex.call(null,G__57388,G__57389,G__57390,G__57391,G__57392,G__57393,G__57394,G__57395,G__57396));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"update-global-styles","update-global-styles",1487171421)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"update-global-styles",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"\n  This example changes the body background of this page's body color.\n  ```clojure\n  [:div\n         [:label \"Input a color for the background color:\"]\n         [:input {:value bg :on-change #(swap! a assoc :bg (-> % .-target .-value))}]\n         (global-style {:body {:background bg}})]\n   ```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (a,_){
var map__57398 = cljs.core.deref(a);
var map__57398__$1 = (((((!((map__57398 == null))))?(((((map__57398.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57398.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__57398):map__57398);
var bg = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57398__$1,new cljs.core.Keyword(null,"bg","bg",-206688421));
var G__57402 = "div";
var G__57403 = null;
var G__57404 = (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3("label",null,"Input a color for the background color:") : sablono.core.create_element.call(null,"label",null,"Input a color for the background color:"));
var G__57405 = sablono.interpreter.create_element("input",({"value": bg, "onChange": (function (p1__57397_SHARP_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),p1__57397_SHARP_.target.value);
})}));
var G__57406 = sablono.interpreter.interpret(dv.cljs_emotion.global_style(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),bg], null)], null)));
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$5 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$5(G__57402,G__57403,G__57404,G__57405,G__57406) : sablono.core.create_element.call(null,G__57402,G__57403,G__57404,G__57405,G__57406));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bg","bg",-206688421),"#cce"], null),new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
dv.cljs_emotion.devcards.start_bg = "#eeaabb";
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"update-card-bg-styles","update-card-bg-styles",-771594595)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"update-card-bg-styles",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"\n  This example changes the background color of this card.\n  ```clojure\n  (let [{:keys [bg]} @a\n          cls :.my-card]\n      (html\n        [:div\n         [:label \"Input a color for the background:\"]\n         [:input {:value bg :on-change #(swap! a assoc :bg (-> % .-target .-value))}]\n         [:button {:on-click #(swap! a assoc :bg start-bg)} \"reset\"]\n         [:button\n          {:on-click\n           #(swap! a assoc :bg (p/lighten 0.08 bg))} \"lighten\"]\n\n         [:button\n          {:on-click\n           #(swap! a assoc :bg (p/darken 0.08 bg))} \"darken\"]\n         (global-style {cls {:background bg}})]))\n   ```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (a,_){
var map__57408 = cljs.core.deref(a);
var map__57408__$1 = (((((!((map__57408 == null))))?(((((map__57408.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57408.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__57408):map__57408);
var bg = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57408__$1,new cljs.core.Keyword(null,"bg","bg",-206688421));
var cls = new cljs.core.Keyword(null,".my-card",".my-card",1656982961);
var G__57412 = "div";
var G__57413 = null;
var G__57414 = (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3("label",null,"Input a color for the background:") : sablono.core.create_element.call(null,"label",null,"Input a color for the background:"));
var G__57415 = sablono.interpreter.create_element("input",({"value": bg, "onChange": (function (p1__57407_SHARP_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),p1__57407_SHARP_.target.value);
})}));
var G__57416 = (function (){var G__57420 = "button";
var G__57421 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),dv.cljs_emotion.devcards.start_bg);
})});
var G__57422 = "reset";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__57420,G__57421,G__57422) : sablono.core.create_element.call(null,G__57420,G__57421,G__57422));
})();
var G__57417 = (function (){var G__57423 = "button";
var G__57424 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),module$node_modules$polished$dist$polished_cjs.lighten(0.08,bg));
})});
var G__57425 = "lighten";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__57423,G__57424,G__57425) : sablono.core.create_element.call(null,G__57423,G__57424,G__57425));
})();
var G__57418 = (function (){var G__57426 = "button";
var G__57427 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),module$node_modules$polished$dist$polished_cjs.darken(0.08,bg));
})});
var G__57428 = "darken";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__57426,G__57427,G__57428) : sablono.core.create_element.call(null,G__57426,G__57427,G__57428));
})();
var G__57419 = sablono.interpreter.interpret(dv.cljs_emotion.global_style(cljs.core.PersistentArrayMap.createAsIfByAssoc([cls,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),bg], null)])));
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$8 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$8(G__57412,G__57413,G__57414,G__57415,G__57416,G__57417,G__57418,G__57419) : sablono.core.create_element.call(null,G__57412,G__57413,G__57414,G__57415,G__57416,G__57417,G__57418,G__57419));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bg","bg",-206688421),dv.cljs_emotion.devcards.start_bg], null),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"classname","classname",777390796),"my-card"], null)], null));
})], null));
var className57431_57530 = "dv.cljs-emotion.devcards/test-theme";
var fullClassName57432_57531 = "dv.cljs-emotion.devcards/test-theme";
var children57433_57532 = clojure.walk.postwalk((function (x__56880__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__56880__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__56880__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__56880__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__56880__auto__)){
return (function (arg__56881__auto__){
delete arg__56881__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__57434 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__56881__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__56880__auto__.cljs$core$IFn$_invoke$arity$1 ? x__56880__auto__.cljs$core$IFn$_invoke$arity$1(G__57434) : x__56880__auto__.call(null,G__57434));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__56880__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__56880__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__56880__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (p__57435){
var map__57436 = p__57435;
var map__57436__$1 = (((((!((map__57436 == null))))?(((((map__57436.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57436.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__57436):map__57436);
var theme = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57436__$1,new cljs.core.Keyword(null,"theme","theme",-1247880880));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"bg","bg",-206688421).cljs$core$IFn$_invoke$arity$1(theme);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "blue";
}
})()], null);
})], null));
var children57433_57533__$1 = cljs.core.clj__GT_js(children57433_57532);
var component_type57429_57534 = goog.object.get(dv.cljs_emotion.styled,"div");
var clss57430_57535 = component_type57429_57534.apply(component_type57429_57534,children57433_57533__$1);
goog.object.set(clss57430_57535,"displayName","dv.cljs-emotion.devcards/test-theme");

dv.cljs_emotion.devcards.test_theme = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss57430_57535,className57431_57530),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName57432_57531),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss57430_57535], null));

var x57438_57536 = dv.cljs_emotion.devcards.test_theme;
(x57438_57536.toString = (function (){
var this__56888__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.test_theme)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"theme-provider-card","theme-provider-card",-1686140511)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"theme-provider-card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Theme use is straight forward.\n\n  It wraps emotion's ThemeProvider calling clj->js first on the props.\n  Wrap your application with `theme-provider` passing it\n  a map or JS object of theme data.\n```clojure\n(defstyled test-theme :div\n  (fn [{:keys [theme]}]\n    {:background (or (:bg theme) \"blue\")}))\n\n(html\n  [:div\n   (theme-provider {:theme {:bg \"yellow\"}} (test-theme \"Hello there theme\"))\n   (test-theme \"no theme\")])\n```\n",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var attrs57439 = dv.cljs_emotion.theme_provider.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"theme","theme",-1247880880),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bg","bg",-206688421),"yellow"], null)], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1("Hello there theme") : dv.cljs_emotion.devcards.test_theme.call(null,"Hello there theme"))], 0));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(sablono.core.create_element,"div",((cljs.core.map_QMARK_(attrs57439))?sablono.interpreter.attributes(attrs57439):null),((cljs.core.map_QMARK_(attrs57439))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret((dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1("no theme") : dv.cljs_emotion.devcards.test_theme.call(null,"no theme")))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs57439),sablono.interpreter.interpret((dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1("no theme") : dv.cljs_emotion.devcards.test_theme.call(null,"no theme")))], null)));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
dv.cljs_emotion.devcards.anon_styles = (function dv$cljs_emotion$devcards$anon_styles(){
var G__57440 = "div";
var G__57441 = (function (){
if(cljs.core.contains_QMARK_(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"lightgrey"], null)], null),new cljs.core.Keyword(null,"css","css",1135045163))){
} else {
throw (new Error(["Assert failed: ","Props must contain :css key","\n","(clojure.core/contains? {:css {:background \"lightgrey\"}} :css)"].join('')));
}

return cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"lightgrey"], null)], null),new cljs.core.Keyword(null,"css","css",1135045163),clojure.walk.postwalk((function (x__56880__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__56880__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__56880__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__56880__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__56880__auto__)){
return (function (arg__56881__auto__){
delete arg__56881__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__57443 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__56881__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__56880__auto__.cljs$core$IFn$_invoke$arity$1 ? x__56880__auto__.cljs$core$IFn$_invoke$arity$1(G__57443) : x__56880__auto__.call(null,G__57443));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__56880__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__56880__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__56880__auto__;

}
}
}
}),new cljs.core.Keyword(null,"css","css",1135045163).cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"lightgrey"], null)], null)))));
})()
;
var G__57442 = "Some text on a lightgrey background.";
return (dv.cljs_emotion.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.cljs_emotion.jsx.cljs$core$IFn$_invoke$arity$3(G__57440,G__57441,G__57442) : dv.cljs_emotion.jsx.call(null,G__57440,G__57441,G__57442));
});
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),devcards.core.markdown__GT_react.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["# Anonymous inline styles support.\n   You can use the `css` helper to style a react element inline without needing to create a component.",["\n```clojure\n","(defn anon-styles []\n  (css :div {:css {:background \"lightgrey\"}}\n    \"Some text on a lightgrey background.\"))","\n```\n"].join('')], 0)),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"hide-border","hide-border",1463657151),true], null))], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),dv.cljs_emotion.devcards.anon_styles(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
dv.cljs_emotion.devcards.anon_styles2 = (function dv$cljs_emotion$devcards$anon_styles2(){
var G__57444 = "div";
var G__57445 = (function (){
if(cljs.core.contains_QMARK_(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"lightgrey"], null)], null),new cljs.core.Keyword(null,"css","css",1135045163))){
} else {
throw (new Error(["Assert failed: ","Props must contain :css key","\n","(clojure.core/contains? {:css {:background \"lightgrey\"}} :css)"].join('')));
}

return cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"lightgrey"], null)], null),new cljs.core.Keyword(null,"css","css",1135045163),clojure.walk.postwalk((function (x__56880__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__56880__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__56880__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__56880__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__56880__auto__)){
return (function (arg__56881__auto__){
delete arg__56881__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__57447 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__56881__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__56880__auto__.cljs$core$IFn$_invoke$arity$1 ? x__56880__auto__.cljs$core$IFn$_invoke$arity$1(G__57447) : x__56880__auto__.call(null,G__57447));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__56880__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__56880__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__56880__auto__;

}
}
}
}),new cljs.core.Keyword(null,"css","css",1135045163).cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"lightgrey"], null)], null)))));
})()
;
var G__57446 = (function (){var G__57450 = "div";
var G__57451 = null;
var G__57452 = (function (){var G__57455 = "div";
var G__57456 = null;
var G__57457 = (function (){var G__57458 = "div";
var G__57459 = ({"key": (1)});
var G__57460 = "Hello";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__57458,G__57459,G__57460) : sablono.core.create_element.call(null,G__57458,G__57459,G__57460));
})();
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__57455,G__57456,G__57457) : sablono.core.create_element.call(null,G__57455,G__57456,G__57457));
})();
var G__57453 = (function (){var G__57461 = "div";
var G__57462 = ({"key": (2)});
var G__57463 = "Hello2";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__57461,G__57462,G__57463) : sablono.core.create_element.call(null,G__57461,G__57462,G__57463));
})();
var G__57454 = (function (){var G__57464 = "div";
var G__57465 = ({"key": (3)});
var G__57466 = "Hello3";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__57464,G__57465,G__57466) : sablono.core.create_element.call(null,G__57464,G__57465,G__57466));
})();
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$5 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$5(G__57450,G__57451,G__57452,G__57453,G__57454) : sablono.core.create_element.call(null,G__57450,G__57451,G__57452,G__57453,G__57454));
})();
return (dv.cljs_emotion.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.cljs_emotion.jsx.cljs$core$IFn$_invoke$arity$3(G__57444,G__57445,G__57446) : dv.cljs_emotion.jsx.call(null,G__57444,G__57445,G__57446));
});
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),devcards.core.markdown__GT_react.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Multiple children are wrapped in a react fragment.",["\n```clojure\n","(defn anon-styles2 []\n  (css :div {:css {:background \"lightgrey\"}}\n    (html\n      [:div\n       [:div [:div {:key 1} \"Hello\"]]\n       [:div {:key 2} \"Hello2\"]\n       [:div {:key 3} \"Hello3\"]])))","\n```\n"].join('')], 0)),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"hide-border","hide-border",1463657151),true], null))], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),dv.cljs_emotion.devcards.anon_styles2(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
dv.cljs_emotion.devcards.main = (function dv$cljs_emotion$devcards$main(){
return devcards.core.start_devcard_ui_BANG__STAR_.cljs$core$IFn$_invoke$arity$0();
});
goog.exportSymbol('dv.cljs_emotion.devcards.main', dv.cljs_emotion.devcards.main);

//# sourceMappingURL=dv.cljs_emotion.devcards.js.map
