goog.provide('dv.cljs_emotion.devcards');
var module$node_modules$polished$dist$polished_cjs=shadow.js.require("module$node_modules$polished$dist$polished_cjs", {});
cljs.core.enable_console_print_BANG_();
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"\n  Hi there. This page uses devcards to demonstrate usage of the dv.cljs-emotion library.\n  This library is a small wrapper around the emotion css-in-js JavaScript library that\n  makes it easy to use all of CSS within a react application.\n\n  The source of these cards can be found here:\n  https://github.com/dvingo/cljs-emotion/tree/master/src/dev/dv/cljs_emotion\n\n  The main API of this library is: `[defstyled keyframes global-style theme-provider]`\n\n  defstyled is a wrapper around `@emotion/styled`\n  Styled is multi-arity and supports passing functions that return maps of styles, a vector of styles that\n  will be merged top down (first to last) and a map, you can also pass JavaScript objects and arrays.\n\n  This library converts between cljs and js structures, but the multi-arity capability is built into emotion already.\n  ",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),null,new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"# Use it\n\nRequire the library:\n```clojure\n(require [dv.cljs-emotion :refer [defstyled keyframes global-style theme-provider]])\n```\n\nOr for reagent support:\n```clojure\n(require [dv.cljs-emotion-reagent :refer [defstyled keyframes global-style theme-provider]])\n```\n\nYou can pass any number of children to defstyled:\n\n```clojure\n(defstyled sample1 :div\n  {:background-color \"RebeccaPurple\"})\n```\n\n```clojure\n(defstyled sample1 :div\n {:background-color \"RebeccaPurple\"}\n #js{:color \"yellow\"}\n (fn [props] {:border-radius 4}))\n```\n\nThis library delegates to emotion's styled API, while adding a transform layer for cljs->js data structures.\n  ",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),null,new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
dv.cljs_emotion.devcards.global_data = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on?","on?",-74017086),false], null));
dv.cljs_emotion.devcards.btn_styles = new cljs.core.PersistentArrayMap(null, 1, ["button",cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"line-height","line-height",1870784992),new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),new cljs.core.Keyword(null,"background-color","background-color",570434026),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"background-image","background-image",-1142314704),":hover",":active",new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"text-shadow","text-shadow",116733623),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),new cljs.core.Keyword(null,"font-family","font-family",-667419874),new cljs.core.Keyword(null,"margin","margin",-995903681)],["1rem",["inset 0 1px 0 white, inset 0 -1px 0 #d9d9d9,"," inset    0 0 0 1px #f2f2f2, 0 2px 4px rgba(0, 0, 0, 0.2)"].join(''),"#8c8c8c","top","all 20ms ease-out",(700),"#f2f2f2","pointer","linear-gradient(to bottom, #f2f2f2, #f2f2f2)",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"background","background",-863952629),"#f2f2f2",new cljs.core.Keyword(null,"border-color","border-color",-2059162761),"#8c8c8c",new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"inset 0 1px 0 white, inset 0 -1px 0 #d9d9d9, inset 0 0 0 1px #f2f2f2"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"inset 0 2px 3px rgba(0, 0, 0, 0.2)"], null),"9px 16px 9px","0 1px 0 rgba(255, 255, 255, 0.5)","1px solid #bfbfbf",(3),"sans-serif","16px 0 0 16px"])], null);
dv.cljs_emotion.devcards.button_styles = new cljs.core.PersistentArrayMap(null, 1, ["button",new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"padding","padding",1660304693),"1rem 2rem",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"transition","transition",765692007),"all .5s",":hover",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755)," 0px 10px 10px rgba(0,0,0,0.2)",new cljs.core.Keyword(null,"transform","transform",1381301764),"translateY(-3px)","::after",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"transform","transform",1381301764),"scaleX(1.4) scaleY(1.6)",new cljs.core.Keyword(null,"opacity","opacity",397153780),(0)], null)], null),"::after",cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"text-transform","text-transform",1685000676),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"top","top",-1856271961),new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"z-index","z-index",1892827090),new cljs.core.Keyword(null,"text-decoration","text-decoration",1836813207),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),new cljs.core.Keyword(null,"height","height",1025178622),new cljs.core.Keyword(null,"left","left",-399115937)],["uppercase","all .5s",(0),"''","100 %",(-1),"none","inline-block","absolute",(100),"100 %",(0)])], null)], null);
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"For a quick demonstration we will change some global styles on this page.\n\n  In this example we add some styles to `<button>` elements on this page.\n\n  If global styles are rendered and then on subsequent render they are not, emotion will remove those global styles\n  from the page so you can dynamically include global styles.\n```clojure\n(html\n  [:div\n  [:h2 \"Click the button to style all the <button>s on this page\"]\n  [:button {:on-click #(swap! global-data update :on? not)} \"Do it.\"]\n (when on? (global-style btn-styles))])\n```\n  ",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (data,_){
var on_QMARK_ = new cljs.core.Keyword(null,"on?","on?",-74017086).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(data));
var G__55566 = "div";
var G__55567 = null;
var G__55568 = (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3("h2",null,"Click the button to style all the <button>s on this page") : sablono.core.create_element.call(null,"h2",null,"Click the button to style all the <button>s on this page"));
var G__55569 = (function (){var G__55571 = "button";
var G__55572 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(dv.cljs_emotion.devcards.global_data,cljs.core.update,new cljs.core.Keyword(null,"on?","on?",-74017086),cljs.core.not);
})});
var G__55573 = "Do it.";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__55571,G__55572,G__55573) : sablono.core.create_element.call(null,G__55571,G__55572,G__55573));
})();
var G__55570 = (cljs.core.truth_(on_QMARK_)?sablono.interpreter.interpret(dv.cljs_emotion.global_style(dv.cljs_emotion.devcards.btn_styles)):null);
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$5 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$5(G__55566,G__55567,G__55568,G__55569,G__55570) : sablono.core.create_element.call(null,G__55566,G__55567,G__55568,G__55569,G__55570));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),dv.cljs_emotion.devcards.global_data,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
var className55576_55824 = "dv.cljs-emotion.devcards/sample1";
var fullClassName55577_55825 = "dv.cljs-emotion.devcards/sample1";
var children55578_55826 = clojure.walk.postwalk((function (x__55237__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__55237__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__55237__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__55237__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__55237__auto__)){
return (function (arg__55238__auto__){
delete arg__55238__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__55579 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__55238__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__55237__auto__.cljs$core$IFn$_invoke$arity$1 ? x__55237__auto__.cljs$core$IFn$_invoke$arity$1(G__55579) : x__55237__auto__.call(null,G__55579));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__55237__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__55237__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__55237__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"rebeCCApurple"], null)], null));
var children55578_55827__$1 = cljs.core.clj__GT_js(children55578_55826);
var component_type55574_55828 = goog.object.get(dv.cljs_emotion.styled,"div");
var clss55575_55829 = component_type55574_55828.apply(component_type55574_55828,children55578_55827__$1);
goog.object.set(clss55575_55829,"displayName","dv.cljs-emotion.devcards/sample1");

dv.cljs_emotion.devcards.sample1 = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss55575_55829,className55576_55824),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName55577_55825),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss55575_55829], null));

var x55586_55830 = dv.cljs_emotion.devcards.sample1;
(x55586_55830.toString = (function (){
var this__55245__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.sample1)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"The main api is defstyled which will return react element factory - a function that accepts props and children.\n\n  ```clojure\n  (defstyled sample1 :div\n    {:background-color \"RebeccaPurple\"})\n\n  (sample1 \"Some text here\")\n  ```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(dv.cljs_emotion.devcards.sample1.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.sample1.cljs$core$IFn$_invoke$arity$1("Some text here") : dv.cljs_emotion.devcards.sample1.call(null,"Some text here")),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"You may find it useful to know that the `className` property is passed through to the rendered element.\n  Inspect the output in the browser devtools to confirm that it works.\n\n  Additionally you will note that the fully qualified symbol name is also added as a classname - this is soley used\n  during development time to see your components easily in the browser devtools. By default these classnames are removed\n  when `goog.DEBUG` is set to `false`. You can keep them during release builds by setting the closure constant:\n\n`dv.cljs-emotion/ADD_CLASSNAMES` to `true`\n\nor if using reagent:\n\n`dv.cljs-emotion-reagent/ADD_CLASSNAMES`\n\nI've set this var to true so these classname will show up in the release build of these devcards.\n\n```clojure\n  (defstyled sample1 :div\n    {:background-color \"RebeccaPurple\"})\n  (sample1 {:className \"TEST\"} \"Some text here\")\n```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var G__55587 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"TEST"], null);
var G__55588 = "Some text here";
return (dv.cljs_emotion.devcards.sample1.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.devcards.sample1.cljs$core$IFn$_invoke$arity$2(G__55587,G__55588) : dv.cljs_emotion.devcards.sample1.call(null,G__55587,G__55588));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
dv.cljs_emotion.devcards.mw_700 = "@media (min-width:700px)";
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"global-styles","global-styles",1792539654)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"global-styles",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Nested styles are supported - as these are part of the emotion API. Here we are applying different styles\n  for screen widths greater than 699 pixels using a breakpoint.\n\n  We also target a global class \"my-thing\" - using the :.classname notation is handled by this library and passes\n  \".my-thing\" to emotion.\n\n  Resize the width of the page to see the effect.\n\n```clojure\n(def mw-700 \"@media (min-width:700px)\")\n[:div\n [:.my-thing \"Some content\"]\n  (global-style\n    {:.my-thing {:background \"navy\" :color \"#cce\" mw-700 {:background \"black\"}}})])\n```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var G__55592 = "div";
var G__55593 = null;
var G__55594 = (function (){var G__55596 = "div";
var G__55597 = ({"className": "my-thing"});
var G__55598 = "Some content";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__55596,G__55597,G__55598) : sablono.core.create_element.call(null,G__55596,G__55597,G__55598));
})();
var G__55595 = sablono.interpreter.interpret(dv.cljs_emotion.global_style(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,".my-thing",".my-thing",780594527),cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"background","background",-863952629),"navy",new cljs.core.Keyword(null,"color","color",1011675173),"#cce",dv.cljs_emotion.devcards.mw_700,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"black"], null)])], null)));
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$4 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$4(G__55592,G__55593,G__55594,G__55595) : sablono.core.create_element.call(null,G__55592,G__55593,G__55594,G__55595));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
dv.cljs_emotion.devcards.animation = dv.cljs_emotion.keyframes(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"transparent"], null),new cljs.core.Keyword(null,"to","to",192099007),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"grey"], null)], null));
dv.cljs_emotion.devcards.animation_styles = (function dv$cljs_emotion$devcards$animation_styles(p__55599){
var map__55600 = p__55599;
var map__55600__$1 = (((((!((map__55600 == null))))?(((((map__55600.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55600.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55600):map__55600);
var time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55600__$1,new cljs.core.Keyword(null,"time","time",1385887882));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"animation","animation",-1248293244),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dv.cljs_emotion.devcards.animation)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(time),"s ease-in-out infinite"].join('')], null);
});
var className55610_55831 = "dv.cljs-emotion.devcards/with-anim";
var fullClassName55611_55832 = "dv.cljs-emotion.devcards/with-anim";
var children55612_55833 = clojure.walk.postwalk((function (x__55237__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__55237__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__55237__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__55237__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__55237__auto__)){
return (function (arg__55238__auto__){
delete arg__55238__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__55613 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__55238__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__55237__auto__.cljs$core$IFn$_invoke$arity$1 ? x__55237__auto__.cljs$core$IFn$_invoke$arity$1(G__55613) : x__55237__auto__.call(null,G__55613));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__55237__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__55237__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__55237__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [dv.cljs_emotion.devcards.animation_styles], null));
var children55612_55834__$1 = cljs.core.clj__GT_js(children55612_55833);
var component_type55608_55835 = goog.object.get(dv.cljs_emotion.styled,"div");
var clss55609_55836 = component_type55608_55835.apply(component_type55608_55835,children55612_55834__$1);
goog.object.set(clss55609_55836,"displayName","dv.cljs-emotion.devcards/with-anim");

dv.cljs_emotion.devcards.with_anim = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss55609_55836,className55610_55831),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName55611_55832),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss55609_55836], null));

var x55614_55837 = dv.cljs_emotion.devcards.with_anim;
(x55614_55837.toString = (function (){
var this__55245__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.with_anim)))].join('');
}));

dv.cljs_emotion.devcards.animation_card = (function dv$cljs_emotion$devcards$animation_card(a,o){
var G__55616 = "div";
var G__55617 = null;
var G__55618 = (function (){var G__55622 = "p";
var G__55623 = null;
var G__55624 = "animation time: ";
var G__55625 = sablono.interpreter.interpret(new cljs.core.Keyword(null,"time","time",1385887882).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(a)));
var G__55626 = " seconds";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$5 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$5(G__55622,G__55623,G__55624,G__55625,G__55626) : sablono.core.create_element.call(null,G__55622,G__55623,G__55624,G__55625,G__55626));
})();
var G__55619 = (function (){var G__55627 = "button";
var G__55628 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.update,new cljs.core.Keyword(null,"time","time",1385887882),cljs.core.inc);
})});
var G__55629 = "inc";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__55627,G__55628,G__55629) : sablono.core.create_element.call(null,G__55627,G__55628,G__55629));
})();
var G__55620 = (function (){var G__55630 = "button";
var G__55631 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.update,new cljs.core.Keyword(null,"time","time",1385887882),cljs.core.dec);
})});
var G__55632 = "dec";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__55630,G__55631,G__55632) : sablono.core.create_element.call(null,G__55630,G__55631,G__55632));
})();
var G__55621 = sablono.interpreter.interpret((function (){var G__55633 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"time","time",1385887882).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(a))], null);
var G__55634 = "Some text here";
return (dv.cljs_emotion.devcards.with_anim.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.devcards.with_anim.cljs$core$IFn$_invoke$arity$2(G__55633,G__55634) : dv.cljs_emotion.devcards.with_anim.call(null,G__55633,G__55634));
})());
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$6 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$6(G__55616,G__55617,G__55618,G__55619,G__55620,G__55621) : sablono.core.create_element.call(null,G__55616,G__55617,G__55618,G__55619,G__55620,G__55621));
});
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),devcards.core.markdown__GT_react.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Keyframe animations are supported - this is built into emotion. ",["\n```clojure\n","(def animation\n  (keyframes {:from {:background-color \"transparent\"}\n              :to   {:background-color \"grey\"}}))","\n```\n"].join(''),["\n```clojure\n","(defn animation-styles [{:keys [time]}]\n  {:animation (str animation \" \" time \"s ease-in-out infinite\")})","\n```\n"].join(''),["\n```clojure\n","(defstyled with-anim :div\n  animation-styles)","\n```\n"].join(''),["\n```clojure\n","(defn animation-card [a o]\n  (html\n    [:div\n     [:p \"animation time: \" (:time @a) \" seconds\"]\n     [:button {:on-click #(swap! a update :time inc)} \"inc\"]\n     [:button {:on-click #(swap! a update :time dec)} \"dec\"]\n     (with-anim {:time (:time @a)} \"Some text here\")]))","\n```\n"].join('')], 0)),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"hide-border","hide-border",1463657151),true], null))], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"keyframes","keyframes",-1437976012)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"keyframes",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),dv.cljs_emotion.devcards.animation_card,new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"time","time",1385887882),(1)], null),new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
var className55651_55838 = "dv.cljs-emotion.devcards/with-anim2";
var fullClassName55652_55839 = "dv.cljs-emotion.devcards/with-anim2";
var children55653_55840 = clojure.walk.postwalk((function (x__55237__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__55237__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__55237__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__55237__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__55237__auto__)){
return (function (arg__55238__auto__){
delete arg__55238__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__55660 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__55238__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__55237__auto__.cljs$core$IFn$_invoke$arity$1 ? x__55237__auto__.cljs$core$IFn$_invoke$arity$1(G__55660) : x__55237__auto__.call(null,G__55660));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__55237__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__55237__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__55237__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (p__55661){
var map__55662 = p__55661;
var map__55662__$1 = (((((!((map__55662 == null))))?(((((map__55662.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55662.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55662):map__55662);
var amt = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__55662__$1,new cljs.core.Keyword(null,"amt","amt",-1785711538),(20));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"animation","animation",-1248293244),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dv.cljs_emotion.keyframes(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),module$node_modules$polished$dist$polished_cjs.adjustHue(amt,"yellow")], null),new cljs.core.Keyword(null,"to","to",192099007),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"yellow"], null)], null)))," 2s ease-in-out infinite"].join('')], null);
})], null));
var children55653_55841__$1 = cljs.core.clj__GT_js(children55653_55840);
var component_type55649_55842 = goog.object.get(dv.cljs_emotion.styled,"div");
var clss55650_55843 = component_type55649_55842.apply(component_type55649_55842,children55653_55841__$1);
goog.object.set(clss55650_55843,"displayName","dv.cljs-emotion.devcards/with-anim2");

dv.cljs_emotion.devcards.with_anim2 = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss55650_55843,className55651_55838),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName55652_55839),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss55650_55843], null));

var x55664_55844 = dv.cljs_emotion.devcards.with_anim2;
(x55664_55844.toString = (function (){
var this__55245__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.with_anim2)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"keyframes2","keyframes2",-701299326)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"keyframes2",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Animation can be defined dynamically as well - in the render.\n\n  This example also shows how you can pass any props to the underlying component - in this case onClick.\n\n  ```clojure\n  (defstyled with-anim2 :div\n    (fn [{:keys [amt] :or {amt 20}}]\n      {:animation\n        (str (keyframes\n          {:from {:background (p/adjustHue amt \"yellow\")}\n           :to   {:background \"yellow\"}})\n            \" 2s ease-in-out infinite\")}))\n\n  (html\n  [:div\n    [:p \"hue: \" (p/adjustHue (:amt @a) \"yellow\")]\n    [:button {:on-click #(swap! a update :amt (partial + 10))} \"inc\"]\n    [:button {:on-click #(swap! a update :amt (partial - 10))} \"dec\"]\n    (with-anim2 {:amt     (:amt @a)\n                 :onClick #(js/console.log \"ON CLICK\")} \"Some text here\")])\n  ```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (a,o){
var G__55666 = "div";
var G__55667 = null;
var G__55668 = (function (){var G__55672 = "p";
var G__55673 = null;
var G__55674 = "hue: ";
var G__55675 = sablono.interpreter.interpret(module$node_modules$polished$dist$polished_cjs.adjustHue(new cljs.core.Keyword(null,"amt","amt",-1785711538).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(a)),"yellow"));
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$4 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$4(G__55672,G__55673,G__55674,G__55675) : sablono.core.create_element.call(null,G__55672,G__55673,G__55674,G__55675));
})();
var G__55669 = (function (){var G__55676 = "button";
var G__55677 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.update,new cljs.core.Keyword(null,"amt","amt",-1785711538),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,(10)));
})});
var G__55678 = "inc";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__55676,G__55677,G__55678) : sablono.core.create_element.call(null,G__55676,G__55677,G__55678));
})();
var G__55670 = (function (){var G__55679 = "button";
var G__55680 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.update,new cljs.core.Keyword(null,"amt","amt",-1785711538),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._,(10)));
})});
var G__55681 = "dec";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__55679,G__55680,G__55681) : sablono.core.create_element.call(null,G__55679,G__55680,G__55681));
})();
var G__55671 = sablono.interpreter.interpret((function (){var G__55682 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"amt","amt",-1785711538),new cljs.core.Keyword(null,"amt","amt",-1785711538).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(a)),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),(function (){
return console.log("ON CLICK");
})], null);
var G__55683 = "Some text here";
return (dv.cljs_emotion.devcards.with_anim2.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.devcards.with_anim2.cljs$core$IFn$_invoke$arity$2(G__55682,G__55683) : dv.cljs_emotion.devcards.with_anim2.call(null,G__55682,G__55683));
})());
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$6 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$6(G__55666,G__55667,G__55668,G__55669,G__55670,G__55671) : sablono.core.create_element.call(null,G__55666,G__55667,G__55668,G__55669,G__55670,G__55671));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"amt","amt",-1785711538),(20)], null),new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
var className55692_55845 = "dv.cljs-emotion.devcards/multi";
var fullClassName55693_55846 = "dv.cljs-emotion.devcards/multi";
var children55694_55847 = clojure.walk.postwalk((function (x__55237__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__55237__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__55237__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__55237__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__55237__auto__)){
return (function (arg__55238__auto__){
delete arg__55238__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__55695 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__55238__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__55237__auto__.cljs$core$IFn$_invoke$arity$1 ? x__55237__auto__.cljs$core$IFn$_invoke$arity$1(G__55695) : x__55237__auto__.call(null,G__55695));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__55237__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__55237__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__55237__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"blue"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"yellow"], null),({"borderRadius": (4)}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, ["border","1px solid grey"], null)], null),(function (_){
return new cljs.core.PersistentArrayMap(null, 1, [":hover",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"white"], null)], null);
})], null));
var children55694_55848__$1 = cljs.core.clj__GT_js(children55694_55847);
var component_type55690_55849 = goog.object.get(dv.cljs_emotion.styled,"div");
var clss55691_55850 = component_type55690_55849.apply(component_type55690_55849,children55694_55848__$1);
goog.object.set(clss55691_55850,"displayName","dv.cljs-emotion.devcards/multi");

dv.cljs_emotion.devcards.multi = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss55691_55850,className55692_55845),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName55693_55846),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss55691_55850], null));

var x55696_55851 = dv.cljs_emotion.devcards.multi;
(x55696_55851.toString = (function (){
var this__55245__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.multi)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Multiple children are handled just like emotion:\n```clojure\n(defstyled multi :div\n  {:background \"blue\"}\n  {:color \"yellow\"}\n  #js{\"borderRadius\" 4}\n  [{\"border\" \"1px solid grey\"}]\n  (fn [_] {\":hover\" {:background \"white\"}}))\n\n(multi \"HELLO\")\n```\n",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(dv.cljs_emotion.devcards.multi.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.multi.cljs$core$IFn$_invoke$arity$1("HELLO") : dv.cljs_emotion.devcards.multi.call(null,"HELLO")),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
var className55700_55852 = "dv.cljs-emotion.devcards/multi2";
var fullClassName55701_55853 = "dv.cljs-emotion.devcards/multi2";
var children55702_55854 = clojure.walk.postwalk((function (x__55237__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__55237__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__55237__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__55237__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__55237__auto__)){
return (function (arg__55238__auto__){
delete arg__55238__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__55703 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__55238__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__55237__auto__.cljs$core$IFn$_invoke$arity$1 ? x__55237__auto__.cljs$core$IFn$_invoke$arity$1(G__55703) : x__55237__auto__.call(null,G__55703));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__55237__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__55237__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__55237__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"blue"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"yellow"], null),({"borderRadius": (4)}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, ["border","1px solid grey"], null)], null),(function (_){
return new cljs.core.PersistentArrayMap(null, 1, [":hover",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"white"], null)], null);
})], null)], null));
var children55702_55855__$1 = cljs.core.clj__GT_js(children55702_55854);
var component_type55698_55856 = goog.object.get(dv.cljs_emotion.styled,"div");
var clss55699_55857 = component_type55698_55856.apply(component_type55698_55856,children55702_55855__$1);
goog.object.set(clss55699_55857,"displayName","dv.cljs-emotion.devcards/multi2");

dv.cljs_emotion.devcards.multi2 = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss55699_55857,className55700_55852),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName55701_55853),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss55699_55857], null));

var x55704_55858 = dv.cljs_emotion.devcards.multi2;
(x55704_55858.toString = (function (){
var this__55245__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.multi2)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Anywhere an array is passed emotion will merge those styles, so you can also\n  pass multiple styles as a vector/array:\n\n```clojure\n(defstyled multi2 :div\n  [{:background \"blue\"}\n  {:color \"yellow\"}\n  #js{\"borderRadius\" 4}\n  [{\"border\" \"1px solid grey\"}]\n  (fn [_] {\":hover\" {:background \"white\"}})])\n\n(multi2 \"HELLO\")\n```\n",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(dv.cljs_emotion.devcards.multi2.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.multi2.cljs$core$IFn$_invoke$arity$1("HELLO") : dv.cljs_emotion.devcards.multi2.call(null,"HELLO")),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
var className55713_55859 = "dv.cljs-emotion.devcards/a-fn";
var fullClassName55714_55860 = "dv.cljs-emotion.devcards/a-fn";
var children55715_55861 = clojure.walk.postwalk((function (x__55237__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__55237__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__55237__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__55237__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__55237__auto__)){
return (function (arg__55238__auto__){
delete arg__55238__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__55716 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__55238__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__55237__auto__.cljs$core$IFn$_invoke$arity$1 ? x__55237__auto__.cljs$core$IFn$_invoke$arity$1(G__55716) : x__55237__auto__.call(null,G__55716));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__55237__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__55237__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__55237__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (p__55717){
var map__55718 = p__55717;
var map__55718__$1 = (((((!((map__55718 == null))))?(((((map__55718.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55718.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55718):map__55718);
var my_padding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55718__$1,new cljs.core.Keyword(null,"my-padding","my-padding",1389925511));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"padding","padding",1660304693),my_padding], null);
})], null));
var children55715_55862__$1 = cljs.core.clj__GT_js(children55715_55861);
var component_type55711_55863 = goog.object.get(dv.cljs_emotion.styled,"button");
var clss55712_55864 = component_type55711_55863.apply(component_type55711_55863,children55715_55862__$1);
goog.object.set(clss55712_55864,"displayName","dv.cljs-emotion.devcards/a-fn");

dv.cljs_emotion.devcards.a_fn = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss55712_55864,className55713_55859),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName55714_55860),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss55712_55864], null));

var x55721_55865 = dv.cljs_emotion.devcards.a_fn;
(x55721_55865.toString = (function (){
var this__55245__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.a_fn)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Any props you pass to the component at render time are converted to cljs data\n  structures via `js->clj` and then passed to any functions in defstyled. The output of your\n  function is then passed to `clj->js` and on to emotion.\n```clojure\n(defstyled a-fn :button\n  (fn [{:keys [my-padding]}]\n    {:padding my-padding}))\n\n  (a-fn\n    {:my-padding 20 :onClick #(js/console.log \"clicked\")\n     :another-key 5} \"This is a button\")\n```\n  ",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var G__55722 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"my-padding","my-padding",1389925511),(20),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),(function (){
return console.log("clicked");
}),new cljs.core.Keyword(null,"another-key","another-key",1757915937),(5)], null);
var G__55723 = "This is a button";
return (dv.cljs_emotion.devcards.a_fn.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.devcards.a_fn.cljs$core$IFn$_invoke$arity$2(G__55722,G__55723) : dv.cljs_emotion.devcards.a_fn.call(null,G__55722,G__55723));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
var className55726_55866 = "dv.cljs-emotion.devcards/flex";
var fullClassName55727_55867 = "dv.cljs-emotion.devcards/flex";
var children55728_55868 = clojure.walk.postwalk((function (x__55237__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__55237__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__55237__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__55237__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__55237__auto__)){
return (function (arg__55238__auto__){
delete arg__55238__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__55729 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__55238__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__55237__auto__.cljs$core$IFn$_invoke$arity$1 ? x__55237__auto__.cljs$core$IFn$_invoke$arity$1(G__55729) : x__55237__auto__.call(null,G__55729));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__55237__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__55237__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__55237__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex-wrap","flex-wrap",455413707),"wrap",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"space-evenly"], null)], null));
var children55728_55869__$1 = cljs.core.clj__GT_js(children55728_55868);
var component_type55724_55870 = goog.object.get(dv.cljs_emotion.styled,"div");
var clss55725_55871 = component_type55724_55870.apply(component_type55724_55870,children55728_55869__$1);
goog.object.set(clss55725_55871,"displayName","dv.cljs-emotion.devcards/flex");

dv.cljs_emotion.devcards.flex = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss55725_55871,className55726_55866),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName55727_55867),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss55725_55871], null));

var x55730_55872 = dv.cljs_emotion.devcards.flex;
(x55730_55872.toString = (function (){
var this__55245__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.flex)))].join('');
}));

var className55733_55873 = "dv.cljs-emotion.devcards/box";
var fullClassName55734_55874 = "dv.cljs-emotion.devcards/box";
var children55735_55875 = clojure.walk.postwalk((function (x__55237__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__55237__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__55237__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__55237__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__55237__auto__)){
return (function (arg__55238__auto__){
delete arg__55238__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__55736 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__55238__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__55237__auto__.cljs$core$IFn$_invoke$arity$1 ? x__55237__auto__.cljs$core$IFn$_invoke$arity$1(G__55736) : x__55237__auto__.call(null,G__55736));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__55237__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__55237__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__55237__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"width","width",-384071477),"20%",new cljs.core.Keyword(null,"padding","padding",1660304693),"1rem 0",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"margin","margin",-995903681),"1rem",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center",new cljs.core.Keyword(null,"background","background",-863952629),"palEvIoletrEd"], null)], null));
var children55735_55876__$1 = cljs.core.clj__GT_js(children55735_55875);
var component_type55731_55877 = goog.object.get(dv.cljs_emotion.styled,"div");
var clss55732_55878 = component_type55731_55877.apply(component_type55731_55877,children55735_55876__$1);
goog.object.set(clss55732_55878,"displayName","dv.cljs-emotion.devcards/box");

dv.cljs_emotion.devcards.box = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss55732_55878,className55733_55873),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName55734_55874),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss55732_55878], null));

var x55737_55879 = dv.cljs_emotion.devcards.box;
(x55737_55879.toString = (function (){
var this__55245__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.box)))].join('');
}));

var className55740_55880 = "dv.cljs-emotion.devcards/box2";
var fullClassName55741_55881 = "dv.cljs-emotion.devcards/box2";
var children55742_55882 = clojure.walk.postwalk((function (x__55237__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__55237__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__55237__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__55237__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__55237__auto__)){
return (function (arg__55238__auto__){
delete arg__55238__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__55743 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__55238__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__55237__auto__.cljs$core$IFn$_invoke$arity$1 ? x__55237__auto__.cljs$core$IFn$_invoke$arity$1(G__55743) : x__55237__auto__.call(null,G__55743));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__55237__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__55237__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__55237__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"user-select","user-select",-346451650),"none",new cljs.core.Keyword(null,"background","background",-863952629),module$node_modules$polished$dist$polished_cjs.lighten(0.2,"palevioletred"),new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",":hover",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),module$node_modules$polished$dist$polished_cjs.darken(0.2,"palevioletred")], null),":active",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"background","background",-863952629),module$node_modules$polished$dist$polished_cjs.darken(0.4,"palevioletred"),new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"4px 4px lightgrey"], null)], null)], null));
var children55742_55883__$1 = cljs.core.clj__GT_js(children55742_55882);
var component_type55738_55884 = ((typeof dv.cljs_emotion.devcards.box === 'string')?goog.object.get(dv.cljs_emotion.styled,dv.cljs_emotion.devcards.box):(((dv.cljs_emotion.devcards.box instanceof cljs.core.Keyword))?goog.object.get(dv.cljs_emotion.styled,"box"):(cljs.core.truth_(new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.box)))?dv.cljs_emotion.styled.call(dv.cljs_emotion.styled,new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.box))):dv.cljs_emotion.styled.call(dv.cljs_emotion.styled,dv.cljs_emotion.devcards.box)
)));
var clss55739_55885 = component_type55738_55884.apply(component_type55738_55884,children55742_55883__$1);
goog.object.set(clss55739_55885,"displayName","dv.cljs-emotion.devcards/box2");

dv.cljs_emotion.devcards.box2 = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss55739_55885,className55740_55880),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName55741_55881),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss55739_55885], null));

var x55744_55886 = dv.cljs_emotion.devcards.box2;
(x55744_55886.toString = (function (){
var this__55245__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.box2)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"flex-card","flex-card",-1954027863)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"flex-card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Here is a somewhat larger example, showing the extension feature of emotion to override styles.\n\n  This example using the polished library as well.\n\n```clojure\n(defstyled flex :div\n  {:display         \"flex\"\n   :flex-wrap       \"wrap\"\n   :justify-content \"space-evenly\"})\n\n(defstyled box :div\n  {:width           \"20%\"\n   :padding         \"1rem 0\"\n   :display         \"flex\"\n   :margin          \"1rem\"\n   :justify-content \"center\"\n   :background      \"palEvIoletrEd\"})\n\n\n(defstyled box2 box\n  {:border-radius \"4px\"\n   :user-select   \"none\"\n   :background    (p/lighten 0.2 \"palevioletred\")\n   :cursor        \"pointer\"\n   \":hover\"       {:background (darken 0.2 \"palevioletred\")}\n   \":active\"      {:background (darken 0.4 \"palevioletred\")\n                   :box-shadow \"4px 4px lightgrey\"}})\n\n(flex (box \"box\") (box \"box\") (box \"box\") (box2 \"box2\") (box2 \"box2\") (box \"box\") (box \"box\") (box2 \"box2\") (box \"box\")))\n```\n",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var G__55745 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__55746 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__55747 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__55748 = (dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1("box2") : dv.cljs_emotion.devcards.box2.call(null,"box2"));
var G__55749 = (dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1("box2") : dv.cljs_emotion.devcards.box2.call(null,"box2"));
var G__55750 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__55751 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__55752 = (dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1("box2") : dv.cljs_emotion.devcards.box2.call(null,"box2"));
var G__55753 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
return (dv.cljs_emotion.devcards.flex.cljs$core$IFn$_invoke$arity$9 ? dv.cljs_emotion.devcards.flex.cljs$core$IFn$_invoke$arity$9(G__55745,G__55746,G__55747,G__55748,G__55749,G__55750,G__55751,G__55752,G__55753) : dv.cljs_emotion.devcards.flex.call(null,G__55745,G__55746,G__55747,G__55748,G__55749,G__55750,G__55751,G__55752,G__55753));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"update-global-styles","update-global-styles",1487171421)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"update-global-styles",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"\n  This example changes the body background of this page's body color.\n  ```clojure\n  [:div\n         [:label \"Input a color for the background color:\"]\n         [:input {:value bg :on-change #(swap! a assoc :bg (-> % .-target .-value))}]\n         (global-style {:body {:background bg}})]\n   ```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (a,_){
var map__55755 = cljs.core.deref(a);
var map__55755__$1 = (((((!((map__55755 == null))))?(((((map__55755.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55755.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55755):map__55755);
var bg = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55755__$1,new cljs.core.Keyword(null,"bg","bg",-206688421));
var G__55759 = "div";
var G__55760 = null;
var G__55761 = (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3("label",null,"Input a color for the background color:") : sablono.core.create_element.call(null,"label",null,"Input a color for the background color:"));
var G__55762 = sablono.interpreter.create_element("input",({"value": bg, "onChange": (function (p1__55754_SHARP_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),p1__55754_SHARP_.target.value);
})}));
var G__55763 = sablono.interpreter.interpret(dv.cljs_emotion.global_style(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),bg], null)], null)));
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$5 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$5(G__55759,G__55760,G__55761,G__55762,G__55763) : sablono.core.create_element.call(null,G__55759,G__55760,G__55761,G__55762,G__55763));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bg","bg",-206688421),"#cce"], null),new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
dv.cljs_emotion.devcards.start_bg = "#eeaabb";
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"update-card-bg-styles","update-card-bg-styles",-771594595)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"update-card-bg-styles",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"\n  This example changes the background color of this card.\n  ```clojure\n  (let [{:keys [bg]} @a\n          cls :.my-card]\n      (html\n        [:div\n         [:label \"Input a color for the background:\"]\n         [:input {:value bg :on-change #(swap! a assoc :bg (-> % .-target .-value))}]\n         [:button {:on-click #(swap! a assoc :bg start-bg)} \"reset\"]\n         [:button\n          {:on-click\n           #(swap! a assoc :bg (p/lighten 0.08 bg))} \"lighten\"]\n\n         [:button\n          {:on-click\n           #(swap! a assoc :bg (p/darken 0.08 bg))} \"darken\"]\n         (global-style {cls {:background bg}})]))\n   ```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (a,_){
var map__55765 = cljs.core.deref(a);
var map__55765__$1 = (((((!((map__55765 == null))))?(((((map__55765.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55765.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55765):map__55765);
var bg = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55765__$1,new cljs.core.Keyword(null,"bg","bg",-206688421));
var cls = new cljs.core.Keyword(null,".my-card",".my-card",1656982961);
var G__55769 = "div";
var G__55770 = null;
var G__55771 = (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3("label",null,"Input a color for the background:") : sablono.core.create_element.call(null,"label",null,"Input a color for the background:"));
var G__55772 = sablono.interpreter.create_element("input",({"value": bg, "onChange": (function (p1__55764_SHARP_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),p1__55764_SHARP_.target.value);
})}));
var G__55773 = (function (){var G__55777 = "button";
var G__55778 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),dv.cljs_emotion.devcards.start_bg);
})});
var G__55779 = "reset";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__55777,G__55778,G__55779) : sablono.core.create_element.call(null,G__55777,G__55778,G__55779));
})();
var G__55774 = (function (){var G__55780 = "button";
var G__55781 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),module$node_modules$polished$dist$polished_cjs.lighten(0.08,bg));
})});
var G__55782 = "lighten";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__55780,G__55781,G__55782) : sablono.core.create_element.call(null,G__55780,G__55781,G__55782));
})();
var G__55775 = (function (){var G__55783 = "button";
var G__55784 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),module$node_modules$polished$dist$polished_cjs.darken(0.08,bg));
})});
var G__55785 = "darken";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__55783,G__55784,G__55785) : sablono.core.create_element.call(null,G__55783,G__55784,G__55785));
})();
var G__55776 = sablono.interpreter.interpret(dv.cljs_emotion.global_style(cljs.core.PersistentArrayMap.createAsIfByAssoc([cls,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),bg], null)])));
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$8 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$8(G__55769,G__55770,G__55771,G__55772,G__55773,G__55774,G__55775,G__55776) : sablono.core.create_element.call(null,G__55769,G__55770,G__55771,G__55772,G__55773,G__55774,G__55775,G__55776));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bg","bg",-206688421),dv.cljs_emotion.devcards.start_bg], null),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"classname","classname",777390796),"my-card"], null)], null));
})], null));
var className55788_55887 = "dv.cljs-emotion.devcards/test-theme";
var fullClassName55789_55888 = "dv.cljs-emotion.devcards/test-theme";
var children55790_55889 = clojure.walk.postwalk((function (x__55237__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__55237__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__55237__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__55237__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__55237__auto__)){
return (function (arg__55238__auto__){
delete arg__55238__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__55791 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__55238__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__55237__auto__.cljs$core$IFn$_invoke$arity$1 ? x__55237__auto__.cljs$core$IFn$_invoke$arity$1(G__55791) : x__55237__auto__.call(null,G__55791));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__55237__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__55237__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__55237__auto__;

}
}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (p__55792){
var map__55793 = p__55792;
var map__55793__$1 = (((((!((map__55793 == null))))?(((((map__55793.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55793.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55793):map__55793);
var theme = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55793__$1,new cljs.core.Keyword(null,"theme","theme",-1247880880));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"bg","bg",-206688421).cljs$core$IFn$_invoke$arity$1(theme);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "blue";
}
})()], null);
})], null));
var children55790_55890__$1 = cljs.core.clj__GT_js(children55790_55889);
var component_type55786_55891 = goog.object.get(dv.cljs_emotion.styled,"div");
var clss55787_55892 = component_type55786_55891.apply(component_type55786_55891,children55790_55890__$1);
goog.object.set(clss55787_55892,"displayName","dv.cljs-emotion.devcards/test-theme");

dv.cljs_emotion.devcards.test_theme = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss55787_55892,className55788_55887),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName55789_55888),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss55787_55892], null));

var x55795_55893 = dv.cljs_emotion.devcards.test_theme;
(x55795_55893.toString = (function (){
var this__55245__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.test_theme)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"theme-provider-card","theme-provider-card",-1686140511)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"theme-provider-card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Theme use is straight forward.\n\n  It wraps emotion's ThemeProvider calling clj->js first on the props.\n  Wrap your application with `theme-provider` passing it\n  a map or JS object of theme data.\n```clojure\n(defstyled test-theme :div\n  (fn [{:keys [theme]}]\n    {:background (or (:bg theme) \"blue\")}))\n\n(html\n  [:div\n   (theme-provider {:theme {:bg \"yellow\"}} (test-theme \"Hello there theme\"))\n   (test-theme \"no theme\")])\n```\n",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var attrs55796 = dv.cljs_emotion.theme_provider.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"theme","theme",-1247880880),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bg","bg",-206688421),"yellow"], null)], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1("Hello there theme") : dv.cljs_emotion.devcards.test_theme.call(null,"Hello there theme"))], 0));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(sablono.core.create_element,"div",((cljs.core.map_QMARK_(attrs55796))?sablono.interpreter.attributes(attrs55796):null),((cljs.core.map_QMARK_(attrs55796))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret((dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1("no theme") : dv.cljs_emotion.devcards.test_theme.call(null,"no theme")))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs55796),sablono.interpreter.interpret((dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1("no theme") : dv.cljs_emotion.devcards.test_theme.call(null,"no theme")))], null)));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
dv.cljs_emotion.devcards.anon_styles = (function dv$cljs_emotion$devcards$anon_styles(){
var G__55797 = "div";
var G__55798 = (function (){
if(cljs.core.contains_QMARK_(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"lightgrey"], null)], null),new cljs.core.Keyword(null,"css","css",1135045163))){
} else {
throw (new Error(["Assert failed: ","Props must contain :css key","\n","(clojure.core/contains? {:css {:background \"lightgrey\"}} :css)"].join('')));
}

return cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"lightgrey"], null)], null),new cljs.core.Keyword(null,"css","css",1135045163),clojure.walk.postwalk((function (x__55237__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__55237__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__55237__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__55237__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__55237__auto__)){
return (function (arg__55238__auto__){
delete arg__55238__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__55800 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__55238__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__55237__auto__.cljs$core$IFn$_invoke$arity$1 ? x__55237__auto__.cljs$core$IFn$_invoke$arity$1(G__55800) : x__55237__auto__.call(null,G__55800));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__55237__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__55237__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__55237__auto__;

}
}
}
}),new cljs.core.Keyword(null,"css","css",1135045163).cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"lightgrey"], null)], null)))));
})()
;
var G__55799 = "Some text on a lightgrey background.";
return (dv.cljs_emotion.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.cljs_emotion.jsx.cljs$core$IFn$_invoke$arity$3(G__55797,G__55798,G__55799) : dv.cljs_emotion.jsx.call(null,G__55797,G__55798,G__55799));
});
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),devcards.core.markdown__GT_react.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["# Anonymous inline styles support.\n   You can use the `css` helper to style a react element inline without needing to create a component.",["\n```clojure\n","(defn anon-styles []\n  (css :div {:css {:background \"lightgrey\"}}\n    \"Some text on a lightgrey background.\"))","\n```\n"].join('')], 0)),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"hide-border","hide-border",1463657151),true], null))], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),dv.cljs_emotion.devcards.anon_styles(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
dv.cljs_emotion.devcards.anon_styles2 = (function dv$cljs_emotion$devcards$anon_styles2(){
var G__55801 = "div";
var G__55802 = (function (){
if(cljs.core.contains_QMARK_(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"lightgrey"], null)], null),new cljs.core.Keyword(null,"css","css",1135045163))){
} else {
throw (new Error(["Assert failed: ","Props must contain :css key","\n","(clojure.core/contains? {:css {:background \"lightgrey\"}} :css)"].join('')));
}

return cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"lightgrey"], null)], null),new cljs.core.Keyword(null,"css","css",1135045163),clojure.walk.postwalk((function (x__55237__auto__){
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(x__55237__auto__);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x__55237__auto__),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x__55237__auto__)))].join('');
} else {
if(cljs.core.fn_QMARK_(x__55237__auto__)){
return (function (arg__55238__auto__){
delete arg__55238__auto__["children"];

return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__55804 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__55238__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__55237__auto__.cljs$core$IFn$_invoke$arity$1 ? x__55237__auto__.cljs$core$IFn$_invoke$arity$1(G__55804) : x__55237__auto__.call(null,G__55804));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__55237__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__55237__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__55237__auto__;

}
}
}
}),new cljs.core.Keyword(null,"css","css",1135045163).cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"lightgrey"], null)], null)))));
})()
;
var G__55803 = (function (){var G__55807 = "div";
var G__55808 = null;
var G__55809 = (function (){var G__55812 = "div";
var G__55813 = null;
var G__55814 = (function (){var G__55815 = "div";
var G__55816 = ({"key": (1)});
var G__55817 = "Hello";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__55815,G__55816,G__55817) : sablono.core.create_element.call(null,G__55815,G__55816,G__55817));
})();
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__55812,G__55813,G__55814) : sablono.core.create_element.call(null,G__55812,G__55813,G__55814));
})();
var G__55810 = (function (){var G__55818 = "div";
var G__55819 = ({"key": (2)});
var G__55820 = "Hello2";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__55818,G__55819,G__55820) : sablono.core.create_element.call(null,G__55818,G__55819,G__55820));
})();
var G__55811 = (function (){var G__55821 = "div";
var G__55822 = ({"key": (3)});
var G__55823 = "Hello3";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__55821,G__55822,G__55823) : sablono.core.create_element.call(null,G__55821,G__55822,G__55823));
})();
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$5 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$5(G__55807,G__55808,G__55809,G__55810,G__55811) : sablono.core.create_element.call(null,G__55807,G__55808,G__55809,G__55810,G__55811));
})();
return (dv.cljs_emotion.jsx.cljs$core$IFn$_invoke$arity$3 ? dv.cljs_emotion.jsx.cljs$core$IFn$_invoke$arity$3(G__55801,G__55802,G__55803) : dv.cljs_emotion.jsx.call(null,G__55801,G__55802,G__55803));
});
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),devcards.core.markdown__GT_react.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Multiple children are wrapped in a react fragment.",["\n```clojure\n","(defn anon-styles2 []\n  (css :div {:css {:background \"lightgrey\"}}\n    (html\n      [:div\n       [:div [:div {:key 1} \"Hello\"]]\n       [:div {:key 2} \"Hello2\"]\n       [:div {:key 3} \"Hello3\"]])))","\n```\n"].join('')], 0)),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"hide-border","hide-border",1463657151),true], null))], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),dv.cljs_emotion.devcards.anon_styles2(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
dv.cljs_emotion.devcards.main = (function dv$cljs_emotion$devcards$main(){
return devcards.core.start_devcard_ui_BANG__STAR_.cljs$core$IFn$_invoke$arity$0();
});
goog.exportSymbol('dv.cljs_emotion.devcards.main', dv.cljs_emotion.devcards.main);

//# sourceMappingURL=dv.cljs_emotion.devcards.js.map
