goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_49555 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_49555(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_49557 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_49557(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__48592 = coll;
var G__48593 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__48592,G__48593) : shadow.dom.lazy_native_coll_seq.call(null,G__48592,G__48593));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__48626 = arguments.length;
switch (G__48626) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__48633 = arguments.length;
switch (G__48633) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__48647 = arguments.length;
switch (G__48647) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__48657 = arguments.length;
switch (G__48657) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__48668 = arguments.length;
switch (G__48668) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__48688 = arguments.length;
switch (G__48688) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e48698){if((e48698 instanceof Object)){
var e = e48698;
return console.log("didnt support attachEvent",el,e);
} else {
throw e48698;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__48711 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__48712 = null;
var count__48713 = (0);
var i__48714 = (0);
while(true){
if((i__48714 < count__48713)){
var el = chunk__48712.cljs$core$IIndexed$_nth$arity$2(null,i__48714);
var handler_49627__$1 = ((function (seq__48711,chunk__48712,count__48713,i__48714,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__48711,chunk__48712,count__48713,i__48714,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_49627__$1);


var G__49638 = seq__48711;
var G__49639 = chunk__48712;
var G__49640 = count__48713;
var G__49642 = (i__48714 + (1));
seq__48711 = G__49638;
chunk__48712 = G__49639;
count__48713 = G__49640;
i__48714 = G__49642;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__48711);
if(temp__5735__auto__){
var seq__48711__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48711__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__48711__$1);
var G__49647 = cljs.core.chunk_rest(seq__48711__$1);
var G__49648 = c__4556__auto__;
var G__49649 = cljs.core.count(c__4556__auto__);
var G__49650 = (0);
seq__48711 = G__49647;
chunk__48712 = G__49648;
count__48713 = G__49649;
i__48714 = G__49650;
continue;
} else {
var el = cljs.core.first(seq__48711__$1);
var handler_49656__$1 = ((function (seq__48711,chunk__48712,count__48713,i__48714,el,seq__48711__$1,temp__5735__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__48711,chunk__48712,count__48713,i__48714,el,seq__48711__$1,temp__5735__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_49656__$1);


var G__49661 = cljs.core.next(seq__48711__$1);
var G__49662 = null;
var G__49663 = (0);
var G__49664 = (0);
seq__48711 = G__49661;
chunk__48712 = G__49662;
count__48713 = G__49663;
i__48714 = G__49664;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__48736 = arguments.length;
switch (G__48736) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__48759 = cljs.core.seq(events);
var chunk__48760 = null;
var count__48761 = (0);
var i__48762 = (0);
while(true){
if((i__48762 < count__48761)){
var vec__48777 = chunk__48760.cljs$core$IIndexed$_nth$arity$2(null,i__48762);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48777,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48777,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__49679 = seq__48759;
var G__49680 = chunk__48760;
var G__49681 = count__48761;
var G__49682 = (i__48762 + (1));
seq__48759 = G__49679;
chunk__48760 = G__49680;
count__48761 = G__49681;
i__48762 = G__49682;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__48759);
if(temp__5735__auto__){
var seq__48759__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48759__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__48759__$1);
var G__49684 = cljs.core.chunk_rest(seq__48759__$1);
var G__49685 = c__4556__auto__;
var G__49686 = cljs.core.count(c__4556__auto__);
var G__49687 = (0);
seq__48759 = G__49684;
chunk__48760 = G__49685;
count__48761 = G__49686;
i__48762 = G__49687;
continue;
} else {
var vec__48781 = cljs.core.first(seq__48759__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48781,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48781,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__49690 = cljs.core.next(seq__48759__$1);
var G__49691 = null;
var G__49692 = (0);
var G__49693 = (0);
seq__48759 = G__49690;
chunk__48760 = G__49691;
count__48761 = G__49692;
i__48762 = G__49693;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__48793 = cljs.core.seq(styles);
var chunk__48794 = null;
var count__48795 = (0);
var i__48796 = (0);
while(true){
if((i__48796 < count__48795)){
var vec__48810 = chunk__48794.cljs$core$IIndexed$_nth$arity$2(null,i__48796);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48810,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48810,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__49703 = seq__48793;
var G__49704 = chunk__48794;
var G__49705 = count__48795;
var G__49706 = (i__48796 + (1));
seq__48793 = G__49703;
chunk__48794 = G__49704;
count__48795 = G__49705;
i__48796 = G__49706;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__48793);
if(temp__5735__auto__){
var seq__48793__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48793__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__48793__$1);
var G__49714 = cljs.core.chunk_rest(seq__48793__$1);
var G__49715 = c__4556__auto__;
var G__49716 = cljs.core.count(c__4556__auto__);
var G__49717 = (0);
seq__48793 = G__49714;
chunk__48794 = G__49715;
count__48795 = G__49716;
i__48796 = G__49717;
continue;
} else {
var vec__48816 = cljs.core.first(seq__48793__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48816,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48816,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__49723 = cljs.core.next(seq__48793__$1);
var G__49724 = null;
var G__49725 = (0);
var G__49726 = (0);
seq__48793 = G__49723;
chunk__48794 = G__49724;
count__48795 = G__49725;
i__48796 = G__49726;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__48824_49728 = key;
var G__48824_49729__$1 = (((G__48824_49728 instanceof cljs.core.Keyword))?G__48824_49728.fqn:null);
switch (G__48824_49729__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_49751 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_49751,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_49751,"aria-");
}
})())){
el.setAttribute(ks_49751,value);
} else {
(el[ks_49751] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__48838){
var map__48839 = p__48838;
var map__48839__$1 = (((((!((map__48839 == null))))?(((((map__48839.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48839.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__48839):map__48839);
var props = map__48839__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48839__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__48841 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48841,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48841,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48841,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__48844 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__48844,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__48844;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__48847 = arguments.length;
switch (G__48847) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__48849){
var vec__48851 = p__48849;
var seq__48852 = cljs.core.seq(vec__48851);
var first__48853 = cljs.core.first(seq__48852);
var seq__48852__$1 = cljs.core.next(seq__48852);
var nn = first__48853;
var first__48853__$1 = cljs.core.first(seq__48852__$1);
var seq__48852__$2 = cljs.core.next(seq__48852__$1);
var np = first__48853__$1;
var nc = seq__48852__$2;
var node = vec__48851;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__48855 = nn;
var G__48856 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__48855,G__48856) : create_fn.call(null,G__48855,G__48856));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__48857 = nn;
var G__48858 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__48857,G__48858) : create_fn.call(null,G__48857,G__48858));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__48859 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48859,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48859,(1),null);
var seq__48862_49805 = cljs.core.seq(node_children);
var chunk__48863_49806 = null;
var count__48864_49807 = (0);
var i__48865_49808 = (0);
while(true){
if((i__48865_49808 < count__48864_49807)){
var child_struct_49811 = chunk__48863_49806.cljs$core$IIndexed$_nth$arity$2(null,i__48865_49808);
var children_49812 = shadow.dom.dom_node(child_struct_49811);
if(cljs.core.seq_QMARK_(children_49812)){
var seq__48910_49813 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_49812));
var chunk__48912_49814 = null;
var count__48913_49815 = (0);
var i__48914_49816 = (0);
while(true){
if((i__48914_49816 < count__48913_49815)){
var child_49817 = chunk__48912_49814.cljs$core$IIndexed$_nth$arity$2(null,i__48914_49816);
if(cljs.core.truth_(child_49817)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49817);


var G__49818 = seq__48910_49813;
var G__49819 = chunk__48912_49814;
var G__49820 = count__48913_49815;
var G__49821 = (i__48914_49816 + (1));
seq__48910_49813 = G__49818;
chunk__48912_49814 = G__49819;
count__48913_49815 = G__49820;
i__48914_49816 = G__49821;
continue;
} else {
var G__49826 = seq__48910_49813;
var G__49827 = chunk__48912_49814;
var G__49828 = count__48913_49815;
var G__49829 = (i__48914_49816 + (1));
seq__48910_49813 = G__49826;
chunk__48912_49814 = G__49827;
count__48913_49815 = G__49828;
i__48914_49816 = G__49829;
continue;
}
} else {
var temp__5735__auto___49830 = cljs.core.seq(seq__48910_49813);
if(temp__5735__auto___49830){
var seq__48910_49831__$1 = temp__5735__auto___49830;
if(cljs.core.chunked_seq_QMARK_(seq__48910_49831__$1)){
var c__4556__auto___49833 = cljs.core.chunk_first(seq__48910_49831__$1);
var G__49834 = cljs.core.chunk_rest(seq__48910_49831__$1);
var G__49835 = c__4556__auto___49833;
var G__49836 = cljs.core.count(c__4556__auto___49833);
var G__49837 = (0);
seq__48910_49813 = G__49834;
chunk__48912_49814 = G__49835;
count__48913_49815 = G__49836;
i__48914_49816 = G__49837;
continue;
} else {
var child_49838 = cljs.core.first(seq__48910_49831__$1);
if(cljs.core.truth_(child_49838)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49838);


var G__49840 = cljs.core.next(seq__48910_49831__$1);
var G__49841 = null;
var G__49842 = (0);
var G__49843 = (0);
seq__48910_49813 = G__49840;
chunk__48912_49814 = G__49841;
count__48913_49815 = G__49842;
i__48914_49816 = G__49843;
continue;
} else {
var G__49844 = cljs.core.next(seq__48910_49831__$1);
var G__49845 = null;
var G__49846 = (0);
var G__49847 = (0);
seq__48910_49813 = G__49844;
chunk__48912_49814 = G__49845;
count__48913_49815 = G__49846;
i__48914_49816 = G__49847;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_49812);
}


var G__49849 = seq__48862_49805;
var G__49850 = chunk__48863_49806;
var G__49851 = count__48864_49807;
var G__49852 = (i__48865_49808 + (1));
seq__48862_49805 = G__49849;
chunk__48863_49806 = G__49850;
count__48864_49807 = G__49851;
i__48865_49808 = G__49852;
continue;
} else {
var temp__5735__auto___49853 = cljs.core.seq(seq__48862_49805);
if(temp__5735__auto___49853){
var seq__48862_49854__$1 = temp__5735__auto___49853;
if(cljs.core.chunked_seq_QMARK_(seq__48862_49854__$1)){
var c__4556__auto___49856 = cljs.core.chunk_first(seq__48862_49854__$1);
var G__49857 = cljs.core.chunk_rest(seq__48862_49854__$1);
var G__49858 = c__4556__auto___49856;
var G__49859 = cljs.core.count(c__4556__auto___49856);
var G__49860 = (0);
seq__48862_49805 = G__49857;
chunk__48863_49806 = G__49858;
count__48864_49807 = G__49859;
i__48865_49808 = G__49860;
continue;
} else {
var child_struct_49861 = cljs.core.first(seq__48862_49854__$1);
var children_49863 = shadow.dom.dom_node(child_struct_49861);
if(cljs.core.seq_QMARK_(children_49863)){
var seq__48926_49864 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_49863));
var chunk__48928_49865 = null;
var count__48929_49866 = (0);
var i__48930_49867 = (0);
while(true){
if((i__48930_49867 < count__48929_49866)){
var child_49870 = chunk__48928_49865.cljs$core$IIndexed$_nth$arity$2(null,i__48930_49867);
if(cljs.core.truth_(child_49870)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49870);


var G__49873 = seq__48926_49864;
var G__49874 = chunk__48928_49865;
var G__49875 = count__48929_49866;
var G__49876 = (i__48930_49867 + (1));
seq__48926_49864 = G__49873;
chunk__48928_49865 = G__49874;
count__48929_49866 = G__49875;
i__48930_49867 = G__49876;
continue;
} else {
var G__49880 = seq__48926_49864;
var G__49881 = chunk__48928_49865;
var G__49882 = count__48929_49866;
var G__49883 = (i__48930_49867 + (1));
seq__48926_49864 = G__49880;
chunk__48928_49865 = G__49881;
count__48929_49866 = G__49882;
i__48930_49867 = G__49883;
continue;
}
} else {
var temp__5735__auto___49887__$1 = cljs.core.seq(seq__48926_49864);
if(temp__5735__auto___49887__$1){
var seq__48926_49888__$1 = temp__5735__auto___49887__$1;
if(cljs.core.chunked_seq_QMARK_(seq__48926_49888__$1)){
var c__4556__auto___49889 = cljs.core.chunk_first(seq__48926_49888__$1);
var G__49892 = cljs.core.chunk_rest(seq__48926_49888__$1);
var G__49893 = c__4556__auto___49889;
var G__49894 = cljs.core.count(c__4556__auto___49889);
var G__49895 = (0);
seq__48926_49864 = G__49892;
chunk__48928_49865 = G__49893;
count__48929_49866 = G__49894;
i__48930_49867 = G__49895;
continue;
} else {
var child_49898 = cljs.core.first(seq__48926_49888__$1);
if(cljs.core.truth_(child_49898)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49898);


var G__49901 = cljs.core.next(seq__48926_49888__$1);
var G__49902 = null;
var G__49903 = (0);
var G__49904 = (0);
seq__48926_49864 = G__49901;
chunk__48928_49865 = G__49902;
count__48929_49866 = G__49903;
i__48930_49867 = G__49904;
continue;
} else {
var G__49910 = cljs.core.next(seq__48926_49888__$1);
var G__49911 = null;
var G__49912 = (0);
var G__49913 = (0);
seq__48926_49864 = G__49910;
chunk__48928_49865 = G__49911;
count__48929_49866 = G__49912;
i__48930_49867 = G__49913;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_49863);
}


var G__49916 = cljs.core.next(seq__48862_49854__$1);
var G__49917 = null;
var G__49918 = (0);
var G__49919 = (0);
seq__48862_49805 = G__49916;
chunk__48863_49806 = G__49917;
count__48864_49807 = G__49918;
i__48865_49808 = G__49919;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__48952 = cljs.core.seq(node);
var chunk__48953 = null;
var count__48954 = (0);
var i__48955 = (0);
while(true){
if((i__48955 < count__48954)){
var n = chunk__48953.cljs$core$IIndexed$_nth$arity$2(null,i__48955);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__49949 = seq__48952;
var G__49950 = chunk__48953;
var G__49951 = count__48954;
var G__49952 = (i__48955 + (1));
seq__48952 = G__49949;
chunk__48953 = G__49950;
count__48954 = G__49951;
i__48955 = G__49952;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__48952);
if(temp__5735__auto__){
var seq__48952__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48952__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__48952__$1);
var G__49954 = cljs.core.chunk_rest(seq__48952__$1);
var G__49955 = c__4556__auto__;
var G__49956 = cljs.core.count(c__4556__auto__);
var G__49957 = (0);
seq__48952 = G__49954;
chunk__48953 = G__49955;
count__48954 = G__49956;
i__48955 = G__49957;
continue;
} else {
var n = cljs.core.first(seq__48952__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__49962 = cljs.core.next(seq__48952__$1);
var G__49963 = null;
var G__49964 = (0);
var G__49965 = (0);
seq__48952 = G__49962;
chunk__48953 = G__49963;
count__48954 = G__49964;
i__48955 = G__49965;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__48975 = arguments.length;
switch (G__48975) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__48983 = arguments.length;
switch (G__48983) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__49012 = arguments.length;
switch (G__49012) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___50041 = arguments.length;
var i__4737__auto___50042 = (0);
while(true){
if((i__4737__auto___50042 < len__4736__auto___50041)){
args__4742__auto__.push((arguments[i__4737__auto___50042]));

var G__50046 = (i__4737__auto___50042 + (1));
i__4737__auto___50042 = G__50046;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__49056_50065 = cljs.core.seq(nodes);
var chunk__49057_50066 = null;
var count__49058_50067 = (0);
var i__49059_50068 = (0);
while(true){
if((i__49059_50068 < count__49058_50067)){
var node_50071 = chunk__49057_50066.cljs$core$IIndexed$_nth$arity$2(null,i__49059_50068);
fragment.appendChild(shadow.dom._to_dom(node_50071));


var G__50076 = seq__49056_50065;
var G__50077 = chunk__49057_50066;
var G__50078 = count__49058_50067;
var G__50079 = (i__49059_50068 + (1));
seq__49056_50065 = G__50076;
chunk__49057_50066 = G__50077;
count__49058_50067 = G__50078;
i__49059_50068 = G__50079;
continue;
} else {
var temp__5735__auto___50080 = cljs.core.seq(seq__49056_50065);
if(temp__5735__auto___50080){
var seq__49056_50082__$1 = temp__5735__auto___50080;
if(cljs.core.chunked_seq_QMARK_(seq__49056_50082__$1)){
var c__4556__auto___50087 = cljs.core.chunk_first(seq__49056_50082__$1);
var G__50091 = cljs.core.chunk_rest(seq__49056_50082__$1);
var G__50092 = c__4556__auto___50087;
var G__50093 = cljs.core.count(c__4556__auto___50087);
var G__50094 = (0);
seq__49056_50065 = G__50091;
chunk__49057_50066 = G__50092;
count__49058_50067 = G__50093;
i__49059_50068 = G__50094;
continue;
} else {
var node_50101 = cljs.core.first(seq__49056_50082__$1);
fragment.appendChild(shadow.dom._to_dom(node_50101));


var G__50104 = cljs.core.next(seq__49056_50082__$1);
var G__50105 = null;
var G__50106 = (0);
var G__50107 = (0);
seq__49056_50065 = G__50104;
chunk__49057_50066 = G__50105;
count__49058_50067 = G__50106;
i__49059_50068 = G__50107;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq49051){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq49051));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__49073_50129 = cljs.core.seq(scripts);
var chunk__49074_50130 = null;
var count__49075_50131 = (0);
var i__49076_50132 = (0);
while(true){
if((i__49076_50132 < count__49075_50131)){
var vec__49083_50137 = chunk__49074_50130.cljs$core$IIndexed$_nth$arity$2(null,i__49076_50132);
var script_tag_50138 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49083_50137,(0),null);
var script_body_50139 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49083_50137,(1),null);
eval(script_body_50139);


var G__50147 = seq__49073_50129;
var G__50148 = chunk__49074_50130;
var G__50149 = count__49075_50131;
var G__50150 = (i__49076_50132 + (1));
seq__49073_50129 = G__50147;
chunk__49074_50130 = G__50148;
count__49075_50131 = G__50149;
i__49076_50132 = G__50150;
continue;
} else {
var temp__5735__auto___50157 = cljs.core.seq(seq__49073_50129);
if(temp__5735__auto___50157){
var seq__49073_50160__$1 = temp__5735__auto___50157;
if(cljs.core.chunked_seq_QMARK_(seq__49073_50160__$1)){
var c__4556__auto___50169 = cljs.core.chunk_first(seq__49073_50160__$1);
var G__50171 = cljs.core.chunk_rest(seq__49073_50160__$1);
var G__50172 = c__4556__auto___50169;
var G__50173 = cljs.core.count(c__4556__auto___50169);
var G__50174 = (0);
seq__49073_50129 = G__50171;
chunk__49074_50130 = G__50172;
count__49075_50131 = G__50173;
i__49076_50132 = G__50174;
continue;
} else {
var vec__49091_50180 = cljs.core.first(seq__49073_50160__$1);
var script_tag_50181 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49091_50180,(0),null);
var script_body_50182 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49091_50180,(1),null);
eval(script_body_50182);


var G__50192 = cljs.core.next(seq__49073_50160__$1);
var G__50193 = null;
var G__50194 = (0);
var G__50195 = (0);
seq__49073_50129 = G__50192;
chunk__49074_50130 = G__50193;
count__49075_50131 = G__50194;
i__49076_50132 = G__50195;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__49094){
var vec__49095 = p__49094;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49095,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49095,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__49109 = arguments.length;
switch (G__49109) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__49123 = cljs.core.seq(style_keys);
var chunk__49124 = null;
var count__49125 = (0);
var i__49126 = (0);
while(true){
if((i__49126 < count__49125)){
var it = chunk__49124.cljs$core$IIndexed$_nth$arity$2(null,i__49126);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__50284 = seq__49123;
var G__50285 = chunk__49124;
var G__50286 = count__49125;
var G__50287 = (i__49126 + (1));
seq__49123 = G__50284;
chunk__49124 = G__50285;
count__49125 = G__50286;
i__49126 = G__50287;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__49123);
if(temp__5735__auto__){
var seq__49123__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49123__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__49123__$1);
var G__50305 = cljs.core.chunk_rest(seq__49123__$1);
var G__50306 = c__4556__auto__;
var G__50307 = cljs.core.count(c__4556__auto__);
var G__50308 = (0);
seq__49123 = G__50305;
chunk__49124 = G__50306;
count__49125 = G__50307;
i__49126 = G__50308;
continue;
} else {
var it = cljs.core.first(seq__49123__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__50322 = cljs.core.next(seq__49123__$1);
var G__50323 = null;
var G__50324 = (0);
var G__50325 = (0);
seq__49123 = G__50322;
chunk__49124 = G__50323;
count__49125 = G__50324;
i__49126 = G__50325;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k49136,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__49142 = k49136;
var G__49142__$1 = (((G__49142 instanceof cljs.core.Keyword))?G__49142.fqn:null);
switch (G__49142__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49136,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__49147){
var vec__49149 = p__49147;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49149,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49149,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49135){
var self__ = this;
var G__49135__$1 = this;
return (new cljs.core.RecordIter((0),G__49135__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49137,other49138){
var self__ = this;
var this49137__$1 = this;
return (((!((other49138 == null)))) && ((this49137__$1.constructor === other49138.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49137__$1.x,other49138.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49137__$1.y,other49138.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49137__$1.__extmap,other49138.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__49135){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__49177 = cljs.core.keyword_identical_QMARK_;
var expr__49178 = k__4388__auto__;
if(cljs.core.truth_((pred__49177.cljs$core$IFn$_invoke$arity$2 ? pred__49177.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__49178) : pred__49177.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__49178)))){
return (new shadow.dom.Coordinate(G__49135,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__49177.cljs$core$IFn$_invoke$arity$2 ? pred__49177.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__49178) : pred__49177.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__49178)))){
return (new shadow.dom.Coordinate(self__.x,G__49135,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__49135),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__49135){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__49135,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__49139){
var extmap__4419__auto__ = (function (){var G__49196 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49139,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__49139)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49196);
} else {
return G__49196;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__49139),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__49139),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k49212,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__49220 = k49212;
var G__49220__$1 = (((G__49220 instanceof cljs.core.Keyword))?G__49220.fqn:null);
switch (G__49220__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49212,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__49229){
var vec__49230 = p__49229;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49230,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49230,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49211){
var self__ = this;
var G__49211__$1 = this;
return (new cljs.core.RecordIter((0),G__49211__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49213,other49214){
var self__ = this;
var this49213__$1 = this;
return (((!((other49214 == null)))) && ((this49213__$1.constructor === other49214.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49213__$1.w,other49214.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49213__$1.h,other49214.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49213__$1.__extmap,other49214.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__49211){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__49251 = cljs.core.keyword_identical_QMARK_;
var expr__49252 = k__4388__auto__;
if(cljs.core.truth_((pred__49251.cljs$core$IFn$_invoke$arity$2 ? pred__49251.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__49252) : pred__49251.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__49252)))){
return (new shadow.dom.Size(G__49211,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__49251.cljs$core$IFn$_invoke$arity$2 ? pred__49251.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__49252) : pred__49251.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__49252)))){
return (new shadow.dom.Size(self__.w,G__49211,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__49211),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__49211){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__49211,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__49216){
var extmap__4419__auto__ = (function (){var G__49265 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49216,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__49216)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49265);
} else {
return G__49265;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__49216),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__49216),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__50778 = (i + (1));
var G__50779 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__50778;
ret = G__50779;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__49279){
var vec__49280 = p__49279;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49280,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49280,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__49284 = arguments.length;
switch (G__49284) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5733__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5733__auto__)){
var child = temp__5733__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__50831 = ps;
var G__50832 = (i + (1));
el__$1 = G__50831;
i = G__50832;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__49315 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49315,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49315,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49315,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__49320_50857 = cljs.core.seq(props);
var chunk__49321_50858 = null;
var count__49322_50859 = (0);
var i__49323_50860 = (0);
while(true){
if((i__49323_50860 < count__49322_50859)){
var vec__49335_50866 = chunk__49321_50858.cljs$core$IIndexed$_nth$arity$2(null,i__49323_50860);
var k_50867 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49335_50866,(0),null);
var v_50868 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49335_50866,(1),null);
el.setAttributeNS((function (){var temp__5735__auto__ = cljs.core.namespace(k_50867);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_50867),v_50868);


var G__50871 = seq__49320_50857;
var G__50872 = chunk__49321_50858;
var G__50873 = count__49322_50859;
var G__50874 = (i__49323_50860 + (1));
seq__49320_50857 = G__50871;
chunk__49321_50858 = G__50872;
count__49322_50859 = G__50873;
i__49323_50860 = G__50874;
continue;
} else {
var temp__5735__auto___50876 = cljs.core.seq(seq__49320_50857);
if(temp__5735__auto___50876){
var seq__49320_50877__$1 = temp__5735__auto___50876;
if(cljs.core.chunked_seq_QMARK_(seq__49320_50877__$1)){
var c__4556__auto___50881 = cljs.core.chunk_first(seq__49320_50877__$1);
var G__50882 = cljs.core.chunk_rest(seq__49320_50877__$1);
var G__50883 = c__4556__auto___50881;
var G__50884 = cljs.core.count(c__4556__auto___50881);
var G__50885 = (0);
seq__49320_50857 = G__50882;
chunk__49321_50858 = G__50883;
count__49322_50859 = G__50884;
i__49323_50860 = G__50885;
continue;
} else {
var vec__49351_50886 = cljs.core.first(seq__49320_50877__$1);
var k_50887 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49351_50886,(0),null);
var v_50888 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49351_50886,(1),null);
el.setAttributeNS((function (){var temp__5735__auto____$1 = cljs.core.namespace(k_50887);
if(cljs.core.truth_(temp__5735__auto____$1)){
var ns = temp__5735__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_50887),v_50888);


var G__50892 = cljs.core.next(seq__49320_50877__$1);
var G__50893 = null;
var G__50894 = (0);
var G__50895 = (0);
seq__49320_50857 = G__50892;
chunk__49321_50858 = G__50893;
count__49322_50859 = G__50894;
i__49323_50860 = G__50895;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__49364 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49364,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49364,(1),null);
var seq__49368_50905 = cljs.core.seq(node_children);
var chunk__49370_50906 = null;
var count__49371_50907 = (0);
var i__49372_50908 = (0);
while(true){
if((i__49372_50908 < count__49371_50907)){
var child_struct_50910 = chunk__49370_50906.cljs$core$IIndexed$_nth$arity$2(null,i__49372_50908);
if((!((child_struct_50910 == null)))){
if(typeof child_struct_50910 === 'string'){
var text_50917 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_50917),child_struct_50910].join(''));
} else {
var children_50920 = shadow.dom.svg_node(child_struct_50910);
if(cljs.core.seq_QMARK_(children_50920)){
var seq__49441_50922 = cljs.core.seq(children_50920);
var chunk__49443_50923 = null;
var count__49444_50924 = (0);
var i__49445_50925 = (0);
while(true){
if((i__49445_50925 < count__49444_50924)){
var child_50935 = chunk__49443_50923.cljs$core$IIndexed$_nth$arity$2(null,i__49445_50925);
if(cljs.core.truth_(child_50935)){
node.appendChild(child_50935);


var G__50938 = seq__49441_50922;
var G__50939 = chunk__49443_50923;
var G__50940 = count__49444_50924;
var G__50941 = (i__49445_50925 + (1));
seq__49441_50922 = G__50938;
chunk__49443_50923 = G__50939;
count__49444_50924 = G__50940;
i__49445_50925 = G__50941;
continue;
} else {
var G__50947 = seq__49441_50922;
var G__50948 = chunk__49443_50923;
var G__50949 = count__49444_50924;
var G__50950 = (i__49445_50925 + (1));
seq__49441_50922 = G__50947;
chunk__49443_50923 = G__50948;
count__49444_50924 = G__50949;
i__49445_50925 = G__50950;
continue;
}
} else {
var temp__5735__auto___50957 = cljs.core.seq(seq__49441_50922);
if(temp__5735__auto___50957){
var seq__49441_50962__$1 = temp__5735__auto___50957;
if(cljs.core.chunked_seq_QMARK_(seq__49441_50962__$1)){
var c__4556__auto___50963 = cljs.core.chunk_first(seq__49441_50962__$1);
var G__50964 = cljs.core.chunk_rest(seq__49441_50962__$1);
var G__50965 = c__4556__auto___50963;
var G__50966 = cljs.core.count(c__4556__auto___50963);
var G__50967 = (0);
seq__49441_50922 = G__50964;
chunk__49443_50923 = G__50965;
count__49444_50924 = G__50966;
i__49445_50925 = G__50967;
continue;
} else {
var child_50969 = cljs.core.first(seq__49441_50962__$1);
if(cljs.core.truth_(child_50969)){
node.appendChild(child_50969);


var G__50971 = cljs.core.next(seq__49441_50962__$1);
var G__50972 = null;
var G__50973 = (0);
var G__50974 = (0);
seq__49441_50922 = G__50971;
chunk__49443_50923 = G__50972;
count__49444_50924 = G__50973;
i__49445_50925 = G__50974;
continue;
} else {
var G__50977 = cljs.core.next(seq__49441_50962__$1);
var G__50978 = null;
var G__50979 = (0);
var G__50980 = (0);
seq__49441_50922 = G__50977;
chunk__49443_50923 = G__50978;
count__49444_50924 = G__50979;
i__49445_50925 = G__50980;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_50920);
}
}


var G__50983 = seq__49368_50905;
var G__50984 = chunk__49370_50906;
var G__50985 = count__49371_50907;
var G__50986 = (i__49372_50908 + (1));
seq__49368_50905 = G__50983;
chunk__49370_50906 = G__50984;
count__49371_50907 = G__50985;
i__49372_50908 = G__50986;
continue;
} else {
var G__50987 = seq__49368_50905;
var G__50988 = chunk__49370_50906;
var G__50989 = count__49371_50907;
var G__50990 = (i__49372_50908 + (1));
seq__49368_50905 = G__50987;
chunk__49370_50906 = G__50988;
count__49371_50907 = G__50989;
i__49372_50908 = G__50990;
continue;
}
} else {
var temp__5735__auto___50992 = cljs.core.seq(seq__49368_50905);
if(temp__5735__auto___50992){
var seq__49368_50996__$1 = temp__5735__auto___50992;
if(cljs.core.chunked_seq_QMARK_(seq__49368_50996__$1)){
var c__4556__auto___50997 = cljs.core.chunk_first(seq__49368_50996__$1);
var G__50999 = cljs.core.chunk_rest(seq__49368_50996__$1);
var G__51000 = c__4556__auto___50997;
var G__51001 = cljs.core.count(c__4556__auto___50997);
var G__51002 = (0);
seq__49368_50905 = G__50999;
chunk__49370_50906 = G__51000;
count__49371_50907 = G__51001;
i__49372_50908 = G__51002;
continue;
} else {
var child_struct_51003 = cljs.core.first(seq__49368_50996__$1);
if((!((child_struct_51003 == null)))){
if(typeof child_struct_51003 === 'string'){
var text_51004 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_51004),child_struct_51003].join(''));
} else {
var children_51006 = shadow.dom.svg_node(child_struct_51003);
if(cljs.core.seq_QMARK_(children_51006)){
var seq__49478_51009 = cljs.core.seq(children_51006);
var chunk__49480_51010 = null;
var count__49481_51011 = (0);
var i__49482_51012 = (0);
while(true){
if((i__49482_51012 < count__49481_51011)){
var child_51014 = chunk__49480_51010.cljs$core$IIndexed$_nth$arity$2(null,i__49482_51012);
if(cljs.core.truth_(child_51014)){
node.appendChild(child_51014);


var G__51015 = seq__49478_51009;
var G__51016 = chunk__49480_51010;
var G__51017 = count__49481_51011;
var G__51018 = (i__49482_51012 + (1));
seq__49478_51009 = G__51015;
chunk__49480_51010 = G__51016;
count__49481_51011 = G__51017;
i__49482_51012 = G__51018;
continue;
} else {
var G__51020 = seq__49478_51009;
var G__51021 = chunk__49480_51010;
var G__51022 = count__49481_51011;
var G__51023 = (i__49482_51012 + (1));
seq__49478_51009 = G__51020;
chunk__49480_51010 = G__51021;
count__49481_51011 = G__51022;
i__49482_51012 = G__51023;
continue;
}
} else {
var temp__5735__auto___51026__$1 = cljs.core.seq(seq__49478_51009);
if(temp__5735__auto___51026__$1){
var seq__49478_51027__$1 = temp__5735__auto___51026__$1;
if(cljs.core.chunked_seq_QMARK_(seq__49478_51027__$1)){
var c__4556__auto___51029 = cljs.core.chunk_first(seq__49478_51027__$1);
var G__51031 = cljs.core.chunk_rest(seq__49478_51027__$1);
var G__51032 = c__4556__auto___51029;
var G__51033 = cljs.core.count(c__4556__auto___51029);
var G__51034 = (0);
seq__49478_51009 = G__51031;
chunk__49480_51010 = G__51032;
count__49481_51011 = G__51033;
i__49482_51012 = G__51034;
continue;
} else {
var child_51036 = cljs.core.first(seq__49478_51027__$1);
if(cljs.core.truth_(child_51036)){
node.appendChild(child_51036);


var G__51038 = cljs.core.next(seq__49478_51027__$1);
var G__51039 = null;
var G__51040 = (0);
var G__51041 = (0);
seq__49478_51009 = G__51038;
chunk__49480_51010 = G__51039;
count__49481_51011 = G__51040;
i__49482_51012 = G__51041;
continue;
} else {
var G__51043 = cljs.core.next(seq__49478_51027__$1);
var G__51044 = null;
var G__51045 = (0);
var G__51046 = (0);
seq__49478_51009 = G__51043;
chunk__49480_51010 = G__51044;
count__49481_51011 = G__51045;
i__49482_51012 = G__51046;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_51006);
}
}


var G__51048 = cljs.core.next(seq__49368_50996__$1);
var G__51049 = null;
var G__51050 = (0);
var G__51051 = (0);
seq__49368_50905 = G__51048;
chunk__49370_50906 = G__51049;
count__49371_50907 = G__51050;
i__49372_50908 = G__51051;
continue;
} else {
var G__51053 = cljs.core.next(seq__49368_50996__$1);
var G__51054 = null;
var G__51055 = (0);
var G__51056 = (0);
seq__49368_50905 = G__51053;
chunk__49370_50906 = G__51054;
count__49371_50907 = G__51055;
i__49372_50908 = G__51056;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___51083 = arguments.length;
var i__4737__auto___51084 = (0);
while(true){
if((i__4737__auto___51084 < len__4736__auto___51083)){
args__4742__auto__.push((arguments[i__4737__auto___51084]));

var G__51088 = (i__4737__auto___51084 + (1));
i__4737__auto___51084 = G__51088;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq49503){
var G__49504 = cljs.core.first(seq49503);
var seq49503__$1 = cljs.core.next(seq49503);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49504,seq49503__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__49515 = arguments.length;
switch (G__49515) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__45032__auto___51123 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_49528){
var state_val_49529 = (state_49528[(1)]);
if((state_val_49529 === (1))){
var state_49528__$1 = state_49528;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49528__$1,(2),once_or_cleanup);
} else {
if((state_val_49529 === (2))){
var inst_49525 = (state_49528[(2)]);
var inst_49526 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_49528__$1 = (function (){var statearr_49531 = state_49528;
(statearr_49531[(7)] = inst_49525);

return statearr_49531;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_49528__$1,inst_49526);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__44935__auto__ = null;
var shadow$dom$state_machine__44935__auto____0 = (function (){
var statearr_49533 = [null,null,null,null,null,null,null,null];
(statearr_49533[(0)] = shadow$dom$state_machine__44935__auto__);

(statearr_49533[(1)] = (1));

return statearr_49533;
});
var shadow$dom$state_machine__44935__auto____1 = (function (state_49528){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_49528);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e49534){var ex__44939__auto__ = e49534;
var statearr_49535_51137 = state_49528;
(statearr_49535_51137[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_49528[(4)]))){
var statearr_49536_51142 = state_49528;
(statearr_49536_51142[(1)] = cljs.core.first((state_49528[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51144 = state_49528;
state_49528 = G__51144;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
shadow$dom$state_machine__44935__auto__ = function(state_49528){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__44935__auto____0.call(this);
case 1:
return shadow$dom$state_machine__44935__auto____1.call(this,state_49528);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__44935__auto____0;
shadow$dom$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__44935__auto____1;
return shadow$dom$state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_49545 = f__45033__auto__();
(statearr_49545[(6)] = c__45032__auto___51123);

return statearr_49545;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
