goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_52545 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_52545(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_52549 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_52549(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__51510 = coll;
var G__51511 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__51510,G__51511) : shadow.dom.lazy_native_coll_seq.call(null,G__51510,G__51511));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__51528 = arguments.length;
switch (G__51528) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__51537 = arguments.length;
switch (G__51537) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__51548 = arguments.length;
switch (G__51548) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__51567 = arguments.length;
switch (G__51567) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__51590 = arguments.length;
switch (G__51590) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__51609 = arguments.length;
switch (G__51609) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e51616){if((e51616 instanceof Object)){
var e = e51616;
return console.log("didnt support attachEvent",el,e);
} else {
throw e51616;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__51626 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__51627 = null;
var count__51628 = (0);
var i__51629 = (0);
while(true){
if((i__51629 < count__51628)){
var el = chunk__51627.cljs$core$IIndexed$_nth$arity$2(null,i__51629);
var handler_52634__$1 = ((function (seq__51626,chunk__51627,count__51628,i__51629,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__51626,chunk__51627,count__51628,i__51629,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_52634__$1);


var G__52638 = seq__51626;
var G__52639 = chunk__51627;
var G__52640 = count__51628;
var G__52641 = (i__51629 + (1));
seq__51626 = G__52638;
chunk__51627 = G__52639;
count__51628 = G__52640;
i__51629 = G__52641;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__51626);
if(temp__5735__auto__){
var seq__51626__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51626__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__51626__$1);
var G__52647 = cljs.core.chunk_rest(seq__51626__$1);
var G__52648 = c__4556__auto__;
var G__52649 = cljs.core.count(c__4556__auto__);
var G__52650 = (0);
seq__51626 = G__52647;
chunk__51627 = G__52648;
count__51628 = G__52649;
i__51629 = G__52650;
continue;
} else {
var el = cljs.core.first(seq__51626__$1);
var handler_52651__$1 = ((function (seq__51626,chunk__51627,count__51628,i__51629,el,seq__51626__$1,temp__5735__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__51626,chunk__51627,count__51628,i__51629,el,seq__51626__$1,temp__5735__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_52651__$1);


var G__52657 = cljs.core.next(seq__51626__$1);
var G__52658 = null;
var G__52659 = (0);
var G__52660 = (0);
seq__51626 = G__52657;
chunk__51627 = G__52658;
count__51628 = G__52659;
i__51629 = G__52660;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__51658 = arguments.length;
switch (G__51658) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__51686 = cljs.core.seq(events);
var chunk__51687 = null;
var count__51688 = (0);
var i__51689 = (0);
while(true){
if((i__51689 < count__51688)){
var vec__51720 = chunk__51687.cljs$core$IIndexed$_nth$arity$2(null,i__51689);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51720,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51720,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__52673 = seq__51686;
var G__52674 = chunk__51687;
var G__52675 = count__51688;
var G__52676 = (i__51689 + (1));
seq__51686 = G__52673;
chunk__51687 = G__52674;
count__51688 = G__52675;
i__51689 = G__52676;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__51686);
if(temp__5735__auto__){
var seq__51686__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51686__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__51686__$1);
var G__52678 = cljs.core.chunk_rest(seq__51686__$1);
var G__52679 = c__4556__auto__;
var G__52680 = cljs.core.count(c__4556__auto__);
var G__52681 = (0);
seq__51686 = G__52678;
chunk__51687 = G__52679;
count__51688 = G__52680;
i__51689 = G__52681;
continue;
} else {
var vec__51728 = cljs.core.first(seq__51686__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51728,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51728,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__52686 = cljs.core.next(seq__51686__$1);
var G__52687 = null;
var G__52688 = (0);
var G__52689 = (0);
seq__51686 = G__52686;
chunk__51687 = G__52687;
count__51688 = G__52688;
i__51689 = G__52689;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__51737 = cljs.core.seq(styles);
var chunk__51738 = null;
var count__51739 = (0);
var i__51740 = (0);
while(true){
if((i__51740 < count__51739)){
var vec__51766 = chunk__51738.cljs$core$IIndexed$_nth$arity$2(null,i__51740);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51766,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51766,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__52691 = seq__51737;
var G__52692 = chunk__51738;
var G__52693 = count__51739;
var G__52694 = (i__51740 + (1));
seq__51737 = G__52691;
chunk__51738 = G__52692;
count__51739 = G__52693;
i__51740 = G__52694;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__51737);
if(temp__5735__auto__){
var seq__51737__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51737__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__51737__$1);
var G__52699 = cljs.core.chunk_rest(seq__51737__$1);
var G__52700 = c__4556__auto__;
var G__52701 = cljs.core.count(c__4556__auto__);
var G__52702 = (0);
seq__51737 = G__52699;
chunk__51738 = G__52700;
count__51739 = G__52701;
i__51740 = G__52702;
continue;
} else {
var vec__51776 = cljs.core.first(seq__51737__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51776,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51776,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__52704 = cljs.core.next(seq__51737__$1);
var G__52705 = null;
var G__52706 = (0);
var G__52707 = (0);
seq__51737 = G__52704;
chunk__51738 = G__52705;
count__51739 = G__52706;
i__51740 = G__52707;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__51789_52708 = key;
var G__51789_52709__$1 = (((G__51789_52708 instanceof cljs.core.Keyword))?G__51789_52708.fqn:null);
switch (G__51789_52709__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_52715 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_52715,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_52715,"aria-");
}
})())){
el.setAttribute(ks_52715,value);
} else {
(el[ks_52715] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__51838){
var map__51839 = p__51838;
var map__51839__$1 = (((((!((map__51839 == null))))?(((((map__51839.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51839.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51839):map__51839);
var props = map__51839__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51839__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__51841 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51841,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51841,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51841,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__51844 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__51844,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__51844;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__51847 = arguments.length;
switch (G__51847) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__51870){
var vec__51873 = p__51870;
var seq__51874 = cljs.core.seq(vec__51873);
var first__51875 = cljs.core.first(seq__51874);
var seq__51874__$1 = cljs.core.next(seq__51874);
var nn = first__51875;
var first__51875__$1 = cljs.core.first(seq__51874__$1);
var seq__51874__$2 = cljs.core.next(seq__51874__$1);
var np = first__51875__$1;
var nc = seq__51874__$2;
var node = vec__51873;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__51879 = nn;
var G__51880 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__51879,G__51880) : create_fn.call(null,G__51879,G__51880));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__51882 = nn;
var G__51883 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__51882,G__51883) : create_fn.call(null,G__51882,G__51883));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__51893 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51893,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51893,(1),null);
var seq__51896_52745 = cljs.core.seq(node_children);
var chunk__51897_52746 = null;
var count__51898_52747 = (0);
var i__51899_52748 = (0);
while(true){
if((i__51899_52748 < count__51898_52747)){
var child_struct_52751 = chunk__51897_52746.cljs$core$IIndexed$_nth$arity$2(null,i__51899_52748);
var children_52752 = shadow.dom.dom_node(child_struct_52751);
if(cljs.core.seq_QMARK_(children_52752)){
var seq__51937_52753 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_52752));
var chunk__51939_52754 = null;
var count__51940_52755 = (0);
var i__51941_52756 = (0);
while(true){
if((i__51941_52756 < count__51940_52755)){
var child_52757 = chunk__51939_52754.cljs$core$IIndexed$_nth$arity$2(null,i__51941_52756);
if(cljs.core.truth_(child_52757)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52757);


var G__52759 = seq__51937_52753;
var G__52760 = chunk__51939_52754;
var G__52761 = count__51940_52755;
var G__52762 = (i__51941_52756 + (1));
seq__51937_52753 = G__52759;
chunk__51939_52754 = G__52760;
count__51940_52755 = G__52761;
i__51941_52756 = G__52762;
continue;
} else {
var G__52763 = seq__51937_52753;
var G__52764 = chunk__51939_52754;
var G__52765 = count__51940_52755;
var G__52766 = (i__51941_52756 + (1));
seq__51937_52753 = G__52763;
chunk__51939_52754 = G__52764;
count__51940_52755 = G__52765;
i__51941_52756 = G__52766;
continue;
}
} else {
var temp__5735__auto___52767 = cljs.core.seq(seq__51937_52753);
if(temp__5735__auto___52767){
var seq__51937_52771__$1 = temp__5735__auto___52767;
if(cljs.core.chunked_seq_QMARK_(seq__51937_52771__$1)){
var c__4556__auto___52772 = cljs.core.chunk_first(seq__51937_52771__$1);
var G__52773 = cljs.core.chunk_rest(seq__51937_52771__$1);
var G__52774 = c__4556__auto___52772;
var G__52775 = cljs.core.count(c__4556__auto___52772);
var G__52776 = (0);
seq__51937_52753 = G__52773;
chunk__51939_52754 = G__52774;
count__51940_52755 = G__52775;
i__51941_52756 = G__52776;
continue;
} else {
var child_52778 = cljs.core.first(seq__51937_52771__$1);
if(cljs.core.truth_(child_52778)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52778);


var G__52779 = cljs.core.next(seq__51937_52771__$1);
var G__52780 = null;
var G__52781 = (0);
var G__52782 = (0);
seq__51937_52753 = G__52779;
chunk__51939_52754 = G__52780;
count__51940_52755 = G__52781;
i__51941_52756 = G__52782;
continue;
} else {
var G__52783 = cljs.core.next(seq__51937_52771__$1);
var G__52784 = null;
var G__52785 = (0);
var G__52786 = (0);
seq__51937_52753 = G__52783;
chunk__51939_52754 = G__52784;
count__51940_52755 = G__52785;
i__51941_52756 = G__52786;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_52752);
}


var G__52787 = seq__51896_52745;
var G__52788 = chunk__51897_52746;
var G__52789 = count__51898_52747;
var G__52790 = (i__51899_52748 + (1));
seq__51896_52745 = G__52787;
chunk__51897_52746 = G__52788;
count__51898_52747 = G__52789;
i__51899_52748 = G__52790;
continue;
} else {
var temp__5735__auto___52791 = cljs.core.seq(seq__51896_52745);
if(temp__5735__auto___52791){
var seq__51896_52792__$1 = temp__5735__auto___52791;
if(cljs.core.chunked_seq_QMARK_(seq__51896_52792__$1)){
var c__4556__auto___52793 = cljs.core.chunk_first(seq__51896_52792__$1);
var G__52794 = cljs.core.chunk_rest(seq__51896_52792__$1);
var G__52795 = c__4556__auto___52793;
var G__52796 = cljs.core.count(c__4556__auto___52793);
var G__52797 = (0);
seq__51896_52745 = G__52794;
chunk__51897_52746 = G__52795;
count__51898_52747 = G__52796;
i__51899_52748 = G__52797;
continue;
} else {
var child_struct_52798 = cljs.core.first(seq__51896_52792__$1);
var children_52799 = shadow.dom.dom_node(child_struct_52798);
if(cljs.core.seq_QMARK_(children_52799)){
var seq__51964_52800 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_52799));
var chunk__51966_52801 = null;
var count__51967_52802 = (0);
var i__51968_52803 = (0);
while(true){
if((i__51968_52803 < count__51967_52802)){
var child_52804 = chunk__51966_52801.cljs$core$IIndexed$_nth$arity$2(null,i__51968_52803);
if(cljs.core.truth_(child_52804)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52804);


var G__52805 = seq__51964_52800;
var G__52806 = chunk__51966_52801;
var G__52807 = count__51967_52802;
var G__52808 = (i__51968_52803 + (1));
seq__51964_52800 = G__52805;
chunk__51966_52801 = G__52806;
count__51967_52802 = G__52807;
i__51968_52803 = G__52808;
continue;
} else {
var G__52810 = seq__51964_52800;
var G__52811 = chunk__51966_52801;
var G__52812 = count__51967_52802;
var G__52813 = (i__51968_52803 + (1));
seq__51964_52800 = G__52810;
chunk__51966_52801 = G__52811;
count__51967_52802 = G__52812;
i__51968_52803 = G__52813;
continue;
}
} else {
var temp__5735__auto___52814__$1 = cljs.core.seq(seq__51964_52800);
if(temp__5735__auto___52814__$1){
var seq__51964_52815__$1 = temp__5735__auto___52814__$1;
if(cljs.core.chunked_seq_QMARK_(seq__51964_52815__$1)){
var c__4556__auto___52816 = cljs.core.chunk_first(seq__51964_52815__$1);
var G__52817 = cljs.core.chunk_rest(seq__51964_52815__$1);
var G__52818 = c__4556__auto___52816;
var G__52819 = cljs.core.count(c__4556__auto___52816);
var G__52820 = (0);
seq__51964_52800 = G__52817;
chunk__51966_52801 = G__52818;
count__51967_52802 = G__52819;
i__51968_52803 = G__52820;
continue;
} else {
var child_52822 = cljs.core.first(seq__51964_52815__$1);
if(cljs.core.truth_(child_52822)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52822);


var G__52823 = cljs.core.next(seq__51964_52815__$1);
var G__52824 = null;
var G__52825 = (0);
var G__52826 = (0);
seq__51964_52800 = G__52823;
chunk__51966_52801 = G__52824;
count__51967_52802 = G__52825;
i__51968_52803 = G__52826;
continue;
} else {
var G__52828 = cljs.core.next(seq__51964_52815__$1);
var G__52829 = null;
var G__52830 = (0);
var G__52831 = (0);
seq__51964_52800 = G__52828;
chunk__51966_52801 = G__52829;
count__51967_52802 = G__52830;
i__51968_52803 = G__52831;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_52799);
}


var G__52833 = cljs.core.next(seq__51896_52792__$1);
var G__52834 = null;
var G__52835 = (0);
var G__52836 = (0);
seq__51896_52745 = G__52833;
chunk__51897_52746 = G__52834;
count__51898_52747 = G__52835;
i__51899_52748 = G__52836;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__52029 = cljs.core.seq(node);
var chunk__52030 = null;
var count__52031 = (0);
var i__52032 = (0);
while(true){
if((i__52032 < count__52031)){
var n = chunk__52030.cljs$core$IIndexed$_nth$arity$2(null,i__52032);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__52842 = seq__52029;
var G__52843 = chunk__52030;
var G__52844 = count__52031;
var G__52845 = (i__52032 + (1));
seq__52029 = G__52842;
chunk__52030 = G__52843;
count__52031 = G__52844;
i__52032 = G__52845;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__52029);
if(temp__5735__auto__){
var seq__52029__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__52029__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__52029__$1);
var G__52852 = cljs.core.chunk_rest(seq__52029__$1);
var G__52853 = c__4556__auto__;
var G__52854 = cljs.core.count(c__4556__auto__);
var G__52855 = (0);
seq__52029 = G__52852;
chunk__52030 = G__52853;
count__52031 = G__52854;
i__52032 = G__52855;
continue;
} else {
var n = cljs.core.first(seq__52029__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__52859 = cljs.core.next(seq__52029__$1);
var G__52860 = null;
var G__52861 = (0);
var G__52862 = (0);
seq__52029 = G__52859;
chunk__52030 = G__52860;
count__52031 = G__52861;
i__52032 = G__52862;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__52048 = arguments.length;
switch (G__52048) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__52058 = arguments.length;
switch (G__52058) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__52075 = arguments.length;
switch (G__52075) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___52883 = arguments.length;
var i__4737__auto___52885 = (0);
while(true){
if((i__4737__auto___52885 < len__4736__auto___52883)){
args__4742__auto__.push((arguments[i__4737__auto___52885]));

var G__52888 = (i__4737__auto___52885 + (1));
i__4737__auto___52885 = G__52888;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__52089_52891 = cljs.core.seq(nodes);
var chunk__52090_52892 = null;
var count__52091_52893 = (0);
var i__52092_52894 = (0);
while(true){
if((i__52092_52894 < count__52091_52893)){
var node_52895 = chunk__52090_52892.cljs$core$IIndexed$_nth$arity$2(null,i__52092_52894);
fragment.appendChild(shadow.dom._to_dom(node_52895));


var G__52896 = seq__52089_52891;
var G__52897 = chunk__52090_52892;
var G__52898 = count__52091_52893;
var G__52899 = (i__52092_52894 + (1));
seq__52089_52891 = G__52896;
chunk__52090_52892 = G__52897;
count__52091_52893 = G__52898;
i__52092_52894 = G__52899;
continue;
} else {
var temp__5735__auto___52902 = cljs.core.seq(seq__52089_52891);
if(temp__5735__auto___52902){
var seq__52089_52905__$1 = temp__5735__auto___52902;
if(cljs.core.chunked_seq_QMARK_(seq__52089_52905__$1)){
var c__4556__auto___52906 = cljs.core.chunk_first(seq__52089_52905__$1);
var G__52909 = cljs.core.chunk_rest(seq__52089_52905__$1);
var G__52910 = c__4556__auto___52906;
var G__52911 = cljs.core.count(c__4556__auto___52906);
var G__52912 = (0);
seq__52089_52891 = G__52909;
chunk__52090_52892 = G__52910;
count__52091_52893 = G__52911;
i__52092_52894 = G__52912;
continue;
} else {
var node_52913 = cljs.core.first(seq__52089_52905__$1);
fragment.appendChild(shadow.dom._to_dom(node_52913));


var G__52915 = cljs.core.next(seq__52089_52905__$1);
var G__52916 = null;
var G__52917 = (0);
var G__52918 = (0);
seq__52089_52891 = G__52915;
chunk__52090_52892 = G__52916;
count__52091_52893 = G__52917;
i__52092_52894 = G__52918;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq52084){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq52084));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__52103_52924 = cljs.core.seq(scripts);
var chunk__52104_52925 = null;
var count__52105_52926 = (0);
var i__52106_52927 = (0);
while(true){
if((i__52106_52927 < count__52105_52926)){
var vec__52115_52929 = chunk__52104_52925.cljs$core$IIndexed$_nth$arity$2(null,i__52106_52927);
var script_tag_52930 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52115_52929,(0),null);
var script_body_52931 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52115_52929,(1),null);
eval(script_body_52931);


var G__52933 = seq__52103_52924;
var G__52934 = chunk__52104_52925;
var G__52935 = count__52105_52926;
var G__52936 = (i__52106_52927 + (1));
seq__52103_52924 = G__52933;
chunk__52104_52925 = G__52934;
count__52105_52926 = G__52935;
i__52106_52927 = G__52936;
continue;
} else {
var temp__5735__auto___52939 = cljs.core.seq(seq__52103_52924);
if(temp__5735__auto___52939){
var seq__52103_52941__$1 = temp__5735__auto___52939;
if(cljs.core.chunked_seq_QMARK_(seq__52103_52941__$1)){
var c__4556__auto___52943 = cljs.core.chunk_first(seq__52103_52941__$1);
var G__52944 = cljs.core.chunk_rest(seq__52103_52941__$1);
var G__52945 = c__4556__auto___52943;
var G__52946 = cljs.core.count(c__4556__auto___52943);
var G__52947 = (0);
seq__52103_52924 = G__52944;
chunk__52104_52925 = G__52945;
count__52105_52926 = G__52946;
i__52106_52927 = G__52947;
continue;
} else {
var vec__52119_52949 = cljs.core.first(seq__52103_52941__$1);
var script_tag_52950 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52119_52949,(0),null);
var script_body_52951 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52119_52949,(1),null);
eval(script_body_52951);


var G__52953 = cljs.core.next(seq__52103_52941__$1);
var G__52954 = null;
var G__52955 = (0);
var G__52956 = (0);
seq__52103_52924 = G__52953;
chunk__52104_52925 = G__52954;
count__52105_52926 = G__52955;
i__52106_52927 = G__52956;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__52122){
var vec__52123 = p__52122;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52123,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52123,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__52129 = arguments.length;
switch (G__52129) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__52148 = cljs.core.seq(style_keys);
var chunk__52149 = null;
var count__52150 = (0);
var i__52151 = (0);
while(true){
if((i__52151 < count__52150)){
var it = chunk__52149.cljs$core$IIndexed$_nth$arity$2(null,i__52151);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__52990 = seq__52148;
var G__52991 = chunk__52149;
var G__52992 = count__52150;
var G__52993 = (i__52151 + (1));
seq__52148 = G__52990;
chunk__52149 = G__52991;
count__52150 = G__52992;
i__52151 = G__52993;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__52148);
if(temp__5735__auto__){
var seq__52148__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__52148__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__52148__$1);
var G__52998 = cljs.core.chunk_rest(seq__52148__$1);
var G__52999 = c__4556__auto__;
var G__53000 = cljs.core.count(c__4556__auto__);
var G__53001 = (0);
seq__52148 = G__52998;
chunk__52149 = G__52999;
count__52150 = G__53000;
i__52151 = G__53001;
continue;
} else {
var it = cljs.core.first(seq__52148__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__53004 = cljs.core.next(seq__52148__$1);
var G__53005 = null;
var G__53006 = (0);
var G__53007 = (0);
seq__52148 = G__53004;
chunk__52149 = G__53005;
count__52150 = G__53006;
i__52151 = G__53007;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k52155,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__52170 = k52155;
var G__52170__$1 = (((G__52170 instanceof cljs.core.Keyword))?G__52170.fqn:null);
switch (G__52170__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k52155,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__52171){
var vec__52172 = p__52171;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52172,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52172,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__52154){
var self__ = this;
var G__52154__$1 = this;
return (new cljs.core.RecordIter((0),G__52154__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this52156,other52157){
var self__ = this;
var this52156__$1 = this;
return (((!((other52157 == null)))) && ((this52156__$1.constructor === other52157.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this52156__$1.x,other52157.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this52156__$1.y,other52157.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this52156__$1.__extmap,other52157.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__52154){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__52176 = cljs.core.keyword_identical_QMARK_;
var expr__52177 = k__4388__auto__;
if(cljs.core.truth_((pred__52176.cljs$core$IFn$_invoke$arity$2 ? pred__52176.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__52177) : pred__52176.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__52177)))){
return (new shadow.dom.Coordinate(G__52154,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__52176.cljs$core$IFn$_invoke$arity$2 ? pred__52176.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__52177) : pred__52176.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__52177)))){
return (new shadow.dom.Coordinate(self__.x,G__52154,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__52154),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__52154){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__52154,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__52162){
var extmap__4419__auto__ = (function (){var G__52192 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__52162,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__52162)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__52192);
} else {
return G__52192;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__52162),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__52162),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k52206,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__52210 = k52206;
var G__52210__$1 = (((G__52210 instanceof cljs.core.Keyword))?G__52210.fqn:null);
switch (G__52210__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k52206,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__52211){
var vec__52212 = p__52211;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52212,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52212,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__52205){
var self__ = this;
var G__52205__$1 = this;
return (new cljs.core.RecordIter((0),G__52205__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this52207,other52208){
var self__ = this;
var this52207__$1 = this;
return (((!((other52208 == null)))) && ((this52207__$1.constructor === other52208.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this52207__$1.w,other52208.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this52207__$1.h,other52208.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this52207__$1.__extmap,other52208.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__52205){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__52216 = cljs.core.keyword_identical_QMARK_;
var expr__52217 = k__4388__auto__;
if(cljs.core.truth_((pred__52216.cljs$core$IFn$_invoke$arity$2 ? pred__52216.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__52217) : pred__52216.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__52217)))){
return (new shadow.dom.Size(G__52205,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__52216.cljs$core$IFn$_invoke$arity$2 ? pred__52216.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__52217) : pred__52216.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__52217)))){
return (new shadow.dom.Size(self__.w,G__52205,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__52205),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__52205){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__52205,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__52209){
var extmap__4419__auto__ = (function (){var G__52229 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__52209,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__52209)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__52229);
} else {
return G__52229;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__52209),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__52209),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__53139 = (i + (1));
var G__53140 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__53139;
ret = G__53140;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__52242){
var vec__52243 = p__52242;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52243,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52243,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__52248 = arguments.length;
switch (G__52248) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5733__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5733__auto__)){
var child = temp__5733__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__53159 = ps;
var G__53160 = (i + (1));
el__$1 = G__53159;
i = G__53160;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__52267 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52267,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52267,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52267,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__52270_53173 = cljs.core.seq(props);
var chunk__52271_53174 = null;
var count__52272_53175 = (0);
var i__52273_53176 = (0);
while(true){
if((i__52273_53176 < count__52272_53175)){
var vec__52286_53178 = chunk__52271_53174.cljs$core$IIndexed$_nth$arity$2(null,i__52273_53176);
var k_53179 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52286_53178,(0),null);
var v_53180 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52286_53178,(1),null);
el.setAttributeNS((function (){var temp__5735__auto__ = cljs.core.namespace(k_53179);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_53179),v_53180);


var G__53183 = seq__52270_53173;
var G__53184 = chunk__52271_53174;
var G__53185 = count__52272_53175;
var G__53186 = (i__52273_53176 + (1));
seq__52270_53173 = G__53183;
chunk__52271_53174 = G__53184;
count__52272_53175 = G__53185;
i__52273_53176 = G__53186;
continue;
} else {
var temp__5735__auto___53187 = cljs.core.seq(seq__52270_53173);
if(temp__5735__auto___53187){
var seq__52270_53188__$1 = temp__5735__auto___53187;
if(cljs.core.chunked_seq_QMARK_(seq__52270_53188__$1)){
var c__4556__auto___53190 = cljs.core.chunk_first(seq__52270_53188__$1);
var G__53192 = cljs.core.chunk_rest(seq__52270_53188__$1);
var G__53193 = c__4556__auto___53190;
var G__53194 = cljs.core.count(c__4556__auto___53190);
var G__53195 = (0);
seq__52270_53173 = G__53192;
chunk__52271_53174 = G__53193;
count__52272_53175 = G__53194;
i__52273_53176 = G__53195;
continue;
} else {
var vec__52294_53199 = cljs.core.first(seq__52270_53188__$1);
var k_53200 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52294_53199,(0),null);
var v_53201 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52294_53199,(1),null);
el.setAttributeNS((function (){var temp__5735__auto____$1 = cljs.core.namespace(k_53200);
if(cljs.core.truth_(temp__5735__auto____$1)){
var ns = temp__5735__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_53200),v_53201);


var G__53207 = cljs.core.next(seq__52270_53188__$1);
var G__53208 = null;
var G__53209 = (0);
var G__53210 = (0);
seq__52270_53173 = G__53207;
chunk__52271_53174 = G__53208;
count__52272_53175 = G__53209;
i__52273_53176 = G__53210;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__52308 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52308,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52308,(1),null);
var seq__52312_53219 = cljs.core.seq(node_children);
var chunk__52314_53220 = null;
var count__52315_53221 = (0);
var i__52316_53222 = (0);
while(true){
if((i__52316_53222 < count__52315_53221)){
var child_struct_53225 = chunk__52314_53220.cljs$core$IIndexed$_nth$arity$2(null,i__52316_53222);
if((!((child_struct_53225 == null)))){
if(typeof child_struct_53225 === 'string'){
var text_53226 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_53226),child_struct_53225].join(''));
} else {
var children_53230 = shadow.dom.svg_node(child_struct_53225);
if(cljs.core.seq_QMARK_(children_53230)){
var seq__52357_53231 = cljs.core.seq(children_53230);
var chunk__52359_53232 = null;
var count__52360_53233 = (0);
var i__52361_53234 = (0);
while(true){
if((i__52361_53234 < count__52360_53233)){
var child_53239 = chunk__52359_53232.cljs$core$IIndexed$_nth$arity$2(null,i__52361_53234);
if(cljs.core.truth_(child_53239)){
node.appendChild(child_53239);


var G__53241 = seq__52357_53231;
var G__53242 = chunk__52359_53232;
var G__53243 = count__52360_53233;
var G__53244 = (i__52361_53234 + (1));
seq__52357_53231 = G__53241;
chunk__52359_53232 = G__53242;
count__52360_53233 = G__53243;
i__52361_53234 = G__53244;
continue;
} else {
var G__53245 = seq__52357_53231;
var G__53246 = chunk__52359_53232;
var G__53247 = count__52360_53233;
var G__53248 = (i__52361_53234 + (1));
seq__52357_53231 = G__53245;
chunk__52359_53232 = G__53246;
count__52360_53233 = G__53247;
i__52361_53234 = G__53248;
continue;
}
} else {
var temp__5735__auto___53251 = cljs.core.seq(seq__52357_53231);
if(temp__5735__auto___53251){
var seq__52357_53252__$1 = temp__5735__auto___53251;
if(cljs.core.chunked_seq_QMARK_(seq__52357_53252__$1)){
var c__4556__auto___53254 = cljs.core.chunk_first(seq__52357_53252__$1);
var G__53255 = cljs.core.chunk_rest(seq__52357_53252__$1);
var G__53256 = c__4556__auto___53254;
var G__53257 = cljs.core.count(c__4556__auto___53254);
var G__53258 = (0);
seq__52357_53231 = G__53255;
chunk__52359_53232 = G__53256;
count__52360_53233 = G__53257;
i__52361_53234 = G__53258;
continue;
} else {
var child_53261 = cljs.core.first(seq__52357_53252__$1);
if(cljs.core.truth_(child_53261)){
node.appendChild(child_53261);


var G__53264 = cljs.core.next(seq__52357_53252__$1);
var G__53265 = null;
var G__53266 = (0);
var G__53267 = (0);
seq__52357_53231 = G__53264;
chunk__52359_53232 = G__53265;
count__52360_53233 = G__53266;
i__52361_53234 = G__53267;
continue;
} else {
var G__53271 = cljs.core.next(seq__52357_53252__$1);
var G__53272 = null;
var G__53273 = (0);
var G__53274 = (0);
seq__52357_53231 = G__53271;
chunk__52359_53232 = G__53272;
count__52360_53233 = G__53273;
i__52361_53234 = G__53274;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_53230);
}
}


var G__53275 = seq__52312_53219;
var G__53276 = chunk__52314_53220;
var G__53277 = count__52315_53221;
var G__53278 = (i__52316_53222 + (1));
seq__52312_53219 = G__53275;
chunk__52314_53220 = G__53276;
count__52315_53221 = G__53277;
i__52316_53222 = G__53278;
continue;
} else {
var G__53281 = seq__52312_53219;
var G__53282 = chunk__52314_53220;
var G__53283 = count__52315_53221;
var G__53284 = (i__52316_53222 + (1));
seq__52312_53219 = G__53281;
chunk__52314_53220 = G__53282;
count__52315_53221 = G__53283;
i__52316_53222 = G__53284;
continue;
}
} else {
var temp__5735__auto___53286 = cljs.core.seq(seq__52312_53219);
if(temp__5735__auto___53286){
var seq__52312_53287__$1 = temp__5735__auto___53286;
if(cljs.core.chunked_seq_QMARK_(seq__52312_53287__$1)){
var c__4556__auto___53288 = cljs.core.chunk_first(seq__52312_53287__$1);
var G__53290 = cljs.core.chunk_rest(seq__52312_53287__$1);
var G__53291 = c__4556__auto___53288;
var G__53292 = cljs.core.count(c__4556__auto___53288);
var G__53293 = (0);
seq__52312_53219 = G__53290;
chunk__52314_53220 = G__53291;
count__52315_53221 = G__53292;
i__52316_53222 = G__53293;
continue;
} else {
var child_struct_53298 = cljs.core.first(seq__52312_53287__$1);
if((!((child_struct_53298 == null)))){
if(typeof child_struct_53298 === 'string'){
var text_53300 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_53300),child_struct_53298].join(''));
} else {
var children_53302 = shadow.dom.svg_node(child_struct_53298);
if(cljs.core.seq_QMARK_(children_53302)){
var seq__52404_53303 = cljs.core.seq(children_53302);
var chunk__52406_53304 = null;
var count__52407_53305 = (0);
var i__52408_53306 = (0);
while(true){
if((i__52408_53306 < count__52407_53305)){
var child_53311 = chunk__52406_53304.cljs$core$IIndexed$_nth$arity$2(null,i__52408_53306);
if(cljs.core.truth_(child_53311)){
node.appendChild(child_53311);


var G__53315 = seq__52404_53303;
var G__53316 = chunk__52406_53304;
var G__53317 = count__52407_53305;
var G__53318 = (i__52408_53306 + (1));
seq__52404_53303 = G__53315;
chunk__52406_53304 = G__53316;
count__52407_53305 = G__53317;
i__52408_53306 = G__53318;
continue;
} else {
var G__53320 = seq__52404_53303;
var G__53321 = chunk__52406_53304;
var G__53322 = count__52407_53305;
var G__53323 = (i__52408_53306 + (1));
seq__52404_53303 = G__53320;
chunk__52406_53304 = G__53321;
count__52407_53305 = G__53322;
i__52408_53306 = G__53323;
continue;
}
} else {
var temp__5735__auto___53326__$1 = cljs.core.seq(seq__52404_53303);
if(temp__5735__auto___53326__$1){
var seq__52404_53327__$1 = temp__5735__auto___53326__$1;
if(cljs.core.chunked_seq_QMARK_(seq__52404_53327__$1)){
var c__4556__auto___53328 = cljs.core.chunk_first(seq__52404_53327__$1);
var G__53329 = cljs.core.chunk_rest(seq__52404_53327__$1);
var G__53330 = c__4556__auto___53328;
var G__53331 = cljs.core.count(c__4556__auto___53328);
var G__53332 = (0);
seq__52404_53303 = G__53329;
chunk__52406_53304 = G__53330;
count__52407_53305 = G__53331;
i__52408_53306 = G__53332;
continue;
} else {
var child_53333 = cljs.core.first(seq__52404_53327__$1);
if(cljs.core.truth_(child_53333)){
node.appendChild(child_53333);


var G__53336 = cljs.core.next(seq__52404_53327__$1);
var G__53337 = null;
var G__53338 = (0);
var G__53339 = (0);
seq__52404_53303 = G__53336;
chunk__52406_53304 = G__53337;
count__52407_53305 = G__53338;
i__52408_53306 = G__53339;
continue;
} else {
var G__53340 = cljs.core.next(seq__52404_53327__$1);
var G__53341 = null;
var G__53342 = (0);
var G__53343 = (0);
seq__52404_53303 = G__53340;
chunk__52406_53304 = G__53341;
count__52407_53305 = G__53342;
i__52408_53306 = G__53343;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_53302);
}
}


var G__53346 = cljs.core.next(seq__52312_53287__$1);
var G__53347 = null;
var G__53348 = (0);
var G__53349 = (0);
seq__52312_53219 = G__53346;
chunk__52314_53220 = G__53347;
count__52315_53221 = G__53348;
i__52316_53222 = G__53349;
continue;
} else {
var G__53351 = cljs.core.next(seq__52312_53287__$1);
var G__53352 = null;
var G__53353 = (0);
var G__53354 = (0);
seq__52312_53219 = G__53351;
chunk__52314_53220 = G__53352;
count__52315_53221 = G__53353;
i__52316_53222 = G__53354;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___53362 = arguments.length;
var i__4737__auto___53363 = (0);
while(true){
if((i__4737__auto___53363 < len__4736__auto___53362)){
args__4742__auto__.push((arguments[i__4737__auto___53363]));

var G__53364 = (i__4737__auto___53363 + (1));
i__4737__auto___53363 = G__53364;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq52444){
var G__52445 = cljs.core.first(seq52444);
var seq52444__$1 = cljs.core.next(seq52444);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__52445,seq52444__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__52463 = arguments.length;
switch (G__52463) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__45600__auto___53386 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_52496){
var state_val_52497 = (state_52496[(1)]);
if((state_val_52497 === (1))){
var state_52496__$1 = state_52496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52496__$1,(2),once_or_cleanup);
} else {
if((state_val_52497 === (2))){
var inst_52481 = (state_52496[(2)]);
var inst_52482 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_52496__$1 = (function (){var statearr_52500 = state_52496;
(statearr_52500[(7)] = inst_52481);

return statearr_52500;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_52496__$1,inst_52482);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__45473__auto__ = null;
var shadow$dom$state_machine__45473__auto____0 = (function (){
var statearr_52502 = [null,null,null,null,null,null,null,null];
(statearr_52502[(0)] = shadow$dom$state_machine__45473__auto__);

(statearr_52502[(1)] = (1));

return statearr_52502;
});
var shadow$dom$state_machine__45473__auto____1 = (function (state_52496){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_52496);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e52505){var ex__45476__auto__ = e52505;
var statearr_52506_53395 = state_52496;
(statearr_52506_53395[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_52496[(4)]))){
var statearr_52508_53399 = state_52496;
(statearr_52508_53399[(1)] = cljs.core.first((state_52496[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53400 = state_52496;
state_52496 = G__53400;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
shadow$dom$state_machine__45473__auto__ = function(state_52496){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__45473__auto____0.call(this);
case 1:
return shadow$dom$state_machine__45473__auto____1.call(this,state_52496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__45473__auto____0;
shadow$dom$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__45473__auto____1;
return shadow$dom$state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_52511 = f__45601__auto__();
(statearr_52511[(6)] = c__45600__auto___53386);

return statearr_52511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
