goog.provide('dv.cljs_emotion.devcards');
var module$node_modules$polished$dist$polished_cjs=shadow.js.require("module$node_modules$polished$dist$polished_cjs", {});
cljs.core.enable_console_print_BANG_();
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"\n  Hi there. This page uses devcards to demonstrate usage of the dv.cljs-emotion library.\n  This library is a small wrapper around the emotion css-in-js JavaScript library that\n  makes it easy to use all of CSS within a react application.\n\n  The source of these cards can be found here:\n  https://github.com/dvingo/cljs-emotion/tree/master/src/dev/dv/cljs_emotion\n\n  The main API of this library is: `[defstyled keyframes global-style]`\n\n  defstyled is a wrapper around `@emotion/styled`\n  Styled is multi-arity and supports passing functions that return maps of styles, a vector of styles that\n  will be merged top down (first to last) and a map, you can also pass JavaScript objects and arrays.\n\n  This library converts between cljs and js structures, but the multi-arity capability is built into emotion already.\n  ",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),null,new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"# Use it\n\nRequire the library:\n```clojure\n(require [dv.cljs-emotion :refer [defstyled keyframes global-style]])\n```\n\nOr for reagent support:\n```clojure\n(require [dv.cljs-emotion-reagent :refer [defstyled keyframes global-style]])\n```\n\nYou can pass any number of children to defstyled:\n\n```clojure\n(defstyled sample1 :div\n  {:background-color \"RebeccaPurple\"})\n```\n\n```clojure\n(defstyled sample1 :div\n {:background-color \"RebeccaPurple\"}\n #js{:color \"yellow\"}\n (fn [props] {:border-radius 4}))\n```\n\nThis library delegates to emotion's styled API, while adding a transform layer for cljs->js data structures.\n  ",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),null,new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
dv.cljs_emotion.devcards.global_data = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on?","on?",-74017086),false], null));
dv.cljs_emotion.devcards.btn_styles = new cljs.core.PersistentArrayMap(null, 1, ["button",cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"line-height","line-height",1870784992),new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),new cljs.core.Keyword(null,"background-color","background-color",570434026),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"background-image","background-image",-1142314704),":hover",":active",new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"text-shadow","text-shadow",116733623),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),new cljs.core.Keyword(null,"font-family","font-family",-667419874),new cljs.core.Keyword(null,"margin","margin",-995903681)],["1rem",["inset 0 1px 0 white, inset 0 -1px 0 #d9d9d9,"," inset    0 0 0 1px #f2f2f2, 0 2px 4px rgba(0, 0, 0, 0.2)"].join(''),"#8c8c8c","top","all 20ms ease-out",(700),"#f2f2f2","pointer","linear-gradient(to bottom, #f2f2f2, #f2f2f2)",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"background","background",-863952629),"#f2f2f2",new cljs.core.Keyword(null,"border-color","border-color",-2059162761),"#8c8c8c",new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"inset 0 1px 0 white, inset 0 -1px 0 #d9d9d9, inset 0 0 0 1px #f2f2f2"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"inset 0 2px 3px rgba(0, 0, 0, 0.2)"], null),"9px 16px 9px","0 1px 0 rgba(255, 255, 255, 0.5)","1px solid #bfbfbf",(3),"sans-serif","16px 0 0 16px"])], null);
dv.cljs_emotion.devcards.button_styles = new cljs.core.PersistentArrayMap(null, 1, ["button",new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"padding","padding",1660304693),"1rem 2rem",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"transition","transition",765692007),"all .5s",":hover",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755)," 0px 10px 10px rgba(0,0,0,0.2)",new cljs.core.Keyword(null,"transform","transform",1381301764),"translateY(-3px)","::after",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"transform","transform",1381301764),"scaleX(1.4) scaleY(1.6)",new cljs.core.Keyword(null,"opacity","opacity",397153780),(0)], null)], null),"::after",cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"text-transform","text-transform",1685000676),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"top","top",-1856271961),new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"z-index","z-index",1892827090),new cljs.core.Keyword(null,"text-decoration","text-decoration",1836813207),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),new cljs.core.Keyword(null,"height","height",1025178622),new cljs.core.Keyword(null,"left","left",-399115937)],["uppercase","all .5s",(0),"''","100 %",(-1),"none","inline-block","absolute",(100),"100 %",(0)])], null)], null);
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"For a quick demonstration we will change some global styles on this page.\n\n  In this example we add some styles to `<button>` elements on this page.\n\n  If global styles are rendered and then on subsequent render they are not, emotion will remove those global styles\n  from the page so you can dynamically include global styles.\n```clojure\n(html\n  [:div\n  [:h2 \"Click the button to style all the <button>s on this page\"]\n  [:button {:on-click #(swap! global-data update :on? not)} \"Do it.\"]\n (when on? (global-style btn-styles))])\n```\n  ",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (data,_){
var on_QMARK_ = new cljs.core.Keyword(null,"on?","on?",-74017086).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(data));
return sablono.core.create_element("div",null,sablono.core.create_element("h2",null,"Click the button to style all the <button>s on this page"),sablono.core.create_element("button",({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(dv.cljs_emotion.devcards.global_data,cljs.core.update,new cljs.core.Keyword(null,"on?","on?",-74017086),cljs.core.not);
})}),"Do it."),(cljs.core.truth_(on_QMARK_)?sablono.interpreter.interpret(dv.cljs_emotion.global_style(dv.cljs_emotion.devcards.btn_styles)):null));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),dv.cljs_emotion.devcards.global_data,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
var className51649_51730 = "dv.cljs-emotion.devcards/sample1";
var children51650_51731 = clojure.walk.postwalk((function (x__51584__auto__){
if(cljs.core.fn_QMARK_(x__51584__auto__)){
return (function (arg__51585__auto__){
return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__51651 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__51585__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__51584__auto__.cljs$core$IFn$_invoke$arity$1 ? x__51584__auto__.cljs$core$IFn$_invoke$arity$1(G__51651) : x__51584__auto__.call(null,G__51651));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__51584__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__51584__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__51584__auto__;

}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"rebeCCApurple"], null)], null));
var children51650_51732__$1 = cljs.core.clj__GT_js(children51650_51731);
var component_type51647_51733 = goog.object.get(dv.cljs_emotion.styled_STAR_,"div");
var clss51648_51734 = component_type51647_51733.apply(component_type51647_51733,children51650_51732__$1);
goog.object.set(clss51648_51734,"displayName","dv.cljs-emotion.devcards/sample1");

dv.cljs_emotion.devcards.sample1 = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss51648_51734,className51649_51730),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss51648_51734], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"The main api is defstyled which will return react element factory - a function that accepts props and children.\n\n```clojure\n(defstyled sample1 :div\n  {:background-color \"RebeccaPurple\"})\n\n(sample1 \"Some text here\")\n```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(dv.cljs_emotion.devcards.sample1.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.sample1.cljs$core$IFn$_invoke$arity$1("Some text here") : dv.cljs_emotion.devcards.sample1.call(null,"Some text here")),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"You may find it useful to know that the `className` property is passed through to the rendered element.\n  Inspect the output in the browser devtools to confirm that it works.\n\n  Additionally you will note that the fully qualified symbol name is also added as a classname - this is soley used\n  during development time to see your components easily in the browser devtools. By default these classnames are removed\n  when `goog.DEBUG` is set to `false`. You can keep them during release builds by setting the closure constant:\n\n`dv.cljs-emotion/ADD_CLASSNAMES` to `true`\n\nor if using reagent:\n\n`dv.cljs-emotion-reagent/ADD_CLASSNAMES`\n\nI've set this var to true so these classname will show up in the release build of these devcards.\n\n```clojure\n  (defstyled sample1 :div\n    {:background-color \"RebeccaPurple\"})\n  (sample1 {:className \"TEST\"} \"Some text here\")\n```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var G__51652 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"TEST"], null);
var G__51653 = "Some text here";
return (dv.cljs_emotion.devcards.sample1.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.devcards.sample1.cljs$core$IFn$_invoke$arity$2(G__51652,G__51653) : dv.cljs_emotion.devcards.sample1.call(null,G__51652,G__51653));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
dv.cljs_emotion.devcards.mw_700 = "@media (min-width:700px)";
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"global-styles","global-styles",1792539654)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"global-styles",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Nested styles are supported - as these are part of the emotion API. Here we are applying different styles\n  for screen widths greater than 699 pixels using a breakpoint.\n\n  We also target a global class \"my-thing\" - using the :.classname notation is handled by this library and passes\n  \".my-thing\" to emotion.\n\n  Resize the width of the page to see the effect.\n\n```clojure\n(def mw-700 \"@media (min-width:700px)\")\n[:div\n [:.my-thing \"Some content\"]\n  (global-style\n    {:.my-thing {:background \"navy\" :color \"#cce\" mw-700 {:background \"black\"}}})])\n```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),sablono.core.create_element("div",null,sablono.core.create_element("div",({"className": "my-thing"}),"Some content"),sablono.interpreter.interpret(dv.cljs_emotion.global_style(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,".my-thing",".my-thing",780594527),cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"background","background",-863952629),"navy",new cljs.core.Keyword(null,"color","color",1011675173),"#cce",dv.cljs_emotion.devcards.mw_700,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"black"], null)])], null)))),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
dv.cljs_emotion.devcards.animation = dv.cljs_emotion.keyframes(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"transparent"], null),new cljs.core.Keyword(null,"to","to",192099007),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"grey"], null)], null));
dv.cljs_emotion.devcards.test_body = (function dv$cljs_emotion$devcards$test_body(p__51656){
var map__51657 = p__51656;
var map__51657__$1 = (((((!((map__51657 == null))))?(((((map__51657.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51657.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51657):map__51657);
var time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51657__$1,new cljs.core.Keyword(null,"time","time",1385887882));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"animation","animation",-1248293244),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dv.cljs_emotion.devcards.animation)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(time),"s ease-in-out infinite"].join('')], null);
});
var className51661_51735 = "dv.cljs-emotion.devcards/with-anim";
var children51662_51736 = clojure.walk.postwalk((function (x__51584__auto__){
if(cljs.core.fn_QMARK_(x__51584__auto__)){
return (function (arg__51585__auto__){
return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__51663 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__51585__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__51584__auto__.cljs$core$IFn$_invoke$arity$1 ? x__51584__auto__.cljs$core$IFn$_invoke$arity$1(G__51663) : x__51584__auto__.call(null,G__51663));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__51584__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__51584__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__51584__auto__;

}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [dv.cljs_emotion.devcards.test_body], null));
var children51662_51737__$1 = cljs.core.clj__GT_js(children51662_51736);
var component_type51659_51738 = goog.object.get(dv.cljs_emotion.styled_STAR_,"div");
var clss51660_51739 = component_type51659_51738.apply(component_type51659_51738,children51662_51737__$1);
goog.object.set(clss51660_51739,"displayName","dv.cljs-emotion.devcards/with-anim");

dv.cljs_emotion.devcards.with_anim = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss51660_51739,className51661_51735),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss51660_51739], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"keyframes","keyframes",-1437976012)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"keyframes",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Keyframe animations are supported - this is built into emotion.\n```clojure\n(def animation\n  (keyframes {:from {:background \"transparent\"}\n              :to {:background \"grey\"} } ))\n\n(defstyled with-anim :div\n  (fn [{:keys [time]}]\n    {:animation (str animation \" \" time \"s ease-in-out infinite\")}))\n\n  (with-anim {:time (:time @a)} \"Some text here\")]\n  ```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (a,o){
return sablono.core.create_element("div",null,sablono.core.create_element("p",null,"animation time: ",sablono.interpreter.interpret(new cljs.core.Keyword(null,"time","time",1385887882).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(a)))," seconds"),sablono.core.create_element("button",({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.update,new cljs.core.Keyword(null,"time","time",1385887882),cljs.core.inc);
})}),"inc"),sablono.core.create_element("button",({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.update,new cljs.core.Keyword(null,"time","time",1385887882),cljs.core.dec);
})}),"dec"),sablono.interpreter.interpret((function (){var G__51664 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"time","time",1385887882).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(a))], null);
var G__51665 = "Some text here";
return (dv.cljs_emotion.devcards.with_anim.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.devcards.with_anim.cljs$core$IFn$_invoke$arity$2(G__51664,G__51665) : dv.cljs_emotion.devcards.with_anim.call(null,G__51664,G__51665));
})()));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"time","time",1385887882),(1)], null),new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
var className51668_51740 = "dv.cljs-emotion.devcards/with-anim2";
var children51669_51741 = clojure.walk.postwalk((function (x__51584__auto__){
if(cljs.core.fn_QMARK_(x__51584__auto__)){
return (function (arg__51585__auto__){
return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__51670 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__51585__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__51584__auto__.cljs$core$IFn$_invoke$arity$1 ? x__51584__auto__.cljs$core$IFn$_invoke$arity$1(G__51670) : x__51584__auto__.call(null,G__51670));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__51584__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__51584__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__51584__auto__;

}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (p__51671){
var map__51672 = p__51671;
var map__51672__$1 = (((((!((map__51672 == null))))?(((((map__51672.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51672.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51672):map__51672);
var amt = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__51672__$1,new cljs.core.Keyword(null,"amt","amt",-1785711538),(20));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"animation","animation",-1248293244),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dv.cljs_emotion.keyframes(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),module$node_modules$polished$dist$polished_cjs.adjustHue(amt,"yellow")], null),new cljs.core.Keyword(null,"to","to",192099007),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"yellow"], null)], null)))," 2s ease-in-out infinite"].join('')], null);
})], null));
var children51669_51742__$1 = cljs.core.clj__GT_js(children51669_51741);
var component_type51666_51743 = goog.object.get(dv.cljs_emotion.styled_STAR_,"div");
var clss51667_51744 = component_type51666_51743.apply(component_type51666_51743,children51669_51742__$1);
goog.object.set(clss51667_51744,"displayName","dv.cljs-emotion.devcards/with-anim2");

dv.cljs_emotion.devcards.with_anim2 = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss51667_51744,className51668_51740),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss51667_51744], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"keyframes2","keyframes2",-701299326)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"keyframes2",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Animation can be defined dynamically as well - in the render.\n\n  This example also shows how you can pass any props to the underlying component - in this case onClick.\n\n  ```clojure\n  (defstyled with-anim2 :div\n    (fn [{:keys [amt] :or {amt 20}}]\n      {:animation\n        (str (keyframes\n          {:from {:background (p/adjustHue amt \"yellow\")}\n           :to   {:background \"yellow\"}})\n            \" 2s ease-in-out infinite\")}))\n\n  (html\n  [:div\n    [:p \"hue: \" (p/adjustHue (:amt @a) \"yellow\")]\n    [:button {:on-click #(swap! a update :amt (partial + 10))} \"inc\"]\n    [:button {:on-click #(swap! a update :amt (partial - 10))} \"dec\"]\n    (with-anim2 {:amt     (:amt @a)\n                 :onClick #(js/console.log \"ON CLICK\")} \"Some text here\")])\n  ```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (a,o){
return sablono.core.create_element("div",null,sablono.core.create_element("p",null,"hue: ",sablono.interpreter.interpret(module$node_modules$polished$dist$polished_cjs.adjustHue(new cljs.core.Keyword(null,"amt","amt",-1785711538).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(a)),"yellow"))),sablono.core.create_element("button",({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.update,new cljs.core.Keyword(null,"amt","amt",-1785711538),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,(10)));
})}),"inc"),sablono.core.create_element("button",({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.update,new cljs.core.Keyword(null,"amt","amt",-1785711538),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._,(10)));
})}),"dec"),sablono.interpreter.interpret((function (){var G__51674 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"amt","amt",-1785711538),new cljs.core.Keyword(null,"amt","amt",-1785711538).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(a)),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),(function (){
return console.log("ON CLICK");
})], null);
var G__51675 = "Some text here";
return (dv.cljs_emotion.devcards.with_anim2.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.devcards.with_anim2.cljs$core$IFn$_invoke$arity$2(G__51674,G__51675) : dv.cljs_emotion.devcards.with_anim2.call(null,G__51674,G__51675));
})()));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"amt","amt",-1785711538),(20)], null),new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
var className51678_51745 = "dv.cljs-emotion.devcards/multi";
var children51679_51746 = clojure.walk.postwalk((function (x__51584__auto__){
if(cljs.core.fn_QMARK_(x__51584__auto__)){
return (function (arg__51585__auto__){
return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__51680 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__51585__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__51584__auto__.cljs$core$IFn$_invoke$arity$1 ? x__51584__auto__.cljs$core$IFn$_invoke$arity$1(G__51680) : x__51584__auto__.call(null,G__51680));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__51584__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__51584__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__51584__auto__;

}
}
}),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"blue"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"yellow"], null),({"borderRadius": (4)}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, ["border","1px solid grey"], null)], null),(function (_){
return new cljs.core.PersistentArrayMap(null, 1, [":hover",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"white"], null)], null);
})], null));
var children51679_51747__$1 = cljs.core.clj__GT_js(children51679_51746);
var component_type51676_51748 = goog.object.get(dv.cljs_emotion.styled_STAR_,"div");
var clss51677_51749 = component_type51676_51748.apply(component_type51676_51748,children51679_51747__$1);
goog.object.set(clss51677_51749,"displayName","dv.cljs-emotion.devcards/multi");

dv.cljs_emotion.devcards.multi = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss51677_51749,className51678_51745),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss51677_51749], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Multiple children are handled just like emotion:\n```clojure\n(defstyled multi :div\n  {:background \"blue\"}\n  {:color \"yellow\"}\n  #js{\"borderRadius\" 4}\n  [{\"border\" \"1px solid grey\"}]\n  (fn [_] {\":hover\" {:background \"white\"}}))\n\n(multi \"HELLO\")\n```\n",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(dv.cljs_emotion.devcards.multi.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.multi.cljs$core$IFn$_invoke$arity$1("HELLO") : dv.cljs_emotion.devcards.multi.call(null,"HELLO")),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
var className51683_51750 = "dv.cljs-emotion.devcards/multi2";
var children51684_51751 = clojure.walk.postwalk((function (x__51584__auto__){
if(cljs.core.fn_QMARK_(x__51584__auto__)){
return (function (arg__51585__auto__){
return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__51685 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__51585__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__51584__auto__.cljs$core$IFn$_invoke$arity$1 ? x__51584__auto__.cljs$core$IFn$_invoke$arity$1(G__51685) : x__51584__auto__.call(null,G__51685));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__51584__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__51584__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__51584__auto__;

}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"blue"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"yellow"], null),({"borderRadius": (4)}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, ["border","1px solid grey"], null)], null),(function (_){
return new cljs.core.PersistentArrayMap(null, 1, [":hover",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"white"], null)], null);
})], null)], null));
var children51684_51752__$1 = cljs.core.clj__GT_js(children51684_51751);
var component_type51681_51753 = goog.object.get(dv.cljs_emotion.styled_STAR_,"div");
var clss51682_51754 = component_type51681_51753.apply(component_type51681_51753,children51684_51752__$1);
goog.object.set(clss51682_51754,"displayName","dv.cljs-emotion.devcards/multi2");

dv.cljs_emotion.devcards.multi2 = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss51682_51754,className51683_51750),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss51682_51754], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Anywhere an array is passed emotion will merge those styles, so you can also\n  pass multiple styles as a vector/array:\n\n```clojure\n(defstyled multi2 :div\n  [{:background \"blue\"}\n  {:color \"yellow\"}\n  #js{\"borderRadius\" 4}\n  [{\"border\" \"1px solid grey\"}]\n  (fn [_] {\":hover\" {:background \"white\"}})])\n\n(multi2 \"HELLO\")\n```\n",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(dv.cljs_emotion.devcards.multi2.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.multi2.cljs$core$IFn$_invoke$arity$1("HELLO") : dv.cljs_emotion.devcards.multi2.call(null,"HELLO")),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
var className51688_51755 = "dv.cljs-emotion.devcards/a-fn";
var children51689_51756 = clojure.walk.postwalk((function (x__51584__auto__){
if(cljs.core.fn_QMARK_(x__51584__auto__)){
return (function (arg__51585__auto__){
return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__51690 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__51585__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__51584__auto__.cljs$core$IFn$_invoke$arity$1 ? x__51584__auto__.cljs$core$IFn$_invoke$arity$1(G__51690) : x__51584__auto__.call(null,G__51690));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__51584__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__51584__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__51584__auto__;

}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (p__51691){
var map__51692 = p__51691;
var map__51692__$1 = (((((!((map__51692 == null))))?(((((map__51692.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51692.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51692):map__51692);
var my_padding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51692__$1,new cljs.core.Keyword(null,"my-padding","my-padding",1389925511));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"padding","padding",1660304693),my_padding], null);
})], null));
var children51689_51757__$1 = cljs.core.clj__GT_js(children51689_51756);
var component_type51686_51758 = goog.object.get(dv.cljs_emotion.styled_STAR_,"button");
var clss51687_51759 = component_type51686_51758.apply(component_type51686_51758,children51689_51757__$1);
goog.object.set(clss51687_51759,"displayName","dv.cljs-emotion.devcards/a-fn");

dv.cljs_emotion.devcards.a_fn = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss51687_51759,className51688_51755),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss51687_51759], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Any props you pass to the component at render time are converted to cljs data\n  structures via `js->clj` and then passed to any functions in defstyled. The output of your\n  function is then passed to `clj->js` and on to emotion.\n```clojure\n(defstyled a-fn :button\n  (fn [{:keys [my-padding]}]\n    {:padding my-padding}))\n\n  (a-fn\n    {:my-padding 20 :onClick #(js/console.log \"clicked\")\n     :another-key 5} \"This is a button\")\n```\n  ",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var G__51694 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"my-padding","my-padding",1389925511),(20),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),(function (){
return console.log("clicked");
}),new cljs.core.Keyword(null,"another-key","another-key",1757915937),(5)], null);
var G__51695 = "This is a button";
return (dv.cljs_emotion.devcards.a_fn.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.devcards.a_fn.cljs$core$IFn$_invoke$arity$2(G__51694,G__51695) : dv.cljs_emotion.devcards.a_fn.call(null,G__51694,G__51695));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
var className51698_51760 = "dv.cljs-emotion.devcards/flex";
var children51699_51761 = clojure.walk.postwalk((function (x__51584__auto__){
if(cljs.core.fn_QMARK_(x__51584__auto__)){
return (function (arg__51585__auto__){
return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__51700 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__51585__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__51584__auto__.cljs$core$IFn$_invoke$arity$1 ? x__51584__auto__.cljs$core$IFn$_invoke$arity$1(G__51700) : x__51584__auto__.call(null,G__51700));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__51584__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__51584__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__51584__auto__;

}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex-wrap","flex-wrap",455413707),"wrap",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"space-evenly"], null)], null));
var children51699_51762__$1 = cljs.core.clj__GT_js(children51699_51761);
var component_type51696_51763 = goog.object.get(dv.cljs_emotion.styled_STAR_,"div");
var clss51697_51764 = component_type51696_51763.apply(component_type51696_51763,children51699_51762__$1);
goog.object.set(clss51697_51764,"displayName","dv.cljs-emotion.devcards/flex");

dv.cljs_emotion.devcards.flex = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss51697_51764,className51698_51760),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss51697_51764], null));
var className51703_51765 = "dv.cljs-emotion.devcards/box";
var children51704_51766 = clojure.walk.postwalk((function (x__51584__auto__){
if(cljs.core.fn_QMARK_(x__51584__auto__)){
return (function (arg__51585__auto__){
return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__51705 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__51585__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__51584__auto__.cljs$core$IFn$_invoke$arity$1 ? x__51584__auto__.cljs$core$IFn$_invoke$arity$1(G__51705) : x__51584__auto__.call(null,G__51705));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__51584__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__51584__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__51584__auto__;

}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"width","width",-384071477),"20%",new cljs.core.Keyword(null,"padding","padding",1660304693),"1rem 0",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"margin","margin",-995903681),"1rem",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center",new cljs.core.Keyword(null,"background","background",-863952629),"palEvIoletrEd"], null)], null));
var children51704_51767__$1 = cljs.core.clj__GT_js(children51704_51766);
var component_type51701_51768 = goog.object.get(dv.cljs_emotion.styled_STAR_,"div");
var clss51702_51769 = component_type51701_51768.apply(component_type51701_51768,children51704_51767__$1);
goog.object.set(clss51702_51769,"displayName","dv.cljs-emotion.devcards/box");

dv.cljs_emotion.devcards.box = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss51702_51769,className51703_51765),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss51702_51769], null));
var className51708_51770 = "dv.cljs-emotion.devcards/box2";
var children51709_51771 = clojure.walk.postwalk((function (x__51584__auto__){
if(cljs.core.fn_QMARK_(x__51584__auto__)){
return (function (arg__51585__auto__){
return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__51710 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg__51585__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x__51584__auto__.cljs$core$IFn$_invoke$arity$1 ? x__51584__auto__.cljs$core$IFn$_invoke$arity$1(G__51710) : x__51584__auto__.call(null,G__51710));
})()));
});
} else {
if(cljs.core.map_QMARK_(x__51584__auto__)){
return dv.cljs_emotion.camelize_keys(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x__51584__auto__,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return x__51584__auto__;

}
}
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"user-select","user-select",-346451650),"none",new cljs.core.Keyword(null,"background","background",-863952629),module$node_modules$polished$dist$polished_cjs.lighten(0.2,"palevioletred"),new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",":hover",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),module$node_modules$polished$dist$polished_cjs.darken(0.2,"palevioletred")], null),":active",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"background","background",-863952629),module$node_modules$polished$dist$polished_cjs.darken(0.4,"palevioletred"),new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"4px 4px lightgrey"], null)], null)], null));
var children51709_51772__$1 = cljs.core.clj__GT_js(children51709_51771);
var component_type51706_51773 = ((typeof dv.cljs_emotion.devcards.box === 'string')?goog.object.get(dv.cljs_emotion.styled_STAR_,dv.cljs_emotion.devcards.box):(((dv.cljs_emotion.devcards.box instanceof cljs.core.Keyword))?goog.object.get(dv.cljs_emotion.styled_STAR_,"box"):(cljs.core.truth_(new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.box)))?dv.cljs_emotion.styled_STAR_(new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.box))):dv.cljs_emotion.styled_STAR_(dv.cljs_emotion.devcards.box)
)));
var clss51707_51774 = component_type51706_51773.apply(component_type51706_51773,children51709_51772__$1);
goog.object.set(clss51707_51774,"displayName","dv.cljs-emotion.devcards/box2");

dv.cljs_emotion.devcards.box2 = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss51707_51774,className51708_51770),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss51707_51774], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"flex-card","flex-card",-1954027863)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"flex-card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Here is a somewhat larger example, showing the extension feature of emotion to override styles.\n\n  This example using the polished library as well.\n\n```clojure\n(defstyled flex :div\n  {:display         \"flex\"\n   :flex-wrap       \"wrap\"\n   :justify-content \"space-evenly\"})\n\n(defstyled box :div\n  {:width           \"20%\"\n   :padding         \"1rem 0\"\n   :display         \"flex\"\n   :margin          \"1rem\"\n   :justify-content \"center\"\n   :background      \"palEvIoletrEd\"})\n\n\n(defstyled box2 box\n  {:border-radius \"4px\"\n   :user-select   \"none\"\n   :background    (p/lighten 0.2 \"palevioletred\")\n   :cursor        \"pointer\"\n   \":hover\"       {:background (darken 0.2 \"palevioletred\")}\n   \":active\"      {:background (darken 0.4 \"palevioletred\")\n                   :box-shadow \"4px 4px lightgrey\"}})\n\n(flex (box \"box\") (box \"box\") (box \"box\") (box2 \"box2\") (box2 \"box2\") (box \"box\") (box \"box\") (box2 \"box2\") (box \"box\")))\n```\n",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var G__51711 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__51712 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__51713 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__51714 = (dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1("box2") : dv.cljs_emotion.devcards.box2.call(null,"box2"));
var G__51715 = (dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1("box2") : dv.cljs_emotion.devcards.box2.call(null,"box2"));
var G__51716 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__51717 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__51718 = (dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1("box2") : dv.cljs_emotion.devcards.box2.call(null,"box2"));
var G__51719 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
return (dv.cljs_emotion.devcards.flex.cljs$core$IFn$_invoke$arity$9 ? dv.cljs_emotion.devcards.flex.cljs$core$IFn$_invoke$arity$9(G__51711,G__51712,G__51713,G__51714,G__51715,G__51716,G__51717,G__51718,G__51719) : dv.cljs_emotion.devcards.flex.call(null,G__51711,G__51712,G__51713,G__51714,G__51715,G__51716,G__51717,G__51718,G__51719));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"update-global-styles","update-global-styles",1487171421)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"update-global-styles",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"\n  This example changes the body background of this page's body color.\n  ```clojure\n  [:div\n         [:label \"Input a color for the background color:\"]\n         [:input {:value bg :on-change #(swap! a assoc :bg (-> % .-target .-value))}]\n         (global-style {:body {:background bg}})]\n   ```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (a,_){
var map__51721 = cljs.core.deref(a);
var map__51721__$1 = (((((!((map__51721 == null))))?(((((map__51721.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51721.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51721):map__51721);
var bg = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51721__$1,new cljs.core.Keyword(null,"bg","bg",-206688421));
return sablono.core.create_element("div",null,sablono.core.create_element("label",null,"Input a color for the background color:"),sablono.interpreter.create_element("input",({"value": bg, "onChange": (function (p1__51720_SHARP_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),p1__51720_SHARP_.target.value);
})})),sablono.interpreter.interpret(dv.cljs_emotion.global_style(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),bg], null)], null))));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bg","bg",-206688421),"#cce"], null),new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
dv.cljs_emotion.devcards.start_bg = "#eeaabb";
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"update-card-bg-styles","update-card-bg-styles",-771594595)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"update-card-bg-styles",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"\n  This example changes the background color of this card.\n  ```clojure\n  (let [{:keys [bg]} @a\n          cls :.my-card]\n      (html\n        [:div\n         [:label \"Input a color for the background:\"]\n         [:input {:value bg :on-change #(swap! a assoc :bg (-> % .-target .-value))}]\n         [:button {:on-click #(swap! a assoc :bg start-bg)} \"reset\"]\n         [:button\n          {:on-click\n           #(swap! a assoc :bg (p/lighten 0.08 bg))} \"lighten\"]\n\n         [:button\n          {:on-click\n           #(swap! a assoc :bg (p/darken 0.08 bg))} \"darken\"]\n         (global-style {cls {:background bg}})]))\n   ```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (a,_){
var map__51726 = cljs.core.deref(a);
var map__51726__$1 = (((((!((map__51726 == null))))?(((((map__51726.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51726.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51726):map__51726);
var bg = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51726__$1,new cljs.core.Keyword(null,"bg","bg",-206688421));
var cls = new cljs.core.Keyword(null,".my-card",".my-card",1656982961);
return sablono.core.create_element("div",null,sablono.core.create_element("label",null,"Input a color for the background:"),sablono.interpreter.create_element("input",({"value": bg, "onChange": (function (p1__51725_SHARP_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),p1__51725_SHARP_.target.value);
})})),sablono.core.create_element("button",({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),dv.cljs_emotion.devcards.start_bg);
})}),"reset"),sablono.core.create_element("button",({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),module$node_modules$polished$dist$polished_cjs.lighten(0.08,bg));
})}),"lighten"),sablono.core.create_element("button",({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),module$node_modules$polished$dist$polished_cjs.darken(0.08,bg));
})}),"darken"),sablono.interpreter.interpret(dv.cljs_emotion.global_style(cljs.core.PersistentArrayMap.createAsIfByAssoc([cls,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),bg], null)]))));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bg","bg",-206688421),dv.cljs_emotion.devcards.start_bg], null),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"classname","classname",777390796),"my-card"], null)], null));
})], null));
dv.cljs_emotion.devcards.main = (function dv$cljs_emotion$devcards$main(){
return devcards.core.start_devcard_ui_BANG__STAR_.cljs$core$IFn$_invoke$arity$0();
});
goog.exportSymbol('dv.cljs_emotion.devcards.main', dv.cljs_emotion.devcards.main);

//# sourceMappingURL=dv.cljs_emotion.devcards.js.map
