// Compiled by ClojureScript 1.10.339 {}
goog.provide('rui.forms.components');
goog.require('cljs.core');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('ccn.core');
goog.require('re_frame.core');
goog.require('rui.buttons');
goog.require('rui.forms.core');
goog.require('rui.forms.events');
rui.forms.components.field__GT_twbs_class = (function rui$forms$components$field__GT_twbs_class(field){
var G__30249 = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(field);
var G__30249__$1 = (((G__30249 instanceof cljs.core.Keyword))?G__30249.fqn:null);
switch (G__30249__$1) {
case "initial":
return null;

break;
case "invalid":
return "is-invalid";

break;
case "valid":
return "is-valid";

break;
default:
return null;

}
});
rui.forms.components.form_errors = (function rui$forms$components$form_errors(messages){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.form-errors.invalid-feedback","div.form-errors.invalid-feedback",-104610415),(function (){var iter__4324__auto__ = (function rui$forms$components$form_errors_$_iter__30251(s__30252){
return (new cljs.core.LazySeq(null,(function (){
var s__30252__$1 = s__30252;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__30252__$1);
if(temp__5457__auto__){
var s__30252__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__30252__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__30252__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__30254 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__30253 = (0);
while(true){
if((i__30253 < size__4323__auto__)){
var vec__30255 = cljs.core._nth.call(null,c__4322__auto__,i__30253);
var message = cljs.core.nth.call(null,vec__30255,(0),null);
var i = cljs.core.nth.call(null,vec__30255,(1),null);
cljs.core.chunk_append.call(null,b__30254,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.bem.call(null,"form-errors","error",cljs.core.PersistentVector.EMPTY)], null),message], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),goog.string.format("%s-%s",message,i)], null)));

var G__30261 = (i__30253 + (1));
i__30253 = G__30261;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__30254),rui$forms$components$form_errors_$_iter__30251.call(null,cljs.core.chunk_rest.call(null,s__30252__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__30254),null);
}
} else {
var vec__30258 = cljs.core.first.call(null,s__30252__$2);
var message = cljs.core.nth.call(null,vec__30258,(0),null);
var i = cljs.core.nth.call(null,vec__30258,(1),null);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.bem.call(null,"form-errors","error",cljs.core.PersistentVector.EMPTY)], null),message], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),goog.string.format("%s-%s",message,i)], null)),rui$forms$components$form_errors_$_iter__30251.call(null,cljs.core.rest.call(null,s__30252__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4324__auto__.call(null,cljs.core.zipmap.call(null,messages,cljs.core.range.call(null)));
})()], null);
});
rui.forms.components.can_show_errors_QMARK_ = (function rui$forms$components$can_show_errors_QMARK_(field,errors){
return ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"initial","initial",1854648214),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(field))) && (cljs.core.seq.call(null,errors)));
});
/**
 * Bare radio input that renders just a div with an input type radio and label. Don't use it directly.
 */
rui.forms.components.radio_input_element = (function rui$forms$components$radio_input_element(p__30262){
var map__30263 = p__30262;
var map__30263__$1 = ((((!((map__30263 == null)))?(((((map__30263.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30263.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30263):map__30263);
var form = cljs.core.get.call(null,map__30263__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var field_id = cljs.core.get.call(null,map__30263__$1,new cljs.core.Keyword(null,"field-id","field-id",-353751335));
var choice = cljs.core.get.call(null,map__30263__$1,new cljs.core.Keyword(null,"choice","choice",-1375170727));
var disabled_QMARK_ = cljs.core.get.call(null,map__30263__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var on_change = cljs.core.get.call(null,map__30263__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var checked_QMARK_ = cljs.core.get.call(null,map__30263__$1,new cljs.core.Keyword(null,"checked?","checked?",2024809091));
var field = cljs.core.get.call(null,map__30263__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var modifiers = cljs.core.get.call(null,map__30263__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834));
var label = cljs.core.get.call(null,map__30263__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__30263__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var radio_name = cljs.core.get.call(null,map__30263__$1,new cljs.core.Keyword(null,"radio-name","radio-name",771897205));
var chosen_value_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-check",(cljs.core.truth_(disabled_QMARK_)?"disabled":null),ccn.core.bem.call(null,"radio",cljs.core.concat.call(null,modifiers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [((chosen_value_QMARK_)?rui.forms.core.field_state.call(null,form,field_id):null)], null))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-check-input",((chosen_value_QMARK_)?rui.forms.components.field__GT_twbs_class.call(null,field):null)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),radio_name,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice),new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK_], null)], null),label], null);
});
/**
 * Radio input field with all functionalities like: updating value, showing an error, ...
 * Required parameters:
 * - `form` a form from the state
 * - `field-id` field is as a keyword
 * - `choices` a all possible values of the radio, a sequence of maps with `:label` and `:value` keys
 * Optional parameters:
 * - `modifiers` a CSS modifiers, a sequence of strings
 * - `component-class-name` a string that is added to 'form-group' Bootstrap element
 * - `renderer` a custom radio renderer, Reagent component that accepts a hashmap with following keys:
 *    id, field, radio-name, choice, on-change, checked?, disabled?, label, modifiers, form, field-id, input-el
 */
rui.forms.components.radio = (function rui$forms$components$radio(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30276 = arguments.length;
var i__4532__auto___30277 = (0);
while(true){
if((i__4532__auto___30277 < len__4531__auto___30276)){
args__4534__auto__.push((arguments[i__4532__auto___30277]));

var G__30278 = (i__4532__auto___30277 + (1));
i__4532__auto___30277 = G__30278;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.radio.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.radio.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,choices,p__30269){
var map__30270 = p__30269;
var map__30270__$1 = ((((!((map__30270 == null)))?(((((map__30270.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30270.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30270):map__30270);
var modifiers = cljs.core.get.call(null,map__30270__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834));
var component_class_name = cljs.core.get.call(null,map__30270__$1,new cljs.core.Keyword(null,"component-class-name","component-class-name",1044506625));
var renderer = cljs.core.get.call(null,map__30270__$1,new cljs.core.Keyword(null,"renderer","renderer",336841071));
var field = field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form));
var errors = field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form));
var on_change = ((function (field,errors,map__30270,map__30270__$1,modifiers,component_class_name,renderer){
return (function (was_keyword_QMARK_,event){
rui.forms.core.input_on_change_BANG_.call(null,form,field_id,(cljs.core.truth_(was_keyword_QMARK_)?cljs.core.keyword:cljs.core.identity),event);

rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

return event.preventDefault();
});})(field,errors,map__30270,map__30270__$1,modifiers,component_class_name,renderer))
;
var radio_name = rui.forms.core.gen_field_id.call(null,form,field_id);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group","radio",component_class_name)], null),(function (){var iter__4324__auto__ = ((function (field,errors,on_change,radio_name,map__30270,map__30270__$1,modifiers,component_class_name,renderer){
return (function rui$forms$components$iter__30272(s__30273){
return (new cljs.core.LazySeq(null,((function (field,errors,on_change,radio_name,map__30270,map__30270__$1,modifiers,component_class_name,renderer){
return (function (){
var s__30273__$1 = s__30273;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__30273__$1);
if(temp__5457__auto__){
var s__30273__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__30273__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__30273__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__30275 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__30274 = (0);
while(true){
if((i__30274 < size__4323__auto__)){
var choice = cljs.core._nth.call(null,c__4322__auto__,i__30274);
cljs.core.chunk_append.call(null,b__30275,(function (){var id = rui.forms.core.gen_field_id.call(null,form,cljs.core.name.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,field_id)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice))].join(''))].join('')));
var disabled_QMARK_ = new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181).cljs$core$IFn$_invoke$arity$1(choice) === true;
var checked_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice))) || ((((new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field) == null)) && (new cljs.core.Keyword(null,"checked?","checked?",2024809091).cljs$core$IFn$_invoke$arity$1(choice) === true))));
var label = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"form-check-label",new cljs.core.Keyword(null,"for","for",-1323786319),id], null),new cljs.core.Keyword(null,"label","label",1718410804).cljs$core$IFn$_invoke$arity$1(choice)], null);
var input_opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"checked?","checked?",2024809091),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"modifiers","modifiers",50378834),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"radio-name","radio-name",771897205),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword(null,"field-id","field-id",-353751335),new cljs.core.Keyword(null,"choice","choice",-1375170727),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181)],[checked_QMARK_,field,modifiers,id,radio_name,form,field_id,choice,cljs.core.partial.call(null,on_change,(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice) instanceof cljs.core.Keyword)),disabled_QMARK_]);
var input_el = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.radio_input_element,cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),(cljs.core.truth_(renderer)?null:label)], null))], null);
if(!((renderer == null))){
return cljs.core.with_meta.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [renderer,cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input-el","input-el",1688931956),input_el], null))], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice)], null));
} else {
return cljs.core.with_meta.call(null,input_el,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice)], null));
}
})());

var G__30279 = (i__30274 + (1));
i__30274 = G__30279;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__30275),rui$forms$components$iter__30272.call(null,cljs.core.chunk_rest.call(null,s__30273__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__30275),null);
}
} else {
var choice = cljs.core.first.call(null,s__30273__$2);
return cljs.core.cons.call(null,(function (){var id = rui.forms.core.gen_field_id.call(null,form,cljs.core.name.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,field_id)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice))].join(''))].join('')));
var disabled_QMARK_ = new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181).cljs$core$IFn$_invoke$arity$1(choice) === true;
var checked_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice))) || ((((new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field) == null)) && (new cljs.core.Keyword(null,"checked?","checked?",2024809091).cljs$core$IFn$_invoke$arity$1(choice) === true))));
var label = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"form-check-label",new cljs.core.Keyword(null,"for","for",-1323786319),id], null),new cljs.core.Keyword(null,"label","label",1718410804).cljs$core$IFn$_invoke$arity$1(choice)], null);
var input_opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"checked?","checked?",2024809091),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"modifiers","modifiers",50378834),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"radio-name","radio-name",771897205),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword(null,"field-id","field-id",-353751335),new cljs.core.Keyword(null,"choice","choice",-1375170727),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181)],[checked_QMARK_,field,modifiers,id,radio_name,form,field_id,choice,cljs.core.partial.call(null,on_change,(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice) instanceof cljs.core.Keyword)),disabled_QMARK_]);
var input_el = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.radio_input_element,cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),(cljs.core.truth_(renderer)?null:label)], null))], null);
if(!((renderer == null))){
return cljs.core.with_meta.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [renderer,cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input-el","input-el",1688931956),input_el], null))], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice)], null));
} else {
return cljs.core.with_meta.call(null,input_el,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice)], null));
}
})(),rui$forms$components$iter__30272.call(null,cljs.core.rest.call(null,s__30273__$2)));
}
} else {
return null;
}
break;
}
});})(field,errors,on_change,radio_name,map__30270,map__30270__$1,modifiers,component_class_name,renderer))
,null,null));
});})(field,errors,on_change,radio_name,map__30270,map__30270__$1,modifiers,component_class_name,renderer))
;
return iter__4324__auto__.call(null,choices);
})(),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field,errors))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,errors], null):null)], null);
});

rui.forms.components.radio.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.radio.cljs$lang$applyTo = (function (seq30265){
var G__30266 = cljs.core.first.call(null,seq30265);
var seq30265__$1 = cljs.core.next.call(null,seq30265);
var G__30267 = cljs.core.first.call(null,seq30265__$1);
var seq30265__$2 = cljs.core.next.call(null,seq30265__$1);
var G__30268 = cljs.core.first.call(null,seq30265__$2);
var seq30265__$3 = cljs.core.next.call(null,seq30265__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30266,G__30267,G__30268,seq30265__$3);
});

rui.forms.components.checkbox = (function rui$forms$components$checkbox(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30287 = arguments.length;
var i__4532__auto___30288 = (0);
while(true){
if((i__4532__auto___30288 < len__4531__auto___30287)){
args__4534__auto__.push((arguments[i__4532__auto___30288]));

var G__30289 = (i__4532__auto___30288 + (1));
i__4532__auto___30288 = G__30289;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.checkbox.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.checkbox.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__30284){
var map__30285 = p__30284;
var map__30285__$1 = ((((!((map__30285 == null)))?(((((map__30285.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30285.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30285):map__30285);
var children = cljs.core.get.call(null,map__30285__$1,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.PersistentVector.EMPTY);
var modifiers = cljs.core.get.call(null,map__30285__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__30285__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var field = field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form));
var active_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field));
var errors = field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form));
var on_change = ((function (field,active_QMARK_,errors,map__30285,map__30285__$1,children,modifiers,attrs){
return (function (event){
re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rui::forms","forms-input-changed","rui::forms/forms-input-changed",-943107654),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(form),field_id,event.target.checked], null));

return rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);
});})(field,active_QMARK_,errors,map__30285,map__30285__$1,children,modifiers,attrs))
;
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-check","form-group",ccn.core.bem.call(null,"checkbox",cljs.core.concat.call(null,modifiers,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((active_QMARK_)?"active":null),rui.forms.core.field_state.call(null,form,field_id)], null))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-check-input",rui.forms.components.field__GT_twbs_class.call(null,field)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change,new cljs.core.Keyword(null,"checked","checked",-50955819),active_QMARK_], null),attrs)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-check-label"], null),label], null)], null),cljs.core.conj.call(null,children,(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field,errors))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,errors], null):null)));
});

rui.forms.components.checkbox.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.checkbox.cljs$lang$applyTo = (function (seq30280){
var G__30281 = cljs.core.first.call(null,seq30280);
var seq30280__$1 = cljs.core.next.call(null,seq30280);
var G__30282 = cljs.core.first.call(null,seq30280__$1);
var seq30280__$2 = cljs.core.next.call(null,seq30280__$1);
var G__30283 = cljs.core.first.call(null,seq30280__$2);
var seq30280__$3 = cljs.core.next.call(null,seq30280__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30281,G__30282,G__30283,seq30280__$3);
});

rui.forms.components.select = (function rui$forms$components$select(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30308 = arguments.length;
var i__4532__auto___30309 = (0);
while(true){
if((i__4532__auto___30309 < len__4531__auto___30308)){
args__4534__auto__.push((arguments[i__4532__auto___30309]));

var G__30310 = (i__4532__auto___30309 + (1));
i__4532__auto___30309 = G__30310;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((4) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((4)),(0),null)):null);
return rui.forms.components.select.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4535__auto__);
});

rui.forms.components.select.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,value_label_pairs,p__30295){
var map__30296 = p__30295;
var map__30296__$1 = ((((!((map__30296 == null)))?(((((map__30296.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30296.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30296):map__30296);
var children = cljs.core.get.call(null,map__30296__$1,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.PersistentVector.EMPTY);
var modifiers = cljs.core.get.call(null,map__30296__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__30296__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.call(null,map__30296__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153),cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.call(null,map__30296__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var field = field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form));
var active_QMARK_ = !((new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field) == null));
var errors = field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form));
var on_change = ((function (field,active_QMARK_,errors,map__30296,map__30296__$1,children,modifiers,attrs,label_attrs,twbs_modifiers){
return (function (event){
re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rui::forms","forms-input-changed","rui::forms/forms-input-changed",-943107654),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(form),field_id,event.target.value], null));

return rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);
});})(field,active_QMARK_,errors,map__30296,map__30296__$1,children,modifiers,attrs,label_attrs,twbs_modifiers))
;
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"select",cljs.core.concat.call(null,modifiers,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((active_QMARK_)?"active":null),rui.forms.core.field_state.call(null,form,field_id)], null))))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change,new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,ccn.core.twbs.call(null,"form-control",twbs_modifiers),rui.forms.components.field__GT_twbs_class.call(null,field))], null),attrs),(function (){var iter__4324__auto__ = ((function (field,active_QMARK_,errors,on_change,id,map__30296,map__30296__$1,children,modifiers,attrs,label_attrs,twbs_modifiers){
return (function rui$forms$components$iter__30298(s__30299){
return (new cljs.core.LazySeq(null,((function (field,active_QMARK_,errors,on_change,id,map__30296,map__30296__$1,children,modifiers,attrs,label_attrs,twbs_modifiers){
return (function (){
var s__30299__$1 = s__30299;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__30299__$1);
if(temp__5457__auto__){
var s__30299__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__30299__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__30299__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__30301 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__30300 = (0);
while(true){
if((i__30300 < size__4323__auto__)){
var vec__30302 = cljs.core._nth.call(null,c__4322__auto__,i__30300);
var value = cljs.core.nth.call(null,vec__30302,(0),null);
var label__$1 = cljs.core.nth.call(null,vec__30302,(1),null);
cljs.core.chunk_append.call(null,b__30301,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),value], null),label__$1], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),value], null)));

var G__30311 = (i__30300 + (1));
i__30300 = G__30311;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__30301),rui$forms$components$iter__30298.call(null,cljs.core.chunk_rest.call(null,s__30299__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__30301),null);
}
} else {
var vec__30305 = cljs.core.first.call(null,s__30299__$2);
var value = cljs.core.nth.call(null,vec__30305,(0),null);
var label__$1 = cljs.core.nth.call(null,vec__30305,(1),null);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),value], null),label__$1], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),value], null)),rui$forms$components$iter__30298.call(null,cljs.core.rest.call(null,s__30299__$2)));
}
} else {
return null;
}
break;
}
});})(field,active_QMARK_,errors,on_change,id,map__30296,map__30296__$1,children,modifiers,attrs,label_attrs,twbs_modifiers))
,null,null));
});})(field,active_QMARK_,errors,on_change,id,map__30296,map__30296__$1,children,modifiers,attrs,label_attrs,twbs_modifiers))
;
return iter__4324__auto__.call(null,value_label_pairs);
})()], null)], null),cljs.core.conj.call(null,children,(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field,errors))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,errors], null):null)));
});

rui.forms.components.select.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
rui.forms.components.select.cljs$lang$applyTo = (function (seq30290){
var G__30291 = cljs.core.first.call(null,seq30290);
var seq30290__$1 = cljs.core.next.call(null,seq30290);
var G__30292 = cljs.core.first.call(null,seq30290__$1);
var seq30290__$2 = cljs.core.next.call(null,seq30290__$1);
var G__30293 = cljs.core.first.call(null,seq30290__$2);
var seq30290__$3 = cljs.core.next.call(null,seq30290__$2);
var G__30294 = cljs.core.first.call(null,seq30290__$3);
var seq30290__$4 = cljs.core.next.call(null,seq30290__$3);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30291,G__30292,G__30293,G__30294,seq30290__$4);
});

/**
 * Input field with all functionalities like: updating value, showing an error, ...
 * Required parameters:
 * - `input-type` a string like: 'text', 'number', ...
 * - `form` a form from the state
 * - `field-id` field is as a keyword
 * - `label` a Reagent valid component or string
 * Optional parameters:
 * - `modifiers` a CSS modifiers, a sequence of strings
 * - `attrs` a hashmap of HTML attributes of the input
 * - `label-attrs` a hashmap of HTML attributes for the label
 * - `twbs-modifiers` Twitter Bootstrap modifiers, a sequence of strings
 * - `input-group-append` a Twitter Bootstrap's 'input-group-append', a Reagent component of string
 * - `input-group-prepend` a Twitter Bootstrap's 'input-group-prepend', a Reagent component of string
 */
rui.forms.components.input_field = (function rui$forms$components$input_field(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30320 = arguments.length;
var i__4532__auto___30321 = (0);
while(true){
if((i__4532__auto___30321 < len__4531__auto___30320)){
args__4534__auto__.push((arguments[i__4532__auto___30321]));

var G__30322 = (i__4532__auto___30321 + (1));
i__4532__auto___30321 = G__30322;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((4) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((4)),(0),null)):null);
return rui.forms.components.input_field.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4535__auto__);
});

rui.forms.components.input_field.cljs$core$IFn$_invoke$arity$variadic = (function (input_type,form,field_id,label,p__30317){
var map__30318 = p__30317;
var map__30318__$1 = ((((!((map__30318 == null)))?(((((map__30318.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30318.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30318):map__30318);
var modifiers = cljs.core.get.call(null,map__30318__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__30318__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.call(null,map__30318__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153),cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.call(null,map__30318__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var input_group_append = cljs.core.get.call(null,map__30318__$1,new cljs.core.Keyword(null,"input-group-append","input-group-append",304795856),null);
var input_group_prepend = cljs.core.get.call(null,map__30318__$1,new cljs.core.Keyword(null,"input-group-prepend","input-group-prepend",-1646594811),null);
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
var field = cljs.core.get_in.call(null,form,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fields","fields",-1932066230),field_id], null));
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"input-field",cljs.core.name.call(null,field_id),cljs.core.conj.call(null,modifiers,rui.forms.core.field_state.call(null,form,field_id))))], null),((!((label == null)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label], null):null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_((function (){var or__3949__auto__ = input_group_prepend;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return input_group_append;
}
})())?"input-group":null)], null),((!((input_group_prepend == null)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-group-prepend","div.input-group-prepend",-1522435373),((typeof input_group_prepend === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-group-text","div.input-group-text",-1838140799),input_group_prepend], null):input_group_prepend)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),input_type,new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,ccn.core.twbs.call(null,"form-control",twbs_modifiers),rui.forms.components.field__GT_twbs_class.call(null,field)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form))),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),label,new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.partial.call(null,rui.forms.core.input_on_change_BANG_,form,field_id),new cljs.core.Keyword(null,"on-blur","on-blur",814300747),cljs.core.partial.call(null,rui.forms.core.input_on_blur_BANG_,form,field_id)], null),attrs)], null),((!((input_group_append == null)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-group-append","div.input-group-append",-1462957134),((typeof input_group_append === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-group-text","div.input-group-text",-1838140799),input_group_append], null):input_group_append)], null):null)], null),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form)),field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))], null):null)], null);
});

rui.forms.components.input_field.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
rui.forms.components.input_field.cljs$lang$applyTo = (function (seq30312){
var G__30313 = cljs.core.first.call(null,seq30312);
var seq30312__$1 = cljs.core.next.call(null,seq30312);
var G__30314 = cljs.core.first.call(null,seq30312__$1);
var seq30312__$2 = cljs.core.next.call(null,seq30312__$1);
var G__30315 = cljs.core.first.call(null,seq30312__$2);
var seq30312__$3 = cljs.core.next.call(null,seq30312__$2);
var G__30316 = cljs.core.first.call(null,seq30312__$3);
var seq30312__$4 = cljs.core.next.call(null,seq30312__$3);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30313,G__30314,G__30315,G__30316,seq30312__$4);
});

rui.forms.components.input_text = cljs.core.partial.call(null,rui.forms.components.input_field,"text");
rui.forms.components.input_password = cljs.core.partial.call(null,rui.forms.components.input_field,"password");
rui.forms.components.input_number = cljs.core.partial.call(null,rui.forms.components.input_field,"number");
rui.forms.components.input_email = cljs.core.partial.call(null,rui.forms.components.input_field,"email");
rui.forms.components.input_file = (function rui$forms$components$input_file(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30330 = arguments.length;
var i__4532__auto___30331 = (0);
while(true){
if((i__4532__auto___30331 < len__4531__auto___30330)){
args__4534__auto__.push((arguments[i__4532__auto___30331]));

var G__30332 = (i__4532__auto___30331 + (1));
i__4532__auto___30331 = G__30332;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.input_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.input_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__30327){
var map__30328 = p__30327;
var map__30328__$1 = ((((!((map__30328 == null)))?(((((map__30328.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30328.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30328):map__30328);
var kwargs = map__30328__$1;
var modifiers = cljs.core.get.call(null,map__30328__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834));
var attrs = cljs.core.get.call(null,map__30328__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var label_attrs = cljs.core.get.call(null,map__30328__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153));
var twbs_modifiers = cljs.core.get.call(null,map__30328__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072));
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
var field = cljs.core.get_in.call(null,form,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fields","fields",-1932066230),field_id], null));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"input-field",cljs.core.conj.call(null,modifiers,rui.forms.core.field_state.call(null,form,field_id))))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.custom-file","div.custom-file",1258230266),((!((label == null)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),"file",new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,ccn.core.twbs.call(null,"form-control-file",twbs_modifiers),rui.forms.components.field__GT_twbs_class.call(null,field)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form))),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),label,new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.partial.call(null,rui.forms.core.input_on_change_BANG_,form,field_id),new cljs.core.Keyword(null,"on-blur","on-blur",814300747),cljs.core.partial.call(null,rui.forms.core.input_on_blur_BANG_,form,field_id)], null),attrs)], null),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form)),field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))], null):null)], null)], null);
});

rui.forms.components.input_file.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.input_file.cljs$lang$applyTo = (function (seq30323){
var G__30324 = cljs.core.first.call(null,seq30323);
var seq30323__$1 = cljs.core.next.call(null,seq30323);
var G__30325 = cljs.core.first.call(null,seq30323__$1);
var seq30323__$2 = cljs.core.next.call(null,seq30323__$1);
var G__30326 = cljs.core.first.call(null,seq30323__$2);
var seq30323__$3 = cljs.core.next.call(null,seq30323__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30324,G__30325,G__30326,seq30323__$3);
});

rui.forms.components.text_area = (function rui$forms$components$text_area(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30340 = arguments.length;
var i__4532__auto___30341 = (0);
while(true){
if((i__4532__auto___30341 < len__4531__auto___30340)){
args__4534__auto__.push((arguments[i__4532__auto___30341]));

var G__30342 = (i__4532__auto___30341 + (1));
i__4532__auto___30341 = G__30342;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.text_area.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.text_area.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__30337){
var map__30338 = p__30337;
var map__30338__$1 = ((((!((map__30338 == null)))?(((((map__30338.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30338.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30338):map__30338);
var modifiers = cljs.core.get.call(null,map__30338__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__30338__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.call(null,map__30338__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153),cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.call(null,map__30338__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
var field = cljs.core.get_in.call(null,form,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fields","fields",-1932066230),field_id], null));
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"text-area",cljs.core.conj.call(null,modifiers,rui.forms.core.field_state.call(null,form,field_id))))], null),((!((label == null)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,ccn.core.twbs.call(null,"form-control",twbs_modifiers),rui.forms.components.field__GT_twbs_class.call(null,field)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form))),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),label,new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.partial.call(null,rui.forms.core.input_on_change_BANG_,form,field_id),new cljs.core.Keyword(null,"on-blur","on-blur",814300747),cljs.core.partial.call(null,rui.forms.core.input_on_blur_BANG_,form,field_id)], null),attrs)], null),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form)),field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))], null):null)], null);
});

rui.forms.components.text_area.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.text_area.cljs$lang$applyTo = (function (seq30333){
var G__30334 = cljs.core.first.call(null,seq30333);
var seq30333__$1 = cljs.core.next.call(null,seq30333);
var G__30335 = cljs.core.first.call(null,seq30333__$1);
var seq30333__$2 = cljs.core.next.call(null,seq30333__$1);
var G__30336 = cljs.core.first.call(null,seq30333__$2);
var seq30333__$3 = cljs.core.next.call(null,seq30333__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30334,G__30335,G__30336,seq30333__$3);
});

rui.forms.components.form_wrapper = (function rui$forms$components$form_wrapper(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30349 = arguments.length;
var i__4532__auto___30350 = (0);
while(true){
if((i__4532__auto___30350 < len__4531__auto___30349)){
args__4534__auto__.push((arguments[i__4532__auto___30350]));

var G__30351 = (i__4532__auto___30350 + (1));
i__4532__auto___30350 = G__30351;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return rui.forms.components.form_wrapper.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

rui.forms.components.form_wrapper.cljs$core$IFn$_invoke$arity$variadic = (function (p__30346,children){
var map__30347 = p__30346;
var map__30347__$1 = ((((!((map__30347 == null)))?(((((map__30347.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30347.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30347):map__30347);
var kwargs = map__30347__$1;
var on_submit = cljs.core.get.call(null,map__30347__$1,new cljs.core.Keyword(null,"on-submit","on-submit",1227871159));
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"form-wrapper",new cljs.core.Keyword(null,"on-submit","on-submit",1227871159),((function (map__30347,map__30347__$1,kwargs,on_submit){
return (function (p1__30343_SHARP_){
p1__30343_SHARP_.preventDefault();

return on_submit.call(null,p1__30343_SHARP_);
});})(map__30347,map__30347__$1,kwargs,on_submit))
], null)], null),children);
});

rui.forms.components.form_wrapper.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
rui.forms.components.form_wrapper.cljs$lang$applyTo = (function (seq30344){
var G__30345 = cljs.core.first.call(null,seq30344);
var seq30344__$1 = cljs.core.next.call(null,seq30344);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30345,seq30344__$1);
});

rui.forms.components.button_submit = (function rui$forms$components$button_submit(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30358 = arguments.length;
var i__4532__auto___30359 = (0);
while(true){
if((i__4532__auto___30359 < len__4531__auto___30358)){
args__4534__auto__.push((arguments[i__4532__auto___30359]));

var G__30360 = (i__4532__auto___30359 + (1));
i__4532__auto___30359 = G__30360;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((2) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((2)),(0),null)):null);
return rui.forms.components.button_submit.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4535__auto__);
});

rui.forms.components.button_submit.cljs$core$IFn$_invoke$arity$variadic = (function (title,on_click,p__30355){
var map__30356 = p__30355;
var map__30356__$1 = ((((!((map__30356 == null)))?(((((map__30356.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30356.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30356):map__30356);
var kwargs = map__30356__$1;
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.buttons.button_primary,title,on_click], null),cljs.core.apply.call(null,cljs.core.concat,cljs.core.merge.call(null,kwargs,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"modifiers","modifiers",50378834),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submit"], null)], null))));
});

rui.forms.components.button_submit.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
rui.forms.components.button_submit.cljs$lang$applyTo = (function (seq30352){
var G__30353 = cljs.core.first.call(null,seq30352);
var seq30352__$1 = cljs.core.next.call(null,seq30352);
var G__30354 = cljs.core.first.call(null,seq30352__$1);
var seq30352__$2 = cljs.core.next.call(null,seq30352__$1);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30353,G__30354,seq30352__$2);
});

rui.forms.components.plaintext = (function rui$forms$components$plaintext(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30368 = arguments.length;
var i__4532__auto___30369 = (0);
while(true){
if((i__4532__auto___30369 < len__4531__auto___30368)){
args__4534__auto__.push((arguments[i__4532__auto___30369]));

var G__30370 = (i__4532__auto___30369 + (1));
i__4532__auto___30369 = G__30370;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.plaintext.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.plaintext.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__30365){
var map__30366 = p__30365;
var map__30366__$1 = ((((!((map__30366 == null)))?(((((map__30366.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30366.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30366):map__30366);
var modifiers = cljs.core.get.call(null,map__30366__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__30366__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.call(null,map__30366__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153),cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.call(null,map__30366__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"plaintext",cljs.core.conj.call(null,modifiers,rui.forms.core.field_state.call(null,form,field_id))))], null),((!((label == null)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"on-blur","on-blur",814300747),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.Keyword(null,"read-only","read-only",-191706886),new cljs.core.Keyword(null,"on-change","on-change",-732046149)],[label,id,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form))),cljs.core.partial.call(null,rui.forms.core.input_on_blur_BANG_,form,field_id),"text",id,ccn.core.twbs.call(null,"form-control-plaintext",twbs_modifiers),true,cljs.core.partial.call(null,rui.forms.core.input_on_change_BANG_,form,field_id)]),attrs)], null)], null);
});

rui.forms.components.plaintext.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.plaintext.cljs$lang$applyTo = (function (seq30361){
var G__30362 = cljs.core.first.call(null,seq30361);
var seq30361__$1 = cljs.core.next.call(null,seq30361);
var G__30363 = cljs.core.first.call(null,seq30361__$1);
var seq30361__$2 = cljs.core.next.call(null,seq30361__$1);
var G__30364 = cljs.core.first.call(null,seq30361__$2);
var seq30361__$3 = cljs.core.next.call(null,seq30361__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30362,G__30363,G__30364,seq30361__$3);
});


//# sourceMappingURL=components.js.map?rel=1533632520897
