// Compiled by ClojureScript 1.9.946 {}
goog.provide('rui.forms.core');
goog.require('cljs.core');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('re_frame.core');
rui.forms.core.field_states = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"valid","valid",155614240),null,new cljs.core.Keyword(null,"invalid","invalid",412869516),null,new cljs.core.Keyword(null,"initial","initial",1854648214),null], null), null);

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
rui.forms.core.Field = (function (id,value,valid_QMARK_,state,blured_QMARK_,__meta,__extmap,__hash){
this.id = id;
this.value = value;
this.valid_QMARK_ = valid_QMARK_;
this.state = state;
this.blured_QMARK_ = blured_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
rui.forms.core.Field.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__28988__auto__,k__28989__auto__){
var self__ = this;
var this__28988__auto____$1 = this;
return this__28988__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__28989__auto__,null);
});

rui.forms.core.Field.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__28990__auto__,k40590,else__28991__auto__){
var self__ = this;
var this__28990__auto____$1 = this;
var G__40594 = k40590;
var G__40594__$1 = (((G__40594 instanceof cljs.core.Keyword))?G__40594.fqn:null);
switch (G__40594__$1) {
case "id":
return self__.id;

break;
case "value":
return self__.value;

break;
case "valid?":
return self__.valid_QMARK_;

break;
case "state":
return self__.state;

break;
case "blured?":
return self__.blured_QMARK_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k40590,else__28991__auto__);

}
});

rui.forms.core.Field.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__29002__auto__,writer__29003__auto__,opts__29004__auto__){
var self__ = this;
var this__29002__auto____$1 = this;
var pr_pair__29005__auto__ = ((function (this__29002__auto____$1){
return (function (keyval__29006__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__29003__auto__,cljs.core.pr_writer,""," ","",opts__29004__auto__,keyval__29006__auto__);
});})(this__29002__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__29003__auto__,pr_pair__29005__auto__,"#rui.forms.core.Field{",", ","}",opts__29004__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"value","value",305978217),self__.value],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"valid?","valid?",-212412379),self__.valid_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blured?","blured?",1861327265),self__.blured_QMARK_],null))], null),self__.__extmap));
});

rui.forms.core.Field.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__40589){
var self__ = this;
var G__40589__$1 = this;
return (new cljs.core.RecordIter((0),G__40589__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"valid?","valid?",-212412379),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"blured?","blured?",1861327265)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

rui.forms.core.Field.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__28986__auto__){
var self__ = this;
var this__28986__auto____$1 = this;
return self__.__meta;
});

rui.forms.core.Field.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__28983__auto__){
var self__ = this;
var this__28983__auto____$1 = this;
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
});

rui.forms.core.Field.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__28992__auto__){
var self__ = this;
var this__28992__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
});

rui.forms.core.Field.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__28984__auto__){
var self__ = this;
var this__28984__auto____$1 = this;
var h__28802__auto__ = self__.__hash;
if(!((h__28802__auto__ == null))){
return h__28802__auto__;
} else {
var h__28802__auto____$1 = ((function (h__28802__auto__,this__28984__auto____$1){
return (function (coll__28985__auto__){
return (1205228671 ^ cljs.core.hash_unordered_coll.call(null,coll__28985__auto__));
});})(h__28802__auto__,this__28984__auto____$1))
.call(null,this__28984__auto____$1);
self__.__hash = h__28802__auto____$1;

return h__28802__auto____$1;
}
});

rui.forms.core.Field.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this40591,other40592){
var self__ = this;
var this40591__$1 = this;
return (!((other40592 == null))) && ((this40591__$1.constructor === other40592.constructor)) && (cljs.core._EQ_.call(null,this40591__$1.id,other40592.id)) && (cljs.core._EQ_.call(null,this40591__$1.value,other40592.value)) && (cljs.core._EQ_.call(null,this40591__$1.valid_QMARK_,other40592.valid_QMARK_)) && (cljs.core._EQ_.call(null,this40591__$1.state,other40592.state)) && (cljs.core._EQ_.call(null,this40591__$1.blured_QMARK_,other40592.blured_QMARK_)) && (cljs.core._EQ_.call(null,this40591__$1.__extmap,other40592.__extmap));
});

rui.forms.core.Field.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__28997__auto__,k__28998__auto__){
var self__ = this;
var this__28997__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"blured?","blured?",1861327265),null,new cljs.core.Keyword(null,"valid?","valid?",-212412379),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"id","id",-1388402092),null], null), null),k__28998__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__28997__auto____$1),self__.__meta),k__28998__auto__);
} else {
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__28998__auto__)),null));
}
});

rui.forms.core.Field.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__28995__auto__,k__28996__auto__,G__40589){
var self__ = this;
var this__28995__auto____$1 = this;
var pred__40595 = cljs.core.keyword_identical_QMARK_;
var expr__40596 = k__28996__auto__;
if(cljs.core.truth_(pred__40595.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__40596))){
return (new rui.forms.core.Field(G__40589,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__40595.call(null,new cljs.core.Keyword(null,"value","value",305978217),expr__40596))){
return (new rui.forms.core.Field(self__.id,G__40589,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__40595.call(null,new cljs.core.Keyword(null,"valid?","valid?",-212412379),expr__40596))){
return (new rui.forms.core.Field(self__.id,self__.value,G__40589,self__.state,self__.blured_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__40595.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__40596))){
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,G__40589,self__.blured_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__40595.call(null,new cljs.core.Keyword(null,"blured?","blured?",1861327265),expr__40596))){
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,G__40589,self__.__meta,self__.__extmap,null));
} else {
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__28996__auto__,G__40589),null));
}
}
}
}
}
});

rui.forms.core.Field.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__29000__auto__){
var self__ = this;
var this__29000__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"value","value",305978217),self__.value],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"valid?","valid?",-212412379),self__.valid_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blured?","blured?",1861327265),self__.blured_QMARK_],null))], null),self__.__extmap));
});

rui.forms.core.Field.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__28987__auto__,G__40589){
var self__ = this;
var this__28987__auto____$1 = this;
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,G__40589,self__.__extmap,self__.__hash));
});

rui.forms.core.Field.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__28993__auto__,entry__28994__auto__){
var self__ = this;
var this__28993__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__28994__auto__)){
return this__28993__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__28994__auto__,(0)),cljs.core._nth.call(null,entry__28994__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__28993__auto____$1,entry__28994__auto__);
}
});

rui.forms.core.Field.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"valid?","valid?",1428119148,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"blured?","blured?",-793108504,null)], null);
});

rui.forms.core.Field.cljs$lang$type = true;

rui.forms.core.Field.cljs$lang$ctorPrSeq = (function (this__29024__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"rui.forms.core/Field");
});

rui.forms.core.Field.cljs$lang$ctorPrWriter = (function (this__29024__auto__,writer__29025__auto__){
return cljs.core._write.call(null,writer__29025__auto__,"rui.forms.core/Field");
});

rui.forms.core.__GT_Field = (function rui$forms$core$__GT_Field(id,value,valid_QMARK_,state,blured_QMARK_){
return (new rui.forms.core.Field(id,value,valid_QMARK_,state,blured_QMARK_,null,null,null));
});

rui.forms.core.map__GT_Field = (function rui$forms$core$map__GT_Field(G__40593){
return (new rui.forms.core.Field(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__40593),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(G__40593),new cljs.core.Keyword(null,"valid?","valid?",-212412379).cljs$core$IFn$_invoke$arity$1(G__40593),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__40593),new cljs.core.Keyword(null,"blured?","blured?",1861327265).cljs$core$IFn$_invoke$arity$1(G__40593),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__40593,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"valid?","valid?",-212412379),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"blured?","blured?",1861327265))),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
rui.forms.core.Form = (function (id,fields,valid_QMARK_,errors,validator,__meta,__extmap,__hash){
this.id = id;
this.fields = fields;
this.valid_QMARK_ = valid_QMARK_;
this.errors = errors;
this.validator = validator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
rui.forms.core.Form.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__28988__auto__,k__28989__auto__){
var self__ = this;
var this__28988__auto____$1 = this;
return this__28988__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__28989__auto__,null);
});

rui.forms.core.Form.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__28990__auto__,k40600,else__28991__auto__){
var self__ = this;
var this__28990__auto____$1 = this;
var G__40604 = k40600;
var G__40604__$1 = (((G__40604 instanceof cljs.core.Keyword))?G__40604.fqn:null);
switch (G__40604__$1) {
case "id":
return self__.id;

break;
case "fields":
return self__.fields;

break;
case "valid?":
return self__.valid_QMARK_;

break;
case "errors":
return self__.errors;

break;
case "validator":
return self__.validator;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k40600,else__28991__auto__);

}
});

rui.forms.core.Form.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__29002__auto__,writer__29003__auto__,opts__29004__auto__){
var self__ = this;
var this__29002__auto____$1 = this;
var pr_pair__29005__auto__ = ((function (this__29002__auto____$1){
return (function (keyval__29006__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__29003__auto__,cljs.core.pr_writer,""," ","",opts__29004__auto__,keyval__29006__auto__);
});})(this__29002__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__29003__auto__,pr_pair__29005__auto__,"#rui.forms.core.Form{",", ","}",opts__29004__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fields","fields",-1932066230),self__.fields],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"valid?","valid?",-212412379),self__.valid_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"errors","errors",-908790718),self__.errors],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"validator","validator",-1966190681),self__.validator],null))], null),self__.__extmap));
});

rui.forms.core.Form.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__40599){
var self__ = this;
var G__40599__$1 = this;
return (new cljs.core.RecordIter((0),G__40599__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"fields","fields",-1932066230),new cljs.core.Keyword(null,"valid?","valid?",-212412379),new cljs.core.Keyword(null,"errors","errors",-908790718),new cljs.core.Keyword(null,"validator","validator",-1966190681)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

rui.forms.core.Form.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__28986__auto__){
var self__ = this;
var this__28986__auto____$1 = this;
return self__.__meta;
});

rui.forms.core.Form.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__28983__auto__){
var self__ = this;
var this__28983__auto____$1 = this;
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,self__.errors,self__.validator,self__.__meta,self__.__extmap,self__.__hash));
});

rui.forms.core.Form.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__28992__auto__){
var self__ = this;
var this__28992__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
});

rui.forms.core.Form.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__28984__auto__){
var self__ = this;
var this__28984__auto____$1 = this;
var h__28802__auto__ = self__.__hash;
if(!((h__28802__auto__ == null))){
return h__28802__auto__;
} else {
var h__28802__auto____$1 = ((function (h__28802__auto__,this__28984__auto____$1){
return (function (coll__28985__auto__){
return (-1405164784 ^ cljs.core.hash_unordered_coll.call(null,coll__28985__auto__));
});})(h__28802__auto__,this__28984__auto____$1))
.call(null,this__28984__auto____$1);
self__.__hash = h__28802__auto____$1;

return h__28802__auto____$1;
}
});

rui.forms.core.Form.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this40601,other40602){
var self__ = this;
var this40601__$1 = this;
return (!((other40602 == null))) && ((this40601__$1.constructor === other40602.constructor)) && (cljs.core._EQ_.call(null,this40601__$1.id,other40602.id)) && (cljs.core._EQ_.call(null,this40601__$1.fields,other40602.fields)) && (cljs.core._EQ_.call(null,this40601__$1.valid_QMARK_,other40602.valid_QMARK_)) && (cljs.core._EQ_.call(null,this40601__$1.errors,other40602.errors)) && (cljs.core._EQ_.call(null,this40601__$1.validator,other40602.validator)) && (cljs.core._EQ_.call(null,this40601__$1.__extmap,other40602.__extmap));
});

rui.forms.core.Form.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__28997__auto__,k__28998__auto__){
var self__ = this;
var this__28997__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"errors","errors",-908790718),null,new cljs.core.Keyword(null,"valid?","valid?",-212412379),null,new cljs.core.Keyword(null,"validator","validator",-1966190681),null,new cljs.core.Keyword(null,"fields","fields",-1932066230),null,new cljs.core.Keyword(null,"id","id",-1388402092),null], null), null),k__28998__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__28997__auto____$1),self__.__meta),k__28998__auto__);
} else {
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,self__.errors,self__.validator,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__28998__auto__)),null));
}
});

rui.forms.core.Form.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__28995__auto__,k__28996__auto__,G__40599){
var self__ = this;
var this__28995__auto____$1 = this;
var pred__40605 = cljs.core.keyword_identical_QMARK_;
var expr__40606 = k__28996__auto__;
if(cljs.core.truth_(pred__40605.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__40606))){
return (new rui.forms.core.Form(G__40599,self__.fields,self__.valid_QMARK_,self__.errors,self__.validator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__40605.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230),expr__40606))){
return (new rui.forms.core.Form(self__.id,G__40599,self__.valid_QMARK_,self__.errors,self__.validator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__40605.call(null,new cljs.core.Keyword(null,"valid?","valid?",-212412379),expr__40606))){
return (new rui.forms.core.Form(self__.id,self__.fields,G__40599,self__.errors,self__.validator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__40605.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718),expr__40606))){
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,G__40599,self__.validator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__40605.call(null,new cljs.core.Keyword(null,"validator","validator",-1966190681),expr__40606))){
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,self__.errors,G__40599,self__.__meta,self__.__extmap,null));
} else {
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,self__.errors,self__.validator,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__28996__auto__,G__40599),null));
}
}
}
}
}
});

rui.forms.core.Form.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__29000__auto__){
var self__ = this;
var this__29000__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fields","fields",-1932066230),self__.fields],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"valid?","valid?",-212412379),self__.valid_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"errors","errors",-908790718),self__.errors],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"validator","validator",-1966190681),self__.validator],null))], null),self__.__extmap));
});

rui.forms.core.Form.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__28987__auto__,G__40599){
var self__ = this;
var this__28987__auto____$1 = this;
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,self__.errors,self__.validator,G__40599,self__.__extmap,self__.__hash));
});

rui.forms.core.Form.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__28993__auto__,entry__28994__auto__){
var self__ = this;
var this__28993__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__28994__auto__)){
return this__28993__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__28994__auto__,(0)),cljs.core._nth.call(null,entry__28994__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__28993__auto____$1,entry__28994__auto__);
}
});

rui.forms.core.Form.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.Symbol(null,"valid?","valid?",1428119148,null),new cljs.core.Symbol(null,"errors","errors",731740809,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null)], null);
});

rui.forms.core.Form.cljs$lang$type = true;

rui.forms.core.Form.cljs$lang$ctorPrSeq = (function (this__29024__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"rui.forms.core/Form");
});

rui.forms.core.Form.cljs$lang$ctorPrWriter = (function (this__29024__auto__,writer__29025__auto__){
return cljs.core._write.call(null,writer__29025__auto__,"rui.forms.core/Form");
});

rui.forms.core.__GT_Form = (function rui$forms$core$__GT_Form(id,fields,valid_QMARK_,errors,validator){
return (new rui.forms.core.Form(id,fields,valid_QMARK_,errors,validator,null,null,null));
});

rui.forms.core.map__GT_Form = (function rui$forms$core$map__GT_Form(G__40603){
return (new rui.forms.core.Form(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__40603),new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(G__40603),new cljs.core.Keyword(null,"valid?","valid?",-212412379).cljs$core$IFn$_invoke$arity$1(G__40603),new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(G__40603),new cljs.core.Keyword(null,"validator","validator",-1966190681).cljs$core$IFn$_invoke$arity$1(G__40603),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__40603,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"fields","fields",-1932066230),new cljs.core.Keyword(null,"valid?","valid?",-212412379),new cljs.core.Keyword(null,"errors","errors",-908790718),new cljs.core.Keyword(null,"validator","validator",-1966190681))),null));
});

rui.forms.core.gen_field_id = (function rui$forms$core$gen_field_id(form,field_name){
return goog.string.format("%s_%s",cljs.core.name.call(null,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(form)),cljs.core.name.call(null,field_name));
});
/**
 * Return a `Form` by a given `id` in the `db`.
 */
rui.forms.core.db__GT_form = (function rui$forms$core$db__GT_form(db,id){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::forms","rui::forms",-426766832),id], null));
});
/**
 * Initializes a `Field` by `id`, or `value` with default values.
 */
rui.forms.core.init_field = (function rui$forms$core$init_field(var_args){
var G__40610 = arguments.length;
switch (G__40610) {
case 1:
return rui.forms.core.init_field.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return rui.forms.core.init_field.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

rui.forms.core.init_field.cljs$core$IFn$_invoke$arity$1 = (function (id){
return rui.forms.core.init_field.call(null,id,null);
});

rui.forms.core.init_field.cljs$core$IFn$_invoke$arity$2 = (function (id,value){
return rui.forms.core.__GT_Field.call(null,id,value,false,new cljs.core.Keyword(null,"initial","initial",1854648214),false);
});

rui.forms.core.init_field.cljs$lang$maxFixedArity = 2;

/**
 * Creates a `Form` from a given `map`.
 */
rui.forms.core.create_form = (function rui$forms$core$create_form(form_map,init_values){
return rui.forms.core.map__GT_Form.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fields","fields",-1932066230),cljs.core.reduce_kv.call(null,(function (fields,field_id,init_value){
return cljs.core.assoc.call(null,fields,field_id,rui.forms.core.init_field.call(null,field_id,init_value));
}),cljs.core.PersistentArrayMap.EMPTY,init_values),new cljs.core.Keyword(null,"errors","errors",-908790718),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"valid?","valid?",-212412379),false], null),form_map));
});
/**
 * Returns a field's state as a `string`.
 */
rui.forms.core.field_state = (function rui$forms$core$field_state(form,id){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form)));
if((state == null)){
return "";
} else {
return cljs.core.name.call(null,state);
}
});
/**
 * Returns `form`'s values as a hashmap.
 */
rui.forms.core.form__GT_values = (function rui$forms$core$form__GT_values(form){
return cljs.core.reduce_kv.call(null,(function (values,id,field){
return cljs.core.assoc.call(null,values,id,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field));
}),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form));
});
/**
 * Validates a given `form` by its valdiator. It returns new form with updated values:
 * - `errors`
 * - `valid?`
 * - every field's `valid?` is updated too
 */
rui.forms.core.validate_form = (function rui$forms$core$validate_form(form){
var field_values = rui.forms.core.form__GT_values.call(null,form);
var validator = new cljs.core.Keyword(null,"validator","validator",-1966190681).cljs$core$IFn$_invoke$arity$1(form);
var errors = validator.call(null,field_values);
return cljs.core.update.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,form,new cljs.core.Keyword(null,"errors","errors",-908790718),errors),new cljs.core.Keyword(null,"valid?","valid?",-212412379),cljs.core.empty_QMARK_.call(null,errors)),new cljs.core.Keyword(null,"fields","fields",-1932066230),((function (field_values,validator,errors){
return (function (p1__40612_SHARP_){
return cljs.core.reduce_kv.call(null,((function (field_values,validator,errors){
return (function (fields,id,field){
return cljs.core.assoc_in.call(null,fields,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,new cljs.core.Keyword(null,"valid?","valid?",-212412379)], null),!(cljs.core.contains_QMARK_.call(null,errors,id)));
});})(field_values,validator,errors))
,p1__40612_SHARP_,p1__40612_SHARP_);
});})(field_values,validator,errors))
);
});
/**
 * Initializes a form in the `db` within `form-map` and `initial-values`
 */
rui.forms.core.init_form = (function rui$forms$core$init_form(db,form_map,initial_values){
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::forms","rui::forms",-426766832),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(form_map)], null),rui.forms.core.create_form.call(null,form_map,initial_values)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::forms","rui::forms",-426766832),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(form_map)], null),rui.forms.core.validate_form);
});
/**
 * Assocs a given `value` into the `db` by a given `form-id` and `field-id`
 */
rui.forms.core.assoc_field_value = (function rui$forms$core$assoc_field_value(db,form_id,field_id,value){
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::forms","rui::forms",-426766832),form_id,new cljs.core.Keyword(null,"fields","fields",-1932066230),field_id,new cljs.core.Keyword(null,"value","value",305978217)], null),value);
});
/**
 * Assocs a given `values` into the `db` by a given `form-id`
 */
rui.forms.core.assoc_values = (function rui$forms$core$assoc_values(db,form_id,values){
return cljs.core.reduce_kv.call(null,(function (db__$1,field_id,value){
return rui.forms.core.assoc_field_value.call(null,db__$1,form_id,field_id,value);
}),db,values);
});
/**
 * Adds a given `errors` into the `db` by a given `form-id`.
 * The `errors` should be a map with vectors
 */
rui.forms.core.add_form_errors = (function rui$forms$core$add_form_errors(db,form_id,errors){
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::forms","rui::forms",-426766832),form_id,new cljs.core.Keyword(null,"errors","errors",-908790718)], null),cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.into),errors);
});
/**
 * Takes a response's body as errors and assoc them in the `db` by a `form-id`.
 * The `errors` should be a map with vectors
 */
rui.forms.core.form_errors_LT_response = (function rui$forms$core$form_errors_LT_response(db,form_id,errors){
return rui.forms.core.add_form_errors.call(null,db,form_id,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(errors));
});
/**
 * Dispatches a input's on-change event. Optionally takes a `formatter` function that takes a new values and returns
 * formatter value.
 */
rui.forms.core.input_on_change_BANG_ = (function rui$forms$core$input_on_change_BANG_(var_args){
var G__40614 = arguments.length;
switch (G__40614) {
case 4:
return rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (form,id,formatter,event){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rui::forms","forms-input-changed","rui::forms/forms-input-changed",-943107654),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(form),id,formatter.call(null,event.target.value)], null));
});

rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (form,id,event){
return rui.forms.core.input_on_change_BANG_.call(null,form,id,cljs.core.identity,event);
});

rui.forms.core.input_on_change_BANG_.cljs$lang$maxFixedArity = 4;

/**
 * Dispatches a input's on-blur event
 */
rui.forms.core.input_on_blur_BANG_ = (function rui$forms$core$input_on_blur_BANG_(form,id,event){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rui::forms","forms-input-blured","rui::forms/forms-input-blured",860908066),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(form),id], null));
});
/**
 * Initializes a form in DB by a given `form-id` with a `validator` function that takes a map of fields values
 * and returns a map of vectors as errors or `nil`. Optionally takes an `initial-values` map.
 */
rui.forms.core.init_form_BANG_ = (function rui$forms$core$init_form_BANG_(var_args){
var G__40617 = arguments.length;
switch (G__40617) {
case 2:
return rui.forms.core.init_form_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return rui.forms.core.init_form_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

rui.forms.core.init_form_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (form_id,validator){
return rui.forms.core.init_form_BANG_.call(null,form_id,validator,cljs.core.PersistentArrayMap.EMPTY);
});

rui.forms.core.init_form_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (form_id,validator,initial_values){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rui::forms","init-form","rui::forms/init-form",-1541891045),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),form_id,new cljs.core.Keyword(null,"validator","validator",-1966190681),validator], null),initial_values], null));
});

rui.forms.core.init_form_BANG_.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=core.js.map?rel=1518101969389
