// Compiled by ClojureScript 1.9.946 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
var seq__28835 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__28836 = null;
var count__28837 = (0);
var i__28838 = (0);
while(true){
if((i__28838 < count__28837)){
var vec__28839 = cljs.core._nth.call(null,chunk__28836,i__28838);
var effect_key = cljs.core.nth.call(null,vec__28839,(0),null);
var effect_value = cljs.core.nth.call(null,vec__28839,(1),null);
var temp__4655__auto___28845 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__4655__auto___28845)){
var effect_fn_28846 = temp__4655__auto___28845;
effect_fn_28846.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__28847 = seq__28835;
var G__28848 = chunk__28836;
var G__28849 = count__28837;
var G__28850 = (i__28838 + (1));
seq__28835 = G__28847;
chunk__28836 = G__28848;
count__28837 = G__28849;
i__28838 = G__28850;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__28835);
if(temp__4657__auto__){
var seq__28835__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28835__$1)){
var c__27218__auto__ = cljs.core.chunk_first.call(null,seq__28835__$1);
var G__28851 = cljs.core.chunk_rest.call(null,seq__28835__$1);
var G__28852 = c__27218__auto__;
var G__28853 = cljs.core.count.call(null,c__27218__auto__);
var G__28854 = (0);
seq__28835 = G__28851;
chunk__28836 = G__28852;
count__28837 = G__28853;
i__28838 = G__28854;
continue;
} else {
var vec__28842 = cljs.core.first.call(null,seq__28835__$1);
var effect_key = cljs.core.nth.call(null,vec__28842,(0),null);
var effect_value = cljs.core.nth.call(null,vec__28842,(1),null);
var temp__4655__auto___28855 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__4655__auto___28855)){
var effect_fn_28856 = temp__4655__auto___28855;
effect_fn_28856.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__28857 = cljs.core.next.call(null,seq__28835__$1);
var G__28858 = null;
var G__28859 = (0);
var G__28860 = (0);
seq__28835 = G__28857;
chunk__28836 = G__28858;
count__28837 = G__28859;
i__28838 = G__28860;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__28861 = cljs.core.seq.call(null,value);
var chunk__28862 = null;
var count__28863 = (0);
var i__28864 = (0);
while(true){
if((i__28864 < count__28863)){
var map__28865 = cljs.core._nth.call(null,chunk__28862,i__28864);
var map__28865__$1 = ((((!((map__28865 == null)))?((((map__28865.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28865.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28865):map__28865);
var effect = map__28865__$1;
var ms = cljs.core.get.call(null,map__28865__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__28865__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__28861,chunk__28862,count__28863,i__28864,map__28865,map__28865__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__28861,chunk__28862,count__28863,i__28864,map__28865,map__28865__$1,effect,ms,dispatch))
,ms);
}

var G__28869 = seq__28861;
var G__28870 = chunk__28862;
var G__28871 = count__28863;
var G__28872 = (i__28864 + (1));
seq__28861 = G__28869;
chunk__28862 = G__28870;
count__28863 = G__28871;
i__28864 = G__28872;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__28861);
if(temp__4657__auto__){
var seq__28861__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28861__$1)){
var c__27218__auto__ = cljs.core.chunk_first.call(null,seq__28861__$1);
var G__28873 = cljs.core.chunk_rest.call(null,seq__28861__$1);
var G__28874 = c__27218__auto__;
var G__28875 = cljs.core.count.call(null,c__27218__auto__);
var G__28876 = (0);
seq__28861 = G__28873;
chunk__28862 = G__28874;
count__28863 = G__28875;
i__28864 = G__28876;
continue;
} else {
var map__28867 = cljs.core.first.call(null,seq__28861__$1);
var map__28867__$1 = ((((!((map__28867 == null)))?((((map__28867.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28867.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28867):map__28867);
var effect = map__28867__$1;
var ms = cljs.core.get.call(null,map__28867__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__28867__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__28861,chunk__28862,count__28863,i__28864,map__28867,map__28867__$1,effect,ms,dispatch,seq__28861__$1,temp__4657__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__28861,chunk__28862,count__28863,i__28864,map__28867,map__28867__$1,effect,ms,dispatch,seq__28861__$1,temp__4657__auto__))
,ms);
}

var G__28877 = cljs.core.next.call(null,seq__28861__$1);
var G__28878 = null;
var G__28879 = (0);
var G__28880 = (0);
seq__28861 = G__28877;
chunk__28862 = G__28878;
count__28863 = G__28879;
i__28864 = G__28880;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__28881 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__28882 = null;
var count__28883 = (0);
var i__28884 = (0);
while(true){
if((i__28884 < count__28883)){
var event = cljs.core._nth.call(null,chunk__28882,i__28884);
re_frame.router.dispatch.call(null,event);

var G__28885 = seq__28881;
var G__28886 = chunk__28882;
var G__28887 = count__28883;
var G__28888 = (i__28884 + (1));
seq__28881 = G__28885;
chunk__28882 = G__28886;
count__28883 = G__28887;
i__28884 = G__28888;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__28881);
if(temp__4657__auto__){
var seq__28881__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28881__$1)){
var c__27218__auto__ = cljs.core.chunk_first.call(null,seq__28881__$1);
var G__28889 = cljs.core.chunk_rest.call(null,seq__28881__$1);
var G__28890 = c__27218__auto__;
var G__28891 = cljs.core.count.call(null,c__27218__auto__);
var G__28892 = (0);
seq__28881 = G__28889;
chunk__28882 = G__28890;
count__28883 = G__28891;
i__28884 = G__28892;
continue;
} else {
var event = cljs.core.first.call(null,seq__28881__$1);
re_frame.router.dispatch.call(null,event);

var G__28893 = cljs.core.next.call(null,seq__28881__$1);
var G__28894 = null;
var G__28895 = (0);
var G__28896 = (0);
seq__28881 = G__28893;
chunk__28882 = G__28894;
count__28883 = G__28895;
i__28884 = G__28896;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__28897 = cljs.core.seq.call(null,value);
var chunk__28898 = null;
var count__28899 = (0);
var i__28900 = (0);
while(true){
if((i__28900 < count__28899)){
var event = cljs.core._nth.call(null,chunk__28898,i__28900);
clear_event.call(null,event);

var G__28901 = seq__28897;
var G__28902 = chunk__28898;
var G__28903 = count__28899;
var G__28904 = (i__28900 + (1));
seq__28897 = G__28901;
chunk__28898 = G__28902;
count__28899 = G__28903;
i__28900 = G__28904;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__28897);
if(temp__4657__auto__){
var seq__28897__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28897__$1)){
var c__27218__auto__ = cljs.core.chunk_first.call(null,seq__28897__$1);
var G__28905 = cljs.core.chunk_rest.call(null,seq__28897__$1);
var G__28906 = c__27218__auto__;
var G__28907 = cljs.core.count.call(null,c__27218__auto__);
var G__28908 = (0);
seq__28897 = G__28905;
chunk__28898 = G__28906;
count__28899 = G__28907;
i__28900 = G__28908;
continue;
} else {
var event = cljs.core.first.call(null,seq__28897__$1);
clear_event.call(null,event);

var G__28909 = cljs.core.next.call(null,seq__28897__$1);
var G__28910 = null;
var G__28911 = (0);
var G__28912 = (0);
seq__28897 = G__28909;
chunk__28898 = G__28910;
count__28899 = G__28911;
i__28900 = G__28912;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref.call(null,re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=fx.js.map?rel=1516615194167
