// Compiled by ClojureScript 1.9.946 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.14";
figwheel.client.js_stringify = (((typeof JSON !== 'undefined') && (!((JSON.stringify == null))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e34925){if((e34925 instanceof Error)){
var e = e34925;
return "Error: Unable to stringify";
} else {
throw e34925;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__34928 = arguments.length;
switch (G__34928) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__34926_SHARP_){
if(typeof p1__34926_SHARP_ === 'string'){
return p1__34926_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__34926_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__29526__auto__ = [];
var len__29519__auto___34931 = arguments.length;
var i__29520__auto___34932 = (0);
while(true){
if((i__29520__auto___34932 < len__29519__auto___34931)){
args__29526__auto__.push((arguments[i__29520__auto___34932]));

var G__34933 = (i__29520__auto___34932 + (1));
i__29520__auto___34932 = G__34933;
continue;
} else {
}
break;
}

var argseq__29527__auto__ = ((((0) < args__29526__auto__.length))?(new cljs.core.IndexedSeq(args__29526__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29527__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq34930){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq34930));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__29526__auto__ = [];
var len__29519__auto___34935 = arguments.length;
var i__29520__auto___34936 = (0);
while(true){
if((i__29520__auto___34936 < len__29519__auto___34935)){
args__29526__auto__.push((arguments[i__29520__auto___34936]));

var G__34937 = (i__29520__auto___34936 + (1));
i__29520__auto___34936 = G__34937;
continue;
} else {
}
break;
}

var argseq__29527__auto__ = ((((0) < args__29526__auto__.length))?(new cljs.core.IndexedSeq(args__29526__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29527__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq34934){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq34934));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__34938){
var map__34939 = p__34938;
var map__34939__$1 = ((((!((map__34939 == null)))?((((map__34939.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34939.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34939):map__34939);
var message = cljs.core.get.call(null,map__34939__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__34939__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__28348__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__28336__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__28336__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__28336__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__30949__auto___35018 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___35018,ch){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___35018,ch){
return (function (state_34990){
var state_val_34991 = (state_34990[(1)]);
if((state_val_34991 === (7))){
var inst_34986 = (state_34990[(2)]);
var state_34990__$1 = state_34990;
var statearr_34992_35019 = state_34990__$1;
(statearr_34992_35019[(2)] = inst_34986);

(statearr_34992_35019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34991 === (1))){
var state_34990__$1 = state_34990;
var statearr_34993_35020 = state_34990__$1;
(statearr_34993_35020[(2)] = null);

(statearr_34993_35020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34991 === (4))){
var inst_34943 = (state_34990[(7)]);
var inst_34943__$1 = (state_34990[(2)]);
var state_34990__$1 = (function (){var statearr_34994 = state_34990;
(statearr_34994[(7)] = inst_34943__$1);

return statearr_34994;
})();
if(cljs.core.truth_(inst_34943__$1)){
var statearr_34995_35021 = state_34990__$1;
(statearr_34995_35021[(1)] = (5));

} else {
var statearr_34996_35022 = state_34990__$1;
(statearr_34996_35022[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34991 === (15))){
var inst_34950 = (state_34990[(8)]);
var inst_34965 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_34950);
var inst_34966 = cljs.core.first.call(null,inst_34965);
var inst_34967 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_34966);
var inst_34968 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34967)].join('');
var inst_34969 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_34968);
var state_34990__$1 = state_34990;
var statearr_34997_35023 = state_34990__$1;
(statearr_34997_35023[(2)] = inst_34969);

(statearr_34997_35023[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34991 === (13))){
var inst_34974 = (state_34990[(2)]);
var state_34990__$1 = state_34990;
var statearr_34998_35024 = state_34990__$1;
(statearr_34998_35024[(2)] = inst_34974);

(statearr_34998_35024[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34991 === (6))){
var state_34990__$1 = state_34990;
var statearr_34999_35025 = state_34990__$1;
(statearr_34999_35025[(2)] = null);

(statearr_34999_35025[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34991 === (17))){
var inst_34972 = (state_34990[(2)]);
var state_34990__$1 = state_34990;
var statearr_35000_35026 = state_34990__$1;
(statearr_35000_35026[(2)] = inst_34972);

(statearr_35000_35026[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34991 === (3))){
var inst_34988 = (state_34990[(2)]);
var state_34990__$1 = state_34990;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34990__$1,inst_34988);
} else {
if((state_val_34991 === (12))){
var inst_34949 = (state_34990[(9)]);
var inst_34963 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_34949,opts);
var state_34990__$1 = state_34990;
if(cljs.core.truth_(inst_34963)){
var statearr_35001_35027 = state_34990__$1;
(statearr_35001_35027[(1)] = (15));

} else {
var statearr_35002_35028 = state_34990__$1;
(statearr_35002_35028[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34991 === (2))){
var state_34990__$1 = state_34990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34990__$1,(4),ch);
} else {
if((state_val_34991 === (11))){
var inst_34950 = (state_34990[(8)]);
var inst_34955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34956 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_34950);
var inst_34957 = cljs.core.async.timeout.call(null,(1000));
var inst_34958 = [inst_34956,inst_34957];
var inst_34959 = (new cljs.core.PersistentVector(null,2,(5),inst_34955,inst_34958,null));
var state_34990__$1 = state_34990;
return cljs.core.async.ioc_alts_BANG_.call(null,state_34990__$1,(14),inst_34959);
} else {
if((state_val_34991 === (9))){
var inst_34950 = (state_34990[(8)]);
var inst_34976 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_34977 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_34950);
var inst_34978 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_34977);
var inst_34979 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34978)].join('');
var inst_34980 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_34979);
var state_34990__$1 = (function (){var statearr_35003 = state_34990;
(statearr_35003[(10)] = inst_34976);

return statearr_35003;
})();
var statearr_35004_35029 = state_34990__$1;
(statearr_35004_35029[(2)] = inst_34980);

(statearr_35004_35029[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34991 === (5))){
var inst_34943 = (state_34990[(7)]);
var inst_34945 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_34946 = (new cljs.core.PersistentArrayMap(null,2,inst_34945,null));
var inst_34947 = (new cljs.core.PersistentHashSet(null,inst_34946,null));
var inst_34948 = figwheel.client.focus_msgs.call(null,inst_34947,inst_34943);
var inst_34949 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_34948);
var inst_34950 = cljs.core.first.call(null,inst_34948);
var inst_34951 = figwheel.client.autoload_QMARK_.call(null);
var state_34990__$1 = (function (){var statearr_35005 = state_34990;
(statearr_35005[(8)] = inst_34950);

(statearr_35005[(9)] = inst_34949);

return statearr_35005;
})();
if(cljs.core.truth_(inst_34951)){
var statearr_35006_35030 = state_34990__$1;
(statearr_35006_35030[(1)] = (8));

} else {
var statearr_35007_35031 = state_34990__$1;
(statearr_35007_35031[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34991 === (14))){
var inst_34961 = (state_34990[(2)]);
var state_34990__$1 = state_34990;
var statearr_35008_35032 = state_34990__$1;
(statearr_35008_35032[(2)] = inst_34961);

(statearr_35008_35032[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34991 === (16))){
var state_34990__$1 = state_34990;
var statearr_35009_35033 = state_34990__$1;
(statearr_35009_35033[(2)] = null);

(statearr_35009_35033[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34991 === (10))){
var inst_34982 = (state_34990[(2)]);
var state_34990__$1 = (function (){var statearr_35010 = state_34990;
(statearr_35010[(11)] = inst_34982);

return statearr_35010;
})();
var statearr_35011_35034 = state_34990__$1;
(statearr_35011_35034[(2)] = null);

(statearr_35011_35034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34991 === (8))){
var inst_34949 = (state_34990[(9)]);
var inst_34953 = figwheel.client.reload_file_state_QMARK_.call(null,inst_34949,opts);
var state_34990__$1 = state_34990;
if(cljs.core.truth_(inst_34953)){
var statearr_35012_35035 = state_34990__$1;
(statearr_35012_35035[(1)] = (11));

} else {
var statearr_35013_35036 = state_34990__$1;
(statearr_35013_35036[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto___35018,ch))
;
return ((function (switch__30861__auto__,c__30949__auto___35018,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__30862__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__30862__auto____0 = (function (){
var statearr_35014 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35014[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__30862__auto__);

(statearr_35014[(1)] = (1));

return statearr_35014;
});
var figwheel$client$file_reloader_plugin_$_state_machine__30862__auto____1 = (function (state_34990){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_34990);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e35015){if((e35015 instanceof Object)){
var ex__30865__auto__ = e35015;
var statearr_35016_35037 = state_34990;
(statearr_35016_35037[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34990);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35015;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35038 = state_34990;
state_34990 = G__35038;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__30862__auto__ = function(state_34990){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__30862__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__30862__auto____1.call(this,state_34990);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__30862__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__30862__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___35018,ch))
})();
var state__30951__auto__ = (function (){var statearr_35017 = f__30950__auto__.call(null);
(statearr_35017[(6)] = c__30949__auto___35018);

return statearr_35017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___35018,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__35039_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__35039_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_35041 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_35041){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e35040){if((e35040 instanceof Error)){
var e = e35040;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_35041], null));
} else {
var e = e35040;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_35041))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__35042){
var map__35043 = p__35042;
var map__35043__$1 = ((((!((map__35043 == null)))?((((map__35043.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35043.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35043):map__35043);
var opts = map__35043__$1;
var build_id = cljs.core.get.call(null,map__35043__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__35043,map__35043__$1,opts,build_id){
return (function (p__35045){
var vec__35046 = p__35045;
var seq__35047 = cljs.core.seq.call(null,vec__35046);
var first__35048 = cljs.core.first.call(null,seq__35047);
var seq__35047__$1 = cljs.core.next.call(null,seq__35047);
var map__35049 = first__35048;
var map__35049__$1 = ((((!((map__35049 == null)))?((((map__35049.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35049.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35049):map__35049);
var msg = map__35049__$1;
var msg_name = cljs.core.get.call(null,map__35049__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__35047__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__35046,seq__35047,first__35048,seq__35047__$1,map__35049,map__35049__$1,msg,msg_name,_,map__35043,map__35043__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__35046,seq__35047,first__35048,seq__35047__$1,map__35049,map__35049__$1,msg,msg_name,_,map__35043,map__35043__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__35043,map__35043__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__35051){
var vec__35052 = p__35051;
var seq__35053 = cljs.core.seq.call(null,vec__35052);
var first__35054 = cljs.core.first.call(null,seq__35053);
var seq__35053__$1 = cljs.core.next.call(null,seq__35053);
var map__35055 = first__35054;
var map__35055__$1 = ((((!((map__35055 == null)))?((((map__35055.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35055.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35055):map__35055);
var msg = map__35055__$1;
var msg_name = cljs.core.get.call(null,map__35055__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__35053__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__35057){
var map__35058 = p__35057;
var map__35058__$1 = ((((!((map__35058 == null)))?((((map__35058.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35058.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35058):map__35058);
var on_compile_warning = cljs.core.get.call(null,map__35058__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__35058__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__35058,map__35058__$1,on_compile_warning,on_compile_fail){
return (function (p__35060){
var vec__35061 = p__35060;
var seq__35062 = cljs.core.seq.call(null,vec__35061);
var first__35063 = cljs.core.first.call(null,seq__35062);
var seq__35062__$1 = cljs.core.next.call(null,seq__35062);
var map__35064 = first__35063;
var map__35064__$1 = ((((!((map__35064 == null)))?((((map__35064.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35064.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35064):map__35064);
var msg = map__35064__$1;
var msg_name = cljs.core.get.call(null,map__35064__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__35062__$1;
var pred__35066 = cljs.core._EQ_;
var expr__35067 = msg_name;
if(cljs.core.truth_(pred__35066.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__35067))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__35066.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__35067))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__35058,map__35058__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__30949__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto__,msg_hist,msg_names,msg){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto__,msg_hist,msg_names,msg){
return (function (state_35156){
var state_val_35157 = (state_35156[(1)]);
if((state_val_35157 === (7))){
var inst_35076 = (state_35156[(2)]);
var state_35156__$1 = state_35156;
if(cljs.core.truth_(inst_35076)){
var statearr_35158_35205 = state_35156__$1;
(statearr_35158_35205[(1)] = (8));

} else {
var statearr_35159_35206 = state_35156__$1;
(statearr_35159_35206[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (20))){
var inst_35150 = (state_35156[(2)]);
var state_35156__$1 = state_35156;
var statearr_35160_35207 = state_35156__$1;
(statearr_35160_35207[(2)] = inst_35150);

(statearr_35160_35207[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (27))){
var inst_35146 = (state_35156[(2)]);
var state_35156__$1 = state_35156;
var statearr_35161_35208 = state_35156__$1;
(statearr_35161_35208[(2)] = inst_35146);

(statearr_35161_35208[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (1))){
var inst_35069 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_35156__$1 = state_35156;
if(cljs.core.truth_(inst_35069)){
var statearr_35162_35209 = state_35156__$1;
(statearr_35162_35209[(1)] = (2));

} else {
var statearr_35163_35210 = state_35156__$1;
(statearr_35163_35210[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (24))){
var inst_35148 = (state_35156[(2)]);
var state_35156__$1 = state_35156;
var statearr_35164_35211 = state_35156__$1;
(statearr_35164_35211[(2)] = inst_35148);

(statearr_35164_35211[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (4))){
var inst_35154 = (state_35156[(2)]);
var state_35156__$1 = state_35156;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35156__$1,inst_35154);
} else {
if((state_val_35157 === (15))){
var inst_35152 = (state_35156[(2)]);
var state_35156__$1 = state_35156;
var statearr_35165_35212 = state_35156__$1;
(statearr_35165_35212[(2)] = inst_35152);

(statearr_35165_35212[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (21))){
var inst_35105 = (state_35156[(2)]);
var inst_35106 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35107 = figwheel.client.auto_jump_to_error.call(null,opts,inst_35106);
var state_35156__$1 = (function (){var statearr_35166 = state_35156;
(statearr_35166[(7)] = inst_35105);

return statearr_35166;
})();
var statearr_35167_35213 = state_35156__$1;
(statearr_35167_35213[(2)] = inst_35107);

(statearr_35167_35213[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (31))){
var inst_35135 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_35156__$1 = state_35156;
if(cljs.core.truth_(inst_35135)){
var statearr_35168_35214 = state_35156__$1;
(statearr_35168_35214[(1)] = (34));

} else {
var statearr_35169_35215 = state_35156__$1;
(statearr_35169_35215[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (32))){
var inst_35144 = (state_35156[(2)]);
var state_35156__$1 = state_35156;
var statearr_35170_35216 = state_35156__$1;
(statearr_35170_35216[(2)] = inst_35144);

(statearr_35170_35216[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (33))){
var inst_35131 = (state_35156[(2)]);
var inst_35132 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35133 = figwheel.client.auto_jump_to_error.call(null,opts,inst_35132);
var state_35156__$1 = (function (){var statearr_35171 = state_35156;
(statearr_35171[(8)] = inst_35131);

return statearr_35171;
})();
var statearr_35172_35217 = state_35156__$1;
(statearr_35172_35217[(2)] = inst_35133);

(statearr_35172_35217[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (13))){
var inst_35090 = figwheel.client.heads_up.clear.call(null);
var state_35156__$1 = state_35156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35156__$1,(16),inst_35090);
} else {
if((state_val_35157 === (22))){
var inst_35111 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35112 = figwheel.client.heads_up.append_warning_message.call(null,inst_35111);
var state_35156__$1 = state_35156;
var statearr_35173_35218 = state_35156__$1;
(statearr_35173_35218[(2)] = inst_35112);

(statearr_35173_35218[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (36))){
var inst_35142 = (state_35156[(2)]);
var state_35156__$1 = state_35156;
var statearr_35174_35219 = state_35156__$1;
(statearr_35174_35219[(2)] = inst_35142);

(statearr_35174_35219[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (29))){
var inst_35122 = (state_35156[(2)]);
var inst_35123 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35124 = figwheel.client.auto_jump_to_error.call(null,opts,inst_35123);
var state_35156__$1 = (function (){var statearr_35175 = state_35156;
(statearr_35175[(9)] = inst_35122);

return statearr_35175;
})();
var statearr_35176_35220 = state_35156__$1;
(statearr_35176_35220[(2)] = inst_35124);

(statearr_35176_35220[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (6))){
var inst_35071 = (state_35156[(10)]);
var state_35156__$1 = state_35156;
var statearr_35177_35221 = state_35156__$1;
(statearr_35177_35221[(2)] = inst_35071);

(statearr_35177_35221[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (28))){
var inst_35118 = (state_35156[(2)]);
var inst_35119 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35120 = figwheel.client.heads_up.display_warning.call(null,inst_35119);
var state_35156__$1 = (function (){var statearr_35178 = state_35156;
(statearr_35178[(11)] = inst_35118);

return statearr_35178;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35156__$1,(29),inst_35120);
} else {
if((state_val_35157 === (25))){
var inst_35116 = figwheel.client.heads_up.clear.call(null);
var state_35156__$1 = state_35156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35156__$1,(28),inst_35116);
} else {
if((state_val_35157 === (34))){
var inst_35137 = figwheel.client.heads_up.flash_loaded.call(null);
var state_35156__$1 = state_35156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35156__$1,(37),inst_35137);
} else {
if((state_val_35157 === (17))){
var inst_35096 = (state_35156[(2)]);
var inst_35097 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35098 = figwheel.client.auto_jump_to_error.call(null,opts,inst_35097);
var state_35156__$1 = (function (){var statearr_35179 = state_35156;
(statearr_35179[(12)] = inst_35096);

return statearr_35179;
})();
var statearr_35180_35222 = state_35156__$1;
(statearr_35180_35222[(2)] = inst_35098);

(statearr_35180_35222[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (3))){
var inst_35088 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_35156__$1 = state_35156;
if(cljs.core.truth_(inst_35088)){
var statearr_35181_35223 = state_35156__$1;
(statearr_35181_35223[(1)] = (13));

} else {
var statearr_35182_35224 = state_35156__$1;
(statearr_35182_35224[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (12))){
var inst_35084 = (state_35156[(2)]);
var state_35156__$1 = state_35156;
var statearr_35183_35225 = state_35156__$1;
(statearr_35183_35225[(2)] = inst_35084);

(statearr_35183_35225[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (2))){
var inst_35071 = (state_35156[(10)]);
var inst_35071__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_35156__$1 = (function (){var statearr_35184 = state_35156;
(statearr_35184[(10)] = inst_35071__$1);

return statearr_35184;
})();
if(cljs.core.truth_(inst_35071__$1)){
var statearr_35185_35226 = state_35156__$1;
(statearr_35185_35226[(1)] = (5));

} else {
var statearr_35186_35227 = state_35156__$1;
(statearr_35186_35227[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (23))){
var inst_35114 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_35156__$1 = state_35156;
if(cljs.core.truth_(inst_35114)){
var statearr_35187_35228 = state_35156__$1;
(statearr_35187_35228[(1)] = (25));

} else {
var statearr_35188_35229 = state_35156__$1;
(statearr_35188_35229[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (35))){
var state_35156__$1 = state_35156;
var statearr_35189_35230 = state_35156__$1;
(statearr_35189_35230[(2)] = null);

(statearr_35189_35230[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (19))){
var inst_35109 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_35156__$1 = state_35156;
if(cljs.core.truth_(inst_35109)){
var statearr_35190_35231 = state_35156__$1;
(statearr_35190_35231[(1)] = (22));

} else {
var statearr_35191_35232 = state_35156__$1;
(statearr_35191_35232[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (11))){
var inst_35080 = (state_35156[(2)]);
var state_35156__$1 = state_35156;
var statearr_35192_35233 = state_35156__$1;
(statearr_35192_35233[(2)] = inst_35080);

(statearr_35192_35233[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (9))){
var inst_35082 = figwheel.client.heads_up.clear.call(null);
var state_35156__$1 = state_35156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35156__$1,(12),inst_35082);
} else {
if((state_val_35157 === (5))){
var inst_35073 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_35156__$1 = state_35156;
var statearr_35193_35234 = state_35156__$1;
(statearr_35193_35234[(2)] = inst_35073);

(statearr_35193_35234[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (14))){
var inst_35100 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_35156__$1 = state_35156;
if(cljs.core.truth_(inst_35100)){
var statearr_35194_35235 = state_35156__$1;
(statearr_35194_35235[(1)] = (18));

} else {
var statearr_35195_35236 = state_35156__$1;
(statearr_35195_35236[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (26))){
var inst_35126 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_35156__$1 = state_35156;
if(cljs.core.truth_(inst_35126)){
var statearr_35196_35237 = state_35156__$1;
(statearr_35196_35237[(1)] = (30));

} else {
var statearr_35197_35238 = state_35156__$1;
(statearr_35197_35238[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (16))){
var inst_35092 = (state_35156[(2)]);
var inst_35093 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35094 = figwheel.client.heads_up.display_exception.call(null,inst_35093);
var state_35156__$1 = (function (){var statearr_35198 = state_35156;
(statearr_35198[(13)] = inst_35092);

return statearr_35198;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35156__$1,(17),inst_35094);
} else {
if((state_val_35157 === (30))){
var inst_35128 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35129 = figwheel.client.heads_up.display_warning.call(null,inst_35128);
var state_35156__$1 = state_35156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35156__$1,(33),inst_35129);
} else {
if((state_val_35157 === (10))){
var inst_35086 = (state_35156[(2)]);
var state_35156__$1 = state_35156;
var statearr_35199_35239 = state_35156__$1;
(statearr_35199_35239[(2)] = inst_35086);

(statearr_35199_35239[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (18))){
var inst_35102 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35103 = figwheel.client.heads_up.display_exception.call(null,inst_35102);
var state_35156__$1 = state_35156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35156__$1,(21),inst_35103);
} else {
if((state_val_35157 === (37))){
var inst_35139 = (state_35156[(2)]);
var state_35156__$1 = state_35156;
var statearr_35200_35240 = state_35156__$1;
(statearr_35200_35240[(2)] = inst_35139);

(statearr_35200_35240[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35157 === (8))){
var inst_35078 = figwheel.client.heads_up.flash_loaded.call(null);
var state_35156__$1 = state_35156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35156__$1,(11),inst_35078);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__30861__auto__,c__30949__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30862__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30862__auto____0 = (function (){
var statearr_35201 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35201[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30862__auto__);

(statearr_35201[(1)] = (1));

return statearr_35201;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30862__auto____1 = (function (state_35156){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_35156);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e35202){if((e35202 instanceof Object)){
var ex__30865__auto__ = e35202;
var statearr_35203_35241 = state_35156;
(statearr_35203_35241[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35156);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35202;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35242 = state_35156;
state_35156 = G__35242;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30862__auto__ = function(state_35156){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30862__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30862__auto____1.call(this,state_35156);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30862__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30862__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto__,msg_hist,msg_names,msg))
})();
var state__30951__auto__ = (function (){var statearr_35204 = f__30950__auto__.call(null);
(statearr_35204[(6)] = c__30949__auto__);

return statearr_35204;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto__,msg_hist,msg_names,msg))
);

return c__30949__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__30949__auto___35271 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___35271,ch){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___35271,ch){
return (function (state_35257){
var state_val_35258 = (state_35257[(1)]);
if((state_val_35258 === (1))){
var state_35257__$1 = state_35257;
var statearr_35259_35272 = state_35257__$1;
(statearr_35259_35272[(2)] = null);

(statearr_35259_35272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35258 === (2))){
var state_35257__$1 = state_35257;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35257__$1,(4),ch);
} else {
if((state_val_35258 === (3))){
var inst_35255 = (state_35257[(2)]);
var state_35257__$1 = state_35257;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35257__$1,inst_35255);
} else {
if((state_val_35258 === (4))){
var inst_35245 = (state_35257[(7)]);
var inst_35245__$1 = (state_35257[(2)]);
var state_35257__$1 = (function (){var statearr_35260 = state_35257;
(statearr_35260[(7)] = inst_35245__$1);

return statearr_35260;
})();
if(cljs.core.truth_(inst_35245__$1)){
var statearr_35261_35273 = state_35257__$1;
(statearr_35261_35273[(1)] = (5));

} else {
var statearr_35262_35274 = state_35257__$1;
(statearr_35262_35274[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35258 === (5))){
var inst_35245 = (state_35257[(7)]);
var inst_35247 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_35245);
var state_35257__$1 = state_35257;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35257__$1,(8),inst_35247);
} else {
if((state_val_35258 === (6))){
var state_35257__$1 = state_35257;
var statearr_35263_35275 = state_35257__$1;
(statearr_35263_35275[(2)] = null);

(statearr_35263_35275[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35258 === (7))){
var inst_35253 = (state_35257[(2)]);
var state_35257__$1 = state_35257;
var statearr_35264_35276 = state_35257__$1;
(statearr_35264_35276[(2)] = inst_35253);

(statearr_35264_35276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35258 === (8))){
var inst_35249 = (state_35257[(2)]);
var state_35257__$1 = (function (){var statearr_35265 = state_35257;
(statearr_35265[(8)] = inst_35249);

return statearr_35265;
})();
var statearr_35266_35277 = state_35257__$1;
(statearr_35266_35277[(2)] = null);

(statearr_35266_35277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__30949__auto___35271,ch))
;
return ((function (switch__30861__auto__,c__30949__auto___35271,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__30862__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__30862__auto____0 = (function (){
var statearr_35267 = [null,null,null,null,null,null,null,null,null];
(statearr_35267[(0)] = figwheel$client$heads_up_plugin_$_state_machine__30862__auto__);

(statearr_35267[(1)] = (1));

return statearr_35267;
});
var figwheel$client$heads_up_plugin_$_state_machine__30862__auto____1 = (function (state_35257){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_35257);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e35268){if((e35268 instanceof Object)){
var ex__30865__auto__ = e35268;
var statearr_35269_35278 = state_35257;
(statearr_35269_35278[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35257);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35268;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35279 = state_35257;
state_35257 = G__35279;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__30862__auto__ = function(state_35257){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__30862__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__30862__auto____1.call(this,state_35257);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__30862__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__30862__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___35271,ch))
})();
var state__30951__auto__ = (function (){var statearr_35270 = f__30950__auto__.call(null);
(statearr_35270[(6)] = c__30949__auto___35271);

return statearr_35270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___35271,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__30949__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto__){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto__){
return (function (state_35285){
var state_val_35286 = (state_35285[(1)]);
if((state_val_35286 === (1))){
var inst_35280 = cljs.core.async.timeout.call(null,(3000));
var state_35285__$1 = state_35285;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35285__$1,(2),inst_35280);
} else {
if((state_val_35286 === (2))){
var inst_35282 = (state_35285[(2)]);
var inst_35283 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_35285__$1 = (function (){var statearr_35287 = state_35285;
(statearr_35287[(7)] = inst_35282);

return statearr_35287;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35285__$1,inst_35283);
} else {
return null;
}
}
});})(c__30949__auto__))
;
return ((function (switch__30861__auto__,c__30949__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__30862__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__30862__auto____0 = (function (){
var statearr_35288 = [null,null,null,null,null,null,null,null];
(statearr_35288[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__30862__auto__);

(statearr_35288[(1)] = (1));

return statearr_35288;
});
var figwheel$client$enforce_project_plugin_$_state_machine__30862__auto____1 = (function (state_35285){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_35285);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e35289){if((e35289 instanceof Object)){
var ex__30865__auto__ = e35289;
var statearr_35290_35292 = state_35285;
(statearr_35290_35292[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35285);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35289;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35293 = state_35285;
state_35285 = G__35293;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__30862__auto__ = function(state_35285){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__30862__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__30862__auto____1.call(this,state_35285);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__30862__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__30862__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto__))
})();
var state__30951__auto__ = (function (){var statearr_35291 = f__30950__auto__.call(null);
(statearr_35291[(6)] = c__30949__auto__);

return statearr_35291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto__))
);

return c__30949__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__4657__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__4657__auto__)){
var figwheel_version = temp__4657__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__30949__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto__,figwheel_version,temp__4657__auto__){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto__,figwheel_version,temp__4657__auto__){
return (function (state_35300){
var state_val_35301 = (state_35300[(1)]);
if((state_val_35301 === (1))){
var inst_35294 = cljs.core.async.timeout.call(null,(2000));
var state_35300__$1 = state_35300;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35300__$1,(2),inst_35294);
} else {
if((state_val_35301 === (2))){
var inst_35296 = (state_35300[(2)]);
var inst_35297 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_35298 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_35297);
var state_35300__$1 = (function (){var statearr_35302 = state_35300;
(statearr_35302[(7)] = inst_35296);

return statearr_35302;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35300__$1,inst_35298);
} else {
return null;
}
}
});})(c__30949__auto__,figwheel_version,temp__4657__auto__))
;
return ((function (switch__30861__auto__,c__30949__auto__,figwheel_version,temp__4657__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30862__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30862__auto____0 = (function (){
var statearr_35303 = [null,null,null,null,null,null,null,null];
(statearr_35303[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30862__auto__);

(statearr_35303[(1)] = (1));

return statearr_35303;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30862__auto____1 = (function (state_35300){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_35300);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e35304){if((e35304 instanceof Object)){
var ex__30865__auto__ = e35304;
var statearr_35305_35307 = state_35300;
(statearr_35305_35307[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35300);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35304;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35308 = state_35300;
state_35300 = G__35308;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30862__auto__ = function(state_35300){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30862__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30862__auto____1.call(this,state_35300);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30862__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30862__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto__,figwheel_version,temp__4657__auto__))
})();
var state__30951__auto__ = (function (){var statearr_35306 = f__30950__auto__.call(null);
(statearr_35306[(6)] = c__30949__auto__);

return statearr_35306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto__,figwheel_version,temp__4657__auto__))
);

return c__30949__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__35309){
var map__35310 = p__35309;
var map__35310__$1 = ((((!((map__35310 == null)))?((((map__35310.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35310.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35310):map__35310);
var file = cljs.core.get.call(null,map__35310__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__35310__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__35310__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__35312 = "";
var G__35312__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35312),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__35312);
var G__35312__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35312__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__35312__$1);
if(cljs.core.truth_((function (){var and__28336__auto__ = line;
if(cljs.core.truth_(and__28336__auto__)){
return column;
} else {
return and__28336__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35312__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__35312__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__35313){
var map__35314 = p__35313;
var map__35314__$1 = ((((!((map__35314 == null)))?((((map__35314.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35314.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35314):map__35314);
var ed = map__35314__$1;
var formatted_exception = cljs.core.get.call(null,map__35314__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__35314__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__35314__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__35316_35320 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__35317_35321 = null;
var count__35318_35322 = (0);
var i__35319_35323 = (0);
while(true){
if((i__35319_35323 < count__35318_35322)){
var msg_35324 = cljs.core._nth.call(null,chunk__35317_35321,i__35319_35323);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_35324);

var G__35325 = seq__35316_35320;
var G__35326 = chunk__35317_35321;
var G__35327 = count__35318_35322;
var G__35328 = (i__35319_35323 + (1));
seq__35316_35320 = G__35325;
chunk__35317_35321 = G__35326;
count__35318_35322 = G__35327;
i__35319_35323 = G__35328;
continue;
} else {
var temp__4657__auto___35329 = cljs.core.seq.call(null,seq__35316_35320);
if(temp__4657__auto___35329){
var seq__35316_35330__$1 = temp__4657__auto___35329;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35316_35330__$1)){
var c__29187__auto___35331 = cljs.core.chunk_first.call(null,seq__35316_35330__$1);
var G__35332 = cljs.core.chunk_rest.call(null,seq__35316_35330__$1);
var G__35333 = c__29187__auto___35331;
var G__35334 = cljs.core.count.call(null,c__29187__auto___35331);
var G__35335 = (0);
seq__35316_35320 = G__35332;
chunk__35317_35321 = G__35333;
count__35318_35322 = G__35334;
i__35319_35323 = G__35335;
continue;
} else {
var msg_35336 = cljs.core.first.call(null,seq__35316_35330__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_35336);

var G__35337 = cljs.core.next.call(null,seq__35316_35330__$1);
var G__35338 = null;
var G__35339 = (0);
var G__35340 = (0);
seq__35316_35320 = G__35337;
chunk__35317_35321 = G__35338;
count__35318_35322 = G__35339;
i__35319_35323 = G__35340;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__35341){
var map__35342 = p__35341;
var map__35342__$1 = ((((!((map__35342 == null)))?((((map__35342.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35342.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35342):map__35342);
var w = map__35342__$1;
var message = cljs.core.get.call(null,map__35342__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/rui-demo/public/js/compiled/demo/out/figwheel/client.cljs",33,1,363,363,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/rui-demo/public/js/compiled/demo/out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__28336__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__28336__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__28336__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_json_message_watch = (function figwheel$client$add_json_message_watch(key,callback){
return figwheel.client.add_message_watch.call(null,key,cljs.core.comp.call(null,callback,cljs.core.clj__GT_js));
});
goog.exportSymbol('figwheel.client.add_json_message_watch', figwheel.client.add_json_message_watch);
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__35344 = cljs.core.seq.call(null,plugins);
var chunk__35345 = null;
var count__35346 = (0);
var i__35347 = (0);
while(true){
if((i__35347 < count__35346)){
var vec__35348 = cljs.core._nth.call(null,chunk__35345,i__35347);
var k = cljs.core.nth.call(null,vec__35348,(0),null);
var plugin = cljs.core.nth.call(null,vec__35348,(1),null);
if(cljs.core.truth_(plugin)){
var pl_35354 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__35344,chunk__35345,count__35346,i__35347,pl_35354,vec__35348,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_35354.call(null,msg_hist);
});})(seq__35344,chunk__35345,count__35346,i__35347,pl_35354,vec__35348,k,plugin))
);
} else {
}

var G__35355 = seq__35344;
var G__35356 = chunk__35345;
var G__35357 = count__35346;
var G__35358 = (i__35347 + (1));
seq__35344 = G__35355;
chunk__35345 = G__35356;
count__35346 = G__35357;
i__35347 = G__35358;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__35344);
if(temp__4657__auto__){
var seq__35344__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35344__$1)){
var c__29187__auto__ = cljs.core.chunk_first.call(null,seq__35344__$1);
var G__35359 = cljs.core.chunk_rest.call(null,seq__35344__$1);
var G__35360 = c__29187__auto__;
var G__35361 = cljs.core.count.call(null,c__29187__auto__);
var G__35362 = (0);
seq__35344 = G__35359;
chunk__35345 = G__35360;
count__35346 = G__35361;
i__35347 = G__35362;
continue;
} else {
var vec__35351 = cljs.core.first.call(null,seq__35344__$1);
var k = cljs.core.nth.call(null,vec__35351,(0),null);
var plugin = cljs.core.nth.call(null,vec__35351,(1),null);
if(cljs.core.truth_(plugin)){
var pl_35363 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__35344,chunk__35345,count__35346,i__35347,pl_35363,vec__35351,k,plugin,seq__35344__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_35363.call(null,msg_hist);
});})(seq__35344,chunk__35345,count__35346,i__35347,pl_35363,vec__35351,k,plugin,seq__35344__$1,temp__4657__auto__))
);
} else {
}

var G__35364 = cljs.core.next.call(null,seq__35344__$1);
var G__35365 = null;
var G__35366 = (0);
var G__35367 = (0);
seq__35344 = G__35364;
chunk__35345 = G__35365;
count__35346 = G__35366;
i__35347 = G__35367;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__35369 = arguments.length;
switch (G__35369) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__35370_35375 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__35371_35376 = null;
var count__35372_35377 = (0);
var i__35373_35378 = (0);
while(true){
if((i__35373_35378 < count__35372_35377)){
var msg_35379 = cljs.core._nth.call(null,chunk__35371_35376,i__35373_35378);
figwheel.client.socket.handle_incoming_message.call(null,msg_35379);

var G__35380 = seq__35370_35375;
var G__35381 = chunk__35371_35376;
var G__35382 = count__35372_35377;
var G__35383 = (i__35373_35378 + (1));
seq__35370_35375 = G__35380;
chunk__35371_35376 = G__35381;
count__35372_35377 = G__35382;
i__35373_35378 = G__35383;
continue;
} else {
var temp__4657__auto___35384 = cljs.core.seq.call(null,seq__35370_35375);
if(temp__4657__auto___35384){
var seq__35370_35385__$1 = temp__4657__auto___35384;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35370_35385__$1)){
var c__29187__auto___35386 = cljs.core.chunk_first.call(null,seq__35370_35385__$1);
var G__35387 = cljs.core.chunk_rest.call(null,seq__35370_35385__$1);
var G__35388 = c__29187__auto___35386;
var G__35389 = cljs.core.count.call(null,c__29187__auto___35386);
var G__35390 = (0);
seq__35370_35375 = G__35387;
chunk__35371_35376 = G__35388;
count__35372_35377 = G__35389;
i__35373_35378 = G__35390;
continue;
} else {
var msg_35391 = cljs.core.first.call(null,seq__35370_35385__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_35391);

var G__35392 = cljs.core.next.call(null,seq__35370_35385__$1);
var G__35393 = null;
var G__35394 = (0);
var G__35395 = (0);
seq__35370_35375 = G__35392;
chunk__35371_35376 = G__35393;
count__35372_35377 = G__35394;
i__35373_35378 = G__35395;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__29526__auto__ = [];
var len__29519__auto___35400 = arguments.length;
var i__29520__auto___35401 = (0);
while(true){
if((i__29520__auto___35401 < len__29519__auto___35400)){
args__29526__auto__.push((arguments[i__29520__auto___35401]));

var G__35402 = (i__29520__auto___35401 + (1));
i__29520__auto___35401 = G__35402;
continue;
} else {
}
break;
}

var argseq__29527__auto__ = ((((0) < args__29526__auto__.length))?(new cljs.core.IndexedSeq(args__29526__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__29527__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__35397){
var map__35398 = p__35397;
var map__35398__$1 = ((((!((map__35398 == null)))?((((map__35398.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35398.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35398):map__35398);
var opts = map__35398__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq35396){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq35396));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e35403){if((e35403 instanceof Error)){
var e = e35403;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e35403;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__35404){
var map__35405 = p__35404;
var map__35405__$1 = ((((!((map__35405 == null)))?((((map__35405.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35405.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35405):map__35405);
var msg_name = cljs.core.get.call(null,map__35405__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1516869015771
