// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__30995 = arguments.length;
switch (G__30995) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async30996 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30996 = (function (f,blockable,meta30997){
this.f = f;
this.blockable = blockable;
this.meta30997 = meta30997;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async30996.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30998,meta30997__$1){
var self__ = this;
var _30998__$1 = this;
return (new cljs.core.async.t_cljs$core$async30996(self__.f,self__.blockable,meta30997__$1));
});

cljs.core.async.t_cljs$core$async30996.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30998){
var self__ = this;
var _30998__$1 = this;
return self__.meta30997;
});

cljs.core.async.t_cljs$core$async30996.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30996.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async30996.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async30996.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async30996.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta30997","meta30997",460332724,null)], null);
});

cljs.core.async.t_cljs$core$async30996.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30996.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30996";

cljs.core.async.t_cljs$core$async30996.cljs$lang$ctorPrWriter = (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async30996");
});

cljs.core.async.__GT_t_cljs$core$async30996 = (function cljs$core$async$__GT_t_cljs$core$async30996(f__$1,blockable__$1,meta30997){
return (new cljs.core.async.t_cljs$core$async30996(f__$1,blockable__$1,meta30997));
});

}

return (new cljs.core.async.t_cljs$core$async30996(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__31002 = arguments.length;
switch (G__31002) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__31005 = arguments.length;
switch (G__31005) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__31008 = arguments.length;
switch (G__31008) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_31010 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_31010);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_31010,ret){
return (function (){
return fn1.call(null,val_31010);
});})(val_31010,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__31012 = arguments.length;
switch (G__31012) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__29295__auto___31014 = n;
var x_31015 = (0);
while(true){
if((x_31015 < n__29295__auto___31014)){
(a[x_31015] = (0));

var G__31016 = (x_31015 + (1));
x_31015 = G__31016;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__31017 = (i + (1));
i = G__31017;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async31018 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31018 = (function (flag,meta31019){
this.flag = flag;
this.meta31019 = meta31019;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31018.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31020,meta31019__$1){
var self__ = this;
var _31020__$1 = this;
return (new cljs.core.async.t_cljs$core$async31018(self__.flag,meta31019__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async31018.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31020){
var self__ = this;
var _31020__$1 = this;
return self__.meta31019;
});})(flag))
;

cljs.core.async.t_cljs$core$async31018.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31018.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async31018.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31018.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31018.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta31019","meta31019",-1541130720,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async31018.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31018.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31018";

cljs.core.async.t_cljs$core$async31018.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async31018");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async31018 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31018(flag__$1,meta31019){
return (new cljs.core.async.t_cljs$core$async31018(flag__$1,meta31019));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async31018(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async31021 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31021 = (function (flag,cb,meta31022){
this.flag = flag;
this.cb = cb;
this.meta31022 = meta31022;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31021.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31023,meta31022__$1){
var self__ = this;
var _31023__$1 = this;
return (new cljs.core.async.t_cljs$core$async31021(self__.flag,self__.cb,meta31022__$1));
});

cljs.core.async.t_cljs$core$async31021.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31023){
var self__ = this;
var _31023__$1 = this;
return self__.meta31022;
});

cljs.core.async.t_cljs$core$async31021.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31021.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async31021.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31021.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async31021.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta31022","meta31022",270604020,null)], null);
});

cljs.core.async.t_cljs$core$async31021.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31021.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31021";

cljs.core.async.t_cljs$core$async31021.cljs$lang$ctorPrWriter = (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async31021");
});

cljs.core.async.__GT_t_cljs$core$async31021 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31021(flag__$1,cb__$1,meta31022){
return (new cljs.core.async.t_cljs$core$async31021(flag__$1,cb__$1,meta31022));
});

}

return (new cljs.core.async.t_cljs$core$async31021(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31024_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31024_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31025_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31025_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__28348__auto__ = wport;
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31026 = (i + (1));
i = G__31026;
continue;
}
} else {
return null;
}
break;
}
})();
var or__28348__auto__ = ret;
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__28336__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__28336__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__28336__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__29526__auto__ = [];
var len__29519__auto___31032 = arguments.length;
var i__29520__auto___31033 = (0);
while(true){
if((i__29520__auto___31033 < len__29519__auto___31032)){
args__29526__auto__.push((arguments[i__29520__auto___31033]));

var G__31034 = (i__29520__auto___31033 + (1));
i__29520__auto___31033 = G__31034;
continue;
} else {
}
break;
}

var argseq__29527__auto__ = ((((1) < args__29526__auto__.length))?(new cljs.core.IndexedSeq(args__29526__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29527__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31029){
var map__31030 = p__31029;
var map__31030__$1 = ((((!((map__31030 == null)))?((((map__31030.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31030.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31030):map__31030);
var opts = map__31030__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31027){
var G__31028 = cljs.core.first.call(null,seq31027);
var seq31027__$1 = cljs.core.next.call(null,seq31027);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31028,seq31027__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__31036 = arguments.length;
switch (G__31036) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30949__auto___31082 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___31082){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___31082){
return (function (state_31060){
var state_val_31061 = (state_31060[(1)]);
if((state_val_31061 === (7))){
var inst_31056 = (state_31060[(2)]);
var state_31060__$1 = state_31060;
var statearr_31062_31083 = state_31060__$1;
(statearr_31062_31083[(2)] = inst_31056);

(statearr_31062_31083[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31061 === (1))){
var state_31060__$1 = state_31060;
var statearr_31063_31084 = state_31060__$1;
(statearr_31063_31084[(2)] = null);

(statearr_31063_31084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31061 === (4))){
var inst_31039 = (state_31060[(7)]);
var inst_31039__$1 = (state_31060[(2)]);
var inst_31040 = (inst_31039__$1 == null);
var state_31060__$1 = (function (){var statearr_31064 = state_31060;
(statearr_31064[(7)] = inst_31039__$1);

return statearr_31064;
})();
if(cljs.core.truth_(inst_31040)){
var statearr_31065_31085 = state_31060__$1;
(statearr_31065_31085[(1)] = (5));

} else {
var statearr_31066_31086 = state_31060__$1;
(statearr_31066_31086[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31061 === (13))){
var state_31060__$1 = state_31060;
var statearr_31067_31087 = state_31060__$1;
(statearr_31067_31087[(2)] = null);

(statearr_31067_31087[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31061 === (6))){
var inst_31039 = (state_31060[(7)]);
var state_31060__$1 = state_31060;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31060__$1,(11),to,inst_31039);
} else {
if((state_val_31061 === (3))){
var inst_31058 = (state_31060[(2)]);
var state_31060__$1 = state_31060;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31060__$1,inst_31058);
} else {
if((state_val_31061 === (12))){
var state_31060__$1 = state_31060;
var statearr_31068_31088 = state_31060__$1;
(statearr_31068_31088[(2)] = null);

(statearr_31068_31088[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31061 === (2))){
var state_31060__$1 = state_31060;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31060__$1,(4),from);
} else {
if((state_val_31061 === (11))){
var inst_31049 = (state_31060[(2)]);
var state_31060__$1 = state_31060;
if(cljs.core.truth_(inst_31049)){
var statearr_31069_31089 = state_31060__$1;
(statearr_31069_31089[(1)] = (12));

} else {
var statearr_31070_31090 = state_31060__$1;
(statearr_31070_31090[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31061 === (9))){
var state_31060__$1 = state_31060;
var statearr_31071_31091 = state_31060__$1;
(statearr_31071_31091[(2)] = null);

(statearr_31071_31091[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31061 === (5))){
var state_31060__$1 = state_31060;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31072_31092 = state_31060__$1;
(statearr_31072_31092[(1)] = (8));

} else {
var statearr_31073_31093 = state_31060__$1;
(statearr_31073_31093[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31061 === (14))){
var inst_31054 = (state_31060[(2)]);
var state_31060__$1 = state_31060;
var statearr_31074_31094 = state_31060__$1;
(statearr_31074_31094[(2)] = inst_31054);

(statearr_31074_31094[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31061 === (10))){
var inst_31046 = (state_31060[(2)]);
var state_31060__$1 = state_31060;
var statearr_31075_31095 = state_31060__$1;
(statearr_31075_31095[(2)] = inst_31046);

(statearr_31075_31095[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31061 === (8))){
var inst_31043 = cljs.core.async.close_BANG_.call(null,to);
var state_31060__$1 = state_31060;
var statearr_31076_31096 = state_31060__$1;
(statearr_31076_31096[(2)] = inst_31043);

(statearr_31076_31096[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto___31082))
;
return ((function (switch__30861__auto__,c__30949__auto___31082){
return (function() {
var cljs$core$async$state_machine__30862__auto__ = null;
var cljs$core$async$state_machine__30862__auto____0 = (function (){
var statearr_31077 = [null,null,null,null,null,null,null,null];
(statearr_31077[(0)] = cljs$core$async$state_machine__30862__auto__);

(statearr_31077[(1)] = (1));

return statearr_31077;
});
var cljs$core$async$state_machine__30862__auto____1 = (function (state_31060){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_31060);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e31078){if((e31078 instanceof Object)){
var ex__30865__auto__ = e31078;
var statearr_31079_31097 = state_31060;
(statearr_31079_31097[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31060);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31078;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31098 = state_31060;
state_31060 = G__31098;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$state_machine__30862__auto__ = function(state_31060){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30862__auto____1.call(this,state_31060);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30862__auto____0;
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30862__auto____1;
return cljs$core$async$state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___31082))
})();
var state__30951__auto__ = (function (){var statearr_31080 = f__30950__auto__.call(null);
(statearr_31080[(6)] = c__30949__auto___31082);

return statearr_31080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___31082))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__31099){
var vec__31100 = p__31099;
var v = cljs.core.nth.call(null,vec__31100,(0),null);
var p = cljs.core.nth.call(null,vec__31100,(1),null);
var job = vec__31100;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__30949__auto___31271 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___31271,res,vec__31100,v,p,job,jobs,results){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___31271,res,vec__31100,v,p,job,jobs,results){
return (function (state_31107){
var state_val_31108 = (state_31107[(1)]);
if((state_val_31108 === (1))){
var state_31107__$1 = state_31107;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31107__$1,(2),res,v);
} else {
if((state_val_31108 === (2))){
var inst_31104 = (state_31107[(2)]);
var inst_31105 = cljs.core.async.close_BANG_.call(null,res);
var state_31107__$1 = (function (){var statearr_31109 = state_31107;
(statearr_31109[(7)] = inst_31104);

return statearr_31109;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31107__$1,inst_31105);
} else {
return null;
}
}
});})(c__30949__auto___31271,res,vec__31100,v,p,job,jobs,results))
;
return ((function (switch__30861__auto__,c__30949__auto___31271,res,vec__31100,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____0 = (function (){
var statearr_31110 = [null,null,null,null,null,null,null,null];
(statearr_31110[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__);

(statearr_31110[(1)] = (1));

return statearr_31110;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____1 = (function (state_31107){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_31107);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e31111){if((e31111 instanceof Object)){
var ex__30865__auto__ = e31111;
var statearr_31112_31272 = state_31107;
(statearr_31112_31272[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31107);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31111;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31273 = state_31107;
state_31107 = G__31273;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__ = function(state_31107){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____1.call(this,state_31107);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___31271,res,vec__31100,v,p,job,jobs,results))
})();
var state__30951__auto__ = (function (){var statearr_31113 = f__30950__auto__.call(null);
(statearr_31113[(6)] = c__30949__auto___31271);

return statearr_31113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___31271,res,vec__31100,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__31114){
var vec__31115 = p__31114;
var v = cljs.core.nth.call(null,vec__31115,(0),null);
var p = cljs.core.nth.call(null,vec__31115,(1),null);
var job = vec__31115;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__29295__auto___31274 = n;
var __31275 = (0);
while(true){
if((__31275 < n__29295__auto___31274)){
var G__31118_31276 = type;
var G__31118_31277__$1 = (((G__31118_31276 instanceof cljs.core.Keyword))?G__31118_31276.fqn:null);
switch (G__31118_31277__$1) {
case "compute":
var c__30949__auto___31279 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__31275,c__30949__auto___31279,G__31118_31276,G__31118_31277__$1,n__29295__auto___31274,jobs,results,process,async){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (__31275,c__30949__auto___31279,G__31118_31276,G__31118_31277__$1,n__29295__auto___31274,jobs,results,process,async){
return (function (state_31131){
var state_val_31132 = (state_31131[(1)]);
if((state_val_31132 === (1))){
var state_31131__$1 = state_31131;
var statearr_31133_31280 = state_31131__$1;
(statearr_31133_31280[(2)] = null);

(statearr_31133_31280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31132 === (2))){
var state_31131__$1 = state_31131;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31131__$1,(4),jobs);
} else {
if((state_val_31132 === (3))){
var inst_31129 = (state_31131[(2)]);
var state_31131__$1 = state_31131;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31131__$1,inst_31129);
} else {
if((state_val_31132 === (4))){
var inst_31121 = (state_31131[(2)]);
var inst_31122 = process.call(null,inst_31121);
var state_31131__$1 = state_31131;
if(cljs.core.truth_(inst_31122)){
var statearr_31134_31281 = state_31131__$1;
(statearr_31134_31281[(1)] = (5));

} else {
var statearr_31135_31282 = state_31131__$1;
(statearr_31135_31282[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31132 === (5))){
var state_31131__$1 = state_31131;
var statearr_31136_31283 = state_31131__$1;
(statearr_31136_31283[(2)] = null);

(statearr_31136_31283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31132 === (6))){
var state_31131__$1 = state_31131;
var statearr_31137_31284 = state_31131__$1;
(statearr_31137_31284[(2)] = null);

(statearr_31137_31284[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31132 === (7))){
var inst_31127 = (state_31131[(2)]);
var state_31131__$1 = state_31131;
var statearr_31138_31285 = state_31131__$1;
(statearr_31138_31285[(2)] = inst_31127);

(statearr_31138_31285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31275,c__30949__auto___31279,G__31118_31276,G__31118_31277__$1,n__29295__auto___31274,jobs,results,process,async))
;
return ((function (__31275,switch__30861__auto__,c__30949__auto___31279,G__31118_31276,G__31118_31277__$1,n__29295__auto___31274,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____0 = (function (){
var statearr_31139 = [null,null,null,null,null,null,null];
(statearr_31139[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__);

(statearr_31139[(1)] = (1));

return statearr_31139;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____1 = (function (state_31131){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_31131);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e31140){if((e31140 instanceof Object)){
var ex__30865__auto__ = e31140;
var statearr_31141_31286 = state_31131;
(statearr_31141_31286[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31131);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31140;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31287 = state_31131;
state_31131 = G__31287;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__ = function(state_31131){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____1.call(this,state_31131);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__;
})()
;})(__31275,switch__30861__auto__,c__30949__auto___31279,G__31118_31276,G__31118_31277__$1,n__29295__auto___31274,jobs,results,process,async))
})();
var state__30951__auto__ = (function (){var statearr_31142 = f__30950__auto__.call(null);
(statearr_31142[(6)] = c__30949__auto___31279);

return statearr_31142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(__31275,c__30949__auto___31279,G__31118_31276,G__31118_31277__$1,n__29295__auto___31274,jobs,results,process,async))
);


break;
case "async":
var c__30949__auto___31288 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__31275,c__30949__auto___31288,G__31118_31276,G__31118_31277__$1,n__29295__auto___31274,jobs,results,process,async){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (__31275,c__30949__auto___31288,G__31118_31276,G__31118_31277__$1,n__29295__auto___31274,jobs,results,process,async){
return (function (state_31155){
var state_val_31156 = (state_31155[(1)]);
if((state_val_31156 === (1))){
var state_31155__$1 = state_31155;
var statearr_31157_31289 = state_31155__$1;
(statearr_31157_31289[(2)] = null);

(statearr_31157_31289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31156 === (2))){
var state_31155__$1 = state_31155;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31155__$1,(4),jobs);
} else {
if((state_val_31156 === (3))){
var inst_31153 = (state_31155[(2)]);
var state_31155__$1 = state_31155;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31155__$1,inst_31153);
} else {
if((state_val_31156 === (4))){
var inst_31145 = (state_31155[(2)]);
var inst_31146 = async.call(null,inst_31145);
var state_31155__$1 = state_31155;
if(cljs.core.truth_(inst_31146)){
var statearr_31158_31290 = state_31155__$1;
(statearr_31158_31290[(1)] = (5));

} else {
var statearr_31159_31291 = state_31155__$1;
(statearr_31159_31291[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31156 === (5))){
var state_31155__$1 = state_31155;
var statearr_31160_31292 = state_31155__$1;
(statearr_31160_31292[(2)] = null);

(statearr_31160_31292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31156 === (6))){
var state_31155__$1 = state_31155;
var statearr_31161_31293 = state_31155__$1;
(statearr_31161_31293[(2)] = null);

(statearr_31161_31293[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31156 === (7))){
var inst_31151 = (state_31155[(2)]);
var state_31155__$1 = state_31155;
var statearr_31162_31294 = state_31155__$1;
(statearr_31162_31294[(2)] = inst_31151);

(statearr_31162_31294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31275,c__30949__auto___31288,G__31118_31276,G__31118_31277__$1,n__29295__auto___31274,jobs,results,process,async))
;
return ((function (__31275,switch__30861__auto__,c__30949__auto___31288,G__31118_31276,G__31118_31277__$1,n__29295__auto___31274,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____0 = (function (){
var statearr_31163 = [null,null,null,null,null,null,null];
(statearr_31163[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__);

(statearr_31163[(1)] = (1));

return statearr_31163;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____1 = (function (state_31155){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_31155);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e31164){if((e31164 instanceof Object)){
var ex__30865__auto__ = e31164;
var statearr_31165_31295 = state_31155;
(statearr_31165_31295[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31155);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31164;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31296 = state_31155;
state_31155 = G__31296;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__ = function(state_31155){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____1.call(this,state_31155);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__;
})()
;})(__31275,switch__30861__auto__,c__30949__auto___31288,G__31118_31276,G__31118_31277__$1,n__29295__auto___31274,jobs,results,process,async))
})();
var state__30951__auto__ = (function (){var statearr_31166 = f__30950__auto__.call(null);
(statearr_31166[(6)] = c__30949__auto___31288);

return statearr_31166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(__31275,c__30949__auto___31288,G__31118_31276,G__31118_31277__$1,n__29295__auto___31274,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31118_31277__$1)].join('')));

}

var G__31297 = (__31275 + (1));
__31275 = G__31297;
continue;
} else {
}
break;
}

var c__30949__auto___31298 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___31298,jobs,results,process,async){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___31298,jobs,results,process,async){
return (function (state_31188){
var state_val_31189 = (state_31188[(1)]);
if((state_val_31189 === (1))){
var state_31188__$1 = state_31188;
var statearr_31190_31299 = state_31188__$1;
(statearr_31190_31299[(2)] = null);

(statearr_31190_31299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31189 === (2))){
var state_31188__$1 = state_31188;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31188__$1,(4),from);
} else {
if((state_val_31189 === (3))){
var inst_31186 = (state_31188[(2)]);
var state_31188__$1 = state_31188;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31188__$1,inst_31186);
} else {
if((state_val_31189 === (4))){
var inst_31169 = (state_31188[(7)]);
var inst_31169__$1 = (state_31188[(2)]);
var inst_31170 = (inst_31169__$1 == null);
var state_31188__$1 = (function (){var statearr_31191 = state_31188;
(statearr_31191[(7)] = inst_31169__$1);

return statearr_31191;
})();
if(cljs.core.truth_(inst_31170)){
var statearr_31192_31300 = state_31188__$1;
(statearr_31192_31300[(1)] = (5));

} else {
var statearr_31193_31301 = state_31188__$1;
(statearr_31193_31301[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31189 === (5))){
var inst_31172 = cljs.core.async.close_BANG_.call(null,jobs);
var state_31188__$1 = state_31188;
var statearr_31194_31302 = state_31188__$1;
(statearr_31194_31302[(2)] = inst_31172);

(statearr_31194_31302[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31189 === (6))){
var inst_31169 = (state_31188[(7)]);
var inst_31174 = (state_31188[(8)]);
var inst_31174__$1 = cljs.core.async.chan.call(null,(1));
var inst_31175 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31176 = [inst_31169,inst_31174__$1];
var inst_31177 = (new cljs.core.PersistentVector(null,2,(5),inst_31175,inst_31176,null));
var state_31188__$1 = (function (){var statearr_31195 = state_31188;
(statearr_31195[(8)] = inst_31174__$1);

return statearr_31195;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31188__$1,(8),jobs,inst_31177);
} else {
if((state_val_31189 === (7))){
var inst_31184 = (state_31188[(2)]);
var state_31188__$1 = state_31188;
var statearr_31196_31303 = state_31188__$1;
(statearr_31196_31303[(2)] = inst_31184);

(statearr_31196_31303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31189 === (8))){
var inst_31174 = (state_31188[(8)]);
var inst_31179 = (state_31188[(2)]);
var state_31188__$1 = (function (){var statearr_31197 = state_31188;
(statearr_31197[(9)] = inst_31179);

return statearr_31197;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31188__$1,(9),results,inst_31174);
} else {
if((state_val_31189 === (9))){
var inst_31181 = (state_31188[(2)]);
var state_31188__$1 = (function (){var statearr_31198 = state_31188;
(statearr_31198[(10)] = inst_31181);

return statearr_31198;
})();
var statearr_31199_31304 = state_31188__$1;
(statearr_31199_31304[(2)] = null);

(statearr_31199_31304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__30949__auto___31298,jobs,results,process,async))
;
return ((function (switch__30861__auto__,c__30949__auto___31298,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____0 = (function (){
var statearr_31200 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31200[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__);

(statearr_31200[(1)] = (1));

return statearr_31200;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____1 = (function (state_31188){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_31188);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e31201){if((e31201 instanceof Object)){
var ex__30865__auto__ = e31201;
var statearr_31202_31305 = state_31188;
(statearr_31202_31305[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31188);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31201;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31306 = state_31188;
state_31188 = G__31306;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__ = function(state_31188){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____1.call(this,state_31188);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___31298,jobs,results,process,async))
})();
var state__30951__auto__ = (function (){var statearr_31203 = f__30950__auto__.call(null);
(statearr_31203[(6)] = c__30949__auto___31298);

return statearr_31203;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___31298,jobs,results,process,async))
);


var c__30949__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto__,jobs,results,process,async){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto__,jobs,results,process,async){
return (function (state_31241){
var state_val_31242 = (state_31241[(1)]);
if((state_val_31242 === (7))){
var inst_31237 = (state_31241[(2)]);
var state_31241__$1 = state_31241;
var statearr_31243_31307 = state_31241__$1;
(statearr_31243_31307[(2)] = inst_31237);

(statearr_31243_31307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (20))){
var state_31241__$1 = state_31241;
var statearr_31244_31308 = state_31241__$1;
(statearr_31244_31308[(2)] = null);

(statearr_31244_31308[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (1))){
var state_31241__$1 = state_31241;
var statearr_31245_31309 = state_31241__$1;
(statearr_31245_31309[(2)] = null);

(statearr_31245_31309[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (4))){
var inst_31206 = (state_31241[(7)]);
var inst_31206__$1 = (state_31241[(2)]);
var inst_31207 = (inst_31206__$1 == null);
var state_31241__$1 = (function (){var statearr_31246 = state_31241;
(statearr_31246[(7)] = inst_31206__$1);

return statearr_31246;
})();
if(cljs.core.truth_(inst_31207)){
var statearr_31247_31310 = state_31241__$1;
(statearr_31247_31310[(1)] = (5));

} else {
var statearr_31248_31311 = state_31241__$1;
(statearr_31248_31311[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (15))){
var inst_31219 = (state_31241[(8)]);
var state_31241__$1 = state_31241;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31241__$1,(18),to,inst_31219);
} else {
if((state_val_31242 === (21))){
var inst_31232 = (state_31241[(2)]);
var state_31241__$1 = state_31241;
var statearr_31249_31312 = state_31241__$1;
(statearr_31249_31312[(2)] = inst_31232);

(statearr_31249_31312[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (13))){
var inst_31234 = (state_31241[(2)]);
var state_31241__$1 = (function (){var statearr_31250 = state_31241;
(statearr_31250[(9)] = inst_31234);

return statearr_31250;
})();
var statearr_31251_31313 = state_31241__$1;
(statearr_31251_31313[(2)] = null);

(statearr_31251_31313[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (6))){
var inst_31206 = (state_31241[(7)]);
var state_31241__$1 = state_31241;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31241__$1,(11),inst_31206);
} else {
if((state_val_31242 === (17))){
var inst_31227 = (state_31241[(2)]);
var state_31241__$1 = state_31241;
if(cljs.core.truth_(inst_31227)){
var statearr_31252_31314 = state_31241__$1;
(statearr_31252_31314[(1)] = (19));

} else {
var statearr_31253_31315 = state_31241__$1;
(statearr_31253_31315[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (3))){
var inst_31239 = (state_31241[(2)]);
var state_31241__$1 = state_31241;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31241__$1,inst_31239);
} else {
if((state_val_31242 === (12))){
var inst_31216 = (state_31241[(10)]);
var state_31241__$1 = state_31241;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31241__$1,(14),inst_31216);
} else {
if((state_val_31242 === (2))){
var state_31241__$1 = state_31241;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31241__$1,(4),results);
} else {
if((state_val_31242 === (19))){
var state_31241__$1 = state_31241;
var statearr_31254_31316 = state_31241__$1;
(statearr_31254_31316[(2)] = null);

(statearr_31254_31316[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (11))){
var inst_31216 = (state_31241[(2)]);
var state_31241__$1 = (function (){var statearr_31255 = state_31241;
(statearr_31255[(10)] = inst_31216);

return statearr_31255;
})();
var statearr_31256_31317 = state_31241__$1;
(statearr_31256_31317[(2)] = null);

(statearr_31256_31317[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (9))){
var state_31241__$1 = state_31241;
var statearr_31257_31318 = state_31241__$1;
(statearr_31257_31318[(2)] = null);

(statearr_31257_31318[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (5))){
var state_31241__$1 = state_31241;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31258_31319 = state_31241__$1;
(statearr_31258_31319[(1)] = (8));

} else {
var statearr_31259_31320 = state_31241__$1;
(statearr_31259_31320[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (14))){
var inst_31219 = (state_31241[(8)]);
var inst_31221 = (state_31241[(11)]);
var inst_31219__$1 = (state_31241[(2)]);
var inst_31220 = (inst_31219__$1 == null);
var inst_31221__$1 = cljs.core.not.call(null,inst_31220);
var state_31241__$1 = (function (){var statearr_31260 = state_31241;
(statearr_31260[(8)] = inst_31219__$1);

(statearr_31260[(11)] = inst_31221__$1);

return statearr_31260;
})();
if(inst_31221__$1){
var statearr_31261_31321 = state_31241__$1;
(statearr_31261_31321[(1)] = (15));

} else {
var statearr_31262_31322 = state_31241__$1;
(statearr_31262_31322[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (16))){
var inst_31221 = (state_31241[(11)]);
var state_31241__$1 = state_31241;
var statearr_31263_31323 = state_31241__$1;
(statearr_31263_31323[(2)] = inst_31221);

(statearr_31263_31323[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (10))){
var inst_31213 = (state_31241[(2)]);
var state_31241__$1 = state_31241;
var statearr_31264_31324 = state_31241__$1;
(statearr_31264_31324[(2)] = inst_31213);

(statearr_31264_31324[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (18))){
var inst_31224 = (state_31241[(2)]);
var state_31241__$1 = state_31241;
var statearr_31265_31325 = state_31241__$1;
(statearr_31265_31325[(2)] = inst_31224);

(statearr_31265_31325[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31242 === (8))){
var inst_31210 = cljs.core.async.close_BANG_.call(null,to);
var state_31241__$1 = state_31241;
var statearr_31266_31326 = state_31241__$1;
(statearr_31266_31326[(2)] = inst_31210);

(statearr_31266_31326[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto__,jobs,results,process,async))
;
return ((function (switch__30861__auto__,c__30949__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____0 = (function (){
var statearr_31267 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31267[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__);

(statearr_31267[(1)] = (1));

return statearr_31267;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____1 = (function (state_31241){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_31241);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e31268){if((e31268 instanceof Object)){
var ex__30865__auto__ = e31268;
var statearr_31269_31327 = state_31241;
(statearr_31269_31327[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31241);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31268;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31328 = state_31241;
state_31241 = G__31328;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__ = function(state_31241){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____1.call(this,state_31241);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30862__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto__,jobs,results,process,async))
})();
var state__30951__auto__ = (function (){var statearr_31270 = f__30950__auto__.call(null);
(statearr_31270[(6)] = c__30949__auto__);

return statearr_31270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto__,jobs,results,process,async))
);

return c__30949__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__31330 = arguments.length;
switch (G__31330) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__31333 = arguments.length;
switch (G__31333) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__31336 = arguments.length;
switch (G__31336) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__30949__auto___31385 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___31385,tc,fc){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___31385,tc,fc){
return (function (state_31362){
var state_val_31363 = (state_31362[(1)]);
if((state_val_31363 === (7))){
var inst_31358 = (state_31362[(2)]);
var state_31362__$1 = state_31362;
var statearr_31364_31386 = state_31362__$1;
(statearr_31364_31386[(2)] = inst_31358);

(statearr_31364_31386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31363 === (1))){
var state_31362__$1 = state_31362;
var statearr_31365_31387 = state_31362__$1;
(statearr_31365_31387[(2)] = null);

(statearr_31365_31387[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31363 === (4))){
var inst_31339 = (state_31362[(7)]);
var inst_31339__$1 = (state_31362[(2)]);
var inst_31340 = (inst_31339__$1 == null);
var state_31362__$1 = (function (){var statearr_31366 = state_31362;
(statearr_31366[(7)] = inst_31339__$1);

return statearr_31366;
})();
if(cljs.core.truth_(inst_31340)){
var statearr_31367_31388 = state_31362__$1;
(statearr_31367_31388[(1)] = (5));

} else {
var statearr_31368_31389 = state_31362__$1;
(statearr_31368_31389[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31363 === (13))){
var state_31362__$1 = state_31362;
var statearr_31369_31390 = state_31362__$1;
(statearr_31369_31390[(2)] = null);

(statearr_31369_31390[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31363 === (6))){
var inst_31339 = (state_31362[(7)]);
var inst_31345 = p.call(null,inst_31339);
var state_31362__$1 = state_31362;
if(cljs.core.truth_(inst_31345)){
var statearr_31370_31391 = state_31362__$1;
(statearr_31370_31391[(1)] = (9));

} else {
var statearr_31371_31392 = state_31362__$1;
(statearr_31371_31392[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31363 === (3))){
var inst_31360 = (state_31362[(2)]);
var state_31362__$1 = state_31362;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31362__$1,inst_31360);
} else {
if((state_val_31363 === (12))){
var state_31362__$1 = state_31362;
var statearr_31372_31393 = state_31362__$1;
(statearr_31372_31393[(2)] = null);

(statearr_31372_31393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31363 === (2))){
var state_31362__$1 = state_31362;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31362__$1,(4),ch);
} else {
if((state_val_31363 === (11))){
var inst_31339 = (state_31362[(7)]);
var inst_31349 = (state_31362[(2)]);
var state_31362__$1 = state_31362;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31362__$1,(8),inst_31349,inst_31339);
} else {
if((state_val_31363 === (9))){
var state_31362__$1 = state_31362;
var statearr_31373_31394 = state_31362__$1;
(statearr_31373_31394[(2)] = tc);

(statearr_31373_31394[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31363 === (5))){
var inst_31342 = cljs.core.async.close_BANG_.call(null,tc);
var inst_31343 = cljs.core.async.close_BANG_.call(null,fc);
var state_31362__$1 = (function (){var statearr_31374 = state_31362;
(statearr_31374[(8)] = inst_31342);

return statearr_31374;
})();
var statearr_31375_31395 = state_31362__$1;
(statearr_31375_31395[(2)] = inst_31343);

(statearr_31375_31395[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31363 === (14))){
var inst_31356 = (state_31362[(2)]);
var state_31362__$1 = state_31362;
var statearr_31376_31396 = state_31362__$1;
(statearr_31376_31396[(2)] = inst_31356);

(statearr_31376_31396[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31363 === (10))){
var state_31362__$1 = state_31362;
var statearr_31377_31397 = state_31362__$1;
(statearr_31377_31397[(2)] = fc);

(statearr_31377_31397[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31363 === (8))){
var inst_31351 = (state_31362[(2)]);
var state_31362__$1 = state_31362;
if(cljs.core.truth_(inst_31351)){
var statearr_31378_31398 = state_31362__$1;
(statearr_31378_31398[(1)] = (12));

} else {
var statearr_31379_31399 = state_31362__$1;
(statearr_31379_31399[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto___31385,tc,fc))
;
return ((function (switch__30861__auto__,c__30949__auto___31385,tc,fc){
return (function() {
var cljs$core$async$state_machine__30862__auto__ = null;
var cljs$core$async$state_machine__30862__auto____0 = (function (){
var statearr_31380 = [null,null,null,null,null,null,null,null,null];
(statearr_31380[(0)] = cljs$core$async$state_machine__30862__auto__);

(statearr_31380[(1)] = (1));

return statearr_31380;
});
var cljs$core$async$state_machine__30862__auto____1 = (function (state_31362){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_31362);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e31381){if((e31381 instanceof Object)){
var ex__30865__auto__ = e31381;
var statearr_31382_31400 = state_31362;
(statearr_31382_31400[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31362);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31381;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31401 = state_31362;
state_31362 = G__31401;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$state_machine__30862__auto__ = function(state_31362){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30862__auto____1.call(this,state_31362);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30862__auto____0;
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30862__auto____1;
return cljs$core$async$state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___31385,tc,fc))
})();
var state__30951__auto__ = (function (){var statearr_31383 = f__30950__auto__.call(null);
(statearr_31383[(6)] = c__30949__auto___31385);

return statearr_31383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___31385,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30949__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto__){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto__){
return (function (state_31422){
var state_val_31423 = (state_31422[(1)]);
if((state_val_31423 === (7))){
var inst_31418 = (state_31422[(2)]);
var state_31422__$1 = state_31422;
var statearr_31424_31442 = state_31422__$1;
(statearr_31424_31442[(2)] = inst_31418);

(statearr_31424_31442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31423 === (1))){
var inst_31402 = init;
var state_31422__$1 = (function (){var statearr_31425 = state_31422;
(statearr_31425[(7)] = inst_31402);

return statearr_31425;
})();
var statearr_31426_31443 = state_31422__$1;
(statearr_31426_31443[(2)] = null);

(statearr_31426_31443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31423 === (4))){
var inst_31405 = (state_31422[(8)]);
var inst_31405__$1 = (state_31422[(2)]);
var inst_31406 = (inst_31405__$1 == null);
var state_31422__$1 = (function (){var statearr_31427 = state_31422;
(statearr_31427[(8)] = inst_31405__$1);

return statearr_31427;
})();
if(cljs.core.truth_(inst_31406)){
var statearr_31428_31444 = state_31422__$1;
(statearr_31428_31444[(1)] = (5));

} else {
var statearr_31429_31445 = state_31422__$1;
(statearr_31429_31445[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31423 === (6))){
var inst_31409 = (state_31422[(9)]);
var inst_31402 = (state_31422[(7)]);
var inst_31405 = (state_31422[(8)]);
var inst_31409__$1 = f.call(null,inst_31402,inst_31405);
var inst_31410 = cljs.core.reduced_QMARK_.call(null,inst_31409__$1);
var state_31422__$1 = (function (){var statearr_31430 = state_31422;
(statearr_31430[(9)] = inst_31409__$1);

return statearr_31430;
})();
if(inst_31410){
var statearr_31431_31446 = state_31422__$1;
(statearr_31431_31446[(1)] = (8));

} else {
var statearr_31432_31447 = state_31422__$1;
(statearr_31432_31447[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31423 === (3))){
var inst_31420 = (state_31422[(2)]);
var state_31422__$1 = state_31422;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31422__$1,inst_31420);
} else {
if((state_val_31423 === (2))){
var state_31422__$1 = state_31422;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31422__$1,(4),ch);
} else {
if((state_val_31423 === (9))){
var inst_31409 = (state_31422[(9)]);
var inst_31402 = inst_31409;
var state_31422__$1 = (function (){var statearr_31433 = state_31422;
(statearr_31433[(7)] = inst_31402);

return statearr_31433;
})();
var statearr_31434_31448 = state_31422__$1;
(statearr_31434_31448[(2)] = null);

(statearr_31434_31448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31423 === (5))){
var inst_31402 = (state_31422[(7)]);
var state_31422__$1 = state_31422;
var statearr_31435_31449 = state_31422__$1;
(statearr_31435_31449[(2)] = inst_31402);

(statearr_31435_31449[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31423 === (10))){
var inst_31416 = (state_31422[(2)]);
var state_31422__$1 = state_31422;
var statearr_31436_31450 = state_31422__$1;
(statearr_31436_31450[(2)] = inst_31416);

(statearr_31436_31450[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31423 === (8))){
var inst_31409 = (state_31422[(9)]);
var inst_31412 = cljs.core.deref.call(null,inst_31409);
var state_31422__$1 = state_31422;
var statearr_31437_31451 = state_31422__$1;
(statearr_31437_31451[(2)] = inst_31412);

(statearr_31437_31451[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto__))
;
return ((function (switch__30861__auto__,c__30949__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__30862__auto__ = null;
var cljs$core$async$reduce_$_state_machine__30862__auto____0 = (function (){
var statearr_31438 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31438[(0)] = cljs$core$async$reduce_$_state_machine__30862__auto__);

(statearr_31438[(1)] = (1));

return statearr_31438;
});
var cljs$core$async$reduce_$_state_machine__30862__auto____1 = (function (state_31422){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_31422);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e31439){if((e31439 instanceof Object)){
var ex__30865__auto__ = e31439;
var statearr_31440_31452 = state_31422;
(statearr_31440_31452[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31422);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31439;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31453 = state_31422;
state_31422 = G__31453;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__30862__auto__ = function(state_31422){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__30862__auto____1.call(this,state_31422);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__30862__auto____0;
cljs$core$async$reduce_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__30862__auto____1;
return cljs$core$async$reduce_$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto__))
})();
var state__30951__auto__ = (function (){var statearr_31441 = f__30950__auto__.call(null);
(statearr_31441[(6)] = c__30949__auto__);

return statearr_31441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto__))
);

return c__30949__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__30949__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto__,f__$1){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto__,f__$1){
return (function (state_31459){
var state_val_31460 = (state_31459[(1)]);
if((state_val_31460 === (1))){
var inst_31454 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_31459__$1 = state_31459;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31459__$1,(2),inst_31454);
} else {
if((state_val_31460 === (2))){
var inst_31456 = (state_31459[(2)]);
var inst_31457 = f__$1.call(null,inst_31456);
var state_31459__$1 = state_31459;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31459__$1,inst_31457);
} else {
return null;
}
}
});})(c__30949__auto__,f__$1))
;
return ((function (switch__30861__auto__,c__30949__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__30862__auto__ = null;
var cljs$core$async$transduce_$_state_machine__30862__auto____0 = (function (){
var statearr_31461 = [null,null,null,null,null,null,null];
(statearr_31461[(0)] = cljs$core$async$transduce_$_state_machine__30862__auto__);

(statearr_31461[(1)] = (1));

return statearr_31461;
});
var cljs$core$async$transduce_$_state_machine__30862__auto____1 = (function (state_31459){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_31459);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e31462){if((e31462 instanceof Object)){
var ex__30865__auto__ = e31462;
var statearr_31463_31465 = state_31459;
(statearr_31463_31465[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31459);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31462;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31466 = state_31459;
state_31459 = G__31466;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__30862__auto__ = function(state_31459){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__30862__auto____1.call(this,state_31459);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__30862__auto____0;
cljs$core$async$transduce_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__30862__auto____1;
return cljs$core$async$transduce_$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto__,f__$1))
})();
var state__30951__auto__ = (function (){var statearr_31464 = f__30950__auto__.call(null);
(statearr_31464[(6)] = c__30949__auto__);

return statearr_31464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto__,f__$1))
);

return c__30949__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__31468 = arguments.length;
switch (G__31468) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30949__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto__){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto__){
return (function (state_31493){
var state_val_31494 = (state_31493[(1)]);
if((state_val_31494 === (7))){
var inst_31475 = (state_31493[(2)]);
var state_31493__$1 = state_31493;
var statearr_31495_31516 = state_31493__$1;
(statearr_31495_31516[(2)] = inst_31475);

(statearr_31495_31516[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31494 === (1))){
var inst_31469 = cljs.core.seq.call(null,coll);
var inst_31470 = inst_31469;
var state_31493__$1 = (function (){var statearr_31496 = state_31493;
(statearr_31496[(7)] = inst_31470);

return statearr_31496;
})();
var statearr_31497_31517 = state_31493__$1;
(statearr_31497_31517[(2)] = null);

(statearr_31497_31517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31494 === (4))){
var inst_31470 = (state_31493[(7)]);
var inst_31473 = cljs.core.first.call(null,inst_31470);
var state_31493__$1 = state_31493;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31493__$1,(7),ch,inst_31473);
} else {
if((state_val_31494 === (13))){
var inst_31487 = (state_31493[(2)]);
var state_31493__$1 = state_31493;
var statearr_31498_31518 = state_31493__$1;
(statearr_31498_31518[(2)] = inst_31487);

(statearr_31498_31518[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31494 === (6))){
var inst_31478 = (state_31493[(2)]);
var state_31493__$1 = state_31493;
if(cljs.core.truth_(inst_31478)){
var statearr_31499_31519 = state_31493__$1;
(statearr_31499_31519[(1)] = (8));

} else {
var statearr_31500_31520 = state_31493__$1;
(statearr_31500_31520[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31494 === (3))){
var inst_31491 = (state_31493[(2)]);
var state_31493__$1 = state_31493;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31493__$1,inst_31491);
} else {
if((state_val_31494 === (12))){
var state_31493__$1 = state_31493;
var statearr_31501_31521 = state_31493__$1;
(statearr_31501_31521[(2)] = null);

(statearr_31501_31521[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31494 === (2))){
var inst_31470 = (state_31493[(7)]);
var state_31493__$1 = state_31493;
if(cljs.core.truth_(inst_31470)){
var statearr_31502_31522 = state_31493__$1;
(statearr_31502_31522[(1)] = (4));

} else {
var statearr_31503_31523 = state_31493__$1;
(statearr_31503_31523[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31494 === (11))){
var inst_31484 = cljs.core.async.close_BANG_.call(null,ch);
var state_31493__$1 = state_31493;
var statearr_31504_31524 = state_31493__$1;
(statearr_31504_31524[(2)] = inst_31484);

(statearr_31504_31524[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31494 === (9))){
var state_31493__$1 = state_31493;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31505_31525 = state_31493__$1;
(statearr_31505_31525[(1)] = (11));

} else {
var statearr_31506_31526 = state_31493__$1;
(statearr_31506_31526[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31494 === (5))){
var inst_31470 = (state_31493[(7)]);
var state_31493__$1 = state_31493;
var statearr_31507_31527 = state_31493__$1;
(statearr_31507_31527[(2)] = inst_31470);

(statearr_31507_31527[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31494 === (10))){
var inst_31489 = (state_31493[(2)]);
var state_31493__$1 = state_31493;
var statearr_31508_31528 = state_31493__$1;
(statearr_31508_31528[(2)] = inst_31489);

(statearr_31508_31528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31494 === (8))){
var inst_31470 = (state_31493[(7)]);
var inst_31480 = cljs.core.next.call(null,inst_31470);
var inst_31470__$1 = inst_31480;
var state_31493__$1 = (function (){var statearr_31509 = state_31493;
(statearr_31509[(7)] = inst_31470__$1);

return statearr_31509;
})();
var statearr_31510_31529 = state_31493__$1;
(statearr_31510_31529[(2)] = null);

(statearr_31510_31529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto__))
;
return ((function (switch__30861__auto__,c__30949__auto__){
return (function() {
var cljs$core$async$state_machine__30862__auto__ = null;
var cljs$core$async$state_machine__30862__auto____0 = (function (){
var statearr_31511 = [null,null,null,null,null,null,null,null];
(statearr_31511[(0)] = cljs$core$async$state_machine__30862__auto__);

(statearr_31511[(1)] = (1));

return statearr_31511;
});
var cljs$core$async$state_machine__30862__auto____1 = (function (state_31493){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_31493);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e31512){if((e31512 instanceof Object)){
var ex__30865__auto__ = e31512;
var statearr_31513_31530 = state_31493;
(statearr_31513_31530[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31493);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31512;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31531 = state_31493;
state_31493 = G__31531;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$state_machine__30862__auto__ = function(state_31493){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30862__auto____1.call(this,state_31493);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30862__auto____0;
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30862__auto____1;
return cljs$core$async$state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto__))
})();
var state__30951__auto__ = (function (){var statearr_31514 = f__30950__auto__.call(null);
(statearr_31514[(6)] = c__30949__auto__);

return statearr_31514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto__))
);

return c__30949__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__29031__auto__ = (((_ == null))?null:_);
var m__29032__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,_);
} else {
var m__29032__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__29031__auto__ = (((m == null))?null:m);
var m__29032__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__29032__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__29031__auto__ = (((m == null))?null:m);
var m__29032__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,m,ch);
} else {
var m__29032__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__29031__auto__ = (((m == null))?null:m);
var m__29032__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,m);
} else {
var m__29032__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31532 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31532 = (function (ch,cs,meta31533){
this.ch = ch;
this.cs = cs;
this.meta31533 = meta31533;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31532.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_31534,meta31533__$1){
var self__ = this;
var _31534__$1 = this;
return (new cljs.core.async.t_cljs$core$async31532(self__.ch,self__.cs,meta31533__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async31532.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_31534){
var self__ = this;
var _31534__$1 = this;
return self__.meta31533;
});})(cs))
;

cljs.core.async.t_cljs$core$async31532.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31532.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async31532.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31532.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31532.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31532.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31532.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta31533","meta31533",2028793333,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async31532.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31532.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31532";

cljs.core.async.t_cljs$core$async31532.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async31532");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async31532 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async31532(ch__$1,cs__$1,meta31533){
return (new cljs.core.async.t_cljs$core$async31532(ch__$1,cs__$1,meta31533));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async31532(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__30949__auto___31754 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___31754,cs,m,dchan,dctr,done){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___31754,cs,m,dchan,dctr,done){
return (function (state_31669){
var state_val_31670 = (state_31669[(1)]);
if((state_val_31670 === (7))){
var inst_31665 = (state_31669[(2)]);
var state_31669__$1 = state_31669;
var statearr_31671_31755 = state_31669__$1;
(statearr_31671_31755[(2)] = inst_31665);

(statearr_31671_31755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (20))){
var inst_31568 = (state_31669[(7)]);
var inst_31580 = cljs.core.first.call(null,inst_31568);
var inst_31581 = cljs.core.nth.call(null,inst_31580,(0),null);
var inst_31582 = cljs.core.nth.call(null,inst_31580,(1),null);
var state_31669__$1 = (function (){var statearr_31672 = state_31669;
(statearr_31672[(8)] = inst_31581);

return statearr_31672;
})();
if(cljs.core.truth_(inst_31582)){
var statearr_31673_31756 = state_31669__$1;
(statearr_31673_31756[(1)] = (22));

} else {
var statearr_31674_31757 = state_31669__$1;
(statearr_31674_31757[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (27))){
var inst_31610 = (state_31669[(9)]);
var inst_31612 = (state_31669[(10)]);
var inst_31617 = (state_31669[(11)]);
var inst_31537 = (state_31669[(12)]);
var inst_31617__$1 = cljs.core._nth.call(null,inst_31610,inst_31612);
var inst_31618 = cljs.core.async.put_BANG_.call(null,inst_31617__$1,inst_31537,done);
var state_31669__$1 = (function (){var statearr_31675 = state_31669;
(statearr_31675[(11)] = inst_31617__$1);

return statearr_31675;
})();
if(cljs.core.truth_(inst_31618)){
var statearr_31676_31758 = state_31669__$1;
(statearr_31676_31758[(1)] = (30));

} else {
var statearr_31677_31759 = state_31669__$1;
(statearr_31677_31759[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (1))){
var state_31669__$1 = state_31669;
var statearr_31678_31760 = state_31669__$1;
(statearr_31678_31760[(2)] = null);

(statearr_31678_31760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (24))){
var inst_31568 = (state_31669[(7)]);
var inst_31587 = (state_31669[(2)]);
var inst_31588 = cljs.core.next.call(null,inst_31568);
var inst_31546 = inst_31588;
var inst_31547 = null;
var inst_31548 = (0);
var inst_31549 = (0);
var state_31669__$1 = (function (){var statearr_31679 = state_31669;
(statearr_31679[(13)] = inst_31549);

(statearr_31679[(14)] = inst_31546);

(statearr_31679[(15)] = inst_31547);

(statearr_31679[(16)] = inst_31548);

(statearr_31679[(17)] = inst_31587);

return statearr_31679;
})();
var statearr_31680_31761 = state_31669__$1;
(statearr_31680_31761[(2)] = null);

(statearr_31680_31761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (39))){
var state_31669__$1 = state_31669;
var statearr_31684_31762 = state_31669__$1;
(statearr_31684_31762[(2)] = null);

(statearr_31684_31762[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (4))){
var inst_31537 = (state_31669[(12)]);
var inst_31537__$1 = (state_31669[(2)]);
var inst_31538 = (inst_31537__$1 == null);
var state_31669__$1 = (function (){var statearr_31685 = state_31669;
(statearr_31685[(12)] = inst_31537__$1);

return statearr_31685;
})();
if(cljs.core.truth_(inst_31538)){
var statearr_31686_31763 = state_31669__$1;
(statearr_31686_31763[(1)] = (5));

} else {
var statearr_31687_31764 = state_31669__$1;
(statearr_31687_31764[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (15))){
var inst_31549 = (state_31669[(13)]);
var inst_31546 = (state_31669[(14)]);
var inst_31547 = (state_31669[(15)]);
var inst_31548 = (state_31669[(16)]);
var inst_31564 = (state_31669[(2)]);
var inst_31565 = (inst_31549 + (1));
var tmp31681 = inst_31546;
var tmp31682 = inst_31547;
var tmp31683 = inst_31548;
var inst_31546__$1 = tmp31681;
var inst_31547__$1 = tmp31682;
var inst_31548__$1 = tmp31683;
var inst_31549__$1 = inst_31565;
var state_31669__$1 = (function (){var statearr_31688 = state_31669;
(statearr_31688[(13)] = inst_31549__$1);

(statearr_31688[(14)] = inst_31546__$1);

(statearr_31688[(15)] = inst_31547__$1);

(statearr_31688[(16)] = inst_31548__$1);

(statearr_31688[(18)] = inst_31564);

return statearr_31688;
})();
var statearr_31689_31765 = state_31669__$1;
(statearr_31689_31765[(2)] = null);

(statearr_31689_31765[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (21))){
var inst_31591 = (state_31669[(2)]);
var state_31669__$1 = state_31669;
var statearr_31693_31766 = state_31669__$1;
(statearr_31693_31766[(2)] = inst_31591);

(statearr_31693_31766[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (31))){
var inst_31617 = (state_31669[(11)]);
var inst_31621 = done.call(null,null);
var inst_31622 = cljs.core.async.untap_STAR_.call(null,m,inst_31617);
var state_31669__$1 = (function (){var statearr_31694 = state_31669;
(statearr_31694[(19)] = inst_31621);

return statearr_31694;
})();
var statearr_31695_31767 = state_31669__$1;
(statearr_31695_31767[(2)] = inst_31622);

(statearr_31695_31767[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (32))){
var inst_31610 = (state_31669[(9)]);
var inst_31611 = (state_31669[(20)]);
var inst_31612 = (state_31669[(10)]);
var inst_31609 = (state_31669[(21)]);
var inst_31624 = (state_31669[(2)]);
var inst_31625 = (inst_31612 + (1));
var tmp31690 = inst_31610;
var tmp31691 = inst_31611;
var tmp31692 = inst_31609;
var inst_31609__$1 = tmp31692;
var inst_31610__$1 = tmp31690;
var inst_31611__$1 = tmp31691;
var inst_31612__$1 = inst_31625;
var state_31669__$1 = (function (){var statearr_31696 = state_31669;
(statearr_31696[(9)] = inst_31610__$1);

(statearr_31696[(20)] = inst_31611__$1);

(statearr_31696[(10)] = inst_31612__$1);

(statearr_31696[(22)] = inst_31624);

(statearr_31696[(21)] = inst_31609__$1);

return statearr_31696;
})();
var statearr_31697_31768 = state_31669__$1;
(statearr_31697_31768[(2)] = null);

(statearr_31697_31768[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (40))){
var inst_31637 = (state_31669[(23)]);
var inst_31641 = done.call(null,null);
var inst_31642 = cljs.core.async.untap_STAR_.call(null,m,inst_31637);
var state_31669__$1 = (function (){var statearr_31698 = state_31669;
(statearr_31698[(24)] = inst_31641);

return statearr_31698;
})();
var statearr_31699_31769 = state_31669__$1;
(statearr_31699_31769[(2)] = inst_31642);

(statearr_31699_31769[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (33))){
var inst_31628 = (state_31669[(25)]);
var inst_31630 = cljs.core.chunked_seq_QMARK_.call(null,inst_31628);
var state_31669__$1 = state_31669;
if(inst_31630){
var statearr_31700_31770 = state_31669__$1;
(statearr_31700_31770[(1)] = (36));

} else {
var statearr_31701_31771 = state_31669__$1;
(statearr_31701_31771[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (13))){
var inst_31558 = (state_31669[(26)]);
var inst_31561 = cljs.core.async.close_BANG_.call(null,inst_31558);
var state_31669__$1 = state_31669;
var statearr_31702_31772 = state_31669__$1;
(statearr_31702_31772[(2)] = inst_31561);

(statearr_31702_31772[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (22))){
var inst_31581 = (state_31669[(8)]);
var inst_31584 = cljs.core.async.close_BANG_.call(null,inst_31581);
var state_31669__$1 = state_31669;
var statearr_31703_31773 = state_31669__$1;
(statearr_31703_31773[(2)] = inst_31584);

(statearr_31703_31773[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (36))){
var inst_31628 = (state_31669[(25)]);
var inst_31632 = cljs.core.chunk_first.call(null,inst_31628);
var inst_31633 = cljs.core.chunk_rest.call(null,inst_31628);
var inst_31634 = cljs.core.count.call(null,inst_31632);
var inst_31609 = inst_31633;
var inst_31610 = inst_31632;
var inst_31611 = inst_31634;
var inst_31612 = (0);
var state_31669__$1 = (function (){var statearr_31704 = state_31669;
(statearr_31704[(9)] = inst_31610);

(statearr_31704[(20)] = inst_31611);

(statearr_31704[(10)] = inst_31612);

(statearr_31704[(21)] = inst_31609);

return statearr_31704;
})();
var statearr_31705_31774 = state_31669__$1;
(statearr_31705_31774[(2)] = null);

(statearr_31705_31774[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (41))){
var inst_31628 = (state_31669[(25)]);
var inst_31644 = (state_31669[(2)]);
var inst_31645 = cljs.core.next.call(null,inst_31628);
var inst_31609 = inst_31645;
var inst_31610 = null;
var inst_31611 = (0);
var inst_31612 = (0);
var state_31669__$1 = (function (){var statearr_31706 = state_31669;
(statearr_31706[(9)] = inst_31610);

(statearr_31706[(27)] = inst_31644);

(statearr_31706[(20)] = inst_31611);

(statearr_31706[(10)] = inst_31612);

(statearr_31706[(21)] = inst_31609);

return statearr_31706;
})();
var statearr_31707_31775 = state_31669__$1;
(statearr_31707_31775[(2)] = null);

(statearr_31707_31775[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (43))){
var state_31669__$1 = state_31669;
var statearr_31708_31776 = state_31669__$1;
(statearr_31708_31776[(2)] = null);

(statearr_31708_31776[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (29))){
var inst_31653 = (state_31669[(2)]);
var state_31669__$1 = state_31669;
var statearr_31709_31777 = state_31669__$1;
(statearr_31709_31777[(2)] = inst_31653);

(statearr_31709_31777[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (44))){
var inst_31662 = (state_31669[(2)]);
var state_31669__$1 = (function (){var statearr_31710 = state_31669;
(statearr_31710[(28)] = inst_31662);

return statearr_31710;
})();
var statearr_31711_31778 = state_31669__$1;
(statearr_31711_31778[(2)] = null);

(statearr_31711_31778[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (6))){
var inst_31601 = (state_31669[(29)]);
var inst_31600 = cljs.core.deref.call(null,cs);
var inst_31601__$1 = cljs.core.keys.call(null,inst_31600);
var inst_31602 = cljs.core.count.call(null,inst_31601__$1);
var inst_31603 = cljs.core.reset_BANG_.call(null,dctr,inst_31602);
var inst_31608 = cljs.core.seq.call(null,inst_31601__$1);
var inst_31609 = inst_31608;
var inst_31610 = null;
var inst_31611 = (0);
var inst_31612 = (0);
var state_31669__$1 = (function (){var statearr_31712 = state_31669;
(statearr_31712[(9)] = inst_31610);

(statearr_31712[(29)] = inst_31601__$1);

(statearr_31712[(20)] = inst_31611);

(statearr_31712[(10)] = inst_31612);

(statearr_31712[(21)] = inst_31609);

(statearr_31712[(30)] = inst_31603);

return statearr_31712;
})();
var statearr_31713_31779 = state_31669__$1;
(statearr_31713_31779[(2)] = null);

(statearr_31713_31779[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (28))){
var inst_31628 = (state_31669[(25)]);
var inst_31609 = (state_31669[(21)]);
var inst_31628__$1 = cljs.core.seq.call(null,inst_31609);
var state_31669__$1 = (function (){var statearr_31714 = state_31669;
(statearr_31714[(25)] = inst_31628__$1);

return statearr_31714;
})();
if(inst_31628__$1){
var statearr_31715_31780 = state_31669__$1;
(statearr_31715_31780[(1)] = (33));

} else {
var statearr_31716_31781 = state_31669__$1;
(statearr_31716_31781[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (25))){
var inst_31611 = (state_31669[(20)]);
var inst_31612 = (state_31669[(10)]);
var inst_31614 = (inst_31612 < inst_31611);
var inst_31615 = inst_31614;
var state_31669__$1 = state_31669;
if(cljs.core.truth_(inst_31615)){
var statearr_31717_31782 = state_31669__$1;
(statearr_31717_31782[(1)] = (27));

} else {
var statearr_31718_31783 = state_31669__$1;
(statearr_31718_31783[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (34))){
var state_31669__$1 = state_31669;
var statearr_31719_31784 = state_31669__$1;
(statearr_31719_31784[(2)] = null);

(statearr_31719_31784[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (17))){
var state_31669__$1 = state_31669;
var statearr_31720_31785 = state_31669__$1;
(statearr_31720_31785[(2)] = null);

(statearr_31720_31785[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (3))){
var inst_31667 = (state_31669[(2)]);
var state_31669__$1 = state_31669;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31669__$1,inst_31667);
} else {
if((state_val_31670 === (12))){
var inst_31596 = (state_31669[(2)]);
var state_31669__$1 = state_31669;
var statearr_31721_31786 = state_31669__$1;
(statearr_31721_31786[(2)] = inst_31596);

(statearr_31721_31786[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (2))){
var state_31669__$1 = state_31669;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31669__$1,(4),ch);
} else {
if((state_val_31670 === (23))){
var state_31669__$1 = state_31669;
var statearr_31722_31787 = state_31669__$1;
(statearr_31722_31787[(2)] = null);

(statearr_31722_31787[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (35))){
var inst_31651 = (state_31669[(2)]);
var state_31669__$1 = state_31669;
var statearr_31723_31788 = state_31669__$1;
(statearr_31723_31788[(2)] = inst_31651);

(statearr_31723_31788[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (19))){
var inst_31568 = (state_31669[(7)]);
var inst_31572 = cljs.core.chunk_first.call(null,inst_31568);
var inst_31573 = cljs.core.chunk_rest.call(null,inst_31568);
var inst_31574 = cljs.core.count.call(null,inst_31572);
var inst_31546 = inst_31573;
var inst_31547 = inst_31572;
var inst_31548 = inst_31574;
var inst_31549 = (0);
var state_31669__$1 = (function (){var statearr_31724 = state_31669;
(statearr_31724[(13)] = inst_31549);

(statearr_31724[(14)] = inst_31546);

(statearr_31724[(15)] = inst_31547);

(statearr_31724[(16)] = inst_31548);

return statearr_31724;
})();
var statearr_31725_31789 = state_31669__$1;
(statearr_31725_31789[(2)] = null);

(statearr_31725_31789[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (11))){
var inst_31568 = (state_31669[(7)]);
var inst_31546 = (state_31669[(14)]);
var inst_31568__$1 = cljs.core.seq.call(null,inst_31546);
var state_31669__$1 = (function (){var statearr_31726 = state_31669;
(statearr_31726[(7)] = inst_31568__$1);

return statearr_31726;
})();
if(inst_31568__$1){
var statearr_31727_31790 = state_31669__$1;
(statearr_31727_31790[(1)] = (16));

} else {
var statearr_31728_31791 = state_31669__$1;
(statearr_31728_31791[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (9))){
var inst_31598 = (state_31669[(2)]);
var state_31669__$1 = state_31669;
var statearr_31729_31792 = state_31669__$1;
(statearr_31729_31792[(2)] = inst_31598);

(statearr_31729_31792[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (5))){
var inst_31544 = cljs.core.deref.call(null,cs);
var inst_31545 = cljs.core.seq.call(null,inst_31544);
var inst_31546 = inst_31545;
var inst_31547 = null;
var inst_31548 = (0);
var inst_31549 = (0);
var state_31669__$1 = (function (){var statearr_31730 = state_31669;
(statearr_31730[(13)] = inst_31549);

(statearr_31730[(14)] = inst_31546);

(statearr_31730[(15)] = inst_31547);

(statearr_31730[(16)] = inst_31548);

return statearr_31730;
})();
var statearr_31731_31793 = state_31669__$1;
(statearr_31731_31793[(2)] = null);

(statearr_31731_31793[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (14))){
var state_31669__$1 = state_31669;
var statearr_31732_31794 = state_31669__$1;
(statearr_31732_31794[(2)] = null);

(statearr_31732_31794[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (45))){
var inst_31659 = (state_31669[(2)]);
var state_31669__$1 = state_31669;
var statearr_31733_31795 = state_31669__$1;
(statearr_31733_31795[(2)] = inst_31659);

(statearr_31733_31795[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (26))){
var inst_31601 = (state_31669[(29)]);
var inst_31655 = (state_31669[(2)]);
var inst_31656 = cljs.core.seq.call(null,inst_31601);
var state_31669__$1 = (function (){var statearr_31734 = state_31669;
(statearr_31734[(31)] = inst_31655);

return statearr_31734;
})();
if(inst_31656){
var statearr_31735_31796 = state_31669__$1;
(statearr_31735_31796[(1)] = (42));

} else {
var statearr_31736_31797 = state_31669__$1;
(statearr_31736_31797[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (16))){
var inst_31568 = (state_31669[(7)]);
var inst_31570 = cljs.core.chunked_seq_QMARK_.call(null,inst_31568);
var state_31669__$1 = state_31669;
if(inst_31570){
var statearr_31737_31798 = state_31669__$1;
(statearr_31737_31798[(1)] = (19));

} else {
var statearr_31738_31799 = state_31669__$1;
(statearr_31738_31799[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (38))){
var inst_31648 = (state_31669[(2)]);
var state_31669__$1 = state_31669;
var statearr_31739_31800 = state_31669__$1;
(statearr_31739_31800[(2)] = inst_31648);

(statearr_31739_31800[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (30))){
var state_31669__$1 = state_31669;
var statearr_31740_31801 = state_31669__$1;
(statearr_31740_31801[(2)] = null);

(statearr_31740_31801[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (10))){
var inst_31549 = (state_31669[(13)]);
var inst_31547 = (state_31669[(15)]);
var inst_31557 = cljs.core._nth.call(null,inst_31547,inst_31549);
var inst_31558 = cljs.core.nth.call(null,inst_31557,(0),null);
var inst_31559 = cljs.core.nth.call(null,inst_31557,(1),null);
var state_31669__$1 = (function (){var statearr_31741 = state_31669;
(statearr_31741[(26)] = inst_31558);

return statearr_31741;
})();
if(cljs.core.truth_(inst_31559)){
var statearr_31742_31802 = state_31669__$1;
(statearr_31742_31802[(1)] = (13));

} else {
var statearr_31743_31803 = state_31669__$1;
(statearr_31743_31803[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (18))){
var inst_31594 = (state_31669[(2)]);
var state_31669__$1 = state_31669;
var statearr_31744_31804 = state_31669__$1;
(statearr_31744_31804[(2)] = inst_31594);

(statearr_31744_31804[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (42))){
var state_31669__$1 = state_31669;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31669__$1,(45),dchan);
} else {
if((state_val_31670 === (37))){
var inst_31628 = (state_31669[(25)]);
var inst_31637 = (state_31669[(23)]);
var inst_31537 = (state_31669[(12)]);
var inst_31637__$1 = cljs.core.first.call(null,inst_31628);
var inst_31638 = cljs.core.async.put_BANG_.call(null,inst_31637__$1,inst_31537,done);
var state_31669__$1 = (function (){var statearr_31745 = state_31669;
(statearr_31745[(23)] = inst_31637__$1);

return statearr_31745;
})();
if(cljs.core.truth_(inst_31638)){
var statearr_31746_31805 = state_31669__$1;
(statearr_31746_31805[(1)] = (39));

} else {
var statearr_31747_31806 = state_31669__$1;
(statearr_31747_31806[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31670 === (8))){
var inst_31549 = (state_31669[(13)]);
var inst_31548 = (state_31669[(16)]);
var inst_31551 = (inst_31549 < inst_31548);
var inst_31552 = inst_31551;
var state_31669__$1 = state_31669;
if(cljs.core.truth_(inst_31552)){
var statearr_31748_31807 = state_31669__$1;
(statearr_31748_31807[(1)] = (10));

} else {
var statearr_31749_31808 = state_31669__$1;
(statearr_31749_31808[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto___31754,cs,m,dchan,dctr,done))
;
return ((function (switch__30861__auto__,c__30949__auto___31754,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__30862__auto__ = null;
var cljs$core$async$mult_$_state_machine__30862__auto____0 = (function (){
var statearr_31750 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31750[(0)] = cljs$core$async$mult_$_state_machine__30862__auto__);

(statearr_31750[(1)] = (1));

return statearr_31750;
});
var cljs$core$async$mult_$_state_machine__30862__auto____1 = (function (state_31669){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_31669);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e31751){if((e31751 instanceof Object)){
var ex__30865__auto__ = e31751;
var statearr_31752_31809 = state_31669;
(statearr_31752_31809[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31669);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31751;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31810 = state_31669;
state_31669 = G__31810;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__30862__auto__ = function(state_31669){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__30862__auto____1.call(this,state_31669);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__30862__auto____0;
cljs$core$async$mult_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__30862__auto____1;
return cljs$core$async$mult_$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___31754,cs,m,dchan,dctr,done))
})();
var state__30951__auto__ = (function (){var statearr_31753 = f__30950__auto__.call(null);
(statearr_31753[(6)] = c__30949__auto___31754);

return statearr_31753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___31754,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__31812 = arguments.length;
switch (G__31812) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__29031__auto__ = (((m == null))?null:m);
var m__29032__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,m,ch);
} else {
var m__29032__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__29031__auto__ = (((m == null))?null:m);
var m__29032__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,m,ch);
} else {
var m__29032__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__29031__auto__ = (((m == null))?null:m);
var m__29032__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,m);
} else {
var m__29032__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__29031__auto__ = (((m == null))?null:m);
var m__29032__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,m,state_map);
} else {
var m__29032__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__29031__auto__ = (((m == null))?null:m);
var m__29032__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,m,mode);
} else {
var m__29032__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__29526__auto__ = [];
var len__29519__auto___31824 = arguments.length;
var i__29520__auto___31825 = (0);
while(true){
if((i__29520__auto___31825 < len__29519__auto___31824)){
args__29526__auto__.push((arguments[i__29520__auto___31825]));

var G__31826 = (i__29520__auto___31825 + (1));
i__29520__auto___31825 = G__31826;
continue;
} else {
}
break;
}

var argseq__29527__auto__ = ((((3) < args__29526__auto__.length))?(new cljs.core.IndexedSeq(args__29526__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29527__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31818){
var map__31819 = p__31818;
var map__31819__$1 = ((((!((map__31819 == null)))?((((map__31819.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31819.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31819):map__31819);
var opts = map__31819__$1;
var statearr_31821_31827 = state;
(statearr_31821_31827[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__31819,map__31819__$1,opts){
return (function (val){
var statearr_31822_31828 = state;
(statearr_31822_31828[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__31819,map__31819__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_31823_31829 = state;
(statearr_31823_31829[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31814){
var G__31815 = cljs.core.first.call(null,seq31814);
var seq31814__$1 = cljs.core.next.call(null,seq31814);
var G__31816 = cljs.core.first.call(null,seq31814__$1);
var seq31814__$2 = cljs.core.next.call(null,seq31814__$1);
var G__31817 = cljs.core.first.call(null,seq31814__$2);
var seq31814__$3 = cljs.core.next.call(null,seq31814__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31815,G__31816,G__31817,seq31814__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31830 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31830 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta31831){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta31831 = meta31831;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31830.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31832,meta31831__$1){
var self__ = this;
var _31832__$1 = this;
return (new cljs.core.async.t_cljs$core$async31830(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta31831__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31830.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31832){
var self__ = this;
var _31832__$1 = this;
return self__.meta31831;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31830.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31830.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31830.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31830.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31830.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31830.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31830.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31830.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31830.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta31831","meta31831",1922578344,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31830.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31830.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31830";

cljs.core.async.t_cljs$core$async31830.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async31830");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async31830 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async31830(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31831){
return (new cljs.core.async.t_cljs$core$async31830(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31831));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async31830(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30949__auto___31994 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___31994,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___31994,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_31934){
var state_val_31935 = (state_31934[(1)]);
if((state_val_31935 === (7))){
var inst_31849 = (state_31934[(2)]);
var state_31934__$1 = state_31934;
var statearr_31936_31995 = state_31934__$1;
(statearr_31936_31995[(2)] = inst_31849);

(statearr_31936_31995[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (20))){
var inst_31861 = (state_31934[(7)]);
var state_31934__$1 = state_31934;
var statearr_31937_31996 = state_31934__$1;
(statearr_31937_31996[(2)] = inst_31861);

(statearr_31937_31996[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (27))){
var state_31934__$1 = state_31934;
var statearr_31938_31997 = state_31934__$1;
(statearr_31938_31997[(2)] = null);

(statearr_31938_31997[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (1))){
var inst_31836 = (state_31934[(8)]);
var inst_31836__$1 = calc_state.call(null);
var inst_31838 = (inst_31836__$1 == null);
var inst_31839 = cljs.core.not.call(null,inst_31838);
var state_31934__$1 = (function (){var statearr_31939 = state_31934;
(statearr_31939[(8)] = inst_31836__$1);

return statearr_31939;
})();
if(inst_31839){
var statearr_31940_31998 = state_31934__$1;
(statearr_31940_31998[(1)] = (2));

} else {
var statearr_31941_31999 = state_31934__$1;
(statearr_31941_31999[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (24))){
var inst_31885 = (state_31934[(9)]);
var inst_31908 = (state_31934[(10)]);
var inst_31894 = (state_31934[(11)]);
var inst_31908__$1 = inst_31885.call(null,inst_31894);
var state_31934__$1 = (function (){var statearr_31942 = state_31934;
(statearr_31942[(10)] = inst_31908__$1);

return statearr_31942;
})();
if(cljs.core.truth_(inst_31908__$1)){
var statearr_31943_32000 = state_31934__$1;
(statearr_31943_32000[(1)] = (29));

} else {
var statearr_31944_32001 = state_31934__$1;
(statearr_31944_32001[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (4))){
var inst_31852 = (state_31934[(2)]);
var state_31934__$1 = state_31934;
if(cljs.core.truth_(inst_31852)){
var statearr_31945_32002 = state_31934__$1;
(statearr_31945_32002[(1)] = (8));

} else {
var statearr_31946_32003 = state_31934__$1;
(statearr_31946_32003[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (15))){
var inst_31879 = (state_31934[(2)]);
var state_31934__$1 = state_31934;
if(cljs.core.truth_(inst_31879)){
var statearr_31947_32004 = state_31934__$1;
(statearr_31947_32004[(1)] = (19));

} else {
var statearr_31948_32005 = state_31934__$1;
(statearr_31948_32005[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (21))){
var inst_31884 = (state_31934[(12)]);
var inst_31884__$1 = (state_31934[(2)]);
var inst_31885 = cljs.core.get.call(null,inst_31884__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31886 = cljs.core.get.call(null,inst_31884__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31887 = cljs.core.get.call(null,inst_31884__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31934__$1 = (function (){var statearr_31949 = state_31934;
(statearr_31949[(13)] = inst_31886);

(statearr_31949[(9)] = inst_31885);

(statearr_31949[(12)] = inst_31884__$1);

return statearr_31949;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31934__$1,(22),inst_31887);
} else {
if((state_val_31935 === (31))){
var inst_31916 = (state_31934[(2)]);
var state_31934__$1 = state_31934;
if(cljs.core.truth_(inst_31916)){
var statearr_31950_32006 = state_31934__$1;
(statearr_31950_32006[(1)] = (32));

} else {
var statearr_31951_32007 = state_31934__$1;
(statearr_31951_32007[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (32))){
var inst_31893 = (state_31934[(14)]);
var state_31934__$1 = state_31934;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31934__$1,(35),out,inst_31893);
} else {
if((state_val_31935 === (33))){
var inst_31884 = (state_31934[(12)]);
var inst_31861 = inst_31884;
var state_31934__$1 = (function (){var statearr_31952 = state_31934;
(statearr_31952[(7)] = inst_31861);

return statearr_31952;
})();
var statearr_31953_32008 = state_31934__$1;
(statearr_31953_32008[(2)] = null);

(statearr_31953_32008[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (13))){
var inst_31861 = (state_31934[(7)]);
var inst_31868 = inst_31861.cljs$lang$protocol_mask$partition0$;
var inst_31869 = (inst_31868 & (64));
var inst_31870 = inst_31861.cljs$core$ISeq$;
var inst_31871 = (cljs.core.PROTOCOL_SENTINEL === inst_31870);
var inst_31872 = (inst_31869) || (inst_31871);
var state_31934__$1 = state_31934;
if(cljs.core.truth_(inst_31872)){
var statearr_31954_32009 = state_31934__$1;
(statearr_31954_32009[(1)] = (16));

} else {
var statearr_31955_32010 = state_31934__$1;
(statearr_31955_32010[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (22))){
var inst_31893 = (state_31934[(14)]);
var inst_31894 = (state_31934[(11)]);
var inst_31892 = (state_31934[(2)]);
var inst_31893__$1 = cljs.core.nth.call(null,inst_31892,(0),null);
var inst_31894__$1 = cljs.core.nth.call(null,inst_31892,(1),null);
var inst_31895 = (inst_31893__$1 == null);
var inst_31896 = cljs.core._EQ_.call(null,inst_31894__$1,change);
var inst_31897 = (inst_31895) || (inst_31896);
var state_31934__$1 = (function (){var statearr_31956 = state_31934;
(statearr_31956[(14)] = inst_31893__$1);

(statearr_31956[(11)] = inst_31894__$1);

return statearr_31956;
})();
if(cljs.core.truth_(inst_31897)){
var statearr_31957_32011 = state_31934__$1;
(statearr_31957_32011[(1)] = (23));

} else {
var statearr_31958_32012 = state_31934__$1;
(statearr_31958_32012[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (36))){
var inst_31884 = (state_31934[(12)]);
var inst_31861 = inst_31884;
var state_31934__$1 = (function (){var statearr_31959 = state_31934;
(statearr_31959[(7)] = inst_31861);

return statearr_31959;
})();
var statearr_31960_32013 = state_31934__$1;
(statearr_31960_32013[(2)] = null);

(statearr_31960_32013[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (29))){
var inst_31908 = (state_31934[(10)]);
var state_31934__$1 = state_31934;
var statearr_31961_32014 = state_31934__$1;
(statearr_31961_32014[(2)] = inst_31908);

(statearr_31961_32014[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (6))){
var state_31934__$1 = state_31934;
var statearr_31962_32015 = state_31934__$1;
(statearr_31962_32015[(2)] = false);

(statearr_31962_32015[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (28))){
var inst_31904 = (state_31934[(2)]);
var inst_31905 = calc_state.call(null);
var inst_31861 = inst_31905;
var state_31934__$1 = (function (){var statearr_31963 = state_31934;
(statearr_31963[(7)] = inst_31861);

(statearr_31963[(15)] = inst_31904);

return statearr_31963;
})();
var statearr_31964_32016 = state_31934__$1;
(statearr_31964_32016[(2)] = null);

(statearr_31964_32016[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (25))){
var inst_31930 = (state_31934[(2)]);
var state_31934__$1 = state_31934;
var statearr_31965_32017 = state_31934__$1;
(statearr_31965_32017[(2)] = inst_31930);

(statearr_31965_32017[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (34))){
var inst_31928 = (state_31934[(2)]);
var state_31934__$1 = state_31934;
var statearr_31966_32018 = state_31934__$1;
(statearr_31966_32018[(2)] = inst_31928);

(statearr_31966_32018[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (17))){
var state_31934__$1 = state_31934;
var statearr_31967_32019 = state_31934__$1;
(statearr_31967_32019[(2)] = false);

(statearr_31967_32019[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (3))){
var state_31934__$1 = state_31934;
var statearr_31968_32020 = state_31934__$1;
(statearr_31968_32020[(2)] = false);

(statearr_31968_32020[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (12))){
var inst_31932 = (state_31934[(2)]);
var state_31934__$1 = state_31934;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31934__$1,inst_31932);
} else {
if((state_val_31935 === (2))){
var inst_31836 = (state_31934[(8)]);
var inst_31841 = inst_31836.cljs$lang$protocol_mask$partition0$;
var inst_31842 = (inst_31841 & (64));
var inst_31843 = inst_31836.cljs$core$ISeq$;
var inst_31844 = (cljs.core.PROTOCOL_SENTINEL === inst_31843);
var inst_31845 = (inst_31842) || (inst_31844);
var state_31934__$1 = state_31934;
if(cljs.core.truth_(inst_31845)){
var statearr_31969_32021 = state_31934__$1;
(statearr_31969_32021[(1)] = (5));

} else {
var statearr_31970_32022 = state_31934__$1;
(statearr_31970_32022[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (23))){
var inst_31893 = (state_31934[(14)]);
var inst_31899 = (inst_31893 == null);
var state_31934__$1 = state_31934;
if(cljs.core.truth_(inst_31899)){
var statearr_31971_32023 = state_31934__$1;
(statearr_31971_32023[(1)] = (26));

} else {
var statearr_31972_32024 = state_31934__$1;
(statearr_31972_32024[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (35))){
var inst_31919 = (state_31934[(2)]);
var state_31934__$1 = state_31934;
if(cljs.core.truth_(inst_31919)){
var statearr_31973_32025 = state_31934__$1;
(statearr_31973_32025[(1)] = (36));

} else {
var statearr_31974_32026 = state_31934__$1;
(statearr_31974_32026[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (19))){
var inst_31861 = (state_31934[(7)]);
var inst_31881 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31861);
var state_31934__$1 = state_31934;
var statearr_31975_32027 = state_31934__$1;
(statearr_31975_32027[(2)] = inst_31881);

(statearr_31975_32027[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (11))){
var inst_31861 = (state_31934[(7)]);
var inst_31865 = (inst_31861 == null);
var inst_31866 = cljs.core.not.call(null,inst_31865);
var state_31934__$1 = state_31934;
if(inst_31866){
var statearr_31976_32028 = state_31934__$1;
(statearr_31976_32028[(1)] = (13));

} else {
var statearr_31977_32029 = state_31934__$1;
(statearr_31977_32029[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (9))){
var inst_31836 = (state_31934[(8)]);
var state_31934__$1 = state_31934;
var statearr_31978_32030 = state_31934__$1;
(statearr_31978_32030[(2)] = inst_31836);

(statearr_31978_32030[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (5))){
var state_31934__$1 = state_31934;
var statearr_31979_32031 = state_31934__$1;
(statearr_31979_32031[(2)] = true);

(statearr_31979_32031[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (14))){
var state_31934__$1 = state_31934;
var statearr_31980_32032 = state_31934__$1;
(statearr_31980_32032[(2)] = false);

(statearr_31980_32032[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (26))){
var inst_31894 = (state_31934[(11)]);
var inst_31901 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_31894);
var state_31934__$1 = state_31934;
var statearr_31981_32033 = state_31934__$1;
(statearr_31981_32033[(2)] = inst_31901);

(statearr_31981_32033[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (16))){
var state_31934__$1 = state_31934;
var statearr_31982_32034 = state_31934__$1;
(statearr_31982_32034[(2)] = true);

(statearr_31982_32034[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (38))){
var inst_31924 = (state_31934[(2)]);
var state_31934__$1 = state_31934;
var statearr_31983_32035 = state_31934__$1;
(statearr_31983_32035[(2)] = inst_31924);

(statearr_31983_32035[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (30))){
var inst_31886 = (state_31934[(13)]);
var inst_31885 = (state_31934[(9)]);
var inst_31894 = (state_31934[(11)]);
var inst_31911 = cljs.core.empty_QMARK_.call(null,inst_31885);
var inst_31912 = inst_31886.call(null,inst_31894);
var inst_31913 = cljs.core.not.call(null,inst_31912);
var inst_31914 = (inst_31911) && (inst_31913);
var state_31934__$1 = state_31934;
var statearr_31984_32036 = state_31934__$1;
(statearr_31984_32036[(2)] = inst_31914);

(statearr_31984_32036[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (10))){
var inst_31836 = (state_31934[(8)]);
var inst_31857 = (state_31934[(2)]);
var inst_31858 = cljs.core.get.call(null,inst_31857,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31859 = cljs.core.get.call(null,inst_31857,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31860 = cljs.core.get.call(null,inst_31857,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31861 = inst_31836;
var state_31934__$1 = (function (){var statearr_31985 = state_31934;
(statearr_31985[(16)] = inst_31859);

(statearr_31985[(17)] = inst_31860);

(statearr_31985[(7)] = inst_31861);

(statearr_31985[(18)] = inst_31858);

return statearr_31985;
})();
var statearr_31986_32037 = state_31934__$1;
(statearr_31986_32037[(2)] = null);

(statearr_31986_32037[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (18))){
var inst_31876 = (state_31934[(2)]);
var state_31934__$1 = state_31934;
var statearr_31987_32038 = state_31934__$1;
(statearr_31987_32038[(2)] = inst_31876);

(statearr_31987_32038[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (37))){
var state_31934__$1 = state_31934;
var statearr_31988_32039 = state_31934__$1;
(statearr_31988_32039[(2)] = null);

(statearr_31988_32039[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31935 === (8))){
var inst_31836 = (state_31934[(8)]);
var inst_31854 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31836);
var state_31934__$1 = state_31934;
var statearr_31989_32040 = state_31934__$1;
(statearr_31989_32040[(2)] = inst_31854);

(statearr_31989_32040[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto___31994,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__30861__auto__,c__30949__auto___31994,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__30862__auto__ = null;
var cljs$core$async$mix_$_state_machine__30862__auto____0 = (function (){
var statearr_31990 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31990[(0)] = cljs$core$async$mix_$_state_machine__30862__auto__);

(statearr_31990[(1)] = (1));

return statearr_31990;
});
var cljs$core$async$mix_$_state_machine__30862__auto____1 = (function (state_31934){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_31934);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e31991){if((e31991 instanceof Object)){
var ex__30865__auto__ = e31991;
var statearr_31992_32041 = state_31934;
(statearr_31992_32041[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31934);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31991;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32042 = state_31934;
state_31934 = G__32042;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__30862__auto__ = function(state_31934){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__30862__auto____1.call(this,state_31934);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__30862__auto____0;
cljs$core$async$mix_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__30862__auto____1;
return cljs$core$async$mix_$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___31994,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__30951__auto__ = (function (){var statearr_31993 = f__30950__auto__.call(null);
(statearr_31993[(6)] = c__30949__auto___31994);

return statearr_31993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___31994,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__29031__auto__ = (((p == null))?null:p);
var m__29032__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__29032__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__29031__auto__ = (((p == null))?null:p);
var m__29032__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,p,v,ch);
} else {
var m__29032__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__32044 = arguments.length;
switch (G__32044) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__29031__auto__ = (((p == null))?null:p);
var m__29032__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,p);
} else {
var m__29032__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__29031__auto__ = (((p == null))?null:p);
var m__29032__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__29031__auto__)]);
if(!((m__29032__auto__ == null))){
return m__29032__auto__.call(null,p,v);
} else {
var m__29032__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__29032__auto____$1 == null))){
return m__29032__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__32048 = arguments.length;
switch (G__32048) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__28348__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__28348__auto__,mults){
return (function (p1__32046_SHARP_){
if(cljs.core.truth_(p1__32046_SHARP_.call(null,topic))){
return p1__32046_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__32046_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__28348__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async32049 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32049 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32050){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32050 = meta32050;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_32051,meta32050__$1){
var self__ = this;
var _32051__$1 = this;
return (new cljs.core.async.t_cljs$core$async32049(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32050__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_32051){
var self__ = this;
var _32051__$1 = this;
return self__.meta32050;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32049.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32050","meta32050",1519023936,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32049.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32049.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32049";

cljs.core.async.t_cljs$core$async32049.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async32049");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async32049 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async32049(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32050){
return (new cljs.core.async.t_cljs$core$async32049(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32050));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async32049(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30949__auto___32169 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___32169,mults,ensure_mult,p){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___32169,mults,ensure_mult,p){
return (function (state_32123){
var state_val_32124 = (state_32123[(1)]);
if((state_val_32124 === (7))){
var inst_32119 = (state_32123[(2)]);
var state_32123__$1 = state_32123;
var statearr_32125_32170 = state_32123__$1;
(statearr_32125_32170[(2)] = inst_32119);

(statearr_32125_32170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (20))){
var state_32123__$1 = state_32123;
var statearr_32126_32171 = state_32123__$1;
(statearr_32126_32171[(2)] = null);

(statearr_32126_32171[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (1))){
var state_32123__$1 = state_32123;
var statearr_32127_32172 = state_32123__$1;
(statearr_32127_32172[(2)] = null);

(statearr_32127_32172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (24))){
var inst_32102 = (state_32123[(7)]);
var inst_32111 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_32102);
var state_32123__$1 = state_32123;
var statearr_32128_32173 = state_32123__$1;
(statearr_32128_32173[(2)] = inst_32111);

(statearr_32128_32173[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (4))){
var inst_32054 = (state_32123[(8)]);
var inst_32054__$1 = (state_32123[(2)]);
var inst_32055 = (inst_32054__$1 == null);
var state_32123__$1 = (function (){var statearr_32129 = state_32123;
(statearr_32129[(8)] = inst_32054__$1);

return statearr_32129;
})();
if(cljs.core.truth_(inst_32055)){
var statearr_32130_32174 = state_32123__$1;
(statearr_32130_32174[(1)] = (5));

} else {
var statearr_32131_32175 = state_32123__$1;
(statearr_32131_32175[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (15))){
var inst_32096 = (state_32123[(2)]);
var state_32123__$1 = state_32123;
var statearr_32132_32176 = state_32123__$1;
(statearr_32132_32176[(2)] = inst_32096);

(statearr_32132_32176[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (21))){
var inst_32116 = (state_32123[(2)]);
var state_32123__$1 = (function (){var statearr_32133 = state_32123;
(statearr_32133[(9)] = inst_32116);

return statearr_32133;
})();
var statearr_32134_32177 = state_32123__$1;
(statearr_32134_32177[(2)] = null);

(statearr_32134_32177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (13))){
var inst_32078 = (state_32123[(10)]);
var inst_32080 = cljs.core.chunked_seq_QMARK_.call(null,inst_32078);
var state_32123__$1 = state_32123;
if(inst_32080){
var statearr_32135_32178 = state_32123__$1;
(statearr_32135_32178[(1)] = (16));

} else {
var statearr_32136_32179 = state_32123__$1;
(statearr_32136_32179[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (22))){
var inst_32108 = (state_32123[(2)]);
var state_32123__$1 = state_32123;
if(cljs.core.truth_(inst_32108)){
var statearr_32137_32180 = state_32123__$1;
(statearr_32137_32180[(1)] = (23));

} else {
var statearr_32138_32181 = state_32123__$1;
(statearr_32138_32181[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (6))){
var inst_32104 = (state_32123[(11)]);
var inst_32054 = (state_32123[(8)]);
var inst_32102 = (state_32123[(7)]);
var inst_32102__$1 = topic_fn.call(null,inst_32054);
var inst_32103 = cljs.core.deref.call(null,mults);
var inst_32104__$1 = cljs.core.get.call(null,inst_32103,inst_32102__$1);
var state_32123__$1 = (function (){var statearr_32139 = state_32123;
(statearr_32139[(11)] = inst_32104__$1);

(statearr_32139[(7)] = inst_32102__$1);

return statearr_32139;
})();
if(cljs.core.truth_(inst_32104__$1)){
var statearr_32140_32182 = state_32123__$1;
(statearr_32140_32182[(1)] = (19));

} else {
var statearr_32141_32183 = state_32123__$1;
(statearr_32141_32183[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (25))){
var inst_32113 = (state_32123[(2)]);
var state_32123__$1 = state_32123;
var statearr_32142_32184 = state_32123__$1;
(statearr_32142_32184[(2)] = inst_32113);

(statearr_32142_32184[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (17))){
var inst_32078 = (state_32123[(10)]);
var inst_32087 = cljs.core.first.call(null,inst_32078);
var inst_32088 = cljs.core.async.muxch_STAR_.call(null,inst_32087);
var inst_32089 = cljs.core.async.close_BANG_.call(null,inst_32088);
var inst_32090 = cljs.core.next.call(null,inst_32078);
var inst_32064 = inst_32090;
var inst_32065 = null;
var inst_32066 = (0);
var inst_32067 = (0);
var state_32123__$1 = (function (){var statearr_32143 = state_32123;
(statearr_32143[(12)] = inst_32064);

(statearr_32143[(13)] = inst_32065);

(statearr_32143[(14)] = inst_32089);

(statearr_32143[(15)] = inst_32067);

(statearr_32143[(16)] = inst_32066);

return statearr_32143;
})();
var statearr_32144_32185 = state_32123__$1;
(statearr_32144_32185[(2)] = null);

(statearr_32144_32185[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (3))){
var inst_32121 = (state_32123[(2)]);
var state_32123__$1 = state_32123;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32123__$1,inst_32121);
} else {
if((state_val_32124 === (12))){
var inst_32098 = (state_32123[(2)]);
var state_32123__$1 = state_32123;
var statearr_32145_32186 = state_32123__$1;
(statearr_32145_32186[(2)] = inst_32098);

(statearr_32145_32186[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (2))){
var state_32123__$1 = state_32123;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32123__$1,(4),ch);
} else {
if((state_val_32124 === (23))){
var state_32123__$1 = state_32123;
var statearr_32146_32187 = state_32123__$1;
(statearr_32146_32187[(2)] = null);

(statearr_32146_32187[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (19))){
var inst_32104 = (state_32123[(11)]);
var inst_32054 = (state_32123[(8)]);
var inst_32106 = cljs.core.async.muxch_STAR_.call(null,inst_32104);
var state_32123__$1 = state_32123;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32123__$1,(22),inst_32106,inst_32054);
} else {
if((state_val_32124 === (11))){
var inst_32064 = (state_32123[(12)]);
var inst_32078 = (state_32123[(10)]);
var inst_32078__$1 = cljs.core.seq.call(null,inst_32064);
var state_32123__$1 = (function (){var statearr_32147 = state_32123;
(statearr_32147[(10)] = inst_32078__$1);

return statearr_32147;
})();
if(inst_32078__$1){
var statearr_32148_32188 = state_32123__$1;
(statearr_32148_32188[(1)] = (13));

} else {
var statearr_32149_32189 = state_32123__$1;
(statearr_32149_32189[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (9))){
var inst_32100 = (state_32123[(2)]);
var state_32123__$1 = state_32123;
var statearr_32150_32190 = state_32123__$1;
(statearr_32150_32190[(2)] = inst_32100);

(statearr_32150_32190[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (5))){
var inst_32061 = cljs.core.deref.call(null,mults);
var inst_32062 = cljs.core.vals.call(null,inst_32061);
var inst_32063 = cljs.core.seq.call(null,inst_32062);
var inst_32064 = inst_32063;
var inst_32065 = null;
var inst_32066 = (0);
var inst_32067 = (0);
var state_32123__$1 = (function (){var statearr_32151 = state_32123;
(statearr_32151[(12)] = inst_32064);

(statearr_32151[(13)] = inst_32065);

(statearr_32151[(15)] = inst_32067);

(statearr_32151[(16)] = inst_32066);

return statearr_32151;
})();
var statearr_32152_32191 = state_32123__$1;
(statearr_32152_32191[(2)] = null);

(statearr_32152_32191[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (14))){
var state_32123__$1 = state_32123;
var statearr_32156_32192 = state_32123__$1;
(statearr_32156_32192[(2)] = null);

(statearr_32156_32192[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (16))){
var inst_32078 = (state_32123[(10)]);
var inst_32082 = cljs.core.chunk_first.call(null,inst_32078);
var inst_32083 = cljs.core.chunk_rest.call(null,inst_32078);
var inst_32084 = cljs.core.count.call(null,inst_32082);
var inst_32064 = inst_32083;
var inst_32065 = inst_32082;
var inst_32066 = inst_32084;
var inst_32067 = (0);
var state_32123__$1 = (function (){var statearr_32157 = state_32123;
(statearr_32157[(12)] = inst_32064);

(statearr_32157[(13)] = inst_32065);

(statearr_32157[(15)] = inst_32067);

(statearr_32157[(16)] = inst_32066);

return statearr_32157;
})();
var statearr_32158_32193 = state_32123__$1;
(statearr_32158_32193[(2)] = null);

(statearr_32158_32193[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (10))){
var inst_32064 = (state_32123[(12)]);
var inst_32065 = (state_32123[(13)]);
var inst_32067 = (state_32123[(15)]);
var inst_32066 = (state_32123[(16)]);
var inst_32072 = cljs.core._nth.call(null,inst_32065,inst_32067);
var inst_32073 = cljs.core.async.muxch_STAR_.call(null,inst_32072);
var inst_32074 = cljs.core.async.close_BANG_.call(null,inst_32073);
var inst_32075 = (inst_32067 + (1));
var tmp32153 = inst_32064;
var tmp32154 = inst_32065;
var tmp32155 = inst_32066;
var inst_32064__$1 = tmp32153;
var inst_32065__$1 = tmp32154;
var inst_32066__$1 = tmp32155;
var inst_32067__$1 = inst_32075;
var state_32123__$1 = (function (){var statearr_32159 = state_32123;
(statearr_32159[(17)] = inst_32074);

(statearr_32159[(12)] = inst_32064__$1);

(statearr_32159[(13)] = inst_32065__$1);

(statearr_32159[(15)] = inst_32067__$1);

(statearr_32159[(16)] = inst_32066__$1);

return statearr_32159;
})();
var statearr_32160_32194 = state_32123__$1;
(statearr_32160_32194[(2)] = null);

(statearr_32160_32194[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (18))){
var inst_32093 = (state_32123[(2)]);
var state_32123__$1 = state_32123;
var statearr_32161_32195 = state_32123__$1;
(statearr_32161_32195[(2)] = inst_32093);

(statearr_32161_32195[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (8))){
var inst_32067 = (state_32123[(15)]);
var inst_32066 = (state_32123[(16)]);
var inst_32069 = (inst_32067 < inst_32066);
var inst_32070 = inst_32069;
var state_32123__$1 = state_32123;
if(cljs.core.truth_(inst_32070)){
var statearr_32162_32196 = state_32123__$1;
(statearr_32162_32196[(1)] = (10));

} else {
var statearr_32163_32197 = state_32123__$1;
(statearr_32163_32197[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto___32169,mults,ensure_mult,p))
;
return ((function (switch__30861__auto__,c__30949__auto___32169,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__30862__auto__ = null;
var cljs$core$async$state_machine__30862__auto____0 = (function (){
var statearr_32164 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32164[(0)] = cljs$core$async$state_machine__30862__auto__);

(statearr_32164[(1)] = (1));

return statearr_32164;
});
var cljs$core$async$state_machine__30862__auto____1 = (function (state_32123){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_32123);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e32165){if((e32165 instanceof Object)){
var ex__30865__auto__ = e32165;
var statearr_32166_32198 = state_32123;
(statearr_32166_32198[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32123);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32165;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32199 = state_32123;
state_32123 = G__32199;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$state_machine__30862__auto__ = function(state_32123){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30862__auto____1.call(this,state_32123);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30862__auto____0;
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30862__auto____1;
return cljs$core$async$state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___32169,mults,ensure_mult,p))
})();
var state__30951__auto__ = (function (){var statearr_32167 = f__30950__auto__.call(null);
(statearr_32167[(6)] = c__30949__auto___32169);

return statearr_32167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___32169,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__32201 = arguments.length;
switch (G__32201) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__32204 = arguments.length;
switch (G__32204) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__32207 = arguments.length;
switch (G__32207) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__30949__auto___32274 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___32274,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___32274,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_32246){
var state_val_32247 = (state_32246[(1)]);
if((state_val_32247 === (7))){
var state_32246__$1 = state_32246;
var statearr_32248_32275 = state_32246__$1;
(statearr_32248_32275[(2)] = null);

(statearr_32248_32275[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32247 === (1))){
var state_32246__$1 = state_32246;
var statearr_32249_32276 = state_32246__$1;
(statearr_32249_32276[(2)] = null);

(statearr_32249_32276[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32247 === (4))){
var inst_32210 = (state_32246[(7)]);
var inst_32212 = (inst_32210 < cnt);
var state_32246__$1 = state_32246;
if(cljs.core.truth_(inst_32212)){
var statearr_32250_32277 = state_32246__$1;
(statearr_32250_32277[(1)] = (6));

} else {
var statearr_32251_32278 = state_32246__$1;
(statearr_32251_32278[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32247 === (15))){
var inst_32242 = (state_32246[(2)]);
var state_32246__$1 = state_32246;
var statearr_32252_32279 = state_32246__$1;
(statearr_32252_32279[(2)] = inst_32242);

(statearr_32252_32279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32247 === (13))){
var inst_32235 = cljs.core.async.close_BANG_.call(null,out);
var state_32246__$1 = state_32246;
var statearr_32253_32280 = state_32246__$1;
(statearr_32253_32280[(2)] = inst_32235);

(statearr_32253_32280[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32247 === (6))){
var state_32246__$1 = state_32246;
var statearr_32254_32281 = state_32246__$1;
(statearr_32254_32281[(2)] = null);

(statearr_32254_32281[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32247 === (3))){
var inst_32244 = (state_32246[(2)]);
var state_32246__$1 = state_32246;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32246__$1,inst_32244);
} else {
if((state_val_32247 === (12))){
var inst_32232 = (state_32246[(8)]);
var inst_32232__$1 = (state_32246[(2)]);
var inst_32233 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_32232__$1);
var state_32246__$1 = (function (){var statearr_32255 = state_32246;
(statearr_32255[(8)] = inst_32232__$1);

return statearr_32255;
})();
if(cljs.core.truth_(inst_32233)){
var statearr_32256_32282 = state_32246__$1;
(statearr_32256_32282[(1)] = (13));

} else {
var statearr_32257_32283 = state_32246__$1;
(statearr_32257_32283[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32247 === (2))){
var inst_32209 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_32210 = (0);
var state_32246__$1 = (function (){var statearr_32258 = state_32246;
(statearr_32258[(7)] = inst_32210);

(statearr_32258[(9)] = inst_32209);

return statearr_32258;
})();
var statearr_32259_32284 = state_32246__$1;
(statearr_32259_32284[(2)] = null);

(statearr_32259_32284[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32247 === (11))){
var inst_32210 = (state_32246[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_32246,(10),Object,null,(9));
var inst_32219 = chs__$1.call(null,inst_32210);
var inst_32220 = done.call(null,inst_32210);
var inst_32221 = cljs.core.async.take_BANG_.call(null,inst_32219,inst_32220);
var state_32246__$1 = state_32246;
var statearr_32260_32285 = state_32246__$1;
(statearr_32260_32285[(2)] = inst_32221);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32246__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32247 === (9))){
var inst_32210 = (state_32246[(7)]);
var inst_32223 = (state_32246[(2)]);
var inst_32224 = (inst_32210 + (1));
var inst_32210__$1 = inst_32224;
var state_32246__$1 = (function (){var statearr_32261 = state_32246;
(statearr_32261[(7)] = inst_32210__$1);

(statearr_32261[(10)] = inst_32223);

return statearr_32261;
})();
var statearr_32262_32286 = state_32246__$1;
(statearr_32262_32286[(2)] = null);

(statearr_32262_32286[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32247 === (5))){
var inst_32230 = (state_32246[(2)]);
var state_32246__$1 = (function (){var statearr_32263 = state_32246;
(statearr_32263[(11)] = inst_32230);

return statearr_32263;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32246__$1,(12),dchan);
} else {
if((state_val_32247 === (14))){
var inst_32232 = (state_32246[(8)]);
var inst_32237 = cljs.core.apply.call(null,f,inst_32232);
var state_32246__$1 = state_32246;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32246__$1,(16),out,inst_32237);
} else {
if((state_val_32247 === (16))){
var inst_32239 = (state_32246[(2)]);
var state_32246__$1 = (function (){var statearr_32264 = state_32246;
(statearr_32264[(12)] = inst_32239);

return statearr_32264;
})();
var statearr_32265_32287 = state_32246__$1;
(statearr_32265_32287[(2)] = null);

(statearr_32265_32287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32247 === (10))){
var inst_32214 = (state_32246[(2)]);
var inst_32215 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_32246__$1 = (function (){var statearr_32266 = state_32246;
(statearr_32266[(13)] = inst_32214);

return statearr_32266;
})();
var statearr_32267_32288 = state_32246__$1;
(statearr_32267_32288[(2)] = inst_32215);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32246__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32247 === (8))){
var inst_32228 = (state_32246[(2)]);
var state_32246__$1 = state_32246;
var statearr_32268_32289 = state_32246__$1;
(statearr_32268_32289[(2)] = inst_32228);

(statearr_32268_32289[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto___32274,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__30861__auto__,c__30949__auto___32274,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__30862__auto__ = null;
var cljs$core$async$state_machine__30862__auto____0 = (function (){
var statearr_32269 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32269[(0)] = cljs$core$async$state_machine__30862__auto__);

(statearr_32269[(1)] = (1));

return statearr_32269;
});
var cljs$core$async$state_machine__30862__auto____1 = (function (state_32246){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_32246);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e32270){if((e32270 instanceof Object)){
var ex__30865__auto__ = e32270;
var statearr_32271_32290 = state_32246;
(statearr_32271_32290[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32246);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32270;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32291 = state_32246;
state_32246 = G__32291;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$state_machine__30862__auto__ = function(state_32246){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30862__auto____1.call(this,state_32246);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30862__auto____0;
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30862__auto____1;
return cljs$core$async$state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___32274,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__30951__auto__ = (function (){var statearr_32272 = f__30950__auto__.call(null);
(statearr_32272[(6)] = c__30949__auto___32274);

return statearr_32272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___32274,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__32294 = arguments.length;
switch (G__32294) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30949__auto___32348 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___32348,out){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___32348,out){
return (function (state_32326){
var state_val_32327 = (state_32326[(1)]);
if((state_val_32327 === (7))){
var inst_32306 = (state_32326[(7)]);
var inst_32305 = (state_32326[(8)]);
var inst_32305__$1 = (state_32326[(2)]);
var inst_32306__$1 = cljs.core.nth.call(null,inst_32305__$1,(0),null);
var inst_32307 = cljs.core.nth.call(null,inst_32305__$1,(1),null);
var inst_32308 = (inst_32306__$1 == null);
var state_32326__$1 = (function (){var statearr_32328 = state_32326;
(statearr_32328[(7)] = inst_32306__$1);

(statearr_32328[(9)] = inst_32307);

(statearr_32328[(8)] = inst_32305__$1);

return statearr_32328;
})();
if(cljs.core.truth_(inst_32308)){
var statearr_32329_32349 = state_32326__$1;
(statearr_32329_32349[(1)] = (8));

} else {
var statearr_32330_32350 = state_32326__$1;
(statearr_32330_32350[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32327 === (1))){
var inst_32295 = cljs.core.vec.call(null,chs);
var inst_32296 = inst_32295;
var state_32326__$1 = (function (){var statearr_32331 = state_32326;
(statearr_32331[(10)] = inst_32296);

return statearr_32331;
})();
var statearr_32332_32351 = state_32326__$1;
(statearr_32332_32351[(2)] = null);

(statearr_32332_32351[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32327 === (4))){
var inst_32296 = (state_32326[(10)]);
var state_32326__$1 = state_32326;
return cljs.core.async.ioc_alts_BANG_.call(null,state_32326__$1,(7),inst_32296);
} else {
if((state_val_32327 === (6))){
var inst_32322 = (state_32326[(2)]);
var state_32326__$1 = state_32326;
var statearr_32333_32352 = state_32326__$1;
(statearr_32333_32352[(2)] = inst_32322);

(statearr_32333_32352[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32327 === (3))){
var inst_32324 = (state_32326[(2)]);
var state_32326__$1 = state_32326;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32326__$1,inst_32324);
} else {
if((state_val_32327 === (2))){
var inst_32296 = (state_32326[(10)]);
var inst_32298 = cljs.core.count.call(null,inst_32296);
var inst_32299 = (inst_32298 > (0));
var state_32326__$1 = state_32326;
if(cljs.core.truth_(inst_32299)){
var statearr_32335_32353 = state_32326__$1;
(statearr_32335_32353[(1)] = (4));

} else {
var statearr_32336_32354 = state_32326__$1;
(statearr_32336_32354[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32327 === (11))){
var inst_32296 = (state_32326[(10)]);
var inst_32315 = (state_32326[(2)]);
var tmp32334 = inst_32296;
var inst_32296__$1 = tmp32334;
var state_32326__$1 = (function (){var statearr_32337 = state_32326;
(statearr_32337[(11)] = inst_32315);

(statearr_32337[(10)] = inst_32296__$1);

return statearr_32337;
})();
var statearr_32338_32355 = state_32326__$1;
(statearr_32338_32355[(2)] = null);

(statearr_32338_32355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32327 === (9))){
var inst_32306 = (state_32326[(7)]);
var state_32326__$1 = state_32326;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32326__$1,(11),out,inst_32306);
} else {
if((state_val_32327 === (5))){
var inst_32320 = cljs.core.async.close_BANG_.call(null,out);
var state_32326__$1 = state_32326;
var statearr_32339_32356 = state_32326__$1;
(statearr_32339_32356[(2)] = inst_32320);

(statearr_32339_32356[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32327 === (10))){
var inst_32318 = (state_32326[(2)]);
var state_32326__$1 = state_32326;
var statearr_32340_32357 = state_32326__$1;
(statearr_32340_32357[(2)] = inst_32318);

(statearr_32340_32357[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32327 === (8))){
var inst_32306 = (state_32326[(7)]);
var inst_32307 = (state_32326[(9)]);
var inst_32296 = (state_32326[(10)]);
var inst_32305 = (state_32326[(8)]);
var inst_32310 = (function (){var cs = inst_32296;
var vec__32301 = inst_32305;
var v = inst_32306;
var c = inst_32307;
return ((function (cs,vec__32301,v,c,inst_32306,inst_32307,inst_32296,inst_32305,state_val_32327,c__30949__auto___32348,out){
return (function (p1__32292_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__32292_SHARP_);
});
;})(cs,vec__32301,v,c,inst_32306,inst_32307,inst_32296,inst_32305,state_val_32327,c__30949__auto___32348,out))
})();
var inst_32311 = cljs.core.filterv.call(null,inst_32310,inst_32296);
var inst_32296__$1 = inst_32311;
var state_32326__$1 = (function (){var statearr_32341 = state_32326;
(statearr_32341[(10)] = inst_32296__$1);

return statearr_32341;
})();
var statearr_32342_32358 = state_32326__$1;
(statearr_32342_32358[(2)] = null);

(statearr_32342_32358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto___32348,out))
;
return ((function (switch__30861__auto__,c__30949__auto___32348,out){
return (function() {
var cljs$core$async$state_machine__30862__auto__ = null;
var cljs$core$async$state_machine__30862__auto____0 = (function (){
var statearr_32343 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32343[(0)] = cljs$core$async$state_machine__30862__auto__);

(statearr_32343[(1)] = (1));

return statearr_32343;
});
var cljs$core$async$state_machine__30862__auto____1 = (function (state_32326){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_32326);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e32344){if((e32344 instanceof Object)){
var ex__30865__auto__ = e32344;
var statearr_32345_32359 = state_32326;
(statearr_32345_32359[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32326);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32344;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32360 = state_32326;
state_32326 = G__32360;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$state_machine__30862__auto__ = function(state_32326){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30862__auto____1.call(this,state_32326);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30862__auto____0;
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30862__auto____1;
return cljs$core$async$state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___32348,out))
})();
var state__30951__auto__ = (function (){var statearr_32346 = f__30950__auto__.call(null);
(statearr_32346[(6)] = c__30949__auto___32348);

return statearr_32346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___32348,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__32362 = arguments.length;
switch (G__32362) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30949__auto___32407 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___32407,out){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___32407,out){
return (function (state_32386){
var state_val_32387 = (state_32386[(1)]);
if((state_val_32387 === (7))){
var inst_32368 = (state_32386[(7)]);
var inst_32368__$1 = (state_32386[(2)]);
var inst_32369 = (inst_32368__$1 == null);
var inst_32370 = cljs.core.not.call(null,inst_32369);
var state_32386__$1 = (function (){var statearr_32388 = state_32386;
(statearr_32388[(7)] = inst_32368__$1);

return statearr_32388;
})();
if(inst_32370){
var statearr_32389_32408 = state_32386__$1;
(statearr_32389_32408[(1)] = (8));

} else {
var statearr_32390_32409 = state_32386__$1;
(statearr_32390_32409[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32387 === (1))){
var inst_32363 = (0);
var state_32386__$1 = (function (){var statearr_32391 = state_32386;
(statearr_32391[(8)] = inst_32363);

return statearr_32391;
})();
var statearr_32392_32410 = state_32386__$1;
(statearr_32392_32410[(2)] = null);

(statearr_32392_32410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32387 === (4))){
var state_32386__$1 = state_32386;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32386__$1,(7),ch);
} else {
if((state_val_32387 === (6))){
var inst_32381 = (state_32386[(2)]);
var state_32386__$1 = state_32386;
var statearr_32393_32411 = state_32386__$1;
(statearr_32393_32411[(2)] = inst_32381);

(statearr_32393_32411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32387 === (3))){
var inst_32383 = (state_32386[(2)]);
var inst_32384 = cljs.core.async.close_BANG_.call(null,out);
var state_32386__$1 = (function (){var statearr_32394 = state_32386;
(statearr_32394[(9)] = inst_32383);

return statearr_32394;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32386__$1,inst_32384);
} else {
if((state_val_32387 === (2))){
var inst_32363 = (state_32386[(8)]);
var inst_32365 = (inst_32363 < n);
var state_32386__$1 = state_32386;
if(cljs.core.truth_(inst_32365)){
var statearr_32395_32412 = state_32386__$1;
(statearr_32395_32412[(1)] = (4));

} else {
var statearr_32396_32413 = state_32386__$1;
(statearr_32396_32413[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32387 === (11))){
var inst_32363 = (state_32386[(8)]);
var inst_32373 = (state_32386[(2)]);
var inst_32374 = (inst_32363 + (1));
var inst_32363__$1 = inst_32374;
var state_32386__$1 = (function (){var statearr_32397 = state_32386;
(statearr_32397[(10)] = inst_32373);

(statearr_32397[(8)] = inst_32363__$1);

return statearr_32397;
})();
var statearr_32398_32414 = state_32386__$1;
(statearr_32398_32414[(2)] = null);

(statearr_32398_32414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32387 === (9))){
var state_32386__$1 = state_32386;
var statearr_32399_32415 = state_32386__$1;
(statearr_32399_32415[(2)] = null);

(statearr_32399_32415[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32387 === (5))){
var state_32386__$1 = state_32386;
var statearr_32400_32416 = state_32386__$1;
(statearr_32400_32416[(2)] = null);

(statearr_32400_32416[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32387 === (10))){
var inst_32378 = (state_32386[(2)]);
var state_32386__$1 = state_32386;
var statearr_32401_32417 = state_32386__$1;
(statearr_32401_32417[(2)] = inst_32378);

(statearr_32401_32417[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32387 === (8))){
var inst_32368 = (state_32386[(7)]);
var state_32386__$1 = state_32386;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32386__$1,(11),out,inst_32368);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto___32407,out))
;
return ((function (switch__30861__auto__,c__30949__auto___32407,out){
return (function() {
var cljs$core$async$state_machine__30862__auto__ = null;
var cljs$core$async$state_machine__30862__auto____0 = (function (){
var statearr_32402 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32402[(0)] = cljs$core$async$state_machine__30862__auto__);

(statearr_32402[(1)] = (1));

return statearr_32402;
});
var cljs$core$async$state_machine__30862__auto____1 = (function (state_32386){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_32386);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e32403){if((e32403 instanceof Object)){
var ex__30865__auto__ = e32403;
var statearr_32404_32418 = state_32386;
(statearr_32404_32418[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32386);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32403;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32419 = state_32386;
state_32386 = G__32419;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$state_machine__30862__auto__ = function(state_32386){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30862__auto____1.call(this,state_32386);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30862__auto____0;
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30862__auto____1;
return cljs$core$async$state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___32407,out))
})();
var state__30951__auto__ = (function (){var statearr_32405 = f__30950__auto__.call(null);
(statearr_32405[(6)] = c__30949__auto___32407);

return statearr_32405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___32407,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32421 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32421 = (function (f,ch,meta32422){
this.f = f;
this.ch = ch;
this.meta32422 = meta32422;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32421.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32423,meta32422__$1){
var self__ = this;
var _32423__$1 = this;
return (new cljs.core.async.t_cljs$core$async32421(self__.f,self__.ch,meta32422__$1));
});

cljs.core.async.t_cljs$core$async32421.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32423){
var self__ = this;
var _32423__$1 = this;
return self__.meta32422;
});

cljs.core.async.t_cljs$core$async32421.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32421.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32421.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32421.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32421.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async32424 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32424 = (function (f,ch,meta32422,_,fn1,meta32425){
this.f = f;
this.ch = ch;
this.meta32422 = meta32422;
this._ = _;
this.fn1 = fn1;
this.meta32425 = meta32425;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32424.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_32426,meta32425__$1){
var self__ = this;
var _32426__$1 = this;
return (new cljs.core.async.t_cljs$core$async32424(self__.f,self__.ch,self__.meta32422,self__._,self__.fn1,meta32425__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async32424.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_32426){
var self__ = this;
var _32426__$1 = this;
return self__.meta32425;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32424.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32424.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32424.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32424.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__32420_SHARP_){
return f1.call(null,(((p1__32420_SHARP_ == null))?null:self__.f.call(null,p1__32420_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async32424.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32422","meta32422",-1284506072,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32421","cljs.core.async/t_cljs$core$async32421",263996922,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta32425","meta32425",1287755393,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32424.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32424.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32424";

cljs.core.async.t_cljs$core$async32424.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async32424");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async32424 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32424(f__$1,ch__$1,meta32422__$1,___$2,fn1__$1,meta32425){
return (new cljs.core.async.t_cljs$core$async32424(f__$1,ch__$1,meta32422__$1,___$2,fn1__$1,meta32425));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async32424(self__.f,self__.ch,self__.meta32422,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__28336__auto__ = ret;
if(cljs.core.truth_(and__28336__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__28336__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async32421.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32421.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async32421.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32422","meta32422",-1284506072,null)], null);
});

cljs.core.async.t_cljs$core$async32421.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32421.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32421";

cljs.core.async.t_cljs$core$async32421.cljs$lang$ctorPrWriter = (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async32421");
});

cljs.core.async.__GT_t_cljs$core$async32421 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32421(f__$1,ch__$1,meta32422){
return (new cljs.core.async.t_cljs$core$async32421(f__$1,ch__$1,meta32422));
});

}

return (new cljs.core.async.t_cljs$core$async32421(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32427 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32427 = (function (f,ch,meta32428){
this.f = f;
this.ch = ch;
this.meta32428 = meta32428;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32429,meta32428__$1){
var self__ = this;
var _32429__$1 = this;
return (new cljs.core.async.t_cljs$core$async32427(self__.f,self__.ch,meta32428__$1));
});

cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32429){
var self__ = this;
var _32429__$1 = this;
return self__.meta32428;
});

cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32427.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async32427.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32428","meta32428",1933681999,null)], null);
});

cljs.core.async.t_cljs$core$async32427.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32427.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32427";

cljs.core.async.t_cljs$core$async32427.cljs$lang$ctorPrWriter = (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async32427");
});

cljs.core.async.__GT_t_cljs$core$async32427 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async32427(f__$1,ch__$1,meta32428){
return (new cljs.core.async.t_cljs$core$async32427(f__$1,ch__$1,meta32428));
});

}

return (new cljs.core.async.t_cljs$core$async32427(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async32430 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32430 = (function (p,ch,meta32431){
this.p = p;
this.ch = ch;
this.meta32431 = meta32431;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32432,meta32431__$1){
var self__ = this;
var _32432__$1 = this;
return (new cljs.core.async.t_cljs$core$async32430(self__.p,self__.ch,meta32431__$1));
});

cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32432){
var self__ = this;
var _32432__$1 = this;
return self__.meta32431;
});

cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async32430.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32431","meta32431",1370769961,null)], null);
});

cljs.core.async.t_cljs$core$async32430.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32430.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32430";

cljs.core.async.t_cljs$core$async32430.cljs$lang$ctorPrWriter = (function (this__28973__auto__,writer__28974__auto__,opt__28975__auto__){
return cljs.core._write.call(null,writer__28974__auto__,"cljs.core.async/t_cljs$core$async32430");
});

cljs.core.async.__GT_t_cljs$core$async32430 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async32430(p__$1,ch__$1,meta32431){
return (new cljs.core.async.t_cljs$core$async32430(p__$1,ch__$1,meta32431));
});

}

return (new cljs.core.async.t_cljs$core$async32430(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__32434 = arguments.length;
switch (G__32434) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30949__auto___32474 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___32474,out){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___32474,out){
return (function (state_32455){
var state_val_32456 = (state_32455[(1)]);
if((state_val_32456 === (7))){
var inst_32451 = (state_32455[(2)]);
var state_32455__$1 = state_32455;
var statearr_32457_32475 = state_32455__$1;
(statearr_32457_32475[(2)] = inst_32451);

(statearr_32457_32475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32456 === (1))){
var state_32455__$1 = state_32455;
var statearr_32458_32476 = state_32455__$1;
(statearr_32458_32476[(2)] = null);

(statearr_32458_32476[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32456 === (4))){
var inst_32437 = (state_32455[(7)]);
var inst_32437__$1 = (state_32455[(2)]);
var inst_32438 = (inst_32437__$1 == null);
var state_32455__$1 = (function (){var statearr_32459 = state_32455;
(statearr_32459[(7)] = inst_32437__$1);

return statearr_32459;
})();
if(cljs.core.truth_(inst_32438)){
var statearr_32460_32477 = state_32455__$1;
(statearr_32460_32477[(1)] = (5));

} else {
var statearr_32461_32478 = state_32455__$1;
(statearr_32461_32478[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32456 === (6))){
var inst_32437 = (state_32455[(7)]);
var inst_32442 = p.call(null,inst_32437);
var state_32455__$1 = state_32455;
if(cljs.core.truth_(inst_32442)){
var statearr_32462_32479 = state_32455__$1;
(statearr_32462_32479[(1)] = (8));

} else {
var statearr_32463_32480 = state_32455__$1;
(statearr_32463_32480[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32456 === (3))){
var inst_32453 = (state_32455[(2)]);
var state_32455__$1 = state_32455;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32455__$1,inst_32453);
} else {
if((state_val_32456 === (2))){
var state_32455__$1 = state_32455;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32455__$1,(4),ch);
} else {
if((state_val_32456 === (11))){
var inst_32445 = (state_32455[(2)]);
var state_32455__$1 = state_32455;
var statearr_32464_32481 = state_32455__$1;
(statearr_32464_32481[(2)] = inst_32445);

(statearr_32464_32481[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32456 === (9))){
var state_32455__$1 = state_32455;
var statearr_32465_32482 = state_32455__$1;
(statearr_32465_32482[(2)] = null);

(statearr_32465_32482[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32456 === (5))){
var inst_32440 = cljs.core.async.close_BANG_.call(null,out);
var state_32455__$1 = state_32455;
var statearr_32466_32483 = state_32455__$1;
(statearr_32466_32483[(2)] = inst_32440);

(statearr_32466_32483[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32456 === (10))){
var inst_32448 = (state_32455[(2)]);
var state_32455__$1 = (function (){var statearr_32467 = state_32455;
(statearr_32467[(8)] = inst_32448);

return statearr_32467;
})();
var statearr_32468_32484 = state_32455__$1;
(statearr_32468_32484[(2)] = null);

(statearr_32468_32484[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32456 === (8))){
var inst_32437 = (state_32455[(7)]);
var state_32455__$1 = state_32455;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32455__$1,(11),out,inst_32437);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto___32474,out))
;
return ((function (switch__30861__auto__,c__30949__auto___32474,out){
return (function() {
var cljs$core$async$state_machine__30862__auto__ = null;
var cljs$core$async$state_machine__30862__auto____0 = (function (){
var statearr_32469 = [null,null,null,null,null,null,null,null,null];
(statearr_32469[(0)] = cljs$core$async$state_machine__30862__auto__);

(statearr_32469[(1)] = (1));

return statearr_32469;
});
var cljs$core$async$state_machine__30862__auto____1 = (function (state_32455){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_32455);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e32470){if((e32470 instanceof Object)){
var ex__30865__auto__ = e32470;
var statearr_32471_32485 = state_32455;
(statearr_32471_32485[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32455);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32470;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32486 = state_32455;
state_32455 = G__32486;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$state_machine__30862__auto__ = function(state_32455){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30862__auto____1.call(this,state_32455);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30862__auto____0;
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30862__auto____1;
return cljs$core$async$state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___32474,out))
})();
var state__30951__auto__ = (function (){var statearr_32472 = f__30950__auto__.call(null);
(statearr_32472[(6)] = c__30949__auto___32474);

return statearr_32472;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___32474,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__32488 = arguments.length;
switch (G__32488) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30949__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto__){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto__){
return (function (state_32551){
var state_val_32552 = (state_32551[(1)]);
if((state_val_32552 === (7))){
var inst_32547 = (state_32551[(2)]);
var state_32551__$1 = state_32551;
var statearr_32553_32591 = state_32551__$1;
(statearr_32553_32591[(2)] = inst_32547);

(statearr_32553_32591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (20))){
var inst_32517 = (state_32551[(7)]);
var inst_32528 = (state_32551[(2)]);
var inst_32529 = cljs.core.next.call(null,inst_32517);
var inst_32503 = inst_32529;
var inst_32504 = null;
var inst_32505 = (0);
var inst_32506 = (0);
var state_32551__$1 = (function (){var statearr_32554 = state_32551;
(statearr_32554[(8)] = inst_32504);

(statearr_32554[(9)] = inst_32528);

(statearr_32554[(10)] = inst_32506);

(statearr_32554[(11)] = inst_32503);

(statearr_32554[(12)] = inst_32505);

return statearr_32554;
})();
var statearr_32555_32592 = state_32551__$1;
(statearr_32555_32592[(2)] = null);

(statearr_32555_32592[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (1))){
var state_32551__$1 = state_32551;
var statearr_32556_32593 = state_32551__$1;
(statearr_32556_32593[(2)] = null);

(statearr_32556_32593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (4))){
var inst_32492 = (state_32551[(13)]);
var inst_32492__$1 = (state_32551[(2)]);
var inst_32493 = (inst_32492__$1 == null);
var state_32551__$1 = (function (){var statearr_32557 = state_32551;
(statearr_32557[(13)] = inst_32492__$1);

return statearr_32557;
})();
if(cljs.core.truth_(inst_32493)){
var statearr_32558_32594 = state_32551__$1;
(statearr_32558_32594[(1)] = (5));

} else {
var statearr_32559_32595 = state_32551__$1;
(statearr_32559_32595[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (15))){
var state_32551__$1 = state_32551;
var statearr_32563_32596 = state_32551__$1;
(statearr_32563_32596[(2)] = null);

(statearr_32563_32596[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (21))){
var state_32551__$1 = state_32551;
var statearr_32564_32597 = state_32551__$1;
(statearr_32564_32597[(2)] = null);

(statearr_32564_32597[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (13))){
var inst_32504 = (state_32551[(8)]);
var inst_32506 = (state_32551[(10)]);
var inst_32503 = (state_32551[(11)]);
var inst_32505 = (state_32551[(12)]);
var inst_32513 = (state_32551[(2)]);
var inst_32514 = (inst_32506 + (1));
var tmp32560 = inst_32504;
var tmp32561 = inst_32503;
var tmp32562 = inst_32505;
var inst_32503__$1 = tmp32561;
var inst_32504__$1 = tmp32560;
var inst_32505__$1 = tmp32562;
var inst_32506__$1 = inst_32514;
var state_32551__$1 = (function (){var statearr_32565 = state_32551;
(statearr_32565[(8)] = inst_32504__$1);

(statearr_32565[(10)] = inst_32506__$1);

(statearr_32565[(11)] = inst_32503__$1);

(statearr_32565[(12)] = inst_32505__$1);

(statearr_32565[(14)] = inst_32513);

return statearr_32565;
})();
var statearr_32566_32598 = state_32551__$1;
(statearr_32566_32598[(2)] = null);

(statearr_32566_32598[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (22))){
var state_32551__$1 = state_32551;
var statearr_32567_32599 = state_32551__$1;
(statearr_32567_32599[(2)] = null);

(statearr_32567_32599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (6))){
var inst_32492 = (state_32551[(13)]);
var inst_32501 = f.call(null,inst_32492);
var inst_32502 = cljs.core.seq.call(null,inst_32501);
var inst_32503 = inst_32502;
var inst_32504 = null;
var inst_32505 = (0);
var inst_32506 = (0);
var state_32551__$1 = (function (){var statearr_32568 = state_32551;
(statearr_32568[(8)] = inst_32504);

(statearr_32568[(10)] = inst_32506);

(statearr_32568[(11)] = inst_32503);

(statearr_32568[(12)] = inst_32505);

return statearr_32568;
})();
var statearr_32569_32600 = state_32551__$1;
(statearr_32569_32600[(2)] = null);

(statearr_32569_32600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (17))){
var inst_32517 = (state_32551[(7)]);
var inst_32521 = cljs.core.chunk_first.call(null,inst_32517);
var inst_32522 = cljs.core.chunk_rest.call(null,inst_32517);
var inst_32523 = cljs.core.count.call(null,inst_32521);
var inst_32503 = inst_32522;
var inst_32504 = inst_32521;
var inst_32505 = inst_32523;
var inst_32506 = (0);
var state_32551__$1 = (function (){var statearr_32570 = state_32551;
(statearr_32570[(8)] = inst_32504);

(statearr_32570[(10)] = inst_32506);

(statearr_32570[(11)] = inst_32503);

(statearr_32570[(12)] = inst_32505);

return statearr_32570;
})();
var statearr_32571_32601 = state_32551__$1;
(statearr_32571_32601[(2)] = null);

(statearr_32571_32601[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (3))){
var inst_32549 = (state_32551[(2)]);
var state_32551__$1 = state_32551;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32551__$1,inst_32549);
} else {
if((state_val_32552 === (12))){
var inst_32537 = (state_32551[(2)]);
var state_32551__$1 = state_32551;
var statearr_32572_32602 = state_32551__$1;
(statearr_32572_32602[(2)] = inst_32537);

(statearr_32572_32602[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (2))){
var state_32551__$1 = state_32551;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32551__$1,(4),in$);
} else {
if((state_val_32552 === (23))){
var inst_32545 = (state_32551[(2)]);
var state_32551__$1 = state_32551;
var statearr_32573_32603 = state_32551__$1;
(statearr_32573_32603[(2)] = inst_32545);

(statearr_32573_32603[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (19))){
var inst_32532 = (state_32551[(2)]);
var state_32551__$1 = state_32551;
var statearr_32574_32604 = state_32551__$1;
(statearr_32574_32604[(2)] = inst_32532);

(statearr_32574_32604[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (11))){
var inst_32517 = (state_32551[(7)]);
var inst_32503 = (state_32551[(11)]);
var inst_32517__$1 = cljs.core.seq.call(null,inst_32503);
var state_32551__$1 = (function (){var statearr_32575 = state_32551;
(statearr_32575[(7)] = inst_32517__$1);

return statearr_32575;
})();
if(inst_32517__$1){
var statearr_32576_32605 = state_32551__$1;
(statearr_32576_32605[(1)] = (14));

} else {
var statearr_32577_32606 = state_32551__$1;
(statearr_32577_32606[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (9))){
var inst_32539 = (state_32551[(2)]);
var inst_32540 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_32551__$1 = (function (){var statearr_32578 = state_32551;
(statearr_32578[(15)] = inst_32539);

return statearr_32578;
})();
if(cljs.core.truth_(inst_32540)){
var statearr_32579_32607 = state_32551__$1;
(statearr_32579_32607[(1)] = (21));

} else {
var statearr_32580_32608 = state_32551__$1;
(statearr_32580_32608[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (5))){
var inst_32495 = cljs.core.async.close_BANG_.call(null,out);
var state_32551__$1 = state_32551;
var statearr_32581_32609 = state_32551__$1;
(statearr_32581_32609[(2)] = inst_32495);

(statearr_32581_32609[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (14))){
var inst_32517 = (state_32551[(7)]);
var inst_32519 = cljs.core.chunked_seq_QMARK_.call(null,inst_32517);
var state_32551__$1 = state_32551;
if(inst_32519){
var statearr_32582_32610 = state_32551__$1;
(statearr_32582_32610[(1)] = (17));

} else {
var statearr_32583_32611 = state_32551__$1;
(statearr_32583_32611[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (16))){
var inst_32535 = (state_32551[(2)]);
var state_32551__$1 = state_32551;
var statearr_32584_32612 = state_32551__$1;
(statearr_32584_32612[(2)] = inst_32535);

(statearr_32584_32612[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32552 === (10))){
var inst_32504 = (state_32551[(8)]);
var inst_32506 = (state_32551[(10)]);
var inst_32511 = cljs.core._nth.call(null,inst_32504,inst_32506);
var state_32551__$1 = state_32551;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32551__$1,(13),out,inst_32511);
} else {
if((state_val_32552 === (18))){
var inst_32517 = (state_32551[(7)]);
var inst_32526 = cljs.core.first.call(null,inst_32517);
var state_32551__$1 = state_32551;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32551__$1,(20),out,inst_32526);
} else {
if((state_val_32552 === (8))){
var inst_32506 = (state_32551[(10)]);
var inst_32505 = (state_32551[(12)]);
var inst_32508 = (inst_32506 < inst_32505);
var inst_32509 = inst_32508;
var state_32551__$1 = state_32551;
if(cljs.core.truth_(inst_32509)){
var statearr_32585_32613 = state_32551__$1;
(statearr_32585_32613[(1)] = (10));

} else {
var statearr_32586_32614 = state_32551__$1;
(statearr_32586_32614[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto__))
;
return ((function (switch__30861__auto__,c__30949__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__30862__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__30862__auto____0 = (function (){
var statearr_32587 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32587[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__30862__auto__);

(statearr_32587[(1)] = (1));

return statearr_32587;
});
var cljs$core$async$mapcat_STAR__$_state_machine__30862__auto____1 = (function (state_32551){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_32551);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e32588){if((e32588 instanceof Object)){
var ex__30865__auto__ = e32588;
var statearr_32589_32615 = state_32551;
(statearr_32589_32615[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32551);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32588;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32616 = state_32551;
state_32551 = G__32616;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__30862__auto__ = function(state_32551){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__30862__auto____1.call(this,state_32551);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__30862__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__30862__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto__))
})();
var state__30951__auto__ = (function (){var statearr_32590 = f__30950__auto__.call(null);
(statearr_32590[(6)] = c__30949__auto__);

return statearr_32590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto__))
);

return c__30949__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__32618 = arguments.length;
switch (G__32618) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__32621 = arguments.length;
switch (G__32621) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__32624 = arguments.length;
switch (G__32624) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30949__auto___32671 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___32671,out){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___32671,out){
return (function (state_32648){
var state_val_32649 = (state_32648[(1)]);
if((state_val_32649 === (7))){
var inst_32643 = (state_32648[(2)]);
var state_32648__$1 = state_32648;
var statearr_32650_32672 = state_32648__$1;
(statearr_32650_32672[(2)] = inst_32643);

(statearr_32650_32672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32649 === (1))){
var inst_32625 = null;
var state_32648__$1 = (function (){var statearr_32651 = state_32648;
(statearr_32651[(7)] = inst_32625);

return statearr_32651;
})();
var statearr_32652_32673 = state_32648__$1;
(statearr_32652_32673[(2)] = null);

(statearr_32652_32673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32649 === (4))){
var inst_32628 = (state_32648[(8)]);
var inst_32628__$1 = (state_32648[(2)]);
var inst_32629 = (inst_32628__$1 == null);
var inst_32630 = cljs.core.not.call(null,inst_32629);
var state_32648__$1 = (function (){var statearr_32653 = state_32648;
(statearr_32653[(8)] = inst_32628__$1);

return statearr_32653;
})();
if(inst_32630){
var statearr_32654_32674 = state_32648__$1;
(statearr_32654_32674[(1)] = (5));

} else {
var statearr_32655_32675 = state_32648__$1;
(statearr_32655_32675[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32649 === (6))){
var state_32648__$1 = state_32648;
var statearr_32656_32676 = state_32648__$1;
(statearr_32656_32676[(2)] = null);

(statearr_32656_32676[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32649 === (3))){
var inst_32645 = (state_32648[(2)]);
var inst_32646 = cljs.core.async.close_BANG_.call(null,out);
var state_32648__$1 = (function (){var statearr_32657 = state_32648;
(statearr_32657[(9)] = inst_32645);

return statearr_32657;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32648__$1,inst_32646);
} else {
if((state_val_32649 === (2))){
var state_32648__$1 = state_32648;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32648__$1,(4),ch);
} else {
if((state_val_32649 === (11))){
var inst_32628 = (state_32648[(8)]);
var inst_32637 = (state_32648[(2)]);
var inst_32625 = inst_32628;
var state_32648__$1 = (function (){var statearr_32658 = state_32648;
(statearr_32658[(7)] = inst_32625);

(statearr_32658[(10)] = inst_32637);

return statearr_32658;
})();
var statearr_32659_32677 = state_32648__$1;
(statearr_32659_32677[(2)] = null);

(statearr_32659_32677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32649 === (9))){
var inst_32628 = (state_32648[(8)]);
var state_32648__$1 = state_32648;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32648__$1,(11),out,inst_32628);
} else {
if((state_val_32649 === (5))){
var inst_32625 = (state_32648[(7)]);
var inst_32628 = (state_32648[(8)]);
var inst_32632 = cljs.core._EQ_.call(null,inst_32628,inst_32625);
var state_32648__$1 = state_32648;
if(inst_32632){
var statearr_32661_32678 = state_32648__$1;
(statearr_32661_32678[(1)] = (8));

} else {
var statearr_32662_32679 = state_32648__$1;
(statearr_32662_32679[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32649 === (10))){
var inst_32640 = (state_32648[(2)]);
var state_32648__$1 = state_32648;
var statearr_32663_32680 = state_32648__$1;
(statearr_32663_32680[(2)] = inst_32640);

(statearr_32663_32680[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32649 === (8))){
var inst_32625 = (state_32648[(7)]);
var tmp32660 = inst_32625;
var inst_32625__$1 = tmp32660;
var state_32648__$1 = (function (){var statearr_32664 = state_32648;
(statearr_32664[(7)] = inst_32625__$1);

return statearr_32664;
})();
var statearr_32665_32681 = state_32648__$1;
(statearr_32665_32681[(2)] = null);

(statearr_32665_32681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto___32671,out))
;
return ((function (switch__30861__auto__,c__30949__auto___32671,out){
return (function() {
var cljs$core$async$state_machine__30862__auto__ = null;
var cljs$core$async$state_machine__30862__auto____0 = (function (){
var statearr_32666 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32666[(0)] = cljs$core$async$state_machine__30862__auto__);

(statearr_32666[(1)] = (1));

return statearr_32666;
});
var cljs$core$async$state_machine__30862__auto____1 = (function (state_32648){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_32648);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e32667){if((e32667 instanceof Object)){
var ex__30865__auto__ = e32667;
var statearr_32668_32682 = state_32648;
(statearr_32668_32682[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32648);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32667;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32683 = state_32648;
state_32648 = G__32683;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$state_machine__30862__auto__ = function(state_32648){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30862__auto____1.call(this,state_32648);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30862__auto____0;
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30862__auto____1;
return cljs$core$async$state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___32671,out))
})();
var state__30951__auto__ = (function (){var statearr_32669 = f__30950__auto__.call(null);
(statearr_32669[(6)] = c__30949__auto___32671);

return statearr_32669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___32671,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__32685 = arguments.length;
switch (G__32685) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30949__auto___32751 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___32751,out){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___32751,out){
return (function (state_32723){
var state_val_32724 = (state_32723[(1)]);
if((state_val_32724 === (7))){
var inst_32719 = (state_32723[(2)]);
var state_32723__$1 = state_32723;
var statearr_32725_32752 = state_32723__$1;
(statearr_32725_32752[(2)] = inst_32719);

(statearr_32725_32752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32724 === (1))){
var inst_32686 = (new Array(n));
var inst_32687 = inst_32686;
var inst_32688 = (0);
var state_32723__$1 = (function (){var statearr_32726 = state_32723;
(statearr_32726[(7)] = inst_32688);

(statearr_32726[(8)] = inst_32687);

return statearr_32726;
})();
var statearr_32727_32753 = state_32723__$1;
(statearr_32727_32753[(2)] = null);

(statearr_32727_32753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32724 === (4))){
var inst_32691 = (state_32723[(9)]);
var inst_32691__$1 = (state_32723[(2)]);
var inst_32692 = (inst_32691__$1 == null);
var inst_32693 = cljs.core.not.call(null,inst_32692);
var state_32723__$1 = (function (){var statearr_32728 = state_32723;
(statearr_32728[(9)] = inst_32691__$1);

return statearr_32728;
})();
if(inst_32693){
var statearr_32729_32754 = state_32723__$1;
(statearr_32729_32754[(1)] = (5));

} else {
var statearr_32730_32755 = state_32723__$1;
(statearr_32730_32755[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32724 === (15))){
var inst_32713 = (state_32723[(2)]);
var state_32723__$1 = state_32723;
var statearr_32731_32756 = state_32723__$1;
(statearr_32731_32756[(2)] = inst_32713);

(statearr_32731_32756[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32724 === (13))){
var state_32723__$1 = state_32723;
var statearr_32732_32757 = state_32723__$1;
(statearr_32732_32757[(2)] = null);

(statearr_32732_32757[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32724 === (6))){
var inst_32688 = (state_32723[(7)]);
var inst_32709 = (inst_32688 > (0));
var state_32723__$1 = state_32723;
if(cljs.core.truth_(inst_32709)){
var statearr_32733_32758 = state_32723__$1;
(statearr_32733_32758[(1)] = (12));

} else {
var statearr_32734_32759 = state_32723__$1;
(statearr_32734_32759[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32724 === (3))){
var inst_32721 = (state_32723[(2)]);
var state_32723__$1 = state_32723;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32723__$1,inst_32721);
} else {
if((state_val_32724 === (12))){
var inst_32687 = (state_32723[(8)]);
var inst_32711 = cljs.core.vec.call(null,inst_32687);
var state_32723__$1 = state_32723;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32723__$1,(15),out,inst_32711);
} else {
if((state_val_32724 === (2))){
var state_32723__$1 = state_32723;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32723__$1,(4),ch);
} else {
if((state_val_32724 === (11))){
var inst_32703 = (state_32723[(2)]);
var inst_32704 = (new Array(n));
var inst_32687 = inst_32704;
var inst_32688 = (0);
var state_32723__$1 = (function (){var statearr_32735 = state_32723;
(statearr_32735[(7)] = inst_32688);

(statearr_32735[(10)] = inst_32703);

(statearr_32735[(8)] = inst_32687);

return statearr_32735;
})();
var statearr_32736_32760 = state_32723__$1;
(statearr_32736_32760[(2)] = null);

(statearr_32736_32760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32724 === (9))){
var inst_32687 = (state_32723[(8)]);
var inst_32701 = cljs.core.vec.call(null,inst_32687);
var state_32723__$1 = state_32723;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32723__$1,(11),out,inst_32701);
} else {
if((state_val_32724 === (5))){
var inst_32691 = (state_32723[(9)]);
var inst_32688 = (state_32723[(7)]);
var inst_32696 = (state_32723[(11)]);
var inst_32687 = (state_32723[(8)]);
var inst_32695 = (inst_32687[inst_32688] = inst_32691);
var inst_32696__$1 = (inst_32688 + (1));
var inst_32697 = (inst_32696__$1 < n);
var state_32723__$1 = (function (){var statearr_32737 = state_32723;
(statearr_32737[(12)] = inst_32695);

(statearr_32737[(11)] = inst_32696__$1);

return statearr_32737;
})();
if(cljs.core.truth_(inst_32697)){
var statearr_32738_32761 = state_32723__$1;
(statearr_32738_32761[(1)] = (8));

} else {
var statearr_32739_32762 = state_32723__$1;
(statearr_32739_32762[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32724 === (14))){
var inst_32716 = (state_32723[(2)]);
var inst_32717 = cljs.core.async.close_BANG_.call(null,out);
var state_32723__$1 = (function (){var statearr_32741 = state_32723;
(statearr_32741[(13)] = inst_32716);

return statearr_32741;
})();
var statearr_32742_32763 = state_32723__$1;
(statearr_32742_32763[(2)] = inst_32717);

(statearr_32742_32763[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32724 === (10))){
var inst_32707 = (state_32723[(2)]);
var state_32723__$1 = state_32723;
var statearr_32743_32764 = state_32723__$1;
(statearr_32743_32764[(2)] = inst_32707);

(statearr_32743_32764[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32724 === (8))){
var inst_32696 = (state_32723[(11)]);
var inst_32687 = (state_32723[(8)]);
var tmp32740 = inst_32687;
var inst_32687__$1 = tmp32740;
var inst_32688 = inst_32696;
var state_32723__$1 = (function (){var statearr_32744 = state_32723;
(statearr_32744[(7)] = inst_32688);

(statearr_32744[(8)] = inst_32687__$1);

return statearr_32744;
})();
var statearr_32745_32765 = state_32723__$1;
(statearr_32745_32765[(2)] = null);

(statearr_32745_32765[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto___32751,out))
;
return ((function (switch__30861__auto__,c__30949__auto___32751,out){
return (function() {
var cljs$core$async$state_machine__30862__auto__ = null;
var cljs$core$async$state_machine__30862__auto____0 = (function (){
var statearr_32746 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32746[(0)] = cljs$core$async$state_machine__30862__auto__);

(statearr_32746[(1)] = (1));

return statearr_32746;
});
var cljs$core$async$state_machine__30862__auto____1 = (function (state_32723){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_32723);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e32747){if((e32747 instanceof Object)){
var ex__30865__auto__ = e32747;
var statearr_32748_32766 = state_32723;
(statearr_32748_32766[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32723);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32747;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32767 = state_32723;
state_32723 = G__32767;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$state_machine__30862__auto__ = function(state_32723){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30862__auto____1.call(this,state_32723);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30862__auto____0;
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30862__auto____1;
return cljs$core$async$state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___32751,out))
})();
var state__30951__auto__ = (function (){var statearr_32749 = f__30950__auto__.call(null);
(statearr_32749[(6)] = c__30949__auto___32751);

return statearr_32749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___32751,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__32769 = arguments.length;
switch (G__32769) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30949__auto___32839 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___32839,out){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___32839,out){
return (function (state_32811){
var state_val_32812 = (state_32811[(1)]);
if((state_val_32812 === (7))){
var inst_32807 = (state_32811[(2)]);
var state_32811__$1 = state_32811;
var statearr_32813_32840 = state_32811__$1;
(statearr_32813_32840[(2)] = inst_32807);

(statearr_32813_32840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32812 === (1))){
var inst_32770 = [];
var inst_32771 = inst_32770;
var inst_32772 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_32811__$1 = (function (){var statearr_32814 = state_32811;
(statearr_32814[(7)] = inst_32771);

(statearr_32814[(8)] = inst_32772);

return statearr_32814;
})();
var statearr_32815_32841 = state_32811__$1;
(statearr_32815_32841[(2)] = null);

(statearr_32815_32841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32812 === (4))){
var inst_32775 = (state_32811[(9)]);
var inst_32775__$1 = (state_32811[(2)]);
var inst_32776 = (inst_32775__$1 == null);
var inst_32777 = cljs.core.not.call(null,inst_32776);
var state_32811__$1 = (function (){var statearr_32816 = state_32811;
(statearr_32816[(9)] = inst_32775__$1);

return statearr_32816;
})();
if(inst_32777){
var statearr_32817_32842 = state_32811__$1;
(statearr_32817_32842[(1)] = (5));

} else {
var statearr_32818_32843 = state_32811__$1;
(statearr_32818_32843[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32812 === (15))){
var inst_32801 = (state_32811[(2)]);
var state_32811__$1 = state_32811;
var statearr_32819_32844 = state_32811__$1;
(statearr_32819_32844[(2)] = inst_32801);

(statearr_32819_32844[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32812 === (13))){
var state_32811__$1 = state_32811;
var statearr_32820_32845 = state_32811__$1;
(statearr_32820_32845[(2)] = null);

(statearr_32820_32845[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32812 === (6))){
var inst_32771 = (state_32811[(7)]);
var inst_32796 = inst_32771.length;
var inst_32797 = (inst_32796 > (0));
var state_32811__$1 = state_32811;
if(cljs.core.truth_(inst_32797)){
var statearr_32821_32846 = state_32811__$1;
(statearr_32821_32846[(1)] = (12));

} else {
var statearr_32822_32847 = state_32811__$1;
(statearr_32822_32847[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32812 === (3))){
var inst_32809 = (state_32811[(2)]);
var state_32811__$1 = state_32811;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32811__$1,inst_32809);
} else {
if((state_val_32812 === (12))){
var inst_32771 = (state_32811[(7)]);
var inst_32799 = cljs.core.vec.call(null,inst_32771);
var state_32811__$1 = state_32811;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32811__$1,(15),out,inst_32799);
} else {
if((state_val_32812 === (2))){
var state_32811__$1 = state_32811;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32811__$1,(4),ch);
} else {
if((state_val_32812 === (11))){
var inst_32779 = (state_32811[(10)]);
var inst_32775 = (state_32811[(9)]);
var inst_32789 = (state_32811[(2)]);
var inst_32790 = [];
var inst_32791 = inst_32790.push(inst_32775);
var inst_32771 = inst_32790;
var inst_32772 = inst_32779;
var state_32811__$1 = (function (){var statearr_32823 = state_32811;
(statearr_32823[(7)] = inst_32771);

(statearr_32823[(11)] = inst_32791);

(statearr_32823[(8)] = inst_32772);

(statearr_32823[(12)] = inst_32789);

return statearr_32823;
})();
var statearr_32824_32848 = state_32811__$1;
(statearr_32824_32848[(2)] = null);

(statearr_32824_32848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32812 === (9))){
var inst_32771 = (state_32811[(7)]);
var inst_32787 = cljs.core.vec.call(null,inst_32771);
var state_32811__$1 = state_32811;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32811__$1,(11),out,inst_32787);
} else {
if((state_val_32812 === (5))){
var inst_32779 = (state_32811[(10)]);
var inst_32772 = (state_32811[(8)]);
var inst_32775 = (state_32811[(9)]);
var inst_32779__$1 = f.call(null,inst_32775);
var inst_32780 = cljs.core._EQ_.call(null,inst_32779__$1,inst_32772);
var inst_32781 = cljs.core.keyword_identical_QMARK_.call(null,inst_32772,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_32782 = (inst_32780) || (inst_32781);
var state_32811__$1 = (function (){var statearr_32825 = state_32811;
(statearr_32825[(10)] = inst_32779__$1);

return statearr_32825;
})();
if(cljs.core.truth_(inst_32782)){
var statearr_32826_32849 = state_32811__$1;
(statearr_32826_32849[(1)] = (8));

} else {
var statearr_32827_32850 = state_32811__$1;
(statearr_32827_32850[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32812 === (14))){
var inst_32804 = (state_32811[(2)]);
var inst_32805 = cljs.core.async.close_BANG_.call(null,out);
var state_32811__$1 = (function (){var statearr_32829 = state_32811;
(statearr_32829[(13)] = inst_32804);

return statearr_32829;
})();
var statearr_32830_32851 = state_32811__$1;
(statearr_32830_32851[(2)] = inst_32805);

(statearr_32830_32851[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32812 === (10))){
var inst_32794 = (state_32811[(2)]);
var state_32811__$1 = state_32811;
var statearr_32831_32852 = state_32811__$1;
(statearr_32831_32852[(2)] = inst_32794);

(statearr_32831_32852[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32812 === (8))){
var inst_32771 = (state_32811[(7)]);
var inst_32779 = (state_32811[(10)]);
var inst_32775 = (state_32811[(9)]);
var inst_32784 = inst_32771.push(inst_32775);
var tmp32828 = inst_32771;
var inst_32771__$1 = tmp32828;
var inst_32772 = inst_32779;
var state_32811__$1 = (function (){var statearr_32832 = state_32811;
(statearr_32832[(7)] = inst_32771__$1);

(statearr_32832[(14)] = inst_32784);

(statearr_32832[(8)] = inst_32772);

return statearr_32832;
})();
var statearr_32833_32853 = state_32811__$1;
(statearr_32833_32853[(2)] = null);

(statearr_32833_32853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto___32839,out))
;
return ((function (switch__30861__auto__,c__30949__auto___32839,out){
return (function() {
var cljs$core$async$state_machine__30862__auto__ = null;
var cljs$core$async$state_machine__30862__auto____0 = (function (){
var statearr_32834 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32834[(0)] = cljs$core$async$state_machine__30862__auto__);

(statearr_32834[(1)] = (1));

return statearr_32834;
});
var cljs$core$async$state_machine__30862__auto____1 = (function (state_32811){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_32811);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e32835){if((e32835 instanceof Object)){
var ex__30865__auto__ = e32835;
var statearr_32836_32854 = state_32811;
(statearr_32836_32854[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32811);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32835;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32855 = state_32811;
state_32811 = G__32855;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
cljs$core$async$state_machine__30862__auto__ = function(state_32811){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30862__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30862__auto____1.call(this,state_32811);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30862__auto____0;
cljs$core$async$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30862__auto____1;
return cljs$core$async$state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___32839,out))
})();
var state__30951__auto__ = (function (){var statearr_32837 = f__30950__auto__.call(null);
(statearr_32837[(6)] = c__30949__auto___32839);

return statearr_32837;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___32839,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1516869009409
