// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
re_frame.fx.kind = cljs.core.cst$kw$fx;
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$id,cljs.core.cst$kw$do_DASH_fx,cljs.core.cst$kw$after,(function re_frame$fx$do_fx_after(context){
var seq__15246 = cljs.core.seq(cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context));
var chunk__15247 = null;
var count__15248 = (0);
var i__15249 = (0);
while(true){
if((i__15249 < count__15248)){
var vec__15255 = chunk__15247.cljs$core$IIndexed$_nth$arity$2(null,i__15249);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15255,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15255,(1),null);
var temp__4655__auto___15271 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__4655__auto___15271)){
var effect_fn_15272 = temp__4655__auto___15271;
(effect_fn_15272.cljs$core$IFn$_invoke$arity$1 ? effect_fn_15272.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_15272.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring."], 0));
}

var G__15273 = seq__15246;
var G__15274 = chunk__15247;
var G__15275 = count__15248;
var G__15276 = (i__15249 + (1));
seq__15246 = G__15273;
chunk__15247 = G__15274;
count__15248 = G__15275;
i__15249 = G__15276;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__15246);
if(temp__4657__auto__){
var seq__15246__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15246__$1)){
var c__8898__auto__ = cljs.core.chunk_first(seq__15246__$1);
var G__15277 = cljs.core.chunk_rest(seq__15246__$1);
var G__15278 = c__8898__auto__;
var G__15279 = cljs.core.count(c__8898__auto__);
var G__15280 = (0);
seq__15246 = G__15277;
chunk__15247 = G__15278;
count__15248 = G__15279;
i__15249 = G__15280;
continue;
} else {
var vec__15262 = cljs.core.first(seq__15246__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15262,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15262,(1),null);
var temp__4655__auto___15281 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__4655__auto___15281)){
var effect_fn_15282 = temp__4655__auto___15281;
(effect_fn_15282.cljs$core$IFn$_invoke$arity$1 ? effect_fn_15282.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_15282.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring."], 0));
}

var G__15283 = cljs.core.next(seq__15246__$1);
var G__15284 = null;
var G__15285 = (0);
var G__15286 = (0);
seq__15246 = G__15283;
chunk__15247 = G__15284;
count__15248 = G__15285;
i__15249 = G__15286;
continue;
}
} else {
return null;
}
}
break;
}
})], 0));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_later,(function (value){
var seq__15287 = cljs.core.seq(value);
var chunk__15288 = null;
var count__15289 = (0);
var i__15290 = (0);
while(true){
if((i__15290 < count__15289)){
var map__15291 = chunk__15288.cljs$core$IIndexed$_nth$arity$2(null,i__15290);
var map__15291__$1 = ((((!((map__15291 == null)))?((((map__15291.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15291.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15291):map__15291);
var effect = map__15291__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15291__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15291__$1,cljs.core.cst$kw$dispatch);
if((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__15287,chunk__15288,count__15289,i__15290,map__15291,map__15291__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__15287,chunk__15288,count__15289,i__15290,map__15291,map__15291__$1,effect,ms,dispatch))
,ms);
}

var G__15295 = seq__15287;
var G__15296 = chunk__15288;
var G__15297 = count__15289;
var G__15298 = (i__15290 + (1));
seq__15287 = G__15295;
chunk__15288 = G__15296;
count__15289 = G__15297;
i__15290 = G__15298;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__15287);
if(temp__4657__auto__){
var seq__15287__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15287__$1)){
var c__8898__auto__ = cljs.core.chunk_first(seq__15287__$1);
var G__15299 = cljs.core.chunk_rest(seq__15287__$1);
var G__15300 = c__8898__auto__;
var G__15301 = cljs.core.count(c__8898__auto__);
var G__15302 = (0);
seq__15287 = G__15299;
chunk__15288 = G__15300;
count__15289 = G__15301;
i__15290 = G__15302;
continue;
} else {
var map__15293 = cljs.core.first(seq__15287__$1);
var map__15293__$1 = ((((!((map__15293 == null)))?((((map__15293.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15293.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15293):map__15293);
var effect = map__15293__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15293__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15293__$1,cljs.core.cst$kw$dispatch);
if((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__15287,chunk__15288,count__15289,i__15290,map__15293,map__15293__$1,effect,ms,dispatch,seq__15287__$1,temp__4657__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__15287,chunk__15288,count__15289,i__15290,map__15293,map__15293__$1,effect,ms,dispatch,seq__15287__$1,temp__4657__auto__))
,ms);
}

var G__15303 = cljs.core.next(seq__15287__$1);
var G__15304 = null;
var G__15305 = (0);
var G__15306 = (0);
seq__15287 = G__15303;
chunk__15288 = G__15304;
count__15289 = G__15305;
i__15290 = G__15306;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch,(function (value){
if(!(cljs.core.vector_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_n,(function (value){
if(!(cljs.core.sequential_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value], 0));
} else {
var seq__15307 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__15308 = null;
var count__15309 = (0);
var i__15310 = (0);
while(true){
if((i__15310 < count__15309)){
var event = chunk__15308.cljs$core$IIndexed$_nth$arity$2(null,i__15310);
re_frame.router.dispatch(event);

var G__15311 = seq__15307;
var G__15312 = chunk__15308;
var G__15313 = count__15309;
var G__15314 = (i__15310 + (1));
seq__15307 = G__15311;
chunk__15308 = G__15312;
count__15309 = G__15313;
i__15310 = G__15314;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__15307);
if(temp__4657__auto__){
var seq__15307__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15307__$1)){
var c__8898__auto__ = cljs.core.chunk_first(seq__15307__$1);
var G__15315 = cljs.core.chunk_rest(seq__15307__$1);
var G__15316 = c__8898__auto__;
var G__15317 = cljs.core.count(c__8898__auto__);
var G__15318 = (0);
seq__15307 = G__15315;
chunk__15308 = G__15316;
count__15309 = G__15317;
i__15310 = G__15318;
continue;
} else {
var event = cljs.core.first(seq__15307__$1);
re_frame.router.dispatch(event);

var G__15319 = cljs.core.next(seq__15307__$1);
var G__15320 = null;
var G__15321 = (0);
var G__15322 = (0);
seq__15307 = G__15319;
chunk__15308 = G__15320;
count__15309 = G__15321;
i__15310 = G__15322;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$deregister_DASH_event_DASH_handler,(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__15323 = cljs.core.seq(value);
var chunk__15324 = null;
var count__15325 = (0);
var i__15326 = (0);
while(true){
if((i__15326 < count__15325)){
var event = chunk__15324.cljs$core$IIndexed$_nth$arity$2(null,i__15326);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));

var G__15327 = seq__15323;
var G__15328 = chunk__15324;
var G__15329 = count__15325;
var G__15330 = (i__15326 + (1));
seq__15323 = G__15327;
chunk__15324 = G__15328;
count__15325 = G__15329;
i__15326 = G__15330;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__15323);
if(temp__4657__auto__){
var seq__15323__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15323__$1)){
var c__8898__auto__ = cljs.core.chunk_first(seq__15323__$1);
var G__15331 = cljs.core.chunk_rest(seq__15323__$1);
var G__15332 = c__8898__auto__;
var G__15333 = cljs.core.count(c__8898__auto__);
var G__15334 = (0);
seq__15323 = G__15331;
chunk__15324 = G__15332;
count__15325 = G__15333;
i__15326 = G__15334;
continue;
} else {
var event = cljs.core.first(seq__15323__$1);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));

var G__15335 = cljs.core.next(seq__15323__$1);
var G__15336 = null;
var G__15337 = (0);
var G__15338 = (0);
seq__15323 = G__15335;
chunk__15324 = G__15336;
count__15325 = G__15337;
i__15326 = G__15338;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return (clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(value) : clear_event.call(null,value));
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$db,(function (value){
if(!((cljs.core.deref(re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));
