// Compiled by ClojureScript 1.9.946 {}
goog.provide('re_com.typeahead');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('re_com.misc');
goog.require('re_com.util');
goog.require('re_com.popover');
goog.require('re_com.box');
goog.require('re_com.validate');
goog.require('reagent.core');
goog.require('goog.events.KeyCodes');

/**
 * Return an initial value for the typeahead state, given `args`.
 */
re_com.typeahead.make_typeahead_state = (function re_com$typeahead$make_typeahead_state(p__33046){
var map__33047 = p__33046;
var map__33047__$1 = ((((!((map__33047 == null)))?((((map__33047.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33047.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33047):map__33047);
var args = map__33047__$1;
var on_change = cljs.core.get.call(null,map__33047__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var rigid_QMARK_ = cljs.core.get.call(null,map__33047__$1,new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118));
var change_on_blur_QMARK_ = cljs.core.get.call(null,map__33047__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var data_source = cljs.core.get.call(null,map__33047__$1,new cljs.core.Keyword(null,"data-source","data-source",-658934676));
var suggestion_to_string = cljs.core.get.call(null,map__33047__$1,new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962));
var debounce_delay = cljs.core.get.call(null,map__33047__$1,new cljs.core.Keyword(null,"debounce-delay","debounce-delay",-608187982));
var model = cljs.core.get.call(null,map__33047__$1,new cljs.core.Keyword(null,"model","model",331153215));
var external_model_value = re_com.util.deref_or_value.call(null,model);
var G__33049 = (function (){var c_input = cljs.core.async.chan.call(null);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962),new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),new cljs.core.Keyword(null,"input-text","input-text",-1336297114),new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118),new cljs.core.Keyword(null,"data-source","data-source",-658934676),new cljs.core.Keyword(null,"c-search","c-search",1832536180),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),new cljs.core.Keyword(null,"c-input","c-input",-1821004232),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"external-model","external-model",506095421),new cljs.core.Keyword(null,"model","model",331153215)],[false,(function (){var or__28348__auto__ = suggestion_to_string;
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return cljs.core.str;
}
})(),false,"",rigid_QMARK_,data_source,re_com.typeahead.debounce.call(null,c_input,debounce_delay),change_on_blur_QMARK_,cljs.core.PersistentVector.EMPTY,c_input,on_change,re_com.util.deref_or_value.call(null,model),re_com.util.deref_or_value.call(null,model)]);
})();
if(cljs.core.truth_(external_model_value)){
return re_com.typeahead.display_suggestion.call(null,G__33049,external_model_value);
} else {
return G__33049;
}
});
/**
 * Should `event` update the `typeahead` `model`?
 */
re_com.typeahead.event_updates_model_QMARK_ = (function re_com$typeahead$event_updates_model_QMARK_(p__33050,event){
var map__33051 = p__33050;
var map__33051__$1 = ((((!((map__33051 == null)))?((((map__33051.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33051.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33051):map__33051);
var state = map__33051__$1;
var change_on_blur_QMARK_ = cljs.core.get.call(null,map__33051__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var rigid_QMARK_ = cljs.core.get.call(null,map__33051__$1,new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118));
var change_on_blur_QMARK___$1 = re_com.util.deref_or_value.call(null,change_on_blur_QMARK_);
var rigid_QMARK___$1 = re_com.util.deref_or_value.call(null,rigid_QMARK_);
var G__33053 = event;
var G__33053__$1 = (((G__33053 instanceof cljs.core.Keyword))?G__33053.fqn:null);
switch (G__33053__$1) {
case "input-text-blurred":
var and__28336__auto__ = change_on_blur_QMARK___$1;
if(cljs.core.truth_(and__28336__auto__)){
return cljs.core.not.call(null,rigid_QMARK___$1);
} else {
return and__28336__auto__;
}

break;
case "suggestion-activated":
return cljs.core.not.call(null,change_on_blur_QMARK___$1);

break;
case "input-text-changed":
return cljs.core.not.call(null,(function (){var or__28348__auto__ = change_on_blur_QMARK___$1;
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return rigid_QMARK___$1;
}
})());

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33053__$1)].join('')));

}
});
/**
 * Should `event` cause the `input-text` value to be used to show the active suggestion?
 */
re_com.typeahead.event_displays_suggestion_QMARK_ = (function re_com$typeahead$event_displays_suggestion_QMARK_(p__33055,event){
var map__33056 = p__33055;
var map__33056__$1 = ((((!((map__33056 == null)))?((((map__33056.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33056.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33056):map__33056);
var state = map__33056__$1;
var change_on_blur_QMARK_ = cljs.core.get.call(null,map__33056__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var change_on_blur_QMARK___$1 = re_com.util.deref_or_value.call(null,change_on_blur_QMARK_);
var G__33058 = event;
var G__33058__$1 = (((G__33058 instanceof cljs.core.Keyword))?G__33058.fqn:null);
switch (G__33058__$1) {
case "suggestion-activated":
return cljs.core.not.call(null,change_on_blur_QMARK___$1);

break;
default:
return false;

}
});
/**
 * Change the `typeahead` `model` value to `new-value`
 */
re_com.typeahead.update_model = (function re_com$typeahead$update_model(p__33060,new_value){
var map__33061 = p__33060;
var map__33061__$1 = ((((!((map__33061 == null)))?((((map__33061.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33061.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33061):map__33061);
var state = map__33061__$1;
var on_change = cljs.core.get.call(null,map__33061__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
if(cljs.core.truth_(on_change)){
on_change.call(null,new_value);
} else {
}

return cljs.core.assoc.call(null,state,new cljs.core.Keyword(null,"model","model",331153215),new_value);
});
/**
 * Change the `input-text` `model` to the string representation of `suggestion`
 */
re_com.typeahead.display_suggestion = (function re_com$typeahead$display_suggestion(p__33063,suggestion){
var map__33064 = p__33063;
var map__33064__$1 = ((((!((map__33064 == null)))?((((map__33064.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33064.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33064):map__33064);
var state = map__33064__$1;
var suggestion_to_string = cljs.core.get.call(null,map__33064__$1,new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962));
var suggestion_string = suggestion_to_string.call(null,suggestion);
var G__33066 = state;
if(cljs.core.truth_(suggestion_string)){
return cljs.core.assoc.call(null,G__33066,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),suggestion_string,new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),true);
} else {
return G__33066;
}
});
re_com.typeahead.clear_suggestions = (function re_com$typeahead$clear_suggestions(state){
return cljs.core.dissoc.call(null,state,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
});
/**
 * Make the suggestion at `index` the active suggestion
 */
re_com.typeahead.activate_suggestion_by_index = (function re_com$typeahead$activate_suggestion_by_index(p__33067,index){
var map__33068 = p__33067;
var map__33068__$1 = ((((!((map__33068 == null)))?((((map__33068.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33068.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33068):map__33068);
var state = map__33068__$1;
var suggestions = cljs.core.get.call(null,map__33068__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion = cljs.core.nth.call(null,suggestions,index);
var G__33070 = state;
var G__33070__$1 = cljs.core.assoc.call(null,G__33070,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728),index)
;
var G__33070__$2 = (cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"suggestion-activated","suggestion-activated",316961778)))?re_com.typeahead.update_model.call(null,G__33070__$1,suggestion):G__33070__$1);
if(cljs.core.truth_(re_com.typeahead.event_displays_suggestion_QMARK_.call(null,state,new cljs.core.Keyword(null,"suggestion-activated","suggestion-activated",316961778)))){
return re_com.typeahead.display_suggestion.call(null,G__33070__$2,suggestion);
} else {
return G__33070__$2;
}
});
/**
 * Choose the suggestion at `index`
 */
re_com.typeahead.choose_suggestion_by_index = (function re_com$typeahead$choose_suggestion_by_index(p__33071,index){
var map__33072 = p__33071;
var map__33072__$1 = ((((!((map__33072 == null)))?((((map__33072.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33072.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33072):map__33072);
var state = map__33072__$1;
var suggestions = cljs.core.get.call(null,map__33072__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion = cljs.core.nth.call(null,suggestions,index);
return re_com.typeahead.clear_suggestions.call(null,re_com.typeahead.display_suggestion.call(null,re_com.typeahead.update_model.call(null,re_com.typeahead.activate_suggestion_by_index.call(null,state,index),suggestion),suggestion));
});
re_com.typeahead.choose_suggestion_active = (function re_com$typeahead$choose_suggestion_active(p__33074){
var map__33075 = p__33074;
var map__33075__$1 = ((((!((map__33075 == null)))?((((map__33075.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33075.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33075):map__33075);
var state = map__33075__$1;
var suggestion_active_index = cljs.core.get.call(null,map__33075__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__33077 = state;
if(cljs.core.truth_(suggestion_active_index)){
return re_com.typeahead.choose_suggestion_by_index.call(null,G__33077,suggestion_active_index);
} else {
return G__33077;
}
});
re_com.typeahead.wrap = (function re_com$typeahead$wrap(index,count){
return cljs.core.mod.call(null,(count + index),count);
});
re_com.typeahead.activate_suggestion_next = (function re_com$typeahead$activate_suggestion_next(p__33078){
var map__33079 = p__33078;
var map__33079__$1 = ((((!((map__33079 == null)))?((((map__33079.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33079.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33079):map__33079);
var state = map__33079__$1;
var suggestions = cljs.core.get.call(null,map__33079__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion_active_index = cljs.core.get.call(null,map__33079__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__33081 = state;
if(cljs.core.truth_(suggestions)){
return re_com.typeahead.activate_suggestion_by_index.call(null,G__33081,re_com.typeahead.wrap.call(null,((function (){var or__28348__auto__ = suggestion_active_index;
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return (-1);
}
})() + (1)),cljs.core.count.call(null,suggestions)));
} else {
return G__33081;
}
});
re_com.typeahead.activate_suggestion_prev = (function re_com$typeahead$activate_suggestion_prev(p__33082){
var map__33083 = p__33082;
var map__33083__$1 = ((((!((map__33083 == null)))?((((map__33083.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33083.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33083):map__33083);
var state = map__33083__$1;
var suggestions = cljs.core.get.call(null,map__33083__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion_active_index = cljs.core.get.call(null,map__33083__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__33085 = state;
if(cljs.core.truth_(suggestions)){
return re_com.typeahead.activate_suggestion_by_index.call(null,G__33085,re_com.typeahead.wrap.call(null,((function (){var or__28348__auto__ = suggestion_active_index;
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return (0);
}
})() - (1)),cljs.core.count.call(null,suggestions)));
} else {
return G__33085;
}
});
re_com.typeahead.reset_typeahead = (function re_com$typeahead$reset_typeahead(state){
var G__33086 = state;
var G__33086__$1 = re_com.typeahead.clear_suggestions.call(null,G__33086)
;
var G__33086__$2 = cljs.core.assoc.call(null,G__33086__$1,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),false,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),"",new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),false)
;
if(cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"input-text-changed","input-text-changed",-1906799535)))){
return re_com.typeahead.update_model.call(null,G__33086__$2,null);
} else {
return G__33086__$2;
}
});
/**
 * Update state when new suggestions are available
 */
re_com.typeahead.got_suggestions = (function re_com$typeahead$got_suggestions(state,suggestions){
return cljs.core.assoc.call(null,state,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),suggestions,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),false,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728),null);
});
/**
 * Update state when the `input-text` is about to lose focus.
 */
re_com.typeahead.input_text_will_blur = (function re_com$typeahead$input_text_will_blur(p__33087){
var map__33088 = p__33087;
var map__33088__$1 = ((((!((map__33088 == null)))?((((map__33088.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33088.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33088):map__33088);
var state = map__33088__$1;
var input_text = cljs.core.get.call(null,map__33088__$1,new cljs.core.Keyword(null,"input-text","input-text",-1336297114));
var displaying_suggestion_QMARK_ = cljs.core.get.call(null,map__33088__$1,new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862));
var G__33090 = state;
if(cljs.core.truth_((function (){var and__28336__auto__ = cljs.core.not.call(null,displaying_suggestion_QMARK_);
if(and__28336__auto__){
return re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"input-text-blurred","input-text-blurred",-501892307));
} else {
return and__28336__auto__;
}
})())){
return re_com.typeahead.update_model.call(null,G__33090,input_text);
} else {
return G__33090;
}
});
/**
 * Update `state` given a new `data-source`. Resets the typeahead since any existing suggestions
 *   came from the old `data-source`.
 */
re_com.typeahead.change_data_source = (function re_com$typeahead$change_data_source(state,data_source){
return cljs.core.assoc.call(null,re_com.typeahead.reset_typeahead.call(null,state),new cljs.core.Keyword(null,"data-source","data-source",-658934676),data_source);
});
/**
 * Update state when the external model value has changed.
 */
re_com.typeahead.external_model_changed = (function re_com$typeahead$external_model_changed(state,new_value){
return re_com.typeahead.clear_suggestions.call(null,re_com.typeahead.display_suggestion.call(null,re_com.typeahead.update_model.call(null,state,new_value),new_value));
});
/**
 * Call the `data-source` fn with `text`, and then call `got-suggestions` with the result
 *   (asynchronously, if `data-source` does not return a truthy value).
 */
re_com.typeahead.search_data_source_BANG_ = (function re_com$typeahead$search_data_source_BANG_(data_source,state_atom,text){
var temp__4655__auto__ = data_source.call(null,text,(function (p1__33091_SHARP_){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.got_suggestions,p1__33091_SHARP_);
}));
if(cljs.core.truth_(temp__4655__auto__)){
var return_value = temp__4655__auto__;
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.got_suggestions,return_value);
} else {
return cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),true);
}
});
/**
 * For every value arriving on the `c-search` channel, call `search-data-source!`.
 */
re_com.typeahead.search_data_source_loop_BANG_ = (function re_com$typeahead$search_data_source_loop_BANG_(state_atom,c_search){
var c__30949__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto__){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto__){
return (function (state_33108){
var state_val_33109 = (state_33108[(1)]);
if((state_val_33109 === (1))){
var state_33108__$1 = state_33108;
var statearr_33110_33122 = state_33108__$1;
(statearr_33110_33122[(2)] = null);

(statearr_33110_33122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33109 === (2))){
var state_33108__$1 = state_33108;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33108__$1,(4),c_search);
} else {
if((state_val_33109 === (3))){
var inst_33106 = (state_33108[(2)]);
var state_33108__$1 = state_33108;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33108__$1,inst_33106);
} else {
if((state_val_33109 === (4))){
var inst_33094 = (state_33108[(7)]);
var inst_33094__$1 = (state_33108[(2)]);
var inst_33095 = cljs.core.deref.call(null,state_atom);
var inst_33096 = new cljs.core.Keyword(null,"data-source","data-source",-658934676).cljs$core$IFn$_invoke$arity$1(inst_33095);
var inst_33097 = cljs.core._EQ_.call(null,"",inst_33094__$1);
var state_33108__$1 = (function (){var statearr_33111 = state_33108;
(statearr_33111[(8)] = inst_33096);

(statearr_33111[(7)] = inst_33094__$1);

return statearr_33111;
})();
if(inst_33097){
var statearr_33112_33123 = state_33108__$1;
(statearr_33112_33123[(1)] = (5));

} else {
var statearr_33113_33124 = state_33108__$1;
(statearr_33113_33124[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33109 === (5))){
var inst_33099 = cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.reset_typeahead);
var state_33108__$1 = state_33108;
var statearr_33114_33125 = state_33108__$1;
(statearr_33114_33125[(2)] = inst_33099);

(statearr_33114_33125[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33109 === (6))){
var inst_33096 = (state_33108[(8)]);
var inst_33094 = (state_33108[(7)]);
var inst_33101 = re_com.typeahead.search_data_source_BANG_.call(null,inst_33096,state_atom,inst_33094);
var state_33108__$1 = state_33108;
var statearr_33115_33126 = state_33108__$1;
(statearr_33115_33126[(2)] = inst_33101);

(statearr_33115_33126[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33109 === (7))){
var inst_33103 = (state_33108[(2)]);
var state_33108__$1 = (function (){var statearr_33116 = state_33108;
(statearr_33116[(9)] = inst_33103);

return statearr_33116;
})();
var statearr_33117_33127 = state_33108__$1;
(statearr_33117_33127[(2)] = null);

(statearr_33117_33127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__30949__auto__))
;
return ((function (switch__30861__auto__,c__30949__auto__){
return (function() {
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30862__auto__ = null;
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30862__auto____0 = (function (){
var statearr_33118 = [null,null,null,null,null,null,null,null,null,null];
(statearr_33118[(0)] = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30862__auto__);

(statearr_33118[(1)] = (1));

return statearr_33118;
});
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30862__auto____1 = (function (state_33108){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_33108);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e33119){if((e33119 instanceof Object)){
var ex__30865__auto__ = e33119;
var statearr_33120_33128 = state_33108;
(statearr_33120_33128[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33108);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33119;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33129 = state_33108;
state_33108 = G__33129;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30862__auto__ = function(state_33108){
switch(arguments.length){
case 0:
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30862__auto____0.call(this);
case 1:
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30862__auto____1.call(this,state_33108);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30862__auto____0;
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30862__auto____1;
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto__))
})();
var state__30951__auto__ = (function (){var statearr_33121 = f__30950__auto__.call(null);
(statearr_33121[(6)] = c__30949__auto__);

return statearr_33121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto__))
);

return c__30949__auto__;
});
/**
 * Update state in response to `input-text` `on-change`, and put text on the `c-input` channel
 */
re_com.typeahead.input_text_on_change_BANG_ = (function re_com$typeahead$input_text_on_change_BANG_(state_atom,new_text){
var map__33131 = cljs.core.deref.call(null,state_atom);
var map__33131__$1 = ((((!((map__33131 == null)))?((((map__33131.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33131.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33131):map__33131);
var state = map__33131__$1;
var input_text = cljs.core.get.call(null,map__33131__$1,new cljs.core.Keyword(null,"input-text","input-text",-1336297114));
var c_input = cljs.core.get.call(null,map__33131__$1,new cljs.core.Keyword(null,"c-input","c-input",-1821004232));
if(cljs.core._EQ_.call(null,new_text,input_text)){
return state;
} else {
if(clojure.string.blank_QMARK_.call(null,new_text)){
} else {
cljs.core.async.put_BANG_.call(null,c_input,new_text);
}

return cljs.core.swap_BANG_.call(null,state_atom,((function (map__33131,map__33131__$1,state,input_text,c_input){
return (function (p1__33130_SHARP_){
var G__33133 = p1__33130_SHARP_;
var G__33133__$1 = cljs.core.assoc.call(null,G__33133,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),new_text,new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),false)
;
if(cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"input-text-changed","input-text-changed",-1906799535)))){
return re_com.typeahead.update_model.call(null,G__33133__$1,new_text);
} else {
return G__33133__$1;
}
});})(map__33131,map__33131__$1,state,input_text,c_input))
);
}
});
re_com.typeahead.input_text_on_key_down_BANG_ = (function re_com$typeahead$input_text_on_key_down_BANG_(state_atom,event){
var pred__33134 = cljs.core._EQ_;
var expr__33135 = event.which;
if(cljs.core.truth_(pred__33134.call(null,goog.events.KeyCodes.UP,expr__33135))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_prev);
} else {
if(cljs.core.truth_(pred__33134.call(null,goog.events.KeyCodes.DOWN,expr__33135))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_next);
} else {
if(cljs.core.truth_(pred__33134.call(null,goog.events.KeyCodes.ENTER,expr__33135))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.choose_suggestion_active);
} else {
if(cljs.core.truth_(pred__33134.call(null,goog.events.KeyCodes.ESC,expr__33135))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.reset_typeahead);
} else {
if(cljs.core.truth_(pred__33134.call(null,goog.events.KeyCodes.TAB,expr__33135))){
if(cljs.core.truth_(cljs.core.not_empty.call(null,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state_atom))))){
cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_next);

return event.preventDefault();
} else {
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.input_text_will_blur);
}
} else {
return true;
}
}
}
}
}
});
re_com.typeahead.typeahead_args_desc = new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"data-source","data-source",-658934676),new cljs.core.Keyword(null,"required","required",1807647006),true,new cljs.core.Keyword(null,"type","type",1174270348),"fn",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null)," supplies suggestion objects. This can either accept a single string argument (the search term), or a string and a callback. For the first case, the fn should return a collection of suggestion objects (which can be anything). For the second case, the fn should return ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"nil"], null),", and eventually result in a call to the callback with a collection of suggestion objects."], null)], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),null,new cljs.core.Keyword(null,"type","type",1174270348),"string -> nil",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":change-on-blur?"], null)," controls when it is called. It is passed a suggestion object."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),true,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"when true, invoke ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":on-change"], null)," when the user chooses a suggestion, otherwise invoke it on every change (navigating through suggestions with the mouse or keyboard, or if ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"rigid?"], null)," is also ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"false"], null),", invoke it on every character typed.)"], null)], null),cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"model","model",331153215),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),null,new cljs.core.Keyword(null,"type","type",1174270348),"object | atom",new cljs.core.Keyword(null,"description","description",-1428560544),"The initial value of the typeahead (should match the suggestion objects returned by ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),")."]),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"debounce-delay","debounce-delay",-608187982),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),(250),new cljs.core.Keyword(null,"type","type",1174270348),"integer",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.integer_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"After receiving input, the typeahead will wait this many milliseconds without receiving new input before calling ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),"."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"render-suggestion","render-suggestion",1472406503),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"render fn",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"override the rendering of the suggestion items by passing a fn that returns hiccup forms. The fn will receive two arguments: the search term, and the suggestion object."], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"suggestion -> string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"When a suggestion is chosen, the input-text value will be set to the result of calling this fn with the suggestion object."], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),true,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"If ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"false"], null)," the user will be allowed to choose arbitrary text input rather than a suggestion from ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),". In this case, a string will be supplied in lieu of a suggestion object."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"keyword",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.input_status_type_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"validation status. ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"nil/omitted"], null)," for normal status or one of: ",re_com.validate.input_status_types_list], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"when true, display an icon to match ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":status"], null)," (no icon for nil)"], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"displayed in status icon's tooltip"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"background text shown when empty"], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),"250px",new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"standard CSS width setting for this input"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"height","height",1025178622),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"standard CSS height setting for this input"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),"if true, the user can't interact (input anything)"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"CSS class names, space separated"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"CSS style map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.css_style_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"CSS styles to add or override"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"HTML attr map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.html_attr_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"HTML attributes, like ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":on-mouse-move"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"br","br",934104792)], null),"No ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":class"], null)," or ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":style"], null),"allowed"], null)], null)], null);
/**
 * typeahead reagent component
 */
re_com.typeahead.typeahead = (function re_com$typeahead$typeahead(var_args){
var args__29526__auto__ = [];
var len__29519__auto___33159 = arguments.length;
var i__29520__auto___33160 = (0);
while(true){
if((i__29520__auto___33160 < len__29519__auto___33159)){
args__29526__auto__.push((arguments[i__29520__auto___33160]));

var G__33161 = (i__29520__auto___33160 + (1));
i__29520__auto___33160 = G__33161;
continue;
} else {
}
break;
}

var argseq__29527__auto__ = ((((0) < args__29526__auto__.length))?(new cljs.core.IndexedSeq(args__29526__auto__.slice((0)),(0),null)):null);
return re_com.typeahead.typeahead.cljs$core$IFn$_invoke$arity$variadic(argseq__29527__auto__);
});

re_com.typeahead.typeahead.cljs$core$IFn$_invoke$arity$variadic = (function (p__33139){
var map__33140 = p__33139;
var map__33140__$1 = ((((!((map__33140 == null)))?((((map__33140.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33140.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33140):map__33140);
var args = map__33140__$1;
if(cljs.core.truth_(((!(goog.DEBUG))?true:re_com.validate.validate_args.call(null,re_com.validate.extract_arg_data.call(null,re_com.typeahead.typeahead_args_desc),args,"typeahead")))){
} else {
throw (new Error("Assert failed: (validate-args-macro typeahead-args-desc args \"typeahead\")"));
}

var map__33142 = re_com.typeahead.make_typeahead_state.call(null,args);
var map__33142__$1 = ((((!((map__33142 == null)))?((((map__33142.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33142.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33142):map__33142);
var state = map__33142__$1;
var c_search = cljs.core.get.call(null,map__33142__$1,new cljs.core.Keyword(null,"c-search","c-search",1832536180));
var c_input = cljs.core.get.call(null,map__33142__$1,new cljs.core.Keyword(null,"c-input","c-input",-1821004232));
var state_atom = reagent.core.atom.call(null,state);
var input_text_model = reagent.core.cursor.call(null,state_atom,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input-text","input-text",-1336297114)], null));
re_com.typeahead.search_data_source_loop_BANG_.call(null,state_atom,c_search);

return ((function (map__33142,map__33142__$1,state,c_search,c_input,state_atom,input_text_model,map__33140,map__33140__$1,args){
return (function() { 
var G__33162__delegate = function (p__33144){
var map__33145 = p__33144;
var map__33145__$1 = ((((!((map__33145 == null)))?((((map__33145.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33145.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33145):map__33145);
var args__$1 = map__33145__$1;
var disabled_QMARK_ = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var status_icon_QMARK_ = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612));
var height = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var status_tooltip = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007));
var model = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"model","model",331153215));
var _debounce_delay = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"_debounce-delay","_debounce-delay",-1476744225));
var _on_change = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"_on-change","_on-change",156649312));
var placeholder = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var render_suggestion = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"render-suggestion","render-suggestion",1472406503));
var _suggestion_to_string = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"_suggestion-to-string","_suggestion-to-string",795407399));
var width = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var data_source = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"data-source","data-source",-658934676));
var _rigid_QMARK_ = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"_rigid?","_rigid?",1424449294));
var style = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var _change_on_blur_QMARK_ = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"_change-on-blur?","_change-on-blur?",1219941073));
var status = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var class$ = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var _attr = cljs.core.get.call(null,map__33145__$1,new cljs.core.Keyword(null,"_attr","_attr",299438964));
if(cljs.core.truth_(((!(goog.DEBUG))?true:re_com.validate.validate_args.call(null,re_com.validate.extract_arg_data.call(null,re_com.typeahead.typeahead_args_desc),args__$1,"typeahead")))){
} else {
throw (new Error("Assert failed: (validate-args-macro typeahead-args-desc args \"typeahead\")"));
}

var map__33147 = cljs.core.deref.call(null,state_atom);
var map__33147__$1 = ((((!((map__33147 == null)))?((((map__33147.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33147.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33147):map__33147);
var state__$1 = map__33147__$1;
var suggestions = cljs.core.get.call(null,map__33147__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var waiting_QMARK_ = cljs.core.get.call(null,map__33147__$1,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215));
var suggestion_active_index = cljs.core.get.call(null,map__33147__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var external_model = cljs.core.get.call(null,map__33147__$1,new cljs.core.Keyword(null,"external-model","external-model",506095421));
var last_data_source = new cljs.core.Keyword(null,"data-source","data-source",-658934676).cljs$core$IFn$_invoke$arity$1(state__$1);
var latest_external_model = re_com.util.deref_or_value.call(null,model);
var width__$1 = (function (){var or__28348__auto__ = width;
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return "250px";
}
})();
if(cljs.core.not_EQ_.call(null,last_data_source,data_source)){
cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.change_data_source,data_source);
} else {
}

if(cljs.core.not_EQ_.call(null,latest_external_model,external_model)){
cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.external_model_changed,latest_external_model);
} else {
}

return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.v_box,new cljs.core.Keyword(null,"width","width",-384071477),width__$1,new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.misc.input_text,new cljs.core.Keyword(null,"model","model",331153215),input_text_model,new cljs.core.Keyword(null,"class","class",-2030961996),class$,new cljs.core.Keyword(null,"style","style",-496642736),style,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),disabled_QMARK_,new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612),status_icon_QMARK_,new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007),status_tooltip,new cljs.core.Keyword(null,"width","width",-384071477),width__$1,new cljs.core.Keyword(null,"height","height",1025178622),height,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),placeholder,new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.partial.call(null,re_com.typeahead.input_text_on_change_BANG_,state_atom),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),false,new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-key-down","on-key-down",-1374733765),cljs.core.partial.call(null,re_com.typeahead.input_text_on_key_down_BANG_,state_atom)], null)], null),(cljs.core.truth_((function (){var or__28348__auto__ = cljs.core.not_empty.call(null,suggestions);
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return waiting_QMARK_;
}
})())?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"position","position",-2011731912),"relative"], null),new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.v_box,new cljs.core.Keyword(null,"class","class",-2030961996),"rc-typeahead-suggestions-container",new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(waiting_QMARK_)?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"align","align",1964212802),new cljs.core.Keyword(null,"center","center",-748944368),new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.misc.throbber,new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"small","small",2133478704),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-typeahead-throbber"], null)], null):null),(function (){var iter__29156__auto__ = ((function (map__33147,map__33147__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33145,map__33145__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33142,map__33142__$1,state,c_search,c_input,state_atom,input_text_model,map__33140,map__33140__$1,args){
return (function re_com$typeahead$iter__33149(s__33150){
return (new cljs.core.LazySeq(null,((function (map__33147,map__33147__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33145,map__33145__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33142,map__33142__$1,state,c_search,c_input,state_atom,input_text_model,map__33140,map__33140__$1,args){
return (function (){
var s__33150__$1 = s__33150;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__33150__$1);
if(temp__4657__auto__){
var s__33150__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33150__$2)){
var c__29154__auto__ = cljs.core.chunk_first.call(null,s__33150__$2);
var size__29155__auto__ = cljs.core.count.call(null,c__29154__auto__);
var b__33152 = cljs.core.chunk_buffer.call(null,size__29155__auto__);
if((function (){var i__33151 = (0);
while(true){
if((i__33151 < size__29155__auto__)){
var vec__33153 = cljs.core._nth.call(null,c__29154__auto__,i__33151);
var i = cljs.core.nth.call(null,vec__33153,(0),null);
var s = cljs.core.nth.call(null,vec__33153,(1),null);
var selected_QMARK_ = cljs.core._EQ_.call(null,suggestion_active_index,i);
cljs.core.chunk_append.call(null,b__33152,cljs.core.with_meta(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"child","child",623967545),(cljs.core.truth_(render_suggestion)?render_suggestion.call(null,s):s),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-typeahead-suggestion",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((selected_QMARK_)?" active":null))].join(''),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),((function (i__33151,selected_QMARK_,vec__33153,i,s,c__29154__auto__,size__29155__auto__,b__33152,s__33150__$2,temp__4657__auto__,map__33147,map__33147__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33145,map__33145__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33142,map__33142__$1,state,c_search,c_input,state_atom,input_text_model,map__33140,map__33140__$1,args){
return (function (){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_by_index,i);
});})(i__33151,selected_QMARK_,vec__33153,i,s,c__29154__auto__,size__29155__auto__,b__33152,s__33150__$2,temp__4657__auto__,map__33147,map__33147__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33145,map__33145__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33142,map__33142__$1,state,c_search,c_input,state_atom,input_text_model,map__33140,map__33140__$1,args))
,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),((function (i__33151,selected_QMARK_,vec__33153,i,s,c__29154__auto__,size__29155__auto__,b__33152,s__33150__$2,temp__4657__auto__,map__33147,map__33147__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33145,map__33145__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33142,map__33142__$1,state,c_search,c_input,state_atom,input_text_model,map__33140,map__33140__$1,args){
return (function (p1__33137_SHARP_){
p1__33137_SHARP_.preventDefault();

return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.choose_suggestion_by_index,i);
});})(i__33151,selected_QMARK_,vec__33153,i,s,c__29154__auto__,size__29155__auto__,b__33152,s__33150__$2,temp__4657__auto__,map__33147,map__33147__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33145,map__33145__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33142,map__33142__$1,state,c_search,c_input,state_atom,input_text_model,map__33140,map__33140__$1,args))
], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),i], null)));

var G__33163 = (i__33151 + (1));
i__33151 = G__33163;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33152),re_com$typeahead$iter__33149.call(null,cljs.core.chunk_rest.call(null,s__33150__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33152),null);
}
} else {
var vec__33156 = cljs.core.first.call(null,s__33150__$2);
var i = cljs.core.nth.call(null,vec__33156,(0),null);
var s = cljs.core.nth.call(null,vec__33156,(1),null);
var selected_QMARK_ = cljs.core._EQ_.call(null,suggestion_active_index,i);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"child","child",623967545),(cljs.core.truth_(render_suggestion)?render_suggestion.call(null,s):s),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-typeahead-suggestion",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((selected_QMARK_)?" active":null))].join(''),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),((function (selected_QMARK_,vec__33156,i,s,s__33150__$2,temp__4657__auto__,map__33147,map__33147__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33145,map__33145__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33142,map__33142__$1,state,c_search,c_input,state_atom,input_text_model,map__33140,map__33140__$1,args){
return (function (){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_by_index,i);
});})(selected_QMARK_,vec__33156,i,s,s__33150__$2,temp__4657__auto__,map__33147,map__33147__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33145,map__33145__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33142,map__33142__$1,state,c_search,c_input,state_atom,input_text_model,map__33140,map__33140__$1,args))
,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),((function (selected_QMARK_,vec__33156,i,s,s__33150__$2,temp__4657__auto__,map__33147,map__33147__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33145,map__33145__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33142,map__33142__$1,state,c_search,c_input,state_atom,input_text_model,map__33140,map__33140__$1,args){
return (function (p1__33137_SHARP_){
p1__33137_SHARP_.preventDefault();

return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.choose_suggestion_by_index,i);
});})(selected_QMARK_,vec__33156,i,s,s__33150__$2,temp__4657__auto__,map__33147,map__33147__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33145,map__33145__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33142,map__33142__$1,state,c_search,c_input,state_atom,input_text_model,map__33140,map__33140__$1,args))
], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),i], null)),re_com$typeahead$iter__33149.call(null,cljs.core.rest.call(null,s__33150__$2)));
}
} else {
return null;
}
break;
}
});})(map__33147,map__33147__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33145,map__33145__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33142,map__33142__$1,state,c_search,c_input,state_atom,input_text_model,map__33140,map__33140__$1,args))
,null,null));
});})(map__33147,map__33147__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33145,map__33145__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33142,map__33142__$1,state,c_search,c_input,state_atom,input_text_model,map__33140,map__33140__$1,args))
;
return iter__29156__auto__.call(null,cljs.core.map.call(null,cljs.core.vector,cljs.core.range.call(null),suggestions));
})()], null)], null)], null):null)], null)], null);
};
var G__33162 = function (var_args){
var p__33144 = null;
if (arguments.length > 0) {
var G__33164__i = 0, G__33164__a = new Array(arguments.length -  0);
while (G__33164__i < G__33164__a.length) {G__33164__a[G__33164__i] = arguments[G__33164__i + 0]; ++G__33164__i;}
  p__33144 = new cljs.core.IndexedSeq(G__33164__a,0,null);
} 
return G__33162__delegate.call(this,p__33144);};
G__33162.cljs$lang$maxFixedArity = 0;
G__33162.cljs$lang$applyTo = (function (arglist__33165){
var p__33144 = cljs.core.seq(arglist__33165);
return G__33162__delegate(p__33144);
});
G__33162.cljs$core$IFn$_invoke$arity$variadic = G__33162__delegate;
return G__33162;
})()
;
;})(map__33142,map__33142__$1,state,c_search,c_input,state_atom,input_text_model,map__33140,map__33140__$1,args))
});

re_com.typeahead.typeahead.cljs$lang$maxFixedArity = (0);

re_com.typeahead.typeahead.cljs$lang$applyTo = (function (seq33138){
return re_com.typeahead.typeahead.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33138));
});

/**
 * Return a channel which will receive a value from the `in` channel only
 *   if no further value is received on the `in` channel in the next `ms` milliseconds.
 */
re_com.typeahead.debounce = (function re_com$typeahead$debounce(in$,ms){
var out = cljs.core.async.chan.call(null);
var c__30949__auto___33246 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___33246,out){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___33246,out){
return (function (state_33216){
var state_val_33217 = (state_33216[(1)]);
if((state_val_33217 === (7))){
var inst_33171 = (state_33216[(2)]);
var state_33216__$1 = state_33216;
var statearr_33218_33247 = state_33216__$1;
(statearr_33218_33247[(2)] = inst_33171);

(statearr_33218_33247[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33217 === (1))){
var inst_33166 = null;
var state_33216__$1 = (function (){var statearr_33219 = state_33216;
(statearr_33219[(7)] = inst_33166);

return statearr_33219;
})();
var statearr_33220_33248 = state_33216__$1;
(statearr_33220_33248[(2)] = null);

(statearr_33220_33248[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33217 === (4))){
var state_33216__$1 = state_33216;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33216__$1,(7),in$);
} else {
if((state_val_33217 === (15))){
var inst_33201 = (state_33216[(2)]);
var state_33216__$1 = (function (){var statearr_33221 = state_33216;
(statearr_33221[(8)] = inst_33201);

return statearr_33221;
})();
var statearr_33222_33249 = state_33216__$1;
(statearr_33222_33249[(2)] = null);

(statearr_33222_33249[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33217 === (13))){
var inst_33189 = (state_33216[(9)]);
var inst_33203 = cljs.core._EQ_.call(null,inst_33189,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_33216__$1 = state_33216;
if(inst_33203){
var statearr_33223_33250 = state_33216__$1;
(statearr_33223_33250[(1)] = (16));

} else {
var statearr_33224_33251 = state_33216__$1;
(statearr_33224_33251[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33217 === (6))){
var inst_33175 = (state_33216[(10)]);
var inst_33174 = (state_33216[(2)]);
var inst_33175__$1 = cljs.core.async.timeout.call(null,ms);
var inst_33183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33184 = [in$,inst_33175__$1];
var inst_33185 = (new cljs.core.PersistentVector(null,2,(5),inst_33183,inst_33184,null));
var state_33216__$1 = (function (){var statearr_33225 = state_33216;
(statearr_33225[(11)] = inst_33174);

(statearr_33225[(10)] = inst_33175__$1);

return statearr_33225;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_33216__$1,(8),inst_33185);
} else {
if((state_val_33217 === (17))){
var state_33216__$1 = state_33216;
var statearr_33226_33252 = state_33216__$1;
(statearr_33226_33252[(2)] = null);

(statearr_33226_33252[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33217 === (3))){
var inst_33214 = (state_33216[(2)]);
var state_33216__$1 = state_33216;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33216__$1,inst_33214);
} else {
if((state_val_33217 === (12))){
var inst_33174 = (state_33216[(11)]);
var state_33216__$1 = state_33216;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33216__$1,(15),out,inst_33174);
} else {
if((state_val_33217 === (2))){
var inst_33166 = (state_33216[(7)]);
var inst_33168 = (inst_33166 == null);
var state_33216__$1 = state_33216;
if(cljs.core.truth_(inst_33168)){
var statearr_33227_33253 = state_33216__$1;
(statearr_33227_33253[(1)] = (4));

} else {
var statearr_33228_33254 = state_33216__$1;
(statearr_33228_33254[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33217 === (11))){
var inst_33211 = (state_33216[(2)]);
var inst_33166 = inst_33211;
var state_33216__$1 = (function (){var statearr_33229 = state_33216;
(statearr_33229[(7)] = inst_33166);

return statearr_33229;
})();
var statearr_33230_33255 = state_33216__$1;
(statearr_33230_33255[(2)] = null);

(statearr_33230_33255[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33217 === (9))){
var inst_33187 = (state_33216[(12)]);
var inst_33195 = cljs.core.nth.call(null,inst_33187,(0),null);
var inst_33196 = cljs.core.nth.call(null,inst_33187,(1),null);
var state_33216__$1 = (function (){var statearr_33231 = state_33216;
(statearr_33231[(13)] = inst_33196);

return statearr_33231;
})();
var statearr_33232_33256 = state_33216__$1;
(statearr_33232_33256[(2)] = inst_33195);

(statearr_33232_33256[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33217 === (5))){
var inst_33166 = (state_33216[(7)]);
var state_33216__$1 = state_33216;
var statearr_33233_33257 = state_33216__$1;
(statearr_33233_33257[(2)] = inst_33166);

(statearr_33233_33257[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33217 === (14))){
var inst_33209 = (state_33216[(2)]);
var state_33216__$1 = state_33216;
var statearr_33234_33258 = state_33216__$1;
(statearr_33234_33258[(2)] = inst_33209);

(statearr_33234_33258[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33217 === (16))){
var inst_33188 = (state_33216[(14)]);
var state_33216__$1 = state_33216;
var statearr_33235_33259 = state_33216__$1;
(statearr_33235_33259[(2)] = inst_33188);

(statearr_33235_33259[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33217 === (10))){
var inst_33189 = (state_33216[(9)]);
var inst_33175 = (state_33216[(10)]);
var inst_33198 = cljs.core._EQ_.call(null,inst_33189,inst_33175);
var state_33216__$1 = state_33216;
if(inst_33198){
var statearr_33236_33260 = state_33216__$1;
(statearr_33236_33260[(1)] = (12));

} else {
var statearr_33237_33261 = state_33216__$1;
(statearr_33237_33261[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33217 === (18))){
var inst_33207 = (state_33216[(2)]);
var state_33216__$1 = state_33216;
var statearr_33238_33262 = state_33216__$1;
(statearr_33238_33262[(2)] = inst_33207);

(statearr_33238_33262[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33217 === (8))){
var inst_33189 = (state_33216[(9)]);
var inst_33187 = (state_33216[(12)]);
var inst_33187__$1 = (state_33216[(2)]);
var inst_33188 = cljs.core.nth.call(null,inst_33187__$1,(0),null);
var inst_33189__$1 = cljs.core.nth.call(null,inst_33187__$1,(1),null);
var inst_33190 = cljs.core._EQ_.call(null,inst_33189__$1,in$);
var state_33216__$1 = (function (){var statearr_33239 = state_33216;
(statearr_33239[(9)] = inst_33189__$1);

(statearr_33239[(12)] = inst_33187__$1);

(statearr_33239[(14)] = inst_33188);

return statearr_33239;
})();
if(inst_33190){
var statearr_33240_33263 = state_33216__$1;
(statearr_33240_33263[(1)] = (9));

} else {
var statearr_33241_33264 = state_33216__$1;
(statearr_33241_33264[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto___33246,out))
;
return ((function (switch__30861__auto__,c__30949__auto___33246,out){
return (function() {
var re_com$typeahead$debounce_$_state_machine__30862__auto__ = null;
var re_com$typeahead$debounce_$_state_machine__30862__auto____0 = (function (){
var statearr_33242 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33242[(0)] = re_com$typeahead$debounce_$_state_machine__30862__auto__);

(statearr_33242[(1)] = (1));

return statearr_33242;
});
var re_com$typeahead$debounce_$_state_machine__30862__auto____1 = (function (state_33216){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_33216);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e33243){if((e33243 instanceof Object)){
var ex__30865__auto__ = e33243;
var statearr_33244_33265 = state_33216;
(statearr_33244_33265[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33216);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33243;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33266 = state_33216;
state_33216 = G__33266;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
re_com$typeahead$debounce_$_state_machine__30862__auto__ = function(state_33216){
switch(arguments.length){
case 0:
return re_com$typeahead$debounce_$_state_machine__30862__auto____0.call(this);
case 1:
return re_com$typeahead$debounce_$_state_machine__30862__auto____1.call(this,state_33216);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
re_com$typeahead$debounce_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = re_com$typeahead$debounce_$_state_machine__30862__auto____0;
re_com$typeahead$debounce_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = re_com$typeahead$debounce_$_state_machine__30862__auto____1;
return re_com$typeahead$debounce_$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___33246,out))
})();
var state__30951__auto__ = (function (){var statearr_33245 = f__30950__auto__.call(null);
(statearr_33245[(6)] = c__30949__auto___33246);

return statearr_33245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___33246,out))
);


return out;
});

//# sourceMappingURL=typeahead.js.map?rel=1516869010702
