// Compiled by ClojureScript 1.9.946 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__28348__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__28348__auto__){
return or__28348__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__28348__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
var or__28348__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__28348__auto____$1)){
return or__28348__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__33635_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__33635_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__33636 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__33637 = null;
var count__33638 = (0);
var i__33639 = (0);
while(true){
if((i__33639 < count__33638)){
var n = cljs.core._nth.call(null,chunk__33637,i__33639);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__33640 = seq__33636;
var G__33641 = chunk__33637;
var G__33642 = count__33638;
var G__33643 = (i__33639 + (1));
seq__33636 = G__33640;
chunk__33637 = G__33641;
count__33638 = G__33642;
i__33639 = G__33643;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__33636);
if(temp__4657__auto__){
var seq__33636__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33636__$1)){
var c__29187__auto__ = cljs.core.chunk_first.call(null,seq__33636__$1);
var G__33644 = cljs.core.chunk_rest.call(null,seq__33636__$1);
var G__33645 = c__29187__auto__;
var G__33646 = cljs.core.count.call(null,c__29187__auto__);
var G__33647 = (0);
seq__33636 = G__33644;
chunk__33637 = G__33645;
count__33638 = G__33646;
i__33639 = G__33647;
continue;
} else {
var n = cljs.core.first.call(null,seq__33636__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__33648 = cljs.core.next.call(null,seq__33636__$1);
var G__33649 = null;
var G__33650 = (0);
var G__33651 = (0);
seq__33636 = G__33648;
chunk__33637 = G__33649;
count__33638 = G__33650;
i__33639 = G__33651;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.in_upper_level_QMARK_ = (function figwheel$client$file_reloading$in_upper_level_QMARK_(topo_state,current_depth,dep){
return cljs.core.some.call(null,(function (p__33652){
var vec__33653 = p__33652;
var _ = cljs.core.nth.call(null,vec__33653,(0),null);
var v = cljs.core.nth.call(null,vec__33653,(1),null);
var and__28336__auto__ = v;
if(cljs.core.truth_(and__28336__auto__)){
return v.call(null,dep);
} else {
return and__28336__auto__;
}
}),cljs.core.filter.call(null,(function (p__33656){
var vec__33657 = p__33656;
var k = cljs.core.nth.call(null,vec__33657,(0),null);
var v = cljs.core.nth.call(null,vec__33657,(1),null);
return (k > current_depth);
}),topo_state));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__33669_33677 = cljs.core.seq.call(null,deps);
var chunk__33670_33678 = null;
var count__33671_33679 = (0);
var i__33672_33680 = (0);
while(true){
if((i__33672_33680 < count__33671_33679)){
var dep_33681 = cljs.core._nth.call(null,chunk__33670_33678,i__33672_33680);
if(cljs.core.truth_((function (){var and__28336__auto__ = dep_33681;
if(cljs.core.truth_(and__28336__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_33681));
} else {
return and__28336__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_33681,(depth + (1)),state);
} else {
}

var G__33682 = seq__33669_33677;
var G__33683 = chunk__33670_33678;
var G__33684 = count__33671_33679;
var G__33685 = (i__33672_33680 + (1));
seq__33669_33677 = G__33682;
chunk__33670_33678 = G__33683;
count__33671_33679 = G__33684;
i__33672_33680 = G__33685;
continue;
} else {
var temp__4657__auto___33686 = cljs.core.seq.call(null,seq__33669_33677);
if(temp__4657__auto___33686){
var seq__33669_33687__$1 = temp__4657__auto___33686;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33669_33687__$1)){
var c__29187__auto___33688 = cljs.core.chunk_first.call(null,seq__33669_33687__$1);
var G__33689 = cljs.core.chunk_rest.call(null,seq__33669_33687__$1);
var G__33690 = c__29187__auto___33688;
var G__33691 = cljs.core.count.call(null,c__29187__auto___33688);
var G__33692 = (0);
seq__33669_33677 = G__33689;
chunk__33670_33678 = G__33690;
count__33671_33679 = G__33691;
i__33672_33680 = G__33692;
continue;
} else {
var dep_33693 = cljs.core.first.call(null,seq__33669_33687__$1);
if(cljs.core.truth_((function (){var and__28336__auto__ = dep_33693;
if(cljs.core.truth_(and__28336__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_33693));
} else {
return and__28336__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_33693,(depth + (1)),state);
} else {
}

var G__33694 = cljs.core.next.call(null,seq__33669_33687__$1);
var G__33695 = null;
var G__33696 = (0);
var G__33697 = (0);
seq__33669_33677 = G__33694;
chunk__33670_33678 = G__33695;
count__33671_33679 = G__33696;
i__33672_33680 = G__33697;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__33673){
var vec__33674 = p__33673;
var seq__33675 = cljs.core.seq.call(null,vec__33674);
var first__33676 = cljs.core.first.call(null,seq__33675);
var seq__33675__$1 = cljs.core.next.call(null,seq__33675);
var x = first__33676;
var xs = seq__33675__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__33674,seq__33675,first__33676,seq__33675__$1,x,xs,get_deps__$1){
return (function (p1__33660_SHARP_){
return clojure.set.difference.call(null,p1__33660_SHARP_,x);
});})(vec__33674,seq__33675,first__33676,seq__33675__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__33698 = cljs.core.seq.call(null,provides);
var chunk__33699 = null;
var count__33700 = (0);
var i__33701 = (0);
while(true){
if((i__33701 < count__33700)){
var prov = cljs.core._nth.call(null,chunk__33699,i__33701);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__33702_33710 = cljs.core.seq.call(null,requires);
var chunk__33703_33711 = null;
var count__33704_33712 = (0);
var i__33705_33713 = (0);
while(true){
if((i__33705_33713 < count__33704_33712)){
var req_33714 = cljs.core._nth.call(null,chunk__33703_33711,i__33705_33713);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33714,prov);

var G__33715 = seq__33702_33710;
var G__33716 = chunk__33703_33711;
var G__33717 = count__33704_33712;
var G__33718 = (i__33705_33713 + (1));
seq__33702_33710 = G__33715;
chunk__33703_33711 = G__33716;
count__33704_33712 = G__33717;
i__33705_33713 = G__33718;
continue;
} else {
var temp__4657__auto___33719 = cljs.core.seq.call(null,seq__33702_33710);
if(temp__4657__auto___33719){
var seq__33702_33720__$1 = temp__4657__auto___33719;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33702_33720__$1)){
var c__29187__auto___33721 = cljs.core.chunk_first.call(null,seq__33702_33720__$1);
var G__33722 = cljs.core.chunk_rest.call(null,seq__33702_33720__$1);
var G__33723 = c__29187__auto___33721;
var G__33724 = cljs.core.count.call(null,c__29187__auto___33721);
var G__33725 = (0);
seq__33702_33710 = G__33722;
chunk__33703_33711 = G__33723;
count__33704_33712 = G__33724;
i__33705_33713 = G__33725;
continue;
} else {
var req_33726 = cljs.core.first.call(null,seq__33702_33720__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33726,prov);

var G__33727 = cljs.core.next.call(null,seq__33702_33720__$1);
var G__33728 = null;
var G__33729 = (0);
var G__33730 = (0);
seq__33702_33710 = G__33727;
chunk__33703_33711 = G__33728;
count__33704_33712 = G__33729;
i__33705_33713 = G__33730;
continue;
}
} else {
}
}
break;
}

var G__33731 = seq__33698;
var G__33732 = chunk__33699;
var G__33733 = count__33700;
var G__33734 = (i__33701 + (1));
seq__33698 = G__33731;
chunk__33699 = G__33732;
count__33700 = G__33733;
i__33701 = G__33734;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__33698);
if(temp__4657__auto__){
var seq__33698__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33698__$1)){
var c__29187__auto__ = cljs.core.chunk_first.call(null,seq__33698__$1);
var G__33735 = cljs.core.chunk_rest.call(null,seq__33698__$1);
var G__33736 = c__29187__auto__;
var G__33737 = cljs.core.count.call(null,c__29187__auto__);
var G__33738 = (0);
seq__33698 = G__33735;
chunk__33699 = G__33736;
count__33700 = G__33737;
i__33701 = G__33738;
continue;
} else {
var prov = cljs.core.first.call(null,seq__33698__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__33706_33739 = cljs.core.seq.call(null,requires);
var chunk__33707_33740 = null;
var count__33708_33741 = (0);
var i__33709_33742 = (0);
while(true){
if((i__33709_33742 < count__33708_33741)){
var req_33743 = cljs.core._nth.call(null,chunk__33707_33740,i__33709_33742);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33743,prov);

var G__33744 = seq__33706_33739;
var G__33745 = chunk__33707_33740;
var G__33746 = count__33708_33741;
var G__33747 = (i__33709_33742 + (1));
seq__33706_33739 = G__33744;
chunk__33707_33740 = G__33745;
count__33708_33741 = G__33746;
i__33709_33742 = G__33747;
continue;
} else {
var temp__4657__auto___33748__$1 = cljs.core.seq.call(null,seq__33706_33739);
if(temp__4657__auto___33748__$1){
var seq__33706_33749__$1 = temp__4657__auto___33748__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33706_33749__$1)){
var c__29187__auto___33750 = cljs.core.chunk_first.call(null,seq__33706_33749__$1);
var G__33751 = cljs.core.chunk_rest.call(null,seq__33706_33749__$1);
var G__33752 = c__29187__auto___33750;
var G__33753 = cljs.core.count.call(null,c__29187__auto___33750);
var G__33754 = (0);
seq__33706_33739 = G__33751;
chunk__33707_33740 = G__33752;
count__33708_33741 = G__33753;
i__33709_33742 = G__33754;
continue;
} else {
var req_33755 = cljs.core.first.call(null,seq__33706_33749__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33755,prov);

var G__33756 = cljs.core.next.call(null,seq__33706_33749__$1);
var G__33757 = null;
var G__33758 = (0);
var G__33759 = (0);
seq__33706_33739 = G__33756;
chunk__33707_33740 = G__33757;
count__33708_33741 = G__33758;
i__33709_33742 = G__33759;
continue;
}
} else {
}
}
break;
}

var G__33760 = cljs.core.next.call(null,seq__33698__$1);
var G__33761 = null;
var G__33762 = (0);
var G__33763 = (0);
seq__33698 = G__33760;
chunk__33699 = G__33761;
count__33700 = G__33762;
i__33701 = G__33763;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__33764_33768 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__33765_33769 = null;
var count__33766_33770 = (0);
var i__33767_33771 = (0);
while(true){
if((i__33767_33771 < count__33766_33770)){
var ns_33772 = cljs.core._nth.call(null,chunk__33765_33769,i__33767_33771);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_33772);

var G__33773 = seq__33764_33768;
var G__33774 = chunk__33765_33769;
var G__33775 = count__33766_33770;
var G__33776 = (i__33767_33771 + (1));
seq__33764_33768 = G__33773;
chunk__33765_33769 = G__33774;
count__33766_33770 = G__33775;
i__33767_33771 = G__33776;
continue;
} else {
var temp__4657__auto___33777 = cljs.core.seq.call(null,seq__33764_33768);
if(temp__4657__auto___33777){
var seq__33764_33778__$1 = temp__4657__auto___33777;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33764_33778__$1)){
var c__29187__auto___33779 = cljs.core.chunk_first.call(null,seq__33764_33778__$1);
var G__33780 = cljs.core.chunk_rest.call(null,seq__33764_33778__$1);
var G__33781 = c__29187__auto___33779;
var G__33782 = cljs.core.count.call(null,c__29187__auto___33779);
var G__33783 = (0);
seq__33764_33768 = G__33780;
chunk__33765_33769 = G__33781;
count__33766_33770 = G__33782;
i__33767_33771 = G__33783;
continue;
} else {
var ns_33784 = cljs.core.first.call(null,seq__33764_33778__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_33784);

var G__33785 = cljs.core.next.call(null,seq__33764_33778__$1);
var G__33786 = null;
var G__33787 = (0);
var G__33788 = (0);
seq__33764_33768 = G__33785;
chunk__33765_33769 = G__33786;
count__33766_33770 = G__33787;
i__33767_33771 = G__33788;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__28348__auto__ = goog.require__;
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__33789__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__33789 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__33790__i = 0, G__33790__a = new Array(arguments.length -  0);
while (G__33790__i < G__33790__a.length) {G__33790__a[G__33790__i] = arguments[G__33790__i + 0]; ++G__33790__i;}
  args = new cljs.core.IndexedSeq(G__33790__a,0,null);
} 
return G__33789__delegate.call(this,args);};
G__33789.cljs$lang$maxFixedArity = 0;
G__33789.cljs$lang$applyTo = (function (arglist__33791){
var args = cljs.core.seq(arglist__33791);
return G__33789__delegate(args);
});
G__33789.cljs$core$IFn$_invoke$arity$variadic = G__33789__delegate;
return G__33789;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = ((typeof goog.net.jsloader.safeLoad !== 'undefined')?(function (p1__33792_SHARP_,p2__33793_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33792_SHARP_)].join('')),p2__33793_SHARP_);
}):((typeof goog.net.jsloader.load !== 'undefined')?(function (p1__33794_SHARP_,p2__33795_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33794_SHARP_)].join(''),p2__33795_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__33796 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__33796.addCallback(((function (G__33796){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__33796))
);

G__33796.addErrback(((function (G__33796){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__33796))
);

return G__33796;
});
figwheel.client.file_reloading.write_script_tag_import = figwheel.client.file_reloading.reload_file_in_html_env;
goog.exportSymbol('figwheel.client.file_reloading.write_script_tag_import', figwheel.client.file_reloading.write_script_tag_import);
figwheel.client.file_reloading.worker_import_script = (function figwheel$client$file_reloading$worker_import_script(request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e33797){if((e33797 instanceof Error)){
var e = e33797;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e33797;

}
}})());
});
goog.exportSymbol('figwheel.client.file_reloading.worker_import_script', figwheel.client.file_reloading.worker_import_script);
figwheel.client.file_reloading.create_node_script_import_fn = (function figwheel$client$file_reloading$create_node_script_import_fn(){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e33798){if((e33798 instanceof Error)){
var e = e33798;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e33798;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path))
});
goog.exportSymbol('figwheel.client.file_reloading.create_node_script_import_fn', figwheel.client.file_reloading.create_node_script_import_fn);
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__33799 = cljs.core._EQ_;
var expr__33800 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__33799.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__33800))){
return figwheel.client.file_reloading.create_node_script_import_fn.call(null);
} else {
if(cljs.core.truth_(pred__33799.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__33800))){
return figwheel.client.file_reloading.write_script_tag_import;
} else {
if(cljs.core.truth_(pred__33799.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__33800))){
return figwheel.client.file_reloading.worker_import_script;
} else {
return ((function (pred__33799,expr__33800){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__33799,expr__33800))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__33802,callback){
var map__33803 = p__33802;
var map__33803__$1 = ((((!((map__33803 == null)))?((((map__33803.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33803.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33803):map__33803);
var file_msg = map__33803__$1;
var request_url = cljs.core.get.call(null,map__33803__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return (function (){var or__28348__auto__ = goog.object.get(goog.global,"FIGWHEEL_IMPORT_SCRIPT");
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return figwheel.client.file_reloading.reload_file_STAR_;
}
})().call(null,request_url,((function (map__33803,map__33803__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__33803,map__33803__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__30949__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto__){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto__){
return (function (state_33843){
var state_val_33844 = (state_33843[(1)]);
if((state_val_33844 === (7))){
var inst_33839 = (state_33843[(2)]);
var state_33843__$1 = state_33843;
var statearr_33845_33872 = state_33843__$1;
(statearr_33845_33872[(2)] = inst_33839);

(statearr_33845_33872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33844 === (1))){
var state_33843__$1 = state_33843;
var statearr_33846_33873 = state_33843__$1;
(statearr_33846_33873[(2)] = null);

(statearr_33846_33873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33844 === (4))){
var inst_33807 = (state_33843[(7)]);
var inst_33807__$1 = (state_33843[(2)]);
var state_33843__$1 = (function (){var statearr_33847 = state_33843;
(statearr_33847[(7)] = inst_33807__$1);

return statearr_33847;
})();
if(cljs.core.truth_(inst_33807__$1)){
var statearr_33848_33874 = state_33843__$1;
(statearr_33848_33874[(1)] = (5));

} else {
var statearr_33849_33875 = state_33843__$1;
(statearr_33849_33875[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33844 === (15))){
var inst_33824 = (state_33843[(8)]);
var inst_33821 = (state_33843[(9)]);
var inst_33826 = inst_33824.call(null,inst_33821);
var state_33843__$1 = state_33843;
var statearr_33850_33876 = state_33843__$1;
(statearr_33850_33876[(2)] = inst_33826);

(statearr_33850_33876[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33844 === (13))){
var inst_33833 = (state_33843[(2)]);
var state_33843__$1 = state_33843;
var statearr_33851_33877 = state_33843__$1;
(statearr_33851_33877[(2)] = inst_33833);

(statearr_33851_33877[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33844 === (6))){
var state_33843__$1 = state_33843;
var statearr_33852_33878 = state_33843__$1;
(statearr_33852_33878[(2)] = null);

(statearr_33852_33878[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33844 === (17))){
var inst_33830 = (state_33843[(2)]);
var state_33843__$1 = state_33843;
var statearr_33853_33879 = state_33843__$1;
(statearr_33853_33879[(2)] = inst_33830);

(statearr_33853_33879[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33844 === (3))){
var inst_33841 = (state_33843[(2)]);
var state_33843__$1 = state_33843;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33843__$1,inst_33841);
} else {
if((state_val_33844 === (12))){
var state_33843__$1 = state_33843;
var statearr_33854_33880 = state_33843__$1;
(statearr_33854_33880[(2)] = null);

(statearr_33854_33880[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33844 === (2))){
var state_33843__$1 = state_33843;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33843__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_33844 === (11))){
var inst_33812 = (state_33843[(10)]);
var inst_33819 = figwheel.client.file_reloading.blocking_load.call(null,inst_33812);
var state_33843__$1 = state_33843;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33843__$1,(14),inst_33819);
} else {
if((state_val_33844 === (9))){
var inst_33812 = (state_33843[(10)]);
var state_33843__$1 = state_33843;
if(cljs.core.truth_(inst_33812)){
var statearr_33855_33881 = state_33843__$1;
(statearr_33855_33881[(1)] = (11));

} else {
var statearr_33856_33882 = state_33843__$1;
(statearr_33856_33882[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33844 === (5))){
var inst_33807 = (state_33843[(7)]);
var inst_33813 = (state_33843[(11)]);
var inst_33812 = cljs.core.nth.call(null,inst_33807,(0),null);
var inst_33813__$1 = cljs.core.nth.call(null,inst_33807,(1),null);
var state_33843__$1 = (function (){var statearr_33857 = state_33843;
(statearr_33857[(11)] = inst_33813__$1);

(statearr_33857[(10)] = inst_33812);

return statearr_33857;
})();
if(cljs.core.truth_(inst_33813__$1)){
var statearr_33858_33883 = state_33843__$1;
(statearr_33858_33883[(1)] = (8));

} else {
var statearr_33859_33884 = state_33843__$1;
(statearr_33859_33884[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33844 === (14))){
var inst_33824 = (state_33843[(8)]);
var inst_33812 = (state_33843[(10)]);
var inst_33821 = (state_33843[(2)]);
var inst_33822 = console.log("Loading!",inst_33812);
var inst_33823 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_33824__$1 = cljs.core.get.call(null,inst_33823,inst_33812);
var state_33843__$1 = (function (){var statearr_33860 = state_33843;
(statearr_33860[(8)] = inst_33824__$1);

(statearr_33860[(9)] = inst_33821);

(statearr_33860[(12)] = inst_33822);

return statearr_33860;
})();
if(cljs.core.truth_(inst_33824__$1)){
var statearr_33861_33885 = state_33843__$1;
(statearr_33861_33885[(1)] = (15));

} else {
var statearr_33862_33886 = state_33843__$1;
(statearr_33862_33886[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33844 === (16))){
var inst_33821 = (state_33843[(9)]);
var inst_33828 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_33821);
var state_33843__$1 = state_33843;
var statearr_33863_33887 = state_33843__$1;
(statearr_33863_33887[(2)] = inst_33828);

(statearr_33863_33887[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33844 === (10))){
var inst_33835 = (state_33843[(2)]);
var state_33843__$1 = (function (){var statearr_33864 = state_33843;
(statearr_33864[(13)] = inst_33835);

return statearr_33864;
})();
var statearr_33865_33888 = state_33843__$1;
(statearr_33865_33888[(2)] = null);

(statearr_33865_33888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33844 === (8))){
var inst_33813 = (state_33843[(11)]);
var inst_33815 = console.log("Evaling!",inst_33813);
var inst_33816 = eval(inst_33813);
var state_33843__$1 = (function (){var statearr_33866 = state_33843;
(statearr_33866[(14)] = inst_33815);

return statearr_33866;
})();
var statearr_33867_33889 = state_33843__$1;
(statearr_33867_33889[(2)] = inst_33816);

(statearr_33867_33889[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto__))
;
return ((function (switch__30861__auto__,c__30949__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__30862__auto__ = null;
var figwheel$client$file_reloading$state_machine__30862__auto____0 = (function (){
var statearr_33868 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33868[(0)] = figwheel$client$file_reloading$state_machine__30862__auto__);

(statearr_33868[(1)] = (1));

return statearr_33868;
});
var figwheel$client$file_reloading$state_machine__30862__auto____1 = (function (state_33843){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_33843);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e33869){if((e33869 instanceof Object)){
var ex__30865__auto__ = e33869;
var statearr_33870_33890 = state_33843;
(statearr_33870_33890[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33843);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33869;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33891 = state_33843;
state_33843 = G__33891;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__30862__auto__ = function(state_33843){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__30862__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__30862__auto____1.call(this,state_33843);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__30862__auto____0;
figwheel$client$file_reloading$state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__30862__auto____1;
return figwheel$client$file_reloading$state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto__))
})();
var state__30951__auto__ = (function (){var statearr_33871 = f__30950__auto__.call(null);
(statearr_33871[(6)] = c__30949__auto__);

return statearr_33871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto__))
);

return c__30949__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(var_args){
var G__33893 = arguments.length;
switch (G__33893) {
case 1:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1 = (function (url){
return figwheel.client.file_reloading.queued_file_reload.call(null,url,null);
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2 = (function (url,opt_source_text){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,opt_source_text], null));
});

figwheel.client.file_reloading.queued_file_reload.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__33895,callback){
var map__33896 = p__33895;
var map__33896__$1 = ((((!((map__33896 == null)))?((((map__33896.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33896.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33896):map__33896);
var file_msg = map__33896__$1;
var namespace = cljs.core.get.call(null,map__33896__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__33896,map__33896__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__33896,map__33896__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__33898){
var map__33899 = p__33898;
var map__33899__$1 = ((((!((map__33899 == null)))?((((map__33899.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33899.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33899):map__33899);
var file_msg = map__33899__$1;
var namespace = cljs.core.get.call(null,map__33899__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__33901){
var map__33902 = p__33901;
var map__33902__$1 = ((((!((map__33902 == null)))?((((map__33902.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33902.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33902):map__33902);
var file_msg = map__33902__$1;
var namespace = cljs.core.get.call(null,map__33902__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__28336__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__28336__auto__){
var or__28348__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
var or__28348__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28348__auto____$1)){
return or__28348__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__28336__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__33904,callback){
var map__33905 = p__33904;
var map__33905__$1 = ((((!((map__33905 == null)))?((((map__33905.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33905.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33905):map__33905);
var file_msg = map__33905__$1;
var request_url = cljs.core.get.call(null,map__33905__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__33905__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__30949__auto___33955 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto___33955,out){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto___33955,out){
return (function (state_33940){
var state_val_33941 = (state_33940[(1)]);
if((state_val_33941 === (1))){
var inst_33914 = cljs.core.seq.call(null,files);
var inst_33915 = cljs.core.first.call(null,inst_33914);
var inst_33916 = cljs.core.next.call(null,inst_33914);
var inst_33917 = files;
var state_33940__$1 = (function (){var statearr_33942 = state_33940;
(statearr_33942[(7)] = inst_33917);

(statearr_33942[(8)] = inst_33916);

(statearr_33942[(9)] = inst_33915);

return statearr_33942;
})();
var statearr_33943_33956 = state_33940__$1;
(statearr_33943_33956[(2)] = null);

(statearr_33943_33956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33941 === (2))){
var inst_33923 = (state_33940[(10)]);
var inst_33917 = (state_33940[(7)]);
var inst_33922 = cljs.core.seq.call(null,inst_33917);
var inst_33923__$1 = cljs.core.first.call(null,inst_33922);
var inst_33924 = cljs.core.next.call(null,inst_33922);
var inst_33925 = (inst_33923__$1 == null);
var inst_33926 = cljs.core.not.call(null,inst_33925);
var state_33940__$1 = (function (){var statearr_33944 = state_33940;
(statearr_33944[(11)] = inst_33924);

(statearr_33944[(10)] = inst_33923__$1);

return statearr_33944;
})();
if(inst_33926){
var statearr_33945_33957 = state_33940__$1;
(statearr_33945_33957[(1)] = (4));

} else {
var statearr_33946_33958 = state_33940__$1;
(statearr_33946_33958[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33941 === (3))){
var inst_33938 = (state_33940[(2)]);
var state_33940__$1 = state_33940;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33940__$1,inst_33938);
} else {
if((state_val_33941 === (4))){
var inst_33923 = (state_33940[(10)]);
var inst_33928 = figwheel.client.file_reloading.reload_js_file.call(null,inst_33923);
var state_33940__$1 = state_33940;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33940__$1,(7),inst_33928);
} else {
if((state_val_33941 === (5))){
var inst_33934 = cljs.core.async.close_BANG_.call(null,out);
var state_33940__$1 = state_33940;
var statearr_33947_33959 = state_33940__$1;
(statearr_33947_33959[(2)] = inst_33934);

(statearr_33947_33959[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33941 === (6))){
var inst_33936 = (state_33940[(2)]);
var state_33940__$1 = state_33940;
var statearr_33948_33960 = state_33940__$1;
(statearr_33948_33960[(2)] = inst_33936);

(statearr_33948_33960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33941 === (7))){
var inst_33924 = (state_33940[(11)]);
var inst_33930 = (state_33940[(2)]);
var inst_33931 = cljs.core.async.put_BANG_.call(null,out,inst_33930);
var inst_33917 = inst_33924;
var state_33940__$1 = (function (){var statearr_33949 = state_33940;
(statearr_33949[(12)] = inst_33931);

(statearr_33949[(7)] = inst_33917);

return statearr_33949;
})();
var statearr_33950_33961 = state_33940__$1;
(statearr_33950_33961[(2)] = null);

(statearr_33950_33961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__30949__auto___33955,out))
;
return ((function (switch__30861__auto__,c__30949__auto___33955,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30862__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30862__auto____0 = (function (){
var statearr_33951 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33951[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30862__auto__);

(statearr_33951[(1)] = (1));

return statearr_33951;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30862__auto____1 = (function (state_33940){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_33940);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e33952){if((e33952 instanceof Object)){
var ex__30865__auto__ = e33952;
var statearr_33953_33962 = state_33940;
(statearr_33953_33962[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33940);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33952;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33963 = state_33940;
state_33940 = G__33963;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30862__auto__ = function(state_33940){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30862__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30862__auto____1.call(this,state_33940);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30862__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30862__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto___33955,out))
})();
var state__30951__auto__ = (function (){var statearr_33954 = f__30950__auto__.call(null);
(statearr_33954[(6)] = c__30949__auto___33955);

return statearr_33954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto___33955,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__33964,opts){
var map__33965 = p__33964;
var map__33965__$1 = ((((!((map__33965 == null)))?((((map__33965.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33965.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33965):map__33965);
var eval_body = cljs.core.get.call(null,map__33965__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__33965__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__28336__auto__ = eval_body;
if(cljs.core.truth_(and__28336__auto__)){
return typeof eval_body === 'string';
} else {
return and__28336__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e33967){var e = e33967;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__33968_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__33968_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__33969){
var vec__33970 = p__33969;
var k = cljs.core.nth.call(null,vec__33970,(0),null);
var v = cljs.core.nth.call(null,vec__33970,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__33973){
var vec__33974 = p__33973;
var k = cljs.core.nth.call(null,vec__33974,(0),null);
var v = cljs.core.nth.call(null,vec__33974,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__33980,p__33981){
var map__33982 = p__33980;
var map__33982__$1 = ((((!((map__33982 == null)))?((((map__33982.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33982.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33982):map__33982);
var opts = map__33982__$1;
var before_jsload = cljs.core.get.call(null,map__33982__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__33982__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__33982__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__33983 = p__33981;
var map__33983__$1 = ((((!((map__33983 == null)))?((((map__33983.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33983.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33983):map__33983);
var msg = map__33983__$1;
var files = cljs.core.get.call(null,map__33983__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__33983__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__33983__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__30949__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__30950__auto__ = (function (){var switch__30861__auto__ = ((function (c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_34137){
var state_val_34138 = (state_34137[(1)]);
if((state_val_34138 === (7))){
var inst_34000 = (state_34137[(7)]);
var inst_33999 = (state_34137[(8)]);
var inst_33998 = (state_34137[(9)]);
var inst_33997 = (state_34137[(10)]);
var inst_34005 = cljs.core._nth.call(null,inst_33998,inst_34000);
var inst_34006 = figwheel.client.file_reloading.eval_body.call(null,inst_34005,opts);
var inst_34007 = (inst_34000 + (1));
var tmp34139 = inst_33999;
var tmp34140 = inst_33998;
var tmp34141 = inst_33997;
var inst_33997__$1 = tmp34141;
var inst_33998__$1 = tmp34140;
var inst_33999__$1 = tmp34139;
var inst_34000__$1 = inst_34007;
var state_34137__$1 = (function (){var statearr_34142 = state_34137;
(statearr_34142[(7)] = inst_34000__$1);

(statearr_34142[(8)] = inst_33999__$1);

(statearr_34142[(9)] = inst_33998__$1);

(statearr_34142[(11)] = inst_34006);

(statearr_34142[(10)] = inst_33997__$1);

return statearr_34142;
})();
var statearr_34143_34226 = state_34137__$1;
(statearr_34143_34226[(2)] = null);

(statearr_34143_34226[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (20))){
var inst_34040 = (state_34137[(12)]);
var inst_34048 = figwheel.client.file_reloading.sort_files.call(null,inst_34040);
var state_34137__$1 = state_34137;
var statearr_34144_34227 = state_34137__$1;
(statearr_34144_34227[(2)] = inst_34048);

(statearr_34144_34227[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (27))){
var state_34137__$1 = state_34137;
var statearr_34145_34228 = state_34137__$1;
(statearr_34145_34228[(2)] = null);

(statearr_34145_34228[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (1))){
var inst_33989 = (state_34137[(13)]);
var inst_33986 = before_jsload.call(null,files);
var inst_33987 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_33988 = (function (){return ((function (inst_33989,inst_33986,inst_33987,state_val_34138,c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__33977_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__33977_SHARP_);
});
;})(inst_33989,inst_33986,inst_33987,state_val_34138,c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33989__$1 = cljs.core.filter.call(null,inst_33988,files);
var inst_33990 = cljs.core.not_empty.call(null,inst_33989__$1);
var state_34137__$1 = (function (){var statearr_34146 = state_34137;
(statearr_34146[(13)] = inst_33989__$1);

(statearr_34146[(14)] = inst_33987);

(statearr_34146[(15)] = inst_33986);

return statearr_34146;
})();
if(cljs.core.truth_(inst_33990)){
var statearr_34147_34229 = state_34137__$1;
(statearr_34147_34229[(1)] = (2));

} else {
var statearr_34148_34230 = state_34137__$1;
(statearr_34148_34230[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (24))){
var state_34137__$1 = state_34137;
var statearr_34149_34231 = state_34137__$1;
(statearr_34149_34231[(2)] = null);

(statearr_34149_34231[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (39))){
var inst_34090 = (state_34137[(16)]);
var state_34137__$1 = state_34137;
var statearr_34150_34232 = state_34137__$1;
(statearr_34150_34232[(2)] = inst_34090);

(statearr_34150_34232[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (46))){
var inst_34132 = (state_34137[(2)]);
var state_34137__$1 = state_34137;
var statearr_34151_34233 = state_34137__$1;
(statearr_34151_34233[(2)] = inst_34132);

(statearr_34151_34233[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (4))){
var inst_34034 = (state_34137[(2)]);
var inst_34035 = cljs.core.List.EMPTY;
var inst_34036 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_34035);
var inst_34037 = (function (){return ((function (inst_34034,inst_34035,inst_34036,state_val_34138,c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__33978_SHARP_){
var and__28336__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__33978_SHARP_);
if(cljs.core.truth_(and__28336__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__33978_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__33978_SHARP_)));
} else {
return and__28336__auto__;
}
});
;})(inst_34034,inst_34035,inst_34036,state_val_34138,c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34038 = cljs.core.filter.call(null,inst_34037,files);
var inst_34039 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_34040 = cljs.core.concat.call(null,inst_34038,inst_34039);
var state_34137__$1 = (function (){var statearr_34152 = state_34137;
(statearr_34152[(17)] = inst_34036);

(statearr_34152[(18)] = inst_34034);

(statearr_34152[(12)] = inst_34040);

return statearr_34152;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_34153_34234 = state_34137__$1;
(statearr_34153_34234[(1)] = (16));

} else {
var statearr_34154_34235 = state_34137__$1;
(statearr_34154_34235[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (15))){
var inst_34024 = (state_34137[(2)]);
var state_34137__$1 = state_34137;
var statearr_34155_34236 = state_34137__$1;
(statearr_34155_34236[(2)] = inst_34024);

(statearr_34155_34236[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (21))){
var inst_34050 = (state_34137[(19)]);
var inst_34050__$1 = (state_34137[(2)]);
var inst_34051 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_34050__$1);
var state_34137__$1 = (function (){var statearr_34156 = state_34137;
(statearr_34156[(19)] = inst_34050__$1);

return statearr_34156;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34137__$1,(22),inst_34051);
} else {
if((state_val_34138 === (31))){
var inst_34135 = (state_34137[(2)]);
var state_34137__$1 = state_34137;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34137__$1,inst_34135);
} else {
if((state_val_34138 === (32))){
var inst_34090 = (state_34137[(16)]);
var inst_34095 = inst_34090.cljs$lang$protocol_mask$partition0$;
var inst_34096 = (inst_34095 & (64));
var inst_34097 = inst_34090.cljs$core$ISeq$;
var inst_34098 = (cljs.core.PROTOCOL_SENTINEL === inst_34097);
var inst_34099 = (inst_34096) || (inst_34098);
var state_34137__$1 = state_34137;
if(cljs.core.truth_(inst_34099)){
var statearr_34157_34237 = state_34137__$1;
(statearr_34157_34237[(1)] = (35));

} else {
var statearr_34158_34238 = state_34137__$1;
(statearr_34158_34238[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (40))){
var inst_34112 = (state_34137[(20)]);
var inst_34111 = (state_34137[(2)]);
var inst_34112__$1 = cljs.core.get.call(null,inst_34111,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_34113 = cljs.core.get.call(null,inst_34111,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_34114 = cljs.core.not_empty.call(null,inst_34112__$1);
var state_34137__$1 = (function (){var statearr_34159 = state_34137;
(statearr_34159[(21)] = inst_34113);

(statearr_34159[(20)] = inst_34112__$1);

return statearr_34159;
})();
if(cljs.core.truth_(inst_34114)){
var statearr_34160_34239 = state_34137__$1;
(statearr_34160_34239[(1)] = (41));

} else {
var statearr_34161_34240 = state_34137__$1;
(statearr_34161_34240[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (33))){
var state_34137__$1 = state_34137;
var statearr_34162_34241 = state_34137__$1;
(statearr_34162_34241[(2)] = false);

(statearr_34162_34241[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (13))){
var inst_34010 = (state_34137[(22)]);
var inst_34014 = cljs.core.chunk_first.call(null,inst_34010);
var inst_34015 = cljs.core.chunk_rest.call(null,inst_34010);
var inst_34016 = cljs.core.count.call(null,inst_34014);
var inst_33997 = inst_34015;
var inst_33998 = inst_34014;
var inst_33999 = inst_34016;
var inst_34000 = (0);
var state_34137__$1 = (function (){var statearr_34163 = state_34137;
(statearr_34163[(7)] = inst_34000);

(statearr_34163[(8)] = inst_33999);

(statearr_34163[(9)] = inst_33998);

(statearr_34163[(10)] = inst_33997);

return statearr_34163;
})();
var statearr_34164_34242 = state_34137__$1;
(statearr_34164_34242[(2)] = null);

(statearr_34164_34242[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (22))){
var inst_34054 = (state_34137[(23)]);
var inst_34050 = (state_34137[(19)]);
var inst_34058 = (state_34137[(24)]);
var inst_34053 = (state_34137[(25)]);
var inst_34053__$1 = (state_34137[(2)]);
var inst_34054__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_34053__$1);
var inst_34055 = (function (){var all_files = inst_34050;
var res_SINGLEQUOTE_ = inst_34053__$1;
var res = inst_34054__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_34054,inst_34050,inst_34058,inst_34053,inst_34053__$1,inst_34054__$1,state_val_34138,c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__33979_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__33979_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_34054,inst_34050,inst_34058,inst_34053,inst_34053__$1,inst_34054__$1,state_val_34138,c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34056 = cljs.core.filter.call(null,inst_34055,inst_34053__$1);
var inst_34057 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_34058__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_34057);
var inst_34059 = cljs.core.not_empty.call(null,inst_34058__$1);
var state_34137__$1 = (function (){var statearr_34165 = state_34137;
(statearr_34165[(23)] = inst_34054__$1);

(statearr_34165[(26)] = inst_34056);

(statearr_34165[(24)] = inst_34058__$1);

(statearr_34165[(25)] = inst_34053__$1);

return statearr_34165;
})();
if(cljs.core.truth_(inst_34059)){
var statearr_34166_34243 = state_34137__$1;
(statearr_34166_34243[(1)] = (23));

} else {
var statearr_34167_34244 = state_34137__$1;
(statearr_34167_34244[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (36))){
var state_34137__$1 = state_34137;
var statearr_34168_34245 = state_34137__$1;
(statearr_34168_34245[(2)] = false);

(statearr_34168_34245[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (41))){
var inst_34112 = (state_34137[(20)]);
var inst_34116 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_34117 = cljs.core.map.call(null,inst_34116,inst_34112);
var inst_34118 = cljs.core.pr_str.call(null,inst_34117);
var inst_34119 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34118)].join('');
var inst_34120 = figwheel.client.utils.log.call(null,inst_34119);
var state_34137__$1 = state_34137;
var statearr_34169_34246 = state_34137__$1;
(statearr_34169_34246[(2)] = inst_34120);

(statearr_34169_34246[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (43))){
var inst_34113 = (state_34137[(21)]);
var inst_34123 = (state_34137[(2)]);
var inst_34124 = cljs.core.not_empty.call(null,inst_34113);
var state_34137__$1 = (function (){var statearr_34170 = state_34137;
(statearr_34170[(27)] = inst_34123);

return statearr_34170;
})();
if(cljs.core.truth_(inst_34124)){
var statearr_34171_34247 = state_34137__$1;
(statearr_34171_34247[(1)] = (44));

} else {
var statearr_34172_34248 = state_34137__$1;
(statearr_34172_34248[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (29))){
var inst_34054 = (state_34137[(23)]);
var inst_34056 = (state_34137[(26)]);
var inst_34090 = (state_34137[(16)]);
var inst_34050 = (state_34137[(19)]);
var inst_34058 = (state_34137[(24)]);
var inst_34053 = (state_34137[(25)]);
var inst_34086 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_34089 = (function (){var all_files = inst_34050;
var res_SINGLEQUOTE_ = inst_34053;
var res = inst_34054;
var files_not_loaded = inst_34056;
var dependencies_that_loaded = inst_34058;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34054,inst_34056,inst_34090,inst_34050,inst_34058,inst_34053,inst_34086,state_val_34138,c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34088){
var map__34173 = p__34088;
var map__34173__$1 = ((((!((map__34173 == null)))?((((map__34173.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34173.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34173):map__34173);
var namespace = cljs.core.get.call(null,map__34173__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34054,inst_34056,inst_34090,inst_34050,inst_34058,inst_34053,inst_34086,state_val_34138,c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34090__$1 = cljs.core.group_by.call(null,inst_34089,inst_34056);
var inst_34092 = (inst_34090__$1 == null);
var inst_34093 = cljs.core.not.call(null,inst_34092);
var state_34137__$1 = (function (){var statearr_34175 = state_34137;
(statearr_34175[(28)] = inst_34086);

(statearr_34175[(16)] = inst_34090__$1);

return statearr_34175;
})();
if(inst_34093){
var statearr_34176_34249 = state_34137__$1;
(statearr_34176_34249[(1)] = (32));

} else {
var statearr_34177_34250 = state_34137__$1;
(statearr_34177_34250[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (44))){
var inst_34113 = (state_34137[(21)]);
var inst_34126 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_34113);
var inst_34127 = cljs.core.pr_str.call(null,inst_34126);
var inst_34128 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34127)].join('');
var inst_34129 = figwheel.client.utils.log.call(null,inst_34128);
var state_34137__$1 = state_34137;
var statearr_34178_34251 = state_34137__$1;
(statearr_34178_34251[(2)] = inst_34129);

(statearr_34178_34251[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (6))){
var inst_34031 = (state_34137[(2)]);
var state_34137__$1 = state_34137;
var statearr_34179_34252 = state_34137__$1;
(statearr_34179_34252[(2)] = inst_34031);

(statearr_34179_34252[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (28))){
var inst_34056 = (state_34137[(26)]);
var inst_34083 = (state_34137[(2)]);
var inst_34084 = cljs.core.not_empty.call(null,inst_34056);
var state_34137__$1 = (function (){var statearr_34180 = state_34137;
(statearr_34180[(29)] = inst_34083);

return statearr_34180;
})();
if(cljs.core.truth_(inst_34084)){
var statearr_34181_34253 = state_34137__$1;
(statearr_34181_34253[(1)] = (29));

} else {
var statearr_34182_34254 = state_34137__$1;
(statearr_34182_34254[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (25))){
var inst_34054 = (state_34137[(23)]);
var inst_34070 = (state_34137[(2)]);
var inst_34071 = cljs.core.not_empty.call(null,inst_34054);
var state_34137__$1 = (function (){var statearr_34183 = state_34137;
(statearr_34183[(30)] = inst_34070);

return statearr_34183;
})();
if(cljs.core.truth_(inst_34071)){
var statearr_34184_34255 = state_34137__$1;
(statearr_34184_34255[(1)] = (26));

} else {
var statearr_34185_34256 = state_34137__$1;
(statearr_34185_34256[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (34))){
var inst_34106 = (state_34137[(2)]);
var state_34137__$1 = state_34137;
if(cljs.core.truth_(inst_34106)){
var statearr_34186_34257 = state_34137__$1;
(statearr_34186_34257[(1)] = (38));

} else {
var statearr_34187_34258 = state_34137__$1;
(statearr_34187_34258[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (17))){
var state_34137__$1 = state_34137;
var statearr_34188_34259 = state_34137__$1;
(statearr_34188_34259[(2)] = recompile_dependents);

(statearr_34188_34259[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (3))){
var state_34137__$1 = state_34137;
var statearr_34189_34260 = state_34137__$1;
(statearr_34189_34260[(2)] = null);

(statearr_34189_34260[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (12))){
var inst_34027 = (state_34137[(2)]);
var state_34137__$1 = state_34137;
var statearr_34190_34261 = state_34137__$1;
(statearr_34190_34261[(2)] = inst_34027);

(statearr_34190_34261[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (2))){
var inst_33989 = (state_34137[(13)]);
var inst_33996 = cljs.core.seq.call(null,inst_33989);
var inst_33997 = inst_33996;
var inst_33998 = null;
var inst_33999 = (0);
var inst_34000 = (0);
var state_34137__$1 = (function (){var statearr_34191 = state_34137;
(statearr_34191[(7)] = inst_34000);

(statearr_34191[(8)] = inst_33999);

(statearr_34191[(9)] = inst_33998);

(statearr_34191[(10)] = inst_33997);

return statearr_34191;
})();
var statearr_34192_34262 = state_34137__$1;
(statearr_34192_34262[(2)] = null);

(statearr_34192_34262[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (23))){
var inst_34054 = (state_34137[(23)]);
var inst_34056 = (state_34137[(26)]);
var inst_34050 = (state_34137[(19)]);
var inst_34058 = (state_34137[(24)]);
var inst_34053 = (state_34137[(25)]);
var inst_34061 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_34063 = (function (){var all_files = inst_34050;
var res_SINGLEQUOTE_ = inst_34053;
var res = inst_34054;
var files_not_loaded = inst_34056;
var dependencies_that_loaded = inst_34058;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34054,inst_34056,inst_34050,inst_34058,inst_34053,inst_34061,state_val_34138,c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34062){
var map__34193 = p__34062;
var map__34193__$1 = ((((!((map__34193 == null)))?((((map__34193.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34193.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34193):map__34193);
var request_url = cljs.core.get.call(null,map__34193__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34054,inst_34056,inst_34050,inst_34058,inst_34053,inst_34061,state_val_34138,c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34064 = cljs.core.reverse.call(null,inst_34058);
var inst_34065 = cljs.core.map.call(null,inst_34063,inst_34064);
var inst_34066 = cljs.core.pr_str.call(null,inst_34065);
var inst_34067 = figwheel.client.utils.log.call(null,inst_34066);
var state_34137__$1 = (function (){var statearr_34195 = state_34137;
(statearr_34195[(31)] = inst_34061);

return statearr_34195;
})();
var statearr_34196_34263 = state_34137__$1;
(statearr_34196_34263[(2)] = inst_34067);

(statearr_34196_34263[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (35))){
var state_34137__$1 = state_34137;
var statearr_34197_34264 = state_34137__$1;
(statearr_34197_34264[(2)] = true);

(statearr_34197_34264[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (19))){
var inst_34040 = (state_34137[(12)]);
var inst_34046 = figwheel.client.file_reloading.expand_files.call(null,inst_34040);
var state_34137__$1 = state_34137;
var statearr_34198_34265 = state_34137__$1;
(statearr_34198_34265[(2)] = inst_34046);

(statearr_34198_34265[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (11))){
var state_34137__$1 = state_34137;
var statearr_34199_34266 = state_34137__$1;
(statearr_34199_34266[(2)] = null);

(statearr_34199_34266[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (9))){
var inst_34029 = (state_34137[(2)]);
var state_34137__$1 = state_34137;
var statearr_34200_34267 = state_34137__$1;
(statearr_34200_34267[(2)] = inst_34029);

(statearr_34200_34267[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (5))){
var inst_34000 = (state_34137[(7)]);
var inst_33999 = (state_34137[(8)]);
var inst_34002 = (inst_34000 < inst_33999);
var inst_34003 = inst_34002;
var state_34137__$1 = state_34137;
if(cljs.core.truth_(inst_34003)){
var statearr_34201_34268 = state_34137__$1;
(statearr_34201_34268[(1)] = (7));

} else {
var statearr_34202_34269 = state_34137__$1;
(statearr_34202_34269[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (14))){
var inst_34010 = (state_34137[(22)]);
var inst_34019 = cljs.core.first.call(null,inst_34010);
var inst_34020 = figwheel.client.file_reloading.eval_body.call(null,inst_34019,opts);
var inst_34021 = cljs.core.next.call(null,inst_34010);
var inst_33997 = inst_34021;
var inst_33998 = null;
var inst_33999 = (0);
var inst_34000 = (0);
var state_34137__$1 = (function (){var statearr_34203 = state_34137;
(statearr_34203[(7)] = inst_34000);

(statearr_34203[(32)] = inst_34020);

(statearr_34203[(8)] = inst_33999);

(statearr_34203[(9)] = inst_33998);

(statearr_34203[(10)] = inst_33997);

return statearr_34203;
})();
var statearr_34204_34270 = state_34137__$1;
(statearr_34204_34270[(2)] = null);

(statearr_34204_34270[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (45))){
var state_34137__$1 = state_34137;
var statearr_34205_34271 = state_34137__$1;
(statearr_34205_34271[(2)] = null);

(statearr_34205_34271[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (26))){
var inst_34054 = (state_34137[(23)]);
var inst_34056 = (state_34137[(26)]);
var inst_34050 = (state_34137[(19)]);
var inst_34058 = (state_34137[(24)]);
var inst_34053 = (state_34137[(25)]);
var inst_34073 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_34075 = (function (){var all_files = inst_34050;
var res_SINGLEQUOTE_ = inst_34053;
var res = inst_34054;
var files_not_loaded = inst_34056;
var dependencies_that_loaded = inst_34058;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34054,inst_34056,inst_34050,inst_34058,inst_34053,inst_34073,state_val_34138,c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34074){
var map__34206 = p__34074;
var map__34206__$1 = ((((!((map__34206 == null)))?((((map__34206.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34206.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34206):map__34206);
var namespace = cljs.core.get.call(null,map__34206__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__34206__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34054,inst_34056,inst_34050,inst_34058,inst_34053,inst_34073,state_val_34138,c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34076 = cljs.core.map.call(null,inst_34075,inst_34054);
var inst_34077 = cljs.core.pr_str.call(null,inst_34076);
var inst_34078 = figwheel.client.utils.log.call(null,inst_34077);
var inst_34079 = (function (){var all_files = inst_34050;
var res_SINGLEQUOTE_ = inst_34053;
var res = inst_34054;
var files_not_loaded = inst_34056;
var dependencies_that_loaded = inst_34058;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34054,inst_34056,inst_34050,inst_34058,inst_34053,inst_34073,inst_34075,inst_34076,inst_34077,inst_34078,state_val_34138,c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34054,inst_34056,inst_34050,inst_34058,inst_34053,inst_34073,inst_34075,inst_34076,inst_34077,inst_34078,state_val_34138,c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34080 = setTimeout(inst_34079,(10));
var state_34137__$1 = (function (){var statearr_34208 = state_34137;
(statearr_34208[(33)] = inst_34073);

(statearr_34208[(34)] = inst_34078);

return statearr_34208;
})();
var statearr_34209_34272 = state_34137__$1;
(statearr_34209_34272[(2)] = inst_34080);

(statearr_34209_34272[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (16))){
var state_34137__$1 = state_34137;
var statearr_34210_34273 = state_34137__$1;
(statearr_34210_34273[(2)] = reload_dependents);

(statearr_34210_34273[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (38))){
var inst_34090 = (state_34137[(16)]);
var inst_34108 = cljs.core.apply.call(null,cljs.core.hash_map,inst_34090);
var state_34137__$1 = state_34137;
var statearr_34211_34274 = state_34137__$1;
(statearr_34211_34274[(2)] = inst_34108);

(statearr_34211_34274[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (30))){
var state_34137__$1 = state_34137;
var statearr_34212_34275 = state_34137__$1;
(statearr_34212_34275[(2)] = null);

(statearr_34212_34275[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (10))){
var inst_34010 = (state_34137[(22)]);
var inst_34012 = cljs.core.chunked_seq_QMARK_.call(null,inst_34010);
var state_34137__$1 = state_34137;
if(inst_34012){
var statearr_34213_34276 = state_34137__$1;
(statearr_34213_34276[(1)] = (13));

} else {
var statearr_34214_34277 = state_34137__$1;
(statearr_34214_34277[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (18))){
var inst_34044 = (state_34137[(2)]);
var state_34137__$1 = state_34137;
if(cljs.core.truth_(inst_34044)){
var statearr_34215_34278 = state_34137__$1;
(statearr_34215_34278[(1)] = (19));

} else {
var statearr_34216_34279 = state_34137__$1;
(statearr_34216_34279[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (42))){
var state_34137__$1 = state_34137;
var statearr_34217_34280 = state_34137__$1;
(statearr_34217_34280[(2)] = null);

(statearr_34217_34280[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (37))){
var inst_34103 = (state_34137[(2)]);
var state_34137__$1 = state_34137;
var statearr_34218_34281 = state_34137__$1;
(statearr_34218_34281[(2)] = inst_34103);

(statearr_34218_34281[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34138 === (8))){
var inst_34010 = (state_34137[(22)]);
var inst_33997 = (state_34137[(10)]);
var inst_34010__$1 = cljs.core.seq.call(null,inst_33997);
var state_34137__$1 = (function (){var statearr_34219 = state_34137;
(statearr_34219[(22)] = inst_34010__$1);

return statearr_34219;
})();
if(inst_34010__$1){
var statearr_34220_34282 = state_34137__$1;
(statearr_34220_34282[(1)] = (10));

} else {
var statearr_34221_34283 = state_34137__$1;
(statearr_34221_34283[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__30861__auto__,c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30862__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30862__auto____0 = (function (){
var statearr_34222 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34222[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__30862__auto__);

(statearr_34222[(1)] = (1));

return statearr_34222;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30862__auto____1 = (function (state_34137){
while(true){
var ret_value__30863__auto__ = (function (){try{while(true){
var result__30864__auto__ = switch__30861__auto__.call(null,state_34137);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30864__auto__;
}
break;
}
}catch (e34223){if((e34223 instanceof Object)){
var ex__30865__auto__ = e34223;
var statearr_34224_34284 = state_34137;
(statearr_34224_34284[(5)] = ex__30865__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34137);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34223;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34285 = state_34137;
state_34137 = G__34285;
continue;
} else {
return ret_value__30863__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__30862__auto__ = function(state_34137){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30862__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30862__auto____1.call(this,state_34137);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__30862__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__30862__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__30862__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30862__auto__;
})()
;})(switch__30861__auto__,c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__30951__auto__ = (function (){var statearr_34225 = f__30950__auto__.call(null);
(statearr_34225[(6)] = c__30949__auto__);

return statearr_34225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30951__auto__);
});})(c__30949__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__30949__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__34288,link){
var map__34289 = p__34288;
var map__34289__$1 = ((((!((map__34289 == null)))?((((map__34289.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34289.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34289):map__34289);
var file = cljs.core.get.call(null,map__34289__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__34289,map__34289__$1,file){
return (function (p1__34286_SHARP_,p2__34287_SHARP_){
if(cljs.core._EQ_.call(null,p1__34286_SHARP_,p2__34287_SHARP_)){
return p1__34286_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__34289,map__34289__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__34292){
var map__34293 = p__34292;
var map__34293__$1 = ((((!((map__34293 == null)))?((((map__34293.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34293.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34293):map__34293);
var match_length = cljs.core.get.call(null,map__34293__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__34293__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__34291_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__34291_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__34295_SHARP_,p2__34296_SHARP_){
return cljs.core.assoc.call(null,p1__34295_SHARP_,cljs.core.get.call(null,p2__34296_SHARP_,key),p2__34296_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__4655__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4655__auto__)){
var link = temp__4655__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__4655__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__4655__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_34297 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_34297);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_34297);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__34298,p__34299){
var map__34300 = p__34298;
var map__34300__$1 = ((((!((map__34300 == null)))?((((map__34300.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34300.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34300):map__34300);
var on_cssload = cljs.core.get.call(null,map__34300__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__34301 = p__34299;
var map__34301__$1 = ((((!((map__34301 == null)))?((((map__34301.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34301.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34301):map__34301);
var files_msg = map__34301__$1;
var files = cljs.core.get.call(null,map__34301__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__4657__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__4657__auto__)){
var f_datas = temp__4657__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1516869013283
