// Compiled by ClojureScript 1.10.339 {}
goog.provide('rui.buttons.components');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('ccn.core');
goog.require('rui.icons');
/**
 * Returns a vector from a given `hashmap`
 * {:a 0 :b [1 2]} -> [:a 0 :b [1 2]]
 */
rui.buttons.components.map__GT_vec = (function rui$buttons$components$map__GT_vec(hashmap){
return cljs.core.apply.call(null,cljs.core.concat,cljs.core.vec.call(null,hashmap));
});
rui.buttons.components.compose_button_class = (function rui$buttons$components$compose_button_class(modifiers,twbs_modifiers,classes,enabled_internal_QMARK_,waiting_QMARK_){
return cljs.core.apply.call(null,ccn.core.css_class,cljs.core.concat.call(null,classes,cljs.core.conj.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ccn.core.twbs.call(null,"btn",twbs_modifiers)], null),ccn.core.bem.call(null,"btn",cljs.core.concat.call(null,modifiers,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(enabled_internal_QMARK_)?"enabled":"disabled"),(cljs.core.truth_(waiting_QMARK_)?"waiting":null)], null))))));
});
/**
 * Returns Bootstrap's button with a given `title` as content and `on-click` handler.
 * Kwargs:
 * :enabled? - a boolean that indicates enabled/disabled state of it
 * :attrs - a map of attributes to override element's attributes
 * :modifiers - BEM modifiers
 * :twbs-modifiers - Bootstrap modifiers
 * :children - a sequence of its children components
 * :waiting? - a boolean that shows a spinner when `true`
 * :classes - a sequence of CSS classes
 */
rui.buttons.components.button = (function rui$buttons$components$button(var_args){
var args__4534__auto__ = [];
var len__4531__auto___2374 = arguments.length;
var i__4532__auto___2375 = (0);
while(true){
if((i__4532__auto___2375 < len__4531__auto___2374)){
args__4534__auto__.push((arguments[i__4532__auto___2375]));

var G__2376 = (i__4532__auto___2375 + (1));
i__4532__auto___2375 = G__2376;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((2) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((2)),(0),null)):null);
return rui.buttons.components.button.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4535__auto__);
});

rui.buttons.components.button.cljs$core$IFn$_invoke$arity$variadic = (function (title,on_click,p__2371){
var map__2372 = p__2371;
var map__2372__$1 = ((((!((map__2372 == null)))?(((((map__2372.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2372.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2372):map__2372);
var enabled_QMARK_ = cljs.core.get.call(null,map__2372__$1,new cljs.core.Keyword(null,"enabled?","enabled?",-1376075057),true);
var attrs = cljs.core.get.call(null,map__2372__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var modifiers = cljs.core.get.call(null,map__2372__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var waiting_QMARK_ = cljs.core.get.call(null,map__2372__$1,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),false);
var children = cljs.core.get.call(null,map__2372__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var twbs_modifiers = cljs.core.get.call(null,map__2372__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var classes = cljs.core.get.call(null,map__2372__$1,new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.PersistentVector.EMPTY);
var enabled_internal_QMARK_ = (function (){var and__3938__auto__ = enabled_QMARK_;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.not.call(null,waiting_QMARK_);
} else {
return and__3938__auto__;
}
})();
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),rui.buttons.components.compose_button_class.call(null,modifiers,twbs_modifiers,classes,enabled_internal_QMARK_,waiting_QMARK_),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (enabled_internal_QMARK_,map__2372,map__2372__$1,enabled_QMARK_,attrs,modifiers,waiting_QMARK_,children,twbs_modifiers,classes){
return (function (p1__2367_SHARP_){
if(cljs.core.truth_(enabled_internal_QMARK_)){
return on_click.call(null,p1__2367_SHARP_);
} else {
return null;
}
});})(enabled_internal_QMARK_,map__2372,map__2372__$1,enabled_QMARK_,attrs,modifiers,waiting_QMARK_,children,twbs_modifiers,classes))
], null),(cljs.core.truth_(enabled_internal_QMARK_)?null:new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),true], null)),attrs),(cljs.core.truth_(waiting_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.icons.fa,"gear",true], null):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.bem.call(null,"btn","title",cljs.core.PersistentVector.EMPTY)], null),title], null)], null),children);
});

rui.buttons.components.button.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
rui.buttons.components.button.cljs$lang$applyTo = (function (seq2368){
var G__2369 = cljs.core.first.call(null,seq2368);
var seq2368__$1 = cljs.core.next.call(null,seq2368);
var G__2370 = cljs.core.first.call(null,seq2368__$1);
var seq2368__$2 = cljs.core.next.call(null,seq2368__$1);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2369,G__2370,seq2368__$2);
});

/**
 * Helper function for creating buttons
 */
rui.buttons.components.button_factory = (function rui$buttons$components$button_factory(button_type){
return (function() { 
var G__2380__delegate = function (title,on_click,p__2377){
var map__2378 = p__2377;
var map__2378__$1 = ((((!((map__2378 == null)))?(((((map__2378.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2378.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2378):map__2378);
var kwargs = map__2378__$1;
var enabled_QMARK_ = cljs.core.get.call(null,map__2378__$1,new cljs.core.Keyword(null,"enabled?","enabled?",-1376075057));
var attrs = cljs.core.get.call(null,map__2378__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var modifiers = cljs.core.get.call(null,map__2378__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834));
var waiting_QMARK_ = cljs.core.get.call(null,map__2378__$1,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215));
var children = cljs.core.get.call(null,map__2378__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var twbs_modifiers = cljs.core.get.call(null,map__2378__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072));
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.buttons.components.button,title,on_click], null),rui.buttons.components.map__GT_vec.call(null,cljs.core.update.call(null,kwargs,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.conj,button_type)));
};
var G__2380 = function (title,on_click,var_args){
var p__2377 = null;
if (arguments.length > 2) {
var G__2381__i = 0, G__2381__a = new Array(arguments.length -  2);
while (G__2381__i < G__2381__a.length) {G__2381__a[G__2381__i] = arguments[G__2381__i + 2]; ++G__2381__i;}
  p__2377 = new cljs.core.IndexedSeq(G__2381__a,0,null);
} 
return G__2380__delegate.call(this,title,on_click,p__2377);};
G__2380.cljs$lang$maxFixedArity = 2;
G__2380.cljs$lang$applyTo = (function (arglist__2382){
var title = cljs.core.first(arglist__2382);
arglist__2382 = cljs.core.next(arglist__2382);
var on_click = cljs.core.first(arglist__2382);
var p__2377 = cljs.core.rest(arglist__2382);
return G__2380__delegate(title,on_click,p__2377);
});
G__2380.cljs$core$IFn$_invoke$arity$variadic = G__2380__delegate;
return G__2380;
})()
;
});

//# sourceMappingURL=components.js.map
