// Compiled by ClojureScript 1.10.339 {}
goog.provide('rui.modals.core');
goog.require('cljs.core');
goog.require('goog.events');
goog.require('goog.events.EventType');
goog.require('goog.events.KeyCodes');
goog.require('re_frame.core');
/**
 * Sets a modal by a given `id` to opened state. Sets a listener for Escape key, when called multiple times
 * the listener is not reset.
 */
rui.modals.core.open_modal = (function rui$modals$core$open_modal(db,id,on_close){
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::modals","rui::modals",1907362643),id,new cljs.core.Keyword(null,"opened?","opened?",1096959669)], null),true),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::modals","rui::modals",1907362643),id,new cljs.core.Keyword(null,"listener-key","listener-key",-2125872392)], null),(function (listener_key){
if(!((listener_key == null))){
return listener_key;
} else {
return goog.events.listen(window,goog.events.EventType.KEYUP,(function (p1__29028_SHARP_){
if(cljs.core._EQ_.call(null,goog.events.KeyCodes.ESC,p1__29028_SHARP_.keyCode)){
return on_close.call(null,p1__29028_SHARP_);
} else {
return null;
}
}));
}
}));
});
/**
 * Sets a modal by a given `id` to closed state. Unlistens a listener for Escape key, when called multiple times
 * the listener is remove only once.
 */
rui.modals.core.close_modal = (function rui$modals$core$close_modal(db,id){
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::modals","rui::modals",1907362643),id,new cljs.core.Keyword(null,"opened?","opened?",1096959669)], null),false),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::modals","rui::modals",1907362643),id,new cljs.core.Keyword(null,"listener-key","listener-key",-2125872392)], null),(function (listener_key){
if(!((listener_key == null))){
goog.events.unlistenByKey(listener_key);
} else {
}

return null;
}));
});
rui.modals.core.initial_state = (function rui$modals$core$initial_state(id){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"opened?","opened?",1096959669),false,new cljs.core.Keyword(null,"listener-key","listener-key",-2125872392),null], null);
});
rui.modals.core.init_modal_state_BANG_ = (function rui$modals$core$init_modal_state_BANG_(var_args){
var G__29030 = arguments.length;
switch (G__29030) {
case 1:
return rui.modals.core.init_modal_state_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return rui.modals.core.init_modal_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

rui.modals.core.init_modal_state_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (id){
return rui.modals.core.init_modal_state_BANG_.call(null,id,null);
});

rui.modals.core.init_modal_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (id,state){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rui::modals","init-state","rui::modals/init-state",763835736),id,cljs.core.merge.call(null,rui.modals.core.initial_state.call(null,id),state)], null));
});

rui.modals.core.init_modal_state_BANG_.cljs$lang$maxFixedArity = 2;

rui.modals.core.db__GT_modal_state = (function rui$modals$core$db__GT_modal_state(db,id){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::modals","rui::modals",1907362643),id], null));
});
rui.modals.core.close_modal_BANG_ = (function rui$modals$core$close_modal_BANG_(id,event){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rui::modals","close","rui::modals/close",1448927578),id], null));
});
rui.modals.core.open_modal_BANG_ = (function rui$modals$core$open_modal_BANG_(id,event){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rui::modals","open","rui::modals/open",1844502324),id,cljs.core.partial.call(null,rui.modals.core.close_modal_BANG_,id)], null));
});

//# sourceMappingURL=core.js.map?rel=1533629724625
