// Compiled by ClojureScript 1.10.339 {}
goog.provide('rui.forms.core');
goog.require('cljs.core');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('re_frame.core');
rui.forms.core.field_states = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"valid","valid",155614240),null,new cljs.core.Keyword(null,"invalid","invalid",412869516),null,new cljs.core.Keyword(null,"initial","initial",1854648214),null], null), null);

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
rui.forms.core.Field = (function (id,value,valid_QMARK_,state,blured_QMARK_,required_QMARK_,coerced_value,__meta,__extmap,__hash){
this.id = id;
this.value = value;
this.valid_QMARK_ = valid_QMARK_;
this.state = state;
this.blured_QMARK_ = blured_QMARK_;
this.required_QMARK_ = required_QMARK_;
this.coerced_value = coerced_value;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
rui.forms.core.Field.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

rui.forms.core.Field.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k22374,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__22378 = k22374;
var G__22378__$1 = (((G__22378 instanceof cljs.core.Keyword))?G__22378.fqn:null);
switch (G__22378__$1) {
case "id":
return self__.id;

break;
case "value":
return self__.value;

break;
case "valid?":
return self__.valid_QMARK_;

break;
case "state":
return self__.state;

break;
case "blured?":
return self__.blured_QMARK_;

break;
case "required?":
return self__.required_QMARK_;

break;
case "coerced-value":
return self__.coerced_value;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k22374,else__4206__auto__);

}
});

rui.forms.core.Field.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,pr_pair__4220__auto__,"#rui.forms.core.Field{",", ","}",opts__4219__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"value","value",305978217),self__.value],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"valid?","valid?",-212412379),self__.valid_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blured?","blured?",1861327265),self__.blured_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"required?","required?",-872514462),self__.required_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"coerced-value","coerced-value",2049831552),self__.coerced_value],null))], null),self__.__extmap));
});

rui.forms.core.Field.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__22373){
var self__ = this;
var G__22373__$1 = this;
return (new cljs.core.RecordIter((0),G__22373__$1,7,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"valid?","valid?",-212412379),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"blured?","blured?",1861327265),new cljs.core.Keyword(null,"required?","required?",-872514462),new cljs.core.Keyword(null,"coerced-value","coerced-value",2049831552)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

rui.forms.core.Field.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

rui.forms.core.Field.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.required_QMARK_,self__.coerced_value,self__.__meta,self__.__extmap,self__.__hash));
});

rui.forms.core.Field.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (7 + cljs.core.count.call(null,self__.__extmap));
});

rui.forms.core.Field.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (1205228671 ^ cljs.core.hash_unordered_coll.call(null,coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
.call(null,this__4199__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

rui.forms.core.Field.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this22375,other22376){
var self__ = this;
var this22375__$1 = this;
return ((!((other22376 == null))) && ((this22375__$1.constructor === other22376.constructor)) && (cljs.core._EQ_.call(null,this22375__$1.id,other22376.id)) && (cljs.core._EQ_.call(null,this22375__$1.value,other22376.value)) && (cljs.core._EQ_.call(null,this22375__$1.valid_QMARK_,other22376.valid_QMARK_)) && (cljs.core._EQ_.call(null,this22375__$1.state,other22376.state)) && (cljs.core._EQ_.call(null,this22375__$1.blured_QMARK_,other22376.blured_QMARK_)) && (cljs.core._EQ_.call(null,this22375__$1.required_QMARK_,other22376.required_QMARK_)) && (cljs.core._EQ_.call(null,this22375__$1.coerced_value,other22376.coerced_value)) && (cljs.core._EQ_.call(null,this22375__$1.__extmap,other22376.__extmap)));
});

rui.forms.core.Field.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"coerced-value","coerced-value",2049831552),null,new cljs.core.Keyword(null,"blured?","blured?",1861327265),null,new cljs.core.Keyword(null,"required?","required?",-872514462),null,new cljs.core.Keyword(null,"valid?","valid?",-212412379),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"id","id",-1388402092),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.required_QMARK_,self__.coerced_value,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4213__auto__)),null));
}
});

rui.forms.core.Field.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__22373){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__22379 = cljs.core.keyword_identical_QMARK_;
var expr__22380 = k__4211__auto__;
if(cljs.core.truth_(pred__22379.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__22380))){
return (new rui.forms.core.Field(G__22373,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.required_QMARK_,self__.coerced_value,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22379.call(null,new cljs.core.Keyword(null,"value","value",305978217),expr__22380))){
return (new rui.forms.core.Field(self__.id,G__22373,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.required_QMARK_,self__.coerced_value,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22379.call(null,new cljs.core.Keyword(null,"valid?","valid?",-212412379),expr__22380))){
return (new rui.forms.core.Field(self__.id,self__.value,G__22373,self__.state,self__.blured_QMARK_,self__.required_QMARK_,self__.coerced_value,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22379.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__22380))){
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,G__22373,self__.blured_QMARK_,self__.required_QMARK_,self__.coerced_value,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22379.call(null,new cljs.core.Keyword(null,"blured?","blured?",1861327265),expr__22380))){
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,G__22373,self__.required_QMARK_,self__.coerced_value,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22379.call(null,new cljs.core.Keyword(null,"required?","required?",-872514462),expr__22380))){
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,G__22373,self__.coerced_value,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22379.call(null,new cljs.core.Keyword(null,"coerced-value","coerced-value",2049831552),expr__22380))){
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.required_QMARK_,G__22373,self__.__meta,self__.__extmap,null));
} else {
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.required_QMARK_,self__.coerced_value,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4211__auto__,G__22373),null));
}
}
}
}
}
}
}
});

rui.forms.core.Field.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"value","value",305978217),self__.value,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"valid?","valid?",-212412379),self__.valid_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blured?","blured?",1861327265),self__.blured_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"required?","required?",-872514462),self__.required_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"coerced-value","coerced-value",2049831552),self__.coerced_value,null))], null),self__.__extmap));
});

rui.forms.core.Field.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__22373){
var self__ = this;
var this__4202__auto____$1 = this;
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.required_QMARK_,self__.coerced_value,G__22373,self__.__extmap,self__.__hash));
});

rui.forms.core.Field.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4209__auto__,(0)),cljs.core._nth.call(null,entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

rui.forms.core.Field.getBasis = (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"valid?","valid?",1428119148,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"blured?","blured?",-793108504,null),new cljs.core.Symbol(null,"required?","required?",768017065,null),new cljs.core.Symbol(null,"coerced-value","coerced-value",-604604217,null)], null);
});

rui.forms.core.Field.cljs$lang$type = true;

rui.forms.core.Field.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"rui.forms.core/Field",null,(1),null));
});

rui.forms.core.Field.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write.call(null,writer__4241__auto__,"rui.forms.core/Field");
});

/**
 * Positional factory function for rui.forms.core/Field.
 */
rui.forms.core.__GT_Field = (function rui$forms$core$__GT_Field(id,value,valid_QMARK_,state,blured_QMARK_,required_QMARK_,coerced_value){
return (new rui.forms.core.Field(id,value,valid_QMARK_,state,blured_QMARK_,required_QMARK_,coerced_value,null,null,null));
});

/**
 * Factory function for rui.forms.core/Field, taking a map of keywords to field values.
 */
rui.forms.core.map__GT_Field = (function rui$forms$core$map__GT_Field(G__22377){
var extmap__4236__auto__ = (function (){var G__22382 = cljs.core.dissoc.call(null,G__22377,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"valid?","valid?",-212412379),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"blured?","blured?",1861327265),new cljs.core.Keyword(null,"required?","required?",-872514462),new cljs.core.Keyword(null,"coerced-value","coerced-value",2049831552));
if(cljs.core.record_QMARK_.call(null,G__22377)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__22382);
} else {
return G__22382;
}
})();
return (new rui.forms.core.Field(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__22377),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(G__22377),new cljs.core.Keyword(null,"valid?","valid?",-212412379).cljs$core$IFn$_invoke$arity$1(G__22377),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__22377),new cljs.core.Keyword(null,"blured?","blured?",1861327265).cljs$core$IFn$_invoke$arity$1(G__22377),new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(G__22377),new cljs.core.Keyword(null,"coerced-value","coerced-value",2049831552).cljs$core$IFn$_invoke$arity$1(G__22377),null,cljs.core.not_empty.call(null,extmap__4236__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
rui.forms.core.Form = (function (id,fields,valid_QMARK_,errors,validator,__meta,__extmap,__hash){
this.id = id;
this.fields = fields;
this.valid_QMARK_ = valid_QMARK_;
this.errors = errors;
this.validator = validator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
rui.forms.core.Form.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

rui.forms.core.Form.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k22385,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__22389 = k22385;
var G__22389__$1 = (((G__22389 instanceof cljs.core.Keyword))?G__22389.fqn:null);
switch (G__22389__$1) {
case "id":
return self__.id;

break;
case "fields":
return self__.fields;

break;
case "valid?":
return self__.valid_QMARK_;

break;
case "errors":
return self__.errors;

break;
case "validator":
return self__.validator;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k22385,else__4206__auto__);

}
});

rui.forms.core.Form.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,pr_pair__4220__auto__,"#rui.forms.core.Form{",", ","}",opts__4219__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fields","fields",-1932066230),self__.fields],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"valid?","valid?",-212412379),self__.valid_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"errors","errors",-908790718),self__.errors],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"validator","validator",-1966190681),self__.validator],null))], null),self__.__extmap));
});

rui.forms.core.Form.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__22384){
var self__ = this;
var G__22384__$1 = this;
return (new cljs.core.RecordIter((0),G__22384__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"fields","fields",-1932066230),new cljs.core.Keyword(null,"valid?","valid?",-212412379),new cljs.core.Keyword(null,"errors","errors",-908790718),new cljs.core.Keyword(null,"validator","validator",-1966190681)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

rui.forms.core.Form.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

rui.forms.core.Form.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,self__.errors,self__.validator,self__.__meta,self__.__extmap,self__.__hash));
});

rui.forms.core.Form.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
});

rui.forms.core.Form.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (-1405164784 ^ cljs.core.hash_unordered_coll.call(null,coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
.call(null,this__4199__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

rui.forms.core.Form.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this22386,other22387){
var self__ = this;
var this22386__$1 = this;
return ((!((other22387 == null))) && ((this22386__$1.constructor === other22387.constructor)) && (cljs.core._EQ_.call(null,this22386__$1.id,other22387.id)) && (cljs.core._EQ_.call(null,this22386__$1.fields,other22387.fields)) && (cljs.core._EQ_.call(null,this22386__$1.valid_QMARK_,other22387.valid_QMARK_)) && (cljs.core._EQ_.call(null,this22386__$1.errors,other22387.errors)) && (cljs.core._EQ_.call(null,this22386__$1.validator,other22387.validator)) && (cljs.core._EQ_.call(null,this22386__$1.__extmap,other22387.__extmap)));
});

rui.forms.core.Form.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"errors","errors",-908790718),null,new cljs.core.Keyword(null,"valid?","valid?",-212412379),null,new cljs.core.Keyword(null,"validator","validator",-1966190681),null,new cljs.core.Keyword(null,"fields","fields",-1932066230),null,new cljs.core.Keyword(null,"id","id",-1388402092),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,self__.errors,self__.validator,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4213__auto__)),null));
}
});

rui.forms.core.Form.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__22384){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__22390 = cljs.core.keyword_identical_QMARK_;
var expr__22391 = k__4211__auto__;
if(cljs.core.truth_(pred__22390.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__22391))){
return (new rui.forms.core.Form(G__22384,self__.fields,self__.valid_QMARK_,self__.errors,self__.validator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22390.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230),expr__22391))){
return (new rui.forms.core.Form(self__.id,G__22384,self__.valid_QMARK_,self__.errors,self__.validator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22390.call(null,new cljs.core.Keyword(null,"valid?","valid?",-212412379),expr__22391))){
return (new rui.forms.core.Form(self__.id,self__.fields,G__22384,self__.errors,self__.validator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22390.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718),expr__22391))){
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,G__22384,self__.validator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22390.call(null,new cljs.core.Keyword(null,"validator","validator",-1966190681),expr__22391))){
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,self__.errors,G__22384,self__.__meta,self__.__extmap,null));
} else {
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,self__.errors,self__.validator,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4211__auto__,G__22384),null));
}
}
}
}
}
});

rui.forms.core.Form.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fields","fields",-1932066230),self__.fields,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"valid?","valid?",-212412379),self__.valid_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"errors","errors",-908790718),self__.errors,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"validator","validator",-1966190681),self__.validator,null))], null),self__.__extmap));
});

rui.forms.core.Form.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__22384){
var self__ = this;
var this__4202__auto____$1 = this;
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,self__.errors,self__.validator,G__22384,self__.__extmap,self__.__hash));
});

rui.forms.core.Form.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4209__auto__,(0)),cljs.core._nth.call(null,entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

rui.forms.core.Form.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.Symbol(null,"valid?","valid?",1428119148,null),new cljs.core.Symbol(null,"errors","errors",731740809,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null)], null);
});

rui.forms.core.Form.cljs$lang$type = true;

rui.forms.core.Form.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"rui.forms.core/Form",null,(1),null));
});

rui.forms.core.Form.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write.call(null,writer__4241__auto__,"rui.forms.core/Form");
});

/**
 * Positional factory function for rui.forms.core/Form.
 */
rui.forms.core.__GT_Form = (function rui$forms$core$__GT_Form(id,fields,valid_QMARK_,errors,validator){
return (new rui.forms.core.Form(id,fields,valid_QMARK_,errors,validator,null,null,null));
});

/**
 * Factory function for rui.forms.core/Form, taking a map of keywords to field values.
 */
rui.forms.core.map__GT_Form = (function rui$forms$core$map__GT_Form(G__22388){
var extmap__4236__auto__ = (function (){var G__22393 = cljs.core.dissoc.call(null,G__22388,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"fields","fields",-1932066230),new cljs.core.Keyword(null,"valid?","valid?",-212412379),new cljs.core.Keyword(null,"errors","errors",-908790718),new cljs.core.Keyword(null,"validator","validator",-1966190681));
if(cljs.core.record_QMARK_.call(null,G__22388)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__22393);
} else {
return G__22393;
}
})();
return (new rui.forms.core.Form(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__22388),new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(G__22388),new cljs.core.Keyword(null,"valid?","valid?",-212412379).cljs$core$IFn$_invoke$arity$1(G__22388),new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(G__22388),new cljs.core.Keyword(null,"validator","validator",-1966190681).cljs$core$IFn$_invoke$arity$1(G__22388),null,cljs.core.not_empty.call(null,extmap__4236__auto__),null));
});

rui.forms.core.gen_field_id = (function rui$forms$core$gen_field_id(form,field_name){
return goog.string.format("%s_%s",cljs.core.name.call(null,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(form)),cljs.core.name.call(null,field_name));
});
/**
 * Return a `Form` by a given `id` in the `db`.
 */
rui.forms.core.db__GT_form = (function rui$forms$core$db__GT_form(db,id){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::forms","rui::forms",-426766832),id], null));
});
/**
 * Initializes a `Field` by `id`, or `value` with default values.
 */
rui.forms.core.init_field = (function rui$forms$core$init_field(var_args){
var G__22396 = arguments.length;
switch (G__22396) {
case 1:
return rui.forms.core.init_field.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return rui.forms.core.init_field.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

rui.forms.core.init_field.cljs$core$IFn$_invoke$arity$1 = (function (id){
return rui.forms.core.init_field.call(null,id,null);
});

rui.forms.core.init_field.cljs$core$IFn$_invoke$arity$2 = (function (id,value){
return rui.forms.core.__GT_Field.call(null,id,value,false,new cljs.core.Keyword(null,"initial","initial",1854648214),false,false,value);
});

rui.forms.core.init_field.cljs$lang$maxFixedArity = 2;

/**
 * Creates a `Form` from a given `map`.
 */
rui.forms.core.create_form = (function rui$forms$core$create_form(form_map,init_values){
return rui.forms.core.map__GT_Form.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fields","fields",-1932066230),cljs.core.reduce_kv.call(null,(function (fields,field_id,init_value){
return cljs.core.assoc.call(null,fields,field_id,rui.forms.core.init_field.call(null,field_id,init_value));
}),cljs.core.PersistentArrayMap.EMPTY,init_values),new cljs.core.Keyword(null,"errors","errors",-908790718),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"valid?","valid?",-212412379),false], null),form_map));
});
/**
 * Returns a field's state as a `string`.
 */
rui.forms.core.field_state = (function rui$forms$core$field_state(form,id){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form)));
if((state == null)){
return "";
} else {
return cljs.core.name.call(null,state);
}
});
rui.forms.core.form__GT__STAR_values = (function rui$forms$core$form__GT__STAR_values(key_name,form){
return cljs.core.reduce_kv.call(null,(function (values,id,field){
return cljs.core.assoc.call(null,values,id,cljs.core.get.call(null,field,key_name));
}),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form));
});
rui.forms.core.form__GT_values = cljs.core.partial.call(null,rui.forms.core.form__GT__STAR_values,new cljs.core.Keyword(null,"value","value",305978217));
rui.forms.core.form__GT_coerced_values = cljs.core.partial.call(null,rui.forms.core.form__GT__STAR_values,new cljs.core.Keyword(null,"coerced-value","coerced-value",2049831552));
rui.forms.core.update_validated_fields = (function rui$forms$core$update_validated_fields(errors,update_coerced_value,fields){
return cljs.core.reduce_kv.call(null,(function (fields__$1,id,field){
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,fields__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,new cljs.core.Keyword(null,"valid?","valid?",-212412379)], null),!(cljs.core.contains_QMARK_.call(null,errors,id))),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,new cljs.core.Keyword(null,"coerced-value","coerced-value",2049831552)], null),cljs.core.partial.call(null,update_coerced_value,id));
}),fields,fields);
});
/**
 * Validates a given `form` by its validator. It returns new form with updated values:
 * - `errors`
 * - `valid?`
 * - every field's `valid?` is updated too and field's `value` if coerced
 */
rui.forms.core.validate_form = (function rui$forms$core$validate_form(form){
var field_values = rui.forms.core.form__GT_values.call(null,form);
var validator = new cljs.core.Keyword(null,"validator","validator",-1966190681).cljs$core$IFn$_invoke$arity$1(form);
var validator_result = validator.call(null,field_values);
var vec__22398 = ((cljs.core.vector_QMARK_.call(null,validator_result))?validator_result:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [validator_result,null], null));
var errors = cljs.core.nth.call(null,vec__22398,(0),null);
var model = cljs.core.nth.call(null,vec__22398,(1),null);
var update_coerced_value = ((function (field_values,validator,validator_result,vec__22398,errors,model){
return (function (id,old_value){
var temp__5459__auto__ = cljs.core.get.call(null,model,id);
if((temp__5459__auto__ == null)){
return old_value;
} else {
var new_value = temp__5459__auto__;
return new_value;
}
});})(field_values,validator,validator_result,vec__22398,errors,model))
;
return cljs.core.update.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,form,new cljs.core.Keyword(null,"errors","errors",-908790718),errors),new cljs.core.Keyword(null,"valid?","valid?",-212412379),cljs.core.empty_QMARK_.call(null,errors)),new cljs.core.Keyword(null,"fields","fields",-1932066230),cljs.core.partial.call(null,rui.forms.core.update_validated_fields,errors,update_coerced_value));
});
/**
 * Initializes a form in the `db` within `form-map` and `initial-values`
 */
rui.forms.core.init_form = (function rui$forms$core$init_form(db,form_map,initial_values){
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::forms","rui::forms",-426766832),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(form_map)], null),rui.forms.core.create_form.call(null,form_map,initial_values)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::forms","rui::forms",-426766832),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(form_map)], null),rui.forms.core.validate_form);
});
/**
 * Disssoc forms from the `db` by given `ids`
 */
rui.forms.core.dissoc_forms = (function rui$forms$core$dissoc_forms(db,ids){
return cljs.core.apply.call(null,cljs.core.update,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [db,new cljs.core.Keyword(null,"rui::forms","rui::forms",-426766832),cljs.core.dissoc], null),ids));
});
/**
 * Assocs a given `value` into the `db` by a given `form-id` and `field-id`
 */
rui.forms.core.assoc_field_value = (function rui$forms$core$assoc_field_value(db,form_id,field_id,value){
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::forms","rui::forms",-426766832),form_id,new cljs.core.Keyword(null,"fields","fields",-1932066230),field_id,new cljs.core.Keyword(null,"value","value",305978217)], null),value);
});
/**
 * Assocs a given `values` into the `db` by a given `form-id`
 */
rui.forms.core.assoc_values = (function rui$forms$core$assoc_values(db,form_id,values){
return cljs.core.reduce_kv.call(null,(function (db__$1,field_id,value){
return rui.forms.core.assoc_field_value.call(null,db__$1,form_id,field_id,value);
}),db,values);
});
/**
 * Adds a given `errors` into the `db` by a given `form-id`.
 * The `errors` should be a map with vectors
 */
rui.forms.core.add_form_errors = (function rui$forms$core$add_form_errors(db,form_id,errors){
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::forms","rui::forms",-426766832),form_id,new cljs.core.Keyword(null,"errors","errors",-908790718)], null),cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.into),errors),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::forms","rui::forms",-426766832),form_id,new cljs.core.Keyword(null,"valid?","valid?",-212412379)], null),false),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rui::forms","rui::forms",-426766832),form_id,new cljs.core.Keyword(null,"fields","fields",-1932066230)], null),(function (p1__22401_SHARP_){
return cljs.core.reduce_kv.call(null,(function (fields,k,_){
if(cljs.core.contains_QMARK_.call(null,errors,k)){
return cljs.core.assoc_in.call(null,fields,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"state","state",-1988618099)], null),new cljs.core.Keyword(null,"invalid","invalid",412869516));
} else {
return fields;
}
}),p1__22401_SHARP_,p1__22401_SHARP_);
}));
});
/**
 * Takes a response's body as errors and assoc them in the `db` by a `form-id`.
 * The `errors` should be a map with vectors
 */
rui.forms.core.form_errors_LT_response = (function rui$forms$core$form_errors_LT_response(db,form_id,errors){
return rui.forms.core.add_form_errors.call(null,db,form_id,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(errors));
});
/**
 * Dispatches a input's on-change event. Optionally takes a `formatter` function that takes a new values and returns
 * formatter value.
 */
rui.forms.core.input_on_change_BANG_ = (function rui$forms$core$input_on_change_BANG_(var_args){
var G__22403 = arguments.length;
switch (G__22403) {
case 4:
return rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (form,id,formatter,event){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rui::forms","forms-input-changed","rui::forms/forms-input-changed",-943107654),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(form),id,formatter.call(null,event.target.value)], null));
});

rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (form,id,event){
return rui.forms.core.input_on_change_BANG_.call(null,form,id,cljs.core.identity,event);
});

rui.forms.core.input_on_change_BANG_.cljs$lang$maxFixedArity = 4;

/**
 * Dispatches a input's on-blur event
 */
rui.forms.core.input_on_blur_BANG_ = (function rui$forms$core$input_on_blur_BANG_(form,id,event){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rui::forms","forms-input-blured","rui::forms/forms-input-blured",860908066),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(form),id], null));
});
/**
 * Initializes a form in DB by a given `form-id` with a `validator` function that takes a map of fields values
 * and returns a map of vectors as errors or `nil`. Optionally takes an `initial-values` map.
 */
rui.forms.core.init_form_BANG_ = (function rui$forms$core$init_form_BANG_(var_args){
var G__22406 = arguments.length;
switch (G__22406) {
case 2:
return rui.forms.core.init_form_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return rui.forms.core.init_form_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

rui.forms.core.init_form_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (form_id,validator){
return rui.forms.core.init_form_BANG_.call(null,form_id,validator,cljs.core.PersistentArrayMap.EMPTY);
});

rui.forms.core.init_form_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (form_id,validator,initial_values){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rui::forms","init-form","rui::forms/init-form",-1541891045),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),form_id,new cljs.core.Keyword(null,"validator","validator",-1966190681),validator], null),initial_values], null));
});

rui.forms.core.init_form_BANG_.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=core.js.map?rel=1561451382317
