// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('rui.modals.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.events');
goog.require('goog.events.EventType');
goog.require('goog.events.KeyCodes');
goog.require('re_frame.core');
/**
 * Sets a modal by a given `id` to opened state. Sets a listener for Escape key, when called multiple times
 * the listener is not reset.
 */
rui.modals.core.open_modal = (function rui$modals$core$open_modal(db,id,on_close){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_modals,id,cljs.core.cst$kw$opened_QMARK_], null),true),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_modals,id,cljs.core.cst$kw$listener_DASH_key], null),(function (listener_key){
if(!((listener_key == null))){
return listener_key;
} else {
var G__7321 = window;
var G__7322 = goog.events.EventType.KEYUP;
var G__7323 = ((function (G__7321,G__7322){
return (function (p1__7320_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(goog.events.KeyCodes.ESC,p1__7320_SHARP_.keyCode)){
return (on_close.cljs$core$IFn$_invoke$arity$1 ? on_close.cljs$core$IFn$_invoke$arity$1(p1__7320_SHARP_) : on_close.call(null,p1__7320_SHARP_));
} else {
return null;
}
});})(G__7321,G__7322))
;
return goog.events.listen(G__7321,G__7322,G__7323);
}
}));
});
/**
 * Sets a modal by a given `id` to closed state. Unlistens a listener for Escape key, when called multiple times
 * the listener is remove only once.
 */
rui.modals.core.close_modal = (function rui$modals$core$close_modal(db,id){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_modals,id,cljs.core.cst$kw$opened_QMARK_], null),false),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_modals,id,cljs.core.cst$kw$listener_DASH_key], null),(function (listener_key){
if(!((listener_key == null))){
goog.events.unlistenByKey(listener_key);
} else {
}

return null;
}));
});
rui.modals.core.initial_state = (function rui$modals$core$initial_state(id){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$id,id,cljs.core.cst$kw$opened_QMARK_,false,cljs.core.cst$kw$listener_DASH_key,null], null);
});
rui.modals.core.init_modal_state_BANG_ = (function rui$modals$core$init_modal_state_BANG_(var_args){
var G__7340 = arguments.length;
switch (G__7340) {
case 1:
return rui.modals.core.init_modal_state_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return rui.modals.core.init_modal_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

rui.modals.core.init_modal_state_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (id){
return rui.modals.core.init_modal_state_BANG_.cljs$core$IFn$_invoke$arity$2(id,null);
});

rui.modals.core.init_modal_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (id,state){
var G__7344 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_modals_SLASH_init_DASH_state,id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([rui.modals.core.initial_state(id),state], 0))], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__7344) : re_frame.core.dispatch.call(null,G__7344));
});

rui.modals.core.init_modal_state_BANG_.cljs$lang$maxFixedArity = 2;

rui.modals.core.db__GT_modal_state = (function rui$modals$core$db__GT_modal_state(db,id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_modals,id], null));
});
rui.modals.core.close_modal_BANG_ = (function rui$modals$core$close_modal_BANG_(id,event){
var G__7354 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_modals_SLASH_close,id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__7354) : re_frame.core.dispatch.call(null,G__7354));
});
rui.modals.core.open_modal_BANG_ = (function rui$modals$core$open_modal_BANG_(id,event){
var G__7355 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_modals_SLASH_open,id,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(rui.modals.core.close_modal_BANG_,id)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__7355) : re_frame.core.dispatch.call(null,G__7355));
});
