// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('rui.forms.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('re_frame.core');
rui.forms.core.field_states = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$valid,null,cljs.core.cst$kw$invalid,null,cljs.core.cst$kw$initial,null], null), null);

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
rui.forms.core.Field = (function (id,value,valid_QMARK_,state,blured_QMARK_,required_QMARK_,coerced_value,__meta,__extmap,__hash){
this.id = id;
this.value = value;
this.valid_QMARK_ = valid_QMARK_;
this.state = state;
this.blured_QMARK_ = blured_QMARK_;
this.required_QMARK_ = required_QMARK_;
this.coerced_value = coerced_value;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
rui.forms.core.Field.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

rui.forms.core.Field.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k7155,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__7166 = k7155;
var G__7166__$1 = (((G__7166 instanceof cljs.core.Keyword))?G__7166.fqn:null);
switch (G__7166__$1) {
case "id":
return self__.id;

break;
case "value":
return self__.value;

break;
case "valid?":
return self__.valid_QMARK_;

break;
case "state":
return self__.state;

break;
case "blured?":
return self__.blured_QMARK_;

break;
case "required?":
return self__.required_QMARK_;

break;
case "coerced-value":
return self__.coerced_value;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k7155,else__4206__auto__);

}
});

rui.forms.core.Field.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer(writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4218__auto__,pr_pair__4220__auto__,"#rui.forms.core.Field{",", ","}",opts__4219__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$value,self__.value],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$valid_QMARK_,self__.valid_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$blured_QMARK_,self__.blured_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$required_QMARK_,self__.required_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$coerced_DASH_value,self__.coerced_value],null))], null),self__.__extmap));
});

rui.forms.core.Field.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__7154){
var self__ = this;
var G__7154__$1 = this;
return (new cljs.core.RecordIter((0),G__7154__$1,7,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$value,cljs.core.cst$kw$valid_QMARK_,cljs.core.cst$kw$state,cljs.core.cst$kw$blured_QMARK_,cljs.core.cst$kw$required_QMARK_,cljs.core.cst$kw$coerced_DASH_value], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

rui.forms.core.Field.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

rui.forms.core.Field.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.required_QMARK_,self__.coerced_value,self__.__meta,self__.__extmap,self__.__hash));
});

rui.forms.core.Field.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (7 + cljs.core.count(self__.__extmap));
});

rui.forms.core.Field.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = (function (){var fexpr__7180 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (1205228671 ^ cljs.core.hash_unordered_coll(coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
;
return fexpr__7180(this__4199__auto____$1);
})();
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

rui.forms.core.Field.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this7156,other7157){
var self__ = this;
var this7156__$1 = this;
return ((!((other7157 == null))) && ((this7156__$1.constructor === other7157.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this7156__$1.id,other7157.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this7156__$1.value,other7157.value)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this7156__$1.valid_QMARK_,other7157.valid_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this7156__$1.state,other7157.state)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this7156__$1.blured_QMARK_,other7157.blured_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this7156__$1.required_QMARK_,other7157.required_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this7156__$1.coerced_value,other7157.coerced_value)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this7156__$1.__extmap,other7157.__extmap)));
});

rui.forms.core.Field.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$coerced_DASH_value,null,cljs.core.cst$kw$blured_QMARK_,null,cljs.core.cst$kw$required_QMARK_,null,cljs.core.cst$kw$valid_QMARK_,null,cljs.core.cst$kw$value,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$id,null], null), null),k__4213__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.required_QMARK_,self__.coerced_value,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4213__auto__)),null));
}
});

rui.forms.core.Field.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__7154){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__7186 = cljs.core.keyword_identical_QMARK_;
var expr__7187 = k__4211__auto__;
if(cljs.core.truth_((function (){var G__7189 = cljs.core.cst$kw$id;
var G__7190 = expr__7187;
return (pred__7186.cljs$core$IFn$_invoke$arity$2 ? pred__7186.cljs$core$IFn$_invoke$arity$2(G__7189,G__7190) : pred__7186.call(null,G__7189,G__7190));
})())){
return (new rui.forms.core.Field(G__7154,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.required_QMARK_,self__.coerced_value,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__7191 = cljs.core.cst$kw$value;
var G__7192 = expr__7187;
return (pred__7186.cljs$core$IFn$_invoke$arity$2 ? pred__7186.cljs$core$IFn$_invoke$arity$2(G__7191,G__7192) : pred__7186.call(null,G__7191,G__7192));
})())){
return (new rui.forms.core.Field(self__.id,G__7154,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.required_QMARK_,self__.coerced_value,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__7195 = cljs.core.cst$kw$valid_QMARK_;
var G__7196 = expr__7187;
return (pred__7186.cljs$core$IFn$_invoke$arity$2 ? pred__7186.cljs$core$IFn$_invoke$arity$2(G__7195,G__7196) : pred__7186.call(null,G__7195,G__7196));
})())){
return (new rui.forms.core.Field(self__.id,self__.value,G__7154,self__.state,self__.blured_QMARK_,self__.required_QMARK_,self__.coerced_value,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__7198 = cljs.core.cst$kw$state;
var G__7199 = expr__7187;
return (pred__7186.cljs$core$IFn$_invoke$arity$2 ? pred__7186.cljs$core$IFn$_invoke$arity$2(G__7198,G__7199) : pred__7186.call(null,G__7198,G__7199));
})())){
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,G__7154,self__.blured_QMARK_,self__.required_QMARK_,self__.coerced_value,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__7200 = cljs.core.cst$kw$blured_QMARK_;
var G__7201 = expr__7187;
return (pred__7186.cljs$core$IFn$_invoke$arity$2 ? pred__7186.cljs$core$IFn$_invoke$arity$2(G__7200,G__7201) : pred__7186.call(null,G__7200,G__7201));
})())){
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,G__7154,self__.required_QMARK_,self__.coerced_value,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__7202 = cljs.core.cst$kw$required_QMARK_;
var G__7203 = expr__7187;
return (pred__7186.cljs$core$IFn$_invoke$arity$2 ? pred__7186.cljs$core$IFn$_invoke$arity$2(G__7202,G__7203) : pred__7186.call(null,G__7202,G__7203));
})())){
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,G__7154,self__.coerced_value,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__7204 = cljs.core.cst$kw$coerced_DASH_value;
var G__7205 = expr__7187;
return (pred__7186.cljs$core$IFn$_invoke$arity$2 ? pred__7186.cljs$core$IFn$_invoke$arity$2(G__7204,G__7205) : pred__7186.call(null,G__7204,G__7205));
})())){
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.required_QMARK_,G__7154,self__.__meta,self__.__extmap,null));
} else {
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.required_QMARK_,self__.coerced_value,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4211__auto__,G__7154),null));
}
}
}
}
}
}
}
});

rui.forms.core.Field.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$value,self__.value,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$valid_QMARK_,self__.valid_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$blured_QMARK_,self__.blured_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$required_QMARK_,self__.required_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$coerced_DASH_value,self__.coerced_value,null))], null),self__.__extmap));
});

rui.forms.core.Field.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__7154){
var self__ = this;
var this__4202__auto____$1 = this;
return (new rui.forms.core.Field(self__.id,self__.value,self__.valid_QMARK_,self__.state,self__.blured_QMARK_,self__.required_QMARK_,self__.coerced_value,G__7154,self__.__extmap,self__.__hash));
});

rui.forms.core.Field.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

rui.forms.core.Field.getBasis = (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id,cljs.core.cst$sym$value,cljs.core.cst$sym$valid_QMARK_,cljs.core.cst$sym$state,cljs.core.cst$sym$blured_QMARK_,cljs.core.cst$sym$required_QMARK_,cljs.core.cst$sym$coerced_DASH_value], null);
});

rui.forms.core.Field.cljs$lang$type = true;

rui.forms.core.Field.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"rui.forms.core/Field",null,(1),null));
});

rui.forms.core.Field.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write(writer__4241__auto__,"rui.forms.core/Field");
});

/**
 * Positional factory function for rui.forms.core/Field.
 */
rui.forms.core.__GT_Field = (function rui$forms$core$__GT_Field(id,value,valid_QMARK_,state,blured_QMARK_,required_QMARK_,coerced_value){
return (new rui.forms.core.Field(id,value,valid_QMARK_,state,blured_QMARK_,required_QMARK_,coerced_value,null,null,null));
});

/**
 * Factory function for rui.forms.core/Field, taking a map of keywords to field values.
 */
rui.forms.core.map__GT_Field = (function rui$forms$core$map__GT_Field(G__7158){
var extmap__4236__auto__ = (function (){var G__7229 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__7158,cljs.core.cst$kw$id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$value,cljs.core.cst$kw$valid_QMARK_,cljs.core.cst$kw$state,cljs.core.cst$kw$blured_QMARK_,cljs.core.cst$kw$required_QMARK_,cljs.core.cst$kw$coerced_DASH_value], 0));
if(cljs.core.record_QMARK_(G__7158)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__7229);
} else {
return G__7229;
}
})();
return (new rui.forms.core.Field(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__7158),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(G__7158),cljs.core.cst$kw$valid_QMARK_.cljs$core$IFn$_invoke$arity$1(G__7158),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__7158),cljs.core.cst$kw$blured_QMARK_.cljs$core$IFn$_invoke$arity$1(G__7158),cljs.core.cst$kw$required_QMARK_.cljs$core$IFn$_invoke$arity$1(G__7158),cljs.core.cst$kw$coerced_DASH_value.cljs$core$IFn$_invoke$arity$1(G__7158),null,cljs.core.not_empty(extmap__4236__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
rui.forms.core.Form = (function (id,fields,valid_QMARK_,errors,validator,__meta,__extmap,__hash){
this.id = id;
this.fields = fields;
this.valid_QMARK_ = valid_QMARK_;
this.errors = errors;
this.validator = validator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
rui.forms.core.Form.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

rui.forms.core.Form.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k7253,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__7258 = k7253;
var G__7258__$1 = (((G__7258 instanceof cljs.core.Keyword))?G__7258.fqn:null);
switch (G__7258__$1) {
case "id":
return self__.id;

break;
case "fields":
return self__.fields;

break;
case "valid?":
return self__.valid_QMARK_;

break;
case "errors":
return self__.errors;

break;
case "validator":
return self__.validator;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k7253,else__4206__auto__);

}
});

rui.forms.core.Form.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer(writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4218__auto__,pr_pair__4220__auto__,"#rui.forms.core.Form{",", ","}",opts__4219__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fields,self__.fields],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$valid_QMARK_,self__.valid_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$errors,self__.errors],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$validator,self__.validator],null))], null),self__.__extmap));
});

rui.forms.core.Form.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__7252){
var self__ = this;
var G__7252__$1 = this;
return (new cljs.core.RecordIter((0),G__7252__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$fields,cljs.core.cst$kw$valid_QMARK_,cljs.core.cst$kw$errors,cljs.core.cst$kw$validator], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

rui.forms.core.Form.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

rui.forms.core.Form.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,self__.errors,self__.validator,self__.__meta,self__.__extmap,self__.__hash));
});

rui.forms.core.Form.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
});

rui.forms.core.Form.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = (function (){var fexpr__7263 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (-1405164784 ^ cljs.core.hash_unordered_coll(coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
;
return fexpr__7263(this__4199__auto____$1);
})();
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

rui.forms.core.Form.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this7254,other7255){
var self__ = this;
var this7254__$1 = this;
return ((!((other7255 == null))) && ((this7254__$1.constructor === other7255.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this7254__$1.id,other7255.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this7254__$1.fields,other7255.fields)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this7254__$1.valid_QMARK_,other7255.valid_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this7254__$1.errors,other7255.errors)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this7254__$1.validator,other7255.validator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this7254__$1.__extmap,other7255.__extmap)));
});

rui.forms.core.Form.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$errors,null,cljs.core.cst$kw$valid_QMARK_,null,cljs.core.cst$kw$validator,null,cljs.core.cst$kw$fields,null,cljs.core.cst$kw$id,null], null), null),k__4213__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,self__.errors,self__.validator,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4213__auto__)),null));
}
});

rui.forms.core.Form.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__7252){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__7268 = cljs.core.keyword_identical_QMARK_;
var expr__7269 = k__4211__auto__;
if(cljs.core.truth_((function (){var G__7271 = cljs.core.cst$kw$id;
var G__7272 = expr__7269;
return (pred__7268.cljs$core$IFn$_invoke$arity$2 ? pred__7268.cljs$core$IFn$_invoke$arity$2(G__7271,G__7272) : pred__7268.call(null,G__7271,G__7272));
})())){
return (new rui.forms.core.Form(G__7252,self__.fields,self__.valid_QMARK_,self__.errors,self__.validator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__7273 = cljs.core.cst$kw$fields;
var G__7274 = expr__7269;
return (pred__7268.cljs$core$IFn$_invoke$arity$2 ? pred__7268.cljs$core$IFn$_invoke$arity$2(G__7273,G__7274) : pred__7268.call(null,G__7273,G__7274));
})())){
return (new rui.forms.core.Form(self__.id,G__7252,self__.valid_QMARK_,self__.errors,self__.validator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__7276 = cljs.core.cst$kw$valid_QMARK_;
var G__7277 = expr__7269;
return (pred__7268.cljs$core$IFn$_invoke$arity$2 ? pred__7268.cljs$core$IFn$_invoke$arity$2(G__7276,G__7277) : pred__7268.call(null,G__7276,G__7277));
})())){
return (new rui.forms.core.Form(self__.id,self__.fields,G__7252,self__.errors,self__.validator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__7278 = cljs.core.cst$kw$errors;
var G__7279 = expr__7269;
return (pred__7268.cljs$core$IFn$_invoke$arity$2 ? pred__7268.cljs$core$IFn$_invoke$arity$2(G__7278,G__7279) : pred__7268.call(null,G__7278,G__7279));
})())){
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,G__7252,self__.validator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__7280 = cljs.core.cst$kw$validator;
var G__7281 = expr__7269;
return (pred__7268.cljs$core$IFn$_invoke$arity$2 ? pred__7268.cljs$core$IFn$_invoke$arity$2(G__7280,G__7281) : pred__7268.call(null,G__7280,G__7281));
})())){
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,self__.errors,G__7252,self__.__meta,self__.__extmap,null));
} else {
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,self__.errors,self__.validator,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4211__auto__,G__7252),null));
}
}
}
}
}
});

rui.forms.core.Form.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fields,self__.fields,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$valid_QMARK_,self__.valid_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$errors,self__.errors,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$validator,self__.validator,null))], null),self__.__extmap));
});

rui.forms.core.Form.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__7252){
var self__ = this;
var this__4202__auto____$1 = this;
return (new rui.forms.core.Form(self__.id,self__.fields,self__.valid_QMARK_,self__.errors,self__.validator,G__7252,self__.__extmap,self__.__hash));
});

rui.forms.core.Form.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

rui.forms.core.Form.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id,cljs.core.cst$sym$fields,cljs.core.cst$sym$valid_QMARK_,cljs.core.cst$sym$errors,cljs.core.cst$sym$validator], null);
});

rui.forms.core.Form.cljs$lang$type = true;

rui.forms.core.Form.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"rui.forms.core/Form",null,(1),null));
});

rui.forms.core.Form.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write(writer__4241__auto__,"rui.forms.core/Form");
});

/**
 * Positional factory function for rui.forms.core/Form.
 */
rui.forms.core.__GT_Form = (function rui$forms$core$__GT_Form(id,fields,valid_QMARK_,errors,validator){
return (new rui.forms.core.Form(id,fields,valid_QMARK_,errors,validator,null,null,null));
});

/**
 * Factory function for rui.forms.core/Form, taking a map of keywords to field values.
 */
rui.forms.core.map__GT_Form = (function rui$forms$core$map__GT_Form(G__7257){
var extmap__4236__auto__ = (function (){var G__7286 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__7257,cljs.core.cst$kw$id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$fields,cljs.core.cst$kw$valid_QMARK_,cljs.core.cst$kw$errors,cljs.core.cst$kw$validator], 0));
if(cljs.core.record_QMARK_(G__7257)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__7286);
} else {
return G__7286;
}
})();
return (new rui.forms.core.Form(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__7257),cljs.core.cst$kw$fields.cljs$core$IFn$_invoke$arity$1(G__7257),cljs.core.cst$kw$valid_QMARK_.cljs$core$IFn$_invoke$arity$1(G__7257),cljs.core.cst$kw$errors.cljs$core$IFn$_invoke$arity$1(G__7257),cljs.core.cst$kw$validator.cljs$core$IFn$_invoke$arity$1(G__7257),null,cljs.core.not_empty(extmap__4236__auto__),null));
});

rui.forms.core.gen_field_id = (function rui$forms$core$gen_field_id(form,field_name){
var G__7298 = "%s_%s";
var G__7299 = cljs.core.name(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(form));
var G__7300 = cljs.core.name(field_name);
return goog.string.format(G__7298,G__7299,G__7300);
});
/**
 * Return a `Form` by a given `id` in the `db`.
 */
rui.forms.core.db__GT_form = (function rui$forms$core$db__GT_form(db,id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_forms,id], null));
});
/**
 * Initializes a `Field` by `id`, or `value` with default values.
 */
rui.forms.core.init_field = (function rui$forms$core$init_field(var_args){
var G__7302 = arguments.length;
switch (G__7302) {
case 1:
return rui.forms.core.init_field.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return rui.forms.core.init_field.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

rui.forms.core.init_field.cljs$core$IFn$_invoke$arity$1 = (function (id){
return rui.forms.core.init_field.cljs$core$IFn$_invoke$arity$2(id,null);
});

rui.forms.core.init_field.cljs$core$IFn$_invoke$arity$2 = (function (id,value){
return rui.forms.core.__GT_Field(id,value,false,cljs.core.cst$kw$initial,false,false,value);
});

rui.forms.core.init_field.cljs$lang$maxFixedArity = 2;

/**
 * Creates a `Form` from a given `map`.
 */
rui.forms.core.create_form = (function rui$forms$core$create_form(form_map,init_values){
return rui.forms.core.map__GT_Form(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fields,cljs.core.reduce_kv((function (fields,field_id,init_value){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(fields,field_id,rui.forms.core.init_field.cljs$core$IFn$_invoke$arity$2(field_id,init_value));
}),cljs.core.PersistentArrayMap.EMPTY,init_values),cljs.core.cst$kw$errors,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$valid_QMARK_,false], null),form_map], 0)));
});
/**
 * Returns a field's state as a `string`.
 */
rui.forms.core.field_state = (function rui$forms$core$field_state(form,id){
var state = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1((function (){var G__7306 = cljs.core.cst$kw$fields.cljs$core$IFn$_invoke$arity$1(form);
return (id.cljs$core$IFn$_invoke$arity$1 ? id.cljs$core$IFn$_invoke$arity$1(G__7306) : id.call(null,G__7306));
})());
if((state == null)){
return "";
} else {
return cljs.core.name(state);
}
});
rui.forms.core.form__GT__STAR_values = (function rui$forms$core$form__GT__STAR_values(key_name,form){
return cljs.core.reduce_kv((function (values,id,field){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(values,id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(field,key_name));
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$fields.cljs$core$IFn$_invoke$arity$1(form));
});
rui.forms.core.form__GT_values = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(rui.forms.core.form__GT__STAR_values,cljs.core.cst$kw$value);
rui.forms.core.form__GT_coerced_values = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(rui.forms.core.form__GT__STAR_values,cljs.core.cst$kw$coerced_DASH_value);
rui.forms.core.update_validated_fields = (function rui$forms$core$update_validated_fields(errors,update_coerced_value,fields){
return cljs.core.reduce_kv((function (fields__$1,id,field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(fields__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,cljs.core.cst$kw$valid_QMARK_], null),!(cljs.core.contains_QMARK_(errors,id))),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,cljs.core.cst$kw$coerced_DASH_value], null),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(update_coerced_value,id));
}),fields,fields);
});
/**
 * Validates a given `form` by its validator. It returns new form with updated values:
 * - `errors`
 * - `valid?`
 * - every field's `valid?` is updated too and field's `value` if coerced
 */
rui.forms.core.validate_form = (function rui$forms$core$validate_form(form){
var field_values = (rui.forms.core.form__GT_values.cljs$core$IFn$_invoke$arity$1 ? rui.forms.core.form__GT_values.cljs$core$IFn$_invoke$arity$1(form) : rui.forms.core.form__GT_values.call(null,form));
var validator = cljs.core.cst$kw$validator.cljs$core$IFn$_invoke$arity$1(form);
var validator_result = (validator.cljs$core$IFn$_invoke$arity$1 ? validator.cljs$core$IFn$_invoke$arity$1(field_values) : validator.call(null,field_values));
var vec__7315 = ((cljs.core.vector_QMARK_(validator_result))?validator_result:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [validator_result,null], null));
var errors = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7315,(0),null);
var model = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7315,(1),null);
var update_coerced_value = ((function (field_values,validator,validator_result,vec__7315,errors,model){
return (function (id,old_value){
var temp__5459__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(model,id);
if((temp__5459__auto__ == null)){
return old_value;
} else {
var new_value = temp__5459__auto__;
return new_value;
}
});})(field_values,validator,validator_result,vec__7315,errors,model))
;
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(form,cljs.core.cst$kw$errors,errors),cljs.core.cst$kw$valid_QMARK_,cljs.core.empty_QMARK_(errors)),cljs.core.cst$kw$fields,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(rui.forms.core.update_validated_fields,errors,update_coerced_value));
});
/**
 * Initializes a form in the `db` within `form-map` and `initial-values`
 */
rui.forms.core.init_form = (function rui$forms$core$init_form(db,form_map,initial_values){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_forms,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(form_map)], null),rui.forms.core.create_form(form_map,initial_values)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_forms,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(form_map)], null),rui.forms.core.validate_form);
});
/**
 * Disssoc forms from the `db` by given `ids`
 */
rui.forms.core.dissoc_forms = (function rui$forms$core$dissoc_forms(db,ids){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.update,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [db,cljs.core.cst$kw$rui_COLON__COLON_forms,cljs.core.dissoc], null),ids));
});
/**
 * Assocs a given `value` into the `db` by a given `form-id` and `field-id`
 */
rui.forms.core.assoc_field_value = (function rui$forms$core$assoc_field_value(db,form_id,field_id,value){
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_forms,form_id,cljs.core.cst$kw$fields,field_id,cljs.core.cst$kw$value], null),value);
});
/**
 * Assocs a given `values` into the `db` by a given `form-id`
 */
rui.forms.core.assoc_values = (function rui$forms$core$assoc_values(db,form_id,values){
return cljs.core.reduce_kv((function (db__$1,field_id,value){
return rui.forms.core.assoc_field_value(db__$1,form_id,field_id,value);
}),db,values);
});
/**
 * Adds a given `errors` into the `db` by a given `form-id`.
 * The `errors` should be a map with vectors
 */
rui.forms.core.add_form_errors = (function rui$forms$core$add_form_errors(db,form_id,errors){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_forms,form_id,cljs.core.cst$kw$errors], null),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.into),errors),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_forms,form_id,cljs.core.cst$kw$valid_QMARK_], null),false),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_forms,form_id,cljs.core.cst$kw$fields], null),(function (p1__7334_SHARP_){
return cljs.core.reduce_kv((function (fields,k,_){
if(cljs.core.contains_QMARK_(errors,k)){
return cljs.core.assoc_in(fields,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.cst$kw$state], null),cljs.core.cst$kw$invalid);
} else {
return fields;
}
}),p1__7334_SHARP_,p1__7334_SHARP_);
}));
});
/**
 * Takes a response's body as errors and assoc them in the `db` by a `form-id`.
 * The `errors` should be a map with vectors
 */
rui.forms.core.form_errors_LT_response = (function rui$forms$core$form_errors_LT_response(db,form_id,errors){
return rui.forms.core.add_form_errors(db,form_id,cljs.core.cst$kw$errors.cljs$core$IFn$_invoke$arity$1(errors));
});
/**
 * Dispatches a input's on-change event. Optionally takes a `formatter` function that takes a new values and returns
 * formatter value.
 */
rui.forms.core.input_on_change_BANG_ = (function rui$forms$core$input_on_change_BANG_(var_args){
var G__7343 = arguments.length;
switch (G__7343) {
case 4:
return rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (form,id,formatter,event){
var G__7347 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_forms_SLASH_forms_DASH_input_DASH_changed,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(form),id,(function (){var G__7348 = event.target.value;
return (formatter.cljs$core$IFn$_invoke$arity$1 ? formatter.cljs$core$IFn$_invoke$arity$1(G__7348) : formatter.call(null,G__7348));
})()], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__7347) : re_frame.core.dispatch.call(null,G__7347));
});

rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (form,id,event){
return rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$4(form,id,cljs.core.identity,event);
});

rui.forms.core.input_on_change_BANG_.cljs$lang$maxFixedArity = 4;

/**
 * Dispatches a input's on-blur event
 */
rui.forms.core.input_on_blur_BANG_ = (function rui$forms$core$input_on_blur_BANG_(form,id,event){
var G__7356 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_forms_SLASH_forms_DASH_input_DASH_blured,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(form),id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__7356) : re_frame.core.dispatch.call(null,G__7356));
});
/**
 * Initializes a form in DB by a given `form-id` with a `validator` function that takes a map of fields values
 * and returns a map of vectors as errors or `nil`. Optionally takes an `initial-values` map.
 */
rui.forms.core.init_form_BANG_ = (function rui$forms$core$init_form_BANG_(var_args){
var G__7358 = arguments.length;
switch (G__7358) {
case 2:
return rui.forms.core.init_form_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return rui.forms.core.init_form_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

rui.forms.core.init_form_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (form_id,validator){
return rui.forms.core.init_form_BANG_.cljs$core$IFn$_invoke$arity$3(form_id,validator,cljs.core.PersistentArrayMap.EMPTY);
});

rui.forms.core.init_form_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (form_id,validator,initial_values){
var G__7359 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_forms_SLASH_init_DASH_form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$id,form_id,cljs.core.cst$kw$validator,validator], null),initial_values], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__7359) : re_frame.core.dispatch.call(null,G__7359));
});

rui.forms.core.init_form_BANG_.cljs$lang$maxFixedArity = 3;

