// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('rui.forms.components');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('ccn.core');
goog.require('re_frame.core');
goog.require('rui.buttons');
goog.require('rui.forms.core');
goog.require('rui.forms.events');
rui.forms.components.default_required_mark = " *";
rui.forms.components.field__GT_twbs_class = (function rui$forms$components$field__GT_twbs_class(field){
var G__3952 = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(field);
var G__3952__$1 = (((G__3952 instanceof cljs.core.Keyword))?G__3952.fqn:null);
switch (G__3952__$1) {
case "initial":
return null;

break;
case "invalid":
return "is-invalid";

break;
case "valid":
return "is-valid";

break;
default:
return null;

}
});
rui.forms.components.form_errors = (function rui$forms$components$form_errors(messages){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$form_DASH_errors$invalid_DASH_feedback,(function (){var iter__4324__auto__ = (function rui$forms$components$form_errors_$_iter__3955(s__3956){
return (new cljs.core.LazySeq(null,(function (){
var s__3956__$1 = s__3956;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__3956__$1);
if(temp__5457__auto__){
var s__3956__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__3956__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__3956__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__3958 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__3957 = (0);
while(true){
if((i__3957 < size__4323__auto__)){
var vec__3959 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__3957);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3959,(0),null);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3959,(1),null);
cljs.core.chunk_append(b__3958,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,ccn.core.bem.cljs$core$IFn$_invoke$arity$3("form-errors","error",cljs.core.PersistentVector.EMPTY)], null),message], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,goog.string.format("%s-%s",message,i)], null)));

var G__3969 = (i__3957 + (1));
i__3957 = G__3969;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__3958),rui$forms$components$form_errors_$_iter__3955(cljs.core.chunk_rest(s__3956__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__3958),null);
}
} else {
var vec__3962 = cljs.core.first(s__3956__$2);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3962,(0),null);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3962,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,ccn.core.bem.cljs$core$IFn$_invoke$arity$3("form-errors","error",cljs.core.PersistentVector.EMPTY)], null),message], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,goog.string.format("%s-%s",message,i)], null)),rui$forms$components$form_errors_$_iter__3955(cljs.core.rest(s__3956__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4324__auto__(cljs.core.zipmap(messages,cljs.core.range.cljs$core$IFn$_invoke$arity$0()));
})()], null);
});
rui.forms.components.can_show_errors_QMARK_ = (function rui$forms$components$can_show_errors_QMARK_(field,errors){
return ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$initial,cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(field))) && (cljs.core.seq(errors)));
});
/**
 * Bare radio input that renders just a div with an input type radio and label. Don't use it directly.
 */
rui.forms.components.radio_input_element = (function rui$forms$components$radio_input_element(p__3974){
var map__3975 = p__3974;
var map__3975__$1 = ((((!((map__3975 == null)))?(((((map__3975.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3975.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3975):map__3975);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3975__$1,cljs.core.cst$kw$form);
var field_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3975__$1,cljs.core.cst$kw$field_DASH_id);
var choice = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3975__$1,cljs.core.cst$kw$choice);
var disabled_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3975__$1,cljs.core.cst$kw$disabled_QMARK_);
var on_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3975__$1,cljs.core.cst$kw$on_DASH_change);
var checked_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3975__$1,cljs.core.cst$kw$checked_QMARK_);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3975__$1,cljs.core.cst$kw$field);
var modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3975__$1,cljs.core.cst$kw$modifiers);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3975__$1,cljs.core.cst$kw$label);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3975__$1,cljs.core.cst$kw$id);
var radio_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3975__$1,cljs.core.cst$kw$radio_DASH_name);
var chosen_value_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(choice),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(field));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["form-check",(cljs.core.truth_(disabled_QMARK_)?"disabled":null),ccn.core.bem.cljs$core$IFn$_invoke$arity$2("radio",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(modifiers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [((chosen_value_QMARK_)?rui.forms.core.field_state(form,field_id):null)], null)))], 0))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$type,"radio",cljs.core.cst$kw$class,ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["form-check-input",((chosen_value_QMARK_)?rui.forms.components.field__GT_twbs_class(field):null)], 0)),cljs.core.cst$kw$id,id,cljs.core.cst$kw$name,radio_name,cljs.core.cst$kw$value,cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(choice),cljs.core.cst$kw$on_DASH_change,on_change,cljs.core.cst$kw$checked,checked_QMARK_,cljs.core.cst$kw$disabled,disabled_QMARK_], null)], null),label], null);
});
/**
 * Radio input field with all functionalities like: updating value, showing an error, ...
 * Required parameters:
 * - `form` a form from the state
 * - `field-id` field is as a keyword
 * - `choices` a all possible values of the radio, a sequence of maps with `:label` and `:value` keys
 * Optional parameters:
 * - `modifiers` a CSS modifiers, a sequence of strings
 * - `component-class-name` a string that is added to 'form-group' Bootstrap element
 * - `renderer` a custom radio renderer, Reagent component that accepts a hashmap with following keys:
 *    id, field, radio-name, choice, on-change, checked?, disabled?, label, modifiers, form, field-id, input-el
 * - `on-change` a custom handler that is called after the original on-change handler
 *   - `required-mark` a valid Hiccup what will be shown when a field is required
 */
rui.forms.components.radio = (function rui$forms$components$radio(var_args){
var args__4534__auto__ = [];
var len__4531__auto___4012 = arguments.length;
var i__4532__auto___4013 = (0);
while(true){
if((i__4532__auto___4013 < len__4531__auto___4012)){
args__4534__auto__.push((arguments[i__4532__auto___4013]));

var G__4014 = (i__4532__auto___4013 + (1));
i__4532__auto___4013 = G__4014;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.radio.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.radio.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,choices,p__3992){
var map__3993 = p__3992;
var map__3993__$1 = ((((!((map__3993 == null)))?(((((map__3993.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3993.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3993):map__3993);
var modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3993__$1,cljs.core.cst$kw$modifiers);
var component_class_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3993__$1,cljs.core.cst$kw$component_DASH_class_DASH_name);
var renderer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3993__$1,cljs.core.cst$kw$renderer);
var on_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3993__$1,cljs.core.cst$kw$on_DASH_change);
var required_mark = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__3993__$1,cljs.core.cst$kw$required_DASH_mark,rui.forms.components.default_required_mark);
var field = (function (){var G__3995 = cljs.core.cst$kw$fields.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__3995) : field_id.call(null,G__3995));
})();
var errors = (function (){var G__3996 = cljs.core.cst$kw$errors.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__3996) : field_id.call(null,G__3996));
})();
var on_change_internal = ((function (field,errors,map__3993,map__3993__$1,modifiers,component_class_name,renderer,on_change,required_mark){
return (function (was_keyword_QMARK_,event){
rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$4(form,field_id,(cljs.core.truth_(was_keyword_QMARK_)?cljs.core.keyword:cljs.core.identity),event);

rui.forms.core.input_on_blur_BANG_(form,field_id,event);

event.preventDefault();

if(cljs.core.truth_(on_change)){
return (on_change.cljs$core$IFn$_invoke$arity$1 ? on_change.cljs$core$IFn$_invoke$arity$1(event) : on_change.call(null,event));
} else {
return null;
}
});})(field,errors,map__3993,map__3993__$1,modifiers,component_class_name,renderer,on_change,required_mark))
;
var radio_name = rui.forms.core.gen_field_id(form,field_id);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["form-group","radio",component_class_name], 0))], null),(function (){var iter__4324__auto__ = ((function (field,errors,on_change_internal,radio_name,map__3993,map__3993__$1,modifiers,component_class_name,renderer,on_change,required_mark){
return (function rui$forms$components$iter__4002(s__4003){
return (new cljs.core.LazySeq(null,((function (field,errors,on_change_internal,radio_name,map__3993,map__3993__$1,modifiers,component_class_name,renderer,on_change,required_mark){
return (function (){
var s__4003__$1 = s__4003;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__4003__$1);
if(temp__5457__auto__){
var s__4003__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__4003__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__4003__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__4005 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__4004 = (0);
while(true){
if((i__4004 < size__4323__auto__)){
var choice = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__4004);
cljs.core.chunk_append(b__4005,(function (){var id = rui.forms.core.gen_field_id(form,cljs.core.name([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(field_id)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(choice))].join(''))].join('')));
var disabled_QMARK_ = cljs.core.cst$kw$disabled_QMARK_.cljs$core$IFn$_invoke$arity$1(choice) === true;
var checked_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(field),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(choice))) || ((((cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(field) == null)) && (cljs.core.cst$kw$checked_QMARK_.cljs$core$IFn$_invoke$arity$1(choice) === true))));
var label = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,"form-check-label",cljs.core.cst$kw$for,id], null),cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(choice),(cljs.core.truth_(cljs.core.cst$kw$required_QMARK_.cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null);
var input_opts = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$checked_QMARK_,cljs.core.cst$kw$field,cljs.core.cst$kw$modifiers,cljs.core.cst$kw$id,cljs.core.cst$kw$radio_DASH_name,cljs.core.cst$kw$form,cljs.core.cst$kw$field_DASH_id,cljs.core.cst$kw$choice,cljs.core.cst$kw$on_DASH_change,cljs.core.cst$kw$disabled_QMARK_],[checked_QMARK_,field,modifiers,id,radio_name,form,field_id,choice,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(on_change_internal,(cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(choice) instanceof cljs.core.Keyword)),disabled_QMARK_]);
var input_el = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.radio_input_element,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([input_opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,(cljs.core.truth_(renderer)?null:label)], null)], 0))], null);
if(!((renderer == null))){
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [renderer,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([input_opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$input_DASH_el,input_el], null)], 0))], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(choice)], null));
} else {
return cljs.core.with_meta(input_el,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(choice)], null));
}
})());

var G__4032 = (i__4004 + (1));
i__4004 = G__4032;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__4005),rui$forms$components$iter__4002(cljs.core.chunk_rest(s__4003__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__4005),null);
}
} else {
var choice = cljs.core.first(s__4003__$2);
return cljs.core.cons((function (){var id = rui.forms.core.gen_field_id(form,cljs.core.name([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(field_id)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(choice))].join(''))].join('')));
var disabled_QMARK_ = cljs.core.cst$kw$disabled_QMARK_.cljs$core$IFn$_invoke$arity$1(choice) === true;
var checked_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(field),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(choice))) || ((((cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(field) == null)) && (cljs.core.cst$kw$checked_QMARK_.cljs$core$IFn$_invoke$arity$1(choice) === true))));
var label = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,"form-check-label",cljs.core.cst$kw$for,id], null),cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(choice),(cljs.core.truth_(cljs.core.cst$kw$required_QMARK_.cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null);
var input_opts = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$checked_QMARK_,cljs.core.cst$kw$field,cljs.core.cst$kw$modifiers,cljs.core.cst$kw$id,cljs.core.cst$kw$radio_DASH_name,cljs.core.cst$kw$form,cljs.core.cst$kw$field_DASH_id,cljs.core.cst$kw$choice,cljs.core.cst$kw$on_DASH_change,cljs.core.cst$kw$disabled_QMARK_],[checked_QMARK_,field,modifiers,id,radio_name,form,field_id,choice,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(on_change_internal,(cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(choice) instanceof cljs.core.Keyword)),disabled_QMARK_]);
var input_el = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.radio_input_element,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([input_opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,(cljs.core.truth_(renderer)?null:label)], null)], 0))], null);
if(!((renderer == null))){
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [renderer,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([input_opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$input_DASH_el,input_el], null)], 0))], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(choice)], null));
} else {
return cljs.core.with_meta(input_el,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(choice)], null));
}
})(),rui$forms$components$iter__4002(cljs.core.rest(s__4003__$2)));
}
} else {
return null;
}
break;
}
});})(field,errors,on_change_internal,radio_name,map__3993,map__3993__$1,modifiers,component_class_name,renderer,on_change,required_mark))
,null,null));
});})(field,errors,on_change_internal,radio_name,map__3993,map__3993__$1,modifiers,component_class_name,renderer,on_change,required_mark))
;
return iter__4324__auto__(choices);
})(),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_(field,errors))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,errors], null):null)], null);
});

rui.forms.components.radio.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.radio.cljs$lang$applyTo = (function (seq3988){
var G__3989 = cljs.core.first(seq3988);
var seq3988__$1 = cljs.core.next(seq3988);
var G__3990 = cljs.core.first(seq3988__$1);
var seq3988__$2 = cljs.core.next(seq3988__$1);
var G__3991 = cljs.core.first(seq3988__$2);
var seq3988__$3 = cljs.core.next(seq3988__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3989,G__3990,G__3991,seq3988__$3);
});

rui.forms.components.checkbox = (function rui$forms$components$checkbox(var_args){
var args__4534__auto__ = [];
var len__4531__auto___4048 = arguments.length;
var i__4532__auto___4049 = (0);
while(true){
if((i__4532__auto___4049 < len__4531__auto___4048)){
args__4534__auto__.push((arguments[i__4532__auto___4049]));

var G__4050 = (i__4532__auto___4049 + (1));
i__4532__auto___4049 = G__4050;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.checkbox.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.checkbox.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__4040){
var map__4041 = p__4040;
var map__4041__$1 = ((((!((map__4041 == null)))?(((((map__4041.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4041.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4041):map__4041);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4041__$1,cljs.core.cst$kw$children,cljs.core.PersistentVector.EMPTY);
var modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4041__$1,cljs.core.cst$kw$modifiers,cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4041__$1,cljs.core.cst$kw$attrs,cljs.core.PersistentArrayMap.EMPTY);
var on_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4041__$1,cljs.core.cst$kw$on_DASH_change);
var required_mark = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4041__$1,cljs.core.cst$kw$required_DASH_mark,rui.forms.components.default_required_mark);
var field = (function (){var G__4043 = cljs.core.cst$kw$fields.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4043) : field_id.call(null,G__4043));
})();
var active_QMARK_ = cljs.core.boolean$(cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(field));
var errors = (function (){var G__4044 = cljs.core.cst$kw$errors.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4044) : field_id.call(null,G__4044));
})();
var on_change_internal = ((function (field,active_QMARK_,errors,map__4041,map__4041__$1,children,modifiers,attrs,on_change,required_mark){
return (function (event){
var G__4045_4053 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rui_COLON__COLON_forms_SLASH_forms_DASH_input_DASH_changed,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(form),field_id,event.target.checked], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__4045_4053) : re_frame.core.dispatch.call(null,G__4045_4053));

rui.forms.core.input_on_blur_BANG_(form,field_id,event);

if(cljs.core.truth_(on_change)){
return (on_change.cljs$core$IFn$_invoke$arity$1 ? on_change.cljs$core$IFn$_invoke$arity$1(event) : on_change.call(null,event));
} else {
return null;
}
});})(field,active_QMARK_,errors,map__4041,map__4041__$1,children,modifiers,attrs,on_change,required_mark))
;
var id = rui.forms.core.gen_field_id(form,field_id);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["form-check","form-group",ccn.core.bem.cljs$core$IFn$_invoke$arity$2("checkbox",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(modifiers,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((active_QMARK_)?"active":null),rui.forms.core.field_state(form,field_id)], null)))], 0))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$class,ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["form-check-input",rui.forms.components.field__GT_twbs_class(field)], 0)),cljs.core.cst$kw$id,id,cljs.core.cst$kw$name,id,cljs.core.cst$kw$on_DASH_change,on_change_internal,cljs.core.cst$kw$checked,active_QMARK_], null),attrs], 0))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$for,id,cljs.core.cst$kw$class,"form-check-label"], null),label,(cljs.core.truth_(cljs.core.cst$kw$required_QMARK_.cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(children,(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_(field,errors))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,errors], null):null)));
});

rui.forms.components.checkbox.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.checkbox.cljs$lang$applyTo = (function (seq4036){
var G__4037 = cljs.core.first(seq4036);
var seq4036__$1 = cljs.core.next(seq4036);
var G__4038 = cljs.core.first(seq4036__$1);
var seq4036__$2 = cljs.core.next(seq4036__$1);
var G__4039 = cljs.core.first(seq4036__$2);
var seq4036__$3 = cljs.core.next(seq4036__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4037,G__4038,G__4039,seq4036__$3);
});

rui.forms.components.select = (function rui$forms$components$select(var_args){
var args__4534__auto__ = [];
var len__4531__auto___4074 = arguments.length;
var i__4532__auto___4075 = (0);
while(true){
if((i__4532__auto___4075 < len__4531__auto___4074)){
args__4534__auto__.push((arguments[i__4532__auto___4075]));

var G__4076 = (i__4532__auto___4075 + (1));
i__4532__auto___4075 = G__4076;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((4) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((4)),(0),null)):null);
return rui.forms.components.select.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4535__auto__);
});

rui.forms.components.select.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,value_label_pairs,p__4059){
var map__4060 = p__4059;
var map__4060__$1 = ((((!((map__4060 == null)))?(((((map__4060.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4060.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4060):map__4060);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4060__$1,cljs.core.cst$kw$children,cljs.core.PersistentVector.EMPTY);
var modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4060__$1,cljs.core.cst$kw$modifiers,cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4060__$1,cljs.core.cst$kw$attrs,cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4060__$1,cljs.core.cst$kw$label_DASH_attrs,cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4060__$1,cljs.core.cst$kw$twbs_DASH_modifiers,cljs.core.PersistentVector.EMPTY);
var on_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4060__$1,cljs.core.cst$kw$on_DASH_change);
var required_mark = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4060__$1,cljs.core.cst$kw$required_DASH_mark,rui.forms.components.default_required_mark);
var field = (function (){var G__4062 = cljs.core.cst$kw$fields.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4062) : field_id.call(null,G__4062));
})();
var active_QMARK_ = !((cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(field) == null));
var errors = (function (){var G__4063 = cljs.core.cst$kw$errors.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4063) : field_id.call(null,G__4063));
})();
var on_change_internal = ((function (field,active_QMARK_,errors,map__4060,map__4060__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark){
return (function (was_keyword_QMARK_,event){
rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$4(form,field_id,(cljs.core.truth_(was_keyword_QMARK_)?cljs.core.keyword:cljs.core.identity),event);

rui.forms.core.input_on_blur_BANG_(form,field_id,event);

if(cljs.core.truth_(on_change)){
return (on_change.cljs$core$IFn$_invoke$arity$1 ? on_change.cljs$core$IFn$_invoke$arity$1(event) : on_change.call(null,event));
} else {
return null;
}
});})(field,active_QMARK_,errors,map__4060,map__4060__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark))
;
var id = rui.forms.core.gen_field_id(form,field_id);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["form-group",ccn.core.bem.cljs$core$IFn$_invoke$arity$2("select",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(modifiers,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((active_QMARK_)?"active":null),rui.forms.core.field_state(form,field_id)], null)))], 0))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$for,id,cljs.core.cst$kw$class,"form-control-label"], null),label_attrs], 0)),label,(cljs.core.truth_(cljs.core.cst$kw$required_QMARK_.cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$id,id,cljs.core.cst$kw$name,id,cljs.core.cst$kw$on_DASH_change,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(on_change_internal,cljs.core.every_QMARK_(cljs.core.keyword_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,value_label_pairs))),cljs.core.cst$kw$class,ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ccn.core.twbs("form-control",twbs_modifiers),rui.forms.components.field__GT_twbs_class(field)], 0))], null),attrs,((!((cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(field) == null)))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$default_DASH_value,cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(field)], null):null)], 0)),(function (){var iter__4324__auto__ = ((function (field,active_QMARK_,errors,on_change_internal,id,map__4060,map__4060__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark){
return (function rui$forms$components$iter__4064(s__4065){
return (new cljs.core.LazySeq(null,((function (field,active_QMARK_,errors,on_change_internal,id,map__4060,map__4060__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark){
return (function (){
var s__4065__$1 = s__4065;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__4065__$1);
if(temp__5457__auto__){
var s__4065__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__4065__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__4065__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__4067 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__4066 = (0);
while(true){
if((i__4066 < size__4323__auto__)){
var vec__4068 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__4066);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4068,(0),null);
var label__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4068,(1),null);
cljs.core.chunk_append(b__4067,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,value], null),label__$1], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,value], null)));

var G__4077 = (i__4066 + (1));
i__4066 = G__4077;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__4067),rui$forms$components$iter__4064(cljs.core.chunk_rest(s__4065__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__4067),null);
}
} else {
var vec__4071 = cljs.core.first(s__4065__$2);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4071,(0),null);
var label__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4071,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,value], null),label__$1], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,value], null)),rui$forms$components$iter__4064(cljs.core.rest(s__4065__$2)));
}
} else {
return null;
}
break;
}
});})(field,active_QMARK_,errors,on_change_internal,id,map__4060,map__4060__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark))
,null,null));
});})(field,active_QMARK_,errors,on_change_internal,id,map__4060,map__4060__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark))
;
return iter__4324__auto__(value_label_pairs);
})()], null)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(children,(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_(field,errors))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,errors], null):null)));
});

rui.forms.components.select.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
rui.forms.components.select.cljs$lang$applyTo = (function (seq4054){
var G__4055 = cljs.core.first(seq4054);
var seq4054__$1 = cljs.core.next(seq4054);
var G__4056 = cljs.core.first(seq4054__$1);
var seq4054__$2 = cljs.core.next(seq4054__$1);
var G__4057 = cljs.core.first(seq4054__$2);
var seq4054__$3 = cljs.core.next(seq4054__$2);
var G__4058 = cljs.core.first(seq4054__$3);
var seq4054__$4 = cljs.core.next(seq4054__$3);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4055,G__4056,G__4057,G__4058,seq4054__$4);
});

/**
 * Input field with all functionalities like: updating value, showing an error, ...
 * Required parameters:
 * - `input-type` a string like: 'text', 'number', ...
 * - `form` a form from the state
 * - `field-id` field is as a keyword
 * - `label` a Reagent valid component or string
 * Optional parameters:
 * - `modifiers` a CSS modifiers, a sequence of strings
 * - `attrs` a hashmap of HTML attributes of the input
 * - `label-attrs` a hashmap of HTML attributes for the label
 * - `twbs-modifiers` Twitter Bootstrap modifiers, a sequence of strings
 * - `input-group-append` a Twitter Bootstrap's 'input-group-append', a Reagent component of string
 * - `input-group-prepend` a Twitter Bootstrap's 'input-group-prepend', a Reagent component of string
 * - `on-change` a custom handler that is called after the original on-change handler
 * - `on-blur` a custom handler that is called after the original on-blur handler
 *   - `required-mark` a valid Hiccup what will be shown when a field is required
 */
rui.forms.components.input_field = (function rui$forms$components$input_field(var_args){
var args__4534__auto__ = [];
var len__4531__auto___4090 = arguments.length;
var i__4532__auto___4091 = (0);
while(true){
if((i__4532__auto___4091 < len__4531__auto___4090)){
args__4534__auto__.push((arguments[i__4532__auto___4091]));

var G__4092 = (i__4532__auto___4091 + (1));
i__4532__auto___4091 = G__4092;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((4) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((4)),(0),null)):null);
return rui.forms.components.input_field.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4535__auto__);
});

rui.forms.components.input_field.cljs$core$IFn$_invoke$arity$variadic = (function (input_type,form,field_id,label,p__4083){
var map__4084 = p__4083;
var map__4084__$1 = ((((!((map__4084 == null)))?(((((map__4084.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4084.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4084):map__4084);
var modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4084__$1,cljs.core.cst$kw$modifiers,cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4084__$1,cljs.core.cst$kw$attrs,cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4084__$1,cljs.core.cst$kw$label_DASH_attrs,cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4084__$1,cljs.core.cst$kw$twbs_DASH_modifiers,cljs.core.PersistentVector.EMPTY);
var input_group_append = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4084__$1,cljs.core.cst$kw$input_DASH_group_DASH_append,null);
var input_group_prepend = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4084__$1,cljs.core.cst$kw$input_DASH_group_DASH_prepend,null);
var on_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4084__$1,cljs.core.cst$kw$on_DASH_change);
var on_blur = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4084__$1,cljs.core.cst$kw$on_DASH_blur);
var required_mark = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4084__$1,cljs.core.cst$kw$required_DASH_mark,rui.forms.components.default_required_mark);
var id = rui.forms.core.gen_field_id(form,field_id);
var field = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$fields,field_id], null));
var on_change_internal = ((function (id,field,map__4084,map__4084__$1,modifiers,attrs,label_attrs,twbs_modifiers,input_group_append,input_group_prepend,on_change,on_blur,required_mark){
return (function (event){
rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$3(form,field_id,event);

if(cljs.core.truth_(on_change)){
return (on_change.cljs$core$IFn$_invoke$arity$1 ? on_change.cljs$core$IFn$_invoke$arity$1(event) : on_change.call(null,event));
} else {
return null;
}
});})(id,field,map__4084,map__4084__$1,modifiers,attrs,label_attrs,twbs_modifiers,input_group_append,input_group_prepend,on_change,on_blur,required_mark))
;
var on_blur_internal = ((function (id,field,on_change_internal,map__4084,map__4084__$1,modifiers,attrs,label_attrs,twbs_modifiers,input_group_append,input_group_prepend,on_change,on_blur,required_mark){
return (function (event){
rui.forms.core.input_on_blur_BANG_(form,field_id,event);

if(cljs.core.truth_(on_blur)){
return (on_blur.cljs$core$IFn$_invoke$arity$1 ? on_blur.cljs$core$IFn$_invoke$arity$1(event) : on_blur.call(null,event));
} else {
return null;
}
});})(id,field,on_change_internal,map__4084,map__4084__$1,modifiers,attrs,label_attrs,twbs_modifiers,input_group_append,input_group_prepend,on_change,on_blur,required_mark))
;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["form-group",ccn.core.bem.cljs$core$IFn$_invoke$arity$3("input-field",cljs.core.name(field_id),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(modifiers,rui.forms.core.field_state(form,field_id)))], 0))], null),((!((label == null)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$for,id,cljs.core.cst$kw$class,"form-control-label"], null),label_attrs], 0)),label,(cljs.core.truth_(cljs.core.cst$kw$required_QMARK_.cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null):null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,(cljs.core.truth_((function (){var or__3949__auto__ = input_group_prepend;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return input_group_append;
}
})())?"input-group":null)], null),((!((input_group_prepend == null)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$input_DASH_group_DASH_prepend,((typeof input_group_prepend === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$input_DASH_group_DASH_text,input_group_prepend], null):input_group_prepend)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$type,input_type,cljs.core.cst$kw$class,ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ccn.core.twbs("form-control",twbs_modifiers),rui.forms.components.field__GT_twbs_class(field)], 0)),cljs.core.cst$kw$id,id,cljs.core.cst$kw$name,id,cljs.core.cst$kw$value,cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((function (){var G__4086 = cljs.core.cst$kw$fields.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4086) : field_id.call(null,G__4086));
})()),cljs.core.cst$kw$placeholder,label,cljs.core.cst$kw$on_DASH_change,on_change_internal,cljs.core.cst$kw$on_DASH_blur,on_blur_internal], null),attrs], 0))], null),((!((input_group_append == null)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$input_DASH_group_DASH_append,((typeof input_group_append === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$input_DASH_group_DASH_text,input_group_append], null):input_group_append)], null):null),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_((function (){var G__4087 = cljs.core.cst$kw$fields.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4087) : field_id.call(null,G__4087));
})(),(function (){var G__4088 = cljs.core.cst$kw$errors.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4088) : field_id.call(null,G__4088));
})()))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,(function (){var G__4089 = cljs.core.cst$kw$errors.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4089) : field_id.call(null,G__4089));
})()], null):null)], null)], null);
});

rui.forms.components.input_field.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
rui.forms.components.input_field.cljs$lang$applyTo = (function (seq4078){
var G__4079 = cljs.core.first(seq4078);
var seq4078__$1 = cljs.core.next(seq4078);
var G__4080 = cljs.core.first(seq4078__$1);
var seq4078__$2 = cljs.core.next(seq4078__$1);
var G__4081 = cljs.core.first(seq4078__$2);
var seq4078__$3 = cljs.core.next(seq4078__$2);
var G__4082 = cljs.core.first(seq4078__$3);
var seq4078__$4 = cljs.core.next(seq4078__$3);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4079,G__4080,G__4081,G__4082,seq4078__$4);
});

rui.forms.components.input_text = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(rui.forms.components.input_field,"text");
rui.forms.components.input_password = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(rui.forms.components.input_field,"password");
rui.forms.components.input_number = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(rui.forms.components.input_field,"number");
rui.forms.components.input_email = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(rui.forms.components.input_field,"email");
rui.forms.components.input_file = (function rui$forms$components$input_file(var_args){
var args__4534__auto__ = [];
var len__4531__auto___4104 = arguments.length;
var i__4532__auto___4105 = (0);
while(true){
if((i__4532__auto___4105 < len__4531__auto___4104)){
args__4534__auto__.push((arguments[i__4532__auto___4105]));

var G__4106 = (i__4532__auto___4105 + (1));
i__4532__auto___4105 = G__4106;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.input_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.input_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__4097){
var map__4098 = p__4097;
var map__4098__$1 = ((((!((map__4098 == null)))?(((((map__4098.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4098.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4098):map__4098);
var kwargs = map__4098__$1;
var modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4098__$1,cljs.core.cst$kw$modifiers);
var attrs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4098__$1,cljs.core.cst$kw$attrs);
var label_attrs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4098__$1,cljs.core.cst$kw$label_DASH_attrs);
var twbs_modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4098__$1,cljs.core.cst$kw$twbs_DASH_modifiers);
var on_blur = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4098__$1,cljs.core.cst$kw$on_DASH_blur);
var on_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4098__$1,cljs.core.cst$kw$on_DASH_change);
var required_mark = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4098__$1,cljs.core.cst$kw$required_DASH_mark,rui.forms.components.default_required_mark);
var id = rui.forms.core.gen_field_id(form,field_id);
var field = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$fields,field_id], null));
var on_change_internal = ((function (id,field,map__4098,map__4098__$1,kwargs,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark){
return (function (event){
rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$3(form,field_id,event);

if(cljs.core.truth_(on_change)){
return (on_change.cljs$core$IFn$_invoke$arity$1 ? on_change.cljs$core$IFn$_invoke$arity$1(event) : on_change.call(null,event));
} else {
return null;
}
});})(id,field,map__4098,map__4098__$1,kwargs,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark))
;
var on_blur_internal = ((function (id,field,on_change_internal,map__4098,map__4098__$1,kwargs,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark){
return (function (event){
rui.forms.core.input_on_blur_BANG_(form,field_id,event);

if(cljs.core.truth_(on_blur)){
return (on_blur.cljs$core$IFn$_invoke$arity$1 ? on_blur.cljs$core$IFn$_invoke$arity$1(event) : on_blur.call(null,event));
} else {
return null;
}
});})(id,field,on_change_internal,map__4098,map__4098__$1,kwargs,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark))
;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["form-group",ccn.core.bem.cljs$core$IFn$_invoke$arity$2("input-field",cljs.core.conj.cljs$core$IFn$_invoke$arity$2(modifiers,rui.forms.core.field_state(form,field_id)))], 0))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$custom_DASH_file,((!((label == null)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$for,id,cljs.core.cst$kw$class,"form-control-label"], null),label_attrs], 0)),label,(cljs.core.truth_(cljs.core.cst$kw$required_QMARK_.cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$type,"file",cljs.core.cst$kw$class,ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ccn.core.twbs("form-control-file",twbs_modifiers),rui.forms.components.field__GT_twbs_class(field)], 0)),cljs.core.cst$kw$id,id,cljs.core.cst$kw$name,id,cljs.core.cst$kw$value,cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((function (){var G__4100 = cljs.core.cst$kw$fields.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4100) : field_id.call(null,G__4100));
})()),cljs.core.cst$kw$placeholder,label,cljs.core.cst$kw$on_DASH_change,on_change_internal,cljs.core.cst$kw$on_DASH_blur,on_blur_internal], null),attrs], 0))], null),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_((function (){var G__4101 = cljs.core.cst$kw$fields.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4101) : field_id.call(null,G__4101));
})(),(function (){var G__4102 = cljs.core.cst$kw$errors.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4102) : field_id.call(null,G__4102));
})()))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,(function (){var G__4103 = cljs.core.cst$kw$errors.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4103) : field_id.call(null,G__4103));
})()], null):null)], null)], null);
});

rui.forms.components.input_file.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.input_file.cljs$lang$applyTo = (function (seq4093){
var G__4094 = cljs.core.first(seq4093);
var seq4093__$1 = cljs.core.next(seq4093);
var G__4095 = cljs.core.first(seq4093__$1);
var seq4093__$2 = cljs.core.next(seq4093__$1);
var G__4096 = cljs.core.first(seq4093__$2);
var seq4093__$3 = cljs.core.next(seq4093__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4094,G__4095,G__4096,seq4093__$3);
});

rui.forms.components.text_area = (function rui$forms$components$text_area(var_args){
var args__4534__auto__ = [];
var len__4531__auto___4118 = arguments.length;
var i__4532__auto___4119 = (0);
while(true){
if((i__4532__auto___4119 < len__4531__auto___4118)){
args__4534__auto__.push((arguments[i__4532__auto___4119]));

var G__4120 = (i__4532__auto___4119 + (1));
i__4532__auto___4119 = G__4120;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.text_area.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.text_area.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__4111){
var map__4112 = p__4111;
var map__4112__$1 = ((((!((map__4112 == null)))?(((((map__4112.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4112.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4112):map__4112);
var modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4112__$1,cljs.core.cst$kw$modifiers,cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4112__$1,cljs.core.cst$kw$attrs,cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4112__$1,cljs.core.cst$kw$label_DASH_attrs,cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4112__$1,cljs.core.cst$kw$twbs_DASH_modifiers,cljs.core.PersistentVector.EMPTY);
var on_blur = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4112__$1,cljs.core.cst$kw$on_DASH_blur);
var on_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4112__$1,cljs.core.cst$kw$on_DASH_change);
var required_mark = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4112__$1,cljs.core.cst$kw$required_DASH_mark,rui.forms.components.default_required_mark);
var id = rui.forms.core.gen_field_id(form,field_id);
var field = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$fields,field_id], null));
var on_change_internal = ((function (id,field,map__4112,map__4112__$1,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark){
return (function (event){
rui.forms.core.input_on_change_BANG_.cljs$core$IFn$_invoke$arity$3(form,field_id,event);

if(cljs.core.truth_(on_change)){
return (on_change.cljs$core$IFn$_invoke$arity$1 ? on_change.cljs$core$IFn$_invoke$arity$1(event) : on_change.call(null,event));
} else {
return null;
}
});})(id,field,map__4112,map__4112__$1,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark))
;
var on_blur_internal = ((function (id,field,on_change_internal,map__4112,map__4112__$1,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark){
return (function (event){
rui.forms.core.input_on_blur_BANG_(form,field_id,event);

if(cljs.core.truth_(on_blur)){
return (on_blur.cljs$core$IFn$_invoke$arity$1 ? on_blur.cljs$core$IFn$_invoke$arity$1(event) : on_blur.call(null,event));
} else {
return null;
}
});})(id,field,on_change_internal,map__4112,map__4112__$1,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark))
;
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["form-group",ccn.core.bem.cljs$core$IFn$_invoke$arity$2("text-area",cljs.core.conj.cljs$core$IFn$_invoke$arity$2(modifiers,rui.forms.core.field_state(form,field_id)))], 0))], null),((!((label == null)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$for,id,cljs.core.cst$kw$class,"form-control-label"], null),label_attrs], 0)),label,(cljs.core.truth_(cljs.core.cst$kw$required_QMARK_.cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$textarea,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$class,ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ccn.core.twbs("form-control",twbs_modifiers),rui.forms.components.field__GT_twbs_class(field)], 0)),cljs.core.cst$kw$id,id,cljs.core.cst$kw$name,id,cljs.core.cst$kw$value,cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((function (){var G__4114 = cljs.core.cst$kw$fields.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4114) : field_id.call(null,G__4114));
})()),cljs.core.cst$kw$placeholder,label,cljs.core.cst$kw$on_DASH_change,on_change_internal,cljs.core.cst$kw$on_DASH_blur,on_blur_internal], null),attrs], 0))], null),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_((function (){var G__4115 = cljs.core.cst$kw$fields.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4115) : field_id.call(null,G__4115));
})(),(function (){var G__4116 = cljs.core.cst$kw$errors.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4116) : field_id.call(null,G__4116));
})()))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,(function (){var G__4117 = cljs.core.cst$kw$errors.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4117) : field_id.call(null,G__4117));
})()], null):null)], null);
});

rui.forms.components.text_area.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.text_area.cljs$lang$applyTo = (function (seq4107){
var G__4108 = cljs.core.first(seq4107);
var seq4107__$1 = cljs.core.next(seq4107);
var G__4109 = cljs.core.first(seq4107__$1);
var seq4107__$2 = cljs.core.next(seq4107__$1);
var G__4110 = cljs.core.first(seq4107__$2);
var seq4107__$3 = cljs.core.next(seq4107__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4108,G__4109,G__4110,seq4107__$3);
});

rui.forms.components.form_wrapper = (function rui$forms$components$form_wrapper(var_args){
var args__4534__auto__ = [];
var len__4531__auto___4127 = arguments.length;
var i__4532__auto___4128 = (0);
while(true){
if((i__4532__auto___4128 < len__4531__auto___4127)){
args__4534__auto__.push((arguments[i__4532__auto___4128]));

var G__4129 = (i__4532__auto___4128 + (1));
i__4532__auto___4128 = G__4129;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return rui.forms.components.form_wrapper.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

rui.forms.components.form_wrapper.cljs$core$IFn$_invoke$arity$variadic = (function (p__4124,children){
var map__4125 = p__4124;
var map__4125__$1 = ((((!((map__4125 == null)))?(((((map__4125.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4125.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4125):map__4125);
var kwargs = map__4125__$1;
var on_submit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4125__$1,cljs.core.cst$kw$on_DASH_submit);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,"form-wrapper",cljs.core.cst$kw$on_DASH_submit,((function (map__4125,map__4125__$1,kwargs,on_submit){
return (function (p1__4121_SHARP_){
p1__4121_SHARP_.preventDefault();

return (on_submit.cljs$core$IFn$_invoke$arity$1 ? on_submit.cljs$core$IFn$_invoke$arity$1(p1__4121_SHARP_) : on_submit.call(null,p1__4121_SHARP_));
});})(map__4125,map__4125__$1,kwargs,on_submit))
], null)], null),children);
});

rui.forms.components.form_wrapper.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
rui.forms.components.form_wrapper.cljs$lang$applyTo = (function (seq4122){
var G__4123 = cljs.core.first(seq4122);
var seq4122__$1 = cljs.core.next(seq4122);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4123,seq4122__$1);
});

rui.forms.components.button_submit = (function rui$forms$components$button_submit(var_args){
var args__4534__auto__ = [];
var len__4531__auto___4136 = arguments.length;
var i__4532__auto___4137 = (0);
while(true){
if((i__4532__auto___4137 < len__4531__auto___4136)){
args__4534__auto__.push((arguments[i__4532__auto___4137]));

var G__4138 = (i__4532__auto___4137 + (1));
i__4532__auto___4137 = G__4138;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((2) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((2)),(0),null)):null);
return rui.forms.components.button_submit.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4535__auto__);
});

rui.forms.components.button_submit.cljs$core$IFn$_invoke$arity$variadic = (function (title,on_click,p__4133){
var map__4134 = p__4133;
var map__4134__$1 = ((((!((map__4134 == null)))?(((((map__4134.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4134.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4134):map__4134);
var kwargs = map__4134__$1;
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.buttons.button_primary,title,on_click], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([kwargs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$modifiers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submit"], null)], null)], 0))));
});

rui.forms.components.button_submit.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
rui.forms.components.button_submit.cljs$lang$applyTo = (function (seq4130){
var G__4131 = cljs.core.first(seq4130);
var seq4130__$1 = cljs.core.next(seq4130);
var G__4132 = cljs.core.first(seq4130__$1);
var seq4130__$2 = cljs.core.next(seq4130__$1);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4131,G__4132,seq4130__$2);
});

rui.forms.components.plaintext = (function rui$forms$components$plaintext(var_args){
var args__4534__auto__ = [];
var len__4531__auto___4147 = arguments.length;
var i__4532__auto___4148 = (0);
while(true){
if((i__4532__auto___4148 < len__4531__auto___4147)){
args__4534__auto__.push((arguments[i__4532__auto___4148]));

var G__4149 = (i__4532__auto___4148 + (1));
i__4532__auto___4148 = G__4149;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.plaintext.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.plaintext.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__4143){
var map__4144 = p__4143;
var map__4144__$1 = ((((!((map__4144 == null)))?(((((map__4144.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4144.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4144):map__4144);
var modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4144__$1,cljs.core.cst$kw$modifiers,cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4144__$1,cljs.core.cst$kw$attrs,cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4144__$1,cljs.core.cst$kw$label_DASH_attrs,cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4144__$1,cljs.core.cst$kw$twbs_DASH_modifiers,cljs.core.PersistentVector.EMPTY);
var id = rui.forms.core.gen_field_id(form,field_id);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["form-group",ccn.core.bem.cljs$core$IFn$_invoke$arity$2("plaintext",cljs.core.conj.cljs$core$IFn$_invoke$arity$2(modifiers,rui.forms.core.field_state(form,field_id)))], 0))], null),((!((label == null)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$for,id,cljs.core.cst$kw$class,"form-control-label"], null),label_attrs], 0)),label], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$placeholder,cljs.core.cst$kw$name,cljs.core.cst$kw$value,cljs.core.cst$kw$on_DASH_blur,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$class,cljs.core.cst$kw$read_DASH_only,cljs.core.cst$kw$on_DASH_change],[label,id,cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((function (){var G__4146 = cljs.core.cst$kw$fields.cljs$core$IFn$_invoke$arity$1(form);
return (field_id.cljs$core$IFn$_invoke$arity$1 ? field_id.cljs$core$IFn$_invoke$arity$1(G__4146) : field_id.call(null,G__4146));
})()),cljs.core.partial.cljs$core$IFn$_invoke$arity$3(rui.forms.core.input_on_blur_BANG_,form,field_id),"text",id,ccn.core.twbs("form-control-plaintext",twbs_modifiers),true,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(rui.forms.core.input_on_change_BANG_,form,field_id)]),attrs], 0))], null)], null);
});

rui.forms.components.plaintext.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.plaintext.cljs$lang$applyTo = (function (seq4139){
var G__4140 = cljs.core.first(seq4139);
var seq4139__$1 = cljs.core.next(seq4139);
var G__4141 = cljs.core.first(seq4139__$1);
var seq4139__$2 = cljs.core.next(seq4139__$1);
var G__4142 = cljs.core.first(seq4139__$2);
var seq4139__$3 = cljs.core.next(seq4139__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4140,G__4141,G__4142,seq4139__$3);
});

