// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('rui.buttons.components');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('reagent.core');
goog.require('ccn.core');
goog.require('rui.icons');
/**
 * Returns a vector from a given `hashmap`
 * {:a 0 :b [1 2]} -> [:a 0 :b [1 2]]
 */
rui.buttons.components.map__GT_vec = (function rui$buttons$components$map__GT_vec(hashmap){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.vec(hashmap));
});
rui.buttons.components.compose_button_class = (function rui$buttons$components$compose_button_class(modifiers,twbs_modifiers,classes,enabled_internal_QMARK_,waiting_QMARK_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(ccn.core.css_class,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(classes,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ccn.core.twbs("btn",twbs_modifiers)], null),ccn.core.bem.cljs$core$IFn$_invoke$arity$2("btn",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(modifiers,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(enabled_internal_QMARK_)?"enabled":"disabled"),(cljs.core.truth_(waiting_QMARK_)?"waiting":null)], null))))));
});
/**
 * Returns Bootstrap's button with a given `title` as content and `on-click` handler.
 * Kwargs:
 * :enabled? - a boolean that indicates enabled/disabled state of it
 * :attrs - a map of attributes to override element's attributes
 * :modifiers - BEM modifiers
 * :twbs-modifiers - Bootstrap modifiers
 * :children - a sequence of its children components
 * :waiting? - a boolean that shows a spinner when `true`
 * :classes - a sequence of CSS classes
 */
rui.buttons.components.button = (function rui$buttons$components$button(var_args){
var args__4534__auto__ = [];
var len__4531__auto___7249 = arguments.length;
var i__4532__auto___7250 = (0);
while(true){
if((i__4532__auto___7250 < len__4531__auto___7249)){
args__4534__auto__.push((arguments[i__4532__auto___7250]));

var G__7251 = (i__4532__auto___7250 + (1));
i__4532__auto___7250 = G__7251;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((2) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((2)),(0),null)):null);
return rui.buttons.components.button.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4535__auto__);
});

rui.buttons.components.button.cljs$core$IFn$_invoke$arity$variadic = (function (title,on_click,p__7244){
var map__7245 = p__7244;
var map__7245__$1 = ((((!((map__7245 == null)))?(((((map__7245.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7245.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__7245):map__7245);
var enabled_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__7245__$1,cljs.core.cst$kw$enabled_QMARK_,true);
var attrs = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__7245__$1,cljs.core.cst$kw$attrs,cljs.core.PersistentArrayMap.EMPTY);
var modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__7245__$1,cljs.core.cst$kw$modifiers,cljs.core.PersistentVector.EMPTY);
var waiting_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__7245__$1,cljs.core.cst$kw$waiting_QMARK_,false);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7245__$1,cljs.core.cst$kw$children);
var twbs_modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__7245__$1,cljs.core.cst$kw$twbs_DASH_modifiers,cljs.core.PersistentVector.EMPTY);
var classes = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__7245__$1,cljs.core.cst$kw$classes,cljs.core.PersistentVector.EMPTY);
var enabled_internal_QMARK_ = (function (){var and__3938__auto__ = enabled_QMARK_;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.not(waiting_QMARK_);
} else {
return and__3938__auto__;
}
})();
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,rui.buttons.components.compose_button_class(modifiers,twbs_modifiers,classes,enabled_internal_QMARK_,waiting_QMARK_),cljs.core.cst$kw$on_DASH_click,((function (enabled_internal_QMARK_,map__7245,map__7245__$1,enabled_QMARK_,attrs,modifiers,waiting_QMARK_,children,twbs_modifiers,classes){
return (function (p1__7240_SHARP_){
if(cljs.core.truth_(enabled_internal_QMARK_)){
return (on_click.cljs$core$IFn$_invoke$arity$1 ? on_click.cljs$core$IFn$_invoke$arity$1(p1__7240_SHARP_) : on_click.call(null,p1__7240_SHARP_));
} else {
return null;
}
});})(enabled_internal_QMARK_,map__7245,map__7245__$1,enabled_QMARK_,attrs,modifiers,waiting_QMARK_,children,twbs_modifiers,classes))
], null),(cljs.core.truth_(enabled_internal_QMARK_)?null:new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$disabled,true], null)),attrs], 0)),(cljs.core.truth_(waiting_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.icons.fa,"gear",true], null):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,ccn.core.bem.cljs$core$IFn$_invoke$arity$3("btn","title",cljs.core.PersistentVector.EMPTY)], null),title], null)], null),children);
});

rui.buttons.components.button.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
rui.buttons.components.button.cljs$lang$applyTo = (function (seq7241){
var G__7242 = cljs.core.first(seq7241);
var seq7241__$1 = cljs.core.next(seq7241);
var G__7243 = cljs.core.first(seq7241__$1);
var seq7241__$2 = cljs.core.next(seq7241__$1);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7242,G__7243,seq7241__$2);
});

/**
 * Helper function for creating buttons
 */
rui.buttons.components.button_factory = (function rui$buttons$components$button_factory(button_type){
return (function() { 
var G__7262__delegate = function (title,on_click,p__7259){
var map__7260 = p__7259;
var map__7260__$1 = ((((!((map__7260 == null)))?(((((map__7260.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7260.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__7260):map__7260);
var kwargs = map__7260__$1;
var enabled_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7260__$1,cljs.core.cst$kw$enabled_QMARK_);
var attrs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7260__$1,cljs.core.cst$kw$attrs);
var modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7260__$1,cljs.core.cst$kw$modifiers);
var waiting_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7260__$1,cljs.core.cst$kw$waiting_QMARK_);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7260__$1,cljs.core.cst$kw$children);
var twbs_modifiers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7260__$1,cljs.core.cst$kw$twbs_DASH_modifiers);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.buttons.components.button,title,on_click], null),rui.buttons.components.map__GT_vec(cljs.core.update.cljs$core$IFn$_invoke$arity$4(kwargs,cljs.core.cst$kw$twbs_DASH_modifiers,cljs.core.conj,button_type)));
};
var G__7262 = function (title,on_click,var_args){
var p__7259 = null;
if (arguments.length > 2) {
var G__7264__i = 0, G__7264__a = new Array(arguments.length -  2);
while (G__7264__i < G__7264__a.length) {G__7264__a[G__7264__i] = arguments[G__7264__i + 2]; ++G__7264__i;}
  p__7259 = new cljs.core.IndexedSeq(G__7264__a,0,null);
} 
return G__7262__delegate.call(this,title,on_click,p__7259);};
G__7262.cljs$lang$maxFixedArity = 2;
G__7262.cljs$lang$applyTo = (function (arglist__7265){
var title = cljs.core.first(arglist__7265);
arglist__7265 = cljs.core.next(arglist__7265);
var on_click = cljs.core.first(arglist__7265);
var p__7259 = cljs.core.rest(arglist__7265);
return G__7262__delegate(title,on_click,p__7259);
});
G__7262.cljs$core$IFn$_invoke$arity$variadic = G__7262__delegate;
return G__7262;
})()
;
});
