// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});

/** @define {boolean} */
goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$warn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__6577){
var map__6578 = p__6577;
var map__6578__$1 = ((((!((map__6578 == null)))?(((((map__6578.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6578.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__6578):map__6578);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6578__$1,cljs.core.cst$kw$operation);
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6578__$1,cljs.core.cst$kw$op_DASH_type);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6578__$1,cljs.core.cst$kw$tags);
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6578__$1,cljs.core.cst$kw$child_DASH_of);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$id,re_frame.trace.next_id(),cljs.core.cst$kw$operation,operation,cljs.core.cst$kw$op_DASH_type,op_type,cljs.core.cst$kw$tags,tags,cljs.core.cst$kw$child_DASH_of,(function (){var or__3949__auto__ = child_of;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),cljs.core.cst$kw$start,re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__6580_6594 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__6581_6595 = null;
var count__6582_6596 = (0);
var i__6583_6597 = (0);
while(true){
if((i__6583_6597 < count__6582_6596)){
var vec__6584_6598 = chunk__6581_6595.cljs$core$IIndexed$_nth$arity$2(null,i__6583_6597);
var k_6599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6584_6598,(0),null);
var cb_6600 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6584_6598,(1),null);
try{var G__6588_6601 = cljs.core.deref(re_frame.trace.traces);
(cb_6600.cljs$core$IFn$_invoke$arity$1 ? cb_6600.cljs$core$IFn$_invoke$arity$1(G__6588_6601) : cb_6600.call(null,G__6588_6601));
}catch (e6587){var e_6602 = e6587;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_6599,"while storing",cljs.core.deref(re_frame.trace.traces),e_6602], 0));
}

var G__6603 = seq__6580_6594;
var G__6604 = chunk__6581_6595;
var G__6605 = count__6582_6596;
var G__6606 = (i__6583_6597 + (1));
seq__6580_6594 = G__6603;
chunk__6581_6595 = G__6604;
count__6582_6596 = G__6605;
i__6583_6597 = G__6606;
continue;
} else {
var temp__5457__auto___6607 = cljs.core.seq(seq__6580_6594);
if(temp__5457__auto___6607){
var seq__6580_6608__$1 = temp__5457__auto___6607;
if(cljs.core.chunked_seq_QMARK_(seq__6580_6608__$1)){
var c__4351__auto___6609 = cljs.core.chunk_first(seq__6580_6608__$1);
var G__6610 = cljs.core.chunk_rest(seq__6580_6608__$1);
var G__6611 = c__4351__auto___6609;
var G__6612 = cljs.core.count(c__4351__auto___6609);
var G__6613 = (0);
seq__6580_6594 = G__6610;
chunk__6581_6595 = G__6611;
count__6582_6596 = G__6612;
i__6583_6597 = G__6613;
continue;
} else {
var vec__6589_6614 = cljs.core.first(seq__6580_6608__$1);
var k_6615 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6589_6614,(0),null);
var cb_6616 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6589_6614,(1),null);
try{var G__6593_6617 = cljs.core.deref(re_frame.trace.traces);
(cb_6616.cljs$core$IFn$_invoke$arity$1 ? cb_6616.cljs$core$IFn$_invoke$arity$1(G__6593_6617) : cb_6616.call(null,G__6593_6617));
}catch (e6592){var e_6618 = e6592;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_6615,"while storing",cljs.core.deref(re_frame.trace.traces),e_6618], 0));
}

var G__6619 = cljs.core.next(seq__6580_6608__$1);
var G__6620 = null;
var G__6621 = (0);
var G__6622 = (0);
seq__6580_6594 = G__6619;
chunk__6581_6595 = G__6620;
count__6582_6596 = G__6621;
i__6583_6597 = G__6622;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});
