// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = cljs.core.cst$kw$fx;
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$id,cljs.core.cst$kw$do_DASH_fx,cljs.core.cst$kw$after,(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR_6971 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op_DASH_type,cljs.core.cst$kw$event_SLASH_do_DASH_fx], null));

try{try{var seq__6974 = cljs.core.seq(cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context));
var chunk__6975 = null;
var count__6976 = (0);
var i__6977 = (0);
while(true){
if((i__6977 < count__6976)){
var vec__6978 = chunk__6975.cljs$core$IIndexed$_nth$arity$2(null,i__6977);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6978,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6978,(1),null);
var temp__5455__auto___6994 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___6994)){
var effect_fn_6995 = temp__5455__auto___6994;
(effect_fn_6995.cljs$core$IFn$_invoke$arity$1 ? effect_fn_6995.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_6995.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__6996 = seq__6974;
var G__6997 = chunk__6975;
var G__6998 = count__6976;
var G__6999 = (i__6977 + (1));
seq__6974 = G__6996;
chunk__6975 = G__6997;
count__6976 = G__6998;
i__6977 = G__6999;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__6974);
if(temp__5457__auto__){
var seq__6974__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__6974__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__6974__$1);
var G__7000 = cljs.core.chunk_rest(seq__6974__$1);
var G__7001 = c__4351__auto__;
var G__7002 = cljs.core.count(c__4351__auto__);
var G__7003 = (0);
seq__6974 = G__7000;
chunk__6975 = G__7001;
count__6976 = G__7002;
i__6977 = G__7003;
continue;
} else {
var vec__6981 = cljs.core.first(seq__6974__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6981,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6981,(1),null);
var temp__5455__auto___7004 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___7004)){
var effect_fn_7005 = temp__5455__auto___7004;
(effect_fn_7005.cljs$core$IFn$_invoke$arity$1 ? effect_fn_7005.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_7005.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__7006 = cljs.core.next(seq__6974__$1);
var G__7007 = null;
var G__7008 = (0);
var G__7009 = (0);
seq__6974 = G__7006;
chunk__6975 = G__7007;
count__6976 = G__7008;
i__6977 = G__7009;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__6555__auto___7010 = re_frame.interop.now();
var duration__6556__auto___7011 = (end__6555__auto___7010 - cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__6556__auto___7011,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__6555__auto___7010);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_6971;
}} else {
var seq__6984 = cljs.core.seq(cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context));
var chunk__6985 = null;
var count__6986 = (0);
var i__6987 = (0);
while(true){
if((i__6987 < count__6986)){
var vec__6988 = chunk__6985.cljs$core$IIndexed$_nth$arity$2(null,i__6987);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6988,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6988,(1),null);
var temp__5455__auto___7012 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___7012)){
var effect_fn_7013 = temp__5455__auto___7012;
(effect_fn_7013.cljs$core$IFn$_invoke$arity$1 ? effect_fn_7013.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_7013.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__7014 = seq__6984;
var G__7015 = chunk__6985;
var G__7016 = count__6986;
var G__7017 = (i__6987 + (1));
seq__6984 = G__7014;
chunk__6985 = G__7015;
count__6986 = G__7016;
i__6987 = G__7017;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__6984);
if(temp__5457__auto__){
var seq__6984__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__6984__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__6984__$1);
var G__7018 = cljs.core.chunk_rest(seq__6984__$1);
var G__7019 = c__4351__auto__;
var G__7020 = cljs.core.count(c__4351__auto__);
var G__7021 = (0);
seq__6984 = G__7018;
chunk__6985 = G__7019;
count__6986 = G__7020;
i__6987 = G__7021;
continue;
} else {
var vec__6991 = cljs.core.first(seq__6984__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6991,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6991,(1),null);
var temp__5455__auto___7022 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___7022)){
var effect_fn_7023 = temp__5455__auto___7022;
(effect_fn_7023.cljs$core$IFn$_invoke$arity$1 ? effect_fn_7023.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_7023.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__7024 = cljs.core.next(seq__6984__$1);
var G__7025 = null;
var G__7026 = (0);
var G__7027 = (0);
seq__6984 = G__7024;
chunk__6985 = G__7025;
count__6986 = G__7026;
i__6987 = G__7027;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_later,(function (value){
var seq__7028 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__7029 = null;
var count__7030 = (0);
var i__7031 = (0);
while(true){
if((i__7031 < count__7030)){
var map__7032 = chunk__7029.cljs$core$IIndexed$_nth$arity$2(null,i__7031);
var map__7032__$1 = ((((!((map__7032 == null)))?(((((map__7032.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7032.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__7032):map__7032);
var effect = map__7032__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7032__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7032__$1,cljs.core.cst$kw$dispatch);
if(((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__7028,chunk__7029,count__7030,i__7031,map__7032,map__7032__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__7028,chunk__7029,count__7030,i__7031,map__7032,map__7032__$1,effect,ms,dispatch))
,ms);
}


var G__7036 = seq__7028;
var G__7037 = chunk__7029;
var G__7038 = count__7030;
var G__7039 = (i__7031 + (1));
seq__7028 = G__7036;
chunk__7029 = G__7037;
count__7030 = G__7038;
i__7031 = G__7039;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__7028);
if(temp__5457__auto__){
var seq__7028__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7028__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__7028__$1);
var G__7040 = cljs.core.chunk_rest(seq__7028__$1);
var G__7041 = c__4351__auto__;
var G__7042 = cljs.core.count(c__4351__auto__);
var G__7043 = (0);
seq__7028 = G__7040;
chunk__7029 = G__7041;
count__7030 = G__7042;
i__7031 = G__7043;
continue;
} else {
var map__7034 = cljs.core.first(seq__7028__$1);
var map__7034__$1 = ((((!((map__7034 == null)))?(((((map__7034.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7034.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__7034):map__7034);
var effect = map__7034__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7034__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7034__$1,cljs.core.cst$kw$dispatch);
if(((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__7028,chunk__7029,count__7030,i__7031,map__7034,map__7034__$1,effect,ms,dispatch,seq__7028__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__7028,chunk__7029,count__7030,i__7031,map__7034,map__7034__$1,effect,ms,dispatch,seq__7028__$1,temp__5457__auto__))
,ms);
}


var G__7044 = cljs.core.next(seq__7028__$1);
var G__7045 = null;
var G__7046 = (0);
var G__7047 = (0);
seq__7028 = G__7044;
chunk__7029 = G__7045;
count__7030 = G__7046;
i__7031 = G__7047;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch,(function (value){
if(!(cljs.core.vector_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_n,(function (value){
if(!(cljs.core.sequential_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__7048 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__7049 = null;
var count__7050 = (0);
var i__7051 = (0);
while(true){
if((i__7051 < count__7050)){
var event = chunk__7049.cljs$core$IIndexed$_nth$arity$2(null,i__7051);
re_frame.router.dispatch(event);


var G__7052 = seq__7048;
var G__7053 = chunk__7049;
var G__7054 = count__7050;
var G__7055 = (i__7051 + (1));
seq__7048 = G__7052;
chunk__7049 = G__7053;
count__7050 = G__7054;
i__7051 = G__7055;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__7048);
if(temp__5457__auto__){
var seq__7048__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7048__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__7048__$1);
var G__7056 = cljs.core.chunk_rest(seq__7048__$1);
var G__7057 = c__4351__auto__;
var G__7058 = cljs.core.count(c__4351__auto__);
var G__7059 = (0);
seq__7048 = G__7056;
chunk__7049 = G__7057;
count__7050 = G__7058;
i__7051 = G__7059;
continue;
} else {
var event = cljs.core.first(seq__7048__$1);
re_frame.router.dispatch(event);


var G__7060 = cljs.core.next(seq__7048__$1);
var G__7061 = null;
var G__7062 = (0);
var G__7063 = (0);
seq__7048 = G__7060;
chunk__7049 = G__7061;
count__7050 = G__7062;
i__7051 = G__7063;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$deregister_DASH_event_DASH_handler,(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__7064 = cljs.core.seq(value);
var chunk__7065 = null;
var count__7066 = (0);
var i__7067 = (0);
while(true){
if((i__7067 < count__7066)){
var event = chunk__7065.cljs$core$IIndexed$_nth$arity$2(null,i__7067);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__7068 = seq__7064;
var G__7069 = chunk__7065;
var G__7070 = count__7066;
var G__7071 = (i__7067 + (1));
seq__7064 = G__7068;
chunk__7065 = G__7069;
count__7066 = G__7070;
i__7067 = G__7071;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__7064);
if(temp__5457__auto__){
var seq__7064__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7064__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__7064__$1);
var G__7072 = cljs.core.chunk_rest(seq__7064__$1);
var G__7073 = c__4351__auto__;
var G__7074 = cljs.core.count(c__4351__auto__);
var G__7075 = (0);
seq__7064 = G__7072;
chunk__7065 = G__7073;
count__7066 = G__7074;
i__7067 = G__7075;
continue;
} else {
var event = cljs.core.first(seq__7064__$1);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__7076 = cljs.core.next(seq__7064__$1);
var G__7077 = null;
var G__7078 = (0);
var G__7079 = (0);
seq__7064 = G__7076;
chunk__7065 = G__7077;
count__7066 = G__7078;
i__7067 = G__7079;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return (clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(value) : clear_event.call(null,value));
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$db,(function (value){
if(!((cljs.core.deref(re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));
