// Compiled by ClojureScript 1.10.339 {}
goog.provide('rui.forms.components');
goog.require('cljs.core');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('ccn.core');
goog.require('re_frame.core');
goog.require('rui.buttons');
goog.require('rui.forms.core');
goog.require('rui.forms.events');
rui.forms.components.default_required_mark = " *";
rui.forms.components.field__GT_twbs_class = (function rui$forms$components$field__GT_twbs_class(field){
var G__2416 = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(field);
var G__2416__$1 = (((G__2416 instanceof cljs.core.Keyword))?G__2416.fqn:null);
switch (G__2416__$1) {
case "initial":
return null;

break;
case "invalid":
return "is-invalid";

break;
case "valid":
return "is-valid";

break;
default:
return null;

}
});
rui.forms.components.form_errors = (function rui$forms$components$form_errors(messages){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.form-errors.invalid-feedback","div.form-errors.invalid-feedback",-104610415),(function (){var iter__4324__auto__ = (function rui$forms$components$form_errors_$_iter__2418(s__2419){
return (new cljs.core.LazySeq(null,(function (){
var s__2419__$1 = s__2419;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__2419__$1);
if(temp__5457__auto__){
var s__2419__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__2419__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__2419__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__2421 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__2420 = (0);
while(true){
if((i__2420 < size__4323__auto__)){
var vec__2422 = cljs.core._nth.call(null,c__4322__auto__,i__2420);
var message = cljs.core.nth.call(null,vec__2422,(0),null);
var i = cljs.core.nth.call(null,vec__2422,(1),null);
cljs.core.chunk_append.call(null,b__2421,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.bem.call(null,"form-errors","error",cljs.core.PersistentVector.EMPTY)], null),message], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),goog.string.format("%s-%s",message,i)], null)));

var G__2428 = (i__2420 + (1));
i__2420 = G__2428;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__2421),rui$forms$components$form_errors_$_iter__2418.call(null,cljs.core.chunk_rest.call(null,s__2419__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__2421),null);
}
} else {
var vec__2425 = cljs.core.first.call(null,s__2419__$2);
var message = cljs.core.nth.call(null,vec__2425,(0),null);
var i = cljs.core.nth.call(null,vec__2425,(1),null);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.bem.call(null,"form-errors","error",cljs.core.PersistentVector.EMPTY)], null),message], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),goog.string.format("%s-%s",message,i)], null)),rui$forms$components$form_errors_$_iter__2418.call(null,cljs.core.rest.call(null,s__2419__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4324__auto__.call(null,cljs.core.zipmap.call(null,messages,cljs.core.range.call(null)));
})()], null);
});
rui.forms.components.can_show_errors_QMARK_ = (function rui$forms$components$can_show_errors_QMARK_(field,errors){
return ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"initial","initial",1854648214),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(field))) && (cljs.core.seq.call(null,errors)));
});
/**
 * Bare radio input that renders just a div with an input type radio and label. Don't use it directly.
 */
rui.forms.components.radio_input_element = (function rui$forms$components$radio_input_element(p__2429){
var map__2430 = p__2429;
var map__2430__$1 = ((((!((map__2430 == null)))?(((((map__2430.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2430.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2430):map__2430);
var form = cljs.core.get.call(null,map__2430__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var field_id = cljs.core.get.call(null,map__2430__$1,new cljs.core.Keyword(null,"field-id","field-id",-353751335));
var choice = cljs.core.get.call(null,map__2430__$1,new cljs.core.Keyword(null,"choice","choice",-1375170727));
var disabled_QMARK_ = cljs.core.get.call(null,map__2430__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var on_change = cljs.core.get.call(null,map__2430__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var checked_QMARK_ = cljs.core.get.call(null,map__2430__$1,new cljs.core.Keyword(null,"checked?","checked?",2024809091));
var field = cljs.core.get.call(null,map__2430__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var modifiers = cljs.core.get.call(null,map__2430__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834));
var label = cljs.core.get.call(null,map__2430__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__2430__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var radio_name = cljs.core.get.call(null,map__2430__$1,new cljs.core.Keyword(null,"radio-name","radio-name",771897205));
var chosen_value_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-check",(cljs.core.truth_(disabled_QMARK_)?"disabled":null),ccn.core.bem.call(null,"radio",cljs.core.concat.call(null,modifiers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [((chosen_value_QMARK_)?rui.forms.core.field_state.call(null,form,field_id):null)], null))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-check-input",((chosen_value_QMARK_)?rui.forms.components.field__GT_twbs_class.call(null,field):null)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),radio_name,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice),new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK_], null)], null),label], null);
});
/**
 * Radio input field with all functionalities like: updating value, showing an error, ...
 * Required parameters:
 * - `form` a form from the state
 * - `field-id` field is as a keyword
 * - `choices` a all possible values of the radio, a sequence of maps with `:label` and `:value` keys
 * Optional parameters:
 * - `modifiers` a CSS modifiers, a sequence of strings
 * - `component-class-name` a string that is added to 'form-group' Bootstrap element
 * - `renderer` a custom radio renderer, Reagent component that accepts a hashmap with following keys:
 *    id, field, radio-name, choice, on-change, checked?, disabled?, label, modifiers, form, field-id, input-el
 * - `on-change` a custom handler that is called after the original on-change handler
 *   - `required-mark` a valid Hiccup what will be shown when a field is required
 */
rui.forms.components.radio = (function rui$forms$components$radio(var_args){
var args__4534__auto__ = [];
var len__4531__auto___2443 = arguments.length;
var i__4532__auto___2444 = (0);
while(true){
if((i__4532__auto___2444 < len__4531__auto___2443)){
args__4534__auto__.push((arguments[i__4532__auto___2444]));

var G__2445 = (i__4532__auto___2444 + (1));
i__4532__auto___2444 = G__2445;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.radio.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.radio.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,choices,p__2436){
var map__2437 = p__2436;
var map__2437__$1 = ((((!((map__2437 == null)))?(((((map__2437.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2437.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2437):map__2437);
var modifiers = cljs.core.get.call(null,map__2437__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834));
var component_class_name = cljs.core.get.call(null,map__2437__$1,new cljs.core.Keyword(null,"component-class-name","component-class-name",1044506625));
var renderer = cljs.core.get.call(null,map__2437__$1,new cljs.core.Keyword(null,"renderer","renderer",336841071));
var on_change = cljs.core.get.call(null,map__2437__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var required_mark = cljs.core.get.call(null,map__2437__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var field = field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form));
var errors = field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form));
var on_change_internal = ((function (field,errors,map__2437,map__2437__$1,modifiers,component_class_name,renderer,on_change,required_mark){
return (function (was_keyword_QMARK_,event){
rui.forms.core.input_on_change_BANG_.call(null,form,field_id,(cljs.core.truth_(was_keyword_QMARK_)?cljs.core.keyword:cljs.core.identity),event);

rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

event.preventDefault();

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(field,errors,map__2437,map__2437__$1,modifiers,component_class_name,renderer,on_change,required_mark))
;
var radio_name = rui.forms.core.gen_field_id.call(null,form,field_id);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group","radio",component_class_name)], null),(function (){var iter__4324__auto__ = ((function (field,errors,on_change_internal,radio_name,map__2437,map__2437__$1,modifiers,component_class_name,renderer,on_change,required_mark){
return (function rui$forms$components$iter__2439(s__2440){
return (new cljs.core.LazySeq(null,((function (field,errors,on_change_internal,radio_name,map__2437,map__2437__$1,modifiers,component_class_name,renderer,on_change,required_mark){
return (function (){
var s__2440__$1 = s__2440;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__2440__$1);
if(temp__5457__auto__){
var s__2440__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__2440__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__2440__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__2442 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__2441 = (0);
while(true){
if((i__2441 < size__4323__auto__)){
var choice = cljs.core._nth.call(null,c__4322__auto__,i__2441);
cljs.core.chunk_append.call(null,b__2442,(function (){var id = rui.forms.core.gen_field_id.call(null,form,cljs.core.name.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,field_id)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice))].join(''))].join('')));
var disabled_QMARK_ = new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181).cljs$core$IFn$_invoke$arity$1(choice) === true;
var checked_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice))) || ((((new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field) == null)) && (new cljs.core.Keyword(null,"checked?","checked?",2024809091).cljs$core$IFn$_invoke$arity$1(choice) === true))));
var label = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"form-check-label",new cljs.core.Keyword(null,"for","for",-1323786319),id], null),new cljs.core.Keyword(null,"label","label",1718410804).cljs$core$IFn$_invoke$arity$1(choice),(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null);
var input_opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"checked?","checked?",2024809091),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"modifiers","modifiers",50378834),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"radio-name","radio-name",771897205),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword(null,"field-id","field-id",-353751335),new cljs.core.Keyword(null,"choice","choice",-1375170727),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181)],[checked_QMARK_,field,modifiers,id,radio_name,form,field_id,choice,cljs.core.partial.call(null,on_change_internal,(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice) instanceof cljs.core.Keyword)),disabled_QMARK_]);
var input_el = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.radio_input_element,cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),(cljs.core.truth_(renderer)?null:label)], null))], null);
if(!((renderer == null))){
return cljs.core.with_meta.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [renderer,cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input-el","input-el",1688931956),input_el], null))], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice)], null));
} else {
return cljs.core.with_meta.call(null,input_el,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice)], null));
}
})());

var G__2446 = (i__2441 + (1));
i__2441 = G__2446;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__2442),rui$forms$components$iter__2439.call(null,cljs.core.chunk_rest.call(null,s__2440__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__2442),null);
}
} else {
var choice = cljs.core.first.call(null,s__2440__$2);
return cljs.core.cons.call(null,(function (){var id = rui.forms.core.gen_field_id.call(null,form,cljs.core.name.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,field_id)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice))].join(''))].join('')));
var disabled_QMARK_ = new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181).cljs$core$IFn$_invoke$arity$1(choice) === true;
var checked_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice))) || ((((new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field) == null)) && (new cljs.core.Keyword(null,"checked?","checked?",2024809091).cljs$core$IFn$_invoke$arity$1(choice) === true))));
var label = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"form-check-label",new cljs.core.Keyword(null,"for","for",-1323786319),id], null),new cljs.core.Keyword(null,"label","label",1718410804).cljs$core$IFn$_invoke$arity$1(choice),(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null);
var input_opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"checked?","checked?",2024809091),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"modifiers","modifiers",50378834),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"radio-name","radio-name",771897205),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword(null,"field-id","field-id",-353751335),new cljs.core.Keyword(null,"choice","choice",-1375170727),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181)],[checked_QMARK_,field,modifiers,id,radio_name,form,field_id,choice,cljs.core.partial.call(null,on_change_internal,(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice) instanceof cljs.core.Keyword)),disabled_QMARK_]);
var input_el = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.radio_input_element,cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),(cljs.core.truth_(renderer)?null:label)], null))], null);
if(!((renderer == null))){
return cljs.core.with_meta.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [renderer,cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input-el","input-el",1688931956),input_el], null))], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice)], null));
} else {
return cljs.core.with_meta.call(null,input_el,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice)], null));
}
})(),rui$forms$components$iter__2439.call(null,cljs.core.rest.call(null,s__2440__$2)));
}
} else {
return null;
}
break;
}
});})(field,errors,on_change_internal,radio_name,map__2437,map__2437__$1,modifiers,component_class_name,renderer,on_change,required_mark))
,null,null));
});})(field,errors,on_change_internal,radio_name,map__2437,map__2437__$1,modifiers,component_class_name,renderer,on_change,required_mark))
;
return iter__4324__auto__.call(null,choices);
})(),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field,errors))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,errors], null):null)], null);
});

rui.forms.components.radio.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.radio.cljs$lang$applyTo = (function (seq2432){
var G__2433 = cljs.core.first.call(null,seq2432);
var seq2432__$1 = cljs.core.next.call(null,seq2432);
var G__2434 = cljs.core.first.call(null,seq2432__$1);
var seq2432__$2 = cljs.core.next.call(null,seq2432__$1);
var G__2435 = cljs.core.first.call(null,seq2432__$2);
var seq2432__$3 = cljs.core.next.call(null,seq2432__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2433,G__2434,G__2435,seq2432__$3);
});

rui.forms.components.checkbox = (function rui$forms$components$checkbox(var_args){
var args__4534__auto__ = [];
var len__4531__auto___2454 = arguments.length;
var i__4532__auto___2455 = (0);
while(true){
if((i__4532__auto___2455 < len__4531__auto___2454)){
args__4534__auto__.push((arguments[i__4532__auto___2455]));

var G__2456 = (i__4532__auto___2455 + (1));
i__4532__auto___2455 = G__2456;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.checkbox.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.checkbox.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__2451){
var map__2452 = p__2451;
var map__2452__$1 = ((((!((map__2452 == null)))?(((((map__2452.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2452.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2452):map__2452);
var children = cljs.core.get.call(null,map__2452__$1,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.PersistentVector.EMPTY);
var modifiers = cljs.core.get.call(null,map__2452__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__2452__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var on_change = cljs.core.get.call(null,map__2452__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var required_mark = cljs.core.get.call(null,map__2452__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var field = field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form));
var active_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field));
var errors = field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form));
var on_change_internal = ((function (field,active_QMARK_,errors,map__2452,map__2452__$1,children,modifiers,attrs,on_change,required_mark){
return (function (event){
re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rui::forms","forms-input-changed","rui::forms/forms-input-changed",-943107654),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(form),field_id,event.target.checked], null));

rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(field,active_QMARK_,errors,map__2452,map__2452__$1,children,modifiers,attrs,on_change,required_mark))
;
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-check","form-group",ccn.core.bem.call(null,"checkbox",cljs.core.concat.call(null,modifiers,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((active_QMARK_)?"active":null),rui.forms.core.field_state.call(null,form,field_id)], null))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-check-input",rui.forms.components.field__GT_twbs_class.call(null,field)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change_internal,new cljs.core.Keyword(null,"checked","checked",-50955819),active_QMARK_], null),attrs)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-check-label"], null),label,(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null)], null),cljs.core.conj.call(null,children,(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field,errors))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,errors], null):null)));
});

rui.forms.components.checkbox.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.checkbox.cljs$lang$applyTo = (function (seq2447){
var G__2448 = cljs.core.first.call(null,seq2447);
var seq2447__$1 = cljs.core.next.call(null,seq2447);
var G__2449 = cljs.core.first.call(null,seq2447__$1);
var seq2447__$2 = cljs.core.next.call(null,seq2447__$1);
var G__2450 = cljs.core.first.call(null,seq2447__$2);
var seq2447__$3 = cljs.core.next.call(null,seq2447__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2448,G__2449,G__2450,seq2447__$3);
});

rui.forms.components.select = (function rui$forms$components$select(var_args){
var args__4534__auto__ = [];
var len__4531__auto___2475 = arguments.length;
var i__4532__auto___2476 = (0);
while(true){
if((i__4532__auto___2476 < len__4531__auto___2475)){
args__4534__auto__.push((arguments[i__4532__auto___2476]));

var G__2477 = (i__4532__auto___2476 + (1));
i__4532__auto___2476 = G__2477;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((4) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((4)),(0),null)):null);
return rui.forms.components.select.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4535__auto__);
});

rui.forms.components.select.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,value_label_pairs,p__2462){
var map__2463 = p__2462;
var map__2463__$1 = ((((!((map__2463 == null)))?(((((map__2463.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2463.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2463):map__2463);
var children = cljs.core.get.call(null,map__2463__$1,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.PersistentVector.EMPTY);
var modifiers = cljs.core.get.call(null,map__2463__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__2463__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.call(null,map__2463__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153),cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.call(null,map__2463__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var on_change = cljs.core.get.call(null,map__2463__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var required_mark = cljs.core.get.call(null,map__2463__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var field = field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form));
var active_QMARK_ = !((new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field) == null));
var errors = field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form));
var on_change_internal = ((function (field,active_QMARK_,errors,map__2463,map__2463__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark){
return (function (was_keyword_QMARK_,event){
rui.forms.core.input_on_change_BANG_.call(null,form,field_id,(cljs.core.truth_(was_keyword_QMARK_)?cljs.core.keyword:cljs.core.identity),event);

rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(field,active_QMARK_,errors,map__2463,map__2463__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark))
;
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"select",cljs.core.concat.call(null,modifiers,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((active_QMARK_)?"active":null),rui.forms.core.field_state.call(null,form,field_id)], null))))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label,(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.partial.call(null,on_change_internal,cljs.core.every_QMARK_.call(null,cljs.core.keyword_QMARK_,cljs.core.map.call(null,cljs.core.first,value_label_pairs))),new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,ccn.core.twbs.call(null,"form-control",twbs_modifiers),rui.forms.components.field__GT_twbs_class.call(null,field))], null),attrs,((!((new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field) == null)))?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"default-value","default-value",232220170),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field)], null):null)),(function (){var iter__4324__auto__ = ((function (field,active_QMARK_,errors,on_change_internal,id,map__2463,map__2463__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark){
return (function rui$forms$components$iter__2465(s__2466){
return (new cljs.core.LazySeq(null,((function (field,active_QMARK_,errors,on_change_internal,id,map__2463,map__2463__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark){
return (function (){
var s__2466__$1 = s__2466;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__2466__$1);
if(temp__5457__auto__){
var s__2466__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__2466__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__2466__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__2468 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__2467 = (0);
while(true){
if((i__2467 < size__4323__auto__)){
var vec__2469 = cljs.core._nth.call(null,c__4322__auto__,i__2467);
var value = cljs.core.nth.call(null,vec__2469,(0),null);
var label__$1 = cljs.core.nth.call(null,vec__2469,(1),null);
cljs.core.chunk_append.call(null,b__2468,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),value], null),label__$1], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),value], null)));

var G__2478 = (i__2467 + (1));
i__2467 = G__2478;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__2468),rui$forms$components$iter__2465.call(null,cljs.core.chunk_rest.call(null,s__2466__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__2468),null);
}
} else {
var vec__2472 = cljs.core.first.call(null,s__2466__$2);
var value = cljs.core.nth.call(null,vec__2472,(0),null);
var label__$1 = cljs.core.nth.call(null,vec__2472,(1),null);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),value], null),label__$1], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),value], null)),rui$forms$components$iter__2465.call(null,cljs.core.rest.call(null,s__2466__$2)));
}
} else {
return null;
}
break;
}
});})(field,active_QMARK_,errors,on_change_internal,id,map__2463,map__2463__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark))
,null,null));
});})(field,active_QMARK_,errors,on_change_internal,id,map__2463,map__2463__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark))
;
return iter__4324__auto__.call(null,value_label_pairs);
})()], null)], null),cljs.core.conj.call(null,children,(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field,errors))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,errors], null):null)));
});

rui.forms.components.select.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
rui.forms.components.select.cljs$lang$applyTo = (function (seq2457){
var G__2458 = cljs.core.first.call(null,seq2457);
var seq2457__$1 = cljs.core.next.call(null,seq2457);
var G__2459 = cljs.core.first.call(null,seq2457__$1);
var seq2457__$2 = cljs.core.next.call(null,seq2457__$1);
var G__2460 = cljs.core.first.call(null,seq2457__$2);
var seq2457__$3 = cljs.core.next.call(null,seq2457__$2);
var G__2461 = cljs.core.first.call(null,seq2457__$3);
var seq2457__$4 = cljs.core.next.call(null,seq2457__$3);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2458,G__2459,G__2460,G__2461,seq2457__$4);
});

/**
 * Input field with all functionalities like: updating value, showing an error, ...
 * Required parameters:
 * - `input-type` a string like: 'text', 'number', ...
 * - `form` a form from the state
 * - `field-id` field is as a keyword
 * - `label` a Reagent valid component or string
 * Optional parameters:
 * - `modifiers` a CSS modifiers, a sequence of strings
 * - `attrs` a hashmap of HTML attributes of the input
 * - `label-attrs` a hashmap of HTML attributes for the label
 * - `twbs-modifiers` Twitter Bootstrap modifiers, a sequence of strings
 * - `input-group-append` a Twitter Bootstrap's 'input-group-append', a Reagent component of string
 * - `input-group-prepend` a Twitter Bootstrap's 'input-group-prepend', a Reagent component of string
 * - `on-change` a custom handler that is called after the original on-change handler
 * - `on-blur` a custom handler that is called after the original on-blur handler
 *   - `required-mark` a valid Hiccup what will be shown when a field is required
 */
rui.forms.components.input_field = (function rui$forms$components$input_field(var_args){
var args__4534__auto__ = [];
var len__4531__auto___2487 = arguments.length;
var i__4532__auto___2488 = (0);
while(true){
if((i__4532__auto___2488 < len__4531__auto___2487)){
args__4534__auto__.push((arguments[i__4532__auto___2488]));

var G__2489 = (i__4532__auto___2488 + (1));
i__4532__auto___2488 = G__2489;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((4) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((4)),(0),null)):null);
return rui.forms.components.input_field.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4535__auto__);
});

rui.forms.components.input_field.cljs$core$IFn$_invoke$arity$variadic = (function (input_type,form,field_id,label,p__2484){
var map__2485 = p__2484;
var map__2485__$1 = ((((!((map__2485 == null)))?(((((map__2485.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2485.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2485):map__2485);
var modifiers = cljs.core.get.call(null,map__2485__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__2485__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.call(null,map__2485__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153),cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.call(null,map__2485__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var input_group_append = cljs.core.get.call(null,map__2485__$1,new cljs.core.Keyword(null,"input-group-append","input-group-append",304795856),null);
var input_group_prepend = cljs.core.get.call(null,map__2485__$1,new cljs.core.Keyword(null,"input-group-prepend","input-group-prepend",-1646594811),null);
var on_change = cljs.core.get.call(null,map__2485__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var on_blur = cljs.core.get.call(null,map__2485__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var required_mark = cljs.core.get.call(null,map__2485__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
var field = cljs.core.get_in.call(null,form,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fields","fields",-1932066230),field_id], null));
var on_change_internal = ((function (id,field,map__2485,map__2485__$1,modifiers,attrs,label_attrs,twbs_modifiers,input_group_append,input_group_prepend,on_change,on_blur,required_mark){
return (function (event){
rui.forms.core.input_on_change_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(id,field,map__2485,map__2485__$1,modifiers,attrs,label_attrs,twbs_modifiers,input_group_append,input_group_prepend,on_change,on_blur,required_mark))
;
var on_blur_internal = ((function (id,field,on_change_internal,map__2485,map__2485__$1,modifiers,attrs,label_attrs,twbs_modifiers,input_group_append,input_group_prepend,on_change,on_blur,required_mark){
return (function (event){
rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_blur)){
return on_blur.call(null,event);
} else {
return null;
}
});})(id,field,on_change_internal,map__2485,map__2485__$1,modifiers,attrs,label_attrs,twbs_modifiers,input_group_append,input_group_prepend,on_change,on_blur,required_mark))
;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"input-field",cljs.core.name.call(null,field_id),cljs.core.conj.call(null,modifiers,rui.forms.core.field_state.call(null,form,field_id))))], null),((!((label == null)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label,(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null):null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_((function (){var or__3949__auto__ = input_group_prepend;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return input_group_append;
}
})())?"input-group":null)], null),((!((input_group_prepend == null)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-group-prepend","div.input-group-prepend",-1522435373),((typeof input_group_prepend === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-group-text","div.input-group-text",-1838140799),input_group_prepend], null):input_group_prepend)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),input_type,new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,ccn.core.twbs.call(null,"form-control",twbs_modifiers),rui.forms.components.field__GT_twbs_class.call(null,field)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form))),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),label,new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change_internal,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),on_blur_internal], null),attrs)], null),((!((input_group_append == null)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-group-append","div.input-group-append",-1462957134),((typeof input_group_append === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-group-text","div.input-group-text",-1838140799),input_group_append], null):input_group_append)], null):null),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form)),field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))], null):null)], null)], null);
});

rui.forms.components.input_field.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
rui.forms.components.input_field.cljs$lang$applyTo = (function (seq2479){
var G__2480 = cljs.core.first.call(null,seq2479);
var seq2479__$1 = cljs.core.next.call(null,seq2479);
var G__2481 = cljs.core.first.call(null,seq2479__$1);
var seq2479__$2 = cljs.core.next.call(null,seq2479__$1);
var G__2482 = cljs.core.first.call(null,seq2479__$2);
var seq2479__$3 = cljs.core.next.call(null,seq2479__$2);
var G__2483 = cljs.core.first.call(null,seq2479__$3);
var seq2479__$4 = cljs.core.next.call(null,seq2479__$3);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2480,G__2481,G__2482,G__2483,seq2479__$4);
});

rui.forms.components.input_text = cljs.core.partial.call(null,rui.forms.components.input_field,"text");
rui.forms.components.input_password = cljs.core.partial.call(null,rui.forms.components.input_field,"password");
rui.forms.components.input_number = cljs.core.partial.call(null,rui.forms.components.input_field,"number");
rui.forms.components.input_email = cljs.core.partial.call(null,rui.forms.components.input_field,"email");
rui.forms.components.input_file = (function rui$forms$components$input_file(var_args){
var args__4534__auto__ = [];
var len__4531__auto___2497 = arguments.length;
var i__4532__auto___2498 = (0);
while(true){
if((i__4532__auto___2498 < len__4531__auto___2497)){
args__4534__auto__.push((arguments[i__4532__auto___2498]));

var G__2499 = (i__4532__auto___2498 + (1));
i__4532__auto___2498 = G__2499;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.input_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.input_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__2494){
var map__2495 = p__2494;
var map__2495__$1 = ((((!((map__2495 == null)))?(((((map__2495.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2495.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2495):map__2495);
var kwargs = map__2495__$1;
var modifiers = cljs.core.get.call(null,map__2495__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834));
var attrs = cljs.core.get.call(null,map__2495__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var label_attrs = cljs.core.get.call(null,map__2495__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153));
var twbs_modifiers = cljs.core.get.call(null,map__2495__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072));
var on_blur = cljs.core.get.call(null,map__2495__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var on_change = cljs.core.get.call(null,map__2495__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var required_mark = cljs.core.get.call(null,map__2495__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
var field = cljs.core.get_in.call(null,form,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fields","fields",-1932066230),field_id], null));
var on_change_internal = ((function (id,field,map__2495,map__2495__$1,kwargs,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark){
return (function (event){
rui.forms.core.input_on_change_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(id,field,map__2495,map__2495__$1,kwargs,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark))
;
var on_blur_internal = ((function (id,field,on_change_internal,map__2495,map__2495__$1,kwargs,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark){
return (function (event){
rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_blur)){
return on_blur.call(null,event);
} else {
return null;
}
});})(id,field,on_change_internal,map__2495,map__2495__$1,kwargs,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark))
;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"input-field",cljs.core.conj.call(null,modifiers,rui.forms.core.field_state.call(null,form,field_id))))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.custom-file","div.custom-file",1258230266),((!((label == null)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label,(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),"file",new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,ccn.core.twbs.call(null,"form-control-file",twbs_modifiers),rui.forms.components.field__GT_twbs_class.call(null,field)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form))),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),label,new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change_internal,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),on_blur_internal], null),attrs)], null),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form)),field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))], null):null)], null)], null);
});

rui.forms.components.input_file.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.input_file.cljs$lang$applyTo = (function (seq2490){
var G__2491 = cljs.core.first.call(null,seq2490);
var seq2490__$1 = cljs.core.next.call(null,seq2490);
var G__2492 = cljs.core.first.call(null,seq2490__$1);
var seq2490__$2 = cljs.core.next.call(null,seq2490__$1);
var G__2493 = cljs.core.first.call(null,seq2490__$2);
var seq2490__$3 = cljs.core.next.call(null,seq2490__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2491,G__2492,G__2493,seq2490__$3);
});

rui.forms.components.text_area = (function rui$forms$components$text_area(var_args){
var args__4534__auto__ = [];
var len__4531__auto___2507 = arguments.length;
var i__4532__auto___2508 = (0);
while(true){
if((i__4532__auto___2508 < len__4531__auto___2507)){
args__4534__auto__.push((arguments[i__4532__auto___2508]));

var G__2509 = (i__4532__auto___2508 + (1));
i__4532__auto___2508 = G__2509;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.text_area.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.text_area.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__2504){
var map__2505 = p__2504;
var map__2505__$1 = ((((!((map__2505 == null)))?(((((map__2505.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2505.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2505):map__2505);
var modifiers = cljs.core.get.call(null,map__2505__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__2505__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.call(null,map__2505__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153),cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.call(null,map__2505__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var on_blur = cljs.core.get.call(null,map__2505__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var on_change = cljs.core.get.call(null,map__2505__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var required_mark = cljs.core.get.call(null,map__2505__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
var field = cljs.core.get_in.call(null,form,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fields","fields",-1932066230),field_id], null));
var on_change_internal = ((function (id,field,map__2505,map__2505__$1,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark){
return (function (event){
rui.forms.core.input_on_change_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(id,field,map__2505,map__2505__$1,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark))
;
var on_blur_internal = ((function (id,field,on_change_internal,map__2505,map__2505__$1,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark){
return (function (event){
rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_blur)){
return on_blur.call(null,event);
} else {
return null;
}
});})(id,field,on_change_internal,map__2505,map__2505__$1,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark))
;
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"text-area",cljs.core.conj.call(null,modifiers,rui.forms.core.field_state.call(null,form,field_id))))], null),((!((label == null)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label,(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,ccn.core.twbs.call(null,"form-control",twbs_modifiers),rui.forms.components.field__GT_twbs_class.call(null,field)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form))),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),label,new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change_internal,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),on_blur_internal], null),attrs)], null),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form)),field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))], null):null)], null);
});

rui.forms.components.text_area.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.text_area.cljs$lang$applyTo = (function (seq2500){
var G__2501 = cljs.core.first.call(null,seq2500);
var seq2500__$1 = cljs.core.next.call(null,seq2500);
var G__2502 = cljs.core.first.call(null,seq2500__$1);
var seq2500__$2 = cljs.core.next.call(null,seq2500__$1);
var G__2503 = cljs.core.first.call(null,seq2500__$2);
var seq2500__$3 = cljs.core.next.call(null,seq2500__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2501,G__2502,G__2503,seq2500__$3);
});

rui.forms.components.form_wrapper = (function rui$forms$components$form_wrapper(var_args){
var args__4534__auto__ = [];
var len__4531__auto___2516 = arguments.length;
var i__4532__auto___2517 = (0);
while(true){
if((i__4532__auto___2517 < len__4531__auto___2516)){
args__4534__auto__.push((arguments[i__4532__auto___2517]));

var G__2518 = (i__4532__auto___2517 + (1));
i__4532__auto___2517 = G__2518;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return rui.forms.components.form_wrapper.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

rui.forms.components.form_wrapper.cljs$core$IFn$_invoke$arity$variadic = (function (p__2513,children){
var map__2514 = p__2513;
var map__2514__$1 = ((((!((map__2514 == null)))?(((((map__2514.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2514.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2514):map__2514);
var kwargs = map__2514__$1;
var on_submit = cljs.core.get.call(null,map__2514__$1,new cljs.core.Keyword(null,"on-submit","on-submit",1227871159));
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"form-wrapper",new cljs.core.Keyword(null,"on-submit","on-submit",1227871159),((function (map__2514,map__2514__$1,kwargs,on_submit){
return (function (p1__2510_SHARP_){
p1__2510_SHARP_.preventDefault();

return on_submit.call(null,p1__2510_SHARP_);
});})(map__2514,map__2514__$1,kwargs,on_submit))
], null)], null),children);
});

rui.forms.components.form_wrapper.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
rui.forms.components.form_wrapper.cljs$lang$applyTo = (function (seq2511){
var G__2512 = cljs.core.first.call(null,seq2511);
var seq2511__$1 = cljs.core.next.call(null,seq2511);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2512,seq2511__$1);
});

rui.forms.components.button_submit = (function rui$forms$components$button_submit(var_args){
var args__4534__auto__ = [];
var len__4531__auto___2525 = arguments.length;
var i__4532__auto___2526 = (0);
while(true){
if((i__4532__auto___2526 < len__4531__auto___2525)){
args__4534__auto__.push((arguments[i__4532__auto___2526]));

var G__2527 = (i__4532__auto___2526 + (1));
i__4532__auto___2526 = G__2527;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((2) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((2)),(0),null)):null);
return rui.forms.components.button_submit.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4535__auto__);
});

rui.forms.components.button_submit.cljs$core$IFn$_invoke$arity$variadic = (function (title,on_click,p__2522){
var map__2523 = p__2522;
var map__2523__$1 = ((((!((map__2523 == null)))?(((((map__2523.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2523.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2523):map__2523);
var kwargs = map__2523__$1;
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.buttons.button_primary,title,on_click], null),cljs.core.apply.call(null,cljs.core.concat,cljs.core.merge.call(null,kwargs,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"modifiers","modifiers",50378834),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submit"], null)], null))));
});

rui.forms.components.button_submit.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
rui.forms.components.button_submit.cljs$lang$applyTo = (function (seq2519){
var G__2520 = cljs.core.first.call(null,seq2519);
var seq2519__$1 = cljs.core.next.call(null,seq2519);
var G__2521 = cljs.core.first.call(null,seq2519__$1);
var seq2519__$2 = cljs.core.next.call(null,seq2519__$1);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2520,G__2521,seq2519__$2);
});

rui.forms.components.plaintext = (function rui$forms$components$plaintext(var_args){
var args__4534__auto__ = [];
var len__4531__auto___2535 = arguments.length;
var i__4532__auto___2536 = (0);
while(true){
if((i__4532__auto___2536 < len__4531__auto___2535)){
args__4534__auto__.push((arguments[i__4532__auto___2536]));

var G__2537 = (i__4532__auto___2536 + (1));
i__4532__auto___2536 = G__2537;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.plaintext.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.plaintext.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__2532){
var map__2533 = p__2532;
var map__2533__$1 = ((((!((map__2533 == null)))?(((((map__2533.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2533.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2533):map__2533);
var modifiers = cljs.core.get.call(null,map__2533__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__2533__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.call(null,map__2533__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153),cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.call(null,map__2533__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"plaintext",cljs.core.conj.call(null,modifiers,rui.forms.core.field_state.call(null,form,field_id))))], null),((!((label == null)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"on-blur","on-blur",814300747),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.Keyword(null,"read-only","read-only",-191706886),new cljs.core.Keyword(null,"on-change","on-change",-732046149)],[label,id,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form))),cljs.core.partial.call(null,rui.forms.core.input_on_blur_BANG_,form,field_id),"text",id,ccn.core.twbs.call(null,"form-control-plaintext",twbs_modifiers),true,cljs.core.partial.call(null,rui.forms.core.input_on_change_BANG_,form,field_id)]),attrs)], null)], null);
});

rui.forms.components.plaintext.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.plaintext.cljs$lang$applyTo = (function (seq2528){
var G__2529 = cljs.core.first.call(null,seq2528);
var seq2528__$1 = cljs.core.next.call(null,seq2528);
var G__2530 = cljs.core.first.call(null,seq2528__$1);
var seq2528__$2 = cljs.core.next.call(null,seq2528__$1);
var G__2531 = cljs.core.first.call(null,seq2528__$2);
var seq2528__$3 = cljs.core.next.call(null,seq2528__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2529,G__2530,G__2531,seq2528__$3);
});


//# sourceMappingURL=components.js.map
