// Compiled by ClojureScript 1.10.339 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_1959 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));

try{try{var seq__1960 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__1961 = null;
var count__1962 = (0);
var i__1963 = (0);
while(true){
if((i__1963 < count__1962)){
var vec__1964 = cljs.core._nth.call(null,chunk__1961,i__1963);
var effect_key = cljs.core.nth.call(null,vec__1964,(0),null);
var effect_value = cljs.core.nth.call(null,vec__1964,(1),null);
var temp__5455__auto___1980 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___1980)){
var effect_fn_1981 = temp__5455__auto___1980;
effect_fn_1981.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__1982 = seq__1960;
var G__1983 = chunk__1961;
var G__1984 = count__1962;
var G__1985 = (i__1963 + (1));
seq__1960 = G__1982;
chunk__1961 = G__1983;
count__1962 = G__1984;
i__1963 = G__1985;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__1960);
if(temp__5457__auto__){
var seq__1960__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__1960__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__1960__$1);
var G__1986 = cljs.core.chunk_rest.call(null,seq__1960__$1);
var G__1987 = c__4351__auto__;
var G__1988 = cljs.core.count.call(null,c__4351__auto__);
var G__1989 = (0);
seq__1960 = G__1986;
chunk__1961 = G__1987;
count__1962 = G__1988;
i__1963 = G__1989;
continue;
} else {
var vec__1967 = cljs.core.first.call(null,seq__1960__$1);
var effect_key = cljs.core.nth.call(null,vec__1967,(0),null);
var effect_value = cljs.core.nth.call(null,vec__1967,(1),null);
var temp__5455__auto___1990 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___1990)){
var effect_fn_1991 = temp__5455__auto___1990;
effect_fn_1991.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__1992 = cljs.core.next.call(null,seq__1960__$1);
var G__1993 = null;
var G__1994 = (0);
var G__1995 = (0);
seq__1960 = G__1992;
chunk__1961 = G__1993;
count__1962 = G__1994;
i__1963 = G__1995;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__1799__auto___1996 = re_frame.interop.now.call(null);
var duration__1800__auto___1997 = (end__1799__auto___1996 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.call(null,re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__1800__auto___1997,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null)));

re_frame.trace.run_tracing_callbacks_BANG_.call(null,end__1799__auto___1996);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_1959;
}} else {
var seq__1970 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__1971 = null;
var count__1972 = (0);
var i__1973 = (0);
while(true){
if((i__1973 < count__1972)){
var vec__1974 = cljs.core._nth.call(null,chunk__1971,i__1973);
var effect_key = cljs.core.nth.call(null,vec__1974,(0),null);
var effect_value = cljs.core.nth.call(null,vec__1974,(1),null);
var temp__5455__auto___1998 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___1998)){
var effect_fn_1999 = temp__5455__auto___1998;
effect_fn_1999.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__2000 = seq__1970;
var G__2001 = chunk__1971;
var G__2002 = count__1972;
var G__2003 = (i__1973 + (1));
seq__1970 = G__2000;
chunk__1971 = G__2001;
count__1972 = G__2002;
i__1973 = G__2003;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__1970);
if(temp__5457__auto__){
var seq__1970__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__1970__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__1970__$1);
var G__2004 = cljs.core.chunk_rest.call(null,seq__1970__$1);
var G__2005 = c__4351__auto__;
var G__2006 = cljs.core.count.call(null,c__4351__auto__);
var G__2007 = (0);
seq__1970 = G__2004;
chunk__1971 = G__2005;
count__1972 = G__2006;
i__1973 = G__2007;
continue;
} else {
var vec__1977 = cljs.core.first.call(null,seq__1970__$1);
var effect_key = cljs.core.nth.call(null,vec__1977,(0),null);
var effect_value = cljs.core.nth.call(null,vec__1977,(1),null);
var temp__5455__auto___2008 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___2008)){
var effect_fn_2009 = temp__5455__auto___2008;
effect_fn_2009.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__2010 = cljs.core.next.call(null,seq__1970__$1);
var G__2011 = null;
var G__2012 = (0);
var G__2013 = (0);
seq__1970 = G__2010;
chunk__1971 = G__2011;
count__1972 = G__2012;
i__1973 = G__2013;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__2014 = cljs.core.seq.call(null,value);
var chunk__2015 = null;
var count__2016 = (0);
var i__2017 = (0);
while(true){
if((i__2017 < count__2016)){
var map__2018 = cljs.core._nth.call(null,chunk__2015,i__2017);
var map__2018__$1 = ((((!((map__2018 == null)))?(((((map__2018.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2018.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2018):map__2018);
var effect = map__2018__$1;
var ms = cljs.core.get.call(null,map__2018__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__2018__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__2014,chunk__2015,count__2016,i__2017,map__2018,map__2018__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__2014,chunk__2015,count__2016,i__2017,map__2018,map__2018__$1,effect,ms,dispatch))
,ms);
}


var G__2022 = seq__2014;
var G__2023 = chunk__2015;
var G__2024 = count__2016;
var G__2025 = (i__2017 + (1));
seq__2014 = G__2022;
chunk__2015 = G__2023;
count__2016 = G__2024;
i__2017 = G__2025;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__2014);
if(temp__5457__auto__){
var seq__2014__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2014__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__2014__$1);
var G__2026 = cljs.core.chunk_rest.call(null,seq__2014__$1);
var G__2027 = c__4351__auto__;
var G__2028 = cljs.core.count.call(null,c__4351__auto__);
var G__2029 = (0);
seq__2014 = G__2026;
chunk__2015 = G__2027;
count__2016 = G__2028;
i__2017 = G__2029;
continue;
} else {
var map__2020 = cljs.core.first.call(null,seq__2014__$1);
var map__2020__$1 = ((((!((map__2020 == null)))?(((((map__2020.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2020.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2020):map__2020);
var effect = map__2020__$1;
var ms = cljs.core.get.call(null,map__2020__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__2020__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__2014,chunk__2015,count__2016,i__2017,map__2020,map__2020__$1,effect,ms,dispatch,seq__2014__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__2014,chunk__2015,count__2016,i__2017,map__2020,map__2020__$1,effect,ms,dispatch,seq__2014__$1,temp__5457__auto__))
,ms);
}


var G__2030 = cljs.core.next.call(null,seq__2014__$1);
var G__2031 = null;
var G__2032 = (0);
var G__2033 = (0);
seq__2014 = G__2030;
chunk__2015 = G__2031;
count__2016 = G__2032;
i__2017 = G__2033;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__2034 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__2035 = null;
var count__2036 = (0);
var i__2037 = (0);
while(true){
if((i__2037 < count__2036)){
var event = cljs.core._nth.call(null,chunk__2035,i__2037);
re_frame.router.dispatch.call(null,event);


var G__2038 = seq__2034;
var G__2039 = chunk__2035;
var G__2040 = count__2036;
var G__2041 = (i__2037 + (1));
seq__2034 = G__2038;
chunk__2035 = G__2039;
count__2036 = G__2040;
i__2037 = G__2041;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__2034);
if(temp__5457__auto__){
var seq__2034__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2034__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__2034__$1);
var G__2042 = cljs.core.chunk_rest.call(null,seq__2034__$1);
var G__2043 = c__4351__auto__;
var G__2044 = cljs.core.count.call(null,c__4351__auto__);
var G__2045 = (0);
seq__2034 = G__2042;
chunk__2035 = G__2043;
count__2036 = G__2044;
i__2037 = G__2045;
continue;
} else {
var event = cljs.core.first.call(null,seq__2034__$1);
re_frame.router.dispatch.call(null,event);


var G__2046 = cljs.core.next.call(null,seq__2034__$1);
var G__2047 = null;
var G__2048 = (0);
var G__2049 = (0);
seq__2034 = G__2046;
chunk__2035 = G__2047;
count__2036 = G__2048;
i__2037 = G__2049;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__2050 = cljs.core.seq.call(null,value);
var chunk__2051 = null;
var count__2052 = (0);
var i__2053 = (0);
while(true){
if((i__2053 < count__2052)){
var event = cljs.core._nth.call(null,chunk__2051,i__2053);
clear_event.call(null,event);


var G__2054 = seq__2050;
var G__2055 = chunk__2051;
var G__2056 = count__2052;
var G__2057 = (i__2053 + (1));
seq__2050 = G__2054;
chunk__2051 = G__2055;
count__2052 = G__2056;
i__2053 = G__2057;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__2050);
if(temp__5457__auto__){
var seq__2050__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2050__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__2050__$1);
var G__2058 = cljs.core.chunk_rest.call(null,seq__2050__$1);
var G__2059 = c__4351__auto__;
var G__2060 = cljs.core.count.call(null,c__4351__auto__);
var G__2061 = (0);
seq__2050 = G__2058;
chunk__2051 = G__2059;
count__2052 = G__2060;
i__2053 = G__2061;
continue;
} else {
var event = cljs.core.first.call(null,seq__2050__$1);
clear_event.call(null,event);


var G__2062 = cljs.core.next.call(null,seq__2050__$1);
var G__2063 = null;
var G__2064 = (0);
var G__2065 = (0);
seq__2050 = G__2062;
chunk__2051 = G__2063;
count__2052 = G__2064;
i__2053 = G__2065;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref.call(null,re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=fx.js.map
