// Compiled by ClojureScript 1.10.339 {}
goog.provide('ccn.core');
goog.require('cljs.core');
goog.require('clojure.string');
/**
 * Composes a CSS class for an element with modifiers by BEM methodology.
 */
ccn.core.bem = (function ccn$core$bem(var_args){
var G__2321 = arguments.length;
switch (G__2321) {
case 2:
return ccn.core.bem.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return ccn.core.bem.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

ccn.core.bem.cljs$core$IFn$_invoke$arity$2 = (function (block,modifiers){
return ccn.core.bem.call(null,block,null,modifiers);
});

ccn.core.bem.cljs$core$IFn$_invoke$arity$3 = (function (block,element,modifiers){
var full_name = ((!((element == null)))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(element)].join(''):block);
return clojure.string.join.call(null," ",cljs.core.remove.call(null,clojure.string.blank_QMARK_,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [full_name], null),cljs.core.map.call(null,((function (full_name){
return (function (p1__2319_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(full_name),"--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__2319_SHARP_)].join('');
});})(full_name))
,cljs.core.remove.call(null,clojure.string.blank_QMARK_,modifiers)))));
});

ccn.core.bem.cljs$lang$maxFixedArity = 3;

/**
 * Composes a CSS class from given args, removes blanks.
 */
ccn.core.css_class = (function ccn$core$css_class(var_args){
var args__4534__auto__ = [];
var len__4531__auto___2324 = arguments.length;
var i__4532__auto___2325 = (0);
while(true){
if((i__4532__auto___2325 < len__4531__auto___2324)){
args__4534__auto__.push((arguments[i__4532__auto___2325]));

var G__2326 = (i__4532__auto___2325 + (1));
i__4532__auto___2325 = G__2326;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

ccn.core.css_class.cljs$core$IFn$_invoke$arity$variadic = (function (classes){
return clojure.string.join.call(null," ",cljs.core.remove.call(null,clojure.string.blank_QMARK_,classes));
});

ccn.core.css_class.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
ccn.core.css_class.cljs$lang$applyTo = (function (seq2323){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq2323));
});

/**
 * Composes a CSS class in Twitter Bootstrap way. It handles special cases like `disabled`.
 */
ccn.core.twbs = (function ccn$core$twbs(base,modifiers){
var vec__2328 = cljs.core.split_with.call(null,cljs.core.partial.call(null,cljs.core.not_EQ_,"disabled"),cljs.core.set.call(null,modifiers));
var head = cljs.core.nth.call(null,vec__2328,(0),null);
var tail = cljs.core.nth.call(null,vec__2328,(1),null);
return clojure.string.join.call(null," ",cljs.core.remove.call(null,clojure.string.blank_QMARK_,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,tail),base], null),cljs.core.map.call(null,((function (vec__2328,head,tail){
return (function (p1__2327_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(base),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__2327_SHARP_)].join('');
});})(vec__2328,head,tail))
,cljs.core.remove.call(null,clojure.string.blank_QMARK_,cljs.core.concat.call(null,head,cljs.core.rest.call(null,tail)))))));
});

//# sourceMappingURL=core.js.map
