// Compiled by ClojureScript 1.10.339 {}
goog.provide('rui.forms.components');
goog.require('cljs.core');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('ccn.core');
goog.require('re_frame.core');
goog.require('rui.buttons');
goog.require('rui.forms.core');
goog.require('rui.forms.events');
rui.forms.components.default_required_mark = " *";
rui.forms.components.field__GT_twbs_class = (function rui$forms$components$field__GT_twbs_class(field){
var G__32222 = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(field);
var G__32222__$1 = (((G__32222 instanceof cljs.core.Keyword))?G__32222.fqn:null);
switch (G__32222__$1) {
case "initial":
return null;

break;
case "invalid":
return "is-invalid";

break;
case "valid":
return "is-valid";

break;
default:
return null;

}
});
rui.forms.components.form_errors = (function rui$forms$components$form_errors(messages){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.form-errors.invalid-feedback","div.form-errors.invalid-feedback",-104610415),(function (){var iter__4324__auto__ = (function rui$forms$components$form_errors_$_iter__32224(s__32225){
return (new cljs.core.LazySeq(null,(function (){
var s__32225__$1 = s__32225;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__32225__$1);
if(temp__5457__auto__){
var s__32225__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__32225__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__32225__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__32227 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__32226 = (0);
while(true){
if((i__32226 < size__4323__auto__)){
var vec__32228 = cljs.core._nth.call(null,c__4322__auto__,i__32226);
var message = cljs.core.nth.call(null,vec__32228,(0),null);
var i = cljs.core.nth.call(null,vec__32228,(1),null);
cljs.core.chunk_append.call(null,b__32227,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.bem.call(null,"form-errors","error",cljs.core.PersistentVector.EMPTY)], null),message], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),goog.string.format("%s-%s",message,i)], null)));

var G__32234 = (i__32226 + (1));
i__32226 = G__32234;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__32227),rui$forms$components$form_errors_$_iter__32224.call(null,cljs.core.chunk_rest.call(null,s__32225__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__32227),null);
}
} else {
var vec__32231 = cljs.core.first.call(null,s__32225__$2);
var message = cljs.core.nth.call(null,vec__32231,(0),null);
var i = cljs.core.nth.call(null,vec__32231,(1),null);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.bem.call(null,"form-errors","error",cljs.core.PersistentVector.EMPTY)], null),message], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),goog.string.format("%s-%s",message,i)], null)),rui$forms$components$form_errors_$_iter__32224.call(null,cljs.core.rest.call(null,s__32225__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4324__auto__.call(null,cljs.core.zipmap.call(null,messages,cljs.core.range.call(null)));
})()], null);
});
rui.forms.components.can_show_errors_QMARK_ = (function rui$forms$components$can_show_errors_QMARK_(field,errors){
return ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"initial","initial",1854648214),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(field))) && (cljs.core.seq.call(null,errors)));
});
/**
 * Bare radio input that renders just a div with an input type radio and label. Don't use it directly.
 */
rui.forms.components.radio_input_element = (function rui$forms$components$radio_input_element(p__32235){
var map__32236 = p__32235;
var map__32236__$1 = ((((!((map__32236 == null)))?(((((map__32236.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32236.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32236):map__32236);
var form = cljs.core.get.call(null,map__32236__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var field_id = cljs.core.get.call(null,map__32236__$1,new cljs.core.Keyword(null,"field-id","field-id",-353751335));
var choice = cljs.core.get.call(null,map__32236__$1,new cljs.core.Keyword(null,"choice","choice",-1375170727));
var disabled_QMARK_ = cljs.core.get.call(null,map__32236__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var on_change = cljs.core.get.call(null,map__32236__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var checked_QMARK_ = cljs.core.get.call(null,map__32236__$1,new cljs.core.Keyword(null,"checked?","checked?",2024809091));
var field = cljs.core.get.call(null,map__32236__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var modifiers = cljs.core.get.call(null,map__32236__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834));
var label = cljs.core.get.call(null,map__32236__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__32236__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var radio_name = cljs.core.get.call(null,map__32236__$1,new cljs.core.Keyword(null,"radio-name","radio-name",771897205));
var chosen_value_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-check",(cljs.core.truth_(disabled_QMARK_)?"disabled":null),ccn.core.bem.call(null,"radio",cljs.core.concat.call(null,modifiers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [((chosen_value_QMARK_)?rui.forms.core.field_state.call(null,form,field_id):null)], null))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-check-input",((chosen_value_QMARK_)?rui.forms.components.field__GT_twbs_class.call(null,field):null)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),radio_name,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice),new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK_], null)], null),label], null);
});
/**
 * Radio input field with all functionalities like: updating value, showing an error, ...
 * Required parameters:
 * - `form` a form from the state
 * - `field-id` field is as a keyword
 * - `choices` a all possible values of the radio, a sequence of maps with `:label` and `:value` keys
 * Optional parameters:
 * - `modifiers` a CSS modifiers, a sequence of strings
 * - `component-class-name` a string that is added to 'form-group' Bootstrap element
 * - `renderer` a custom radio renderer, Reagent component that accepts a hashmap with following keys:
 *    id, field, radio-name, choice, on-change, checked?, disabled?, label, modifiers, form, field-id, input-el
 * - `on-change` a custom handler that is called after the original on-change handler
 *   - `required-mark` a valid Hiccup what will be shown when a field is required
 */
rui.forms.components.radio = (function rui$forms$components$radio(var_args){
var args__4534__auto__ = [];
var len__4531__auto___32249 = arguments.length;
var i__4532__auto___32250 = (0);
while(true){
if((i__4532__auto___32250 < len__4531__auto___32249)){
args__4534__auto__.push((arguments[i__4532__auto___32250]));

var G__32251 = (i__4532__auto___32250 + (1));
i__4532__auto___32250 = G__32251;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.radio.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.radio.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,choices,p__32242){
var map__32243 = p__32242;
var map__32243__$1 = ((((!((map__32243 == null)))?(((((map__32243.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32243.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32243):map__32243);
var modifiers = cljs.core.get.call(null,map__32243__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834));
var component_class_name = cljs.core.get.call(null,map__32243__$1,new cljs.core.Keyword(null,"component-class-name","component-class-name",1044506625));
var renderer = cljs.core.get.call(null,map__32243__$1,new cljs.core.Keyword(null,"renderer","renderer",336841071));
var on_change = cljs.core.get.call(null,map__32243__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var required_mark = cljs.core.get.call(null,map__32243__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var field = field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form));
var errors = field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form));
var on_change_internal = ((function (field,errors,map__32243,map__32243__$1,modifiers,component_class_name,renderer,on_change,required_mark){
return (function (was_keyword_QMARK_,event){
rui.forms.core.input_on_change_BANG_.call(null,form,field_id,(cljs.core.truth_(was_keyword_QMARK_)?cljs.core.keyword:cljs.core.identity),event);

rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

event.preventDefault();

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(field,errors,map__32243,map__32243__$1,modifiers,component_class_name,renderer,on_change,required_mark))
;
var radio_name = rui.forms.core.gen_field_id.call(null,form,field_id);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group","radio",component_class_name)], null),(function (){var iter__4324__auto__ = ((function (field,errors,on_change_internal,radio_name,map__32243,map__32243__$1,modifiers,component_class_name,renderer,on_change,required_mark){
return (function rui$forms$components$iter__32245(s__32246){
return (new cljs.core.LazySeq(null,((function (field,errors,on_change_internal,radio_name,map__32243,map__32243__$1,modifiers,component_class_name,renderer,on_change,required_mark){
return (function (){
var s__32246__$1 = s__32246;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__32246__$1);
if(temp__5457__auto__){
var s__32246__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__32246__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__32246__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__32248 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__32247 = (0);
while(true){
if((i__32247 < size__4323__auto__)){
var choice = cljs.core._nth.call(null,c__4322__auto__,i__32247);
cljs.core.chunk_append.call(null,b__32248,(function (){var id = rui.forms.core.gen_field_id.call(null,form,cljs.core.name.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,field_id)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice))].join(''))].join('')));
var disabled_QMARK_ = new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181).cljs$core$IFn$_invoke$arity$1(choice) === true;
var checked_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice))) || ((((new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field) == null)) && (new cljs.core.Keyword(null,"checked?","checked?",2024809091).cljs$core$IFn$_invoke$arity$1(choice) === true))));
var label = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"form-check-label",new cljs.core.Keyword(null,"for","for",-1323786319),id], null),new cljs.core.Keyword(null,"label","label",1718410804).cljs$core$IFn$_invoke$arity$1(choice),(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null);
var input_opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"checked?","checked?",2024809091),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"modifiers","modifiers",50378834),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"radio-name","radio-name",771897205),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword(null,"field-id","field-id",-353751335),new cljs.core.Keyword(null,"choice","choice",-1375170727),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181)],[checked_QMARK_,field,modifiers,id,radio_name,form,field_id,choice,cljs.core.partial.call(null,on_change_internal,(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice) instanceof cljs.core.Keyword)),disabled_QMARK_]);
var input_el = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.radio_input_element,cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),(cljs.core.truth_(renderer)?null:label)], null))], null);
if(!((renderer == null))){
return cljs.core.with_meta.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [renderer,cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input-el","input-el",1688931956),input_el], null))], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice)], null));
} else {
return cljs.core.with_meta.call(null,input_el,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice)], null));
}
})());

var G__32252 = (i__32247 + (1));
i__32247 = G__32252;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__32248),rui$forms$components$iter__32245.call(null,cljs.core.chunk_rest.call(null,s__32246__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__32248),null);
}
} else {
var choice = cljs.core.first.call(null,s__32246__$2);
return cljs.core.cons.call(null,(function (){var id = rui.forms.core.gen_field_id.call(null,form,cljs.core.name.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,field_id)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice))].join(''))].join('')));
var disabled_QMARK_ = new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181).cljs$core$IFn$_invoke$arity$1(choice) === true;
var checked_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice))) || ((((new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field) == null)) && (new cljs.core.Keyword(null,"checked?","checked?",2024809091).cljs$core$IFn$_invoke$arity$1(choice) === true))));
var label = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"form-check-label",new cljs.core.Keyword(null,"for","for",-1323786319),id], null),new cljs.core.Keyword(null,"label","label",1718410804).cljs$core$IFn$_invoke$arity$1(choice),(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null);
var input_opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"checked?","checked?",2024809091),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"modifiers","modifiers",50378834),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"radio-name","radio-name",771897205),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword(null,"field-id","field-id",-353751335),new cljs.core.Keyword(null,"choice","choice",-1375170727),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181)],[checked_QMARK_,field,modifiers,id,radio_name,form,field_id,choice,cljs.core.partial.call(null,on_change_internal,(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice) instanceof cljs.core.Keyword)),disabled_QMARK_]);
var input_el = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.radio_input_element,cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),(cljs.core.truth_(renderer)?null:label)], null))], null);
if(!((renderer == null))){
return cljs.core.with_meta.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [renderer,cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input-el","input-el",1688931956),input_el], null))], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice)], null));
} else {
return cljs.core.with_meta.call(null,input_el,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice)], null));
}
})(),rui$forms$components$iter__32245.call(null,cljs.core.rest.call(null,s__32246__$2)));
}
} else {
return null;
}
break;
}
});})(field,errors,on_change_internal,radio_name,map__32243,map__32243__$1,modifiers,component_class_name,renderer,on_change,required_mark))
,null,null));
});})(field,errors,on_change_internal,radio_name,map__32243,map__32243__$1,modifiers,component_class_name,renderer,on_change,required_mark))
;
return iter__4324__auto__.call(null,choices);
})(),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field,errors))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,errors], null):null)], null);
});

rui.forms.components.radio.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.radio.cljs$lang$applyTo = (function (seq32238){
var G__32239 = cljs.core.first.call(null,seq32238);
var seq32238__$1 = cljs.core.next.call(null,seq32238);
var G__32240 = cljs.core.first.call(null,seq32238__$1);
var seq32238__$2 = cljs.core.next.call(null,seq32238__$1);
var G__32241 = cljs.core.first.call(null,seq32238__$2);
var seq32238__$3 = cljs.core.next.call(null,seq32238__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32239,G__32240,G__32241,seq32238__$3);
});

rui.forms.components.checkbox = (function rui$forms$components$checkbox(var_args){
var args__4534__auto__ = [];
var len__4531__auto___32260 = arguments.length;
var i__4532__auto___32261 = (0);
while(true){
if((i__4532__auto___32261 < len__4531__auto___32260)){
args__4534__auto__.push((arguments[i__4532__auto___32261]));

var G__32262 = (i__4532__auto___32261 + (1));
i__4532__auto___32261 = G__32262;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.checkbox.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.checkbox.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__32257){
var map__32258 = p__32257;
var map__32258__$1 = ((((!((map__32258 == null)))?(((((map__32258.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32258.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32258):map__32258);
var children = cljs.core.get.call(null,map__32258__$1,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.PersistentVector.EMPTY);
var modifiers = cljs.core.get.call(null,map__32258__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__32258__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var on_change = cljs.core.get.call(null,map__32258__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var required_mark = cljs.core.get.call(null,map__32258__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var field = field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form));
var active_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field));
var errors = field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form));
var on_change_internal = ((function (field,active_QMARK_,errors,map__32258,map__32258__$1,children,modifiers,attrs,on_change,required_mark){
return (function (event){
re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rui::forms","forms-input-changed","rui::forms/forms-input-changed",-943107654),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(form),field_id,event.target.checked], null));

rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(field,active_QMARK_,errors,map__32258,map__32258__$1,children,modifiers,attrs,on_change,required_mark))
;
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-check","form-group",ccn.core.bem.call(null,"checkbox",cljs.core.concat.call(null,modifiers,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((active_QMARK_)?"active":null),rui.forms.core.field_state.call(null,form,field_id)], null))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-check-input",rui.forms.components.field__GT_twbs_class.call(null,field)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change_internal,new cljs.core.Keyword(null,"checked","checked",-50955819),active_QMARK_], null),attrs)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-check-label"], null),label,(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null)], null),cljs.core.conj.call(null,children,(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field,errors))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,errors], null):null)));
});

rui.forms.components.checkbox.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.checkbox.cljs$lang$applyTo = (function (seq32253){
var G__32254 = cljs.core.first.call(null,seq32253);
var seq32253__$1 = cljs.core.next.call(null,seq32253);
var G__32255 = cljs.core.first.call(null,seq32253__$1);
var seq32253__$2 = cljs.core.next.call(null,seq32253__$1);
var G__32256 = cljs.core.first.call(null,seq32253__$2);
var seq32253__$3 = cljs.core.next.call(null,seq32253__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32254,G__32255,G__32256,seq32253__$3);
});

rui.forms.components.select = (function rui$forms$components$select(var_args){
var args__4534__auto__ = [];
var len__4531__auto___32281 = arguments.length;
var i__4532__auto___32282 = (0);
while(true){
if((i__4532__auto___32282 < len__4531__auto___32281)){
args__4534__auto__.push((arguments[i__4532__auto___32282]));

var G__32283 = (i__4532__auto___32282 + (1));
i__4532__auto___32282 = G__32283;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((4) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((4)),(0),null)):null);
return rui.forms.components.select.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4535__auto__);
});

rui.forms.components.select.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,value_label_pairs,p__32268){
var map__32269 = p__32268;
var map__32269__$1 = ((((!((map__32269 == null)))?(((((map__32269.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32269.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32269):map__32269);
var children = cljs.core.get.call(null,map__32269__$1,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.PersistentVector.EMPTY);
var modifiers = cljs.core.get.call(null,map__32269__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__32269__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.call(null,map__32269__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153),cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.call(null,map__32269__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var on_change = cljs.core.get.call(null,map__32269__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var required_mark = cljs.core.get.call(null,map__32269__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var field = field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form));
var active_QMARK_ = !((new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field) == null));
var errors = field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form));
var on_change_internal = ((function (field,active_QMARK_,errors,map__32269,map__32269__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark){
return (function (was_keyword_QMARK_,event){
rui.forms.core.input_on_change_BANG_.call(null,form,field_id,(cljs.core.truth_(was_keyword_QMARK_)?cljs.core.keyword:cljs.core.identity),event);

rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(field,active_QMARK_,errors,map__32269,map__32269__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark))
;
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"select",cljs.core.concat.call(null,modifiers,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((active_QMARK_)?"active":null),rui.forms.core.field_state.call(null,form,field_id)], null))))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label,(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.partial.call(null,on_change_internal,cljs.core.every_QMARK_.call(null,cljs.core.keyword_QMARK_,cljs.core.map.call(null,cljs.core.first,value_label_pairs))),new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,ccn.core.twbs.call(null,"form-control",twbs_modifiers),rui.forms.components.field__GT_twbs_class.call(null,field))], null),attrs,((!((new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field) == null)))?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"default-value","default-value",232220170),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field)], null):null)),(function (){var iter__4324__auto__ = ((function (field,active_QMARK_,errors,on_change_internal,id,map__32269,map__32269__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark){
return (function rui$forms$components$iter__32271(s__32272){
return (new cljs.core.LazySeq(null,((function (field,active_QMARK_,errors,on_change_internal,id,map__32269,map__32269__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark){
return (function (){
var s__32272__$1 = s__32272;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__32272__$1);
if(temp__5457__auto__){
var s__32272__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__32272__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__32272__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__32274 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__32273 = (0);
while(true){
if((i__32273 < size__4323__auto__)){
var vec__32275 = cljs.core._nth.call(null,c__4322__auto__,i__32273);
var value = cljs.core.nth.call(null,vec__32275,(0),null);
var label__$1 = cljs.core.nth.call(null,vec__32275,(1),null);
cljs.core.chunk_append.call(null,b__32274,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),value], null),label__$1], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),value], null)));

var G__32284 = (i__32273 + (1));
i__32273 = G__32284;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__32274),rui$forms$components$iter__32271.call(null,cljs.core.chunk_rest.call(null,s__32272__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__32274),null);
}
} else {
var vec__32278 = cljs.core.first.call(null,s__32272__$2);
var value = cljs.core.nth.call(null,vec__32278,(0),null);
var label__$1 = cljs.core.nth.call(null,vec__32278,(1),null);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),value], null),label__$1], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),value], null)),rui$forms$components$iter__32271.call(null,cljs.core.rest.call(null,s__32272__$2)));
}
} else {
return null;
}
break;
}
});})(field,active_QMARK_,errors,on_change_internal,id,map__32269,map__32269__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark))
,null,null));
});})(field,active_QMARK_,errors,on_change_internal,id,map__32269,map__32269__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark))
;
return iter__4324__auto__.call(null,value_label_pairs);
})()], null)], null),cljs.core.conj.call(null,children,(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field,errors))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,errors], null):null)));
});

rui.forms.components.select.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
rui.forms.components.select.cljs$lang$applyTo = (function (seq32263){
var G__32264 = cljs.core.first.call(null,seq32263);
var seq32263__$1 = cljs.core.next.call(null,seq32263);
var G__32265 = cljs.core.first.call(null,seq32263__$1);
var seq32263__$2 = cljs.core.next.call(null,seq32263__$1);
var G__32266 = cljs.core.first.call(null,seq32263__$2);
var seq32263__$3 = cljs.core.next.call(null,seq32263__$2);
var G__32267 = cljs.core.first.call(null,seq32263__$3);
var seq32263__$4 = cljs.core.next.call(null,seq32263__$3);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32264,G__32265,G__32266,G__32267,seq32263__$4);
});

/**
 * Input field with all functionalities like: updating value, showing an error, ...
 * Required parameters:
 * - `input-type` a string like: 'text', 'number', ...
 * - `form` a form from the state
 * - `field-id` field is as a keyword
 * - `label` a Reagent valid component or string
 * Optional parameters:
 * - `modifiers` a CSS modifiers, a sequence of strings
 * - `attrs` a hashmap of HTML attributes of the input
 * - `label-attrs` a hashmap of HTML attributes for the label
 * - `twbs-modifiers` Twitter Bootstrap modifiers, a sequence of strings
 * - `input-group-append` a Twitter Bootstrap's 'input-group-append', a Reagent component of string
 * - `input-group-prepend` a Twitter Bootstrap's 'input-group-prepend', a Reagent component of string
 * - `on-change` a custom handler that is called after the original on-change handler
 * - `on-blur` a custom handler that is called after the original on-blur handler
 *   - `required-mark` a valid Hiccup what will be shown when a field is required
 */
rui.forms.components.input_field = (function rui$forms$components$input_field(var_args){
var args__4534__auto__ = [];
var len__4531__auto___32293 = arguments.length;
var i__4532__auto___32294 = (0);
while(true){
if((i__4532__auto___32294 < len__4531__auto___32293)){
args__4534__auto__.push((arguments[i__4532__auto___32294]));

var G__32295 = (i__4532__auto___32294 + (1));
i__4532__auto___32294 = G__32295;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((4) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((4)),(0),null)):null);
return rui.forms.components.input_field.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4535__auto__);
});

rui.forms.components.input_field.cljs$core$IFn$_invoke$arity$variadic = (function (input_type,form,field_id,label,p__32290){
var map__32291 = p__32290;
var map__32291__$1 = ((((!((map__32291 == null)))?(((((map__32291.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32291.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32291):map__32291);
var modifiers = cljs.core.get.call(null,map__32291__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__32291__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.call(null,map__32291__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153),cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.call(null,map__32291__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var input_group_append = cljs.core.get.call(null,map__32291__$1,new cljs.core.Keyword(null,"input-group-append","input-group-append",304795856),null);
var input_group_prepend = cljs.core.get.call(null,map__32291__$1,new cljs.core.Keyword(null,"input-group-prepend","input-group-prepend",-1646594811),null);
var on_change = cljs.core.get.call(null,map__32291__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var on_blur = cljs.core.get.call(null,map__32291__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var required_mark = cljs.core.get.call(null,map__32291__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
var field = cljs.core.get_in.call(null,form,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fields","fields",-1932066230),field_id], null));
var on_change_internal = ((function (id,field,map__32291,map__32291__$1,modifiers,attrs,label_attrs,twbs_modifiers,input_group_append,input_group_prepend,on_change,on_blur,required_mark){
return (function (event){
rui.forms.core.input_on_change_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(id,field,map__32291,map__32291__$1,modifiers,attrs,label_attrs,twbs_modifiers,input_group_append,input_group_prepend,on_change,on_blur,required_mark))
;
var on_blur_internal = ((function (id,field,on_change_internal,map__32291,map__32291__$1,modifiers,attrs,label_attrs,twbs_modifiers,input_group_append,input_group_prepend,on_change,on_blur,required_mark){
return (function (event){
rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_blur)){
return on_blur.call(null,event);
} else {
return null;
}
});})(id,field,on_change_internal,map__32291,map__32291__$1,modifiers,attrs,label_attrs,twbs_modifiers,input_group_append,input_group_prepend,on_change,on_blur,required_mark))
;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"input-field",cljs.core.name.call(null,field_id),cljs.core.conj.call(null,modifiers,rui.forms.core.field_state.call(null,form,field_id))))], null),((!((label == null)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label,(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null):null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_((function (){var or__3949__auto__ = input_group_prepend;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return input_group_append;
}
})())?"input-group":null)], null),((!((input_group_prepend == null)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-group-prepend","div.input-group-prepend",-1522435373),((typeof input_group_prepend === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-group-text","div.input-group-text",-1838140799),input_group_prepend], null):input_group_prepend)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),input_type,new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,ccn.core.twbs.call(null,"form-control",twbs_modifiers),rui.forms.components.field__GT_twbs_class.call(null,field)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form))),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),label,new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change_internal,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),on_blur_internal], null),attrs)], null),((!((input_group_append == null)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-group-append","div.input-group-append",-1462957134),((typeof input_group_append === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-group-text","div.input-group-text",-1838140799),input_group_append], null):input_group_append)], null):null),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form)),field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))], null):null)], null)], null);
});

rui.forms.components.input_field.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
rui.forms.components.input_field.cljs$lang$applyTo = (function (seq32285){
var G__32286 = cljs.core.first.call(null,seq32285);
var seq32285__$1 = cljs.core.next.call(null,seq32285);
var G__32287 = cljs.core.first.call(null,seq32285__$1);
var seq32285__$2 = cljs.core.next.call(null,seq32285__$1);
var G__32288 = cljs.core.first.call(null,seq32285__$2);
var seq32285__$3 = cljs.core.next.call(null,seq32285__$2);
var G__32289 = cljs.core.first.call(null,seq32285__$3);
var seq32285__$4 = cljs.core.next.call(null,seq32285__$3);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32286,G__32287,G__32288,G__32289,seq32285__$4);
});

rui.forms.components.input_text = cljs.core.partial.call(null,rui.forms.components.input_field,"text");
rui.forms.components.input_password = cljs.core.partial.call(null,rui.forms.components.input_field,"password");
rui.forms.components.input_number = cljs.core.partial.call(null,rui.forms.components.input_field,"number");
rui.forms.components.input_email = cljs.core.partial.call(null,rui.forms.components.input_field,"email");
rui.forms.components.input_file = (function rui$forms$components$input_file(var_args){
var args__4534__auto__ = [];
var len__4531__auto___32303 = arguments.length;
var i__4532__auto___32304 = (0);
while(true){
if((i__4532__auto___32304 < len__4531__auto___32303)){
args__4534__auto__.push((arguments[i__4532__auto___32304]));

var G__32305 = (i__4532__auto___32304 + (1));
i__4532__auto___32304 = G__32305;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.input_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.input_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__32300){
var map__32301 = p__32300;
var map__32301__$1 = ((((!((map__32301 == null)))?(((((map__32301.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32301.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32301):map__32301);
var kwargs = map__32301__$1;
var modifiers = cljs.core.get.call(null,map__32301__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834));
var attrs = cljs.core.get.call(null,map__32301__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var label_attrs = cljs.core.get.call(null,map__32301__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153));
var twbs_modifiers = cljs.core.get.call(null,map__32301__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072));
var on_blur = cljs.core.get.call(null,map__32301__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var on_change = cljs.core.get.call(null,map__32301__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var required_mark = cljs.core.get.call(null,map__32301__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
var field = cljs.core.get_in.call(null,form,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fields","fields",-1932066230),field_id], null));
var on_change_internal = ((function (id,field,map__32301,map__32301__$1,kwargs,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark){
return (function (event){
rui.forms.core.input_on_change_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(id,field,map__32301,map__32301__$1,kwargs,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark))
;
var on_blur_internal = ((function (id,field,on_change_internal,map__32301,map__32301__$1,kwargs,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark){
return (function (event){
rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_blur)){
return on_blur.call(null,event);
} else {
return null;
}
});})(id,field,on_change_internal,map__32301,map__32301__$1,kwargs,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark))
;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"input-field",cljs.core.conj.call(null,modifiers,rui.forms.core.field_state.call(null,form,field_id))))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.custom-file","div.custom-file",1258230266),((!((label == null)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label,(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),"file",new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,ccn.core.twbs.call(null,"form-control-file",twbs_modifiers),rui.forms.components.field__GT_twbs_class.call(null,field)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form))),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),label,new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change_internal,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),on_blur_internal], null),attrs)], null),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form)),field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))], null):null)], null)], null);
});

rui.forms.components.input_file.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.input_file.cljs$lang$applyTo = (function (seq32296){
var G__32297 = cljs.core.first.call(null,seq32296);
var seq32296__$1 = cljs.core.next.call(null,seq32296);
var G__32298 = cljs.core.first.call(null,seq32296__$1);
var seq32296__$2 = cljs.core.next.call(null,seq32296__$1);
var G__32299 = cljs.core.first.call(null,seq32296__$2);
var seq32296__$3 = cljs.core.next.call(null,seq32296__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32297,G__32298,G__32299,seq32296__$3);
});

rui.forms.components.text_area = (function rui$forms$components$text_area(var_args){
var args__4534__auto__ = [];
var len__4531__auto___32313 = arguments.length;
var i__4532__auto___32314 = (0);
while(true){
if((i__4532__auto___32314 < len__4531__auto___32313)){
args__4534__auto__.push((arguments[i__4532__auto___32314]));

var G__32315 = (i__4532__auto___32314 + (1));
i__4532__auto___32314 = G__32315;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.text_area.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.text_area.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__32310){
var map__32311 = p__32310;
var map__32311__$1 = ((((!((map__32311 == null)))?(((((map__32311.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32311.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32311):map__32311);
var modifiers = cljs.core.get.call(null,map__32311__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__32311__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.call(null,map__32311__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153),cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.call(null,map__32311__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var on_blur = cljs.core.get.call(null,map__32311__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var on_change = cljs.core.get.call(null,map__32311__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var required_mark = cljs.core.get.call(null,map__32311__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
var field = cljs.core.get_in.call(null,form,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fields","fields",-1932066230),field_id], null));
var on_change_internal = ((function (id,field,map__32311,map__32311__$1,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark){
return (function (event){
rui.forms.core.input_on_change_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(id,field,map__32311,map__32311__$1,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark))
;
var on_blur_internal = ((function (id,field,on_change_internal,map__32311,map__32311__$1,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark){
return (function (event){
rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_blur)){
return on_blur.call(null,event);
} else {
return null;
}
});})(id,field,on_change_internal,map__32311,map__32311__$1,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark))
;
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"text-area",cljs.core.conj.call(null,modifiers,rui.forms.core.field_state.call(null,form,field_id))))], null),((!((label == null)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label,(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,ccn.core.twbs.call(null,"form-control",twbs_modifiers),rui.forms.components.field__GT_twbs_class.call(null,field)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form))),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),label,new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change_internal,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),on_blur_internal], null),attrs)], null),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form)),field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))], null):null)], null);
});

rui.forms.components.text_area.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.text_area.cljs$lang$applyTo = (function (seq32306){
var G__32307 = cljs.core.first.call(null,seq32306);
var seq32306__$1 = cljs.core.next.call(null,seq32306);
var G__32308 = cljs.core.first.call(null,seq32306__$1);
var seq32306__$2 = cljs.core.next.call(null,seq32306__$1);
var G__32309 = cljs.core.first.call(null,seq32306__$2);
var seq32306__$3 = cljs.core.next.call(null,seq32306__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32307,G__32308,G__32309,seq32306__$3);
});

rui.forms.components.form_wrapper = (function rui$forms$components$form_wrapper(var_args){
var args__4534__auto__ = [];
var len__4531__auto___32322 = arguments.length;
var i__4532__auto___32323 = (0);
while(true){
if((i__4532__auto___32323 < len__4531__auto___32322)){
args__4534__auto__.push((arguments[i__4532__auto___32323]));

var G__32324 = (i__4532__auto___32323 + (1));
i__4532__auto___32323 = G__32324;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return rui.forms.components.form_wrapper.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

rui.forms.components.form_wrapper.cljs$core$IFn$_invoke$arity$variadic = (function (p__32319,children){
var map__32320 = p__32319;
var map__32320__$1 = ((((!((map__32320 == null)))?(((((map__32320.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32320.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32320):map__32320);
var kwargs = map__32320__$1;
var on_submit = cljs.core.get.call(null,map__32320__$1,new cljs.core.Keyword(null,"on-submit","on-submit",1227871159));
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"form-wrapper",new cljs.core.Keyword(null,"on-submit","on-submit",1227871159),((function (map__32320,map__32320__$1,kwargs,on_submit){
return (function (p1__32316_SHARP_){
p1__32316_SHARP_.preventDefault();

return on_submit.call(null,p1__32316_SHARP_);
});})(map__32320,map__32320__$1,kwargs,on_submit))
], null)], null),children);
});

rui.forms.components.form_wrapper.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
rui.forms.components.form_wrapper.cljs$lang$applyTo = (function (seq32317){
var G__32318 = cljs.core.first.call(null,seq32317);
var seq32317__$1 = cljs.core.next.call(null,seq32317);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32318,seq32317__$1);
});

rui.forms.components.button_submit = (function rui$forms$components$button_submit(var_args){
var args__4534__auto__ = [];
var len__4531__auto___32331 = arguments.length;
var i__4532__auto___32332 = (0);
while(true){
if((i__4532__auto___32332 < len__4531__auto___32331)){
args__4534__auto__.push((arguments[i__4532__auto___32332]));

var G__32333 = (i__4532__auto___32332 + (1));
i__4532__auto___32332 = G__32333;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((2) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((2)),(0),null)):null);
return rui.forms.components.button_submit.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4535__auto__);
});

rui.forms.components.button_submit.cljs$core$IFn$_invoke$arity$variadic = (function (title,on_click,p__32328){
var map__32329 = p__32328;
var map__32329__$1 = ((((!((map__32329 == null)))?(((((map__32329.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32329.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32329):map__32329);
var kwargs = map__32329__$1;
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.buttons.button_primary,title,on_click], null),cljs.core.apply.call(null,cljs.core.concat,cljs.core.merge.call(null,kwargs,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"modifiers","modifiers",50378834),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submit"], null)], null))));
});

rui.forms.components.button_submit.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
rui.forms.components.button_submit.cljs$lang$applyTo = (function (seq32325){
var G__32326 = cljs.core.first.call(null,seq32325);
var seq32325__$1 = cljs.core.next.call(null,seq32325);
var G__32327 = cljs.core.first.call(null,seq32325__$1);
var seq32325__$2 = cljs.core.next.call(null,seq32325__$1);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32326,G__32327,seq32325__$2);
});

rui.forms.components.plaintext = (function rui$forms$components$plaintext(var_args){
var args__4534__auto__ = [];
var len__4531__auto___32341 = arguments.length;
var i__4532__auto___32342 = (0);
while(true){
if((i__4532__auto___32342 < len__4531__auto___32341)){
args__4534__auto__.push((arguments[i__4532__auto___32342]));

var G__32343 = (i__4532__auto___32342 + (1));
i__4532__auto___32342 = G__32343;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.plaintext.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.plaintext.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__32338){
var map__32339 = p__32338;
var map__32339__$1 = ((((!((map__32339 == null)))?(((((map__32339.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32339.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32339):map__32339);
var modifiers = cljs.core.get.call(null,map__32339__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__32339__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.call(null,map__32339__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153),cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.call(null,map__32339__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"plaintext",cljs.core.conj.call(null,modifiers,rui.forms.core.field_state.call(null,form,field_id))))], null),((!((label == null)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"on-blur","on-blur",814300747),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.Keyword(null,"read-only","read-only",-191706886),new cljs.core.Keyword(null,"on-change","on-change",-732046149)],[label,id,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form))),cljs.core.partial.call(null,rui.forms.core.input_on_blur_BANG_,form,field_id),"text",id,ccn.core.twbs.call(null,"form-control-plaintext",twbs_modifiers),true,cljs.core.partial.call(null,rui.forms.core.input_on_change_BANG_,form,field_id)]),attrs)], null)], null);
});

rui.forms.components.plaintext.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.plaintext.cljs$lang$applyTo = (function (seq32334){
var G__32335 = cljs.core.first.call(null,seq32334);
var seq32334__$1 = cljs.core.next.call(null,seq32334);
var G__32336 = cljs.core.first.call(null,seq32334__$1);
var seq32334__$2 = cljs.core.next.call(null,seq32334__$1);
var G__32337 = cljs.core.first.call(null,seq32334__$2);
var seq32334__$3 = cljs.core.next.call(null,seq32334__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32335,G__32336,G__32337,seq32334__$3);
});


//# sourceMappingURL=components.js.map?rel=1561448346923
