// Compiled by ClojureScript 1.10.339 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined')){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__3949__auto__ = ((cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && ((((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string'))) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372))));
if(or__3949__auto__){
return or__3949__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__3949__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
var or__3949__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__3949__auto____$1)){
return or__3949__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__30295_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__30295_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.dependency_data !== 'undefined')){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__30296 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__30297 = null;
var count__30298 = (0);
var i__30299 = (0);
while(true){
if((i__30299 < count__30298)){
var n = cljs.core._nth.call(null,chunk__30297,i__30299);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__30300 = seq__30296;
var G__30301 = chunk__30297;
var G__30302 = count__30298;
var G__30303 = (i__30299 + (1));
seq__30296 = G__30300;
chunk__30297 = G__30301;
count__30298 = G__30302;
i__30299 = G__30303;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__30296);
if(temp__5457__auto__){
var seq__30296__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30296__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__30296__$1);
var G__30304 = cljs.core.chunk_rest.call(null,seq__30296__$1);
var G__30305 = c__4351__auto__;
var G__30306 = cljs.core.count.call(null,c__4351__auto__);
var G__30307 = (0);
seq__30296 = G__30304;
chunk__30297 = G__30305;
count__30298 = G__30306;
i__30299 = G__30307;
continue;
} else {
var n = cljs.core.first.call(null,seq__30296__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__30308 = cljs.core.next.call(null,seq__30296__$1);
var G__30309 = null;
var G__30310 = (0);
var G__30311 = (0);
seq__30296 = G__30308;
chunk__30297 = G__30309;
count__30298 = G__30310;
i__30299 = G__30311;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.in_upper_level_QMARK_ = (function figwheel$client$file_reloading$in_upper_level_QMARK_(topo_state,current_depth,dep){
return cljs.core.some.call(null,(function (p__30312){
var vec__30313 = p__30312;
var _ = cljs.core.nth.call(null,vec__30313,(0),null);
var v = cljs.core.nth.call(null,vec__30313,(1),null);
var and__3938__auto__ = v;
if(cljs.core.truth_(and__3938__auto__)){
return v.call(null,dep);
} else {
return and__3938__auto__;
}
}),cljs.core.filter.call(null,(function (p__30316){
var vec__30317 = p__30316;
var k = cljs.core.nth.call(null,vec__30317,(0),null);
var v = cljs.core.nth.call(null,vec__30317,(1),null);
return (k > current_depth);
}),topo_state));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__30329_30337 = cljs.core.seq.call(null,deps);
var chunk__30330_30338 = null;
var count__30331_30339 = (0);
var i__30332_30340 = (0);
while(true){
if((i__30332_30340 < count__30331_30339)){
var dep_30341 = cljs.core._nth.call(null,chunk__30330_30338,i__30332_30340);
if(cljs.core.truth_((function (){var and__3938__auto__ = dep_30341;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_30341));
} else {
return and__3938__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_30341,(depth + (1)),state);
} else {
}


var G__30342 = seq__30329_30337;
var G__30343 = chunk__30330_30338;
var G__30344 = count__30331_30339;
var G__30345 = (i__30332_30340 + (1));
seq__30329_30337 = G__30342;
chunk__30330_30338 = G__30343;
count__30331_30339 = G__30344;
i__30332_30340 = G__30345;
continue;
} else {
var temp__5457__auto___30346 = cljs.core.seq.call(null,seq__30329_30337);
if(temp__5457__auto___30346){
var seq__30329_30347__$1 = temp__5457__auto___30346;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30329_30347__$1)){
var c__4351__auto___30348 = cljs.core.chunk_first.call(null,seq__30329_30347__$1);
var G__30349 = cljs.core.chunk_rest.call(null,seq__30329_30347__$1);
var G__30350 = c__4351__auto___30348;
var G__30351 = cljs.core.count.call(null,c__4351__auto___30348);
var G__30352 = (0);
seq__30329_30337 = G__30349;
chunk__30330_30338 = G__30350;
count__30331_30339 = G__30351;
i__30332_30340 = G__30352;
continue;
} else {
var dep_30353 = cljs.core.first.call(null,seq__30329_30347__$1);
if(cljs.core.truth_((function (){var and__3938__auto__ = dep_30353;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_30353));
} else {
return and__3938__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_30353,(depth + (1)),state);
} else {
}


var G__30354 = cljs.core.next.call(null,seq__30329_30347__$1);
var G__30355 = null;
var G__30356 = (0);
var G__30357 = (0);
seq__30329_30337 = G__30354;
chunk__30330_30338 = G__30355;
count__30331_30339 = G__30356;
i__30332_30340 = G__30357;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__30333){
var vec__30334 = p__30333;
var seq__30335 = cljs.core.seq.call(null,vec__30334);
var first__30336 = cljs.core.first.call(null,seq__30335);
var seq__30335__$1 = cljs.core.next.call(null,seq__30335);
var x = first__30336;
var xs = seq__30335__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__30334,seq__30335,first__30336,seq__30335__$1,x,xs,get_deps__$1){
return (function (p1__30320_SHARP_){
return clojure.set.difference.call(null,p1__30320_SHARP_,x);
});})(vec__30334,seq__30335,first__30336,seq__30335__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__30358 = cljs.core.seq.call(null,provides);
var chunk__30359 = null;
var count__30360 = (0);
var i__30361 = (0);
while(true){
if((i__30361 < count__30360)){
var prov = cljs.core._nth.call(null,chunk__30359,i__30361);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__30362_30370 = cljs.core.seq.call(null,requires);
var chunk__30363_30371 = null;
var count__30364_30372 = (0);
var i__30365_30373 = (0);
while(true){
if((i__30365_30373 < count__30364_30372)){
var req_30374 = cljs.core._nth.call(null,chunk__30363_30371,i__30365_30373);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30374,prov);


var G__30375 = seq__30362_30370;
var G__30376 = chunk__30363_30371;
var G__30377 = count__30364_30372;
var G__30378 = (i__30365_30373 + (1));
seq__30362_30370 = G__30375;
chunk__30363_30371 = G__30376;
count__30364_30372 = G__30377;
i__30365_30373 = G__30378;
continue;
} else {
var temp__5457__auto___30379 = cljs.core.seq.call(null,seq__30362_30370);
if(temp__5457__auto___30379){
var seq__30362_30380__$1 = temp__5457__auto___30379;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30362_30380__$1)){
var c__4351__auto___30381 = cljs.core.chunk_first.call(null,seq__30362_30380__$1);
var G__30382 = cljs.core.chunk_rest.call(null,seq__30362_30380__$1);
var G__30383 = c__4351__auto___30381;
var G__30384 = cljs.core.count.call(null,c__4351__auto___30381);
var G__30385 = (0);
seq__30362_30370 = G__30382;
chunk__30363_30371 = G__30383;
count__30364_30372 = G__30384;
i__30365_30373 = G__30385;
continue;
} else {
var req_30386 = cljs.core.first.call(null,seq__30362_30380__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30386,prov);


var G__30387 = cljs.core.next.call(null,seq__30362_30380__$1);
var G__30388 = null;
var G__30389 = (0);
var G__30390 = (0);
seq__30362_30370 = G__30387;
chunk__30363_30371 = G__30388;
count__30364_30372 = G__30389;
i__30365_30373 = G__30390;
continue;
}
} else {
}
}
break;
}


var G__30391 = seq__30358;
var G__30392 = chunk__30359;
var G__30393 = count__30360;
var G__30394 = (i__30361 + (1));
seq__30358 = G__30391;
chunk__30359 = G__30392;
count__30360 = G__30393;
i__30361 = G__30394;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__30358);
if(temp__5457__auto__){
var seq__30358__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30358__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__30358__$1);
var G__30395 = cljs.core.chunk_rest.call(null,seq__30358__$1);
var G__30396 = c__4351__auto__;
var G__30397 = cljs.core.count.call(null,c__4351__auto__);
var G__30398 = (0);
seq__30358 = G__30395;
chunk__30359 = G__30396;
count__30360 = G__30397;
i__30361 = G__30398;
continue;
} else {
var prov = cljs.core.first.call(null,seq__30358__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__30366_30399 = cljs.core.seq.call(null,requires);
var chunk__30367_30400 = null;
var count__30368_30401 = (0);
var i__30369_30402 = (0);
while(true){
if((i__30369_30402 < count__30368_30401)){
var req_30403 = cljs.core._nth.call(null,chunk__30367_30400,i__30369_30402);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30403,prov);


var G__30404 = seq__30366_30399;
var G__30405 = chunk__30367_30400;
var G__30406 = count__30368_30401;
var G__30407 = (i__30369_30402 + (1));
seq__30366_30399 = G__30404;
chunk__30367_30400 = G__30405;
count__30368_30401 = G__30406;
i__30369_30402 = G__30407;
continue;
} else {
var temp__5457__auto___30408__$1 = cljs.core.seq.call(null,seq__30366_30399);
if(temp__5457__auto___30408__$1){
var seq__30366_30409__$1 = temp__5457__auto___30408__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30366_30409__$1)){
var c__4351__auto___30410 = cljs.core.chunk_first.call(null,seq__30366_30409__$1);
var G__30411 = cljs.core.chunk_rest.call(null,seq__30366_30409__$1);
var G__30412 = c__4351__auto___30410;
var G__30413 = cljs.core.count.call(null,c__4351__auto___30410);
var G__30414 = (0);
seq__30366_30399 = G__30411;
chunk__30367_30400 = G__30412;
count__30368_30401 = G__30413;
i__30369_30402 = G__30414;
continue;
} else {
var req_30415 = cljs.core.first.call(null,seq__30366_30409__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30415,prov);


var G__30416 = cljs.core.next.call(null,seq__30366_30409__$1);
var G__30417 = null;
var G__30418 = (0);
var G__30419 = (0);
seq__30366_30399 = G__30416;
chunk__30367_30400 = G__30417;
count__30368_30401 = G__30418;
i__30369_30402 = G__30419;
continue;
}
} else {
}
}
break;
}


var G__30420 = cljs.core.next.call(null,seq__30358__$1);
var G__30421 = null;
var G__30422 = (0);
var G__30423 = (0);
seq__30358 = G__30420;
chunk__30359 = G__30421;
count__30360 = G__30422;
i__30361 = G__30423;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__30424_30428 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__30425_30429 = null;
var count__30426_30430 = (0);
var i__30427_30431 = (0);
while(true){
if((i__30427_30431 < count__30426_30430)){
var ns_30432 = cljs.core._nth.call(null,chunk__30425_30429,i__30427_30431);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_30432);


var G__30433 = seq__30424_30428;
var G__30434 = chunk__30425_30429;
var G__30435 = count__30426_30430;
var G__30436 = (i__30427_30431 + (1));
seq__30424_30428 = G__30433;
chunk__30425_30429 = G__30434;
count__30426_30430 = G__30435;
i__30427_30431 = G__30436;
continue;
} else {
var temp__5457__auto___30437 = cljs.core.seq.call(null,seq__30424_30428);
if(temp__5457__auto___30437){
var seq__30424_30438__$1 = temp__5457__auto___30437;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30424_30438__$1)){
var c__4351__auto___30439 = cljs.core.chunk_first.call(null,seq__30424_30438__$1);
var G__30440 = cljs.core.chunk_rest.call(null,seq__30424_30438__$1);
var G__30441 = c__4351__auto___30439;
var G__30442 = cljs.core.count.call(null,c__4351__auto___30439);
var G__30443 = (0);
seq__30424_30428 = G__30440;
chunk__30425_30429 = G__30441;
count__30426_30430 = G__30442;
i__30427_30431 = G__30443;
continue;
} else {
var ns_30444 = cljs.core.first.call(null,seq__30424_30438__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_30444);


var G__30445 = cljs.core.next.call(null,seq__30424_30438__$1);
var G__30446 = null;
var G__30447 = (0);
var G__30448 = (0);
seq__30424_30428 = G__30445;
chunk__30425_30429 = G__30446;
count__30426_30430 = G__30447;
i__30427_30431 = G__30448;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__3949__auto__ = goog.require__;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__30449__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__30449 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__30450__i = 0, G__30450__a = new Array(arguments.length -  0);
while (G__30450__i < G__30450__a.length) {G__30450__a[G__30450__i] = arguments[G__30450__i + 0]; ++G__30450__i;}
  args = new cljs.core.IndexedSeq(G__30450__a,0,null);
} 
return G__30449__delegate.call(this,args);};
G__30449.cljs$lang$maxFixedArity = 0;
G__30449.cljs$lang$applyTo = (function (arglist__30451){
var args = cljs.core.seq(arglist__30451);
return G__30449__delegate(args);
});
G__30449.cljs$core$IFn$_invoke$arity$variadic = G__30449__delegate;
return G__30449;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined')){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = (((typeof goog !== 'undefined') && (typeof goog.net !== 'undefined') && (typeof goog.net.jsloader !== 'undefined') && (typeof goog.net.jsloader.safeLoad !== 'undefined'))?(function (p1__30452_SHARP_,p2__30453_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30452_SHARP_)].join('')),p2__30453_SHARP_);
}):(((typeof goog !== 'undefined') && (typeof goog.net !== 'undefined') && (typeof goog.net.jsloader !== 'undefined') && (typeof goog.net.jsloader.load !== 'undefined'))?(function (p1__30454_SHARP_,p2__30455_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30454_SHARP_)].join(''),p2__30455_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__30456 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__30456.addCallback(((function (G__30456){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__30456))
);

G__30456.addErrback(((function (G__30456){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__30456))
);

return G__30456;
});
figwheel.client.file_reloading.write_script_tag_import = figwheel.client.file_reloading.reload_file_in_html_env;
goog.exportSymbol('figwheel.client.file_reloading.write_script_tag_import', figwheel.client.file_reloading.write_script_tag_import);
figwheel.client.file_reloading.worker_import_script = (function figwheel$client$file_reloading$worker_import_script(request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e30457){if((e30457 instanceof Error)){
var e = e30457;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e30457;

}
}})());
});
goog.exportSymbol('figwheel.client.file_reloading.worker_import_script', figwheel.client.file_reloading.worker_import_script);
figwheel.client.file_reloading.create_node_script_import_fn = (function figwheel$client$file_reloading$create_node_script_import_fn(){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e30458){if((e30458 instanceof Error)){
var e = e30458;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e30458;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path))
});
goog.exportSymbol('figwheel.client.file_reloading.create_node_script_import_fn', figwheel.client.file_reloading.create_node_script_import_fn);
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__30459 = cljs.core._EQ_;
var expr__30460 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__30459.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__30460))){
return figwheel.client.file_reloading.create_node_script_import_fn.call(null);
} else {
if(cljs.core.truth_(pred__30459.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__30460))){
return figwheel.client.file_reloading.write_script_tag_import;
} else {
if(cljs.core.truth_(pred__30459.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__30460))){
return figwheel.client.file_reloading.worker_import_script;
} else {
return ((function (pred__30459,expr__30460){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__30459,expr__30460))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__30462,callback){
var map__30463 = p__30462;
var map__30463__$1 = ((((!((map__30463 == null)))?(((((map__30463.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30463.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30463):map__30463);
var file_msg = map__30463__$1;
var request_url = cljs.core.get.call(null,map__30463__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return (function (){var or__3949__auto__ = goog.object.get(goog.global,"FIGWHEEL_IMPORT_SCRIPT");
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return figwheel.client.file_reloading.reload_file_STAR_;
}
})().call(null,request_url,((function (map__30463,map__30463__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__30463,map__30463__$1,file_msg,request_url))
);
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reload_chan !== 'undefined')){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined')){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined')){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reloader_loop !== 'undefined')){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__25422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto__){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto__){
return (function (state_30501){
var state_val_30502 = (state_30501[(1)]);
if((state_val_30502 === (7))){
var inst_30497 = (state_30501[(2)]);
var state_30501__$1 = state_30501;
var statearr_30503_30529 = state_30501__$1;
(statearr_30503_30529[(2)] = inst_30497);

(statearr_30503_30529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30502 === (1))){
var state_30501__$1 = state_30501;
var statearr_30504_30530 = state_30501__$1;
(statearr_30504_30530[(2)] = null);

(statearr_30504_30530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30502 === (4))){
var inst_30467 = (state_30501[(7)]);
var inst_30467__$1 = (state_30501[(2)]);
var state_30501__$1 = (function (){var statearr_30505 = state_30501;
(statearr_30505[(7)] = inst_30467__$1);

return statearr_30505;
})();
if(cljs.core.truth_(inst_30467__$1)){
var statearr_30506_30531 = state_30501__$1;
(statearr_30506_30531[(1)] = (5));

} else {
var statearr_30507_30532 = state_30501__$1;
(statearr_30507_30532[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30502 === (15))){
var inst_30480 = (state_30501[(8)]);
var inst_30482 = (state_30501[(9)]);
var inst_30484 = inst_30482.call(null,inst_30480);
var state_30501__$1 = state_30501;
var statearr_30508_30533 = state_30501__$1;
(statearr_30508_30533[(2)] = inst_30484);

(statearr_30508_30533[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30502 === (13))){
var inst_30491 = (state_30501[(2)]);
var state_30501__$1 = state_30501;
var statearr_30509_30534 = state_30501__$1;
(statearr_30509_30534[(2)] = inst_30491);

(statearr_30509_30534[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30502 === (6))){
var state_30501__$1 = state_30501;
var statearr_30510_30535 = state_30501__$1;
(statearr_30510_30535[(2)] = null);

(statearr_30510_30535[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30502 === (17))){
var inst_30488 = (state_30501[(2)]);
var state_30501__$1 = state_30501;
var statearr_30511_30536 = state_30501__$1;
(statearr_30511_30536[(2)] = inst_30488);

(statearr_30511_30536[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30502 === (3))){
var inst_30499 = (state_30501[(2)]);
var state_30501__$1 = state_30501;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30501__$1,inst_30499);
} else {
if((state_val_30502 === (12))){
var state_30501__$1 = state_30501;
var statearr_30512_30537 = state_30501__$1;
(statearr_30512_30537[(2)] = null);

(statearr_30512_30537[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30502 === (2))){
var state_30501__$1 = state_30501;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30501__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_30502 === (11))){
var inst_30472 = (state_30501[(10)]);
var inst_30478 = figwheel.client.file_reloading.blocking_load.call(null,inst_30472);
var state_30501__$1 = state_30501;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30501__$1,(14),inst_30478);
} else {
if((state_val_30502 === (9))){
var inst_30472 = (state_30501[(10)]);
var state_30501__$1 = state_30501;
if(cljs.core.truth_(inst_30472)){
var statearr_30513_30538 = state_30501__$1;
(statearr_30513_30538[(1)] = (11));

} else {
var statearr_30514_30539 = state_30501__$1;
(statearr_30514_30539[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30502 === (5))){
var inst_30467 = (state_30501[(7)]);
var inst_30473 = (state_30501[(11)]);
var inst_30472 = cljs.core.nth.call(null,inst_30467,(0),null);
var inst_30473__$1 = cljs.core.nth.call(null,inst_30467,(1),null);
var state_30501__$1 = (function (){var statearr_30515 = state_30501;
(statearr_30515[(11)] = inst_30473__$1);

(statearr_30515[(10)] = inst_30472);

return statearr_30515;
})();
if(cljs.core.truth_(inst_30473__$1)){
var statearr_30516_30540 = state_30501__$1;
(statearr_30516_30540[(1)] = (8));

} else {
var statearr_30517_30541 = state_30501__$1;
(statearr_30517_30541[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30502 === (14))){
var inst_30472 = (state_30501[(10)]);
var inst_30482 = (state_30501[(9)]);
var inst_30480 = (state_30501[(2)]);
var inst_30481 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_30482__$1 = cljs.core.get.call(null,inst_30481,inst_30472);
var state_30501__$1 = (function (){var statearr_30518 = state_30501;
(statearr_30518[(8)] = inst_30480);

(statearr_30518[(9)] = inst_30482__$1);

return statearr_30518;
})();
if(cljs.core.truth_(inst_30482__$1)){
var statearr_30519_30542 = state_30501__$1;
(statearr_30519_30542[(1)] = (15));

} else {
var statearr_30520_30543 = state_30501__$1;
(statearr_30520_30543[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30502 === (16))){
var inst_30480 = (state_30501[(8)]);
var inst_30486 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_30480);
var state_30501__$1 = state_30501;
var statearr_30521_30544 = state_30501__$1;
(statearr_30521_30544[(2)] = inst_30486);

(statearr_30521_30544[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30502 === (10))){
var inst_30493 = (state_30501[(2)]);
var state_30501__$1 = (function (){var statearr_30522 = state_30501;
(statearr_30522[(12)] = inst_30493);

return statearr_30522;
})();
var statearr_30523_30545 = state_30501__$1;
(statearr_30523_30545[(2)] = null);

(statearr_30523_30545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30502 === (8))){
var inst_30473 = (state_30501[(11)]);
var inst_30475 = eval(inst_30473);
var state_30501__$1 = state_30501;
var statearr_30524_30546 = state_30501__$1;
(statearr_30524_30546[(2)] = inst_30475);

(statearr_30524_30546[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto__))
;
return ((function (switch__25331__auto__,c__25422__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__25332__auto__ = null;
var figwheel$client$file_reloading$state_machine__25332__auto____0 = (function (){
var statearr_30525 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30525[(0)] = figwheel$client$file_reloading$state_machine__25332__auto__);

(statearr_30525[(1)] = (1));

return statearr_30525;
});
var figwheel$client$file_reloading$state_machine__25332__auto____1 = (function (state_30501){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_30501);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e30526){if((e30526 instanceof Object)){
var ex__25335__auto__ = e30526;
var statearr_30527_30547 = state_30501;
(statearr_30527_30547[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30501);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30526;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30548 = state_30501;
state_30501 = G__30548;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__25332__auto__ = function(state_30501){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__25332__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__25332__auto____1.call(this,state_30501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__25332__auto____0;
figwheel$client$file_reloading$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__25332__auto____1;
return figwheel$client$file_reloading$state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto__))
})();
var state__25424__auto__ = (function (){var statearr_30528 = f__25423__auto__.call(null);
(statearr_30528[(6)] = c__25422__auto__);

return statearr_30528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto__))
);

return c__25422__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(var_args){
var G__30550 = arguments.length;
switch (G__30550) {
case 1:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1 = (function (url){
return figwheel.client.file_reloading.queued_file_reload.call(null,url,null);
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2 = (function (url,opt_source_text){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,opt_source_text], null));
});

figwheel.client.file_reloading.queued_file_reload.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__30552,callback){
var map__30553 = p__30552;
var map__30553__$1 = ((((!((map__30553 == null)))?(((((map__30553.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30553.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30553):map__30553);
var file_msg = map__30553__$1;
var namespace = cljs.core.get.call(null,map__30553__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__30553,map__30553__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__30553,map__30553__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__30555){
var map__30556 = p__30555;
var map__30556__$1 = ((((!((map__30556 == null)))?(((((map__30556.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30556.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30556):map__30556);
var file_msg = map__30556__$1;
var namespace = cljs.core.get.call(null,map__30556__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.ns_exists_QMARK_ = (function figwheel$client$file_reloading$ns_exists_QMARK_(namespace){
return !((cljs.core.reduce.call(null,cljs.core.fnil.call(null,goog.object.get,({})),goog.global,clojure.string.split.call(null,cljs.core.name.call(null,namespace),".")) == null));
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__30558){
var map__30559 = p__30558;
var map__30559__$1 = ((((!((map__30559 == null)))?(((((map__30559.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30559.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30559):map__30559);
var file_msg = map__30559__$1;
var namespace = cljs.core.get.call(null,map__30559__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__3938__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__3938__auto__){
var or__3949__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
var or__3949__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__3949__auto____$1)){
return or__3949__auto____$1;
} else {
var or__3949__auto____$2 = figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
if(cljs.core.truth_(or__3949__auto____$2)){
return or__3949__auto____$2;
} else {
return figwheel.client.file_reloading.ns_exists_QMARK_.call(null,namespace);
}
}
}
} else {
return and__3938__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__30561,callback){
var map__30562 = p__30561;
var map__30562__$1 = ((((!((map__30562 == null)))?(((((map__30562.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30562.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30562):map__30562);
var file_msg = map__30562__$1;
var request_url = cljs.core.get.call(null,map__30562__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__30562__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__25422__auto___30612 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___30612,out){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___30612,out){
return (function (state_30597){
var state_val_30598 = (state_30597[(1)]);
if((state_val_30598 === (1))){
var inst_30571 = cljs.core.seq.call(null,files);
var inst_30572 = cljs.core.first.call(null,inst_30571);
var inst_30573 = cljs.core.next.call(null,inst_30571);
var inst_30574 = files;
var state_30597__$1 = (function (){var statearr_30599 = state_30597;
(statearr_30599[(7)] = inst_30574);

(statearr_30599[(8)] = inst_30573);

(statearr_30599[(9)] = inst_30572);

return statearr_30599;
})();
var statearr_30600_30613 = state_30597__$1;
(statearr_30600_30613[(2)] = null);

(statearr_30600_30613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (2))){
var inst_30580 = (state_30597[(10)]);
var inst_30574 = (state_30597[(7)]);
var inst_30579 = cljs.core.seq.call(null,inst_30574);
var inst_30580__$1 = cljs.core.first.call(null,inst_30579);
var inst_30581 = cljs.core.next.call(null,inst_30579);
var inst_30582 = (inst_30580__$1 == null);
var inst_30583 = cljs.core.not.call(null,inst_30582);
var state_30597__$1 = (function (){var statearr_30601 = state_30597;
(statearr_30601[(10)] = inst_30580__$1);

(statearr_30601[(11)] = inst_30581);

return statearr_30601;
})();
if(inst_30583){
var statearr_30602_30614 = state_30597__$1;
(statearr_30602_30614[(1)] = (4));

} else {
var statearr_30603_30615 = state_30597__$1;
(statearr_30603_30615[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (3))){
var inst_30595 = (state_30597[(2)]);
var state_30597__$1 = state_30597;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30597__$1,inst_30595);
} else {
if((state_val_30598 === (4))){
var inst_30580 = (state_30597[(10)]);
var inst_30585 = figwheel.client.file_reloading.reload_js_file.call(null,inst_30580);
var state_30597__$1 = state_30597;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30597__$1,(7),inst_30585);
} else {
if((state_val_30598 === (5))){
var inst_30591 = cljs.core.async.close_BANG_.call(null,out);
var state_30597__$1 = state_30597;
var statearr_30604_30616 = state_30597__$1;
(statearr_30604_30616[(2)] = inst_30591);

(statearr_30604_30616[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (6))){
var inst_30593 = (state_30597[(2)]);
var state_30597__$1 = state_30597;
var statearr_30605_30617 = state_30597__$1;
(statearr_30605_30617[(2)] = inst_30593);

(statearr_30605_30617[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (7))){
var inst_30581 = (state_30597[(11)]);
var inst_30587 = (state_30597[(2)]);
var inst_30588 = cljs.core.async.put_BANG_.call(null,out,inst_30587);
var inst_30574 = inst_30581;
var state_30597__$1 = (function (){var statearr_30606 = state_30597;
(statearr_30606[(12)] = inst_30588);

(statearr_30606[(7)] = inst_30574);

return statearr_30606;
})();
var statearr_30607_30618 = state_30597__$1;
(statearr_30607_30618[(2)] = null);

(statearr_30607_30618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__25422__auto___30612,out))
;
return ((function (switch__25331__auto__,c__25422__auto___30612,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__25332__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__25332__auto____0 = (function (){
var statearr_30608 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30608[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__25332__auto__);

(statearr_30608[(1)] = (1));

return statearr_30608;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__25332__auto____1 = (function (state_30597){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_30597);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e30609){if((e30609 instanceof Object)){
var ex__25335__auto__ = e30609;
var statearr_30610_30619 = state_30597;
(statearr_30610_30619[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30597);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30609;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30620 = state_30597;
state_30597 = G__30620;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__25332__auto__ = function(state_30597){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__25332__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__25332__auto____1.call(this,state_30597);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__25332__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__25332__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___30612,out))
})();
var state__25424__auto__ = (function (){var statearr_30611 = f__25423__auto__.call(null);
(statearr_30611[(6)] = c__25422__auto___30612);

return statearr_30611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___30612,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__30621,opts){
var map__30622 = p__30621;
var map__30622__$1 = ((((!((map__30622 == null)))?(((((map__30622.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30622.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30622):map__30622);
var eval_body = cljs.core.get.call(null,map__30622__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__30622__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__3938__auto__ = eval_body;
if(cljs.core.truth_(and__3938__auto__)){
return typeof eval_body === 'string';
} else {
return and__3938__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e30624){var e = e30624;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__5455__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__30625_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__30625_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__5455__auto__)){
var file_msg = temp__5455__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__30626){
var vec__30627 = p__30626;
var k = cljs.core.nth.call(null,vec__30627,(0),null);
var v = cljs.core.nth.call(null,vec__30627,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__30630){
var vec__30631 = p__30630;
var k = cljs.core.nth.call(null,vec__30631,(0),null);
var v = cljs.core.nth.call(null,vec__30631,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__30637,p__30638){
var map__30639 = p__30637;
var map__30639__$1 = ((((!((map__30639 == null)))?(((((map__30639.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30639.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30639):map__30639);
var opts = map__30639__$1;
var before_jsload = cljs.core.get.call(null,map__30639__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__30639__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__30639__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__30640 = p__30638;
var map__30640__$1 = ((((!((map__30640 == null)))?(((((map__30640.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30640.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30640):map__30640);
var msg = map__30640__$1;
var files = cljs.core.get.call(null,map__30640__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__30640__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__30640__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__25422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_30794){
var state_val_30795 = (state_30794[(1)]);
if((state_val_30795 === (7))){
var inst_30654 = (state_30794[(7)]);
var inst_30657 = (state_30794[(8)]);
var inst_30656 = (state_30794[(9)]);
var inst_30655 = (state_30794[(10)]);
var inst_30662 = cljs.core._nth.call(null,inst_30655,inst_30657);
var inst_30663 = figwheel.client.file_reloading.eval_body.call(null,inst_30662,opts);
var inst_30664 = (inst_30657 + (1));
var tmp30796 = inst_30654;
var tmp30797 = inst_30656;
var tmp30798 = inst_30655;
var inst_30654__$1 = tmp30796;
var inst_30655__$1 = tmp30798;
var inst_30656__$1 = tmp30797;
var inst_30657__$1 = inst_30664;
var state_30794__$1 = (function (){var statearr_30799 = state_30794;
(statearr_30799[(11)] = inst_30663);

(statearr_30799[(7)] = inst_30654__$1);

(statearr_30799[(8)] = inst_30657__$1);

(statearr_30799[(9)] = inst_30656__$1);

(statearr_30799[(10)] = inst_30655__$1);

return statearr_30799;
})();
var statearr_30800_30883 = state_30794__$1;
(statearr_30800_30883[(2)] = null);

(statearr_30800_30883[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (20))){
var inst_30697 = (state_30794[(12)]);
var inst_30705 = figwheel.client.file_reloading.sort_files.call(null,inst_30697);
var state_30794__$1 = state_30794;
var statearr_30801_30884 = state_30794__$1;
(statearr_30801_30884[(2)] = inst_30705);

(statearr_30801_30884[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (27))){
var state_30794__$1 = state_30794;
var statearr_30802_30885 = state_30794__$1;
(statearr_30802_30885[(2)] = null);

(statearr_30802_30885[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (1))){
var inst_30646 = (state_30794[(13)]);
var inst_30643 = before_jsload.call(null,files);
var inst_30644 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_30645 = (function (){return ((function (inst_30646,inst_30643,inst_30644,state_val_30795,c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__30634_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__30634_SHARP_);
});
;})(inst_30646,inst_30643,inst_30644,state_val_30795,c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_30646__$1 = cljs.core.filter.call(null,inst_30645,files);
var inst_30647 = cljs.core.not_empty.call(null,inst_30646__$1);
var state_30794__$1 = (function (){var statearr_30803 = state_30794;
(statearr_30803[(14)] = inst_30643);

(statearr_30803[(15)] = inst_30644);

(statearr_30803[(13)] = inst_30646__$1);

return statearr_30803;
})();
if(cljs.core.truth_(inst_30647)){
var statearr_30804_30886 = state_30794__$1;
(statearr_30804_30886[(1)] = (2));

} else {
var statearr_30805_30887 = state_30794__$1;
(statearr_30805_30887[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (24))){
var state_30794__$1 = state_30794;
var statearr_30806_30888 = state_30794__$1;
(statearr_30806_30888[(2)] = null);

(statearr_30806_30888[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (39))){
var inst_30747 = (state_30794[(16)]);
var state_30794__$1 = state_30794;
var statearr_30807_30889 = state_30794__$1;
(statearr_30807_30889[(2)] = inst_30747);

(statearr_30807_30889[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (46))){
var inst_30789 = (state_30794[(2)]);
var state_30794__$1 = state_30794;
var statearr_30808_30890 = state_30794__$1;
(statearr_30808_30890[(2)] = inst_30789);

(statearr_30808_30890[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (4))){
var inst_30691 = (state_30794[(2)]);
var inst_30692 = cljs.core.List.EMPTY;
var inst_30693 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_30692);
var inst_30694 = (function (){return ((function (inst_30691,inst_30692,inst_30693,state_val_30795,c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__30635_SHARP_){
var and__3938__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__30635_SHARP_);
if(cljs.core.truth_(and__3938__auto__)){
return ((cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__30635_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__30635_SHARP_))));
} else {
return and__3938__auto__;
}
});
;})(inst_30691,inst_30692,inst_30693,state_val_30795,c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_30695 = cljs.core.filter.call(null,inst_30694,files);
var inst_30696 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_30697 = cljs.core.concat.call(null,inst_30695,inst_30696);
var state_30794__$1 = (function (){var statearr_30809 = state_30794;
(statearr_30809[(12)] = inst_30697);

(statearr_30809[(17)] = inst_30691);

(statearr_30809[(18)] = inst_30693);

return statearr_30809;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_30810_30891 = state_30794__$1;
(statearr_30810_30891[(1)] = (16));

} else {
var statearr_30811_30892 = state_30794__$1;
(statearr_30811_30892[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (15))){
var inst_30681 = (state_30794[(2)]);
var state_30794__$1 = state_30794;
var statearr_30812_30893 = state_30794__$1;
(statearr_30812_30893[(2)] = inst_30681);

(statearr_30812_30893[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (21))){
var inst_30707 = (state_30794[(19)]);
var inst_30707__$1 = (state_30794[(2)]);
var inst_30708 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_30707__$1);
var state_30794__$1 = (function (){var statearr_30813 = state_30794;
(statearr_30813[(19)] = inst_30707__$1);

return statearr_30813;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30794__$1,(22),inst_30708);
} else {
if((state_val_30795 === (31))){
var inst_30792 = (state_30794[(2)]);
var state_30794__$1 = state_30794;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30794__$1,inst_30792);
} else {
if((state_val_30795 === (32))){
var inst_30747 = (state_30794[(16)]);
var inst_30752 = inst_30747.cljs$lang$protocol_mask$partition0$;
var inst_30753 = (inst_30752 & (64));
var inst_30754 = inst_30747.cljs$core$ISeq$;
var inst_30755 = (cljs.core.PROTOCOL_SENTINEL === inst_30754);
var inst_30756 = ((inst_30753) || (inst_30755));
var state_30794__$1 = state_30794;
if(cljs.core.truth_(inst_30756)){
var statearr_30814_30894 = state_30794__$1;
(statearr_30814_30894[(1)] = (35));

} else {
var statearr_30815_30895 = state_30794__$1;
(statearr_30815_30895[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (40))){
var inst_30769 = (state_30794[(20)]);
var inst_30768 = (state_30794[(2)]);
var inst_30769__$1 = cljs.core.get.call(null,inst_30768,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_30770 = cljs.core.get.call(null,inst_30768,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_30771 = cljs.core.not_empty.call(null,inst_30769__$1);
var state_30794__$1 = (function (){var statearr_30816 = state_30794;
(statearr_30816[(20)] = inst_30769__$1);

(statearr_30816[(21)] = inst_30770);

return statearr_30816;
})();
if(cljs.core.truth_(inst_30771)){
var statearr_30817_30896 = state_30794__$1;
(statearr_30817_30896[(1)] = (41));

} else {
var statearr_30818_30897 = state_30794__$1;
(statearr_30818_30897[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (33))){
var state_30794__$1 = state_30794;
var statearr_30819_30898 = state_30794__$1;
(statearr_30819_30898[(2)] = false);

(statearr_30819_30898[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (13))){
var inst_30667 = (state_30794[(22)]);
var inst_30671 = cljs.core.chunk_first.call(null,inst_30667);
var inst_30672 = cljs.core.chunk_rest.call(null,inst_30667);
var inst_30673 = cljs.core.count.call(null,inst_30671);
var inst_30654 = inst_30672;
var inst_30655 = inst_30671;
var inst_30656 = inst_30673;
var inst_30657 = (0);
var state_30794__$1 = (function (){var statearr_30820 = state_30794;
(statearr_30820[(7)] = inst_30654);

(statearr_30820[(8)] = inst_30657);

(statearr_30820[(9)] = inst_30656);

(statearr_30820[(10)] = inst_30655);

return statearr_30820;
})();
var statearr_30821_30899 = state_30794__$1;
(statearr_30821_30899[(2)] = null);

(statearr_30821_30899[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (22))){
var inst_30707 = (state_30794[(19)]);
var inst_30711 = (state_30794[(23)]);
var inst_30715 = (state_30794[(24)]);
var inst_30710 = (state_30794[(25)]);
var inst_30710__$1 = (state_30794[(2)]);
var inst_30711__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_30710__$1);
var inst_30712 = (function (){var all_files = inst_30707;
var res_SINGLEQUOTE_ = inst_30710__$1;
var res = inst_30711__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_30707,inst_30711,inst_30715,inst_30710,inst_30710__$1,inst_30711__$1,state_val_30795,c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__30636_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__30636_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_30707,inst_30711,inst_30715,inst_30710,inst_30710__$1,inst_30711__$1,state_val_30795,c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_30713 = cljs.core.filter.call(null,inst_30712,inst_30710__$1);
var inst_30714 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_30715__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_30714);
var inst_30716 = cljs.core.not_empty.call(null,inst_30715__$1);
var state_30794__$1 = (function (){var statearr_30822 = state_30794;
(statearr_30822[(23)] = inst_30711__$1);

(statearr_30822[(24)] = inst_30715__$1);

(statearr_30822[(25)] = inst_30710__$1);

(statearr_30822[(26)] = inst_30713);

return statearr_30822;
})();
if(cljs.core.truth_(inst_30716)){
var statearr_30823_30900 = state_30794__$1;
(statearr_30823_30900[(1)] = (23));

} else {
var statearr_30824_30901 = state_30794__$1;
(statearr_30824_30901[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (36))){
var state_30794__$1 = state_30794;
var statearr_30825_30902 = state_30794__$1;
(statearr_30825_30902[(2)] = false);

(statearr_30825_30902[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (41))){
var inst_30769 = (state_30794[(20)]);
var inst_30773 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_30774 = cljs.core.map.call(null,inst_30773,inst_30769);
var inst_30775 = cljs.core.pr_str.call(null,inst_30774);
var inst_30776 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30775)].join('');
var inst_30777 = figwheel.client.utils.log.call(null,inst_30776);
var state_30794__$1 = state_30794;
var statearr_30826_30903 = state_30794__$1;
(statearr_30826_30903[(2)] = inst_30777);

(statearr_30826_30903[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (43))){
var inst_30770 = (state_30794[(21)]);
var inst_30780 = (state_30794[(2)]);
var inst_30781 = cljs.core.not_empty.call(null,inst_30770);
var state_30794__$1 = (function (){var statearr_30827 = state_30794;
(statearr_30827[(27)] = inst_30780);

return statearr_30827;
})();
if(cljs.core.truth_(inst_30781)){
var statearr_30828_30904 = state_30794__$1;
(statearr_30828_30904[(1)] = (44));

} else {
var statearr_30829_30905 = state_30794__$1;
(statearr_30829_30905[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (29))){
var inst_30707 = (state_30794[(19)]);
var inst_30747 = (state_30794[(16)]);
var inst_30711 = (state_30794[(23)]);
var inst_30715 = (state_30794[(24)]);
var inst_30710 = (state_30794[(25)]);
var inst_30713 = (state_30794[(26)]);
var inst_30743 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_30746 = (function (){var all_files = inst_30707;
var res_SINGLEQUOTE_ = inst_30710;
var res = inst_30711;
var files_not_loaded = inst_30713;
var dependencies_that_loaded = inst_30715;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_30707,inst_30747,inst_30711,inst_30715,inst_30710,inst_30713,inst_30743,state_val_30795,c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__30745){
var map__30830 = p__30745;
var map__30830__$1 = ((((!((map__30830 == null)))?(((((map__30830.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30830.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30830):map__30830);
var namespace = cljs.core.get.call(null,map__30830__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_30707,inst_30747,inst_30711,inst_30715,inst_30710,inst_30713,inst_30743,state_val_30795,c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_30747__$1 = cljs.core.group_by.call(null,inst_30746,inst_30713);
var inst_30749 = (inst_30747__$1 == null);
var inst_30750 = cljs.core.not.call(null,inst_30749);
var state_30794__$1 = (function (){var statearr_30832 = state_30794;
(statearr_30832[(16)] = inst_30747__$1);

(statearr_30832[(28)] = inst_30743);

return statearr_30832;
})();
if(inst_30750){
var statearr_30833_30906 = state_30794__$1;
(statearr_30833_30906[(1)] = (32));

} else {
var statearr_30834_30907 = state_30794__$1;
(statearr_30834_30907[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (44))){
var inst_30770 = (state_30794[(21)]);
var inst_30783 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_30770);
var inst_30784 = cljs.core.pr_str.call(null,inst_30783);
var inst_30785 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30784)].join('');
var inst_30786 = figwheel.client.utils.log.call(null,inst_30785);
var state_30794__$1 = state_30794;
var statearr_30835_30908 = state_30794__$1;
(statearr_30835_30908[(2)] = inst_30786);

(statearr_30835_30908[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (6))){
var inst_30688 = (state_30794[(2)]);
var state_30794__$1 = state_30794;
var statearr_30836_30909 = state_30794__$1;
(statearr_30836_30909[(2)] = inst_30688);

(statearr_30836_30909[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (28))){
var inst_30713 = (state_30794[(26)]);
var inst_30740 = (state_30794[(2)]);
var inst_30741 = cljs.core.not_empty.call(null,inst_30713);
var state_30794__$1 = (function (){var statearr_30837 = state_30794;
(statearr_30837[(29)] = inst_30740);

return statearr_30837;
})();
if(cljs.core.truth_(inst_30741)){
var statearr_30838_30910 = state_30794__$1;
(statearr_30838_30910[(1)] = (29));

} else {
var statearr_30839_30911 = state_30794__$1;
(statearr_30839_30911[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (25))){
var inst_30711 = (state_30794[(23)]);
var inst_30727 = (state_30794[(2)]);
var inst_30728 = cljs.core.not_empty.call(null,inst_30711);
var state_30794__$1 = (function (){var statearr_30840 = state_30794;
(statearr_30840[(30)] = inst_30727);

return statearr_30840;
})();
if(cljs.core.truth_(inst_30728)){
var statearr_30841_30912 = state_30794__$1;
(statearr_30841_30912[(1)] = (26));

} else {
var statearr_30842_30913 = state_30794__$1;
(statearr_30842_30913[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (34))){
var inst_30763 = (state_30794[(2)]);
var state_30794__$1 = state_30794;
if(cljs.core.truth_(inst_30763)){
var statearr_30843_30914 = state_30794__$1;
(statearr_30843_30914[(1)] = (38));

} else {
var statearr_30844_30915 = state_30794__$1;
(statearr_30844_30915[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (17))){
var state_30794__$1 = state_30794;
var statearr_30845_30916 = state_30794__$1;
(statearr_30845_30916[(2)] = recompile_dependents);

(statearr_30845_30916[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (3))){
var state_30794__$1 = state_30794;
var statearr_30846_30917 = state_30794__$1;
(statearr_30846_30917[(2)] = null);

(statearr_30846_30917[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (12))){
var inst_30684 = (state_30794[(2)]);
var state_30794__$1 = state_30794;
var statearr_30847_30918 = state_30794__$1;
(statearr_30847_30918[(2)] = inst_30684);

(statearr_30847_30918[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (2))){
var inst_30646 = (state_30794[(13)]);
var inst_30653 = cljs.core.seq.call(null,inst_30646);
var inst_30654 = inst_30653;
var inst_30655 = null;
var inst_30656 = (0);
var inst_30657 = (0);
var state_30794__$1 = (function (){var statearr_30848 = state_30794;
(statearr_30848[(7)] = inst_30654);

(statearr_30848[(8)] = inst_30657);

(statearr_30848[(9)] = inst_30656);

(statearr_30848[(10)] = inst_30655);

return statearr_30848;
})();
var statearr_30849_30919 = state_30794__$1;
(statearr_30849_30919[(2)] = null);

(statearr_30849_30919[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (23))){
var inst_30707 = (state_30794[(19)]);
var inst_30711 = (state_30794[(23)]);
var inst_30715 = (state_30794[(24)]);
var inst_30710 = (state_30794[(25)]);
var inst_30713 = (state_30794[(26)]);
var inst_30718 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_30720 = (function (){var all_files = inst_30707;
var res_SINGLEQUOTE_ = inst_30710;
var res = inst_30711;
var files_not_loaded = inst_30713;
var dependencies_that_loaded = inst_30715;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_30707,inst_30711,inst_30715,inst_30710,inst_30713,inst_30718,state_val_30795,c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__30719){
var map__30850 = p__30719;
var map__30850__$1 = ((((!((map__30850 == null)))?(((((map__30850.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30850.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30850):map__30850);
var request_url = cljs.core.get.call(null,map__30850__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_30707,inst_30711,inst_30715,inst_30710,inst_30713,inst_30718,state_val_30795,c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_30721 = cljs.core.reverse.call(null,inst_30715);
var inst_30722 = cljs.core.map.call(null,inst_30720,inst_30721);
var inst_30723 = cljs.core.pr_str.call(null,inst_30722);
var inst_30724 = figwheel.client.utils.log.call(null,inst_30723);
var state_30794__$1 = (function (){var statearr_30852 = state_30794;
(statearr_30852[(31)] = inst_30718);

return statearr_30852;
})();
var statearr_30853_30920 = state_30794__$1;
(statearr_30853_30920[(2)] = inst_30724);

(statearr_30853_30920[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (35))){
var state_30794__$1 = state_30794;
var statearr_30854_30921 = state_30794__$1;
(statearr_30854_30921[(2)] = true);

(statearr_30854_30921[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (19))){
var inst_30697 = (state_30794[(12)]);
var inst_30703 = figwheel.client.file_reloading.expand_files.call(null,inst_30697);
var state_30794__$1 = state_30794;
var statearr_30855_30922 = state_30794__$1;
(statearr_30855_30922[(2)] = inst_30703);

(statearr_30855_30922[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (11))){
var state_30794__$1 = state_30794;
var statearr_30856_30923 = state_30794__$1;
(statearr_30856_30923[(2)] = null);

(statearr_30856_30923[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (9))){
var inst_30686 = (state_30794[(2)]);
var state_30794__$1 = state_30794;
var statearr_30857_30924 = state_30794__$1;
(statearr_30857_30924[(2)] = inst_30686);

(statearr_30857_30924[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (5))){
var inst_30657 = (state_30794[(8)]);
var inst_30656 = (state_30794[(9)]);
var inst_30659 = (inst_30657 < inst_30656);
var inst_30660 = inst_30659;
var state_30794__$1 = state_30794;
if(cljs.core.truth_(inst_30660)){
var statearr_30858_30925 = state_30794__$1;
(statearr_30858_30925[(1)] = (7));

} else {
var statearr_30859_30926 = state_30794__$1;
(statearr_30859_30926[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (14))){
var inst_30667 = (state_30794[(22)]);
var inst_30676 = cljs.core.first.call(null,inst_30667);
var inst_30677 = figwheel.client.file_reloading.eval_body.call(null,inst_30676,opts);
var inst_30678 = cljs.core.next.call(null,inst_30667);
var inst_30654 = inst_30678;
var inst_30655 = null;
var inst_30656 = (0);
var inst_30657 = (0);
var state_30794__$1 = (function (){var statearr_30860 = state_30794;
(statearr_30860[(32)] = inst_30677);

(statearr_30860[(7)] = inst_30654);

(statearr_30860[(8)] = inst_30657);

(statearr_30860[(9)] = inst_30656);

(statearr_30860[(10)] = inst_30655);

return statearr_30860;
})();
var statearr_30861_30927 = state_30794__$1;
(statearr_30861_30927[(2)] = null);

(statearr_30861_30927[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (45))){
var state_30794__$1 = state_30794;
var statearr_30862_30928 = state_30794__$1;
(statearr_30862_30928[(2)] = null);

(statearr_30862_30928[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (26))){
var inst_30707 = (state_30794[(19)]);
var inst_30711 = (state_30794[(23)]);
var inst_30715 = (state_30794[(24)]);
var inst_30710 = (state_30794[(25)]);
var inst_30713 = (state_30794[(26)]);
var inst_30730 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_30732 = (function (){var all_files = inst_30707;
var res_SINGLEQUOTE_ = inst_30710;
var res = inst_30711;
var files_not_loaded = inst_30713;
var dependencies_that_loaded = inst_30715;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_30707,inst_30711,inst_30715,inst_30710,inst_30713,inst_30730,state_val_30795,c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__30731){
var map__30863 = p__30731;
var map__30863__$1 = ((((!((map__30863 == null)))?(((((map__30863.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30863.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30863):map__30863);
var namespace = cljs.core.get.call(null,map__30863__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__30863__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_30707,inst_30711,inst_30715,inst_30710,inst_30713,inst_30730,state_val_30795,c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_30733 = cljs.core.map.call(null,inst_30732,inst_30711);
var inst_30734 = cljs.core.pr_str.call(null,inst_30733);
var inst_30735 = figwheel.client.utils.log.call(null,inst_30734);
var inst_30736 = (function (){var all_files = inst_30707;
var res_SINGLEQUOTE_ = inst_30710;
var res = inst_30711;
var files_not_loaded = inst_30713;
var dependencies_that_loaded = inst_30715;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_30707,inst_30711,inst_30715,inst_30710,inst_30713,inst_30730,inst_30732,inst_30733,inst_30734,inst_30735,state_val_30795,c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_30707,inst_30711,inst_30715,inst_30710,inst_30713,inst_30730,inst_30732,inst_30733,inst_30734,inst_30735,state_val_30795,c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_30737 = setTimeout(inst_30736,(10));
var state_30794__$1 = (function (){var statearr_30865 = state_30794;
(statearr_30865[(33)] = inst_30735);

(statearr_30865[(34)] = inst_30730);

return statearr_30865;
})();
var statearr_30866_30929 = state_30794__$1;
(statearr_30866_30929[(2)] = inst_30737);

(statearr_30866_30929[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (16))){
var state_30794__$1 = state_30794;
var statearr_30867_30930 = state_30794__$1;
(statearr_30867_30930[(2)] = reload_dependents);

(statearr_30867_30930[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (38))){
var inst_30747 = (state_30794[(16)]);
var inst_30765 = cljs.core.apply.call(null,cljs.core.hash_map,inst_30747);
var state_30794__$1 = state_30794;
var statearr_30868_30931 = state_30794__$1;
(statearr_30868_30931[(2)] = inst_30765);

(statearr_30868_30931[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (30))){
var state_30794__$1 = state_30794;
var statearr_30869_30932 = state_30794__$1;
(statearr_30869_30932[(2)] = null);

(statearr_30869_30932[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (10))){
var inst_30667 = (state_30794[(22)]);
var inst_30669 = cljs.core.chunked_seq_QMARK_.call(null,inst_30667);
var state_30794__$1 = state_30794;
if(inst_30669){
var statearr_30870_30933 = state_30794__$1;
(statearr_30870_30933[(1)] = (13));

} else {
var statearr_30871_30934 = state_30794__$1;
(statearr_30871_30934[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (18))){
var inst_30701 = (state_30794[(2)]);
var state_30794__$1 = state_30794;
if(cljs.core.truth_(inst_30701)){
var statearr_30872_30935 = state_30794__$1;
(statearr_30872_30935[(1)] = (19));

} else {
var statearr_30873_30936 = state_30794__$1;
(statearr_30873_30936[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (42))){
var state_30794__$1 = state_30794;
var statearr_30874_30937 = state_30794__$1;
(statearr_30874_30937[(2)] = null);

(statearr_30874_30937[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (37))){
var inst_30760 = (state_30794[(2)]);
var state_30794__$1 = state_30794;
var statearr_30875_30938 = state_30794__$1;
(statearr_30875_30938[(2)] = inst_30760);

(statearr_30875_30938[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30795 === (8))){
var inst_30667 = (state_30794[(22)]);
var inst_30654 = (state_30794[(7)]);
var inst_30667__$1 = cljs.core.seq.call(null,inst_30654);
var state_30794__$1 = (function (){var statearr_30876 = state_30794;
(statearr_30876[(22)] = inst_30667__$1);

return statearr_30876;
})();
if(inst_30667__$1){
var statearr_30877_30939 = state_30794__$1;
(statearr_30877_30939[(1)] = (10));

} else {
var statearr_30878_30940 = state_30794__$1;
(statearr_30878_30940[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__25331__auto__,c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__25332__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__25332__auto____0 = (function (){
var statearr_30879 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30879[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__25332__auto__);

(statearr_30879[(1)] = (1));

return statearr_30879;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__25332__auto____1 = (function (state_30794){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_30794);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e30880){if((e30880 instanceof Object)){
var ex__25335__auto__ = e30880;
var statearr_30881_30941 = state_30794;
(statearr_30881_30941[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30794);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30880;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30942 = state_30794;
state_30794 = G__30942;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__25332__auto__ = function(state_30794){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__25332__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__25332__auto____1.call(this,state_30794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__25332__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__25332__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__25424__auto__ = (function (){var statearr_30882 = f__25423__auto__.call(null);
(statearr_30882[(6)] = c__25422__auto__);

return statearr_30882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto__,map__30639,map__30639__$1,opts,before_jsload,on_jsload,reload_dependents,map__30640,map__30640__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__25422__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__30945,link){
var map__30946 = p__30945;
var map__30946__$1 = ((((!((map__30946 == null)))?(((((map__30946.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30946.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30946):map__30946);
var file = cljs.core.get.call(null,map__30946__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__5457__auto__ = link.href;
if(cljs.core.truth_(temp__5457__auto__)){
var link_href = temp__5457__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__5457__auto__,map__30946,map__30946__$1,file){
return (function (p1__30943_SHARP_,p2__30944_SHARP_){
if(cljs.core._EQ_.call(null,p1__30943_SHARP_,p2__30944_SHARP_)){
return p1__30943_SHARP_;
} else {
return false;
}
});})(link_href,temp__5457__auto__,map__30946,map__30946__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__5457__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__30949){
var map__30950 = p__30949;
var map__30950__$1 = ((((!((map__30950 == null)))?(((((map__30950.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30950.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30950):map__30950);
var match_length = cljs.core.get.call(null,map__30950__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__30950__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__30948_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__30948_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__5457__auto__)){
var res = temp__5457__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__30952_SHARP_,p2__30953_SHARP_){
return cljs.core.assoc.call(null,p1__30952_SHARP_,cljs.core.get.call(null,p2__30953_SHARP_,key),p2__30953_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined')){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__5455__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__5455__auto__)){
var link = temp__5455__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__5455__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__5455__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_30954 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_30954);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_30954);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__30955,p__30956){
var map__30957 = p__30955;
var map__30957__$1 = ((((!((map__30957 == null)))?(((((map__30957.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30957.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30957):map__30957);
var on_cssload = cljs.core.get.call(null,map__30957__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__30958 = p__30956;
var map__30958__$1 = ((((!((map__30958 == null)))?(((((map__30958.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30958.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30958):map__30958);
var files_msg = map__30958__$1;
var files = cljs.core.get.call(null,map__30958__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__5457__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__5457__auto__)){
var f_datas = temp__5457__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1533629727119
