// Compiled by ClojureScript 1.10.339 {}
goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.call(null,(0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_.call(null,re_frame.trace.id,(0));
});

/** @define {boolean} */
goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.call(null,(0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.call(null,re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/Day8/re-frame-trace#installation.");
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.call(null,re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.call(null,re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__22834){
var map__22835 = p__22834;
var map__22835__$1 = ((((!((map__22835 == null)))?(((((map__22835.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22835.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22835):map__22835);
var operation = cljs.core.get.call(null,map__22835__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.call(null,map__22835__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.call(null,map__22835__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.call(null,map__22835__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id.call(null),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__3949__auto__ = child_of;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now.call(null)], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce.call(null,(function re_frame$trace$tracing_cb_debounced(){
var seq__22837_22849 = cljs.core.seq.call(null,cljs.core.deref.call(null,re_frame.trace.trace_cbs));
var chunk__22838_22850 = null;
var count__22839_22851 = (0);
var i__22840_22852 = (0);
while(true){
if((i__22840_22852 < count__22839_22851)){
var vec__22841_22853 = cljs.core._nth.call(null,chunk__22838_22850,i__22840_22852);
var k_22854 = cljs.core.nth.call(null,vec__22841_22853,(0),null);
var cb_22855 = cljs.core.nth.call(null,vec__22841_22853,(1),null);
try{cb_22855.call(null,cljs.core.deref.call(null,re_frame.trace.traces));
}catch (e22844){var e_22856 = e22844;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k_22854,"while storing",cljs.core.deref.call(null,re_frame.trace.traces),e_22856);
}

var G__22857 = seq__22837_22849;
var G__22858 = chunk__22838_22850;
var G__22859 = count__22839_22851;
var G__22860 = (i__22840_22852 + (1));
seq__22837_22849 = G__22857;
chunk__22838_22850 = G__22858;
count__22839_22851 = G__22859;
i__22840_22852 = G__22860;
continue;
} else {
var temp__5457__auto___22861 = cljs.core.seq.call(null,seq__22837_22849);
if(temp__5457__auto___22861){
var seq__22837_22862__$1 = temp__5457__auto___22861;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22837_22862__$1)){
var c__4351__auto___22863 = cljs.core.chunk_first.call(null,seq__22837_22862__$1);
var G__22864 = cljs.core.chunk_rest.call(null,seq__22837_22862__$1);
var G__22865 = c__4351__auto___22863;
var G__22866 = cljs.core.count.call(null,c__4351__auto___22863);
var G__22867 = (0);
seq__22837_22849 = G__22864;
chunk__22838_22850 = G__22865;
count__22839_22851 = G__22866;
i__22840_22852 = G__22867;
continue;
} else {
var vec__22845_22868 = cljs.core.first.call(null,seq__22837_22862__$1);
var k_22869 = cljs.core.nth.call(null,vec__22845_22868,(0),null);
var cb_22870 = cljs.core.nth.call(null,vec__22845_22868,(1),null);
try{cb_22870.call(null,cljs.core.deref.call(null,re_frame.trace.traces));
}catch (e22848){var e_22871 = e22848;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k_22869,"while storing",cljs.core.deref.call(null,re_frame.trace.traces),e_22871);
}

var G__22872 = cljs.core.next.call(null,seq__22837_22862__$1);
var G__22873 = null;
var G__22874 = (0);
var G__22875 = (0);
seq__22837_22849 = G__22872;
chunk__22838_22850 = G__22873;
count__22839_22851 = G__22874;
i__22840_22852 = G__22875;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_.call(null,re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref.call(null,re_frame.trace.next_delivery) - (10)) < now)){
re_frame.trace.schedule_debounce.call(null);

return cljs.core.reset_BANG_.call(null,re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=trace.js.map?rel=1533629715429
