// Compiled by ClojureScript 1.9.946 {}
goog.provide('re_frame.events');
goog.require('cljs.core');
goog.require('re_frame.db');
goog.require('re_frame.utils');
goog.require('re_frame.interop');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.interceptor');
goog.require('re_frame.trace');
re_frame.events.kind = new cljs.core.Keyword(null,"event","event",301435442);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.events.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * `interceptors` might have nested collections, and contain nil elements.
 *   return a flat collection, with all nils removed.
 *   This function is 9/10 about giving good error messages.
 */
re_frame.events.flatten_and_remove_nils = (function re_frame$events$flatten_and_remove_nils(id,interceptors){
var make_chain = (function (p1__28715_SHARP_){
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,p1__28715_SHARP_));
});
if(!(re_frame.interop.debug_enabled_QMARK_)){
return make_chain.call(null,interceptors);
} else {
if(cljs.core.coll_QMARK_.call(null,interceptors)){
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected a collection of interceptors, got: ",interceptors);
}

var chain = make_chain.call(null,interceptors);
if(cljs.core.empty_QMARK_.call(null,chain)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", given an empty interceptor chain");
} else {
}

var temp__4657__auto___28716 = cljs.core.first.call(null,cljs.core.remove.call(null,re_frame.interceptor.interceptor_QMARK_,chain));
if(cljs.core.truth_(temp__4657__auto___28716)){
var not_i_28717 = temp__4657__auto___28716;
if(cljs.core.fn_QMARK_.call(null,not_i_28717)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", got a function instead of an interceptor. Did you provide old style middleware by mistake? Got: ",not_i_28717);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected interceptors, but got: ",not_i_28717);
}
} else {
}

return chain;
}
});
/**
 * Associate the given event `id` with the given collection of `interceptors`.
 * 
 * `interceptors` may contain nested collections and there may be nils
 * at any level,so process this structure into a simple, nil-less vector
 * before registration.
 * 
 * Typically, an `event handler` will be at the end of the chain (wrapped
 * in an interceptor).
 */
re_frame.events.register = (function re_frame$events$register(id,interceptors){
return re_frame.registrar.register_handler.call(null,re_frame.events.kind,id,re_frame.events.flatten_and_remove_nils.call(null,id,interceptors));
});
re_frame.events._STAR_handling_STAR_ = null;
/**
 * Given an event vector `event-v`, look up the associated interceptor chain, and execute it.
 */
re_frame.events.handle = (function re_frame$events$handle(event_v){
var event_id = re_frame.utils.first_in_vector.call(null,event_v);
var temp__4655__auto__ = re_frame.registrar.get_handler.call(null,re_frame.events.kind,event_id,true);
if(cljs.core.truth_(temp__4655__auto__)){
var interceptors = temp__4655__auto__;
if(cljs.core.truth_(re_frame.events._STAR_handling_STAR_)){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: while handling \"",re_frame.events._STAR_handling_STAR_,"\", dispatch-sync was called for \"",event_v,"\". You can't call dispatch-sync within an event handler.");
} else {
var _STAR_handling_STAR_28718 = re_frame.events._STAR_handling_STAR_;
re_frame.events._STAR_handling_STAR_ = event_v;

try{if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_28719 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"operation","operation",-1267664310),event_id,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),re_frame.events.kind,new cljs.core.Keyword(null,"tags","tags",1771418977),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),event_v], null)], null));

try{try{return re_frame.interceptor.execute.call(null,event_v,interceptors);
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__28663__auto___28732 = re_frame.interop.now.call(null);
var duration__28664__auto___28733 = (end__28663__auto___28732 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__28720_28734 = cljs.core.seq.call(null,cljs.core.deref.call(null,re_frame.trace.trace_cbs));
var chunk__28721_28735 = null;
var count__28722_28736 = (0);
var i__28723_28737 = (0);
while(true){
if((i__28723_28737 < count__28722_28736)){
var vec__28724_28738 = cljs.core._nth.call(null,chunk__28721_28735,i__28723_28737);
var k__28665__auto___28739 = cljs.core.nth.call(null,vec__28724_28738,(0),null);
var cb__28666__auto___28740 = cljs.core.nth.call(null,vec__28724_28738,(1),null);
try{cb__28666__auto___28740.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__28664__auto___28733,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e28727){if((e28727 instanceof java.lang.Exception)){
var e__28667__auto___28741 = e28727;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__28665__auto___28739,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__28667__auto___28741);
} else {
throw e28727;

}
}
var G__28742 = seq__28720_28734;
var G__28743 = chunk__28721_28735;
var G__28744 = count__28722_28736;
var G__28745 = (i__28723_28737 + (1));
seq__28720_28734 = G__28742;
chunk__28721_28735 = G__28743;
count__28722_28736 = G__28744;
i__28723_28737 = G__28745;
continue;
} else {
var temp__4657__auto___28746 = cljs.core.seq.call(null,seq__28720_28734);
if(temp__4657__auto___28746){
var seq__28720_28747__$1 = temp__4657__auto___28746;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28720_28747__$1)){
var c__27218__auto___28748 = cljs.core.chunk_first.call(null,seq__28720_28747__$1);
var G__28749 = cljs.core.chunk_rest.call(null,seq__28720_28747__$1);
var G__28750 = c__27218__auto___28748;
var G__28751 = cljs.core.count.call(null,c__27218__auto___28748);
var G__28752 = (0);
seq__28720_28734 = G__28749;
chunk__28721_28735 = G__28750;
count__28722_28736 = G__28751;
i__28723_28737 = G__28752;
continue;
} else {
var vec__28728_28753 = cljs.core.first.call(null,seq__28720_28747__$1);
var k__28665__auto___28754 = cljs.core.nth.call(null,vec__28728_28753,(0),null);
var cb__28666__auto___28755 = cljs.core.nth.call(null,vec__28728_28753,(1),null);
try{cb__28666__auto___28755.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__28664__auto___28733,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e28731){if((e28731 instanceof java.lang.Exception)){
var e__28667__auto___28756 = e28731;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__28665__auto___28754,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__28667__auto___28756);
} else {
throw e28731;

}
}
var G__28757 = cljs.core.next.call(null,seq__28720_28747__$1);
var G__28758 = null;
var G__28759 = (0);
var G__28760 = (0);
seq__28720_28734 = G__28757;
chunk__28721_28735 = G__28758;
count__28722_28736 = G__28759;
i__28723_28737 = G__28760;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_28719;
}} else {
return re_frame.interceptor.execute.call(null,event_v,interceptors);
}
}finally {re_frame.events._STAR_handling_STAR_ = _STAR_handling_STAR_28718;
}}
} else {
return null;
}
});

//# sourceMappingURL=events.js.map?rel=1516615193735
