// Compiled by ClojureScript 1.9.946 {}
goog.provide('re_com.typeahead');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('re_com.misc');
goog.require('re_com.util');
goog.require('re_com.popover');
goog.require('re_com.box');
goog.require('re_com.validate');
goog.require('reagent.core');
goog.require('goog.events.KeyCodes');

/**
 * Return an initial value for the typeahead state, given `args`.
 */
re_com.typeahead.make_typeahead_state = (function re_com$typeahead$make_typeahead_state(p__33047){
var map__33048 = p__33047;
var map__33048__$1 = ((((!((map__33048 == null)))?((((map__33048.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33048.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33048):map__33048);
var args = map__33048__$1;
var on_change = cljs.core.get.call(null,map__33048__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var rigid_QMARK_ = cljs.core.get.call(null,map__33048__$1,new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118));
var change_on_blur_QMARK_ = cljs.core.get.call(null,map__33048__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var data_source = cljs.core.get.call(null,map__33048__$1,new cljs.core.Keyword(null,"data-source","data-source",-658934676));
var suggestion_to_string = cljs.core.get.call(null,map__33048__$1,new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962));
var debounce_delay = cljs.core.get.call(null,map__33048__$1,new cljs.core.Keyword(null,"debounce-delay","debounce-delay",-608187982));
var model = cljs.core.get.call(null,map__33048__$1,new cljs.core.Keyword(null,"model","model",331153215));
var external_model_value = re_com.util.deref_or_value.call(null,model);
var G__33050 = (function (){var c_input = cljs.core.async.chan.call(null);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962),new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),new cljs.core.Keyword(null,"input-text","input-text",-1336297114),new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118),new cljs.core.Keyword(null,"data-source","data-source",-658934676),new cljs.core.Keyword(null,"c-search","c-search",1832536180),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),new cljs.core.Keyword(null,"c-input","c-input",-1821004232),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"external-model","external-model",506095421),new cljs.core.Keyword(null,"model","model",331153215)],[false,(function (){var or__28348__auto__ = suggestion_to_string;
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return cljs.core.str;
}
})(),false,"",rigid_QMARK_,data_source,re_com.typeahead.debounce.call(null,c_input,debounce_delay),change_on_blur_QMARK_,cljs.core.PersistentVector.EMPTY,c_input,on_change,re_com.util.deref_or_value.call(null,model),re_com.util.deref_or_value.call(null,model)]);
})();
if(cljs.core.truth_(external_model_value)){
return re_com.typeahead.display_suggestion.call(null,G__33050,external_model_value);
} else {
return G__33050;
}
});
/**
 * Should `event` update the `typeahead` `model`?
 */
re_com.typeahead.event_updates_model_QMARK_ = (function re_com$typeahead$event_updates_model_QMARK_(p__33051,event){
var map__33052 = p__33051;
var map__33052__$1 = ((((!((map__33052 == null)))?((((map__33052.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33052.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33052):map__33052);
var state = map__33052__$1;
var change_on_blur_QMARK_ = cljs.core.get.call(null,map__33052__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var rigid_QMARK_ = cljs.core.get.call(null,map__33052__$1,new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118));
var change_on_blur_QMARK___$1 = re_com.util.deref_or_value.call(null,change_on_blur_QMARK_);
var rigid_QMARK___$1 = re_com.util.deref_or_value.call(null,rigid_QMARK_);
var G__33054 = event;
var G__33054__$1 = (((G__33054 instanceof cljs.core.Keyword))?G__33054.fqn:null);
switch (G__33054__$1) {
case "input-text-blurred":
var and__28336__auto__ = change_on_blur_QMARK___$1;
if(cljs.core.truth_(and__28336__auto__)){
return cljs.core.not.call(null,rigid_QMARK___$1);
} else {
return and__28336__auto__;
}

break;
case "suggestion-activated":
return cljs.core.not.call(null,change_on_blur_QMARK___$1);

break;
case "input-text-changed":
return cljs.core.not.call(null,(function (){var or__28348__auto__ = change_on_blur_QMARK___$1;
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return rigid_QMARK___$1;
}
})());

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33054__$1)].join('')));

}
});
/**
 * Should `event` cause the `input-text` value to be used to show the active suggestion?
 */
re_com.typeahead.event_displays_suggestion_QMARK_ = (function re_com$typeahead$event_displays_suggestion_QMARK_(p__33056,event){
var map__33057 = p__33056;
var map__33057__$1 = ((((!((map__33057 == null)))?((((map__33057.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33057.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33057):map__33057);
var state = map__33057__$1;
var change_on_blur_QMARK_ = cljs.core.get.call(null,map__33057__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var change_on_blur_QMARK___$1 = re_com.util.deref_or_value.call(null,change_on_blur_QMARK_);
var G__33059 = event;
var G__33059__$1 = (((G__33059 instanceof cljs.core.Keyword))?G__33059.fqn:null);
switch (G__33059__$1) {
case "suggestion-activated":
return cljs.core.not.call(null,change_on_blur_QMARK___$1);

break;
default:
return false;

}
});
/**
 * Change the `typeahead` `model` value to `new-value`
 */
re_com.typeahead.update_model = (function re_com$typeahead$update_model(p__33061,new_value){
var map__33062 = p__33061;
var map__33062__$1 = ((((!((map__33062 == null)))?((((map__33062.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33062.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33062):map__33062);
var state = map__33062__$1;
var on_change = cljs.core.get.call(null,map__33062__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
if(cljs.core.truth_(on_change)){
on_change.call(null,new_value);
} else {
}

return cljs.core.assoc.call(null,state,new cljs.core.Keyword(null,"model","model",331153215),new_value);
});
/**
 * Change the `input-text` `model` to the string representation of `suggestion`
 */
re_com.typeahead.display_suggestion = (function re_com$typeahead$display_suggestion(p__33064,suggestion){
var map__33065 = p__33064;
var map__33065__$1 = ((((!((map__33065 == null)))?((((map__33065.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33065.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33065):map__33065);
var state = map__33065__$1;
var suggestion_to_string = cljs.core.get.call(null,map__33065__$1,new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962));
var suggestion_string = suggestion_to_string.call(null,suggestion);
var G__33067 = state;
if(cljs.core.truth_(suggestion_string)){
return cljs.core.assoc.call(null,G__33067,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),suggestion_string,new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),true);
} else {
return G__33067;
}
});
re_com.typeahead.clear_suggestions = (function re_com$typeahead$clear_suggestions(state){
return cljs.core.dissoc.call(null,state,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
});
/**
 * Make the suggestion at `index` the active suggestion
 */
re_com.typeahead.activate_suggestion_by_index = (function re_com$typeahead$activate_suggestion_by_index(p__33068,index){
var map__33069 = p__33068;
var map__33069__$1 = ((((!((map__33069 == null)))?((((map__33069.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33069.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33069):map__33069);
var state = map__33069__$1;
var suggestions = cljs.core.get.call(null,map__33069__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion = cljs.core.nth.call(null,suggestions,index);
var G__33071 = state;
var G__33071__$1 = cljs.core.assoc.call(null,G__33071,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728),index)
;
var G__33071__$2 = (cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"suggestion-activated","suggestion-activated",316961778)))?re_com.typeahead.update_model.call(null,G__33071__$1,suggestion):G__33071__$1);
if(cljs.core.truth_(re_com.typeahead.event_displays_suggestion_QMARK_.call(null,state,new cljs.core.Keyword(null,"suggestion-activated","suggestion-activated",316961778)))){
return re_com.typeahead.display_suggestion.call(null,G__33071__$2,suggestion);
} else {
return G__33071__$2;
}
});
/**
 * Choose the suggestion at `index`
 */
re_com.typeahead.choose_suggestion_by_index = (function re_com$typeahead$choose_suggestion_by_index(p__33072,index){
var map__33073 = p__33072;
var map__33073__$1 = ((((!((map__33073 == null)))?((((map__33073.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33073.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33073):map__33073);
var state = map__33073__$1;
var suggestions = cljs.core.get.call(null,map__33073__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion = cljs.core.nth.call(null,suggestions,index);
return re_com.typeahead.clear_suggestions.call(null,re_com.typeahead.display_suggestion.call(null,re_com.typeahead.update_model.call(null,re_com.typeahead.activate_suggestion_by_index.call(null,state,index),suggestion),suggestion));
});
re_com.typeahead.choose_suggestion_active = (function re_com$typeahead$choose_suggestion_active(p__33075){
var map__33076 = p__33075;
var map__33076__$1 = ((((!((map__33076 == null)))?((((map__33076.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33076.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33076):map__33076);
var state = map__33076__$1;
var suggestion_active_index = cljs.core.get.call(null,map__33076__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__33078 = state;
if(cljs.core.truth_(suggestion_active_index)){
return re_com.typeahead.choose_suggestion_by_index.call(null,G__33078,suggestion_active_index);
} else {
return G__33078;
}
});
re_com.typeahead.wrap = (function re_com$typeahead$wrap(index,count){
return cljs.core.mod.call(null,(count + index),count);
});
re_com.typeahead.activate_suggestion_next = (function re_com$typeahead$activate_suggestion_next(p__33079){
var map__33080 = p__33079;
var map__33080__$1 = ((((!((map__33080 == null)))?((((map__33080.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33080.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33080):map__33080);
var state = map__33080__$1;
var suggestions = cljs.core.get.call(null,map__33080__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion_active_index = cljs.core.get.call(null,map__33080__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__33082 = state;
if(cljs.core.truth_(suggestions)){
return re_com.typeahead.activate_suggestion_by_index.call(null,G__33082,re_com.typeahead.wrap.call(null,((function (){var or__28348__auto__ = suggestion_active_index;
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return (-1);
}
})() + (1)),cljs.core.count.call(null,suggestions)));
} else {
return G__33082;
}
});
re_com.typeahead.activate_suggestion_prev = (function re_com$typeahead$activate_suggestion_prev(p__33083){
var map__33084 = p__33083;
var map__33084__$1 = ((((!((map__33084 == null)))?((((map__33084.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33084.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33084):map__33084);
var state = map__33084__$1;
var suggestions = cljs.core.get.call(null,map__33084__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion_active_index = cljs.core.get.call(null,map__33084__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__33086 = state;
if(cljs.core.truth_(suggestions)){
return re_com.typeahead.activate_suggestion_by_index.call(null,G__33086,re_com.typeahead.wrap.call(null,((function (){var or__28348__auto__ = suggestion_active_index;
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return (0);
}
})() - (1)),cljs.core.count.call(null,suggestions)));
} else {
return G__33086;
}
});
re_com.typeahead.reset_typeahead = (function re_com$typeahead$reset_typeahead(state){
var G__33087 = state;
var G__33087__$1 = re_com.typeahead.clear_suggestions.call(null,G__33087)
;
var G__33087__$2 = cljs.core.assoc.call(null,G__33087__$1,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),false,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),"",new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),false)
;
if(cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"input-text-changed","input-text-changed",-1906799535)))){
return re_com.typeahead.update_model.call(null,G__33087__$2,null);
} else {
return G__33087__$2;
}
});
/**
 * Update state when new suggestions are available
 */
re_com.typeahead.got_suggestions = (function re_com$typeahead$got_suggestions(state,suggestions){
return cljs.core.assoc.call(null,state,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),suggestions,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),false,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728),null);
});
/**
 * Update state when the `input-text` is about to lose focus.
 */
re_com.typeahead.input_text_will_blur = (function re_com$typeahead$input_text_will_blur(p__33088){
var map__33089 = p__33088;
var map__33089__$1 = ((((!((map__33089 == null)))?((((map__33089.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33089.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33089):map__33089);
var state = map__33089__$1;
var input_text = cljs.core.get.call(null,map__33089__$1,new cljs.core.Keyword(null,"input-text","input-text",-1336297114));
var displaying_suggestion_QMARK_ = cljs.core.get.call(null,map__33089__$1,new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862));
var G__33091 = state;
if(cljs.core.truth_((function (){var and__28336__auto__ = cljs.core.not.call(null,displaying_suggestion_QMARK_);
if(and__28336__auto__){
return re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"input-text-blurred","input-text-blurred",-501892307));
} else {
return and__28336__auto__;
}
})())){
return re_com.typeahead.update_model.call(null,G__33091,input_text);
} else {
return G__33091;
}
});
/**
 * Update `state` given a new `data-source`. Resets the typeahead since any existing suggestions
 *   came from the old `data-source`.
 */
re_com.typeahead.change_data_source = (function re_com$typeahead$change_data_source(state,data_source){
return cljs.core.assoc.call(null,re_com.typeahead.reset_typeahead.call(null,state),new cljs.core.Keyword(null,"data-source","data-source",-658934676),data_source);
});
/**
 * Update state when the external model value has changed.
 */
re_com.typeahead.external_model_changed = (function re_com$typeahead$external_model_changed(state,new_value){
return re_com.typeahead.clear_suggestions.call(null,re_com.typeahead.display_suggestion.call(null,re_com.typeahead.update_model.call(null,state,new_value),new_value));
});
/**
 * Call the `data-source` fn with `text`, and then call `got-suggestions` with the result
 *   (asynchronously, if `data-source` does not return a truthy value).
 */
re_com.typeahead.search_data_source_BANG_ = (function re_com$typeahead$search_data_source_BANG_(data_source,state_atom,text){
var temp__4655__auto__ = data_source.call(null,text,(function (p1__33092_SHARP_){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.got_suggestions,p1__33092_SHARP_);
}));
if(cljs.core.truth_(temp__4655__auto__)){
var return_value = temp__4655__auto__;
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.got_suggestions,return_value);
} else {
return cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),true);
}
});
/**
 * For every value arriving on the `c-search` channel, call `search-data-source!`.
 */
re_com.typeahead.search_data_source_loop_BANG_ = (function re_com$typeahead$search_data_source_loop_BANG_(state_atom,c_search){
var c__30950__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto__){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto__){
return (function (state_33109){
var state_val_33110 = (state_33109[(1)]);
if((state_val_33110 === (1))){
var state_33109__$1 = state_33109;
var statearr_33111_33123 = state_33109__$1;
(statearr_33111_33123[(2)] = null);

(statearr_33111_33123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33110 === (2))){
var state_33109__$1 = state_33109;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33109__$1,(4),c_search);
} else {
if((state_val_33110 === (3))){
var inst_33107 = (state_33109[(2)]);
var state_33109__$1 = state_33109;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33109__$1,inst_33107);
} else {
if((state_val_33110 === (4))){
var inst_33095 = (state_33109[(7)]);
var inst_33095__$1 = (state_33109[(2)]);
var inst_33096 = cljs.core.deref.call(null,state_atom);
var inst_33097 = new cljs.core.Keyword(null,"data-source","data-source",-658934676).cljs$core$IFn$_invoke$arity$1(inst_33096);
var inst_33098 = cljs.core._EQ_.call(null,"",inst_33095__$1);
var state_33109__$1 = (function (){var statearr_33112 = state_33109;
(statearr_33112[(7)] = inst_33095__$1);

(statearr_33112[(8)] = inst_33097);

return statearr_33112;
})();
if(inst_33098){
var statearr_33113_33124 = state_33109__$1;
(statearr_33113_33124[(1)] = (5));

} else {
var statearr_33114_33125 = state_33109__$1;
(statearr_33114_33125[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33110 === (5))){
var inst_33100 = cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.reset_typeahead);
var state_33109__$1 = state_33109;
var statearr_33115_33126 = state_33109__$1;
(statearr_33115_33126[(2)] = inst_33100);

(statearr_33115_33126[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33110 === (6))){
var inst_33095 = (state_33109[(7)]);
var inst_33097 = (state_33109[(8)]);
var inst_33102 = re_com.typeahead.search_data_source_BANG_.call(null,inst_33097,state_atom,inst_33095);
var state_33109__$1 = state_33109;
var statearr_33116_33127 = state_33109__$1;
(statearr_33116_33127[(2)] = inst_33102);

(statearr_33116_33127[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33110 === (7))){
var inst_33104 = (state_33109[(2)]);
var state_33109__$1 = (function (){var statearr_33117 = state_33109;
(statearr_33117[(9)] = inst_33104);

return statearr_33117;
})();
var statearr_33118_33128 = state_33109__$1;
(statearr_33118_33128[(2)] = null);

(statearr_33118_33128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__30950__auto__))
;
return ((function (switch__30862__auto__,c__30950__auto__){
return (function() {
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30863__auto__ = null;
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30863__auto____0 = (function (){
var statearr_33119 = [null,null,null,null,null,null,null,null,null,null];
(statearr_33119[(0)] = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30863__auto__);

(statearr_33119[(1)] = (1));

return statearr_33119;
});
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30863__auto____1 = (function (state_33109){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_33109);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e33120){if((e33120 instanceof Object)){
var ex__30866__auto__ = e33120;
var statearr_33121_33129 = state_33109;
(statearr_33121_33129[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33109);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33120;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33130 = state_33109;
state_33109 = G__33130;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30863__auto__ = function(state_33109){
switch(arguments.length){
case 0:
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30863__auto____0.call(this);
case 1:
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30863__auto____1.call(this,state_33109);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30863__auto____0;
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30863__auto____1;
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto__))
})();
var state__30952__auto__ = (function (){var statearr_33122 = f__30951__auto__.call(null);
(statearr_33122[(6)] = c__30950__auto__);

return statearr_33122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto__))
);

return c__30950__auto__;
});
/**
 * Update state in response to `input-text` `on-change`, and put text on the `c-input` channel
 */
re_com.typeahead.input_text_on_change_BANG_ = (function re_com$typeahead$input_text_on_change_BANG_(state_atom,new_text){
var map__33132 = cljs.core.deref.call(null,state_atom);
var map__33132__$1 = ((((!((map__33132 == null)))?((((map__33132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33132.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33132):map__33132);
var state = map__33132__$1;
var input_text = cljs.core.get.call(null,map__33132__$1,new cljs.core.Keyword(null,"input-text","input-text",-1336297114));
var c_input = cljs.core.get.call(null,map__33132__$1,new cljs.core.Keyword(null,"c-input","c-input",-1821004232));
if(cljs.core._EQ_.call(null,new_text,input_text)){
return state;
} else {
if(clojure.string.blank_QMARK_.call(null,new_text)){
} else {
cljs.core.async.put_BANG_.call(null,c_input,new_text);
}

return cljs.core.swap_BANG_.call(null,state_atom,((function (map__33132,map__33132__$1,state,input_text,c_input){
return (function (p1__33131_SHARP_){
var G__33134 = p1__33131_SHARP_;
var G__33134__$1 = cljs.core.assoc.call(null,G__33134,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),new_text,new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),false)
;
if(cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"input-text-changed","input-text-changed",-1906799535)))){
return re_com.typeahead.update_model.call(null,G__33134__$1,new_text);
} else {
return G__33134__$1;
}
});})(map__33132,map__33132__$1,state,input_text,c_input))
);
}
});
re_com.typeahead.input_text_on_key_down_BANG_ = (function re_com$typeahead$input_text_on_key_down_BANG_(state_atom,event){
var pred__33135 = cljs.core._EQ_;
var expr__33136 = event.which;
if(cljs.core.truth_(pred__33135.call(null,goog.events.KeyCodes.UP,expr__33136))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_prev);
} else {
if(cljs.core.truth_(pred__33135.call(null,goog.events.KeyCodes.DOWN,expr__33136))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_next);
} else {
if(cljs.core.truth_(pred__33135.call(null,goog.events.KeyCodes.ENTER,expr__33136))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.choose_suggestion_active);
} else {
if(cljs.core.truth_(pred__33135.call(null,goog.events.KeyCodes.ESC,expr__33136))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.reset_typeahead);
} else {
if(cljs.core.truth_(pred__33135.call(null,goog.events.KeyCodes.TAB,expr__33136))){
if(cljs.core.truth_(cljs.core.not_empty.call(null,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state_atom))))){
cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_next);

return event.preventDefault();
} else {
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.input_text_will_blur);
}
} else {
return true;
}
}
}
}
}
});
re_com.typeahead.typeahead_args_desc = new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"data-source","data-source",-658934676),new cljs.core.Keyword(null,"required","required",1807647006),true,new cljs.core.Keyword(null,"type","type",1174270348),"fn",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null)," supplies suggestion objects. This can either accept a single string argument (the search term), or a string and a callback. For the first case, the fn should return a collection of suggestion objects (which can be anything). For the second case, the fn should return ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"nil"], null),", and eventually result in a call to the callback with a collection of suggestion objects."], null)], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),null,new cljs.core.Keyword(null,"type","type",1174270348),"string -> nil",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":change-on-blur?"], null)," controls when it is called. It is passed a suggestion object."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),true,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"when true, invoke ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":on-change"], null)," when the user chooses a suggestion, otherwise invoke it on every change (navigating through suggestions with the mouse or keyboard, or if ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"rigid?"], null)," is also ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"false"], null),", invoke it on every character typed.)"], null)], null),cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"model","model",331153215),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),null,new cljs.core.Keyword(null,"type","type",1174270348),"object | atom",new cljs.core.Keyword(null,"description","description",-1428560544),"The initial value of the typeahead (should match the suggestion objects returned by ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),")."]),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"debounce-delay","debounce-delay",-608187982),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),(250),new cljs.core.Keyword(null,"type","type",1174270348),"integer",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.integer_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"After receiving input, the typeahead will wait this many milliseconds without receiving new input before calling ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),"."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"render-suggestion","render-suggestion",1472406503),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"render fn",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"override the rendering of the suggestion items by passing a fn that returns hiccup forms. The fn will receive two arguments: the search term, and the suggestion object."], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"suggestion -> string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"When a suggestion is chosen, the input-text value will be set to the result of calling this fn with the suggestion object."], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),true,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"If ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"false"], null)," the user will be allowed to choose arbitrary text input rather than a suggestion from ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),". In this case, a string will be supplied in lieu of a suggestion object."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"keyword",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.input_status_type_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"validation status. ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"nil/omitted"], null)," for normal status or one of: ",re_com.validate.input_status_types_list], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"when true, display an icon to match ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":status"], null)," (no icon for nil)"], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"displayed in status icon's tooltip"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"background text shown when empty"], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),"250px",new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"standard CSS width setting for this input"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"height","height",1025178622),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"standard CSS height setting for this input"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),"if true, the user can't interact (input anything)"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"CSS class names, space separated"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"CSS style map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.css_style_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"CSS styles to add or override"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"HTML attr map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.html_attr_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"HTML attributes, like ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":on-mouse-move"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"br","br",934104792)], null),"No ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":class"], null)," or ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":style"], null),"allowed"], null)], null)], null);
/**
 * typeahead reagent component
 */
re_com.typeahead.typeahead = (function re_com$typeahead$typeahead(var_args){
var args__29526__auto__ = [];
var len__29519__auto___33160 = arguments.length;
var i__29520__auto___33161 = (0);
while(true){
if((i__29520__auto___33161 < len__29519__auto___33160)){
args__29526__auto__.push((arguments[i__29520__auto___33161]));

var G__33162 = (i__29520__auto___33161 + (1));
i__29520__auto___33161 = G__33162;
continue;
} else {
}
break;
}

var argseq__29527__auto__ = ((((0) < args__29526__auto__.length))?(new cljs.core.IndexedSeq(args__29526__auto__.slice((0)),(0),null)):null);
return re_com.typeahead.typeahead.cljs$core$IFn$_invoke$arity$variadic(argseq__29527__auto__);
});

re_com.typeahead.typeahead.cljs$core$IFn$_invoke$arity$variadic = (function (p__33140){
var map__33141 = p__33140;
var map__33141__$1 = ((((!((map__33141 == null)))?((((map__33141.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33141.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33141):map__33141);
var args = map__33141__$1;
if(cljs.core.truth_(((!(goog.DEBUG))?true:re_com.validate.validate_args.call(null,re_com.validate.extract_arg_data.call(null,re_com.typeahead.typeahead_args_desc),args,"typeahead")))){
} else {
throw (new Error("Assert failed: (validate-args-macro typeahead-args-desc args \"typeahead\")"));
}

var map__33143 = re_com.typeahead.make_typeahead_state.call(null,args);
var map__33143__$1 = ((((!((map__33143 == null)))?((((map__33143.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33143.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33143):map__33143);
var state = map__33143__$1;
var c_search = cljs.core.get.call(null,map__33143__$1,new cljs.core.Keyword(null,"c-search","c-search",1832536180));
var c_input = cljs.core.get.call(null,map__33143__$1,new cljs.core.Keyword(null,"c-input","c-input",-1821004232));
var state_atom = reagent.core.atom.call(null,state);
var input_text_model = reagent.core.cursor.call(null,state_atom,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input-text","input-text",-1336297114)], null));
re_com.typeahead.search_data_source_loop_BANG_.call(null,state_atom,c_search);

return ((function (map__33143,map__33143__$1,state,c_search,c_input,state_atom,input_text_model,map__33141,map__33141__$1,args){
return (function() { 
var G__33163__delegate = function (p__33145){
var map__33146 = p__33145;
var map__33146__$1 = ((((!((map__33146 == null)))?((((map__33146.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33146.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33146):map__33146);
var args__$1 = map__33146__$1;
var disabled_QMARK_ = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var status_icon_QMARK_ = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612));
var height = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var status_tooltip = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007));
var model = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"model","model",331153215));
var _debounce_delay = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"_debounce-delay","_debounce-delay",-1476744225));
var _on_change = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"_on-change","_on-change",156649312));
var placeholder = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var render_suggestion = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"render-suggestion","render-suggestion",1472406503));
var _suggestion_to_string = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"_suggestion-to-string","_suggestion-to-string",795407399));
var width = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var data_source = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"data-source","data-source",-658934676));
var _rigid_QMARK_ = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"_rigid?","_rigid?",1424449294));
var style = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var _change_on_blur_QMARK_ = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"_change-on-blur?","_change-on-blur?",1219941073));
var status = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var class$ = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var _attr = cljs.core.get.call(null,map__33146__$1,new cljs.core.Keyword(null,"_attr","_attr",299438964));
if(cljs.core.truth_(((!(goog.DEBUG))?true:re_com.validate.validate_args.call(null,re_com.validate.extract_arg_data.call(null,re_com.typeahead.typeahead_args_desc),args__$1,"typeahead")))){
} else {
throw (new Error("Assert failed: (validate-args-macro typeahead-args-desc args \"typeahead\")"));
}

var map__33148 = cljs.core.deref.call(null,state_atom);
var map__33148__$1 = ((((!((map__33148 == null)))?((((map__33148.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33148.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33148):map__33148);
var state__$1 = map__33148__$1;
var suggestions = cljs.core.get.call(null,map__33148__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var waiting_QMARK_ = cljs.core.get.call(null,map__33148__$1,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215));
var suggestion_active_index = cljs.core.get.call(null,map__33148__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var external_model = cljs.core.get.call(null,map__33148__$1,new cljs.core.Keyword(null,"external-model","external-model",506095421));
var last_data_source = new cljs.core.Keyword(null,"data-source","data-source",-658934676).cljs$core$IFn$_invoke$arity$1(state__$1);
var latest_external_model = re_com.util.deref_or_value.call(null,model);
var width__$1 = (function (){var or__28348__auto__ = width;
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return "250px";
}
})();
if(cljs.core.not_EQ_.call(null,last_data_source,data_source)){
cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.change_data_source,data_source);
} else {
}

if(cljs.core.not_EQ_.call(null,latest_external_model,external_model)){
cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.external_model_changed,latest_external_model);
} else {
}

return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.v_box,new cljs.core.Keyword(null,"width","width",-384071477),width__$1,new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.misc.input_text,new cljs.core.Keyword(null,"model","model",331153215),input_text_model,new cljs.core.Keyword(null,"class","class",-2030961996),class$,new cljs.core.Keyword(null,"style","style",-496642736),style,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),disabled_QMARK_,new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612),status_icon_QMARK_,new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007),status_tooltip,new cljs.core.Keyword(null,"width","width",-384071477),width__$1,new cljs.core.Keyword(null,"height","height",1025178622),height,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),placeholder,new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.partial.call(null,re_com.typeahead.input_text_on_change_BANG_,state_atom),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),false,new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-key-down","on-key-down",-1374733765),cljs.core.partial.call(null,re_com.typeahead.input_text_on_key_down_BANG_,state_atom)], null)], null),(cljs.core.truth_((function (){var or__28348__auto__ = cljs.core.not_empty.call(null,suggestions);
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return waiting_QMARK_;
}
})())?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"position","position",-2011731912),"relative"], null),new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.v_box,new cljs.core.Keyword(null,"class","class",-2030961996),"rc-typeahead-suggestions-container",new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(waiting_QMARK_)?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"align","align",1964212802),new cljs.core.Keyword(null,"center","center",-748944368),new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.misc.throbber,new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"small","small",2133478704),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-typeahead-throbber"], null)], null):null),(function (){var iter__29156__auto__ = ((function (map__33148,map__33148__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33146,map__33146__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33143,map__33143__$1,state,c_search,c_input,state_atom,input_text_model,map__33141,map__33141__$1,args){
return (function re_com$typeahead$iter__33150(s__33151){
return (new cljs.core.LazySeq(null,((function (map__33148,map__33148__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33146,map__33146__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33143,map__33143__$1,state,c_search,c_input,state_atom,input_text_model,map__33141,map__33141__$1,args){
return (function (){
var s__33151__$1 = s__33151;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__33151__$1);
if(temp__4657__auto__){
var s__33151__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33151__$2)){
var c__29154__auto__ = cljs.core.chunk_first.call(null,s__33151__$2);
var size__29155__auto__ = cljs.core.count.call(null,c__29154__auto__);
var b__33153 = cljs.core.chunk_buffer.call(null,size__29155__auto__);
if((function (){var i__33152 = (0);
while(true){
if((i__33152 < size__29155__auto__)){
var vec__33154 = cljs.core._nth.call(null,c__29154__auto__,i__33152);
var i = cljs.core.nth.call(null,vec__33154,(0),null);
var s = cljs.core.nth.call(null,vec__33154,(1),null);
var selected_QMARK_ = cljs.core._EQ_.call(null,suggestion_active_index,i);
cljs.core.chunk_append.call(null,b__33153,cljs.core.with_meta(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"child","child",623967545),(cljs.core.truth_(render_suggestion)?render_suggestion.call(null,s):s),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-typeahead-suggestion",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((selected_QMARK_)?" active":null))].join(''),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),((function (i__33152,selected_QMARK_,vec__33154,i,s,c__29154__auto__,size__29155__auto__,b__33153,s__33151__$2,temp__4657__auto__,map__33148,map__33148__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33146,map__33146__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33143,map__33143__$1,state,c_search,c_input,state_atom,input_text_model,map__33141,map__33141__$1,args){
return (function (){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_by_index,i);
});})(i__33152,selected_QMARK_,vec__33154,i,s,c__29154__auto__,size__29155__auto__,b__33153,s__33151__$2,temp__4657__auto__,map__33148,map__33148__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33146,map__33146__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33143,map__33143__$1,state,c_search,c_input,state_atom,input_text_model,map__33141,map__33141__$1,args))
,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),((function (i__33152,selected_QMARK_,vec__33154,i,s,c__29154__auto__,size__29155__auto__,b__33153,s__33151__$2,temp__4657__auto__,map__33148,map__33148__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33146,map__33146__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33143,map__33143__$1,state,c_search,c_input,state_atom,input_text_model,map__33141,map__33141__$1,args){
return (function (p1__33138_SHARP_){
p1__33138_SHARP_.preventDefault();

return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.choose_suggestion_by_index,i);
});})(i__33152,selected_QMARK_,vec__33154,i,s,c__29154__auto__,size__29155__auto__,b__33153,s__33151__$2,temp__4657__auto__,map__33148,map__33148__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33146,map__33146__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33143,map__33143__$1,state,c_search,c_input,state_atom,input_text_model,map__33141,map__33141__$1,args))
], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),i], null)));

var G__33164 = (i__33152 + (1));
i__33152 = G__33164;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33153),re_com$typeahead$iter__33150.call(null,cljs.core.chunk_rest.call(null,s__33151__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33153),null);
}
} else {
var vec__33157 = cljs.core.first.call(null,s__33151__$2);
var i = cljs.core.nth.call(null,vec__33157,(0),null);
var s = cljs.core.nth.call(null,vec__33157,(1),null);
var selected_QMARK_ = cljs.core._EQ_.call(null,suggestion_active_index,i);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"child","child",623967545),(cljs.core.truth_(render_suggestion)?render_suggestion.call(null,s):s),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-typeahead-suggestion",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((selected_QMARK_)?" active":null))].join(''),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),((function (selected_QMARK_,vec__33157,i,s,s__33151__$2,temp__4657__auto__,map__33148,map__33148__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33146,map__33146__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33143,map__33143__$1,state,c_search,c_input,state_atom,input_text_model,map__33141,map__33141__$1,args){
return (function (){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_by_index,i);
});})(selected_QMARK_,vec__33157,i,s,s__33151__$2,temp__4657__auto__,map__33148,map__33148__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33146,map__33146__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33143,map__33143__$1,state,c_search,c_input,state_atom,input_text_model,map__33141,map__33141__$1,args))
,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),((function (selected_QMARK_,vec__33157,i,s,s__33151__$2,temp__4657__auto__,map__33148,map__33148__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33146,map__33146__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33143,map__33143__$1,state,c_search,c_input,state_atom,input_text_model,map__33141,map__33141__$1,args){
return (function (p1__33138_SHARP_){
p1__33138_SHARP_.preventDefault();

return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.choose_suggestion_by_index,i);
});})(selected_QMARK_,vec__33157,i,s,s__33151__$2,temp__4657__auto__,map__33148,map__33148__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33146,map__33146__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33143,map__33143__$1,state,c_search,c_input,state_atom,input_text_model,map__33141,map__33141__$1,args))
], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),i], null)),re_com$typeahead$iter__33150.call(null,cljs.core.rest.call(null,s__33151__$2)));
}
} else {
return null;
}
break;
}
});})(map__33148,map__33148__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33146,map__33146__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33143,map__33143__$1,state,c_search,c_input,state_atom,input_text_model,map__33141,map__33141__$1,args))
,null,null));
});})(map__33148,map__33148__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__33146,map__33146__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__33143,map__33143__$1,state,c_search,c_input,state_atom,input_text_model,map__33141,map__33141__$1,args))
;
return iter__29156__auto__.call(null,cljs.core.map.call(null,cljs.core.vector,cljs.core.range.call(null),suggestions));
})()], null)], null)], null):null)], null)], null);
};
var G__33163 = function (var_args){
var p__33145 = null;
if (arguments.length > 0) {
var G__33165__i = 0, G__33165__a = new Array(arguments.length -  0);
while (G__33165__i < G__33165__a.length) {G__33165__a[G__33165__i] = arguments[G__33165__i + 0]; ++G__33165__i;}
  p__33145 = new cljs.core.IndexedSeq(G__33165__a,0,null);
} 
return G__33163__delegate.call(this,p__33145);};
G__33163.cljs$lang$maxFixedArity = 0;
G__33163.cljs$lang$applyTo = (function (arglist__33166){
var p__33145 = cljs.core.seq(arglist__33166);
return G__33163__delegate(p__33145);
});
G__33163.cljs$core$IFn$_invoke$arity$variadic = G__33163__delegate;
return G__33163;
})()
;
;})(map__33143,map__33143__$1,state,c_search,c_input,state_atom,input_text_model,map__33141,map__33141__$1,args))
});

re_com.typeahead.typeahead.cljs$lang$maxFixedArity = (0);

re_com.typeahead.typeahead.cljs$lang$applyTo = (function (seq33139){
return re_com.typeahead.typeahead.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33139));
});

/**
 * Return a channel which will receive a value from the `in` channel only
 *   if no further value is received on the `in` channel in the next `ms` milliseconds.
 */
re_com.typeahead.debounce = (function re_com$typeahead$debounce(in$,ms){
var out = cljs.core.async.chan.call(null);
var c__30950__auto___33247 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___33247,out){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___33247,out){
return (function (state_33217){
var state_val_33218 = (state_33217[(1)]);
if((state_val_33218 === (7))){
var inst_33172 = (state_33217[(2)]);
var state_33217__$1 = state_33217;
var statearr_33219_33248 = state_33217__$1;
(statearr_33219_33248[(2)] = inst_33172);

(statearr_33219_33248[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33218 === (1))){
var inst_33167 = null;
var state_33217__$1 = (function (){var statearr_33220 = state_33217;
(statearr_33220[(7)] = inst_33167);

return statearr_33220;
})();
var statearr_33221_33249 = state_33217__$1;
(statearr_33221_33249[(2)] = null);

(statearr_33221_33249[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33218 === (4))){
var state_33217__$1 = state_33217;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33217__$1,(7),in$);
} else {
if((state_val_33218 === (15))){
var inst_33202 = (state_33217[(2)]);
var state_33217__$1 = (function (){var statearr_33222 = state_33217;
(statearr_33222[(8)] = inst_33202);

return statearr_33222;
})();
var statearr_33223_33250 = state_33217__$1;
(statearr_33223_33250[(2)] = null);

(statearr_33223_33250[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33218 === (13))){
var inst_33190 = (state_33217[(9)]);
var inst_33204 = cljs.core._EQ_.call(null,inst_33190,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_33217__$1 = state_33217;
if(inst_33204){
var statearr_33224_33251 = state_33217__$1;
(statearr_33224_33251[(1)] = (16));

} else {
var statearr_33225_33252 = state_33217__$1;
(statearr_33225_33252[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33218 === (6))){
var inst_33176 = (state_33217[(10)]);
var inst_33175 = (state_33217[(2)]);
var inst_33176__$1 = cljs.core.async.timeout.call(null,ms);
var inst_33184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33185 = [in$,inst_33176__$1];
var inst_33186 = (new cljs.core.PersistentVector(null,2,(5),inst_33184,inst_33185,null));
var state_33217__$1 = (function (){var statearr_33226 = state_33217;
(statearr_33226[(10)] = inst_33176__$1);

(statearr_33226[(11)] = inst_33175);

return statearr_33226;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_33217__$1,(8),inst_33186);
} else {
if((state_val_33218 === (17))){
var state_33217__$1 = state_33217;
var statearr_33227_33253 = state_33217__$1;
(statearr_33227_33253[(2)] = null);

(statearr_33227_33253[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33218 === (3))){
var inst_33215 = (state_33217[(2)]);
var state_33217__$1 = state_33217;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33217__$1,inst_33215);
} else {
if((state_val_33218 === (12))){
var inst_33175 = (state_33217[(11)]);
var state_33217__$1 = state_33217;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33217__$1,(15),out,inst_33175);
} else {
if((state_val_33218 === (2))){
var inst_33167 = (state_33217[(7)]);
var inst_33169 = (inst_33167 == null);
var state_33217__$1 = state_33217;
if(cljs.core.truth_(inst_33169)){
var statearr_33228_33254 = state_33217__$1;
(statearr_33228_33254[(1)] = (4));

} else {
var statearr_33229_33255 = state_33217__$1;
(statearr_33229_33255[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33218 === (11))){
var inst_33212 = (state_33217[(2)]);
var inst_33167 = inst_33212;
var state_33217__$1 = (function (){var statearr_33230 = state_33217;
(statearr_33230[(7)] = inst_33167);

return statearr_33230;
})();
var statearr_33231_33256 = state_33217__$1;
(statearr_33231_33256[(2)] = null);

(statearr_33231_33256[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33218 === (9))){
var inst_33188 = (state_33217[(12)]);
var inst_33196 = cljs.core.nth.call(null,inst_33188,(0),null);
var inst_33197 = cljs.core.nth.call(null,inst_33188,(1),null);
var state_33217__$1 = (function (){var statearr_33232 = state_33217;
(statearr_33232[(13)] = inst_33197);

return statearr_33232;
})();
var statearr_33233_33257 = state_33217__$1;
(statearr_33233_33257[(2)] = inst_33196);

(statearr_33233_33257[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33218 === (5))){
var inst_33167 = (state_33217[(7)]);
var state_33217__$1 = state_33217;
var statearr_33234_33258 = state_33217__$1;
(statearr_33234_33258[(2)] = inst_33167);

(statearr_33234_33258[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33218 === (14))){
var inst_33210 = (state_33217[(2)]);
var state_33217__$1 = state_33217;
var statearr_33235_33259 = state_33217__$1;
(statearr_33235_33259[(2)] = inst_33210);

(statearr_33235_33259[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33218 === (16))){
var inst_33189 = (state_33217[(14)]);
var state_33217__$1 = state_33217;
var statearr_33236_33260 = state_33217__$1;
(statearr_33236_33260[(2)] = inst_33189);

(statearr_33236_33260[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33218 === (10))){
var inst_33176 = (state_33217[(10)]);
var inst_33190 = (state_33217[(9)]);
var inst_33199 = cljs.core._EQ_.call(null,inst_33190,inst_33176);
var state_33217__$1 = state_33217;
if(inst_33199){
var statearr_33237_33261 = state_33217__$1;
(statearr_33237_33261[(1)] = (12));

} else {
var statearr_33238_33262 = state_33217__$1;
(statearr_33238_33262[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33218 === (18))){
var inst_33208 = (state_33217[(2)]);
var state_33217__$1 = state_33217;
var statearr_33239_33263 = state_33217__$1;
(statearr_33239_33263[(2)] = inst_33208);

(statearr_33239_33263[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33218 === (8))){
var inst_33188 = (state_33217[(12)]);
var inst_33190 = (state_33217[(9)]);
var inst_33188__$1 = (state_33217[(2)]);
var inst_33189 = cljs.core.nth.call(null,inst_33188__$1,(0),null);
var inst_33190__$1 = cljs.core.nth.call(null,inst_33188__$1,(1),null);
var inst_33191 = cljs.core._EQ_.call(null,inst_33190__$1,in$);
var state_33217__$1 = (function (){var statearr_33240 = state_33217;
(statearr_33240[(14)] = inst_33189);

(statearr_33240[(12)] = inst_33188__$1);

(statearr_33240[(9)] = inst_33190__$1);

return statearr_33240;
})();
if(inst_33191){
var statearr_33241_33264 = state_33217__$1;
(statearr_33241_33264[(1)] = (9));

} else {
var statearr_33242_33265 = state_33217__$1;
(statearr_33242_33265[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto___33247,out))
;
return ((function (switch__30862__auto__,c__30950__auto___33247,out){
return (function() {
var re_com$typeahead$debounce_$_state_machine__30863__auto__ = null;
var re_com$typeahead$debounce_$_state_machine__30863__auto____0 = (function (){
var statearr_33243 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33243[(0)] = re_com$typeahead$debounce_$_state_machine__30863__auto__);

(statearr_33243[(1)] = (1));

return statearr_33243;
});
var re_com$typeahead$debounce_$_state_machine__30863__auto____1 = (function (state_33217){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_33217);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e33244){if((e33244 instanceof Object)){
var ex__30866__auto__ = e33244;
var statearr_33245_33266 = state_33217;
(statearr_33245_33266[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33217);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33244;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33267 = state_33217;
state_33217 = G__33267;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
re_com$typeahead$debounce_$_state_machine__30863__auto__ = function(state_33217){
switch(arguments.length){
case 0:
return re_com$typeahead$debounce_$_state_machine__30863__auto____0.call(this);
case 1:
return re_com$typeahead$debounce_$_state_machine__30863__auto____1.call(this,state_33217);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
re_com$typeahead$debounce_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = re_com$typeahead$debounce_$_state_machine__30863__auto____0;
re_com$typeahead$debounce_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = re_com$typeahead$debounce_$_state_machine__30863__auto____1;
return re_com$typeahead$debounce_$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___33247,out))
})();
var state__30952__auto__ = (function (){var statearr_33246 = f__30951__auto__.call(null);
(statearr_33246[(6)] = c__30950__auto___33247);

return statearr_33246;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___33247,out))
);


return out;
});

//# sourceMappingURL=typeahead.js.map?rel=1516617671678
