// Compiled by ClojureScript 1.9.946 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__28348__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__28348__auto__){
return or__28348__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__28348__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
var or__28348__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__28348__auto____$1)){
return or__28348__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__33662_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__33662_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__33663 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__33664 = null;
var count__33665 = (0);
var i__33666 = (0);
while(true){
if((i__33666 < count__33665)){
var n = cljs.core._nth.call(null,chunk__33664,i__33666);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__33667 = seq__33663;
var G__33668 = chunk__33664;
var G__33669 = count__33665;
var G__33670 = (i__33666 + (1));
seq__33663 = G__33667;
chunk__33664 = G__33668;
count__33665 = G__33669;
i__33666 = G__33670;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__33663);
if(temp__4657__auto__){
var seq__33663__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33663__$1)){
var c__29187__auto__ = cljs.core.chunk_first.call(null,seq__33663__$1);
var G__33671 = cljs.core.chunk_rest.call(null,seq__33663__$1);
var G__33672 = c__29187__auto__;
var G__33673 = cljs.core.count.call(null,c__29187__auto__);
var G__33674 = (0);
seq__33663 = G__33671;
chunk__33664 = G__33672;
count__33665 = G__33673;
i__33666 = G__33674;
continue;
} else {
var n = cljs.core.first.call(null,seq__33663__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__33675 = cljs.core.next.call(null,seq__33663__$1);
var G__33676 = null;
var G__33677 = (0);
var G__33678 = (0);
seq__33663 = G__33675;
chunk__33664 = G__33676;
count__33665 = G__33677;
i__33666 = G__33678;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.in_upper_level_QMARK_ = (function figwheel$client$file_reloading$in_upper_level_QMARK_(topo_state,current_depth,dep){
return cljs.core.some.call(null,(function (p__33679){
var vec__33680 = p__33679;
var _ = cljs.core.nth.call(null,vec__33680,(0),null);
var v = cljs.core.nth.call(null,vec__33680,(1),null);
var and__28336__auto__ = v;
if(cljs.core.truth_(and__28336__auto__)){
return v.call(null,dep);
} else {
return and__28336__auto__;
}
}),cljs.core.filter.call(null,(function (p__33683){
var vec__33684 = p__33683;
var k = cljs.core.nth.call(null,vec__33684,(0),null);
var v = cljs.core.nth.call(null,vec__33684,(1),null);
return (k > current_depth);
}),topo_state));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__33696_33704 = cljs.core.seq.call(null,deps);
var chunk__33697_33705 = null;
var count__33698_33706 = (0);
var i__33699_33707 = (0);
while(true){
if((i__33699_33707 < count__33698_33706)){
var dep_33708 = cljs.core._nth.call(null,chunk__33697_33705,i__33699_33707);
if(cljs.core.truth_((function (){var and__28336__auto__ = dep_33708;
if(cljs.core.truth_(and__28336__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_33708));
} else {
return and__28336__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_33708,(depth + (1)),state);
} else {
}

var G__33709 = seq__33696_33704;
var G__33710 = chunk__33697_33705;
var G__33711 = count__33698_33706;
var G__33712 = (i__33699_33707 + (1));
seq__33696_33704 = G__33709;
chunk__33697_33705 = G__33710;
count__33698_33706 = G__33711;
i__33699_33707 = G__33712;
continue;
} else {
var temp__4657__auto___33713 = cljs.core.seq.call(null,seq__33696_33704);
if(temp__4657__auto___33713){
var seq__33696_33714__$1 = temp__4657__auto___33713;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33696_33714__$1)){
var c__29187__auto___33715 = cljs.core.chunk_first.call(null,seq__33696_33714__$1);
var G__33716 = cljs.core.chunk_rest.call(null,seq__33696_33714__$1);
var G__33717 = c__29187__auto___33715;
var G__33718 = cljs.core.count.call(null,c__29187__auto___33715);
var G__33719 = (0);
seq__33696_33704 = G__33716;
chunk__33697_33705 = G__33717;
count__33698_33706 = G__33718;
i__33699_33707 = G__33719;
continue;
} else {
var dep_33720 = cljs.core.first.call(null,seq__33696_33714__$1);
if(cljs.core.truth_((function (){var and__28336__auto__ = dep_33720;
if(cljs.core.truth_(and__28336__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_33720));
} else {
return and__28336__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_33720,(depth + (1)),state);
} else {
}

var G__33721 = cljs.core.next.call(null,seq__33696_33714__$1);
var G__33722 = null;
var G__33723 = (0);
var G__33724 = (0);
seq__33696_33704 = G__33721;
chunk__33697_33705 = G__33722;
count__33698_33706 = G__33723;
i__33699_33707 = G__33724;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__33700){
var vec__33701 = p__33700;
var seq__33702 = cljs.core.seq.call(null,vec__33701);
var first__33703 = cljs.core.first.call(null,seq__33702);
var seq__33702__$1 = cljs.core.next.call(null,seq__33702);
var x = first__33703;
var xs = seq__33702__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__33701,seq__33702,first__33703,seq__33702__$1,x,xs,get_deps__$1){
return (function (p1__33687_SHARP_){
return clojure.set.difference.call(null,p1__33687_SHARP_,x);
});})(vec__33701,seq__33702,first__33703,seq__33702__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__33725 = cljs.core.seq.call(null,provides);
var chunk__33726 = null;
var count__33727 = (0);
var i__33728 = (0);
while(true){
if((i__33728 < count__33727)){
var prov = cljs.core._nth.call(null,chunk__33726,i__33728);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__33729_33737 = cljs.core.seq.call(null,requires);
var chunk__33730_33738 = null;
var count__33731_33739 = (0);
var i__33732_33740 = (0);
while(true){
if((i__33732_33740 < count__33731_33739)){
var req_33741 = cljs.core._nth.call(null,chunk__33730_33738,i__33732_33740);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33741,prov);

var G__33742 = seq__33729_33737;
var G__33743 = chunk__33730_33738;
var G__33744 = count__33731_33739;
var G__33745 = (i__33732_33740 + (1));
seq__33729_33737 = G__33742;
chunk__33730_33738 = G__33743;
count__33731_33739 = G__33744;
i__33732_33740 = G__33745;
continue;
} else {
var temp__4657__auto___33746 = cljs.core.seq.call(null,seq__33729_33737);
if(temp__4657__auto___33746){
var seq__33729_33747__$1 = temp__4657__auto___33746;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33729_33747__$1)){
var c__29187__auto___33748 = cljs.core.chunk_first.call(null,seq__33729_33747__$1);
var G__33749 = cljs.core.chunk_rest.call(null,seq__33729_33747__$1);
var G__33750 = c__29187__auto___33748;
var G__33751 = cljs.core.count.call(null,c__29187__auto___33748);
var G__33752 = (0);
seq__33729_33737 = G__33749;
chunk__33730_33738 = G__33750;
count__33731_33739 = G__33751;
i__33732_33740 = G__33752;
continue;
} else {
var req_33753 = cljs.core.first.call(null,seq__33729_33747__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33753,prov);

var G__33754 = cljs.core.next.call(null,seq__33729_33747__$1);
var G__33755 = null;
var G__33756 = (0);
var G__33757 = (0);
seq__33729_33737 = G__33754;
chunk__33730_33738 = G__33755;
count__33731_33739 = G__33756;
i__33732_33740 = G__33757;
continue;
}
} else {
}
}
break;
}

var G__33758 = seq__33725;
var G__33759 = chunk__33726;
var G__33760 = count__33727;
var G__33761 = (i__33728 + (1));
seq__33725 = G__33758;
chunk__33726 = G__33759;
count__33727 = G__33760;
i__33728 = G__33761;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__33725);
if(temp__4657__auto__){
var seq__33725__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33725__$1)){
var c__29187__auto__ = cljs.core.chunk_first.call(null,seq__33725__$1);
var G__33762 = cljs.core.chunk_rest.call(null,seq__33725__$1);
var G__33763 = c__29187__auto__;
var G__33764 = cljs.core.count.call(null,c__29187__auto__);
var G__33765 = (0);
seq__33725 = G__33762;
chunk__33726 = G__33763;
count__33727 = G__33764;
i__33728 = G__33765;
continue;
} else {
var prov = cljs.core.first.call(null,seq__33725__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__33733_33766 = cljs.core.seq.call(null,requires);
var chunk__33734_33767 = null;
var count__33735_33768 = (0);
var i__33736_33769 = (0);
while(true){
if((i__33736_33769 < count__33735_33768)){
var req_33770 = cljs.core._nth.call(null,chunk__33734_33767,i__33736_33769);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33770,prov);

var G__33771 = seq__33733_33766;
var G__33772 = chunk__33734_33767;
var G__33773 = count__33735_33768;
var G__33774 = (i__33736_33769 + (1));
seq__33733_33766 = G__33771;
chunk__33734_33767 = G__33772;
count__33735_33768 = G__33773;
i__33736_33769 = G__33774;
continue;
} else {
var temp__4657__auto___33775__$1 = cljs.core.seq.call(null,seq__33733_33766);
if(temp__4657__auto___33775__$1){
var seq__33733_33776__$1 = temp__4657__auto___33775__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33733_33776__$1)){
var c__29187__auto___33777 = cljs.core.chunk_first.call(null,seq__33733_33776__$1);
var G__33778 = cljs.core.chunk_rest.call(null,seq__33733_33776__$1);
var G__33779 = c__29187__auto___33777;
var G__33780 = cljs.core.count.call(null,c__29187__auto___33777);
var G__33781 = (0);
seq__33733_33766 = G__33778;
chunk__33734_33767 = G__33779;
count__33735_33768 = G__33780;
i__33736_33769 = G__33781;
continue;
} else {
var req_33782 = cljs.core.first.call(null,seq__33733_33776__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33782,prov);

var G__33783 = cljs.core.next.call(null,seq__33733_33776__$1);
var G__33784 = null;
var G__33785 = (0);
var G__33786 = (0);
seq__33733_33766 = G__33783;
chunk__33734_33767 = G__33784;
count__33735_33768 = G__33785;
i__33736_33769 = G__33786;
continue;
}
} else {
}
}
break;
}

var G__33787 = cljs.core.next.call(null,seq__33725__$1);
var G__33788 = null;
var G__33789 = (0);
var G__33790 = (0);
seq__33725 = G__33787;
chunk__33726 = G__33788;
count__33727 = G__33789;
i__33728 = G__33790;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__33791_33795 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__33792_33796 = null;
var count__33793_33797 = (0);
var i__33794_33798 = (0);
while(true){
if((i__33794_33798 < count__33793_33797)){
var ns_33799 = cljs.core._nth.call(null,chunk__33792_33796,i__33794_33798);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_33799);

var G__33800 = seq__33791_33795;
var G__33801 = chunk__33792_33796;
var G__33802 = count__33793_33797;
var G__33803 = (i__33794_33798 + (1));
seq__33791_33795 = G__33800;
chunk__33792_33796 = G__33801;
count__33793_33797 = G__33802;
i__33794_33798 = G__33803;
continue;
} else {
var temp__4657__auto___33804 = cljs.core.seq.call(null,seq__33791_33795);
if(temp__4657__auto___33804){
var seq__33791_33805__$1 = temp__4657__auto___33804;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33791_33805__$1)){
var c__29187__auto___33806 = cljs.core.chunk_first.call(null,seq__33791_33805__$1);
var G__33807 = cljs.core.chunk_rest.call(null,seq__33791_33805__$1);
var G__33808 = c__29187__auto___33806;
var G__33809 = cljs.core.count.call(null,c__29187__auto___33806);
var G__33810 = (0);
seq__33791_33795 = G__33807;
chunk__33792_33796 = G__33808;
count__33793_33797 = G__33809;
i__33794_33798 = G__33810;
continue;
} else {
var ns_33811 = cljs.core.first.call(null,seq__33791_33805__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_33811);

var G__33812 = cljs.core.next.call(null,seq__33791_33805__$1);
var G__33813 = null;
var G__33814 = (0);
var G__33815 = (0);
seq__33791_33795 = G__33812;
chunk__33792_33796 = G__33813;
count__33793_33797 = G__33814;
i__33794_33798 = G__33815;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__28348__auto__ = goog.require__;
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__33816__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__33816 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__33817__i = 0, G__33817__a = new Array(arguments.length -  0);
while (G__33817__i < G__33817__a.length) {G__33817__a[G__33817__i] = arguments[G__33817__i + 0]; ++G__33817__i;}
  args = new cljs.core.IndexedSeq(G__33817__a,0,null);
} 
return G__33816__delegate.call(this,args);};
G__33816.cljs$lang$maxFixedArity = 0;
G__33816.cljs$lang$applyTo = (function (arglist__33818){
var args = cljs.core.seq(arglist__33818);
return G__33816__delegate(args);
});
G__33816.cljs$core$IFn$_invoke$arity$variadic = G__33816__delegate;
return G__33816;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = ((typeof goog.net.jsloader.safeLoad !== 'undefined')?(function (p1__33819_SHARP_,p2__33820_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33819_SHARP_)].join('')),p2__33820_SHARP_);
}):((typeof goog.net.jsloader.load !== 'undefined')?(function (p1__33821_SHARP_,p2__33822_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33821_SHARP_)].join(''),p2__33822_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__33823 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__33823.addCallback(((function (G__33823){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__33823))
);

G__33823.addErrback(((function (G__33823){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__33823))
);

return G__33823;
});
figwheel.client.file_reloading.write_script_tag_import = figwheel.client.file_reloading.reload_file_in_html_env;
goog.exportSymbol('figwheel.client.file_reloading.write_script_tag_import', figwheel.client.file_reloading.write_script_tag_import);
figwheel.client.file_reloading.worker_import_script = (function figwheel$client$file_reloading$worker_import_script(request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e33824){if((e33824 instanceof Error)){
var e = e33824;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e33824;

}
}})());
});
goog.exportSymbol('figwheel.client.file_reloading.worker_import_script', figwheel.client.file_reloading.worker_import_script);
figwheel.client.file_reloading.create_node_script_import_fn = (function figwheel$client$file_reloading$create_node_script_import_fn(){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e33825){if((e33825 instanceof Error)){
var e = e33825;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e33825;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path))
});
goog.exportSymbol('figwheel.client.file_reloading.create_node_script_import_fn', figwheel.client.file_reloading.create_node_script_import_fn);
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__33826 = cljs.core._EQ_;
var expr__33827 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__33826.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__33827))){
return figwheel.client.file_reloading.create_node_script_import_fn.call(null);
} else {
if(cljs.core.truth_(pred__33826.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__33827))){
return figwheel.client.file_reloading.write_script_tag_import;
} else {
if(cljs.core.truth_(pred__33826.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__33827))){
return figwheel.client.file_reloading.worker_import_script;
} else {
return ((function (pred__33826,expr__33827){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__33826,expr__33827))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__33829,callback){
var map__33830 = p__33829;
var map__33830__$1 = ((((!((map__33830 == null)))?((((map__33830.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33830.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33830):map__33830);
var file_msg = map__33830__$1;
var request_url = cljs.core.get.call(null,map__33830__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return (function (){var or__28348__auto__ = goog.object.get(goog.global,"FIGWHEEL_IMPORT_SCRIPT");
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return figwheel.client.file_reloading.reload_file_STAR_;
}
})().call(null,request_url,((function (map__33830,map__33830__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__33830,map__33830__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__30950__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto__){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto__){
return (function (state_33870){
var state_val_33871 = (state_33870[(1)]);
if((state_val_33871 === (7))){
var inst_33866 = (state_33870[(2)]);
var state_33870__$1 = state_33870;
var statearr_33872_33899 = state_33870__$1;
(statearr_33872_33899[(2)] = inst_33866);

(statearr_33872_33899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33871 === (1))){
var state_33870__$1 = state_33870;
var statearr_33873_33900 = state_33870__$1;
(statearr_33873_33900[(2)] = null);

(statearr_33873_33900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33871 === (4))){
var inst_33834 = (state_33870[(7)]);
var inst_33834__$1 = (state_33870[(2)]);
var state_33870__$1 = (function (){var statearr_33874 = state_33870;
(statearr_33874[(7)] = inst_33834__$1);

return statearr_33874;
})();
if(cljs.core.truth_(inst_33834__$1)){
var statearr_33875_33901 = state_33870__$1;
(statearr_33875_33901[(1)] = (5));

} else {
var statearr_33876_33902 = state_33870__$1;
(statearr_33876_33902[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33871 === (15))){
var inst_33851 = (state_33870[(8)]);
var inst_33848 = (state_33870[(9)]);
var inst_33853 = inst_33851.call(null,inst_33848);
var state_33870__$1 = state_33870;
var statearr_33877_33903 = state_33870__$1;
(statearr_33877_33903[(2)] = inst_33853);

(statearr_33877_33903[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33871 === (13))){
var inst_33860 = (state_33870[(2)]);
var state_33870__$1 = state_33870;
var statearr_33878_33904 = state_33870__$1;
(statearr_33878_33904[(2)] = inst_33860);

(statearr_33878_33904[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33871 === (6))){
var state_33870__$1 = state_33870;
var statearr_33879_33905 = state_33870__$1;
(statearr_33879_33905[(2)] = null);

(statearr_33879_33905[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33871 === (17))){
var inst_33857 = (state_33870[(2)]);
var state_33870__$1 = state_33870;
var statearr_33880_33906 = state_33870__$1;
(statearr_33880_33906[(2)] = inst_33857);

(statearr_33880_33906[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33871 === (3))){
var inst_33868 = (state_33870[(2)]);
var state_33870__$1 = state_33870;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33870__$1,inst_33868);
} else {
if((state_val_33871 === (12))){
var state_33870__$1 = state_33870;
var statearr_33881_33907 = state_33870__$1;
(statearr_33881_33907[(2)] = null);

(statearr_33881_33907[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33871 === (2))){
var state_33870__$1 = state_33870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33870__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_33871 === (11))){
var inst_33839 = (state_33870[(10)]);
var inst_33846 = figwheel.client.file_reloading.blocking_load.call(null,inst_33839);
var state_33870__$1 = state_33870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33870__$1,(14),inst_33846);
} else {
if((state_val_33871 === (9))){
var inst_33839 = (state_33870[(10)]);
var state_33870__$1 = state_33870;
if(cljs.core.truth_(inst_33839)){
var statearr_33882_33908 = state_33870__$1;
(statearr_33882_33908[(1)] = (11));

} else {
var statearr_33883_33909 = state_33870__$1;
(statearr_33883_33909[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33871 === (5))){
var inst_33840 = (state_33870[(11)]);
var inst_33834 = (state_33870[(7)]);
var inst_33839 = cljs.core.nth.call(null,inst_33834,(0),null);
var inst_33840__$1 = cljs.core.nth.call(null,inst_33834,(1),null);
var state_33870__$1 = (function (){var statearr_33884 = state_33870;
(statearr_33884[(10)] = inst_33839);

(statearr_33884[(11)] = inst_33840__$1);

return statearr_33884;
})();
if(cljs.core.truth_(inst_33840__$1)){
var statearr_33885_33910 = state_33870__$1;
(statearr_33885_33910[(1)] = (8));

} else {
var statearr_33886_33911 = state_33870__$1;
(statearr_33886_33911[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33871 === (14))){
var inst_33839 = (state_33870[(10)]);
var inst_33851 = (state_33870[(8)]);
var inst_33848 = (state_33870[(2)]);
var inst_33849 = console.log("Loading!",inst_33839);
var inst_33850 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_33851__$1 = cljs.core.get.call(null,inst_33850,inst_33839);
var state_33870__$1 = (function (){var statearr_33887 = state_33870;
(statearr_33887[(8)] = inst_33851__$1);

(statearr_33887[(12)] = inst_33849);

(statearr_33887[(9)] = inst_33848);

return statearr_33887;
})();
if(cljs.core.truth_(inst_33851__$1)){
var statearr_33888_33912 = state_33870__$1;
(statearr_33888_33912[(1)] = (15));

} else {
var statearr_33889_33913 = state_33870__$1;
(statearr_33889_33913[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33871 === (16))){
var inst_33848 = (state_33870[(9)]);
var inst_33855 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_33848);
var state_33870__$1 = state_33870;
var statearr_33890_33914 = state_33870__$1;
(statearr_33890_33914[(2)] = inst_33855);

(statearr_33890_33914[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33871 === (10))){
var inst_33862 = (state_33870[(2)]);
var state_33870__$1 = (function (){var statearr_33891 = state_33870;
(statearr_33891[(13)] = inst_33862);

return statearr_33891;
})();
var statearr_33892_33915 = state_33870__$1;
(statearr_33892_33915[(2)] = null);

(statearr_33892_33915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33871 === (8))){
var inst_33840 = (state_33870[(11)]);
var inst_33842 = console.log("Evaling!",inst_33840);
var inst_33843 = eval(inst_33840);
var state_33870__$1 = (function (){var statearr_33893 = state_33870;
(statearr_33893[(14)] = inst_33842);

return statearr_33893;
})();
var statearr_33894_33916 = state_33870__$1;
(statearr_33894_33916[(2)] = inst_33843);

(statearr_33894_33916[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto__))
;
return ((function (switch__30862__auto__,c__30950__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__30863__auto__ = null;
var figwheel$client$file_reloading$state_machine__30863__auto____0 = (function (){
var statearr_33895 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33895[(0)] = figwheel$client$file_reloading$state_machine__30863__auto__);

(statearr_33895[(1)] = (1));

return statearr_33895;
});
var figwheel$client$file_reloading$state_machine__30863__auto____1 = (function (state_33870){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_33870);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e33896){if((e33896 instanceof Object)){
var ex__30866__auto__ = e33896;
var statearr_33897_33917 = state_33870;
(statearr_33897_33917[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33870);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33896;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33918 = state_33870;
state_33870 = G__33918;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__30863__auto__ = function(state_33870){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__30863__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__30863__auto____1.call(this,state_33870);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__30863__auto____0;
figwheel$client$file_reloading$state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__30863__auto____1;
return figwheel$client$file_reloading$state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto__))
})();
var state__30952__auto__ = (function (){var statearr_33898 = f__30951__auto__.call(null);
(statearr_33898[(6)] = c__30950__auto__);

return statearr_33898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto__))
);

return c__30950__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(var_args){
var G__33920 = arguments.length;
switch (G__33920) {
case 1:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1 = (function (url){
return figwheel.client.file_reloading.queued_file_reload.call(null,url,null);
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2 = (function (url,opt_source_text){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,opt_source_text], null));
});

figwheel.client.file_reloading.queued_file_reload.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__33922,callback){
var map__33923 = p__33922;
var map__33923__$1 = ((((!((map__33923 == null)))?((((map__33923.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33923.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33923):map__33923);
var file_msg = map__33923__$1;
var namespace = cljs.core.get.call(null,map__33923__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__33923,map__33923__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__33923,map__33923__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__33925){
var map__33926 = p__33925;
var map__33926__$1 = ((((!((map__33926 == null)))?((((map__33926.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33926.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33926):map__33926);
var file_msg = map__33926__$1;
var namespace = cljs.core.get.call(null,map__33926__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__33928){
var map__33929 = p__33928;
var map__33929__$1 = ((((!((map__33929 == null)))?((((map__33929.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33929.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33929):map__33929);
var file_msg = map__33929__$1;
var namespace = cljs.core.get.call(null,map__33929__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__28336__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__28336__auto__){
var or__28348__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
var or__28348__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28348__auto____$1)){
return or__28348__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__28336__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__33931,callback){
var map__33932 = p__33931;
var map__33932__$1 = ((((!((map__33932 == null)))?((((map__33932.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33932.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33932):map__33932);
var file_msg = map__33932__$1;
var request_url = cljs.core.get.call(null,map__33932__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__33932__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__30950__auto___33982 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___33982,out){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___33982,out){
return (function (state_33967){
var state_val_33968 = (state_33967[(1)]);
if((state_val_33968 === (1))){
var inst_33941 = cljs.core.seq.call(null,files);
var inst_33942 = cljs.core.first.call(null,inst_33941);
var inst_33943 = cljs.core.next.call(null,inst_33941);
var inst_33944 = files;
var state_33967__$1 = (function (){var statearr_33969 = state_33967;
(statearr_33969[(7)] = inst_33942);

(statearr_33969[(8)] = inst_33944);

(statearr_33969[(9)] = inst_33943);

return statearr_33969;
})();
var statearr_33970_33983 = state_33967__$1;
(statearr_33970_33983[(2)] = null);

(statearr_33970_33983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33968 === (2))){
var inst_33950 = (state_33967[(10)]);
var inst_33944 = (state_33967[(8)]);
var inst_33949 = cljs.core.seq.call(null,inst_33944);
var inst_33950__$1 = cljs.core.first.call(null,inst_33949);
var inst_33951 = cljs.core.next.call(null,inst_33949);
var inst_33952 = (inst_33950__$1 == null);
var inst_33953 = cljs.core.not.call(null,inst_33952);
var state_33967__$1 = (function (){var statearr_33971 = state_33967;
(statearr_33971[(10)] = inst_33950__$1);

(statearr_33971[(11)] = inst_33951);

return statearr_33971;
})();
if(inst_33953){
var statearr_33972_33984 = state_33967__$1;
(statearr_33972_33984[(1)] = (4));

} else {
var statearr_33973_33985 = state_33967__$1;
(statearr_33973_33985[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33968 === (3))){
var inst_33965 = (state_33967[(2)]);
var state_33967__$1 = state_33967;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33967__$1,inst_33965);
} else {
if((state_val_33968 === (4))){
var inst_33950 = (state_33967[(10)]);
var inst_33955 = figwheel.client.file_reloading.reload_js_file.call(null,inst_33950);
var state_33967__$1 = state_33967;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33967__$1,(7),inst_33955);
} else {
if((state_val_33968 === (5))){
var inst_33961 = cljs.core.async.close_BANG_.call(null,out);
var state_33967__$1 = state_33967;
var statearr_33974_33986 = state_33967__$1;
(statearr_33974_33986[(2)] = inst_33961);

(statearr_33974_33986[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33968 === (6))){
var inst_33963 = (state_33967[(2)]);
var state_33967__$1 = state_33967;
var statearr_33975_33987 = state_33967__$1;
(statearr_33975_33987[(2)] = inst_33963);

(statearr_33975_33987[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33968 === (7))){
var inst_33951 = (state_33967[(11)]);
var inst_33957 = (state_33967[(2)]);
var inst_33958 = cljs.core.async.put_BANG_.call(null,out,inst_33957);
var inst_33944 = inst_33951;
var state_33967__$1 = (function (){var statearr_33976 = state_33967;
(statearr_33976[(12)] = inst_33958);

(statearr_33976[(8)] = inst_33944);

return statearr_33976;
})();
var statearr_33977_33988 = state_33967__$1;
(statearr_33977_33988[(2)] = null);

(statearr_33977_33988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__30950__auto___33982,out))
;
return ((function (switch__30862__auto__,c__30950__auto___33982,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30863__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30863__auto____0 = (function (){
var statearr_33978 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33978[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30863__auto__);

(statearr_33978[(1)] = (1));

return statearr_33978;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30863__auto____1 = (function (state_33967){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_33967);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e33979){if((e33979 instanceof Object)){
var ex__30866__auto__ = e33979;
var statearr_33980_33989 = state_33967;
(statearr_33980_33989[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33967);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33979;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33990 = state_33967;
state_33967 = G__33990;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30863__auto__ = function(state_33967){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30863__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30863__auto____1.call(this,state_33967);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30863__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30863__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___33982,out))
})();
var state__30952__auto__ = (function (){var statearr_33981 = f__30951__auto__.call(null);
(statearr_33981[(6)] = c__30950__auto___33982);

return statearr_33981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___33982,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__33991,opts){
var map__33992 = p__33991;
var map__33992__$1 = ((((!((map__33992 == null)))?((((map__33992.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33992.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33992):map__33992);
var eval_body = cljs.core.get.call(null,map__33992__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__33992__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__28336__auto__ = eval_body;
if(cljs.core.truth_(and__28336__auto__)){
return typeof eval_body === 'string';
} else {
return and__28336__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e33994){var e = e33994;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__33995_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__33995_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__33996){
var vec__33997 = p__33996;
var k = cljs.core.nth.call(null,vec__33997,(0),null);
var v = cljs.core.nth.call(null,vec__33997,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__34000){
var vec__34001 = p__34000;
var k = cljs.core.nth.call(null,vec__34001,(0),null);
var v = cljs.core.nth.call(null,vec__34001,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__34007,p__34008){
var map__34009 = p__34007;
var map__34009__$1 = ((((!((map__34009 == null)))?((((map__34009.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34009.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34009):map__34009);
var opts = map__34009__$1;
var before_jsload = cljs.core.get.call(null,map__34009__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__34009__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__34009__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__34010 = p__34008;
var map__34010__$1 = ((((!((map__34010 == null)))?((((map__34010.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34010.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34010):map__34010);
var msg = map__34010__$1;
var files = cljs.core.get.call(null,map__34010__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__34010__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__34010__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__30950__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_34164){
var state_val_34165 = (state_34164[(1)]);
if((state_val_34165 === (7))){
var inst_34024 = (state_34164[(7)]);
var inst_34027 = (state_34164[(8)]);
var inst_34025 = (state_34164[(9)]);
var inst_34026 = (state_34164[(10)]);
var inst_34032 = cljs.core._nth.call(null,inst_34025,inst_34027);
var inst_34033 = figwheel.client.file_reloading.eval_body.call(null,inst_34032,opts);
var inst_34034 = (inst_34027 + (1));
var tmp34166 = inst_34024;
var tmp34167 = inst_34025;
var tmp34168 = inst_34026;
var inst_34024__$1 = tmp34166;
var inst_34025__$1 = tmp34167;
var inst_34026__$1 = tmp34168;
var inst_34027__$1 = inst_34034;
var state_34164__$1 = (function (){var statearr_34169 = state_34164;
(statearr_34169[(11)] = inst_34033);

(statearr_34169[(7)] = inst_34024__$1);

(statearr_34169[(8)] = inst_34027__$1);

(statearr_34169[(9)] = inst_34025__$1);

(statearr_34169[(10)] = inst_34026__$1);

return statearr_34169;
})();
var statearr_34170_34253 = state_34164__$1;
(statearr_34170_34253[(2)] = null);

(statearr_34170_34253[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (20))){
var inst_34067 = (state_34164[(12)]);
var inst_34075 = figwheel.client.file_reloading.sort_files.call(null,inst_34067);
var state_34164__$1 = state_34164;
var statearr_34171_34254 = state_34164__$1;
(statearr_34171_34254[(2)] = inst_34075);

(statearr_34171_34254[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (27))){
var state_34164__$1 = state_34164;
var statearr_34172_34255 = state_34164__$1;
(statearr_34172_34255[(2)] = null);

(statearr_34172_34255[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (1))){
var inst_34016 = (state_34164[(13)]);
var inst_34013 = before_jsload.call(null,files);
var inst_34014 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_34015 = (function (){return ((function (inst_34016,inst_34013,inst_34014,state_val_34165,c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__34004_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__34004_SHARP_);
});
;})(inst_34016,inst_34013,inst_34014,state_val_34165,c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34016__$1 = cljs.core.filter.call(null,inst_34015,files);
var inst_34017 = cljs.core.not_empty.call(null,inst_34016__$1);
var state_34164__$1 = (function (){var statearr_34173 = state_34164;
(statearr_34173[(13)] = inst_34016__$1);

(statearr_34173[(14)] = inst_34014);

(statearr_34173[(15)] = inst_34013);

return statearr_34173;
})();
if(cljs.core.truth_(inst_34017)){
var statearr_34174_34256 = state_34164__$1;
(statearr_34174_34256[(1)] = (2));

} else {
var statearr_34175_34257 = state_34164__$1;
(statearr_34175_34257[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (24))){
var state_34164__$1 = state_34164;
var statearr_34176_34258 = state_34164__$1;
(statearr_34176_34258[(2)] = null);

(statearr_34176_34258[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (39))){
var inst_34117 = (state_34164[(16)]);
var state_34164__$1 = state_34164;
var statearr_34177_34259 = state_34164__$1;
(statearr_34177_34259[(2)] = inst_34117);

(statearr_34177_34259[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (46))){
var inst_34159 = (state_34164[(2)]);
var state_34164__$1 = state_34164;
var statearr_34178_34260 = state_34164__$1;
(statearr_34178_34260[(2)] = inst_34159);

(statearr_34178_34260[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (4))){
var inst_34061 = (state_34164[(2)]);
var inst_34062 = cljs.core.List.EMPTY;
var inst_34063 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_34062);
var inst_34064 = (function (){return ((function (inst_34061,inst_34062,inst_34063,state_val_34165,c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__34005_SHARP_){
var and__28336__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__34005_SHARP_);
if(cljs.core.truth_(and__28336__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__34005_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__34005_SHARP_)));
} else {
return and__28336__auto__;
}
});
;})(inst_34061,inst_34062,inst_34063,state_val_34165,c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34065 = cljs.core.filter.call(null,inst_34064,files);
var inst_34066 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_34067 = cljs.core.concat.call(null,inst_34065,inst_34066);
var state_34164__$1 = (function (){var statearr_34179 = state_34164;
(statearr_34179[(17)] = inst_34063);

(statearr_34179[(18)] = inst_34061);

(statearr_34179[(12)] = inst_34067);

return statearr_34179;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_34180_34261 = state_34164__$1;
(statearr_34180_34261[(1)] = (16));

} else {
var statearr_34181_34262 = state_34164__$1;
(statearr_34181_34262[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (15))){
var inst_34051 = (state_34164[(2)]);
var state_34164__$1 = state_34164;
var statearr_34182_34263 = state_34164__$1;
(statearr_34182_34263[(2)] = inst_34051);

(statearr_34182_34263[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (21))){
var inst_34077 = (state_34164[(19)]);
var inst_34077__$1 = (state_34164[(2)]);
var inst_34078 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_34077__$1);
var state_34164__$1 = (function (){var statearr_34183 = state_34164;
(statearr_34183[(19)] = inst_34077__$1);

return statearr_34183;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34164__$1,(22),inst_34078);
} else {
if((state_val_34165 === (31))){
var inst_34162 = (state_34164[(2)]);
var state_34164__$1 = state_34164;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34164__$1,inst_34162);
} else {
if((state_val_34165 === (32))){
var inst_34117 = (state_34164[(16)]);
var inst_34122 = inst_34117.cljs$lang$protocol_mask$partition0$;
var inst_34123 = (inst_34122 & (64));
var inst_34124 = inst_34117.cljs$core$ISeq$;
var inst_34125 = (cljs.core.PROTOCOL_SENTINEL === inst_34124);
var inst_34126 = (inst_34123) || (inst_34125);
var state_34164__$1 = state_34164;
if(cljs.core.truth_(inst_34126)){
var statearr_34184_34264 = state_34164__$1;
(statearr_34184_34264[(1)] = (35));

} else {
var statearr_34185_34265 = state_34164__$1;
(statearr_34185_34265[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (40))){
var inst_34139 = (state_34164[(20)]);
var inst_34138 = (state_34164[(2)]);
var inst_34139__$1 = cljs.core.get.call(null,inst_34138,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_34140 = cljs.core.get.call(null,inst_34138,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_34141 = cljs.core.not_empty.call(null,inst_34139__$1);
var state_34164__$1 = (function (){var statearr_34186 = state_34164;
(statearr_34186[(20)] = inst_34139__$1);

(statearr_34186[(21)] = inst_34140);

return statearr_34186;
})();
if(cljs.core.truth_(inst_34141)){
var statearr_34187_34266 = state_34164__$1;
(statearr_34187_34266[(1)] = (41));

} else {
var statearr_34188_34267 = state_34164__$1;
(statearr_34188_34267[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (33))){
var state_34164__$1 = state_34164;
var statearr_34189_34268 = state_34164__$1;
(statearr_34189_34268[(2)] = false);

(statearr_34189_34268[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (13))){
var inst_34037 = (state_34164[(22)]);
var inst_34041 = cljs.core.chunk_first.call(null,inst_34037);
var inst_34042 = cljs.core.chunk_rest.call(null,inst_34037);
var inst_34043 = cljs.core.count.call(null,inst_34041);
var inst_34024 = inst_34042;
var inst_34025 = inst_34041;
var inst_34026 = inst_34043;
var inst_34027 = (0);
var state_34164__$1 = (function (){var statearr_34190 = state_34164;
(statearr_34190[(7)] = inst_34024);

(statearr_34190[(8)] = inst_34027);

(statearr_34190[(9)] = inst_34025);

(statearr_34190[(10)] = inst_34026);

return statearr_34190;
})();
var statearr_34191_34269 = state_34164__$1;
(statearr_34191_34269[(2)] = null);

(statearr_34191_34269[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (22))){
var inst_34081 = (state_34164[(23)]);
var inst_34077 = (state_34164[(19)]);
var inst_34080 = (state_34164[(24)]);
var inst_34085 = (state_34164[(25)]);
var inst_34080__$1 = (state_34164[(2)]);
var inst_34081__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_34080__$1);
var inst_34082 = (function (){var all_files = inst_34077;
var res_SINGLEQUOTE_ = inst_34080__$1;
var res = inst_34081__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_34081,inst_34077,inst_34080,inst_34085,inst_34080__$1,inst_34081__$1,state_val_34165,c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__34006_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__34006_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_34081,inst_34077,inst_34080,inst_34085,inst_34080__$1,inst_34081__$1,state_val_34165,c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34083 = cljs.core.filter.call(null,inst_34082,inst_34080__$1);
var inst_34084 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_34085__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_34084);
var inst_34086 = cljs.core.not_empty.call(null,inst_34085__$1);
var state_34164__$1 = (function (){var statearr_34192 = state_34164;
(statearr_34192[(26)] = inst_34083);

(statearr_34192[(23)] = inst_34081__$1);

(statearr_34192[(24)] = inst_34080__$1);

(statearr_34192[(25)] = inst_34085__$1);

return statearr_34192;
})();
if(cljs.core.truth_(inst_34086)){
var statearr_34193_34270 = state_34164__$1;
(statearr_34193_34270[(1)] = (23));

} else {
var statearr_34194_34271 = state_34164__$1;
(statearr_34194_34271[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (36))){
var state_34164__$1 = state_34164;
var statearr_34195_34272 = state_34164__$1;
(statearr_34195_34272[(2)] = false);

(statearr_34195_34272[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (41))){
var inst_34139 = (state_34164[(20)]);
var inst_34143 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_34144 = cljs.core.map.call(null,inst_34143,inst_34139);
var inst_34145 = cljs.core.pr_str.call(null,inst_34144);
var inst_34146 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34145)].join('');
var inst_34147 = figwheel.client.utils.log.call(null,inst_34146);
var state_34164__$1 = state_34164;
var statearr_34196_34273 = state_34164__$1;
(statearr_34196_34273[(2)] = inst_34147);

(statearr_34196_34273[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (43))){
var inst_34140 = (state_34164[(21)]);
var inst_34150 = (state_34164[(2)]);
var inst_34151 = cljs.core.not_empty.call(null,inst_34140);
var state_34164__$1 = (function (){var statearr_34197 = state_34164;
(statearr_34197[(27)] = inst_34150);

return statearr_34197;
})();
if(cljs.core.truth_(inst_34151)){
var statearr_34198_34274 = state_34164__$1;
(statearr_34198_34274[(1)] = (44));

} else {
var statearr_34199_34275 = state_34164__$1;
(statearr_34199_34275[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (29))){
var inst_34083 = (state_34164[(26)]);
var inst_34081 = (state_34164[(23)]);
var inst_34077 = (state_34164[(19)]);
var inst_34080 = (state_34164[(24)]);
var inst_34085 = (state_34164[(25)]);
var inst_34117 = (state_34164[(16)]);
var inst_34113 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_34116 = (function (){var all_files = inst_34077;
var res_SINGLEQUOTE_ = inst_34080;
var res = inst_34081;
var files_not_loaded = inst_34083;
var dependencies_that_loaded = inst_34085;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34083,inst_34081,inst_34077,inst_34080,inst_34085,inst_34117,inst_34113,state_val_34165,c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34115){
var map__34200 = p__34115;
var map__34200__$1 = ((((!((map__34200 == null)))?((((map__34200.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34200.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34200):map__34200);
var namespace = cljs.core.get.call(null,map__34200__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34083,inst_34081,inst_34077,inst_34080,inst_34085,inst_34117,inst_34113,state_val_34165,c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34117__$1 = cljs.core.group_by.call(null,inst_34116,inst_34083);
var inst_34119 = (inst_34117__$1 == null);
var inst_34120 = cljs.core.not.call(null,inst_34119);
var state_34164__$1 = (function (){var statearr_34202 = state_34164;
(statearr_34202[(28)] = inst_34113);

(statearr_34202[(16)] = inst_34117__$1);

return statearr_34202;
})();
if(inst_34120){
var statearr_34203_34276 = state_34164__$1;
(statearr_34203_34276[(1)] = (32));

} else {
var statearr_34204_34277 = state_34164__$1;
(statearr_34204_34277[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (44))){
var inst_34140 = (state_34164[(21)]);
var inst_34153 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_34140);
var inst_34154 = cljs.core.pr_str.call(null,inst_34153);
var inst_34155 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34154)].join('');
var inst_34156 = figwheel.client.utils.log.call(null,inst_34155);
var state_34164__$1 = state_34164;
var statearr_34205_34278 = state_34164__$1;
(statearr_34205_34278[(2)] = inst_34156);

(statearr_34205_34278[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (6))){
var inst_34058 = (state_34164[(2)]);
var state_34164__$1 = state_34164;
var statearr_34206_34279 = state_34164__$1;
(statearr_34206_34279[(2)] = inst_34058);

(statearr_34206_34279[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (28))){
var inst_34083 = (state_34164[(26)]);
var inst_34110 = (state_34164[(2)]);
var inst_34111 = cljs.core.not_empty.call(null,inst_34083);
var state_34164__$1 = (function (){var statearr_34207 = state_34164;
(statearr_34207[(29)] = inst_34110);

return statearr_34207;
})();
if(cljs.core.truth_(inst_34111)){
var statearr_34208_34280 = state_34164__$1;
(statearr_34208_34280[(1)] = (29));

} else {
var statearr_34209_34281 = state_34164__$1;
(statearr_34209_34281[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (25))){
var inst_34081 = (state_34164[(23)]);
var inst_34097 = (state_34164[(2)]);
var inst_34098 = cljs.core.not_empty.call(null,inst_34081);
var state_34164__$1 = (function (){var statearr_34210 = state_34164;
(statearr_34210[(30)] = inst_34097);

return statearr_34210;
})();
if(cljs.core.truth_(inst_34098)){
var statearr_34211_34282 = state_34164__$1;
(statearr_34211_34282[(1)] = (26));

} else {
var statearr_34212_34283 = state_34164__$1;
(statearr_34212_34283[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (34))){
var inst_34133 = (state_34164[(2)]);
var state_34164__$1 = state_34164;
if(cljs.core.truth_(inst_34133)){
var statearr_34213_34284 = state_34164__$1;
(statearr_34213_34284[(1)] = (38));

} else {
var statearr_34214_34285 = state_34164__$1;
(statearr_34214_34285[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (17))){
var state_34164__$1 = state_34164;
var statearr_34215_34286 = state_34164__$1;
(statearr_34215_34286[(2)] = recompile_dependents);

(statearr_34215_34286[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (3))){
var state_34164__$1 = state_34164;
var statearr_34216_34287 = state_34164__$1;
(statearr_34216_34287[(2)] = null);

(statearr_34216_34287[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (12))){
var inst_34054 = (state_34164[(2)]);
var state_34164__$1 = state_34164;
var statearr_34217_34288 = state_34164__$1;
(statearr_34217_34288[(2)] = inst_34054);

(statearr_34217_34288[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (2))){
var inst_34016 = (state_34164[(13)]);
var inst_34023 = cljs.core.seq.call(null,inst_34016);
var inst_34024 = inst_34023;
var inst_34025 = null;
var inst_34026 = (0);
var inst_34027 = (0);
var state_34164__$1 = (function (){var statearr_34218 = state_34164;
(statearr_34218[(7)] = inst_34024);

(statearr_34218[(8)] = inst_34027);

(statearr_34218[(9)] = inst_34025);

(statearr_34218[(10)] = inst_34026);

return statearr_34218;
})();
var statearr_34219_34289 = state_34164__$1;
(statearr_34219_34289[(2)] = null);

(statearr_34219_34289[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (23))){
var inst_34083 = (state_34164[(26)]);
var inst_34081 = (state_34164[(23)]);
var inst_34077 = (state_34164[(19)]);
var inst_34080 = (state_34164[(24)]);
var inst_34085 = (state_34164[(25)]);
var inst_34088 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_34090 = (function (){var all_files = inst_34077;
var res_SINGLEQUOTE_ = inst_34080;
var res = inst_34081;
var files_not_loaded = inst_34083;
var dependencies_that_loaded = inst_34085;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34083,inst_34081,inst_34077,inst_34080,inst_34085,inst_34088,state_val_34165,c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34089){
var map__34220 = p__34089;
var map__34220__$1 = ((((!((map__34220 == null)))?((((map__34220.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34220.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34220):map__34220);
var request_url = cljs.core.get.call(null,map__34220__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34083,inst_34081,inst_34077,inst_34080,inst_34085,inst_34088,state_val_34165,c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34091 = cljs.core.reverse.call(null,inst_34085);
var inst_34092 = cljs.core.map.call(null,inst_34090,inst_34091);
var inst_34093 = cljs.core.pr_str.call(null,inst_34092);
var inst_34094 = figwheel.client.utils.log.call(null,inst_34093);
var state_34164__$1 = (function (){var statearr_34222 = state_34164;
(statearr_34222[(31)] = inst_34088);

return statearr_34222;
})();
var statearr_34223_34290 = state_34164__$1;
(statearr_34223_34290[(2)] = inst_34094);

(statearr_34223_34290[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (35))){
var state_34164__$1 = state_34164;
var statearr_34224_34291 = state_34164__$1;
(statearr_34224_34291[(2)] = true);

(statearr_34224_34291[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (19))){
var inst_34067 = (state_34164[(12)]);
var inst_34073 = figwheel.client.file_reloading.expand_files.call(null,inst_34067);
var state_34164__$1 = state_34164;
var statearr_34225_34292 = state_34164__$1;
(statearr_34225_34292[(2)] = inst_34073);

(statearr_34225_34292[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (11))){
var state_34164__$1 = state_34164;
var statearr_34226_34293 = state_34164__$1;
(statearr_34226_34293[(2)] = null);

(statearr_34226_34293[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (9))){
var inst_34056 = (state_34164[(2)]);
var state_34164__$1 = state_34164;
var statearr_34227_34294 = state_34164__$1;
(statearr_34227_34294[(2)] = inst_34056);

(statearr_34227_34294[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (5))){
var inst_34027 = (state_34164[(8)]);
var inst_34026 = (state_34164[(10)]);
var inst_34029 = (inst_34027 < inst_34026);
var inst_34030 = inst_34029;
var state_34164__$1 = state_34164;
if(cljs.core.truth_(inst_34030)){
var statearr_34228_34295 = state_34164__$1;
(statearr_34228_34295[(1)] = (7));

} else {
var statearr_34229_34296 = state_34164__$1;
(statearr_34229_34296[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (14))){
var inst_34037 = (state_34164[(22)]);
var inst_34046 = cljs.core.first.call(null,inst_34037);
var inst_34047 = figwheel.client.file_reloading.eval_body.call(null,inst_34046,opts);
var inst_34048 = cljs.core.next.call(null,inst_34037);
var inst_34024 = inst_34048;
var inst_34025 = null;
var inst_34026 = (0);
var inst_34027 = (0);
var state_34164__$1 = (function (){var statearr_34230 = state_34164;
(statearr_34230[(32)] = inst_34047);

(statearr_34230[(7)] = inst_34024);

(statearr_34230[(8)] = inst_34027);

(statearr_34230[(9)] = inst_34025);

(statearr_34230[(10)] = inst_34026);

return statearr_34230;
})();
var statearr_34231_34297 = state_34164__$1;
(statearr_34231_34297[(2)] = null);

(statearr_34231_34297[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (45))){
var state_34164__$1 = state_34164;
var statearr_34232_34298 = state_34164__$1;
(statearr_34232_34298[(2)] = null);

(statearr_34232_34298[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (26))){
var inst_34083 = (state_34164[(26)]);
var inst_34081 = (state_34164[(23)]);
var inst_34077 = (state_34164[(19)]);
var inst_34080 = (state_34164[(24)]);
var inst_34085 = (state_34164[(25)]);
var inst_34100 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_34102 = (function (){var all_files = inst_34077;
var res_SINGLEQUOTE_ = inst_34080;
var res = inst_34081;
var files_not_loaded = inst_34083;
var dependencies_that_loaded = inst_34085;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34083,inst_34081,inst_34077,inst_34080,inst_34085,inst_34100,state_val_34165,c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34101){
var map__34233 = p__34101;
var map__34233__$1 = ((((!((map__34233 == null)))?((((map__34233.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34233.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34233):map__34233);
var namespace = cljs.core.get.call(null,map__34233__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__34233__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34083,inst_34081,inst_34077,inst_34080,inst_34085,inst_34100,state_val_34165,c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34103 = cljs.core.map.call(null,inst_34102,inst_34081);
var inst_34104 = cljs.core.pr_str.call(null,inst_34103);
var inst_34105 = figwheel.client.utils.log.call(null,inst_34104);
var inst_34106 = (function (){var all_files = inst_34077;
var res_SINGLEQUOTE_ = inst_34080;
var res = inst_34081;
var files_not_loaded = inst_34083;
var dependencies_that_loaded = inst_34085;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34083,inst_34081,inst_34077,inst_34080,inst_34085,inst_34100,inst_34102,inst_34103,inst_34104,inst_34105,state_val_34165,c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34083,inst_34081,inst_34077,inst_34080,inst_34085,inst_34100,inst_34102,inst_34103,inst_34104,inst_34105,state_val_34165,c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34107 = setTimeout(inst_34106,(10));
var state_34164__$1 = (function (){var statearr_34235 = state_34164;
(statearr_34235[(33)] = inst_34100);

(statearr_34235[(34)] = inst_34105);

return statearr_34235;
})();
var statearr_34236_34299 = state_34164__$1;
(statearr_34236_34299[(2)] = inst_34107);

(statearr_34236_34299[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (16))){
var state_34164__$1 = state_34164;
var statearr_34237_34300 = state_34164__$1;
(statearr_34237_34300[(2)] = reload_dependents);

(statearr_34237_34300[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (38))){
var inst_34117 = (state_34164[(16)]);
var inst_34135 = cljs.core.apply.call(null,cljs.core.hash_map,inst_34117);
var state_34164__$1 = state_34164;
var statearr_34238_34301 = state_34164__$1;
(statearr_34238_34301[(2)] = inst_34135);

(statearr_34238_34301[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (30))){
var state_34164__$1 = state_34164;
var statearr_34239_34302 = state_34164__$1;
(statearr_34239_34302[(2)] = null);

(statearr_34239_34302[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (10))){
var inst_34037 = (state_34164[(22)]);
var inst_34039 = cljs.core.chunked_seq_QMARK_.call(null,inst_34037);
var state_34164__$1 = state_34164;
if(inst_34039){
var statearr_34240_34303 = state_34164__$1;
(statearr_34240_34303[(1)] = (13));

} else {
var statearr_34241_34304 = state_34164__$1;
(statearr_34241_34304[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (18))){
var inst_34071 = (state_34164[(2)]);
var state_34164__$1 = state_34164;
if(cljs.core.truth_(inst_34071)){
var statearr_34242_34305 = state_34164__$1;
(statearr_34242_34305[(1)] = (19));

} else {
var statearr_34243_34306 = state_34164__$1;
(statearr_34243_34306[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (42))){
var state_34164__$1 = state_34164;
var statearr_34244_34307 = state_34164__$1;
(statearr_34244_34307[(2)] = null);

(statearr_34244_34307[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (37))){
var inst_34130 = (state_34164[(2)]);
var state_34164__$1 = state_34164;
var statearr_34245_34308 = state_34164__$1;
(statearr_34245_34308[(2)] = inst_34130);

(statearr_34245_34308[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34165 === (8))){
var inst_34024 = (state_34164[(7)]);
var inst_34037 = (state_34164[(22)]);
var inst_34037__$1 = cljs.core.seq.call(null,inst_34024);
var state_34164__$1 = (function (){var statearr_34246 = state_34164;
(statearr_34246[(22)] = inst_34037__$1);

return statearr_34246;
})();
if(inst_34037__$1){
var statearr_34247_34309 = state_34164__$1;
(statearr_34247_34309[(1)] = (10));

} else {
var statearr_34248_34310 = state_34164__$1;
(statearr_34248_34310[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__30862__auto__,c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30863__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30863__auto____0 = (function (){
var statearr_34249 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34249[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__30863__auto__);

(statearr_34249[(1)] = (1));

return statearr_34249;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30863__auto____1 = (function (state_34164){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_34164);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e34250){if((e34250 instanceof Object)){
var ex__30866__auto__ = e34250;
var statearr_34251_34311 = state_34164;
(statearr_34251_34311[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34164);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34250;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34312 = state_34164;
state_34164 = G__34312;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__30863__auto__ = function(state_34164){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30863__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30863__auto____1.call(this,state_34164);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__30863__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__30863__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__30952__auto__ = (function (){var statearr_34252 = f__30951__auto__.call(null);
(statearr_34252[(6)] = c__30950__auto__);

return statearr_34252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto__,map__34009,map__34009__$1,opts,before_jsload,on_jsload,reload_dependents,map__34010,map__34010__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__30950__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__34315,link){
var map__34316 = p__34315;
var map__34316__$1 = ((((!((map__34316 == null)))?((((map__34316.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34316.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34316):map__34316);
var file = cljs.core.get.call(null,map__34316__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__34316,map__34316__$1,file){
return (function (p1__34313_SHARP_,p2__34314_SHARP_){
if(cljs.core._EQ_.call(null,p1__34313_SHARP_,p2__34314_SHARP_)){
return p1__34313_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__34316,map__34316__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__34319){
var map__34320 = p__34319;
var map__34320__$1 = ((((!((map__34320 == null)))?((((map__34320.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34320.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34320):map__34320);
var match_length = cljs.core.get.call(null,map__34320__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__34320__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__34318_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__34318_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__34322_SHARP_,p2__34323_SHARP_){
return cljs.core.assoc.call(null,p1__34322_SHARP_,cljs.core.get.call(null,p2__34323_SHARP_,key),p2__34323_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__4655__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4655__auto__)){
var link = temp__4655__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__4655__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__4655__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_34324 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_34324);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_34324);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__34325,p__34326){
var map__34327 = p__34325;
var map__34327__$1 = ((((!((map__34327 == null)))?((((map__34327.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34327.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34327):map__34327);
var on_cssload = cljs.core.get.call(null,map__34327__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__34328 = p__34326;
var map__34328__$1 = ((((!((map__34328 == null)))?((((map__34328.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34328.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34328):map__34328);
var files_msg = map__34328__$1;
var files = cljs.core.get.call(null,map__34328__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__4657__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__4657__auto__)){
var f_datas = temp__4657__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1516617674922
